// This prevents pollution of the global namespace
var SQL = (function () {
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = (typeof Module !== 'undefined' ? Module : null) || {};

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_WEB = typeof window === 'object';
// Three configurations we can be running in:
// 1) We could be the application main() thread running in the main JS UI thread. (ENVIRONMENT_IS_WORKER == false and ENVIRONMENT_IS_PTHREAD == false)
// 2) We could be the application main() thread proxied to worker. (with Emscripten -s PROXY_TO_WORKER=1) (ENVIRONMENT_IS_WORKER == true, ENVIRONMENT_IS_PTHREAD == false)
// 3) We could be an application pthread running in a worker. (ENVIRONMENT_IS_WORKER == true and ENVIRONMENT_IS_PTHREAD == true)
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function' && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER;
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  if (!Module['print']) Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  if (!Module['printErr']) Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };

  var nodeFS = require('fs');
  var nodePath = require('path');

  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };

  Module['readBinary'] = function readBinary(filename) {
    var ret = Module['read'](filename, true);
    if (!ret.buffer) {
      ret = new Uint8Array(ret);
    }
    assert(ret.buffer);
    return ret;
  };

  Module['load'] = function load(f) {
    globalEval(read(f));
  };

  if (!Module['thisProgram']) {
    if (process['argv'].length > 1) {
      Module['thisProgram'] = process['argv'][1].replace(/\\/g, '/');
    } else {
      Module['thisProgram'] = 'unknown-program';
    }
  }

  Module['arguments'] = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  process['on']('uncaughtException', function(ex) {
    // suppress ExitStatus exceptions from showing an error
    if (!(ex instanceof ExitStatus)) {
      throw ex;
    }
  });

  Module['inspect'] = function () { return '[Emscripten Module object]'; };
}
else if (ENVIRONMENT_IS_SHELL) {
  if (!Module['print']) Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm

  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }

  Module['readBinary'] = function readBinary(f) {
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    var data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };

  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  if (typeof console !== 'undefined') {
    if (!Module['print']) Module['print'] = function print(x) {
      console.log(x);
    };
    if (!Module['printErr']) Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    if (!Module['print']) Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }

  if (ENVIRONMENT_IS_WORKER) {
    Module['load'] = importScripts;
  }

  if (typeof Module['setWindowTitle'] === 'undefined') {
    Module['setWindowTitle'] = function(title) { document.title = title };
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}

function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
if (!Module['thisProgram']) {
  Module['thisProgram'] = './this.program';
}

// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];

// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in: 
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at: 
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html

//========================================
// Runtime code shared with compiler
//========================================

var Runtime = {
  setTempRet0: function (value) {
    tempRet0 = value;
  },
  getTempRet0: function () {
    return tempRet0;
  },
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  STACK_ALIGN: 16,
  prepVararg: function (ptr, type) {
    if (type === 'double' || type === 'i64') {
      // move so the load is aligned
      if (ptr & 7) {
        assert((ptr & 7) === 4);
        ptr += 4;
      }
    } else {
      assert((ptr & 3) === 0);
    }
    return ptr;
  },
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (!vararg && (type == 'i64' || type == 'double')) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[sig]) {
      Runtime.funcWrappers[sig] = {};
    }
    var sigCache = Runtime.funcWrappers[sig];
    if (!sigCache[func]) {
      sigCache[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return sigCache[func];
  },
  getCompilerSetting: function (name) {
    throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work';
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+15)&-16); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+15)&-16); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+15)&-16); if (DYNAMICTOP >= TOTAL_MEMORY) { var success = enlargeMemory(); if (!success) { DYNAMICTOP = ret;  return 0; } }; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 16))*(quantum ? quantum : 16); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*4294967296.0)) : ((+((low>>>0)))+((+((high|0)))*4294967296.0))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}



Module["Runtime"] = Runtime;



//========================================
// Runtime essentials
//========================================

var __THREW__ = 0; // Used in checking for thrown exceptions.

var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  if (!func) {
    try {
      func = eval('_' + ident); // explicit lookup
    } catch(e) {}
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}

var cwrap, ccall;
(function(){
  var JSfuncs = {
    // Helpers for cwrap -- it can't refer to Runtime directly because it might
    // be renamed by closure, instead it calls JSfuncs['stackSave'].body to find
    // out what the minified function name is.
    'stackSave': function() {
      Runtime.stackSave()
    },
    'stackRestore': function() {
      Runtime.stackRestore()
    },
    // type conversion from js to c
    'arrayToC' : function(arr) {
      var ret = Runtime.stackAlloc(arr.length);
      writeArrayToMemory(arr, ret);
      return ret;
    },
    'stringToC' : function(str) {
      var ret = 0;
      if (str !== null && str !== undefined && str !== 0) { // null string
        // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
        ret = Runtime.stackAlloc((str.length << 2) + 1);
        writeStringToMemory(str, ret);
      }
      return ret;
    }
  };
  // For fast lookup of conversion functions
  var toC = {'string' : JSfuncs['stringToC'], 'array' : JSfuncs['arrayToC']};

  // C calling interface. 
  ccall = function ccallFunc(ident, returnType, argTypes, args, opts) {
    var func = getCFunc(ident);
    var cArgs = [];
    var stack = 0;
    if (args) {
      for (var i = 0; i < args.length; i++) {
        var converter = toC[argTypes[i]];
        if (converter) {
          if (stack === 0) stack = Runtime.stackSave();
          cArgs[i] = converter(args[i]);
        } else {
          cArgs[i] = args[i];
        }
      }
    }
    var ret = func.apply(null, cArgs);
    if (returnType === 'string') ret = Pointer_stringify(ret);
    if (stack !== 0) {
      if (opts && opts.async) {
        EmterpreterAsync.asyncFinalizers.push(function() {
          Runtime.stackRestore(stack);
        });
        return;
      }
      Runtime.stackRestore(stack);
    }
    return ret;
  }

  var sourceRegex = /^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;
  function parseJSFunc(jsfunc) {
    // Match the body and the return value of a javascript function source
    var parsed = jsfunc.toString().match(sourceRegex).slice(1);
    return {arguments : parsed[0], body : parsed[1], returnValue: parsed[2]}
  }
  var JSsource = {};
  for (var fun in JSfuncs) {
    if (JSfuncs.hasOwnProperty(fun)) {
      // Elements of toCsource are arrays of three items:
      // the code, and the return value
      JSsource[fun] = parseJSFunc(JSfuncs[fun]);
    }
  }

  
  cwrap = function cwrap(ident, returnType, argTypes) {
    argTypes = argTypes || [];
    var cfunc = getCFunc(ident);
    // When the function takes numbers and returns a number, we can just return
    // the original function
    var numericArgs = argTypes.every(function(type){ return type === 'number'});
    var numericRet = (returnType !== 'string');
    if ( numericRet && numericArgs) {
      return cfunc;
    }
    // Creation of the arguments list (["$1","$2",...,"$nargs"])
    var argNames = argTypes.map(function(x,i){return '$'+i});
    var funcstr = "(function(" + argNames.join(',') + ") {";
    var nargs = argTypes.length;
    if (!numericArgs) {
      // Generate the code needed to convert the arguments from javascript
      // values to pointers
      funcstr += 'var stack = ' + JSsource['stackSave'].body + ';';
      for (var i = 0; i < nargs; i++) {
        var arg = argNames[i], type = argTypes[i];
        if (type === 'number') continue;
        var convertCode = JSsource[type + 'ToC']; // [code, return]
        funcstr += 'var ' + convertCode.arguments + ' = ' + arg + ';';
        funcstr += convertCode.body + ';';
        funcstr += arg + '=' + convertCode.returnValue + ';';
      }
    }

    // When the code is compressed, the name of cfunc is not literally 'cfunc' anymore
    var cfuncname = parseJSFunc(function(){return cfunc}).returnValue;
    // Call the function
    funcstr += 'var ret = ' + cfuncname + '(' + argNames.join(',') + ');';
    if (!numericRet) { // Return type can only by 'string' or 'number'
      // Convert the result to a string
      var strgfy = parseJSFunc(function(){return Pointer_stringify}).returnValue;
      funcstr += 'ret = ' + strgfy + '(ret);';
    }
    if (!numericArgs) {
      // If we had a stack, restore it
      funcstr += JSsource['stackRestore'].body.replace('()', '(stack)') + ';';
    }
    funcstr += 'return ret})';
    return eval(funcstr);
  };
})();
Module["ccall"] = ccall;
Module["cwrap"] = cwrap;

function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[((ptr)>>0)]=value; break;
      case 'i8': HEAP8[((ptr)>>0)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math_min((+(Math_floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module["setValue"] = setValue;


function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module["getValue"] = getValue;

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module["ALLOC_NORMAL"] = ALLOC_NORMAL;
Module["ALLOC_STACK"] = ALLOC_STACK;
Module["ALLOC_STATIC"] = ALLOC_STATIC;
Module["ALLOC_DYNAMIC"] = ALLOC_DYNAMIC;
Module["ALLOC_NONE"] = ALLOC_NONE;

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)>>0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];

    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);

    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }

  return ret;
}
Module["allocate"] = allocate;

// Allocate memory during any stage of startup - static memory early on, dynamic memory later, malloc when ready
function getMemory(size) {
  if (!staticSealed) return Runtime.staticAlloc(size);
  if ((typeof _sbrk !== 'undefined' && !_sbrk.called) || !runtimeInitialized) return Runtime.dynamicAlloc(size);
  return _malloc(size);
}
Module["getMemory"] = getMemory;

function Pointer_stringify(ptr, /* optional */ length) {
  if (length === 0 || !ptr) return '';
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = 0;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))>>0)];
    hasUtf |= t;
    if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;

  var ret = '';

  if (hasUtf < 128) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  return Module['UTF8ToString'](ptr);
}
Module["Pointer_stringify"] = Pointer_stringify;

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAP8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}
Module["AsciiToString"] = AsciiToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}
Module["stringToAscii"] = stringToAscii;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

function UTF8ArrayToString(u8Array, idx) {
  var u0, u1, u2, u3, u4, u5;

  var str = '';
  while (1) {
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    u0 = u8Array[idx++];
    if (!u0) return str;
    if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
    u1 = u8Array[idx++] & 63;
    if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
    u2 = u8Array[idx++] & 63;
    if ((u0 & 0xF0) == 0xE0) {
      u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
    } else {
      u3 = u8Array[idx++] & 63;
      if ((u0 & 0xF8) == 0xF0) {
        u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | u3;
      } else {
        u4 = u8Array[idx++] & 63;
        if ((u0 & 0xFC) == 0xF8) {
          u0 = ((u0 & 3) << 24) | (u1 << 18) | (u2 << 12) | (u3 << 6) | u4;
        } else {
          u5 = u8Array[idx++] & 63;
          u0 = ((u0 & 1) << 30) | (u1 << 24) | (u2 << 18) | (u3 << 12) | (u4 << 6) | u5;
        }
      }
    }
    if (u0 < 0x10000) {
      str += String.fromCharCode(u0);
    } else {
      var ch = u0 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    }
  }
}
Module["UTF8ArrayToString"] = UTF8ArrayToString;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF8ToString(ptr) {
  return UTF8ArrayToString(HEAPU8,ptr);
}
Module["UTF8ToString"] = UTF8ToString;

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outU8Array: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      outU8Array[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      outU8Array[outIdx++] = 0xC0 | (u >> 6);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      outU8Array[outIdx++] = 0xE0 | (u >> 12);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x1FFFFF) {
      if (outIdx + 3 >= endIdx) break;
      outU8Array[outIdx++] = 0xF0 | (u >> 18);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x3FFFFFF) {
      if (outIdx + 4 >= endIdx) break;
      outU8Array[outIdx++] = 0xF8 | (u >> 24);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 5 >= endIdx) break;
      outU8Array[outIdx++] = 0xFC | (u >> 30);
      outU8Array[outIdx++] = 0x80 | ((u >> 24) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  outU8Array[outIdx] = 0;
  return outIdx - startIdx;
}
Module["stringToUTF8Array"] = stringToUTF8Array;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  return stringToUTF8Array(str, HEAPU8,outPtr, maxBytesToWrite);
}
Module["stringToUTF8"] = stringToUTF8;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      ++len;
    } else if (u <= 0x7FF) {
      len += 2;
    } else if (u <= 0xFFFF) {
      len += 3;
    } else if (u <= 0x1FFFFF) {
      len += 4;
    } else if (u <= 0x3FFFFFF) {
      len += 5;
    } else {
      len += 6;
    }
  }
  return len;
}
Module["lengthBytesUTF8"] = lengthBytesUTF8;

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF16ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module["UTF16ToString"] = UTF16ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)]=codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)]=0;
  return outPtr - startPtr;
}
Module["stringToUTF16"] = stringToUTF16;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}
Module["lengthBytesUTF16"] = lengthBytesUTF16;

function UTF32ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module["UTF32ToString"] = UTF32ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)]=codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)]=0;
  return outPtr - startPtr;
}
Module["stringToUTF32"] = stringToUTF32;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}
Module["lengthBytesUTF32"] = lengthBytesUTF32;

function demangle(func) {
  var hasLibcxxabi = !!Module['___cxa_demangle'];
  if (hasLibcxxabi) {
    try {
      var buf = _malloc(func.length);
      writeStringToMemory(func.substr(1), buf);
      var status = _malloc(4);
      var ret = Module['___cxa_demangle'](buf, 0, 0, status);
      if (getValue(status, 'i32') === 0 && ret) {
        return Pointer_stringify(ret);
      }
      // otherwise, libcxxabi failed, we can try ours which may return a partial result
    } catch(e) {
      // failure when using libcxxabi, we can try ours which may return a partial result
    } finally {
      if (buf) _free(buf);
      if (status) _free(status);
      if (ret) _free(ret);
    }
  }
  var i = 3;
  // params, etc.
  var basicTypes = {
    'v': 'void',
    'b': 'bool',
    'c': 'char',
    's': 'short',
    'i': 'int',
    'l': 'long',
    'f': 'float',
    'd': 'double',
    'w': 'wchar_t',
    'a': 'signed char',
    'h': 'unsigned char',
    't': 'unsigned short',
    'j': 'unsigned int',
    'm': 'unsigned long',
    'x': 'long long',
    'y': 'unsigned long long',
    'z': '...'
  };
  var subs = [];
  var first = true;
  function dump(x) {
    //return;
    if (x) Module.print(x);
    Module.print(func);
    var pre = '';
    for (var a = 0; a < i; a++) pre += ' ';
    Module.print (pre + '^');
  }
  function parseNested() {
    i++;
    if (func[i] === 'K') i++; // ignore const
    var parts = [];
    while (func[i] !== 'E') {
      if (func[i] === 'S') { // substitution
        i++;
        var next = func.indexOf('_', i);
        var num = func.substring(i, next) || 0;
        parts.push(subs[num] || '?');
        i = next+1;
        continue;
      }
      if (func[i] === 'C') { // constructor
        parts.push(parts[parts.length-1]);
        i += 2;
        continue;
      }
      var size = parseInt(func.substr(i));
      var pre = size.toString().length;
      if (!size || !pre) { i--; break; } // counter i++ below us
      var curr = func.substr(i + pre, size);
      parts.push(curr);
      subs.push(curr);
      i += pre + size;
    }
    i++; // skip E
    return parts;
  }
  function parse(rawList, limit, allowVoid) { // main parser
    limit = limit || Infinity;
    var ret = '', list = [];
    function flushList() {
      return '(' + list.join(', ') + ')';
    }
    var name;
    if (func[i] === 'N') {
      // namespaced N-E
      name = parseNested().join('::');
      limit--;
      if (limit === 0) return rawList ? [name] : name;
    } else {
      // not namespaced
      if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
      var size = parseInt(func.substr(i));
      if (size) {
        var pre = size.toString().length;
        name = func.substr(i + pre, size);
        i += pre + size;
      }
    }
    first = false;
    if (func[i] === 'I') {
      i++;
      var iList = parse(true);
      var iRet = parse(true, 1, true);
      ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
    } else {
      ret = name;
    }
    paramLoop: while (i < func.length && limit-- > 0) {
      //dump('paramLoop');
      var c = func[i++];
      if (c in basicTypes) {
        list.push(basicTypes[c]);
      } else {
        switch (c) {
          case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
          case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
          case 'L': { // literal
            i++; // skip basic type
            var end = func.indexOf('E', i);
            var size = end - i;
            list.push(func.substr(i, size));
            i += size + 2; // size + 'EE'
            break;
          }
          case 'A': { // array
            var size = parseInt(func.substr(i));
            i += size.toString().length;
            if (func[i] !== '_') throw '?';
            i++; // skip _
            list.push(parse(true, 1, true)[0] + ' [' + size + ']');
            break;
          }
          case 'E': break paramLoop;
          default: ret += '?' + c; break paramLoop;
        }
      }
    }
    if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
    if (rawList) {
      if (ret) {
        list.push(ret + '?');
      }
      return list;
    } else {
      return ret + flushList();
    }
  }
  var parsed = func;
  try {
    // Special-case the entry point, since its name differs from other name mangling.
    if (func == 'Object._main' || func == '_main') {
      return 'main()';
    }
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    parsed = parse();
  } catch(e) {
    parsed += '?';
  }
  if (parsed.indexOf('?') >= 0 && !hasLibcxxabi) {
    Runtime.warnOnce('warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling');
  }
  return parsed;
}

function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}

function jsStackTrace() {
  var err = new Error();
  if (!err.stack) {
    // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
    // so try that as a special-case.
    try {
      throw new Error(0);
    } catch(e) {
      err = e;
    }
    if (!err.stack) {
      return '(no stack trace available)';
    }
  }
  return err.stack.toString();
}

function stackTrace() {
  return demangleAll(jsStackTrace());
}
Module["stackTrace"] = stackTrace;

// Memory management

var PAGE_SIZE = 4096;

function alignMemoryPage(x) {
  if (x % 4096 > 0) {
    x += (4096 - (x % 4096));
  }
  return x;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk


function abortOnCannotGrowMemory() {
  abort('Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value ' + TOTAL_MEMORY + ', (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ');
}

function enlargeMemory() {
  abortOnCannotGrowMemory();
}


var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;

var totalMemory = 64*1024;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2*TOTAL_STACK) {
  if (totalMemory < 16*1024*1024) {
    totalMemory *= 2;
  } else {
    totalMemory += 16*1024*1024
  }
}
if (totalMemory !== TOTAL_MEMORY) {
  TOTAL_MEMORY = totalMemory;
}

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'JS engine does not provide full typed array support');

var buffer;



buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);


// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');

Module['HEAP'] = HEAP;
Module['buffer'] = buffer;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited

var runtimeInitialized = false;
var runtimeExited = false;


function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
  runtimeExited = true;
}

function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module["addOnPreRun"] = addOnPreRun;

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module["addOnInit"] = addOnInit;

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module["addOnPreMain"] = addOnPreMain;

function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module["addOnExit"] = addOnExit;

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module["addOnPostRun"] = addOnPostRun;

// Tools


function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}
Module["intArrayFromString"] = intArrayFromString;

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module["intArrayToString"] = intArrayToString;

function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))>>0)]=chr;
    i = i + 1;
  }
}
Module["writeStringToMemory"] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[((buffer++)>>0)]=array[i];
  }
}
Module["writeArrayToMemory"] = writeArrayToMemory;

function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    HEAP8[((buffer++)>>0)]=str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)]=0;
}
Module["writeAsciiToMemory"] = writeAsciiToMemory;

function unSign(value, bits, ignore) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}


// check for imul support, and also for correctness ( https://bugs.webkit.org/show_bug.cgi?id=126345 )
if (!Math['imul'] || Math['imul'](0xffffffff, 5) !== -5) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];


if (!Math['clz32']) Math['clz32'] = function(x) {
  x = x >>> 0;
  for (var i = 0; i < 32; i++) {
    if (x & (1 << (31 - i))) return i;
  }
  return 32;
};
Math.clz32 = Math['clz32']

var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
var Math_clz32 = Math.clz32;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled

function getUniqueRunDependency(id) {
  return id;
}

function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
}
Module["addRunDependency"] = addRunDependency;

function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module["removeRunDependency"] = removeRunDependency;

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data



var memoryInitializer = null;



// === Body ===

var ASM_CONSTS = [];




STATIC_BASE = 8;

STATICTOP = STATIC_BASE + 48688;
  /* global initializers */  __ATINIT__.push();
  

/* memory initializer */ allocate([1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,127,0,0,0,0,128,0,0,0,244,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,64,0,0,1,0,1,0,130,0,0,0,55,64,0,0,1,0,1,0,131,0,0,0,60,64,0,0,1,0,1,0,132,0,0,0,65,64,0,0,2,0,1,0,133,0,0,0,70,64,0,0,2,0,1,0,133,0,0,0,76,64,0,0,1,0,1,0,134,0,0,0,82,64,0,0,1,0,1,0,135,0,0,0,88,64,0,0,1,0,1,0,136,0,0,0,94,64,0,0,2,0,1,0,137,0,0,0,105,64,0,0,1,0,1,0,138,0,0,0,113,64,0,0,1,0,1,0,139,0,0,0,121,64,0,0,1,0,1,0,140,0,0,0,125,64,0,0,1,0,1,0,141,0,0,0,129,64,0,0,1,0,1,0,142,0,0,0,133,64,0,0,1,0,1,0,143,0,0,0,137,64,0,0,1,0,1,0,144,0,0,0,142,64,0,0,1,0,1,0,145,0,0,0,147,64,0,0,1,0,1,0,146,0,0,0,152,64,0,0,1,0,1,0,147,0,0,0,157,64,0,0,1,0,1,0,148,0,0,0,143,98,0,0,1,0,1,0,149,0,0,0,161,64,0,0,1,0,1,0,150,0,0,0,167,64,0,0,2,0,1,0,151,0,0,0,173,64,0,0,1,0,1,0,152,0,0,0,178,64,0,0,1,0,1,0,153,0,0,0,183,64,0,0,1,0,1,0,154,0,0,0,190,64,0,0,1,0,1,0,155,0,0,0,195,64,0,0,1,0,1,0,156,0,0,0,201,64,0,0,0,0,1,1,157,0,0,0,204,64,0,0,2,0,1,0,158,0,0,0,214,64,0,0,2,0,1,0,159,0,0,0,214,64,0,0,3,0,1,0,159,0,0,0,224,64,0,0,2,0,1,0,160,0,0,0,232,64,0,0,2,0,1,0,161,0,0,0,241,64,0,0,1,0,1,0,162,0,0,0,249,64,0,0,1,0,1,0,163,0,0,0,0,65,0,0,2,0,1,0,164,0,0,0,5,65,0,0,2,0,1,0,165,0,0,0,10,65,0,0,2,0,1,0,166,0,0,0,15,65,0,0,2,0,1,0,167,0,0,0,25,65,0,0,1,0,0,0,168,0,0,0,130,0,0,0,31,65,0,0,1,0,0,0,168,0,0,0,131,0,0,0,221,101,0,0,1,0,0,0,169,0,0,0,132,0,0,0,40,65,0,0,1,0,0,0,169,0,0,0,133,0,0,0,47,65,0,0,1,0,0,0,169,0,0,0,134,0,0,0,62,65,0,0,1,0,0,0,169,0,0,0,135,0,0,0,0,0,0,0,128,48,0,0,128,32,14,0,128,32,200,3,0,0,0,0,128,255,255,255,0,248,255,255,0,0,255,255,1,0,0,0,0,0,0,0,45,178,0,0,66,178,0,0,78,178,0,0,90,178,0,0,114,178,0,0,125,178,0,0,145,178,0,0,159,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,44,0,0,0,0,2,0,0,0,0,0,0,21,172,0,0,204,24,0,0,130,0,0,0,130,0,0,0,130,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,0,0,0,130,0,0,0,131,0,0,0,132,0,0,0,132,0,0,0,133,0,0,0,133,0,0,0,134,0,0,0,3,0,0,0,44,0,0,0,0,2,0,0,0,0,0,0,26,172,0,0,208,24,0,0,130,0,0,0,130,0,0,0,130,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,0,0,0,130,0,0,0,131,0,0,0,132,0,0,0,132,0,0,0,133,0,0,0,133,0,0,0,134,0,0,0,3,0,0,0,44,0,0,0,0,2,0,0,0,0,0,0,36,172,0,0,212,24,0,0,130,0,0,0,130,0,0,0,130,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,0,0,0,130,0,0,0,131,0,0,0,132,0,0,0,132,0,0,0,133,0,0,0,133,0,0,0,134,0,0,0,3,0,0,0,44,0,0,0,0,2,0,0,0,0,0,0,49,172,0,0,204,24,0,0,130,0,0,0,130,0,0,0,130,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,0,0,0,130,0,0,0,131,0,0,0,132,0,0,0,132,0,0,0,133,0,0,0,133,0,0,0,134,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,234,3,0,0,0,0,8,0,235,3,0,0,0,0,0,1,236,3,0,0,0,0,0,64,237,3,0,0,0,0,64,0,0,202,154,59,0,202,154,59,208,7,0,0,232,3,0,0,244,1,0,0,168,97,0,0,127,0,0,0,10,0,0,0,80,195,0,0,231,3,0,0,232,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,130,0,0,0,131,0,0,0,135,0,0,0,130,0,0,0,131,0,0,0,136,0,0,0,132,0,0,0,131,0,0,0,133,0,0,0,134,0,0,0,134,0,0,0,137,0,0,0,132,0,0,0,135,0,0,0,136,0,0,0,137,0,0,0,138,0,0,0,132,0,0,0,138,0,0,0,139,0,0,0,140,0,0,0,141,0,0,0,0,0,0,0,132,0,0,0,132,0,0,0,142,0,0,0,139,0,0,0,139,0,0,0,143,0,0,0,140,0,0,0,133,0,0,0,141,0,0,0,142,0,0,0,135,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,81,0,0,184,81,0,0,252,81,0,0,24,82,0,0,53,82,0,0,80,82,0,0,108,82,0,0,133,82,0,0,157,82,0,0,222,82,0,0,25,83,0,0,93,83,0,0,141,83,0,0,253,83,0,0,132,84,0,0,184,84,0,0,250,84,0,0,37,85,0,0,96,85,0,0,135,85,0,0,179,85,0,0,220,85,0,0,11,86,0,0,53,86,0,0,226,71,0,0,226,71,0,0,91,86,0,0,146,86,0,0,207,86,0,0,70,87,0,0,173,87,0,0,228,87,0,0,30,88,0,0,137,88,0,0,216,88,0,0,25,89,0,0,85,89,0,0,133,89,0,0,239,89,0,0,56,90,0,0,6,80,0,0,170,0,0,0,14,80,0,0,171,0,0,0,32,80,0,0,172,0,0,0,22,80,0,0,173,0,0,0,0,93,0,0,2,0,4,0,3,93,0,0,3,1,3,0,7,93,0,0,3,1,2,0,11,93,0,0,4,0,1,0,22,80,0,0,9,0,0,0,236,96,0,0,6,0,0,0,99,94,0,0,8,0,0,0,108,94,0,0,10,0,0,0,243,96,0,0,5,0,0,0,37,94,0,0,7,0,0,0,249,96,0,0,10,0,0,0,4,97,0,0,10,0,0,0,0,0,0,0,136,0,0,0,143,0,0,0,133,0,0,0,144,0,0,0,133,0,0,0,0,0,0,0,0,0,0,0,137,0,0,0,145,0,0,0,134,0,0,0,146,0,0,0,134,0,0,0,0,0,0,0,0,0,0,0,135,0,0,0,135,0,0,0,145,0,0,0,147,0,0,0,147,0,0,0,146,0,0,0,148,0,0,0,134,0,0,0,149,0,0,0,150,0,0,0,138,0,0,0,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,0,0,0,151,0,0,0,135,0,0,0,152,0,0,0,136,0,0,0,0,0,0,0,255,255,255,255,255,255,0,252,1,0,0,248,1,0,0,248,48,0,0,0,7,232,0,0,6,108,1,0,47,236,1,0,7,172,2,0,1,208,2,0,3,216,2,0,1,236,2,0,1,252,2,0,1,92,3,0,1,220,3,0,4,8,11,0,14,72,11,0,7,148,11,0,1,180,11,0,129,188,11,0,1,212,13,0,1,248,13,0,2,16,14,0,1,28,14,0,1,216,15,0,8,8,18,0,6,104,21,0,2,36,22,0,1,60,22,0,55,68,22,0,2,204,23,0,5,0,24,0,22,24,24,0,2,120,24,0,21,44,25,0,4,168,25,0,1,192,25,0,1,80,27,0,15,88,27,0,7,156,27,0,2,244,27,0,14,0,28,0,1,60,28,0,1,68,28,0,27,192,28,0,11,152,30,0,9,172,31,0,4,216,31,0,4,88,32,0,9,108,32,0,3,148,32,0,5,164,32,0,15,192,32,0,3,100,33,0,1,120,33,0,27,144,35,0,4,0,36,0,3,232,36,0,18,248,36,0,7,68,37,0,4,136,37,0,1,192,37,0,3,4,38,0,1,240,38,0,7,248,38,0,2,28,39,0,3,44,39,0,1,92,39,0,2,136,39,0,2,200,39,0,2,232,39,0,3,4,40,0,1,240,40,0,5,248,40,0,2,28,41,0,3,44,41,0,1,68,41,0,2,192,41,0,1,212,41,0,3,4,42,0,1,240,42,0,8,248,42,0,3,28,43,0,3,44,43,0,2,136,43,0,2,192,43,0,3,4,44,0,1,240,44,0,7,248,44,0,2,28,45,0,3,44,45,0,2,88,45,0,2,136,45,0,1,192,45,0,1,8,46,0,5,248,46,0,3,24,47,0,4,40,47,0,1,92,47,0,8,204,47,0,3,4,48,0,7,248,48,0,3,24,49,0,4,40,49,0,2,84,49,0,2,136,49,0,1,252,49,0,2,8,50,0,1,240,50,0,7,248,50,0,3,24,51,0,4,40,51,0,2,84,51,0,2,136,51,0,2,8,52,0,7,248,52,0,3,24,53,0,4,40,53,0,1,92,53,0,2,136,53,0,1,228,53,0,2,8,54,0,1,40,55,0,6,60,55,0,1,88,55,0,8,96,55,0,3,200,55,0,1,196,56,0,7,208,56,0,1,252,56,0,9,28,57,0,2,104,57,0,1,196,58,0,6,208,58,0,2,236,58,0,6,32,59,0,31,4,60,0,12,208,60,0,23,196,61,0,11,52,62,0,36,100,62,0,15,248,62,0,13,56,63,0,20,172,64,0,6,40,65,0,4,88,65,0,3,120,65,0,3,136,65,0,7,156,65,0,4,196,65,0,12,8,66,0,1,60,66,0,6,104,66,0,1,236,67,0,12,116,77,0,10,64,78,0,1,0,80,0,2,180,89,0,1,0,90,0,2,108,90,0,3,172,91,0,3,72,92,0,5,200,92,0,2,72,93,0,2,200,93,0,35,208,94,0,4,96,95,0,1,116,95,0,15,0,96,0,1,164,98,0,12,128,100,0,12,192,100,0,1,0,101,0,2,16,101,0,17,192,102,0,2,32,103,0,34,120,103,0,5,92,104,0,2,120,104,0,10,84,105,0,29,128,105,0,1,252,105,0,7,128,106,0,6,160,106,0,5,0,108,0,17,208,108,0,35,104,109,0,3,0,110,0,13,132,110,0,14,152,111,0,4,240,111,0,20,144,112,0,5,236,112,0,2,248,113,0,8,0,115,0,25,64,115,0,1,180,115,0,3,200,115,0,39,0,119,0,4,240,119,0,1,244,126,0,3,252,126,0,3,52,127,0,3,116,127,0,3,180,127,0,2,244,127,0,101,0,128,0,6,168,129,0,5,232,129,0,5,40,130,0,26,128,130,0,33,64,131,0,2,0,132,0,4,12,132,0,2,32,132,0,1,80,132,0,3,88,132,0,6,120,132,0,1,148,132,0,1,156,132,0,1,164,132,0,1,184,132,0,2,232,132,0,5,0,133,0,4,40,133,0,1,60,133,0,100,66,134,0,39,0,144,0,11,0,145,0,78,112,146,0,0,2,148,0,117,4,156,0,185,83,158,0,10,64,173,0,6,148,179,0,3,188,179,0,4,228,179,0,2,248,179,0,1,192,181,0,1,252,181,0,79,128,183,0,12,192,184,0,26,0,186,0,89,108,186,0,214,0,188,0,12,192,191,0,5,0,192,0,25,32,192,0,7,168,192,0,2,216,192,0,3,244,192,0,4,100,194,0,1,128,194,0,1,236,195,0,2,64,198,0,10,88,198,0,36,0,199,0,31,0,200,0,30,168,200,0,1,64,201,0,32,128,201,0,39,40,202,0,63,0,203,0,0,1,204,0,64,0,55,1,55,64,146,2,2,248,147,2,3,52,152,2,16,188,153,2,1,124,154,2,8,192,155,2,23,0,156,2,2,128,156,2,2,36,158,2,1,8,160,2,1,24,160,2,1,44,160,2,9,140,160,2,4,216,160,2,4,208,161,2,2,0,162,2,17,208,162,2,2,56,163,2,18,128,163,2,3,224,163,2,10,152,164,2,13,28,165,2,1,124,165,2,4,0,166,2,27,204,166,2,2,120,167,2,14,164,168,2,1,12,169,2,2,48,169,2,4,112,169,2,3,220,169,2,1,236,169,2,1,192,170,2,3,200,170,2,2,220,170,2,2,248,170,2,1,4,171,2,2,120,171,2,7,172,171,2,2,212,171,2,11,140,175,2,1,0,96,3,2,252,109,3,2,252,111,3,1,252,127,3,1,120,236,3,1,164,236,3,16,200,238,3,2,248,244,3,2,240,247,3,26,0,248,3,7,128,248,3,35,192,248,3,19,80,249,3,4,160,249,3,1,252,251,3,15,4,252,3,7,104,252,3,6,236,252,3,11,108,253,3,7,128,255,3,7,160,255,3,5,228,255,3,3,0,4,4,9,220,4,4,17,228,5,4,12,64,6,4,46,64,7,4,1,124,14,4,1,64,15,4,1,92,33,4,1,124,36,4,1,252,36,4,3,4,40,4,2,20,40,4,4,48,40,4,3,224,40,4,1,252,40,4,9,64,41,4,1,252,41,4,7,228,44,4,3,0,64,4,22,224,64,4,3,0,66,4,18,192,66,4,3,0,68,4,14,156,68,4,4,0,69,4,3,0,70,4,14,204,70,4,4,20,71,4,13,172,90,4,4,192,145,4,46,68,189,5,4,60,190,5,246,0,64,7,39,0,68,7,181,164,68,7,70,0,72,7,87,0,76,7,1,4,91,7,1,108,91,7,1,236,91,7,1,84,92,7,1,212,92,7,1,60,93,7,1,188,93,7,1,36,94,7,1,164,94,7,1,12,95,7,2,192,187,7,44,0,192,7,100,192,192,7,15,128,194,7,14,196,194,7,15,4,195,7,15,68,195,7,31,64,196,7,60,192,196,7,43,192,197,7,29,152,199,7,43,64,200,7,9,0,201,7,2,64,201,7,33,0,204,7,6,192,204,7,70,220,204,7,20,0,206,7,37,128,206,7,5,24,207,7,17,128,207,7,63,0,208,7,1,0,209,7,182,8,209,7,4,228,211,7,62,0,212,7,4,0,213,7,24,64,213,7,70,236,215,7,11,20,217,7,70,0,218,7,116,0,220,7,1,4,0,56,96,128,0,56,240,0,4,56,0,0,0,0,1,0,0,0,153,0,0,0,135,0,0,0,136,0,0,0,140,0,0,0,148,0,0,0,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,102,0,0,0,0,2,0,61,102,0,0,0,0,4,0,0,0,0,0,0,0,0,0,37,102,0,0,1,0,0,0,40,102,0,0,2,0,0,0,43,102,0,0,6,0,0,0,47,102,0,0,128,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,154,0,0,0,136,0,0,0,141,0,0,0,130,0,0,0,155,0,0,0,142,0,0,0,174,0,0,0,130,0,0,0,131,0,0,0,137,0,0,0,138,0,0,0,156,0,0,0,139,0,0,0,150,0,0,0,157,0,0,0,158,0,0,0,159,0,0,0,140,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,133,0,0,1,0,0,0,226,77,0,0,1,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,175,0,0,0,0,0,0,0,185,120,0,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,175,120,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,177,0,0,0,0,0,0,0,155,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,78,0,0,248,120,0,0,5,121,0,0,0,0,0,0,18,121,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,178,0,0,0,0,0,0,0,85,122,0,0,0,0,0,0,3,0,1,0,0,0,0,0,0,0,0,0,179,0,0,0,0,0,0,0,210,122,0,0,0,0,0,0,23,130,0,0,0,0,0,0,8,0,0,0,247,125,0,0,1,1,0,0,0,0,0,0,38,130,0,0,2,0,0,0,0,0,16,0,54,130,0,0,3,0,0,0,0,0,0,0,114,125,0,0,4,1,0,0,0,0,0,0,23,126,0,0,5,0,0,0,0,0,0,0,67,130,0,0,6,0,0,0,0,0,0,0,87,130,0,0,2,0,0,0,0,0,0,32,103,130,0,0,2,0,0,0,16,0,0,0,124,130,0,0,7,0,0,0,0,0,0,0,139,130,0,0,8,0,0,0,0,0,0,0,155,130,0,0,2,0,0,0,128,0,0,0,169,130,0,0,0,2,0,0,15,0,0,0,182,130,0,0,10,1,0,0,0,0,0,0,196,130,0,0,11,1,0,0,0,0,0,0,215,130,0,0,2,0,0,0,0,0,0,2,234,130,0,0,2,0,0,0,0,1,0,0,126,127,0,0,12,0,0,0,0,0,0,0,1,131,0,0,13,1,0,0,0,0,0,0,19,131,0,0,14,1,0,0,0,0,0,0,36,131,0,0,2,0,0,0,0,0,8,0,49,131,0,0,0,2,0,0,0,0,0,0,64,131,0,0,2,0,0,0,4,0,0,0,82,131,0,0,2,0,0,0,8,0,0,0,92,131,0,0,2,0,0,0,0,32,0,0,117,131,0,0,15,1,0,0,0,0,0,0,136,131,0,0,16,1,0,0,0,0,0,0,147,131,0,0,17,1,0,0,0,0,0,0,158,131,0,0,16,1,0,0,1,0,0,0,221,126,0,0,18,1,0,0,0,0,0,0,215,125,0,0,19,1,0,0,0,0,0,0,228,125,0,0,20,0,0,0,0,0,0,0,170,131,0,0,2,0,0,0,0,128,0,0,202,125,0,0,22,0,0,0,0,0,0,0,189,131,0,0,23,1,0,0,0,0,0,0,35,126,0,0,24,0,0,0,0,0,0,0,204,131,0,0,23,1,0,0,0,0,0,0,161,125,0,0,25,0,0,0,0,0,0,0,215,131,0,0,2,0,0,0,0,0,0,4,226,131,0,0,18,1,0,0,0,0,0,0,238,131,0,0,2,0,0,0,0,64,0,0,255,131,0,0,2,0,0,0,0,0,4,0,18,132,0,0,2,0,0,0,0,0,2,0,44,132,0,0,0,0,0,0,1,0,0,0,171,125,0,0,26,0,0,0,0,0,0,0,59,132,0,0,2,0,0,0,64,0,0,0,78,132,0,0,27,0,0,0,0,0,0,0,244,127,0,0,28,0,0,0,0,0,0,0,92,132,0,0,29,1,0,0,0,0,0,0,102,126,0,0,30,1,0,0,0,0,0,0,98,132,0,0,31,1,0,0,0,0,0,0,45,126,0,0,32,0,0,0,0,0,0,0,56,126,0,0,33,0,0,0,0,0,0,0,4,128,0,0,34,0,0,0,0,0,0,0,109,132,0,0,0,0,0,0,6,0,0,0,217,127,0,0,35,0,0,0,0,0,0,0,122,132,0,0,36,1,0,0,0,0,0,0,137,132,0,0,2,0,0,0,0,8,1,0,121,129,0,0,76,129,0,0,153,129,0,0,158,129,0,0,166,129,0,0,90,129,0,0,225,128,0,0,134,129,0,0,140,129,0,0,146,129,0,0,115,129,0,0,121,129,0,0,76,129,0,0,9,94,0,0,125,129,0,0,130,129,0,0,38,129,0,0,76,129,0,0,93,129,0,0,100,129,0,0,107,129,0,0,86,129,0,0,88,129,0,0,90,129,0,0,38,129,0,0,76,129,0,0,81,129,0,0,38,129,0,0,76,129,0,0,35,129,0,0,38,129,0,0,225,128,0,0,42,129,0,0,47,129,0,0,50,129,0,0,60,129,0,0,70,129,0,0,225,128,0,0,169,96,0,0,231,128,0,0,238,128,0,0,30,128,0,0,1,0,0,0,35,128,0,0,1,0,0,0,41,128,0,0,2,0,0,0,50,128,0,0,3,0,0,0,59,128,0,0,2,0,0,0,67,128,0,0,3,0,0,0,75,128,0,0,0,0,0,0,82,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,128,0,0,143,98,0,0,17,128,0,0,0,130,0,0,7,130,0,0,15,130,0,0,208,127,0,0,47,102,0,0,19,130,0,0,70,129,0,0,64,0,0,0,97,128,0,0,66,0,0,0,92,128,0,0,65,0,0,0,25,136,0,0,67,0,0,0,248,116,0,0,3,0,0,0,244,116,0,0,3,0,0,0,226,71,0,0,19,146,0,0,25,146,0,0,30,146,0,0,35,146,0,0,151,146,0,0,157,146,0,0,165,146,0,0,216,154,0,0,221,154,0,0,228,154,0,0,231,154,0,0,234,154,0,0,237,154,0,0,240,154,0,0,243,154,0,0,251,154,0,0,243,96,0,0,42,129,0,0,4,155,0,0,148,163,0,0,157,163,0,0,164,163,0,0,170,163,0,0,253,163,0,0,7,164,0,0,18,164,0,0,30,164,0,0,41,164,0,0,52,164,0,0,63,164,0,0,68,164,0,0,73,164,0,0,84,164,0,0,96,164,0,0,103,164,0,0,111,164,0,0,119,164,0,0,124,164,0,0,130,164,0,0,144,164,0,0,150,164,0,0,160,164,0,0,165,164,0,0,169,164,0,0,174,164,0,0,177,164,0,0,183,164,0,0,190,164,0,0,197,164,0,0,204,164,0,0,211,164,0,0,214,164,0,0,218,164,0,0,229,164,0,0,238,164,0,0,244,164,0,0,254,164,0,0,8,165,0,0,15,165,0,0,23,165,0,0,26,165,0,0,29,165,0,0,32,165,0,0,35,165,0,0,38,165,0,0,41,165,0,0,51,165,0,0,58,165,0,0,64,165,0,0,74,165,0,0,85,165,0,0,89,165,0,0,98,165,0,0,107,165,0,0,114,165,0,0,124,165,0,0,131,165,0,0,136,165,0,0,143,165,0,0,154,165,0,0,159,165,0,0,166,165,0,0,172,165,0,0,178,165,0,0,184,165,0,0,190,165,0,0,201,165,0,0,212,165,0,0,220,165,0,0,229,165,0,0,235,165,0,0,245,165,0,0,2,166,0,0,13,166,0,0,19,166,0,0,24,166,0,0,31,166,0,0,44,166,0,0,55,166,0,0,60,166,0,0,68,166,0,0,74,166,0,0,81,166,0,0,86,166,0,0,95,166,0,0,100,166,0,0,109,166,0,0,114,166,0,0,119,166,0,0,125,166,0,0,133,166,0,0,143,166,0,0,151,166,0,0,161,166,0,0,170,166,0,0,177,166,0,0,190,166,0,0,195,166,0,0,207,166,0,0,215,166,0,0,222,166,0,0,230,166,0,0,239,166,0,0,250,166,0,0,0,167,0,0,11,167,0,0,21,167,0,0,31,167,0,0,40,167,0,0,50,167,0,0,64,167,0,0,78,167,0,0,89,167,0,0,102,167,0,0,113,167,0,0,119,167,0,0,131,167,0,0,140,167,0,0,149,167,0,0,156,167,0,0,166,167,0,0,173,167,0,0,184,167,0,0,198,167,0,0,209,167,0,0,216,167,0,0,224,167,0,0,230,167,0,0,238,167,0,0,251,167,0,0,5,168,0,0,15,168,0,0,20,168,0,0,29,168,0,0,37,168,0,0,43,168,0,0,48,168,0,0,60,168,0,0,72,168,0,0,84,168,0,0,96,168,0,0,109,168,0,0,119,168,0,0,129,168,0,0,141,168,0,0,153,168,0,0,163,168,0,0,169,168,0,0,179,168,0,0,186,168,0,0,198,168,0,0,207,168,0,0,215,168,0,0,224,168,0,0,231,168,0,0,241,168,0,0,248,168,0,0,0,169,0,0,9,169,0,0,15,169,0,0,23,169,0,0,31,169,0,0,41,169,0,0,50,169,0,0,61,169,0,0,66,169,0,0,150,169,0,0,163,169,0,0,0,0,0,0,199,169,0,0,224,169,0,0,255,169,0,0,18,170,0,0,184,97,0,0,43,170,0,0,80,170,0,0,92,170,0,0,107,170,0,0,140,170,0,0,158,170,0,0,183,170,0,0,212,170,0,0,229,170,0,0,73,157,0,0,250,70,0,0,252,170,0,0,14,171,0,0,32,171,0,0,71,171,0,0,102,171,0,0,123,171,0,0,155,171,0,0,189,171,0,0,151,0,0,0,152,0,0,0,153,0,0,0,1,0,0,0,160,0,0,0,137,0,0,0,138,0,0,0,143,0,0,0,154,0,0,0,155,0,0,0,156,0,0,0,157,0,0,0,158,0,0,0,144,0,0,0,161,0,0,0,162,0,0,0,0,0,0,0,136,0,0,0,141,0,0,0,159,0,0,0,139,0,0,0,137,0,0,0,96,172,0,0,145,0,0,0,0,0,0,0,59,172,0,0,163,0,0,0,0,0,0,0,226,101,0,0,160,0,0,0,0,0,0,0,101,172,0,0,161,0,0,0,0,0,0,0,108,172,0,0,162,0,0,0,0,0,0,0,113,172,0,0,163,0,0,0,0,0,0,0,119,172,0,0,164,0,0,0,0,0,0,0,129,172,0,0,146,0,0,0,0,0,0,0,135,172,0,0,147,0,0,0,0,0,0,0,140,172,0,0,0,0,0,0,0,0,0,0,146,172,0,0,0,0,0,0,0,0,0,0,154,172,0,0,148,0,0,0,0,0,0,0,160,172,0,0,0,0,0,0,0,0,0,0,167,172,0,0,0,0,0,0,0,0,0,0,176,172,0,0,165,0,0,0,0,0,0,0,183,172,0,0,0,0,0,0,0,0,0,0,193,172,0,0,164,0,0,0,0,0,0,0,200,172,0,0,166,0,0,0,0,0,0,0,214,172,0,0,167,0,0,0,0,0,0,0,220,172,0,0,165,0,0,0,0,0,0,0,226,172,0,0,149,0,0,0,0,0,0,0,233,172,0,0,130,0,0,0,0,0,0,0,241,172,0,0,137,0,0,0,0,0,0,0,246,172,0,0,168,0,0,0,0,0,0,0,253,172,0,0,0,0,0,0,0,0,0,0,4,173,0,0,131,0,0,0,0,0,0,0,16,173,0,0,150,0,0,0,0,0,0,0,25,173,0,0,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,173,0,0,131,173,0,0,140,173,0,0,145,173,0,0,3,0,0,0,166,0,0,0,137,0,0,0,138,0,0,0,143,0,0,0,154,0,0,0,155,0,0,0,170,0,0,0,171,0,0,0,172,0,0,0,144,0,0,0,161,0,0,0,162,0,0,0,0,0,0,0,136,0,0,0,141,0,0,0,159,0,0,0,139,0,0,0,137,0,0,0,0,0,0,0,3,0,0,0,167,0,0,0,137,0,0,0,138,0,0,0,143,0,0,0,154,0,0,0,155,0,0,0,173,0,0,0,174,0,0,0,175,0,0,0,144,0,0,0,161,0,0,0,162,0,0,0,140,0,0,0,136,0,0,0,141,0,0,0,159,0,0,0,139,0,0,0,137,0,0,0,0,0,0,0,1,0,1,32,0,0,0,0,0,0,0,0,180,0,0,0,0,0,0,0,17,175,0,0,0,0,0,0,1,0,1,32,0,0,0,0,0,0,0,0,181,0,0,0,0,0,0,0,43,175,0,0,0,0,0,0,1,0,1,12,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,68,175,0,0,0,0,0,0,2,0,1,12,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,77,175,0,0,0,0,0,0,1,0,1,12,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,88,175,0,0,0,0,0,0,1,0,1,8,1,0,0,0,0,0,0,0,183,0,0,0,0,0,0,0,95,175,0,0,0,0,0,0,2,0,1,8,1,0,0,0,0,0,0,0,183,0,0,0,0,0,0,0,95,175,0,0,0,0,0,0,1,0,1,8,2,0,0,0,0,0,0,0,183,0,0,0,0,0,0,0,101,175,0,0,0,0,0,0,2,0,1,8,2,0,0,0,0,0,0,0,183,0,0,0,0,0,0,0,101,175,0,0,0,0,0,0,1,0,1,8,3,0,0,0,0,0,0,0,183,0,0,0,0,0,0,0,107,175,0,0,0,0,0,0,2,0,1,8,3,0,0,0,0,0,0,0,183,0,0,0,0,0,0,0,107,175,0,0,0,0,0,0,255,0,33,8,0,0,0,0,0,0,0,0,184,0,0,0,0,0,0,0,124,139,0,0,0,0,0,0,0,0,33,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,139,0,0,0,0,0,0,1,0,33,16,0,0,0,0,0,0,0,0,185,0,0,0,142,0,0,0,124,139,0,0,0,0,0,0,255,0,33,8,1,0,0,0,0,0,0,0,184,0,0,0,0,0,0,0,128,139,0,0,0,0,0,0,0,0,33,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,139,0,0,0,0,0,0,1,0,33,16,1,0,0,0,0,0,0,0,185,0,0,0,142,0,0,0,128,139,0,0,0,0,0,0,1,0,129,8,0,0,0,0,0,0,0,0,186,0,0,0,0,0,0,0,112,175,0,0,0,0,0,0,1,0,65,8,0,0,0,0,0,0,0,0,187,0,0,0,0,0,0,0,119,175,0,0,0,0,0,0,2,0,1,8,0,0,0,0,0,0,0,0,188,0,0,0,0,0,0,0,126,175,0,0,0,0,0,0,255,0,1,8,0,0,0,0,0,0,0,0,189,0,0,0,0,0,0,0,132,175,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,139,175,0,0,0,0,0,0,255,0,1,8,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,147,175,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,152,175,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,193,0,0,0,0,0,0,0,156,175,0,0,0,0,0,0,2,0,1,8,0,0,0,0,0,0,0,0,193,0,0,0,0,0,0,0,156,175,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,194,0,0,0,0,0,0,0,162,175,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,195,0,0,0,0,0,0,0,168,175,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,196,0,0,0,0,0,0,0,174,175,0,0,0,0,0,0,2,0,1,10,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,178,175,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,197,0,0,0,0,0,0,0,185,175,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,198,0,0,0,0,0,0,0,192,175,0,0,0,0,0,0,2,0,33,8,0,0,0,0,0,0,0,0,199,0,0,0,0,0,0,0,203,175,0,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,210,175,0,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0,0,0,200,0,0,0,0,0,0,0,225,175,0,0,0,0,0,0,2,0,1,8,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,242,175,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,202,0,0,0,0,0,0,0,253,175,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,203,0,0,0,0,0,0,0,3,176,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,204,0,0,0,0,0,0,0,21,176,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,205,0,0,0,0,0,0,0,29,176,0,0,0,0,0,0,3,0,1,8,0,0,0,0,0,0,0,0,206,0,0,0,0,0,0,0,43,176,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,207,0,0,0,0,0,0,0,51,176,0,0,0,0,0,0,2,0,1,8,0,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,60,176,0,0,0,0,0,0,3,0,1,8,0,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,60,176,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,209,0,0,0,143,0,0,0,67,176,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,209,0,0,0,144,0,0,0,71,176,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,209,0,0,0,145,0,0,0,77,176,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,210,0,0,0,146,0,0,0,81,176,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,210,0,0,0,146,0,0,0,81,176,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,211,0,0,0,147,0,0,0,87,176,0,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,211,0,0,0,147,0,0,0,87,176,0,0,0,0,0,0,2,0,13,8,218,71,0,0,0,0,0,0,212,0,0,0,0,0,0,0,97,128,0,0,0,0,0,0,2,0,5,8,222,71,0,0,0,0,0,0,212,0,0,0,0,0,0,0,92,128,0,0,0,0,0,0,3,0,5,8,222,71,0,0,0,0,0,0,212,0,0,0,0,0,0,0,92,128,0,0,0,0,0,0,1,0,1,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,176,0,0,0,0,0,0,0,0,1,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,176,0,0,0,0,0,0,255,0,1,10,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,100,176,0,0,0,0,0,0,101,138,0,0,255,0,1,32,0,0,0,0,0,0,0,0,213,0,0,0,0,0,0,0,165,176,0,0,0,0,0,0,255,0,1,32,0,0,0,0,0,0,0,0,214,0,0,0,0,0,0,0,175,176,0,0,0,0,0,0,255,0,1,32,0,0,0,0,0,0,0,0,215,0,0,0,0,0,0,0,180,176,0,0,0,0,0,0,255,0,1,32,0,0,0,0,0,0,0,0,216,0,0,0,0,0,0,0,185,176,0,0,0,0,0,0,255,0,1,32,0,0,0,0,0,0,0,0,217,0,0,0,0,0,0,0,194,176,0,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0,0,0,218,0,0,0,0,0,0,0,203,176,0,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0,0,0,219,0,0,0,0,0,0,0,216,176,0,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0,0,0,220,0,0,0,0,0,0,0,234,176,0,0,0,0,0,0,2,0,1,8,0,0,0,0,0,0,0,0,221,0,0,0,0,0,0,0,209,177,0,0,0,0,0,0,2,0,1,8,0,0,0,0,0,0,0,0,222,0,0,0,0,0,0,0,229,177,0,0,0,0,0,0,3,0,1,8,0,0,0,0,0,0,0,0,223,0,0,0,0,0,0,0,251,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,34,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,0,0,0,152,0,0,0,39,186,0,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,8,0,9,0,14,0,16,0,20,0,23,0,25,0,25,0,29,0,33,0,36,0,41,0,46,0,48,0,53,0,54,0,59,0,62,0,65,0,67,0,69,0,78,0,81,0,86,0,91,0,95,0,96,0,101,0,105,0,109,0,117,0,122,0,128,0,136,0,142,0,152,0,159,0,162,0,162,0,165,0,167,0,167,0,171,0,176,0,179,0,184,0,184,0,188,0,192,0,199,0,204,0,209,0,212,0,218,0,221,0,225,0,234,0,240,0,240,0,240,0,243,0,246,0,250,0,251,0,255,0,5,1,9,1,16,1,22,1,34,1,40,1,49,1,51,1,57,1,62,1,64,1,71,1,76,1,81,1,87,1,93,1,98,1,102,1,105,1,111,1,115,1,122,1,124,1,131,1,133,1,135,1,144,1,148,1,154,1,160,1,168,1,173,1,173,1,189,1,196,1,203,1,204,1,211,1,215,1,219,1,223,1,227,1,230,1,232,1,234,1,240,1,244,1,252,1,1,2,9,2,12,2,17,2,22,2,28,2,32,2,37,2,33,0,32,0,30,0,28,0,26,0,0,0,2,0,3,0,5,0,6,0,7,0,8,0,9,0,65,0,14,26,181,0,64,1,192,0,14,23,216,0,14,7,0,1,1,48,50,1,1,6,57,1,1,16,74,1,1,46,120,1,116,1,121,1,1,6,127,1,104,1,129,1,50,1,130,1,1,4,134,1,44,1,135,1,0,1,137,1,42,2,139,1,0,1,142,1,32,1,143,1,38,1,144,1,40,1,145,1,0,1,147,1,42,1,148,1,46,1,150,1,52,1,151,1,48,1,152,1,0,1,156,1,52,1,157,1,54,1,159,1,56,1,160,1,1,6,166,1,60,1,167,1,0,1,169,1,60,1,172,1,0,1,174,1,60,1,175,1,0,1,177,1,58,2,179,1,1,4,183,1,62,1,184,1,0,1,188,1,0,1,196,1,2,1,197,1,0,1,199,1,2,1,200,1,0,1,202,1,2,1,203,1,1,18,222,1,1,18,241,1,2,1,242,1,1,4,246,1,122,1,247,1,134,1,248,1,1,40,32,2,110,1,34,2,1,18,58,2,70,1,59,2,0,1,61,2,108,1,62,2,68,1,65,2,0,1,67,2,106,1,68,2,28,1,69,2,30,1,70,2,1,10,69,3,36,1,112,3,1,4,118,3,0,1,134,3,18,1,136,3,16,3,140,3,26,1,142,3,24,2,145,3,14,17,163,3,14,9,194,3,0,1,207,3,4,1,208,3,140,1,209,3,142,1,213,3,146,1,214,3,144,1,216,3,1,24,240,3,136,1,241,3,138,1,244,3,130,1,245,3,128,1,247,3,0,1,249,3,152,1,250,3,0,1,253,3,110,3,0,4,34,16,16,4,14,32,96,4,1,34,138,4,1,54,192,4,6,1,193,4,1,14,208,4,1,88,49,5,22,38,160,16,66,38,199,16,66,1,205,16,66,1,0,30,1,150,155,30,132,1,158,30,96,1,160,30,1,96,8,31,150,8,24,31,150,6,40,31,150,8,56,31,150,8,72,31,150,6,89,31,151,8,104,31,150,8,136,31,150,8,152,31,150,8,168,31], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
/* memory initializer */ allocate([150,8,184,31,150,2,186,31,126,2,188,31,148,1,190,31,100,1,200,31,124,4,204,31,148,1,216,31,150,2,218,31,120,2,232,31,150,2,234,31,118,2,236,31,152,1,248,31,112,2,250,31,114,2,252,31,148,1,38,33,98,1,42,33,92,1,43,33,94,1,50,33,12,1,96,33,8,16,131,33,0,1,182,36,10,26,0,44,22,47,96,44,0,1,98,44,88,1,99,44,102,1,100,44,90,1,103,44,1,6,109,44,84,1,110,44,86,1,111,44,80,1,112,44,82,1,114,44,0,1,117,44,0,1,126,44,78,2,128,44,1,100,235,44,1,4,242,44,0,1,64,166,1,46,128,166,1,24,34,167,1,14,50,167,1,62,121,167,1,4,125,167,76,1,126,167,1,10,139,167,0,1,141,167,74,1,144,167,1,4,160,167,1,10,170,167,72,1,33,255,14,26,1,0,2,0,8,0,15,0,16,0,26,0,28,0,32,0,37,0,38,0,40,0,48,0,63,0,64,0,69,0,71,0,79,0,80,0,116,0,202,0,203,0,205,0,206,0,207,0,209,0,210,0,211,0,213,0,214,0,217,0,218,0,219,0,7,3,96,28,40,42,43,42,188,90,216,90,252,117,193,213,225,213,226,213,228,213,3,214,9,214,25,214,65,223,186,223,65,226,163,226,251,227,26,241,244,254,61,255,93,255,126,255,128,255,130,255,135,255,144,255,156,255,159,255,170,255,182,255,192,255,196,255,198,255,200,255,202,255,208,255,226,255,231,255,234,255,241,255,247,255,248,255,249,255,0,0,5,7,56,7,67,7,99,7,136,7,148,7,203,7,232,7,248,7,12,8,62,8,120,8,158,8,216,8,238,8,40,9,79,9,168,9,184,9,212,9,36,10,108,10,172,10,222,10,26,11,78,11,138,11,168,11,184,11,212,11,8,13,128,13,112,14,128,14,144,14,160,14,56,15,72,15,88,15,128,15,168,15,200,15,10,16,42,16,74,16,106,16,138,16,170,16,200,16,216,16,248,16,56,17,72,17,120,17,152,17,4,24,54,24,120,24,136,24,216,24,29,25,105,25,129,25,8,240,28,240,94,240,152,240,202,240,248,240,8,241,30,241,88,241,104,241,140,241,184,241,218,241,252,241,46,242,170,242,202,242,248,242,10,243,94,243,156,243,234,243,14,244,72,244,90,244,120,244,140,244,176,244,184,244,192,244,200,244,10,245,204,245,74,246,106,246,42,247,158,247,227,255,54,2,13,2,93,2,207,255,51,1,235,1,21,2,156,2,179,1,89,2,132,2,148,0,235,2,18,3,27,3,163,1,20,3,59,3,22,3,198,1,64,3,121,3,239,1,56,3,222,2,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,15,3,130,3,137,3,139,3,143,3,153,3,165,3,168,3,172,3,175,3,179,3,182,3,184,3,187,3,190,3,194,3,197,3,201,3,206,3,209,3,212,3,216,3,220,3,223,3,225,3,228,3,231,3,234,3,238,3,242,3,250,3,253,3,0,4,4,4,8,4,10,4,12,4,16,4,22,4,27,4,34,4,38,4,40,4,44,4,46,4,49,4,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,76,0,87,3,36,0,11,2,235,0,160,1,9,3,76,0,22,1,76,0,76,0,76,0,76,0,188,2,188,2,188,2,150,0,220,0,147,0,217,0,221,0,50,1,50,1,99,2,5,0,23,2,44,2,108,2,208,2,104,3,129,3,116,0,96,3,93,1,11,4,13,4,148,1,23,4,224,3,127,255,26,4,236,1,62,0,210,2,111,3,48,4,65,4,40,3,42,4,70,4,71,4,72,4,73,4,74,4,8,3,30,4,45,2,57,0,112,0,131,0,167,0,182,0,250,0,16,1,35,1,75,1,108,1,182,1,241,1,5,2,79,2,141,2,178,2,227,2,7,3,30,3,124,3,140,3,156,3,162,3,247,3,39,4,45,4,99,1,16,3,31,3,213,3,77,4,158,3,127,4,137,4,138,4,177,3,140,4,142,4,104,4,144,4,147,4,148,4,250,0,149,4,150,4,151,4,154,4,156,4,157,4,64,4,78,4,95,4,100,4,102,4,158,3,107,4,115,4,164,4,116,4,105,4,106,4,79,4,120,4,83,4,155,4,132,4,143,4,158,4,110,4,98,4,159,4,160,4,126,4,129,4,173,4,87,4,178,4,179,4,99,4,101,4,181,4,123,4,161,4,145,4,162,4,166,4,167,4,168,4,189,4,193,4,169,4,133,4,172,4,174,4,170,4,196,4,194,4,121,4,130,4,205,4,207,4,209,4,192,4,213,4,216,4,217,4,220,4,198,4,203,4,206,4,208,4,199,4,211,4,212,4,221,4,225,4,202,4,226,4,230,4,175,4,177,4,180,4,183,4,185,4,187,4,190,4,188,4,231,4,184,4,235,4,191,4,232,4,176,4,182,4,236,4,223,4,237,4,239,4,238,4,242,4,254,4,2,5,12,5,14,5,17,5,18,5,19,5,20,5,197,4,200,4,204,4,8,5,11,5,252,4,253,4,15,5,69,1,64,3,95,1,57,3,5,0,203,0,203,0,51,3,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,45,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,209,3,209,3,56,3,56,3,58,3,179,3,98,1,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,82,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,95,0,95,0,94,0,94,0,94,0,93,0,95,1,23,3,209,3,209,3,69,1,94,0,94,0,94,0,93,0,95,1,24,3,75,0,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,194,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,53,5,155,0,155,0,2,0,69,1,19,1,146,0,132,0,52,0,52,0,93,0,95,1,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,101,0,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,190,3,190,3,69,1,12,1,172,1,157,1,155,1,61,0,240,2,240,2,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,60,0,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,14,1,73,1,17,1,21,1,191,3,192,3,250,0,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,45,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,170,3,46,5,186,2,194,2,46,5,242,0,156,1,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,91,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,170,3,47,5,128,1,187,2,47,5,125,1,123,1,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,189,2,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,92,0,89,0,178,0,65,3,168,3,117,1,188,2,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,119,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,252,4,179,3,98,1,50,3,168,3,227,2,227,2,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,230,0,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,201,3,227,0,92,0,89,0,178,0,117,1,44,1,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,153,3,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,193,1,191,1,191,1,191,1,147,0,225,2,225,2,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,40,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,163,1,231,0,190,3,190,3,158,0,25,0,166,1,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,194,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,187,1,224,0,224,0,164,1,190,3,190,3,194,3,69,1,52,0,52,0,191,3,192,3,176,0,159,1,78,0,99,0,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,123,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,172,1,162,1,42,1,191,3,192,3,194,3,81,0,99,0,88,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,205,2,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,75,3,75,3,87,3,90,3,228,3,62,1,87,1,123,1,100,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,194,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,69,1,94,1,94,1,94,1,4,1,121,1,84,1,161,3,52,0,52,0,90,0,74,3,74,3,86,3,89,3,78,3,78,3,97,0,97,0,98,0,98,0,98,0,98,0,105,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,86,0,189,1,79,3,3,0,179,4,105,1,104,1,122,1,88,1,45,3,190,3,190,3,20,5,86,0,189,1,217,2,3,0,212,0,169,0,31,1,149,1,26,1,148,1,199,0,232,0,194,1,44,1,248,2,83,0,84,0,24,1,245,0,6,1,109,1,251,0,85,0,96,1,96,1,92,0,89,0,178,0,83,0,84,0,242,0,156,1,52,0,52,0,192,1,85,0,96,1,96,1,246,0,191,3,192,3,194,0,199,1,158,2,146,1,143,1,142,1,192,1,243,0,221,0,114,0,178,1,8,3,105,1,194,1,141,1,12,1,235,2,224,0,224,0,132,0,132,0,198,0,64,3,178,1,196,1,195,1,172,1,171,1,51,3,159,1,222,2,201,2,132,0,52,0,52,0,64,3,12,1,196,1,195,1,222,2,194,0,51,3,107,1,146,1,143,1,142,1,194,1,247,4,247,4,23,0,190,3,190,3,86,0,189,1,141,1,3,0,228,0,173,1,127,3,56,3,56,3,58,3,59,3,19,0,203,0,208,2,52,0,52,0,172,1,152,1,183,1,249,0,56,3,56,3,58,3,59,3,19,0,229,0,147,1,153,0,83,0,84,0,249,2,177,0,241,0,194,1,209,2,85,0,96,1,96,1,120,0,157,0,191,3,192,3,58,0,209,3,153,1,99,1,74,1,192,1,12,1,172,1,174,1,64,1,22,3,32,0,32,0,86,0,189,1,8,3,3,0,85,1,98,0,98,0,98,0,98,0,178,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,64,3,120,0,196,1,195,1,45,3,119,3,51,3,83,0,84,0,209,3,45,3,132,0,154,1,152,3,85,0,96,1,96,1,132,0,151,1,21,3,190,3,190,3,92,0,89,0,178,0,149,3,192,1,6,1,114,1,5,1,82,0,146,3,80,0,6,1,114,1,5,1,8,3,56,3,56,3,58,3,59,3,19,0,166,3,178,1,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,64,3,74,0,196,1,195,1,190,3,190,3,51,3,191,3,192,3,120,0,92,0,89,0,178,0,177,3,2,0,150,3,197,3,12,1,1,0,208,3,76,0,189,1,250,2,3,0,196,2,133,3,133,3,131,1,190,3,190,3,245,2,151,3,115,1,228,2,10,3,244,2,1,1,56,3,56,3,58,3,59,3,19,0,161,1,229,2,194,1,24,0,191,3,192,3,83,0,84,0,113,1,190,3,190,3,177,0,226,0,85,0,96,1,96,1,117,3,59,1,58,1,57,1,215,0,55,1,10,0,10,0,171,2,192,1,93,1,92,1,191,3,192,3,141,3,9,3,157,0,120,0,190,3,190,3,81,1,8,3,160,1,199,2,54,1,194,1,178,1,194,1,65,1,194,1,23,3,103,0,200,0,175,0,194,1,191,3,192,3,140,3,64,3,24,3,196,1,195,1,9,0,9,0,51,3,10,0,10,0,52,0,52,0,51,0,51,0,180,0,204,2,248,0,10,0,10,0,171,0,170,0,167,0,83,1,191,3,192,3,247,0,216,3,190,2,190,2,194,1,203,2,233,0,174,2,214,3,121,3,215,3,182,0,146,3,56,3,56,3,58,3,59,3,19,0,183,0,0,1,167,1,132,0,181,0,138,1,10,0,10,0,121,3,123,3,237,2,190,3,190,3,149,3,12,1,217,3,198,0,217,3,93,1,92,1,169,1,159,1,43,1,49,3,64,3,70,1,57,3,120,0,76,1,133,0,51,3,12,1,98,0,98,0,98,0,98,0,91,0,96,0,96,0,96,0,96,0,95,0,95,0,94,0,94,0,94,0,93,0,95,1,157,0,42,3,115,1,126,1,103,1,191,3,192,3,102,1,12,1,194,1,150,3,112,1,68,1,56,3,56,3,58,3,194,1,197,2,194,1,8,1,124,1,121,3,194,1,109,3,234,2,253,0,151,3,255,0,177,1,36,0,36,0,234,0,194,1,234,0,120,0,13,1,37,0,37,0,12,0,12,0,78,1,16,1,27,0,27,0,194,1,74,1,118,0,194,1,162,0,230,2,24,1,194,1,38,0,38,0,194,1,217,3,100,1,217,3,194,1,197,2,186,4,194,1,132,0,194,1,39,0,39,0,194,1,40,0,40,0,194,1,106,1,41,0,41,0,194,1,42,0,42,0,194,1,254,0,28,0,28,0,194,1,29,0,29,0,31,0,31,0,194,1,43,0,43,0,194,1,44,0,44,0,194,1,202,2,45,0,45,0,194,1,11,0,11,0,255,2,194,1,46,0,46,0,194,1,12,1,194,1,105,0,105,0,194,1,47,0,47,0,194,1,48,0,48,0,194,1,237,0,33,0,33,0,194,1,172,0,49,0,49,0,194,1,50,0,50,0,34,0,34,0,18,1,122,0,122,0,194,1,123,0,123,0,194,1,124,0,124,0,194,1,130,3,56,0,56,0,194,1,129,3,35,0,35,0,194,1,11,1,194,1,49,3,194,1,49,3,106,0,106,0,194,1,53,0,53,0,129,1,107,0,107,0,194,1,49,3,108,0,108,0,49,3,194,1,104,0,104,0,121,0,121,0,119,0,119,0,194,1,117,0,112,0,112,0,194,1,20,1,194,1,225,0,111,0,111,0,194,1,218,2,194,1,109,0,109,0,194,1,161,2,162,2,163,2,144,3,110,0,110,0,61,1,230,3,55,0,55,0,57,0,57,0,180,2,75,1,54,0,54,0,26,0,26,0,184,2,30,0,30,0,61,1,169,3,197,0,196,0,195,0,79,1,25,1,80,1,190,1,75,1,233,2,177,2,180,1,184,1,188,1,120,0,72,0,130,1,223,0,175,0,89,1,245,2,165,3,20,0,30,1,63,1,244,2,47,3,116,1,118,1,202,0,202,0,202,0,7,1,139,1,29,1,74,0,208,0,21,0,184,2,207,2,206,2,116,3,120,0,120,0,120,0,120,0,120,0,242,2,22,1,60,3,77,0,74,0,214,2,215,2,17,3,15,3,112,3,202,0,231,3,208,0,126,3,125,3,126,3,125,3,182,2,48,3,251,2,116,0,6,3,10,5,175,1,176,1,46,1,231,3,134,1,47,1,55,3,185,2,179,2,168,2,159,0,33,1,167,2,116,3,169,2,184,3,35,1,218,0,37,1,7,0,60,1,60,3,173,0,37,3,3,1,108,1,252,0,143,3,120,1,201,2,39,1,179,1,52,1,168,0,187,3,225,3,135,0,144,1,222,3,28,1,114,3,113,3,205,0,160,3,158,3,59,0,77,1,62,0,144,0,156,0,130,0,72,0,34,3,110,1,111,1,137,1,137,0,185,0,189,0,160,0,139,0,127,1,67,0,128,3,140,0,141,0,142,0,148,0,133,1,44,3,7,3,10,1,219,0,190,0,154,0,135,1,145,3,108,3,15,1,150,1,191,0,66,1,170,2,221,2,192,0,86,1,220,2,212,2,219,2,199,2,211,2,165,1,193,2,71,0,67,1,6,0,204,0,3,3,32,1,79,0,41,1,90,1,4,3,192,2,34,1,27,1,191,2,2,3,36,1,38,1,199,3,239,0,1,3,102,0,94,3,182,1,170,1,240,0,168,1,186,1,73,0,213,0,176,2,238,0,22,0,197,1,185,3,214,0,217,0,216,0,198,1,165,2,164,2,159,2,241,2,125,0,115,0,235,0,126,0,157,2,97,1,166,0,127,0,244,0,179,0,101,1,50,1,48,1,49,1,51,1,113,0,124,3,71,1,122,3,43,3,72,1,134,0,128,0,136,0,138,0,231,2,2,1,139,3,184,0,143,0,129,0,142,3,186,0,63,0,64,0,145,0,187,0,138,3,65,0,8,0,66,0,13,0,188,0,202,0,131,3,9,1,149,0,219,3,132,1,150,0,173,2,161,0,136,1,29,1,193,0,23,1,140,1,151,0,145,1,68,0,14,0,15,0,210,2,69,0,236,0,63,3,131,0,62,3,92,3,70,0,239,2,16,0,158,1,243,2,4,0,174,0,220,0,222,0,16,3,201,0,152,0,11,3,77,0,74,0,17,0,18,0,107,3,93,3,91,3,148,3,96,3,147,3,207,0,206,0,174,3,163,0,181,1,180,3,175,3,164,0,209,0,234,3,185,1,95,3,165,0,210,0,61,3,183,2,87,0,56,1,211,0,12,5,11,5,53,1,16,16,2,16,40,0,87,2,136,3,100,2,248,2,248,2,248,2,248,2,213,2,237,255,16,0,16,0,100,0,248,2,248,2,248,2,248,2,248,2,248,2,248,2,108,3,108,3,61,2,30,2,207,2,88,2,61,0,137,0,172,0,207,0,242,0,21,1,56,1,91,1,126,1,161,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,203,1,238,1,203,1,17,2,52,2,52,2,193,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,88,3,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,248,2,219,3,234,2,234,2,234,2,234,2,234,2,33,3,23,0,32,0,181,3,193,3,211,3,196,3,196,3,181,3,73,0,113,0,205,255,31,6,31,6,31,6,24,2,24,2,24,2,99,0,99,0,45,3,45,3,155,2,205,0,240,0,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,76,1,243,3,166,1,166,1,113,0,30,0,30,0,30,0,30,0,30,0,30,0,31,6,31,6,31,6,154,3,162,255,162,255,128,1,101,2,60,3,164,1,253,2,36,3,83,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,160,2,160,2,160,2,181,3,181,3,145,2,181,3,181,3,181,3,238,255,181,3,181,3,226,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,181,3,4,3,94,4,200,2,200,2,200,2,42,3,45,0,1,3,195,4,109,4,162,1,162,1,57,2,109,4,57,2,62,3,95,2,151,2,114,3,162,1,181,2,114,3,114,3,80,3,128,4,41,4,6,5,214,4,214,4,7,5,7,5,214,4,64,5,61,5,215,4,73,5,73,5,73,5,73,5,214,4,75,5,215,4,64,5,61,5,61,5,215,4,214,4,75,5,219,4,32,5,214,4,214,4,75,5,90,5,214,4,75,5,214,4,75,5,90,5,10,5,10,5,10,5,47,5,90,5,10,5,21,5,10,5,47,5,10,5,10,5,4,5,24,5,4,5,24,5,4,5,24,5,4,5,24,5,214,4,111,5,214,4,0,5,90,5,86,5,86,5,90,5,22,5,28,5,30,5,29,5,215,4,134,5,136,5,151,5,151,5,160,5,160,5,160,5,160,5,31,6,31,6,31,6,31,6,31,6,31,6,31,6,31,6,7,2,210,3,186,4,201,4,104,0,117,4,165,4,222,4,224,4,227,4,228,4,229,4,233,4,234,4,249,4,235,3,163,4,13,5,146,4,248,4,255,4,210,4,1,5,152,4,153,4,9,5,218,4,171,4,173,5,175,5,157,5,39,5,167,5,89,5,172,5,166,5,168,5,72,5,65,5,84,5,74,5,178,5,76,5,183,5,199,5,79,5,77,5,169,5,170,5,174,5,176,5,92,5,148,5,141,5,87,5,209,5,207,5,192,5,108,5,78,5,137,5,190,5,139,5,133,5,149,5,115,5,200,5,203,5,206,5,114,5,122,5,208,5,150,5,210,5,211,5,205,5,212,5,152,5,177,5,214,5,158,5,171,5,215,5,217,5,218,5,216,5,127,5,222,5,223,5,225,5,219,5,126,5,226,5,227,5,195,5,188,5,231,5,130,5,229,5,193,5,230,5,194,5,236,5,229,5,237,5,238,5,239,5,240,5,241,5,243,5,252,5,244,5,246,5,245,5,247,5,248,5,250,5,251,5,247,5,253,5,255,5,0,6,1,6,3,6,156,5,161,5,162,5,163,5,7,6,11,6,13,6,1,5,247,4,247,4,247,4,179,4,179,4,179,4,179,4,247,4,72,4,101,4,101,4,231,4,52,5,52,5,52,5,52,5,52,5,52,5,178,4,52,5,52,5,52,5,52,5,247,4,76,4,107,4,52,5,52,5,52,5,52,5,180,4,181,4,52,5,52,5,52,5,230,4,232,4,117,4,116,4,115,4,114,4,213,4,88,4,112,4,105,4,109,4,180,4,174,4,175,4,173,4,177,4,181,4,52,5,108,4,143,4,158,4,142,4,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,152,4,157,4,164,4,156,4,153,4,145,4,144,4,146,4,147,4,52,5,251,3,43,4,52,5,52,5,52,5,148,4,52,5,149,4,161,4,160,4,159,4,238,4,9,5,8,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,1,5,247,4,1,4,1,4,52,5,247,4,247,4,247,4,247,4,247,4,247,4,243,4,76,4,67,4,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,235,4,233,4,52,5,194,4,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,72,4,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,3,5,52,5,208,4,72,4,72,4,72,4,74,4,56,4,66,4,236,3,111,4,90,4,90,4,41,5,111,4,41,5,18,4,23,5,15,4,101,4,90,4,176,4,101,4,101,4,73,4,66,4,52,5,44,5,81,4,81,4,43,5,43,5,81,4,122,4,46,4,111,4,52,4,52,4,52,4,52,4,81,4,248,3,111,4,122,4,46,4,46,4,111,4,81,4,248,3,212,4,38,5,81,4,81,4,248,3,187,4,81,4,248,3,81,4,248,3,187,4,44,4,44,4,44,4,33,4,187,4,44,4,18,4,44,4,33,4,44,4,44,4,94,4,89,4,94,4,89,4,94,4,89,4,94,4,89,4,81,4,182,4,81,4,52,5,187,4,191,4,191,4,187,4,106,4,95,4,104,4,102,4,111,4,254,3,36,4,6,5,6,5,2,5,2,5,2,5,2,5,49,5,49,5,243,4,18,5,18,5,20,4,20,4,18,5,52,5,52,5,52,5,52,5,52,5,52,5,13,5,52,5,196,4,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,128,4,52,5,232,3,240,4,52,5,52,5,239,4,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,40,5,52,5,52,5,52,5,52,5,52,5,52,5,211,4,210,4,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,58,4,52,5,52,5,52,5,27,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,103,4,52,5,96,4,52,5,52,5,31,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,52,5,249,4,52,5,52,5,52,5,248,4,52,5,52,5,52,5,52,5,52,5,130,4,52,5,129,4,133,4,52,5,242,3,52,5,16,0,2,2,12,0,14,0,24,0,31,0,59,0,15,39,97,99,111,115,0,97,115,105,110,0,97,116,97,110,0,97,116,110,50,0,97,116,97,110,50,0,97,99,111,115,104,0,97,115,105,110,104,0,97,116,97,110,104,0,100,105,102,102,101,114,101,110,99,101,0,100,101,103,114,101,101,115,0,114,97,100,105,97,110,115,0,99,111,115,0,115,105,110,0,116,97,110,0,99,111,116,0,99,111,115,104,0,115,105,110,104,0,116,97,110,104,0,99,111,116,104,0,101,120,112,0,108,111,103,49,48,0,112,111,119,101,114,0,115,105,103,110,0,115,113,114,116,0,115,113,117,97,114,101,0,99,101,105,108,0,102,108,111,111,114,0,112,105,0,114,101,112,108,105,99,97,116,101,0,99,104,97,114,105,110,100,101,120,0,108,101,102,116,115,116,114,0,114,105,103,104,116,115,116,114,0,114,101,118,101,114,115,101,0,112,114,111,112,101,114,0,112,97,100,108,0,112,97,100,114,0,112,97,100,99,0,115,116,114,102,105,108,116,101,114,0,115,116,100,101,118,0,118,97,114,105,97,110,99,101,0,109,101,100,105,97,110,0,108,111,119,101,114,95,113,117,97,114,116,105,108,101,0,117,112,112,101,114,95,113,117,97,114,116,105,108,101,0,102,111,114,32,110,111,100,101,0,97,114,103,99,61,61,49,0,99,47,101,120,116,101,110,115,105,111,110,45,102,117,110,99,116,105,111,110,115,46,99,0,97,99,111,115,70,117,110,99,0,97,115,105,110,70,117,110,99,0,97,116,97,110,70,117,110,99,0,97,114,103,99,61,61,50,0,97,116,110,50,70,117,110,99,0,97,99,111,115,104,70,117,110,99,0,97,115,105,110,104,70,117,110,99,0,97,116,97,110,104,70,117,110,99,0,100,105,102,102,101,114,101,110,99,101,70,117,110,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,0,1,2,0,0,2,2,4,5,5,0,1,2,6,2,3,0,1,0,2,0,2,0,0,0,0,0,0,0,1,2,3,0,1,2,0,0,2,2,4,5,5,0,1,2,6,2,3,0,1,0,2,0,2,0,0,0,0,0,63,48,48,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,114,97,100,50,100,101,103,70,117,110,99,0,100,101,103,50,114,97,100,70,117,110,99,0,99,111,115,70,117,110,99,0,115,105,110,70,117,110,99,0,116,97,110,70,117,110,99,0,99,111,116,70,117,110,99,0,99,111,115,104,70,117,110,99,0,115,105,110,104,70,117,110,99,0,116,97,110,104,70,117,110,99,0,99,111,116,104,70,117,110,99,0,101,120,112,70,117,110,99,0,108,111,103,70,117,110,99,0,108,111,103,49,48,70,117,110,99,0,112,111,119,101,114,70,117,110,99,0,115,105,103,110,70,117,110,99,0,115,113,114,116,70,117,110,99,0,115,113,117,97,114,101,70,117,110,99,0,99,101,105,108,70,117,110,99,0,102,108,111,111,114,70,117,110,99,0,100,111,109,97,105,110,32,101,114,114,111,114,0,97,114,103,99,61,61,51,32,124,124,97,114,103,99,61,61,50,0,99,104,97,114,105,110,100,101,120,70,117,110,99,0,108,101,102,116,70,117,110,99,0,114,105,103,104,116,70,117,110,99,0,49,61,61,97,114,103,99,0,114,101,118,101,114,115,101,70,117,110,99,0,112,114,111,112,101,114,70,117,110,99,0,112,97,100,108,70,117,110,99,0,122,60,61,122,84,101,114,109,0,115,113,108,105,116,101,51,85,116,102,56,67,104,97,114,76,101,110,0,112,97,100,114,70,117,110,99,0,112,97,100,99,70,117,110,99,0,115,116,114,102,105,108,116,101,114,70,117,110,99,0,118,97,114,105,97,110,99,101,83,116,101,112,0,109,111,100,101,83,116,101,112,0,51,46,49,53,46,49,0,83,81,76,73,84,69,95,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,3,5,1,5,1,5,2,5,2,5,1,5,1,5,4,5,3,5,1,5,1,5,2,5,2,5,1,5,1,5,115,116,114,105,110,103,32,111,114,32,98,108,111,98,32,116,111,111,32,98,105,103,0,99,97,110,110,111,116,32,111,112,101,110,32,118,105,114,116,117,97,108,32,116,97,98,108,101,58,32,37,115,0,99,97,110,110,111,116,32,111,112,101,110,32,116,97,98,108,101,32,119,105,116,104,111,117,116,32,114,111,119,105,100,58,32,37,115,0,99,97,110,110,111,116,32,111,112,101,110,32,118,105,101,119,58,32,37,115,0,110,111,32,115,117,99,104,32,99,111,108,117,109,110,58,32,34,37,115,34,0,102,111,114,101,105,103,110,32,107,101,121,0,105,110,100,101,120,101,100,0,99,97,110,110,111,116,32,111,112,101,110,32,37,115,32,99,111,108,117,109,110,32,102,111,114,32,119,114,105,116,105,110,103,0,151,0,0,0,104,0,0,0,82,1,1,0,33,0,7,1,96,0,0,1,87,1,0,0,13,0,2,0,111,0,0,0,75,0,0,0,37,115,0,42,63,91,0,37,95,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,128,0,64,0,0,128,0,0,0,0,0,0,0,0,12,12,12,12,12,12,12,12,12,12,0,0,0,0,0,0,0,10,10,10,10,10,10,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,128,0,0,0,64,128,42,42,42,42,42,42,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,0,0,0,0,0,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,1,4,3,2,5,116,114,105,103,103,101,114,0,116,101,109,112,0,50,48,49,54,45,49,49,45,48,52,32,49,50,58,48,56,58,52,57,32,49,49,51,54,56,54,51,99,55,54,53,55,54,49,49,48,101,55,49,48,100,100,53,100,54,57,97,98,54,98,102,51,52,55,99,54,53,101,51,54,0,117,110,107,110,111,119,110,32,100,97,116,97,98,97,115,101,58,32,37,115,0,73,78,84,69,71,69,82,0,57,50,50,51,51,55,50,48,51,54,56,53,52,55,55,53,56,48,0,2,2,3,5,3,4,5,4,0,1,2,4,9,12,15,20,111,110,111,102,102,97,108,115,101,121,101,115,116,114,117,101,120,116,114,97,102,117,108,108,0,1,0,0,0,1,1,3,2,76,105,117,74,0,45,0,0,82,0,77,0,0,42,12,78,15,0,116,85,54,112,0,19,0,0,121,0,119,115,0,22,93,0,9,0,0,70,71,0,69,6,0,48,90,102,0,118,101,0,0,44,0,103,24,0,17,0,122,53,23,0,5,110,25,96,0,0,124,106,60,123,57,28,55,0,91,0,100,26,0,99,0,0,0,95,92,97,88,109,14,39,108,0,81,0,18,89,111,32,0,120,80,113,62,46,84,0,0,94,40,59,114,0,36,0,0,29,0,86,63,64,0,20,61,0,56,7,7,5,4,6,4,5,3,6,7,3,6,6,7,7,3,8,2,6,5,4,4,3,10,4,6,11,6,2,7,5,5,9,6,9,9,7,10,10,4,6,2,3,9,4,2,6,5,7,4,5,7,6,6,5,6,5,5,9,7,7,3,2,4,4,7,3,6,4,7,6,12,6,9,4,6,5,4,7,6,5,6,7,5,4,5,6,5,7,3,7,13,2,2,4,6,6,8,5,17,12,7,8,8,2,4,4,4,4,4,2,2,6,5,8,5,8,3,5,5,6,4,9,3,82,69,73,78,68,69,88,69,68,69,83,67,65,80,69,65,67,72,69,67,75,69,89,66,69,70,79,82,69,73,71,78,79,82,69,71,69,88,80,76,65,73,78,83,84,69,65,68,68,65,84,65,66,65,83,69,76,69,67,84,65,66,76,69,70,84,72,69,78,68,69,70,69,82,82,65,66,76,69,76,83,69,88,67,69,80,84,82,65,78,83,65,67,84,73,79,78,65,84,85,82,65,76,84,69,82,65,73,83,69,88,67,76,85,83,73,86,69,88,73,83,84,83,65,86,69,80,79,73,78,84,69,82,83,69,67,84,82,73,71,71,69,82,69,70,69,82,69,78,67,69,83,67,79,78,83,84,82,65,73,78,84,79,70,70,83,69,84,69,77,80,79,82,65,82,89,85,78,73,81,85,69,82,89,87,73,84,72,79,85,84,69,82,69,76,69,65,83,69,65,84,84,65,67,72,65,86,73,78,71,82,79,85,80,68,65,84,69,66,69,71,73,78,78,69,82,69,67,85,82,83,73,86,69,66,69,84,87,69,69,78,79,84,78,85,76,76,73,75,69,67,65,83,67,65,68,69,76,69,84,69,67,65,83,69,67,79,76,76,65,84,69,67,82,69,65,84,69,67,85,82,82,69,78,84,95,68,65,84,69,68,69,84,65,67,72,73,77,77,69,68,73,65,84,69,74,79,73,78,83,69,82,84,77,65,84,67,72,80,76,65,78,65,76,89,90,69,80,82,65,71,77,65,66,79,82,84,86,65,76,85,69,83,86,73,82,84,85,65,76,73,77,73,84,87,72,69,78,87,72,69,82,69,78,65,77,69,65,70,84,69,82,69,80,76,65,67,69,65,78,68,69,70,65,85,76,84,65,85,84,79,73,78,67,82,69,77,69,78,84,67,65,83,84,67,79,76,85,77,78,67,79,77,77,73,84,67,79,78,70,76,73,67,84,67,82,79,83,83,67,85,82,82,69,78,84,95,84,73,77,69,83,84,65,77,80,82,73,77,65,82,89,68,69,70,69,82,82,69,68,73,83,84,73,78,67,84,68,82,79,80,70,65,73,76,70,82,79,77,70,85,76,76,71,76,79,66,89,73,70,73,83,78,85,76,76,79,82,68,69,82,69,83,84,82,73,67,84,82,73,71,72,84,82,79,76,76,66,65,67,75,82,79,87,85,78,73,79,78,85,83,73,78,71,86,65,67,85,85,77,86,73,69,87,73,78,73,84,73,65,76,76,89,93,56,140,70,42,72,104,79,63,113,74,75,31,2,77,142,69,24,119,16,98,138,11,112,139,117,6,58,107,98,141,83,9,20,13,118,88,105,99,131,81,80,111,21,21,27,103,3,25,92,98,14,62,128,127,110,5,98,84,32,35,19,78,101,31,65,61,109,136,53,17,95,71,8,124,108,30,4,60,82,57,120,91,129,137,130,94,59,85,28,100,106,15,33,66,67,10,68,98,95,95,102,7,121,29,114,73,123,98,31,64,18,34,126,86,98,12,87,115,125,89,90,76,116,0,0,0,0,4,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,13,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,21,0,0,0,0,0,50,0,43,3,47,0,0,0,0,30,0,58,0,38,0,0,0,1,66,0,0,67,0,41,0,0,0,0,0,0,49,65,0,0,0,0,31,52,16,34,10,0,0,0,0,0,0,0,11,72,79,0,8,0,104,98,0,107,0,87,0,75,51,0,27,37,73,83,0,35,68,0,0,95,82,79,87,73,68,95,0,82,79,87,73,68,0,79,73,68,0,115,113,108,105,116,101,95,116,101,109,112,95,109,97,115,116,101,114,0,115,113,108,105,116,101,95,109,97,115,116,101,114,0,49,0,67,82,69,65,84,69,32,84,65,66,76,69,32,120,40,116,121,112,101,32,116,101,120,116,44,110,97,109,101,32,116,101,120,116,44,116,98,108,95,110,97,109,101,32,116,101,120,116,44,114,111,111,116,112,97,103,101,32,105,110,116,101,103,101,114,44,115,113,108,32,116,101,120,116,41,0,97,116,116,97,99,104,101,100,32,100,97,116,97,98,97,115,101,115,32,109,117,115,116,32,117,115,101,32,116,104,101,32,115,97,109,101,32,116,101,120,116,32,101,110,99,111,100,105,110,103,32,97,115,32,109,97,105,110,32,100,97,116,97,98,97,115,101,0,117,110,115,117,112,112,111,114,116,101,100,32,102,105,108,101,32,102,111,114,109,97,116,0,83,69,76,69,67,84,32,110,97,109,101,44,32,114,111,111,116,112,97,103,101,44,32,115,113,108,32,70,82,79,77,32,34,37,119,34,46,37,115,32,79,82,68,69,82,32,66,89,32,114,111,119,105,100,0,115,113,108,105,116,101,95,115,116,97,116,49,0,83,69,76,69,67,84,32,116,98,108,44,105,100,120,44,115,116,97,116,32,70,82,79,77,32,37,81,46,115,113,108,105,116,101,95,115,116,97,116,49,0,117,110,111,114,100,101,114,101,100,42,0,115,122,61,91,48,45,57,93,42,0,110,111,115,107,105,112,115,99,97,110,42,0,99,114,101,97,116,101,32,0,105,110,118,97,108,105,100,32,114,111,111,116,112,97,103,101,0,63,0,109,97,108,102,111,114,109,101,100,32,100,97,116,97,98,97,115,101,32,115,99,104,101,109,97,32,40,37,115,41,0,37,122,32,45,32,37,115,0,100,97,116,97,98,97,115,101,32,99,111,114,114,117,112,116,105,111,110,0,37,115,32,97,116,32,108,105,110,101,32,37,100,32,111,102,32,91,37,46,49,48,115,93,0,117,110,97,98,108,101,32,116,111,32,100,101,108,101,116,101,47,109,111,100,105,102,121,32,99,111,108,108,97,116,105,111,110,32,115,101,113,117,101,110,99,101,32,100,117,101,32,116,111,32,97,99,116,105,118,101,32,115,116,97,116,101,109,101,110,116,115,0,78,79,67,65,83,69,0,82,84,82,73,77,0,109,97,105,110,0,115,105,109,112,108,101,0,112,111,114,116,101,114,0,117,110,105,99,111,100,101,54,49,0,102,116,115,51,95,116,111,107,101,110,105,122,101,114,0,115,110], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+10240);
/* memory initializer */ allocate([105,112,112,101,116,0,111,102,102,115,101,116,115,0,109,97,116,99,104,105,110,102,111,0,111,112,116,105,109,105,122,101,0,102,116,115,51,0,102,116,115,52,0,102,116,115,51,116,111,107,101,110,105,122,101,0,67,82,69,65,84,69,32,84,65,66,76,69,32,120,40,105,110,112,117,116,44,32,116,111,107,101,110,44,32,115,116,97,114,116,44,32,101,110,100,44,32,112,111,115,105,116,105,111,110,41,0,117,110,107,110,111,119,110,32,116,111,107,101,110,105,122,101,114,58,32,37,115,0,65,76,84,69,82,32,84,65,66,76,69,32,37,81,46,39,37,113,95,99,111,110,116,101,110,116,39,32,32,82,69,78,65,77,69,32,84,79,32,39,37,113,95,99,111,110,116,101,110,116,39,59,0,65,76,84,69,82,32,84,65,66,76,69,32,37,81,46,39,37,113,95,100,111,99,115,105,122,101,39,32,32,82,69,78,65,77,69,32,84,79,32,39,37,113,95,100,111,99,115,105,122,101,39,59,0,65,76,84,69,82,32,84,65,66,76,69,32,37,81,46,39,37,113,95,115,116,97,116,39,32,32,82,69,78,65,77,69,32,84,79,32,39,37,113,95,115,116,97,116,39,59,0,65,76,84,69,82,32,84,65,66,76,69,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,32,82,69,78,65,77,69,32,84,79,32,39,37,113,95,115,101,103,109,101,110,116,115,39,59,0,65,76,84,69,82,32,84,65,66,76,69,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,32,32,82,69,78,65,77,69,32,84,79,32,39,37,113,95,115,101,103,100,105,114,39,59,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,99,111,110,116,101,110,116,39,32,87,72,69,82,69,32,114,111,119,105,100,32,61,32,63,0,83,69,76,69,67,84,32,78,79,84,32,69,88,73,83,84,83,40,83,69,76,69,67,84,32,100,111,99,105,100,32,70,82,79,77,32,37,81,46,39,37,113,95,99,111,110,116,101,110,116,39,32,87,72,69,82,69,32,114,111,119,105,100,33,61,63,41,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,99,111,110,116,101,110,116,39,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,100,111,99,115,105,122,101,39,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,115,116,97,116,39,0,83,69,76,69,67,84,32,37,115,32,87,72,69,82,69,32,114,111,119,105,100,61,63,0,83,69,76,69,67,84,32,40,83,69,76,69,67,84,32,109,97,120,40,105,100,120,41,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,41,32,43,32,49,0,82,69,80,76,65,67,69,32,73,78,84,79,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,40,98,108,111,99,107,105,100,44,32,98,108,111,99,107,41,32,86,65,76,85,69,83,40,63,44,32,63,41,0,83,69,76,69,67,84,32,99,111,97,108,101,115,99,101,40,40,83,69,76,69,67,84,32,109,97,120,40,98,108,111,99,107,105,100,41,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,41,32,43,32,49,44,32,49,41,0,82,69,80,76,65,67,69,32,73,78,84,79,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,86,65,76,85,69,83,40,63,44,63,44,63,44,63,44,63,44,63,41,0,83,69,76,69,67,84,32,105,100,120,44,32,115,116,97,114,116,95,98,108,111,99,107,44,32,108,101,97,118,101,115,95,101,110,100,95,98,108,111,99,107,44,32,101,110,100,95,98,108,111,99,107,44,32,114,111,111,116,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,32,79,82,68,69,82,32,66,89,32,105,100,120,32,65,83,67,0,83,69,76,69,67,84,32,105,100,120,44,32,115,116,97,114,116,95,98,108,111,99,107,44,32,108,101,97,118,101,115,95,101,110,100,95,98,108,111,99,107,44,32,101,110,100,95,98,108,111,99,107,44,32,114,111,111,116,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,66,69,84,87,69,69,78,32,63,32,65,78,68,32,63,79,82,68,69,82,32,66,89,32,108,101,118,101,108,32,68,69,83,67,44,32,105,100,120,32,65,83,67,0,83,69,76,69,67,84,32,99,111,117,110,116,40,42,41,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,0,83,69,76,69,67,84,32,109,97,120,40,108,101,118,101,108,41,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,66,69,84,87,69,69,78,32,63,32,65,78,68,32,63,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,32,87,72,69,82,69,32,98,108,111,99,107,105,100,32,66,69,84,87,69,69,78,32,63,32,65,78,68,32,63,0,73,78,83,69,82,84,32,73,78,84,79,32,37,81,46,39,37,113,95,99,111,110,116,101,110,116,39,32,86,65,76,85,69,83,40,37,115,41,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,100,111,99,115,105,122,101,39,32,87,72,69,82,69,32,100,111,99,105,100,32,61,32,63,0,82,69,80,76,65,67,69,32,73,78,84,79,32,37,81,46,39,37,113,95,100,111,99,115,105,122,101,39,32,86,65,76,85,69,83,40,63,44,63,41,0,83,69,76,69,67,84,32,115,105,122,101,32,70,82,79,77,32,37,81,46,39,37,113,95,100,111,99,115,105,122,101,39,32,87,72,69,82,69,32,100,111,99,105,100,61,63,0,83,69,76,69,67,84,32,118,97,108,117,101,32,70,82,79,77,32,37,81,46,39,37,113,95,115,116,97,116,39,32,87,72,69,82,69,32,105,100,61,63,0,82,69,80,76,65,67,69,32,73,78,84,79,32,37,81,46,39,37,113,95,115,116,97,116,39,32,86,65,76,85,69,83,40,63,44,63,41,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,66,69,84,87,69,69,78,32,63,32,65,78,68,32,63,0,83,69,76,69,67,84,32,63,32,85,78,73,79,78,32,83,69,76,69,67,84,32,108,101,118,101,108,32,47,32,40,49,48,50,52,32,42,32,63,41,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,0,83,69,76,69,67,84,32,108,101,118,101,108,44,32,99,111,117,110,116,40,42,41,32,65,83,32,99,110,116,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,32,32,71,82,79,85,80,32,66,89,32,108,101,118,101,108,32,72,65,86,73,78,71,32,99,110,116,62,61,63,32,32,79,82,68,69,82,32,66,89,32,40,108,101,118,101,108,32,37,37,32,49,48,50,52,41,32,65,83,67,32,76,73,77,73,84,32,49,0,83,69,76,69,67,84,32,50,32,42,32,116,111,116,97,108,40,49,32,43,32,108,101,97,118,101,115,95,101,110,100,95,98,108,111,99,107,32,45,32,115,116,97,114,116,95,98,108,111,99,107,41,32,32,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,32,65,78,68,32,105,100,120,32,60,32,63,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,32,65,78,68,32,105,100,120,32,61,32,63,0,85,80,68,65,84,69,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,83,69,84,32,105,100,120,32,61,32,63,32,87,72,69,82,69,32,108,101,118,101,108,61,63,32,65,78,68,32,105,100,120,61,63,0,83,69,76,69,67,84,32,105,100,120,44,32,115,116,97,114,116,95,98,108,111,99,107,44,32,108,101,97,118,101,115,95,101,110,100,95,98,108,111,99,107,44,32,101,110,100,95,98,108,111,99,107,44,32,114,111,111,116,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,32,65,78,68,32,105,100,120,32,61,32,63,0,85,80,68,65,84,69,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,83,69,84,32,115,116,97,114,116,95,98,108,111,99,107,32,61,32,63,44,32,114,111,111,116,32,61,32,63,87,72,69,82,69,32,108,101,118,101,108,32,61,32,63,32,65,78,68,32,105,100,120,32,61,32,63,0,83,69,76,69,67,84,32,49,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,32,87,72,69,82,69,32,98,108,111,99,107,105,100,61,63,32,65,78,68,32,98,108,111,99,107,32,73,83,32,78,85,76,76,0,83,69,76,69,67,84,32,105,100,120,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,61,63,32,79,82,68,69,82,32,66,89,32,49,32,65,83,67,0,83,69,76,69,67,84,32,109,97,120,40,32,108,101,118,101,108,32,37,37,32,49,48,50,52,32,41,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,0,83,69,76,69,67,84,32,108,101,118,101,108,44,32,105,100,120,44,32,101,110,100,95,98,108,111,99,107,32,70,82,79,77,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,87,72,69,82,69,32,108,101,118,101,108,32,66,69,84,87,69,69,78,32,63,32,65,78,68,32,63,32,79,82,68,69,82,32,66,89,32,108,101,118,101,108,32,68,69,83,67,44,32,105,100,120,32,65,83,67,0,85,80,68,65,84,69,32,79,82,32,70,65,73,76,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,83,69,84,32,108,101,118,101,108,61,45,49,44,105,100,120,61,63,32,87,72,69,82,69,32,108,101,118,101,108,61,63,32,65,78,68,32,105,100,120,61,63,0,85,80,68,65,84,69,32,79,82,32,70,65,73,76,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,32,83,69,84,32,108,101,118,101,108,61,63,32,87,72,69,82,69,32,108,101,118,101,108,61,45,49,0,37,108,108,100,32,37,108,108,100,0,37,115,95,115,101,103,109,101,110,116,115,0,98,108,111,99,107,0,83,69,76,69,67,84,32,49,32,70,82,79,77,32,37,81,46,115,113,108,105,116,101,95,109,97,115,116,101,114,32,87,72,69,82,69,32,116,98,108,95,110,97,109,101,61,39,37,113,95,115,116,97,116,39,0,112,99,120,0,83,69,76,69,67,84,32,37,115,32,87,72,69,82,69,32,114,111,119,105,100,32,61,32,63,0,117,110,114,101,99,111,103,110,105,122,101,100,32,109,97,116,99,104,105,110,102,111,32,114,101,113,117,101,115,116,58,32,37,99,0,105,108,108,101,103,97,108,32,102,105,114,115,116,32,97,114,103,117,109,101,110,116,32,116,111,32,37,115,0,73,110,100,101,120,32,111,112,116,105,109,105,122,101,100,0,73,110,100,101,120,32,97,108,114,101,97,100,121,32,111,112,116,105,109,97,108,0,83,65,86,69,80,79,73,78,84,32,102,116,115,51,0,82,69,76,69,65,83,69,32,102,116,115,51,0,82,79,76,76,66,65,67,75,32,84,79,32,102,116,115,51,0,37,100,32,37,100,32,37,100,32,37,100,32,0,60,98,62,0,60,47,98,62,0,60,98,62,46,46,46,60,47,98,62,0,119,114,111,110,103,32,110,117,109,98,101,114,32,111,102,32,97,114,103,117,109,101,110,116,115,32,116,111,32,102,117,110,99,116,105,111,110,32,115,110,105,112,112,101,116,40,41,0,114,101,98,117,105,108,100,0,105,110,116,101,103,114,105,116,121,45,99,104,101,99,107,0,109,101,114,103,101,61,0,97,117,116,111,109,101,114,103,101,61,0,67,82,69,65,84,69,32,84,65,66,76,69,32,73,70,32,78,79,84,32,69,88,73,83,84,83,32,37,81,46,39,37,113,95,115,116,97,116,39,40,105,100,32,73,78,84,69,71,69,82,32,80,82,73,77,65,82,89,32,75,69,89,44,32,118,97,108,117,101,32,66,76,79,66,41,59,0,83,69,76,69,67,84,32,37,115,0,68,69,83,67,0,65,83,67,0,83,69,76,69,67,84,32,37,115,32,87,72,69,82,69,32,114,111,119,105,100,32,66,69,84,87,69,69,78,32,37,108,108,100,32,65,78,68,32,37,108,108,100,32,79,82,68,69,82,32,66,89,32,114,111,119,105,100,32,37,115,0,83,69,76,69,67,84,32,37,115,32,79,82,68,69,82,32,66,89,32,114,111,119,105,100,32,37,115,0,70,84,83,32,101,120,112,114,101,115,115,105,111,110,32,116,114,101,101,32,105,115,32,116,111,111,32,108,97,114,103,101,32,40,109,97,120,105,109,117,109,32,100,101,112,116,104,32,37,100,41,0,109,97,108,102,111,114,109,101,100,32,77,65,84,67,72,32,101,120,112,114,101,115,115,105,111,110,58,32,91,37,115,93,0,79,82,0,65,78,68,0,78,79,84,0,78,69,65,82,0,68,82,79,80,32,84,65,66,76,69,32,73,70,32,69,88,73,83,84,83,32,37,81,46,39,37,113,95,99,111,110,116,101,110,116,39,0,68,82,79,80,32,84,65,66,76,69,32,73,70,32,69,88,73,83,84,83,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,0,68,82,79,80,32,84,65,66,76,69,32,73,70,32,69,88,73,83,84,83,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,0,68,82,79,80,32,84,65,66,76,69,32,73,70,32,69,88,73,83,84,83,32,37,81,46,39,37,113,95,100,111,99,115,105,122,101,39,0,68,82,79,80,32,84,65,66,76,69,32,73,70,32,69,88,73,83,84,83,32,37,81,46,39,37,113,95,115,116,97,116,39,0,116,111,107,101,110,105,122,101,0,117,110,114,101,99,111,103,110,105,122,101,100,32,112,97,114,97,109,101,116,101,114,58,32,37,115,0,117,110,114,101,99,111,103,110,105,122,101,100,32,109,97,116,99,104,105,110,102,111,58,32,37,115,0,97,115,99,0,100,101,115,99,0,117,110,114,101,99,111,103,110,105,122,101,100,32,111,114,100,101,114,58,32,37,115,0,99,111,110,116,101,110,116,0,101,114,114,111,114,32,112,97,114,115,105,110,103,32,112,114,101,102,105,120,32,112,97,114,97,109,101,116,101,114,58,32,37,115,0,110,111,32,115,117,99,104,32,99,111,108,117,109,110,58,32,37,115,0,99,111,109,112,114,101,115,115,0,117,110,99,111,109,112,114,101,115,115,0,109,105,115,115,105,110,103,32,37,115,32,112,97,114,97,109,101,116,101,114,32,105,110,32,102,116,115,52,32,99,111,110,115,116,114,117,99,116,111,114,0,95,95,108,97,110,103,105,100,0,37,81,44,32,0,37,122,37,81,44,32,0,67,82,69,65,84,69,32,84,65,66,76,69,32,120,40,37,115,32,37,81,32,72,73,68,68,69,78,44,32,100,111,99,105,100,32,72,73,68,68,69,78,44,32,37,81,32,72,73,68,68,69,78,41,0,80,82,65,71,77,65,32,37,81,46,112,97,103,101,95,115,105,122,101,0,100,111,99,105,100,32,73,78,84,69,71,69,82,32,80,82,73,77,65,82,89,32,75,69,89,0,37,122,44,32,39,99,37,100,37,113,39,0,37,122,44,32,108,97,110,103,105,100,0,67,82,69,65,84,69,32,84,65,66,76,69,32,37,81,46,39,37,113,95,99,111,110,116,101,110,116,39,40,37,115,41,0,67,82,69,65,84,69,32,84,65,66,76,69,32,37,81,46,39,37,113,95,115,101,103,109,101,110,116,115,39,40,98,108,111,99,107,105,100,32,73,78,84,69,71,69,82,32,80,82,73,77,65,82,89,32,75,69,89,44,32,98,108,111,99,107,32,66,76,79,66,41,59,0,67,82,69,65,84,69,32,84,65,66,76,69,32,37,81,46,39,37,113,95,115,101,103,100,105,114,39,40,108,101,118,101,108,32,73,78,84,69,71,69,82,44,105,100,120,32,73,78,84,69,71,69,82,44,115,116,97,114,116,95,98,108,111,99,107,32,73,78,84,69,71,69,82,44,108,101,97,118,101,115,95,101,110,100,95,98,108,111,99,107,32,73,78,84,69,71,69,82,44,101,110,100,95,98,108,111,99,107,32,73,78,84,69,71,69,82,44,114,111,111,116,32,66,76,79,66,44,80,82,73,77,65,82,89,32,75,69,89,40,108,101,118,101,108,44,32,105,100,120,41,41,59,0,67,82,69,65,84,69,32,84,65,66,76,69,32,37,81,46,39,37,113,95,100,111,99,115,105,122,101,39,40,100,111,99,105,100,32,73,78,84,69,71,69,82,32,80,82,73,77,65,82,89,32,75,69,89,44,32,115,105,122,101,32,66,76,79,66,41,59,0,44,37,115,40,63,41,0,44,32,63,0,37,115,37,115,0,100,111,99,105,100,0,44,37,115,40,120,46,39,99,37,100,37,113,39,41,0,44,32,120,46,37,81,0,108,97,110,103,105,100,0,114,111,119,105,100,0,44,32,120,46,39,37,113,39,0,95,99,111,110,116,101,110,116,0,32,70,82,79,77,32,39,37,113,39,46,39,37,113,37,115,39,32,65,83,32,120,0,83,69,76,69,67,84,32,42,32,70,82,79,77,32,37,81,46,37,81,0,112,114,101,102,105,120,0,111,114,100,101,114,0,108,97,110,103,117,97,103,101,105,100,0,110,111,116,105,110,100,101,120,101,100,0,117,110,107,110,111,119,110,32,116,111,107,101,110,105,122,101,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,97,114,103,117,109,101,110,116,32,116,121,112,101,32,109,105,115,109,97,116,99,104,0,111,117,116,32,111,102,32,109,101,109,111,114,121,0,102,116,115,51,116,111,107,101,110,105,122,101,32,100,105,115,97,98,108,101,100,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,115,101,115,115,0,115,115,0,115,101,105,0,105,0,100,101,101,0,101,101,0,103,110,105,0,100,101,0,116,97,0,97,116,101,0,108,98,0,98,108,101,0,122,105,0,105,122,101,0,108,97,110,111,105,116,97,0,108,97,110,111,105,116,0,116,105,111,110,0,105,99,110,101,0,101,110,99,101,0,105,99,110,97,0,97,110,99,101,0,114,101,122,105,0,105,103,111,108,0,108,111,103,0,105,108,98,0,105,108,108,97,0,97,108,0,105,108,116,110,101,0,101,110,116,0,105,108,101,0,101,0,105,108,115,117,111,0,111,117,115,0,110,111,105,116,97,122,105,0,110,111,105,116,97,0,114,111,116,97,0,109,115,105,108,97,0,115,115,101,110,101,118,105,0,105,118,101,0,115,115,101,110,108,117,102,0,102,117,108,0,115,115,101,110,115,117,111,0,105,116,105,108,97,0,105,116,105,118,105,0,105,116,105,108,105,98,0,101,116,97,99,105,0,105,99,0,101,118,105,116,97,0,101,122,105,108,97,0,105,116,105,99,105,0,108,97,99,105,0,108,117,102,0,115,115,101,110,0,116,110,101,109,101,0,116,110,101,109,0,116,110,101,0,110,111,105,0,101,116,97,0,105,116,105,0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,2,1,102,116,115,52,97,117,120,0,42,0,67,82,69,65,84,69,32,84,65,66,76,69,32,120,40,116,101,114,109,44,32,99,111,108,44,32,100,111,99,117,109,101,110,116,115,44,32,111,99,99,117,114,114,101,110,99,101,115,44,32,108,97,110,103,117,97,103,101,105,100,32,72,73,68,68,69,78,41,0,105,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,115,32,116,111,32,102,116,115,52,97,117,120,32,99,111,110,115,116,114,117,99,116,111,114,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7,0,1,2,3,0,1,0,0,0,97,99,101,105,110,111,117,121,121,97,99,100,101,101,103,104,105,106,107,108,110,111,114,115,116,117,117,119,121,122,111,117,97,105,111,117,103,107,111,106,103,110,97,101,105,111,114,117,115,116,104,97,101,111,121,0,0,0,0,0,0,0,0,97,98,100,100,101,102,103,104,104,105,107,108,108,109,110,112,114,114,115,116,117,118,119,119,120,121,122,104,116,119,121,97,101,105,111,117,121,114,101,109,111,118,101,95,100,105,97,99,114,105,116,105,99,115,61,49,0,114,101,109,111,118,101,95,100,105,97,99,114,105,116,105,99,115,61,48,0,116,111,107,101,110,99,104,97,114,115,61,0,115,101,112,97,114,97,116,111,114,115,61,0,97,117,116,111,109,97,116,105,99,32,101,120,116,101,110,115,105,111,110,32,108,111,97,100,105,110,103,32,102,97,105,108,101,100,58,32,37,115,0,77,65,84,67,72,0,58,109,101,109,111,114,121,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,101,99,111,118,101,114,101,100,32,37,100,32,112,97,103,101,115,32,102,114,111,109,32,37,115,0,217,213,5,249,32,161,99,215,99,97,110,110,111,116,32,108,105,109,105,116,32,87,65,76,32,115,105,122,101,58,32,37,115,0,99,97,110,110,111,116,32,111,112,101,110,32,102,105,108,101,0,114,101,99,111,118,101,114,101,100,32,37,100,32,102,114,97,109,101,115,32,102,114,111,109,32,87,65,76,32,102,105,108,101,32,37,115,0,45,106,111,117,114,110,97,108,0,0,45,119,97,108,0,0,110,111,108,111,99,107,0,105,109,109,117,116,97,98,108,101,0,0,102,105,108,101,58,0,108,111,99,97,108,104,111,115,116,0,105,110,118,97,108,105,100,32,117,114,105,32,97,117,116,104,111,114,105,116,121,58,32,37,46,42,115,0,118,102,115,0,99,97,99,104,101,0,109,111,100,101,0,97,99,99,101,115,115,0,110,111,32,115,117,99,104,32,37,115,32,109,111,100,101,58,32,37,115,0,37,115,32,109,111,100,101,32,110,111,116,32,97,108,108,111,119,101,100,58,32,37,115,0,110,111,32,115,117,99,104,32,118,102,115,58,32,37,115,0,114,111,0,114,119,0,114,119,99,0,109,101,109,111,114,121,0,115,104,97,114,101,100,0,112,114,105,118,97,116,101,0,117,110,97,98,108,101,32,116,111,32,117,115,101,32,102,117,110,99,116,105,111,110,32,37,115,32,105,110,32,116,104,101,32,114,101,113,117,101,115,116,101,100,32,99,111,110,116,101,120,116,0,117,110,97,98,108,101,32,116,111,32,100,101,108,101,116,101,47,109,111,100,105,102,121,32,117,115,101,114,45,102,117,110,99,116,105,111,110,32,100,117,101,32,116,111,32,97,99,116,105,118,101,32,115,116,97,116,101,109,101,110,116,115,0,117,110,97,98,108,101,32,116,111,32,99,108,111,115,101,32,100,117,101,32,116,111,32,117,110,102,105,110,97,108,105,122,101,100,32,115,116,97,116,101,109,101,110,116,115,32,111,114,32,117,110,102,105,110,105,115,104,101,100,32,98,97,99,107,117,112,115,0,102,97,105,108,101,100,32,109,101,109,111,114,121,32,114,101,115,105,122,101,32,37,117,32,116,111,32,37,117,32,98,121,116,101,115,0,102,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,37,117,32,98,121,116,101,115,32,111,102,32,109,101,109,111,114,121,0,117,110,114,101,99,111,103,110,105,122,101,100,32,116,111,107,101,110,58,32,34,37,84,34,0,110,101,97,114,32,34,37,84,34,58,32,115,121,110,116,97,120,32,101,114,114,111,114,0,147,1,147,3,148,1,149,3,150,0,150,1,150,1,150,1,149,2,149,2,149,2,149,2,149,3,149,5,154,6,156,1,158,0,158,3,157,1,157,0,155,5,155,2,162,0,162,2,164,2,166,0,166,4,166,6,167,2,171,2,171,2,171,4,171,3,171,3,171,2,171,3,171,5,171,2,171,4,171,4,171,1,171,2,176,0,176,1,178,0,178,2,180,2,180,3,180,3,180,3,181,2,181,2,181,1,181,1,181,2,179,3,179,2,182,0,182,2,182,2,161,0,184,1,185,2,185,7,185,5,185,5,185,10,188,0,174,0,174,3,189,0,189,2,190,1,190,1,149,4,192,2,192,0,149,9,149,4,149,1,163,2,194,3,197,1,197,2,197,1,195,9,206,4,206,5,198,1,198,1,198,0,209,0,199,3,199,2,199,4,210,2,210,0,200,0,200,2,212,2,212,0,211,7,211,9,211,7,211,7,159,0,159,2,193,2,213,1,213,2,213,3,213,4,215,2,215,0,214,0,214,3,214,2,216,4,216,0,204,0,204,3,186,4,186,2,175,1,175,1,175,0,202,0,202,3,203,0,203,2,205,0,205,2,205,4,205,4,149,6,201,0,201,2,149,8,218,5,218,7,218,3,218,5,149,6,149,7,219,2,219,1,220,0,220,3,217,3,217,1,173,3,172,1,173,1,173,1,173,3,173,5,172,1,172,1,172,1,173,1,173,3,173,6,173,5,173,4,172,1,173,5,173,3,173,3,173,3,173,3,173,3,173,3,173,3,173,3,221,1,221,2,173,3,173,5,173,2,173,3,173,3,173,4,173,2,173,2,173,2,173,2,222,1,222,2,173,5,223,1,223,2,173,5,173,3,173,5,173,5,173,4,173,5,226,5,226,4,227,2,227,0,225,1,225,0,208,0,207,3,207,1,224,0,224,3,149,12,228,1,228,0,177,0,177,3,187,5,187,3,229,0,229,2,149,4,149,1,149,2,149,3,149,5,149,6,149,5,149,6,169,2,170,2,149,5,231,11,233,1,233,1,233,2,233,0,234,1,234,1,234,3,236,0,236,2,232,3,232,2,238,3,239,3,239,2,237,7,237,5,237,5,237,1,173,4,173,6,191,1,191,1,191,1,149,4,149,6,149,3,241,0,241,2,149,1,149,3,149,1,149,3,149,6,149,7,242,1,149,1,149,4,244,8,246,0,247,1,247,3,248,1,196,0,196,2,196,3,250,6,250,8,144,1,145,2,145,1,146,1,146,3,147,0,151,0,151,1,151,2,153,1,153,0,149,2,160,4,160,2,152,1,152,1,152,1,166,1,167,1,168,1,168,1,165,2,165,0,171,2,161,2,183,3,183,1,184,0,188,1,190,1,194,1,195,1,209,2,210,1,173,1,208,1,230,1,230,1,230,1,230,1,230,1,169,1,235,0,235,3,238,1,239,0,240,1,240,0,243,0,243,1,245,1,245,3,246,2,249,0,249,4,249,2,117,110,107,110,111,119,110,32,116,97,98,108,101,32,111,112,116,105,111,110,58,32,37,46,42,115,0,115,101,116,32,108,105,115,116,0,116,111,111,32,109,97,110,121,32,97,114,103,117,109,101,110,116,115,32,111,110,32,102,117,110,99,116,105,111,110,32,37,84,0,113,117,97,108,105,102,105,101,100,32,116,97,98,108,101,32,110,97,109,101,115,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,111,110,32,73,78,83,69,82,84,44,32,85,80,68,65,84,69,44,32,97,110,100,32,68,69,76,69,84,69,32,115,116,97,116,101,109,101,110,116,115,32,119,105,116,104,105,110,32,116,114,105,103,103,101,114,115,0,116,104,101,32,73,78,68,69,88,69,68,32,66,89,32,99,108,97,117,115,101,32,105,115,32,110,111,116,32,97,108,108,111,119,101,100,32,111,110,32,85,80,68,65,84,69,32,111,114,32,68,69,76,69,84,69,32,115,116,97,116,101,109,101,110,116,115,32,119,105,116,104,105,110,32,116,114,105,103,103,101,114,115,0,116,104,101,32,78,79,84,32,73,78,68,69,88,69,68,32,99,108,97,117,115,101,32,105,115,32,110,111,116,32,97,108,108,111,119,101,100,32,111,110,32,85,80,68,65,84,69,32,111,114,32,68,69,76,69,84,69,32,115,116,97,116,101,109,101,110,116,115,32,119,105,116,104,105,110,32,116,114,105,103,103,101,114,115,0,100,117,112,108,105,99,97,116,101,32,87,73,84,72,32,116,97,98,108,101,32,110,97,109,101,58,32,37,115,0,110,111,116,32,97,117,116,104,111,114,105,122,101,100,0,97,117,116,104,111,114,105,122,101,114,32,109,97,108,102,117,110,99,116,105,111,110,0,67,82,69,65,84,69,32,86,73,82,84,85,65,76,32,84,65,66,76,69,32,37,84,0,85,80,68,65,84,69,32,37,81,46,37,115,32,83,69,84,32,116,121,112,101,61,39,116,97,98,108,101,39,44,32,110,97,109,101,61,37,81,44,32,116,98,108,95,110,97,109,101,61,37,81,44,32,114,111,111,116,112,97,103,101,61,48,44,32,115,113,108,61,37,81,32,87,72,69,82,69,32,114,111,119,105,100,61,35,37,100,0,110,97,109,101,61,39,37,113,39,32,65,78,68,32,116,121,112,101,61,39,116,97,98,108,101,39,0,118,105,114,116,117,97,108,32,116,97,98,108,101,115,32,109,97,121,32,110,111,116,32,98,101,32,97,108,116,101,114,101,100,0,67,97,110,110,111,116,32,97,100,100,32,97,32,99,111,108,117,109,110,32,116,111,32,97,32,118,105,101,119,0,115,113,108,105,116,101,95,97,108,116,101,114,116,97,98,95,37,115,0,117,110,97,98,108,101,32,116,111,32,111,112,101,110,32,97,32,116,101,109,112,111,114,97,114,121,32,100,97,116,97,98,97,115,101,32,102,105,108,101,32,102,111,114,32,115,116,111,114,105,110,103,32,116,101,109,112,111,114,97,114,121,32,116,97,98,108,101,115,0,115,113,108,105,116,101,95,0,116,97,98,108,101,32,37,115,32,109,97,121,32,110,111,116,32,98,101,32,97,108,116,101,114,101,100,0,67,97,110,110,111,116,32,97,100,100,32,97,32,80,82,73,77,65,82,89,32,75,69,89,32,99,111,108,117,109,110,0,67,97,110,110,111,116,32,97,100,100,32,97,32,85,78,73,81,85,69,32,99,111,108,117,109,110,0,67,97,110,110,111,116,32,97,100,100,32,97,32,82,69,70,69,82,69,78,67,69,83,32,99,111,108,117,109,110,32,119,105,116,104,32,110,111,110,45,78,85,76,76,32,100,101,102,97,117,108,116,32,118,97,108,117,101,0,67,97,110,110,111,116,32,97,100,100,32,97,32,78,79,84,32,78,85,76,76,32,99,111,108,117,109,110,32,119,105,116,104,32,100,101,102,97,117,108,116,32,118,97,108,117,101,32,78,85,76,76,0,67,97,110,110,111,116,32,97,100,100,32,97,32,99,111,108,117,109,110,32,119,105,116,104,32,110,111,110,45,99,111,110,115,116,97,110,116,32,100,101,102,97,117,108,116,0,85,80,68,65,84,69,32,34,37,119,34,46,37,115,32,83,69,84,32,115,113,108,32,61,32,115,117,98,115,116,114,40,115,113,108,44,49,44,37,100,41,32,124,124,32,39,44,32,39,32,124,124,32,37,81,32,124,124,32,115,117,98,115,116,114,40,115,113,108,44,37,100,41,32,87,72,69,82,69,32,116,121,112,101,32,61,32,39,116,97,98,108,101,39,32,65,78,68,32,110,97,109,101,32,61,32,37,81,0,116,98,108,95,110,97,109,101,61,37,81,0,116,121,112,101,61,39,116,114,105,103,103,101,114,39,32,65,78,68,32,40,37,115,41,0,110,97,109,101,61,37,81,0,37,115,32,79,82,32,110,97,109,101,61,37,81,0,45,0,37,108,108,100,0,37,33,46,49,53,103,0,116,104,101,114,101,32,105,115,32,97,108,114,101,97,100,121,32,97,110,111,116,104,101,114,32,116,97,98,108,101,32,111,114,32,105,110,100,101,120,32,119,105,116,104,32,116,104,105,115,32,110,97,109,101,58,32,37,115,0,118,105,101,119,32,37,115,32,109,97,121,32,110,111,116,32,98,101,32,97,108,116,101,114,101,100,0,85,80,68,65,84,69,32,34,37,119,34,46,37,115,32,83,69,84,32,115,113,108,32,61,32,115,113,108,105,116,101,95,114,101,110,97,109,101,95,112,97,114,101,110,116,40,115,113,108,44,32,37,81,44,32,37,81,41,32,87,72,69,82,69,32,37,115,59,0,85,80,68,65,84,69,32,37,81,46,37,115,32,83,69,84,32,115,113,108,32,61,32,67,65,83,69,32,87,72,69,78,32,116,121,112,101,32,61,32,39,116,114,105,103,103,101,114,39,32,84,72,69,78,32,115,113,108,105,116,101,95,114,101,110,97,109,101,95,116,114,105,103,103,101,114,40,115,113,108,44,32,37,81,41,69,76,83,69,32,115,113,108,105,116,101,95,114,101,110,97,109,101,95,116,97,98,108,101,40,115,113,108,44,32,37,81,41,32,69,78,68,44,32,116,98,108,95,110,97,109,101,32,61,32,37,81,44,32,110,97,109,101,32,61,32,67,65,83,69,32,87,72,69,78,32,116,121,112,101,61,39,116,97,98,108,101,39,32,84,72,69,78,32,37,81,32,87,72,69,78,32,110,97,109,101,32,76,73,75,69,32,39,115,113,108,105,116,101,95,97,117,116,111,105,110,100,101,120,37,37,39,32,65,78,68,32,116,121,112,101,61,39,105,110,100,101,120,39,32,84,72,69,78,32,39,115,113,108,105,116,101,95,97,117,116,111,105,110,100,101,120,95,39,32,124,124,32,37,81,32,124,124,32,115,117,98,115,116,114,40,110,97,109,101,44,37,100,43,49,56,41,32,69,76,83,69,32,110,97,109,101,32,69,78,68,32,87,72,69,82,69,32,116,98,108,95,110,97,109,101,61,37,81,32,67,79,76,76,65,84,69,32,110,111,99,97,115,101,32,65,78,68,32,40,116,121,112,101,61,39,116,97,98,108,101,39,32,79,82,32,116,121,112,101,61,39,105,110,100,101,120,39,32,79,82,32,116,121,112,101,61,39,116,114,105,103,103,101,114,39,41,59,0,115,113,108,105,116,101,95,115,101,113,117,101,110,99,101,0,85,80,68,65,84,69,32,34,37,119,34,46,115,113,108,105,116,101,95,115,101,113,117,101,110,99,101,32,115,101,116,32,110,97,109,101,32,61,32,37,81,32,87,72,69,82,69,32,110,97,109,101,32,61,32,37,81,0,85,80,68,65,84,69,32,115,113,108,105,116,101,95,116,101,109,112,95,109,97,115,116,101,114,32,83,69,84,32,115,113,108,32,61,32,115,113,108,105,116,101,95,114,101,110,97,109,101,95,116,114,105,103,103,101,114,40,115,113,108,44,32,37,81,41,44,32,116,98,108,95,110,97,109,101,32,61,32,37,81,32,87,72,69,82,69,32,37,115,59,0,118,105,101,119,32,37,115,32,105,115,32,99,105,114,99,117,108,97,114,108,121,32,100,101,102,105,110,101,100,0,110,111,32,115,117,99,104,32,99,111,108,108,97,116,105,111,110,32,115,101,113,117,101,110,99,101,58,32,37,115,0,3,2,1,37,46,42,122,58,37,117,0,97,32,71,82,79,85,80,32,66,89,32,99,108,97,117,115,101,32,105,115,32,114,101,113,117,105,114,101,100,32,98,101,102,111,114,101,32,72,65,86,73,78,71,0,79,82,68,69,82,0,71,82,79,85,80,0,97,103,103,114,101,103,97,116,101,32,102,117,110,99,116,105,111,110,115,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,116,104,101,32,71,82,79,85,80,32,66,89,32,99,108,97,117,115,101,0,116,111,111,32,109,97,110,121,32,116,101,114,109,115,32,105,110,32,79,82,68,69,82,32,66,89,32,99,108,97,117,115,101,0,37,114,32,79,82,68,69,82,32,66,89,32,116,101,114,109,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,97,110,121,32,99,111,108,117,109,110,32,105,110,32,116,104,101,32,114,101,115,117,108,116,32,115,101,116,0,37,114,32,37,115,32,66,89,32,116,101,114,109,32,111,117,116,32,111,102,32,114,97,110,103,101,32,45,32,115,104,111,117,108,100,32,98,101,32,98,101,116,119,101,101,110,32,49,32,97,110,100,32,37,100,0,97,108,108,32,86,65,76,85,69,83,32,109,117,115,116,32,104,97,118,101,32,116,104,101,32,115,97,109,101,32,110,117,109,98,101,114,32,111,102,32,116,101,114,109,115,0,83,69,76,69,67,84,115,32,116,111,32,116,104,101,32,108,101,102,116,32,97,110,100,32,114,105,103,104,116,32,111,102,32,37,115,32,100,111,32,110,111,116,32,104,97,118,101,32,116,104,101,32,115,97,109,101,32,110,117,109,98,101,114,32,111,102,32,114,101,115,117,108,116,32,99,111,108,117,109,110,115,0,85,78,73,79,78,32,65,76,76,0,73,78,84,69,82,83,69,67,84,0,69,88,67,69,80,84,0,85,78,73,79,78,0,116,111,111,32,109,97,110,121,32,116,101,114,109,115,32,105,110,32,37,115,32,66,89,32,99,108,97,117,115,101,0,69,120,112,114,101,115,115,105,111,110,32,116,114,101,101,32,105,115,32,116,111,111,32,108,97,114,103,101,32,40,109,97,120,105,109,117,109,32,100,101,112,116,104,32,37,100,41,0,116,104,101,32,34,46,34,32,111,112,101,114,97,116,111,114,0,115,101,99,111,110,100,32,97,114,103,117,109,101,110,116,32,116,111,32,108,105,107,101,108,105,104,111,111,100,40,41,32,109,117,115,116,32,98,101,32,97,32,99,111,110,115,116,97,110,116,32,98,101,116,119,101,101,110,32,48,46,48,32,97,110,100,32,49,46,48,0,110,111,116,32,97,117,116,104,111,114,105,122,101,100,32,116,111,32,117,115,101,32,102,117,110,99,116,105,111,110,58,32,37,115,0,110,111,110,45,100,101,116,101,114,109,105,110,105,115,116,105,99,32,102,117,110,99,116,105,111,110,115,0,109,105,115,117,115,101,32,111,102,32,97,103,103,114,101,103,97,116,101,32,102,117,110,99,116,105,111,110,32,37,46,42,115,40,41,0,110,111,32,115,117,99,104,32,102,117,110,99,116,105,111,110,58,32,37,46,42,115,0,119,114,111,110,103,32,110,117,109,98,101,114,32,111,102,32,97,114,103,117,109,101,110,116,115,32,116,111,32,102,117,110,99,116,105,111,110,32,37,46,42,115,40,41,0,115,117,98,113,117,101,114,105,101,115,0,112,97,114,97,109,101,116,101,114,115,0,114,111,119,32,118,97,108,117,101,32,109,105,115,117,115,101,100,0,112,97,114,116,105,97,108,32,105,110,100,101,120,32,87,72,69,82,69,32,99,108,97,117,115,101,115,0,105,110,100,101,120,32,101,120,112,114,101,115,115,105,111,110,115,0,67,72,69,67,75,32,99,111,110,115,116,114,97,105,110,116,115,0,37,115,32,112,114,111,104,105,98,105,116,101,100,32,105,110,32,37,115,0,110,101,119,0,111,108,100,0,109,105,115,117,115,101,32,111,102,32,97,108,105,97,115,101,100,32,97,103,103,114,101,103,97,116,101,32,37,115,0,110,111,32,115,117,99,104,32,99,111,108,117,109,110,0,97,109,98,105,103,117,111,117,115,32,99,111,108,117,109,110,32,110,97,109,101,0,37,115,58,32,37,115,46,37,115,46,37,115,0,37,115,58,32,37,115,46,37,115,0,37,115,58,32,37,115,0,97,99,99,101,115,115,32,116,111,32,37,115,46,37,115,46,37,115,32,105,115,32,112,114,111,104,105,98,105,116,101,100,0,97,99,99,101,115,115,32,116,111,32,37,115,46,37,115,32,105,115,32,112,114,111,104,105,98,105,116,101,100,0,115,113,108,105,116,101,95,115,113,95,37,112,0,116,111,111,32,109,97,110,121,32,114,101,102,101,114,101,110,99,101,115,32,116,111,32,34,37,115,34,58,32,109,97,120,32,54,53,53,51,53,0,37,115,46,37,115,0,37,115,46,37,115,46,37,115,0,110,111,32,115,117,99,104,32,116,97,98,108,101,58,32,37,115,0,110,111,32,116,97,98,108,101,115,32,115,112,101,99,105,102,105,101,100,0,116,111,111,32,109,97,110,121,32,99,111,108,117,109,110,115,32,105,110,32,114,101,115,117,108,116,32,115,101,116,0,97,32,78,65,84,85,82,65,76,32,106,111,105,110,32,109,97,121,32,110,111,116,32,104,97,118,101,32,97,110,32,79,78,32,111,114,32,85,83,73,78,71,32,99,108,97,117,115,101,0,99,97,110,110,111,116,32,104,97,118,101,32,98,111,116,104,32,79,78,32,97,110,100,32,85,83,73,78,71,32,99,108,97,117,115,101,115,32,105,110,32,116,104,101,32,115,97,109,101,32,106,111,105,110,0,99,97,110,110,111,116,32,106,111,105,110,32,117,115,105,110,103,32,99,111,108,117,109,110,32,37,115,32,45,32,99,111,108,117,109,110,32,110,111,116,32,112,114,101,115,101,110,116,32,105,110,32,98,111,116,104,32,116,97,98,108,101,115,0,110,111,32,115,117,99,104,32,105,110,100,101,120,58,32,37,115,0,39,37,115,39,32,105,115,32,110,111,116,32,97,32,102,117,110,99,116,105,111,110,0,109,117,108,116,105,112,108,101,32,114,101,102,101,114,101,110,99,101,115,32,116,111,32,114,101,99,117,114,115,105,118,101,32,116,97,98,108,101,58,32,37,115,0,99,105,114,99,117,108,97,114,32,114,101,102,101,114,101,110,99,101,58,32,37,115,0,116,97,98,108,101,32,37,115,32,104,97,115,32,37,100,32,118,97,108,117,101,115,32,102,111,114,32,37,100,32,99,111,108,117,109,110,115,0,109,117,108,116,105,112,108,101,32,114,101,99,117,114,115,105,118,101,32,114,101,102,101,114,101,110,99,101,115,58,32,37,115,0,114,101,99,117,114,115,105,118,101,32,114,101,102,101,114,101,110,99,101,32,105,110,32,97,32,115,117,98,113,117,101,114,121,58,32,37,115,0,110,111,32,115,117,99,104,32,109,111,100,117,108,101,58,32,37,115,0,118,116,97,98,108,101,32,99,111,110,115,116,114,117,99,116,111,114,32,99,97,108,108,101,100,32,114,101,99,117,114,115,105,118,101,108,121,58,32,37,115,0,118,116,97,98,108,101,32,99,111,110,115,116,114,117,99,116,111,114,32,102,97,105,108,101,100,58,32,37,115,0,118,116,97,98,108,101], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+20480);
/* memory initializer */ allocate([32,99,111,110,115,116,114,117,99,116,111,114,32,100,105,100,32,110,111,116,32,100,101,99,108,97,114,101,32,115,99,104,101,109,97,58,32,37,115,0,104,105,100,100,101,110,0,111,98,106,101,99,116,32,110,97,109,101,32,114,101,115,101,114,118,101,100,32,102,111,114,32,105,110,116,101,114,110,97,108,32,117,115,101,58,32,37,115,0,99,111,114,114,117,112,116,32,100,97,116,97,98,97,115,101,0,117,110,107,110,111,119,110,32,100,97,116,97,98,97,115,101,32,37,84,0,105,100,120,0,116,98,108,0,115,113,108,105,116,101,95,37,0,66,66,66,0,115,116,97,116,95,103,101,116,0,37,108,108,117,0,32,37,108,108,117,0,115,116,97,116,95,112,117,115,104,0,115,116,97,116,95,105,110,105,116,0,67,82,69,65,84,69,32,84,65,66,76,69,32,37,81,46,37,115,40,37,115,41,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,37,115,32,87,72,69,82,69,32,37,115,61,37,81,0,116,98,108,44,105,100,120,44,115,116,97,116,0,115,113,108,105,116,101,95,115,116,97,116,51,0,115,113,108,105,116,101,95,115,116,97,116,52,0,117,110,97,98,108,101,32,116,111,32,105,100,101,110,116,105,102,121,32,116,104,101,32,111,98,106,101,99,116,32,116,111,32,98,101,32,114,101,105,110,100,101,120,101,100,0,105,110,100,101,120,32,39,37,113,39,0,44,32,0,109,105,115,117,115,101,32,111,102,32,97,103,103,114,101,103,97,116,101,58,32,37,115,40,41,0,117,110,107,110,111,119,110,32,102,117,110,99,116,105,111,110,58,32,37,115,40,41,0,82,65,73,83,69,40,41,32,109,97,121,32,111,110,108,121,32,98,101,32,117,115,101,100,32,119,105,116,104,105,110,32,97,32,116,114,105,103,103,101,114,45,112,114,111,103,114,97,109,0,85,83,73,78,71,32,73,78,68,69,88,32,37,115,32,70,79,82,32,73,78,45,79,80,69,82,65,84,79,82,0,67,79,82,82,69,76,65,84,69,68,32,0,76,73,83,84,0,83,67,65,76,65,82,0,69,88,69,67,85,84,69,32,37,115,37,115,32,83,85,66,81,85,69,82,89,32,37,100,0,115,117,98,45,115,101,108,101,99,116,32,114,101,116,117,114,110,115,32,37,100,32,99,111,108,117,109,110,115,32,45,32,101,120,112,101,99,116,101,100,32,37,100,0,48,120,0,104,101,120,32,108,105,116,101,114,97,108,32,116,111,111,32,98,105,103,58,32,37,115,0,115,113,108,105,116,101,95,100,101,116,97,99,104,0,110,111,32,115,117,99,104,32,100,97,116,97,98,97,115,101,58,32,37,115,0,99,97,110,110,111,116,32,100,101,116,97,99,104,32,100,97,116,97,98,97,115,101,32,37,115,0,99,97,110,110,111,116,32,68,69,84,65,67,72,32,100,97,116,97,98,97,115,101,32,119,105,116,104,105,110,32,116,114,97,110,115,97,99,116,105,111,110,0,100,97,116,97,98,97,115,101,32,37,115,32,105,115,32,108,111,99,107,101,100,0,115,113,108,105,116,101,95,97,116,116,97,99,104,0,116,111,111,32,109,97,110,121,32,97,116,116,97,99,104,101,100,32,100,97,116,97,98,97,115,101,115,32,45,32,109,97,120,32,37,100,0,99,97,110,110,111,116,32,65,84,84,65,67,72,32,100,97,116,97,98,97,115,101,32,119,105,116,104,105,110,32,116,114,97,110,115,97,99,116,105,111,110,0,100,97,116,97,98,97,115,101,32,37,115,32,105,115,32,97,108,114,101,97,100,121,32,105,110,32,117,115,101,0,100,97,116,97,98,97,115,101,32,105,115,32,97,108,114,101,97,100,121,32,97,116,116,97,99,104,101,100,0,117,110,97,98,108,101,32,116,111,32,111,112,101,110,32,100,97,116,97,98,97,115,101,58,32,37,115,0,110,111,32,115,117,99,104,32,116,114,105,103,103,101,114,58,32,37,83,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,37,115,32,87,72,69,82,69,32,110,97,109,101,61,37,81,32,65,78,68,32,116,121,112,101,61,39,116,114,105,103,103,101,114,39,0,116,101,109,112,111,114,97,114,121,32,116,114,105,103,103,101,114,32,109,97,121,32,110,111,116,32,104,97,118,101,32,113,117,97,108,105,102,105,101,100,32,110,97,109,101,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,116,114,105,103,103,101,114,115,32,111,110,32,118,105,114,116,117,97,108,32,116,97,98,108,101,115,0,116,114,105,103,103,101,114,32,37,84,32,97,108,114,101,97,100,121,32,101,120,105,115,116,115,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,116,114,105,103,103,101,114,32,111,110,32,115,121,115,116,101,109,32,116,97,98,108,101,0,66,69,70,79,82,69,0,65,70,84,69,82,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,37,115,32,116,114,105,103,103,101,114,32,111,110,32,118,105,101,119,58,32,37,83,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,73,78,83,84,69,65,68,32,79,70,32,116,114,105,103,103,101,114,32,111,110,32,116,97,98,108,101,58,32,37,83,0,37,115,32,37,84,32,99,97,110,110,111,116,32,114,101,102,101,114,101,110,99,101,32,111,98,106,101,99,116,115,32,105,110,32,100,97,116,97,98,97,115,101,32,37,115,0,37,115,32,99,97,110,110,111,116,32,117,115,101,32,118,97,114,105,97,98,108,101,115,0,73,78,83,69,82,84,32,73,78,84,79,32,37,81,46,37,115,32,86,65,76,85,69,83,40,39,116,114,105,103,103,101,114,39,44,37,81,44,37,81,44,48,44,39,67,82,69,65,84,69,32,84,82,73,71,71,69,82,32,37,113,39,41,0,116,121,112,101,61,39,116,114,105,103,103,101,114,39,32,65,78,68,32,110,97,109,101,61,39,37,113,39,0,45,37,84,0,114,101,115,117,108,116,0,99,97,99,104,101,95,115,105,122,101,0,2,0,0,0,101,0,1,3,66,1,8,0,76,0,2,0,48,1,2,1,66,1,8,0,76,0,1,0,161,0,0,0,87,1,1,0,112,97,103,101,95,115,105,122,101,0,115,101,99,117,114,101,95,100,101,108,101,116,101,0,110,111,114,109,97,108,0,101,120,99,108,117,115,105,118,101,0,108,111,99,107,105,110,103,95,109,111,100,101,0,106,111,117,114,110,97,108,95,109,111,100,101,0,106,111,117,114,110,97,108,95,115,105,122,101,95,108,105,109,105,116,0,97,117,116,111,95,118,97,99,117,117,109,0,2,0,1,0,101,0,1,4,21,1,0,0,75,0,2,0,102,0,7,0,99,97,99,104,101,95,115,112,105,108,108,0,109,109,97,112,95,115,105,122,101,0,116,101,109,112,95,115,116,111,114,101,0,116,101,109,112,95,115,116,111,114,101,95,100,105,114,101,99,116,111,114,121,0,110,111,116,32,97,32,119,114,105,116,97,98,108,101,32,100,105,114,101,99,116,111,114,121,0,115,121,110,99,104,114,111,110,111,117,115,0,83,97,102,101,116,121,32,108,101,118,101,108,32,109,97,121,32,110,111,116,32,98,101,32,99,104,97,110,103,101,100,32,105,110,115,105,100,101,32,97,32,116,114,97,110,115,97,99,116,105,111,110,0,105,115,115,105,115,105,0,115,115,105,105,0,115,105,105,0,105,105,115,0,105,115,105,0,105,115,105,115,105,0,105,115,115,0,105,115,0,105,105,115,115,115,115,115,115,0,78,79,78,69,0,115,105,0,105,110,116,101,103,114,105,116,121,95,99,104,101,99,107,0,42,42,42,32,105,110,32,100,97,116,97,98,97,115,101,32,37,115,32,42,42,42,10,0,78,85,76,76,32,118,97,108,117,101,32,105,110,32,37,115,46,37,115,0,114,111,119,32,0,32,109,105,115,115,105,110,103,32,102,114,111,109,32,105,110,100,101,120,32,0,110,111,110,45,117,110,105,113,117,101,32,101,110,116,114,121,32,105,110,32,105,110,100,101,120,32,0,119,114,111,110,103,32,35,32,111,102,32,101,110,116,114,105,101,115,32,105,110,32,105,110,100,101,120,32,0,91,1,0,0,21,1,4,0,97,0,3,0,87,3,1,0,111,107,0,101,110,99,111,100,105,110,103,0,117,110,115,117,112,112,111,114,116,101,100,32,101,110,99,111,100,105,110,103,58,32,37,115,0,2,0,1,0,102,0,0,0,2,0,0,0,101,0,1,0,87,1,1,0,99,111,109,112,105,108,101,95,111,112,116,105,111,110,0,102,117,108,108,0,114,101,115,116,97,114,116,0,116,114,117,110,99,97,116,101,0,119,97,108,95,97,117,116,111,99,104,101,99,107,112,111,105,110,116,0,116,105,109,101,111,117,116,0,115,111,102,116,95,104,101,97,112,95,108,105,109,105,116,0,116,104,114,101,97,100,115,0,98,117,115,121,0,99,104,101,99,107,112,111,105,110,116,101,100,0,85,84,70,56,0,85,84,70,45,56,0,85,84,70,45,49,54,108,101,0,85,84,70,45,49,54,98,101,0,85,84,70,49,54,108,101,0,85,84,70,49,54,98,101,0,85,84,70,45,49,54,0,85,84,70,49,54,0,37,95,0,0,108,105,107,101,0,103,108,111,98,0,76,73,75,69,32,111,114,32,71,76,79,66,32,112,97,116,116,101,114,110,32,116,111,111,32,99,111,109,112,108,101,120,0,69,83,67,65,80,69,32,101,120,112,114,101,115,115,105,111,110,32,109,117,115,116,32,98,101,32,97,32,115,105,110,103,108,101,32,99,104,97,114,97,99,116,101,114,0,102,111,114,101,105,103,110,32,107,101,121,32,109,105,115,109,97,116,99,104,32,45,32,34,37,119,34,32,114,101,102,101,114,101,110,99,105,110,103,32,34,37,119,34,0,116,97,98,108,101,0,112,97,114,101,110,116,0,102,107,105,100,0,83,69,84,32,78,85,76,76,0,83,69,84,32,68,69,70,65,85,76,84,0,67,65,83,67,65,68,69,0,82,69,83,84,82,73,67,84,0,78,79,32,65,67,84,73,79,78,0,105,100,0,115,101,113,0,102,114,111,109,0,116,111,0,111,110,95,117,112,100,97,116,101,0,111,110,95,100,101,108,101,116,101,0,109,97,116,99,104,0,110,97,109,101,0,102,105,108,101,0,99,0,117,0,112,107,0,117,110,105,113,117,101,0,111,114,105,103,105,110,0,112,97,114,116,105,97,108,0,115,101,113,110,111,0,99,105,100,0,99,111,108,108,0,107,101,121,0,105,110,100,101,120,0,119,105,100,116,104,0,104,101,105,103,104,116,0,116,121,112,101,0,110,111,116,110,117,108,108,0,100,102,108,116,95,118,97,108,117,101,0,116,101,109,112,111,114,97,114,121,32,115,116,111,114,97,103,101,32,99,97,110,110,111,116,32,98,101,32,99,104,97,110,103,101,100,32,102,114,111,109,32,119,105,116,104,105,110,32,97,32,116,114,97,110,115,97,99,116,105,111,110,0,110,111,110,101,0,105,110,99,114,101,109,101,110,116,97,108,0,100,101,108,101,116,101,0,112,101,114,115,105,115,116,0,111,102,102,0,119,97,108,0,97,112,112,108,105,99,97,116,105,111,110,95,105,100,0,97,117,116,111,109,97,116,105,99,95,105,110,100,101,120,0,98,117,115,121,95,116,105,109,101,111,117,116,0,99,97,115,101,95,115,101,110,115,105,116,105,118,101,95,108,105,107,101,0,99,101,108,108,95,115,105,122,101,95,99,104,101,99,107,0,99,104,101,99,107,112,111,105,110,116,95,102,117,108,108,102,115,121,110,99,0,99,111,108,108,97,116,105,111,110,95,108,105,115,116,0,99,111,109,112,105,108,101,95,111,112,116,105,111,110,115,0,99,111,117,110,116,95,99,104,97,110,103,101,115,0,100,97,116,97,95,118,101,114,115,105,111,110,0,100,97,116,97,98,97,115,101,95,108,105,115,116,0,100,101,102,97,117,108,116,95,99,97,99,104,101,95,115,105,122,101,0,100,101,102,101,114,95,102,111,114,101,105,103,110,95,107,101,121,115,0,101,109,112,116,121,95,114,101,115,117,108,116,95,99,97,108,108,98,97,99,107,115,0,102,111,114,101,105,103,110,95,107,101,121,95,99,104,101,99,107,0,102,111,114,101,105,103,110,95,107,101,121,95,108,105,115,116,0,102,111,114,101,105,103,110,95,107,101,121,115,0,102,114,101,101,108,105,115,116,95,99,111,117,110,116,0,102,117,108,108,95,99,111,108,117,109,110,95,110,97,109,101,115,0,102,117,108,108,102,115,121,110,99,0,105,103,110,111,114,101,95,99,104,101,99,107,95,99,111,110,115,116,114,97,105,110,116,115,0,105,110,99,114,101,109,101,110,116,97,108,95,118,97,99,117,117,109,0,105,110,100,101,120,95,105,110,102,111,0,105,110,100,101,120,95,108,105,115,116,0,105,110,100,101,120,95,120,105,110,102,111,0,108,101,103,97,99,121,95,102,105,108,101,95,102,111,114,109,97,116,0,109,97,120,95,112,97,103,101,95,99,111,117,110,116,0,112,97,103,101,95,99,111,117,110,116,0,113,117,101,114,121,95,111,110,108,121,0,113,117,105,99,107,95,99,104,101,99,107,0,114,101,97,100,95,117,110,99,111,109,109,105,116,116,101,100,0,114,101,99,117,114,115,105,118,101,95,116,114,105,103,103,101,114,115,0,114,101,118,101,114,115,101,95,117,110,111,114,100,101,114,101,100,95,115,101,108,101,99,116,115,0,115,99,104,101,109,97,95,118,101,114,115,105,111,110,0,115,104,111,114,116,95,99,111,108,117,109,110,95,110,97,109,101,115,0,115,104,114,105,110,107,95,109,101,109,111,114,121,0,115,116,97,116,115,0,116,97,98,108,101,95,105,110,102,111,0,117,115,101,114,95,118,101,114,115,105,111,110,0,119,97,108,95,99,104,101,99,107,112,111,105,110,116,0,119,114,105,116,97,98,108,101,95,115,99,104,101,109,97,0,110,111,32,115,117,99,104,32,105,110,100,101,120,58,32,37,83,0,105,110,100,101,120,32,97,115,115,111,99,105,97,116,101,100,32,119,105,116,104,32,85,78,73,81,85,69,32,111,114,32,80,82,73,77,65,82,89,32,75,69,89,32,99,111,110,115,116,114,97,105,110,116,32,99,97,110,110,111,116,32,98,101,32,100,114,111,112,112,101,100,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,37,115,32,87,72,69,82,69,32,110,97,109,101,61,37,81,32,65,78,68,32,116,121,112,101,61,39,105,110,100,101,120,39,0,85,80,68,65,84,69,32,37,81,46,37,115,32,83,69,84,32,114,111,111,116,112,97,103,101,61,37,100,32,87,72,69,82,69,32,35,37,100,32,65,78,68,32,114,111,111,116,112,97,103,101,61,35,37,100,0,115,113,108,105,116,101,95,115,116,97,116,37,100,0,115,121,110,116,97,120,32,101,114,114,111,114,32,97,102,116,101,114,32,99,111,108,117,109,110,32,110,97,109,101,32,34,37,46,42,115,34,0,48,0,118,97,114,105,97,98,108,101,32,110,117,109,98,101,114,32,109,117,115,116,32,98,101,32,98,101,116,119,101,101,110,32,63,49,32,97,110,100,32,63,37,100,0,116,111,111,32,109,97,110,121,32,83,81,76,32,118,97,114,105,97,98,108,101,115,0,116,97,98,108,101,32,37,83,32,104,97,115,32,110,111,32,99,111,108,117,109,110,32,110,97,109,101,100,32,37,115,0,116,97,98,108,101,32,37,83,32,104,97,115,32,37,100,32,99,111,108,117,109,110,115,32,98,117,116,32,37,100,32,118,97,108,117,101,115,32,119,101,114,101,32,115,117,112,112,108,105,101,100,0,37,100,32,118,97,108,117,101,115,32,102,111,114,32,37,100,32,99,111,108,117,109,110,115,0,114,111,119,115,32,105,110,115,101,114,116,101,100,0,35,0,2,0,114,0,0,0,99,0,2,0,115,0,0,0,111,0,0,0,97,116,32,109,111,115,116,32,37,100,32,116,97,98,108,101,115,32,105,110,32,97,32,106,111,105,110,0,26,24,23,25,0,0,57,53,26,23,25,24,61,59,58,60,7,6,57,53,83,69,65,82,67,72,0,83,67,65,78,0,32,83,85,66,81,85,69,82,89,32,37,100,0,32,84,65,66,76,69,32,37,115,0,32,65,83,32,37,115,0,80,82,73,77,65,82,89,32,75,69,89,0,65,85,84,79,77,65,84,73,67,32,80,65,82,84,73,65,76,32,67,79,86,69,82,73,78,71,32,73,78,68,69,88,0,65,85,84,79,77,65,84,73,67,32,67,79,86,69,82,73,78,71,32,73,78,68,69,88,0,67,79,86,69,82,73,78,71,32,73,78,68,69,88,32,37,115,0,73,78,68,69,88,32,37,115,0,32,85,83,73,78,71,32,0,61,0,62,63,32,65,78,68,32,114,111,119,105,100,60,0,62,0,60,0,32,85,83,73,78,71,32,73,78,84,69,71,69,82,32,80,82,73,77,65,82,89,32,75,69,89,32,40,114,111,119,105,100,37,115,63,41,0,32,86,73,82,84,85,65,76,32,84,65,66,76,69,32,73,78,68,69,88,32,37,100,58,37,115,0,32,40,0,32,65,78,68,32,0,37,115,61,63,0,65,78,89,40,37,115,41,0,41,0,40,0,44,0,60,101,120,112,114,62,0,97,117,116,111,109,97,116,105,99,32,105,110,100,101,120,32,111,110,32,37,115,40,37,115,41,0,97,117,116,111,45,105,110,100,101,120,0,110,111,32,113,117,101,114,121,32,115,111,108,117,116,105,111,110,0,10,10,9,9,8,8,7,7,7,6,6,6,5,5,5,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,37,115,46,120,66,101,115,116,73,110,100,101,120,32,109,97,108,102,117,110,99,116,105,111,110,0,41,39,66,73,78,65,82,89,0,114,101,103,101,120,112,0,116,111,111,32,109,97,110,121,32,97,114,103,117,109,101,110,116,115,32,111,110,32,37,115,40,41,32,45,32,109,97,120,32,37,100,0,45,45,32,84,82,73,71,71,69,82,32,37,115,0,0,0,0,1,1,1,1,1,0,16,0,1,0,1,1,1,3,3,1,18,1,3,3,9,9,9,9,38,38,9,9,9,9,9,3,3,11,11,11,11,11,11,1,38,38,38,38,38,38,38,38,38,38,1,18,1,1,1,1,1,1,1,35,11,1,1,3,3,3,1,1,1,2,2,8,0,16,16,16,16,0,16,16,0,0,16,16,0,0,0,0,2,2,2,0,0,0,16,0,0,16,16,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,0,0,0,16,0,4,4,0,0,16,16,0,16,0,16,16,0,0,0,0,0,0,6,16,0,4,26,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,1,2,3,4,6,8,8,0,0,0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56,57,57,70,79,82,69,73,71,78,32,75,69,89,32,99,111,110,115,116,114,97,105,110,116,32,102,97,105,108,101,100,0,37,115,46,114,111,119,105,100,0,116,97,98,108,101,32,37,115,32,109,97,121,32,110,111,116,32,98,101,32,109,111,100,105,102,105,101,100,0,99,97,110,110,111,116,32,109,111,100,105,102,121,32,37,115,32,98,101,99,97,117,115,101,32,105,116,32,105,115,32,97,32,118,105,101,119,0,37,100,32,99,111,108,117,109,110,115,32,97,115,115,105,103,110,101,100,32,37,100,32,118,97,108,117,101,115,0,114,111,119,115,32,117,112,100,97,116,101,100,0,116,111,111,32,109,97,110,121,32,99,111,108,117,109,110,115,32,105,110,32,37,115,0,114,111,119,115,32,100,101,108,101,116,101,100,0,0,7,4,6,4,40,10,5,32,14,5,48,19,4,56,23,5,1,28,5,3,110,97,116,117,114,97,108,101,102,116,111,117,116,101,114,105,103,104,116,102,117,108,108,105,110,110,101,114,99,114,111,115,115,0,32,0,117,110,107,110,111,119,110,32,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,106,111,105,110,32,116,121,112,101,58,32,37,84,32,37,84,37,115,37,84,0,82,73,71,72,84,32,97,110,100,32,70,85,76,76,32,79,85,84,69,82,32,74,79,73,78,115,32,97,114,101,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,115,117,112,112,111,114,116,101,100,0,79,78,0,85,83,73,78,71,0,97,32,74,79,73,78,32,99,108,97,117,115,101,32,105,115,32,114,101,113,117,105,114,101,100,32,98,101,102,111,114,101,32,37,115,0,116,111,111,32,109,97,110,121,32,116,101,114,109,115,32,105,110,32,99,111,109,112,111,117,110,100,32,83,69,76,69,67,84,0,101,120,112,101,99,116,101,100,32,37,100,32,99,111,108,117,109,110,115,32,102,111,114,32,39,37,115,39,32,98,117,116,32,103,111,116,32,37,100,0,68,73,83,84,73,78,67,84,0,71,82,79,85,80,32,66,89,0,82,73,71,72,84,32,80,65,82,84,32,79,70,32,79,82,68,69,82,32,66,89,0,79,82,68,69,82,32,66,89,0,99,111,108,117,109,110,37,100,0,109,105,110,0,109,97,120,0,32,85,83,73,78,71,32,67,79,86,69,82,73,78,71,32,73,78,68,69,88,32,0,83,67,65,78,32,84,65,66,76,69,32,37,115,37,115,37,115,0,68,73,83,84,73,78,67,84,32,97,103,103,114,101,103,97,116,101,115,32,109,117,115,116,32,104,97,118,101,32,101,120,97,99,116,108,121,32,111,110,101,32,97,114,103,117,109,101,110,116,0,85,83,69,32,84,69,77,80,32,66,45,84,82,69,69,32,70,79,82,32,37,115,0,79,82,68,69,82,32,66,89,32,99,108,97,117,115,101,32,115,104,111,117,108,100,32,99,111,109,101,32,97,102,116,101,114,32,37,115,32,110,111,116,32,98,101,102,111,114,101,0,76,73,77,73,84,32,99,108,97,117,115,101,32,115,104,111,117,108,100,32,99,111,109,101,32,97,102,116,101,114,32,37,115,32,110,111,116,32,98,101,102,111,114,101,0,85,83,73,78,71,32,84,69,77,80,32,66,45,84,82,69,69,32,0,67,79,77,80,79,85,78,68,32,83,85,66,81,85,69,82,73,69,83,32,37,100,32,65,78,68,32,37,100,32,37,115,40,37,115,41,0,114,101,99,117,114,115,105,118,101,32,97,103,103,114,101,103,97,116,101,32,113,117,101,114,105,101,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,112,97,114,97,109,101,116,101,114,115,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,118,105,101,119,115,0,118,105,101,119,0,115,113,108,105,116,101,95,115,116,97,116,0,116,97,98,108,101,32,37,115,32,109,97,121,32,110,111,116,32,98,101,32,100,114,111,112,112,101,100,0,117,115,101,32,68,82,79,80,32,84,65,66,76,69,32,116,111,32,100,101,108,101,116,101,32,116,97,98,108,101,32,37,115,0,117,115,101,32,68,82,79,80,32,86,73,69,87,32,116,111,32,100,101,108,101,116,101,32,118,105,101,119,32,37,115,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,115,113,108,105,116,101,95,115,101,113,117,101,110,99,101,32,87,72,69,82,69,32,110,97,109,101,61,37,81,0,68,69,76,69,84,69,32,70,82,79,77,32,37,81,46,37,115,32,87,72,69,82,69,32,116,98,108,95,110,97,109,101,61,37,81,32,97,110,100,32,116,121,112,101,33,61,39,116,114,105,103,103,101,114,39,0,102,111,114,101,105,103,110,32,107,101,121,32,111,110,32,37,115,32,115,104,111,117,108,100,32,114,101,102,101,114,101,110,99,101,32,111,110,108,121,32,111,110,101,32,99,111,108,117,109,110,32,111,102,32,116,97,98,108,101,32,37,84,0,110,117,109,98,101,114,32,111,102,32,99,111,108,117,109,110,115,32,105,110,32,102,111,114,101,105,103,110,32,107,101,121,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,116,104,101,32,110,117,109,98,101,114,32,111,102,32,99,111,108,117,109,110,115,32,105,110,32,116,104,101,32,114,101,102,101,114,101,110,99,101,100,32,116,97,98,108,101,0,117,110,107,110,111,119,110,32,99,111,108,117,109,110,32,34,37,115,34,32,105,110,32,102,111,114,101,105,103,110,32,107,101,121,32,100,101,102,105,110,105,116,105,111,110,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,97,32,84,69,77,80,32,105,110,100,101,120,32,111,110,32,110,111,110,45,84,69,77,80,32,116,97,98,108,101,32,34,37,115,34,0,97,108,116,101,114,116,97,98,95,0,116,97,98,108,101,32,37,115,32,109,97,121,32,110,111,116,32,98,101,32,105,110,100,101,120,101,100,0,118,105,101,119,115,32,109,97,121,32,110,111,116,32,98,101,32,105,110,100,101,120,101,100,0,118,105,114,116,117,97,108,32,116,97,98,108,101,115,32,109,97,121,32,110,111,116,32,98,101,32,105,110,100,101,120,101,100,0,116,104,101,114,101,32,105,115,32,97,108,114,101,97,100,121,32,97,32,116,97,98,108,101,32,110,97,109,101,100,32,37,115,0,105,110,100,101,120,32,37,115,32,97,108,114,101,97,100,121,32,101,120,105,115,116,115,0,115,113,108,105,116,101,95,97,117,116,111,105,110,100,101,120,95,37,115,95,37,100,0,101,120,112,114,101,115,115,105,111,110,115,32,112,114,111,104,105,98,105,116,101,100,32,105,110,32,80,82,73,77,65,82,89,32,75,69,89,32,97,110,100,32,85,78,73,81,85,69,32,99,111,110,115,116,114,97,105,110,116,115,0,99,111,110,102,108,105,99,116,105,110,103,32,79,78,32,67,79,78,70,76,73,67,84,32,99,108,97,117,115,101,115,32,115,112,101,99,105,102,105,101,100,0,32,85,78,73,81,85,69,0,67,82,69,65,84,69,37,115,32,73,78,68,69,88,32,37,46,42,115,0,73,78,83,69,82,84,32,73,78,84,79,32,37,81,46,37,115,32,86,65,76,85,69,83,40,39,105,110,100,101,120,39,44,37,81,44,37,81,44,35,37,100,44,37,81,41,59,0,110,97,109,101,61,39,37,113,39,32,65,78,68,32,116,121,112,101,61,39,105,110,100,101,120,39,0,116,97,98,108,101,32,34,37,115,34,32,104,97,115,32,109,111,114,101,32,116,104,97,110,32,111,110,101,32,112,114,105,109,97,114,121,32,107,101,121,0,65,85,84,79,73,78,67,82,69,77,69,78,84,32,105,115,32,111,110,108,121,32,97,108,108,111,119,101,100,32,111,110,32,97,110,32,73,78,84,69,71,69,82,32,80,82,73,77,65,82,89,32,75,69,89,0,100,101,102,97,117,108,116,32,118,97,108,117,101,32,111,102,32,99,111,108,117,109,110,32,91,37,115,93,32,105,115,32,110,111,116,32,99,111,110,115,116,97,110,116,0,116,111,111,32,109,97,110,121,32,99,111,108,117,109,110,115,32,111,110,32,37,115,0,100,117,112,108,105,99,97,116,101,32,99,111,108,117,109,110,32,110,97,109,101,58,32,37,115,0,65,85,84,79,73,78,67,82,69,77,69,78,84,32,110,111,116,32,97,108,108,111,119,101,100,32,111,110,32,87,73,84,72,79,85,84,32,82,79,87,73,68,32,116,97,98,108,101,115,0,80,82,73,77,65,82,89,32,75,69,89,32,109,105,115,115,105,110,103,32,111,110,32,116,97,98,108,101,32,37,115,0,84,65,66,76,69,0,86,73,69,87,0,67,82,69,65,84,69,32,37,115,32,37,46,42,115,0,85,80,68,65,84,69,32,37,81,46,37,115,32,83,69,84,32,116,121,112,101,61,39,37,115,39,44,32,110,97,109,101,61,37,81,44,32,116,98,108,95,110,97,109,101,61,37,81,44,32,114,111,111,116,112,97,103,101,61,35,37,100,44,32,115,113,108,61,37,81,32,87,72,69,82,69,32,114,111,119,105,100,61,35,37,100,0,67,82,69,65,84,69,32,84,65,66,76,69,32,37,81,46,115,113,108,105,116,101,95,115,101,113,117,101,110,99,101,40,110,97,109,101,44,115,101,113,41,0,116,98,108,95,110,97,109,101,61,39,37,113,39,32,65,78,68,32,116,121,112,101,33,61,39,116,114,105,103,103,101,114,39,0,10,32,32,0,44,10,32,32,0,10,41,0,67,82,69,65,84,69,32,84,65,66,76,69,32,0,32,84,69,88,84,0,32,78,85,77,0,32,73,78,84,0,32,82,69,65,76,0,116,101,109,112,111,114,97,114,121,32,116,97,98,108,101,32,110,97,109,101,32,109,117,115,116,32,98,101,32,117,110,113,117,97,108,105,102,105,101,100,0,2,4,8,6,116,97,98,108,101,32,37,84,32,97,108,114,101,97,100,121,32,101,120,105,115,116,115,0,116,104,101,114,101,32,105,115,32,97,108,114,101,97,100,121,32,97,110,32,105,110,100,101,120,32,110,97,109,101,100,32,37,115,0,6,0,0,0,0,0,66,69,71,73,78,0,82,69,76,69,65,83,69,0,82,79,76,76,66,65,67,75,0,67,79,77,77,73,84,0,79,0,0,0,57,0,9,0,96,0,0,0,36,0,7,0,123,0,0,0,96,0,1,0,13,0,9,0,7,0,2,0,76,0,0,0,111,0,0,0,112,97,114,115,101,114,32,115,116,97,99,107,32,111,118,101,114,102,108,111,119,0,19,95,53,97,22,24,24,101,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,19,55,55,132,133,134,1,2,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,187,43,44,45,46,47,48,49,50,51,52,53,47,48,49,50,51,52,53,61,97,97,19,49,50,51,52,53,70,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,144,145,146,147,19,16,22,92,172,173,52,53,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,81,43,44,45,46,47,48,49,50,51,52,53,55,56,19,152,207,208,115,24,117,118,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,79,43,44,45,46,47,48,49,50,51,52,53,19,88,157,90,23,97,98,193,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,19,22,23,172,23,26,119,120,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,187,43,44,45,46,47,48,49,50,51,52,53,19,22,23,228,23,26,231,152,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,172,43,44,45,46,47,48,49,50,51,52,53,19,221,222,223,23,96,152,172,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,19,0,1,2,23,96,190,191,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,238,43,44,45,46,47,48,49,50,51,52,53,19,185,218,221,222,223,152,152,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,241,43,44,45,46,47,48,49,50,51,52,53,19,152,168,169,170,22,190,191,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,19,19,218,55,56,24,22,152,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,250,194,195,56,55,56,55,19,172,173,97,98,152,206,138,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,19,207,208,152,97,98,97,138,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,181,43,44,45,46,47,48,49,50,51,52,53,19,30,31,32,33,247,248,19,152,28,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,19,168,169,170,238,19,53,152,172,173,29,30,31,32,33,34,35,36,37,38,39,40,41,152,43,44,45,46,47,48,49,50,51,52,53,19,20,101,22,23,169,170,56,207,85,55,56,23,19,20,26,22,99,100,101,102,103,104,105,238,152,152,210,47,48,112,152,108,109,110,54,55,56,221,222,223,47,48,119,120,172,173,66,54,55,56,152,97,98,99,148,149,102,103,104,66,154,23,156,83,26,230,152,113,152,163,194,195,92,92,30,95,83,97,98,207,208,101,206,179,180,92,172,173,95,152,97,98,188,99,101,219,102,103,104,152,119,120,196,55,56,19,20,113,22,193,163,11,132,133,134,135,136,24,65,172,173,207,208,250,152,132,133,134,135,136,193,78,84,47,48,49,98,199,152,86,54,55,56,196,152,97,98,209,55,163,244,107,66,152,207,208,164,175,172,173,19,20,124,22,111,38,39,40,41,83,43,44,45,46,47,48,49,50,51,52,53,95,196,97,98,85,152,101,47,48,97,85,92,207,193,54,55,56,92,49,175,55,56,221,222,223,12,66,108,109,110,137,163,139,108,109,110,26,132,133,134,135,136,152,83,43,44,45,46,47,48,49,50,51,52,53,95,26,97,98,55,56,101,97,98,196,221,222,223,146,147,57,171,152,22,26,19,20,49,22,179,108,109,110,55,56,116,73,219,75,124,121,152,132,133,134,135,136,163,85,152,232,97,98,47,48,237,55,56,98,5,54,55,56,193,10,11,12,13,14,172,173,17,66,47,48,97,98,152,124,152,196,55,56,186,124,152,106,160,152,83,152,164,152,61,22,211,212,152,97,98,152,95,70,97,98,172,173,101,172,173,172,173,172,173,60,181,62,172,173,47,48,123,186,97,98,71,100,55,56,152,181,186,21,107,152,109,82,163,132,133,134,135,136,89,16,207,92,93,19,172,173,169,170,195,55,56,12,152,132,30,134,47,48,186,206,225,152,95,114,97,196,245,246,101,152,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,152,163,219,152,141,97,98,193,152,152,57,91,164,132,133,134,152,55,152,152,237,230,152,103,193,88,73,90,75,172,173,183,152,185,196,152,172,173,172,173,217,152,172,173,152,107,22,152,24,193,112,152,172,173,152,132,242,134,152,97,140,152,92,152,172,173,152,172,173,152,100,172,173,152,172,173,152,140,172,173,152,172,173,172,173,152,172,173,152,172,173,152,152,172,173,152,172,173,213,152,172,173,152,152,152,172,173,152,172,173,152,172,173,152,210,172,173,152,26,172,173,152,172,173,172,173,152,172,173,152,172,173,152,172,173,152,59,172,173,152,63,172,173,152,193,152,152,152,152,172,173,152,172,173,77,172,173,152,152,172,173,152,152,172,173,172,173,172,173,152,22,172,173,152,152,152,22,172,173,152,152,152,172,173,152,7,8,9,163,172,173,22,23,172,173,172,173,166,167,172,173,172,173,55,172,173,22,23,108,109,110,217,152,217,166,167,163,163,163,163,163,196,130,217,211,212,217,116,23,22,101,26,121,23,23,23,26,26,26,23,23,112,26,26,37,97,100,101,55,196,196,196,196,196,23,23,55,26,26,7,8,23,152,23,26,96,26,132,132,134,134,23,152,152,26,152,122,152,191,152,96,234,152,152,152,152,152,197,210,152,97,152,152,210,233,210,198,150,97,184,201,239,214,214,201,239,180,214,227,200,198,155,67,243,176,69,175,175,175,122,159,159,240,159,240,22,220,27,130,201,18,159,18,189,158,158,220,192,159,137,236,192,192,192,189,74,189,159,235,159,158,22,177,201,201,159,107,158,177,159,174,158,76,174,182,174,106,182,125,174,107,177,22,159,216,215,137,159,53,216,176,215,174,174,216,215,215,174,229,216,129,224,177,126,229,127,177,128,25,162,226,26,161,13,153,6,153,151,151,151,151,205,165,178,178,165,4,3,22,165,142,15,94,202,204,203,201,16,23,249,23,120,249,246,111,131,123,20,16,1,125,123,111,56,64,37,37,131,122,1,37,5,37,22,107,26,80,140,80,87,72,107,20,24,19,112,105,23,79,22,79,22,22,22,58,22,79,23,68,23,23,26,116,22,26,23,22,122,23,23,56,64,22,124,26,26,64,64,23,23,23,23,11,23,22,26,23,22,24,1,23,22,26,251,24,23,22,122,23,23,22,15,122,122,122,23,0,0,55,55,55,55,0,55,55,55,0,55,55,55,55,0,0,0,55,0,0,55,0,0,0,55,0,0,0,0,55,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,27,27,27,27,27,27,27,27,27,7,7,27,7,7,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,7,15,8,5,4,22,24,8,17,18,21,20,23,11,26,16,3,3,3,3,3,3,3,3,3,3,5,19,12,14,13,6,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,9,27,27,27,1,8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,27,10,27,25,27,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,105,110,118,97,108,105,100,0,65,80,73,32,99,97,108,108,32,119,105,116,104,32,37,115,32,100,97,116,97,98,97,115,101,32,99,111,110,110,101,99,116,105,111,110,32,112,111,105,110,116,101,114,0,100,97,116,97,98,97,115,101,32,115,99,104,101,109,97,32,105,115,32,108,111,99,107,101,100,58,32,37,115,0,115,116,97,116,101,109,101,110,116,32,116,111,111,32,108,111,110,103,0,97,100,100,114,0,111,112,99,111,100,101,0,112,49,0,112,50,0,112,51,0,112,52,0,112,53,0,99,111,109,109,101,110,116,0,115,101,108,101,99,116,105,100,0,100,101,116,97,105,108,0,78,85,76,76,0,117,110,111,112,101,110,101,100,0,114,101,97,108,0,105,110,116,101,103,101,114,0,110,117,108,108,0,99,97,110,110,111,116,32,111,112,101,110,32,118,97,108,117,101,32,111,102,32,116,121,112,101,32,37,115,0,110,111,32,115,117,99,104,32,114,111,119,105,100,58,32,37,108,108,100,0,110,111,32,115,117,99,104,32,118,105,101,119,0,110,111,32,115,117,99,104,32,116,97,98,108,101,0,45,45,32,0,39,37,46,42,113,39,0,122,101,114,111,98,108,111,98,40,37,100,41,0,120,39,0,37,48,50,120,0,39,0,98,105,110,100,32,111,110,32,97,32,98,117,115,121,32,112,114,101,112,97,114,101,100,32,115,116,97,116,101,109,101,110,116,58,32,91,37,115,93,0,37,115,32,99,111,110,115,116,114,97,105,110,116,32,102,97,105,108,101,100,0,37,122,58,32,37,115,0,97,98,111,114,116,32,97,116,32,37,100,32,105,110,32,91,37,115,93,58,32,37,115,0,0,0,0,0,1,2,0,2,2,0,1,2,1,1,1,2,1,2,0,0,0,0,0,0,0,0,99,97,110,110,111,116,32,111,112,101,110,32,115,97,118,101,112,111,105,110,116,32,45,32,83,81,76,32,115,116,97,116,101,109,101,110,116,115,32,105,110,32,112,114,111,103,114,101,115,115,0,110,111,32,115,117,99,104,32,115,97,118,101,112,111,105,110,116,58,32,37,115,0,99,97,110,110,111,116,32,114,101,108,101,97,115,101,32,115,97,118,101,112,111,105,110,116,32,45,32,83,81,76,32,115,116,97,116,101,109,101,110,116,115,32,105,110,32,112,114,111,103,114,101,115,115,0,99,97,110,110,111,116,32,99,111,109,109,105,116,32,116,114,97,110,115,97,99,116,105,111,110,32,45,32,83,81,76,32,115,116,97,116,101,109,101,110,116,115,32,105,110,32,112,114,111,103,114,101,115,115,0,99,97,110,110,111,116,32,114,111,108,108,98,97,99,107,32,45,32,110,111,32,116,114,97,110,115,97,99,116,105,111,110,32,105,115,32,97,99,116,105,118,101,0,99,97,110,110,111,116,32,99,111,109,109,105,116,32,45,32,110,111,32,116,114,97,110,115,97,99,116,105,111,110,32,105,115,32,97,99,116,105,118,101,0,99,97,110,110,111,116,32,115,116,97,114,116,32,97,32,116,114,97,110,115,97,99,116,105,111,110,32,119,105,116,104,105,110,32,97,32,116,114,97,110,115,97,99,116,105,111,110,0,100,97,116,97,98,97,115,101,32,115,99,104,101,109,97,32,104,97,115,32,99,104,97,110,103,101,100,0,83,69,76,69,67,84,32,110,97,109,101,44,32,114,111,111,116,112,97,103,101,44,32,115,113,108,32,70,82,79,77,32,39,37,113,39,46,37,115,32,87,72,69,82,69,32,37,115,32,79,82,68,69,82,32,66,89,32,114,111,119,105,100,0,116,111,111,32,109,97,110,121,32,108,101,118,101,108,115,32,111,102,32,116,114,105,103,103,101,114,32,114,101,99,117,114,115,105,111,110,0,105,110,116,111,0,111,117,116,32,111,102,0,99,97,110,110,111,116,32,99,104,97,110,103,101,32,37,115,32,119,97,108,32,109,111,100,101,32,102,114,111,109,32,119,105,116,104,105,110,32,97,32,116,114,97,110,115,97,99,116,105,111,110,0,100,97,116,97,98,97,115,101,32,116,97,98,108,101,32,105,115,32,108,111,99,107,101,100,58,32,37,115,0,115,116,97,116,101,109,101,110,116,32,97,98,111,114,116,115,32,97,116,32,37,100,58,32,91,37,115,93,32,37,115,0,99,97,110,110,111,116,32,86,65,67,85,85,77,32,102,114,111,109,32,119,105,116,104,105,110,32,97,32,116,114,97,110,115,97,99,116,105,111,110,0,99,97,110,110,111,116,32,86,65,67,85,85,77,32,45,32,83,81,76,32,115,116,97,116,101,109,101,110,116,115,32,105,110,32,112,114,111,103,114,101,115,115,0,65,84,84,65,67,72,39,39,65,83,32,118,97,99,117,117,109,95,100,98,0,83,69,76,69,67,84,32,115,113,108,32,70,82,79,77,32,34,37,119,34,46,115,113,108,105,116,101,95,109,97,115,116,101,114,32,87,72,69,82,69,32,116,121,112,101,61,39,116,97,98,108,101,39,65,78,68,32,110,97,109,101,60,62,39,115,113,108,105,116,101,95,115,101,113,117,101,110,99,101,39,32,65,78,68,32,99,111,97,108,101,115,99,101,40,114,111,111,116,112,97,103,101,44,49,41,62,48,0,83,69,76,69,67,84,32,115,113,108,32,70,82,79,77,32,34,37,119,34,46,115,113,108,105,116,101,95,109,97,115,116,101,114,32,87,72,69,82,69,32,116,121,112,101,61,39,105,110,100,101,120,39,32,65,78,68,32,108,101,110,103,116,104,40,115,113,108,41,62,49,48,0,83,69,76,69,67,84,39,73,78,83,69,82,84,32,73,78,84,79,32,118,97,99,117,117,109,95,100,98,46,39,124,124,113,117,111,116,101,40,110,97,109,101,41,124,124,39,32,83,69,76,69,67,84,42,70,82,79,77,34,37,119,34,46,39,124,124,113,117,111,116,101,40,110,97,109,101,41,70,82,79,77,32,118,97,99,117,117,109,95,100,98,46,115,113,108,105,116,101,95,109,97,115,116,101,114,32,87,72,69,82,69,32,116,121,112,101,61,39,116,97,98,108,101,39,65,78,68,32,99,111,97,108,101,115,99,101,40,114,111,111,116,112,97,103,101,44,49,41,62,48,0,73,78,83,69,82,84,32,73,78,84,79,32,118], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+30720);
/* memory initializer */ allocate([97,99,117,117,109,95,100,98,46,115,113,108,105,116,101,95,109,97,115,116,101,114,32,83,69,76,69,67,84,42,70,82,79,77,32,34,37,119,34,46,115,113,108,105,116,101,95,109,97,115,116,101,114,32,87,72,69,82,69,32,116,121,112,101,32,73,78,40,39,118,105,101,119,39,44,39,116,114,105,103,103,101,114,39,41,32,79,82,40,116,121,112,101,61,39,116,97,98,108,101,39,65,78,68,32,114,111,111,116,112,97,103,101,61,48,41,0,1,1,3,0,5,0,6,0,8,0,77,97,105,110,32,102,114,101,101,108,105,115,116,58,32,0,80,97,103,101,32,37,100,32,105,115,32,110,101,118,101,114,32,117,115,101,100,0,80,111,105,110,116,101,114,32,109,97,112,32,112,97,103,101,32,37,100,32,105,115,32,114,101,102,101,114,101,110,99,101,100,0,10,0,80,97,103,101,32,37,100,58,32,0,117,110,97,98,108,101,32,116,111,32,103,101,116,32,116,104,101,32,112,97,103,101,46,32,101,114,114,111,114,32,99,111,100,101,61,37,100,0,98,116,114,101,101,73,110,105,116,80,97,103,101,40,41,32,114,101,116,117,114,110,115,32,101,114,114,111,114,32,99,111,100,101,32,37,100,0,79,110,32,116,114,101,101,32,112,97,103,101,32,37,100,32,99,101,108,108,32,37,100,58,32,0,79,110,32,112,97,103,101,32,37,100,32,97,116,32,114,105,103,104,116,32,99,104,105,108,100,58,32,0,79,102,102,115,101,116,32,37,100,32,111,117,116,32,111,102,32,114,97,110,103,101,32,37,100,46,46,37,100,0,69,120,116,101,110,100,115,32,111,102,102,32,101,110,100,32,111,102,32,112,97,103,101,0,82,111,119,105,100,32,37,108,108,100,32,111,117,116,32,111,102,32,111,114,100,101,114,0,67,104,105,108,100,32,112,97,103,101,32,100,101,112,116,104,32,100,105,102,102,101,114,115,0,77,117,108,116,105,112,108,101,32,117,115,101,115,32,102,111,114,32,98,121,116,101,32,37,117,32,111,102,32,112,97,103,101,32,37,100,0,70,114,97,103,109,101,110,116,97,116,105,111,110,32,111,102,32,37,100,32,98,121,116,101,115,32,114,101,112,111,114,116,101,100,32,97,115,32,37,100,32,111,110,32,112,97,103,101,32,37,100,0,105,110,118,97,108,105,100,32,112,97,103,101,32,110,117,109,98,101,114,32,37,100,0,50,110,100,32,114,101,102,101,114,101,110,99,101,32,116,111,32,112,97,103,101,32,37,100,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,112,116,114,109,97,112,32,107,101,121,61,37,100,0,66,97,100,32,112,116,114,32,109,97,112,32,101,110,116,114,121,32,107,101,121,61,37,100,32,101,120,112,101,99,116,101,100,61,40,37,100,44,37,100,41,32,103,111,116,61,40,37,100,44,37,100,41,0,37,100,32,111,102,32,37,100,32,112,97,103,101,115,32,109,105,115,115,105,110,103,32,102,114,111,109,32,111,118,101,114,102,108,111,119,32,108,105,115,116,32,115,116,97,114,116,105,110,103,32,97,116,32,37,100,0,102,97,105,108,101,100,32,116,111,32,103,101,116,32,112,97,103,101,32,37,100,0,102,114,101,101,108,105,115,116,32,108,101,97,102,32,99,111,117,110,116,32,116,111,111,32,98,105,103,32,111,110,32,112,97,103,101,32,37,100,0,102,114,101,101,45,112,97,103,101,32,99,111,117,110,116,32,105,110,32,104,101,97,100,101,114,32,105,115,32,116,111,111,32,115,109,97,108,108,0,0,1,2,3,4,6,8,83,81,76,105,116,101,32,102,111,114,109,97,116,32,51,0,1,1,0,1,0,0,37,115,45,109,106,88,88,88,88,88,88,57,88,88,122,0,77,74,32,100,101,108,101,116,101,58,32,37,115,0,77,74,32,99,111,108,108,105,100,101,58,32,37,115,0,45,109,106,37,48,54,88,57,37,48,50,88,0,78,79,84,32,78,85,76,76,0,85,78,73,81,85,69,0,67,72,69,67,75,0,70,79,82,69,73,71,78,32,75,69,89,0,37,46,50,120,0,107,40,37,100,0,66,0,44,37,115,37,115,0,40,37,46,50,48,115,41,0,37,115,40,37,100,41,0,37,100,0,37,46,49,54,103,0,40,98,108,111,98,41,0,118,116,97,98,58,37,112,0,44,37,100,0,93,0,112,114,111,103,114,97,109,0,83,97,118,101,112,111,105,110,116,0,65,117,116,111,67,111,109,109,105,116,0,84,114,97,110,115,97,99,116,105,111,110,0,83,111,114,116,101,114,78,101,120,116,0,80,114,101,118,73,102,79,112,101,110,0,78,101,120,116,73,102,79,112,101,110,0,80,114,101,118,0,78,101,120,116,0,67,104,101,99,107,112,111,105,110,116,0,74,111,117,114,110,97,108,77,111,100,101,0,86,97,99,117,117,109,0,86,70,105,108,116,101,114,0,86,85,112,100,97,116,101,0,71,111,116,111,0,71,111,115,117,98,0,73,110,105,116,67,111,114,111,117,116,105,110,101,0,89,105,101,108,100,0,77,117,115,116,66,101,73,110,116,0,74,117,109,112,0,78,111,116,0,79,110,99,101,0,73,102,0,73,102,78,111,116,0,83,101,101,107,76,84,0,83,101,101,107,76,69,0,83,101,101,107,71,69,0,83,101,101,107,71,84,0,79,114,0,65,110,100,0,78,111,67,111,110,102,108,105,99,116,0,78,111,116,70,111,117,110,100,0,70,111,117,110,100,0,83,101,101,107,82,111,119,105,100,0,78,111,116,69,120,105,115,116,115,0,73,115,78,117,108,108,0,78,111,116,78,117,108,108,0,78,101,0,69,113,0,71,116,0,76,101,0,76,116,0,71,101,0,69,108,115,101,78,111,116,69,113,0,66,105,116,65,110,100,0,66,105,116,79,114,0,83,104,105,102,116,76,101,102,116,0,83,104,105,102,116,82,105,103,104,116,0,65,100,100,0,83,117,98,116,114,97,99,116,0,77,117,108,116,105,112,108,121,0,68,105,118,105,100,101,0,82,101,109,97,105,110,100,101,114,0,67,111,110,99,97,116,0,76,97,115,116,0,66,105,116,78,111,116,0,83,111,114,116,101,114,83,111,114,116,0,83,111,114,116,0,82,101,119,105,110,100,0,73,100,120,76,69,0,73,100,120,71,84,0,73,100,120,76,84,0,73,100,120,71,69,0,82,111,119,83,101,116,82,101,97,100,0,82,111,119,83,101,116,84,101,115,116,0,80,114,111,103,114,97,109,0,70,107,73,102,90,101,114,111,0,73,102,80,111,115,0,73,102,78,111,116,90,101,114,111,0,68,101,99,114,74,117,109,112,90,101,114,111,0,73,110,99,114,86,97,99,117,117,109,0,86,78,101,120,116,0,73,110,105,116,0,82,101,116,117,114,110,0,69,110,100,67,111,114,111,117,116,105,110,101,0,72,97,108,116,73,102,78,117,108,108,0,72,97,108,116,0,73,110,116,101,103,101,114,0,73,110,116,54,52,0,83,116,114,105,110,103,0,78,117,108,108,0,83,111,102,116,78,117,108,108,0,66,108,111,98,0,86,97,114,105,97,98,108,101,0,77,111,118,101,0,67,111,112,121,0,83,67,111,112,121,0,73,110,116,67,111,112,121,0,82,101,115,117,108,116,82,111,119,0,67,111,108,108,83,101,113,0,70,117,110,99,116,105,111,110,48,0,70,117,110,99,116,105,111,110,0,65,100,100,73,109,109,0,82,101,97,108,65,102,102,105,110,105,116,121,0,67,97,115,116,0,80,101,114,109,117,116,97,116,105,111,110,0,67,111,109,112,97,114,101,0,67,111,108,117,109,110,0,83,116,114,105,110,103,56,0,65,102,102,105,110,105,116,121,0,77,97,107,101,82,101,99,111,114,100,0,67,111,117,110,116,0,82,101,97,100,67,111,111,107,105,101,0,83,101,116,67,111,111,107,105,101,0,82,101,111,112,101,110,73,100,120,0,79,112,101,110,82,101,97,100,0,79,112,101,110,87,114,105,116,101,0,79,112,101,110,65,117,116,111,105,110,100,101,120,0,79,112,101,110,69,112,104,101,109,101,114,97,108,0,83,111,114,116,101,114,79,112,101,110,0,83,101,113,117,101,110,99,101,84,101,115,116,0,79,112,101,110,80,115,101,117,100,111,0,67,108,111,115,101,0,67,111,108,117,109,110,115,85,115,101,100,0,83,101,113,117,101,110,99,101,0,78,101,119,82,111,119,105,100,0,73,110,115,101,114,116,0,73,110,115,101,114,116,73,110,116,0,68,101,108,101,116,101,0,82,101,115,101,116,67,111,117,110,116,0,83,111,114,116,101,114,67,111,109,112,97,114,101,0,83,111,114,116,101,114,68,97,116,97,0,82,111,119,75,101,121,0,82,111,119,68,97,116,97,0,82,111,119,105,100,0,78,117,108,108,82,111,119,0,83,111,114,116,101,114,73,110,115,101,114,116,0,73,100,120,73,110,115,101,114,116,0,73,100,120,68,101,108,101,116,101,0,83,101,101,107,0,73,100,120,82,111,119,105,100,0,68,101,115,116,114,111,121,0,67,108,101,97,114,0,82,101,97,108,0,82,101,115,101,116,83,111,114,116,101,114,0,67,114,101,97,116,101,73,110,100,101,120,0,67,114,101,97,116,101,84,97,98,108,101,0,80,97,114,115,101,83,99,104,101,109,97,0,76,111,97,100,65,110,97,108,121,115,105,115,0,68,114,111,112,84,97,98,108,101,0,68,114,111,112,73,110,100,101,120,0,68,114,111,112,84,114,105,103,103,101,114,0,73,110,116,101,103,114,105,116,121,67,107,0,82,111,119,83,101,116,65,100,100,0,80,97,114,97,109,0,70,107,67,111,117,110,116,101,114,0,77,101,109,77,97,120,0,79,102,102,115,101,116,76,105,109,105,116,0,65,103,103,83,116,101,112,48,0,65,103,103,83,116,101,112,0,65,103,103,70,105,110,97,108,0,69,120,112,105,114,101,0,84,97,98,108,101,76,111,99,107,0,86,66,101,103,105,110,0,86,67,114,101,97,116,101,0,86,68,101,115,116,114,111,121,0,86,79,112,101,110,0,86,67,111,108,117,109,110,0,86,82,101,110,97,109,101,0,80,97,103,101,99,111,117,110,116,0,77,97,120,80,103,99,110,116,0,67,117,114,115,111,114,72,105,110,116,0,78,111,111,112,0,69,120,112,108,97,105,110,0,65,80,73,32,99,97,108,108,101,100,32,119,105,116,104,32,78,85,76,76,32,112,114,101,112,97,114,101,100,32,115,116,97,116,101,109,101,110,116,0,117,110,107,110,111,119,110,32,101,114,114,111,114,0,97,98,111,114,116,32,100,117,101,32,116,111,32,82,79,76,76,66,65,67,75,0,110,111,116,32,97,110,32,101,114,114,111,114,0,83,81,76,32,108,111,103,105,99,32,101,114,114,111,114,32,111,114,32,109,105,115,115,105,110,103,32,100,97,116,97,98,97,115,101,0,97,99,99,101,115,115,32,112,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,99,97,108,108,98,97,99,107,32,114,101,113,117,101,115,116,101,100,32,113,117,101,114,121,32,97,98,111,114,116,0,100,97,116,97,98,97,115,101,32,105,115,32,108,111,99,107,101,100,0,100,97,116,97,98,97,115,101,32,116,97,98,108,101,32,105,115,32,108,111,99,107,101,100,0,97,116,116,101,109,112,116,32,116,111,32,119,114,105,116,101,32,97,32,114,101,97,100,111,110,108,121,32,100,97,116,97,98,97,115,101,0,105,110,116,101,114,114,117,112,116,101,100,0,100,105,115,107,32,73,47,79,32,101,114,114,111,114,0,100,97,116,97,98,97,115,101,32,100,105,115,107,32,105,109,97,103,101,32,105,115,32,109,97,108,102,111,114,109,101,100,0,117,110,107,110,111,119,110,32,111,112,101,114,97,116,105,111,110,0,100,97,116,97,98,97,115,101,32,111,114,32,100,105,115,107,32,105,115,32,102,117,108,108,0,117,110,97,98,108,101,32,116,111,32,111,112,101,110,32,100,97,116,97,98,97,115,101,32,102,105,108,101,0,108,111,99,107,105,110,103,32,112,114,111,116,111,99,111,108,0,116,97,98,108,101,32,99,111,110,116,97,105,110,115,32,110,111,32,100,97,116,97,0,99,111,110,115,116,114,97,105,110,116,32,102,97,105,108,101,100,0,100,97,116,97,116,121,112,101,32,109,105,115,109,97,116,99,104,0,108,105,98,114,97,114,121,32,114,111,117,116,105,110,101,32,99,97,108,108,101,100,32,111,117,116,32,111,102,32,115,101,113,117,101,110,99,101,0,108,97,114,103,101,32,102,105,108,101,32,115,117,112,112,111,114,116,32,105,115,32,100,105,115,97,98,108,101,100,0,97,117,116,104,111,114,105,122,97,116,105,111,110,32,100,101,110,105,101,100,0,97,117,120,105,108,105,97,114,121,32,100,97,116,97,98,97,115,101,32,102,111,114,109,97,116,32,101,114,114,111,114,0,98,105,110,100,32,111,114,32,99,111,108,117,109,110,32,105,110,100,101,120,32,111,117,116,32,111,102,32,114,97,110,103,101,0,102,105,108,101,32,105,115,32,101,110,99,114,121,112,116,101,100,32,111,114,32,105,115,32,110,111,116,32,97,32,100,97,116,97,98,97,115,101,0,65,80,73,32,99,97,108,108,101,100,32,119,105,116,104,32,102,105,110,97,108,105,122,101,100,32,112,114,101,112,97,114,101,100,32,115,116,97,116,101,109,101,110,116,0,64,32,32,0,117,110,105,120,0,117,110,105,120,45,110,111,110,101,0,117,110,105,120,45,100,111,116,102,105,108,101,0,117,110,105,120,45,101,120,99,108,0,99,108,111,115,101,0,111,115,95,117,110,105,120,46,99,58,37,100,58,32,40,37,100,41,32,37,115,40,37,115,41,32,45,32,37,115,0,111,112,101,110,0,103,101,116,99,119,100,0,115,116,97,116,0,102,115,116,97,116,0,102,116,114,117,110,99,97,116,101,0,102,99,110,116,108,0,114,101,97,100,0,112,114,101,97,100,0,112,114,101,97,100,54,52,0,119,114,105,116,101,0,112,119,114,105,116,101,0,112,119,114,105,116,101,54,52,0,102,99,104,109,111,100,0,102,97,108,108,111,99,97,116,101,0,117,110,108,105,110,107,0,111,112,101,110,68,105,114,101,99,116,111,114,121,0,109,107,100,105,114,0,114,109,100,105,114,0,102,99,104,111,119,110,0,103,101,116,101,117,105,100,0,109,109,97,112,0,109,117,110,109,97,112,0,109,114,101,109,97,112,0,103,101,116,112,97,103,101,115,105,122,101,0,114,101,97,100,108,105,110,107,0,108,115,116,97,116,0,97,116,116,101,109,112,116,32,116,111,32,111,112,101,110,32,34,37,115,34,32,97,115,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,37,100,0,47,100,101,118,47,110,117,108,108,0,37,115,47,101,116,105,108,113,115,95,37,108,108,120,37,99,0,83,81,76,73,84,69,95,84,77,80,68,73,82,0,84,77,80,68,73,82,0,47,118,97,114,47,116,109,112,0,47,117,115,114,47,116,109,112,0,47,116,109,112,0,46,0,102,117,108,108,95,102,115,121,110,99,0,47,100,101,118,47,117,114,97,110,100,111,109,0,102,115,121,110,99,0,112,115,111,119,0,37,115,46,108,111,99,107,0,99,97,110,110,111,116,32,102,115,116,97,116,32,100,98,32,102,105,108,101,32,37,115,0,102,105,108,101,32,117,110,108,105,110,107,101,100,32,119,104,105,108,101,32,111,112,101,110,58,32,37,115,0,109,117,108,116,105,112,108,101,32,108,105,110,107,115,32,116,111,32,102,105,108,101,58,32,37,115,0,102,105,108,101,32,114,101,110,97,109,101,100,32,119,104,105,108,101,32,111,112,101,110,58,32,37,115,0,37,115,45,115,104,109,0,114,101,97,100,111,110,108,121,95,115,104,109,0,109,111,100,101,111,102,0,37,0,100,10,1,0,0,0,115,0,4,5,0,0,103,0,1,3,30,0,122,0,4,6,0,0,113,0,4,9,0,0,81,0,4,10,0,0,119,0,4,14,0,0,99,0,0,8,0,0,111,8,0,0,0,2,117,10,0,0,0,0,120,16,0,0,16,1,88,16,0,0,0,4,102,0,1,1,0,0,101,0,1,2,30,0,69,0,1,2,14,0,71,0,1,3,14,0,105,10,1,0,0,0,110,0,0,4,0,0,37,0,0,7,0,0,112,16,0,13,0,1,84,0,2,11,0,0,83,0,2,12,0,0,114,10,3,15,0,0,116,104,115,116,110,100,114,100,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,0,45,120,48,0,88,48,0,78,97,78,0,73,110,102,0,40,78,85,76,76,41,0,115,113,108,105,116,101,95,99,111,109,112,105,108,101,111,112,116,105,111,110,95,117,115,101,100,0,115,113,108,105,116,101,95,99,111,109,112,105,108,101,111,112,116,105,111,110,95,103,101,116,0,117,110,108,105,107,101,108,121,0,108,105,107,101,108,105,104,111,111,100,0,108,105,107,101,108,121,0,108,116,114,105,109,0,114,116,114,105,109,0,116,114,105,109,0,116,121,112,101,111,102,0,108,101,110,103,116,104,0,105,110,115,116,114,0,112,114,105,110,116,102,0,117,110,105,99,111,100,101,0,99,104,97,114,0,97,98,115,0,114,111,117,110,100,0,117,112,112,101,114,0,108,111,119,101,114,0,104,101,120,0,105,102,110,117,108,108,0,114,97,110,100,111,109,0,114,97,110,100,111,109,98,108,111,98,0,110,117,108,108,105,102,0,115,113,108,105,116,101,95,118,101,114,115,105,111,110,0,115,113,108,105,116,101,95,115,111,117,114,99,101,95,105,100,0,115,113,108,105,116,101,95,108,111,103,0,113,117,111,116,101,0,108,97,115,116,95,105,110,115,101,114,116,95,114,111,119,105,100,0,99,104,97,110,103,101,115,0,116,111,116,97,108,95,99,104,97,110,103,101,115,0,114,101,112,108,97,99,101,0,122,101,114,111,98,108,111,98,0,115,117,98,115,116,114,0,115,117,109,0,116,111,116,97,108,0,97,118,103,0,99,111,117,110,116,0,103,114,111,117,112,95,99,111,110,99,97,116,0,99,111,97,108,101,115,99,101,0,105,110,116,101,103,101,114,32,111,118,101,114,102,108,111,119,0,37,33,46,50,48,101,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,37,46,42,102,0,116,101,120,116,0,98,108,111,98,0,1,106,117,108,105,97,110,100,97,121,0,100,97,116,101,0,116,105,109,101,0,100,97,116,101,116,105,109,101,0,115,116,114,102,116,105,109,101,0,99,117,114,114,101,110,116,95,116,105,109,101,0,99,117,114,114,101,110,116,95,116,105,109,101,115,116,97,109,112,0,99,117,114,114,101,110,116,95,100,97,116,101,0,37,48,50,100,0,37,48,54,46,51,102,0,37,48,51,100,0,37,48,52,100,0,108,111,99,97,108,116,105,109,101,0,117,110,105,120,101,112,111,99,104,0,117,116,99,0,119,101,101,107,100,97,121,32,0,115,116,97,114,116,32,111,102,32,0,109,111,110,116,104,0,121,101,97,114,0,100,97,121,0,104,111,117,114,0,109,105,110,117,116,101,0,115,101,99,111,110,100,0,50,48,99,58,50,48,101,0,50,48,101,0,50,48,98,58,50,48,101,0,108,111,99,97,108,32,116,105,109,101,32,117,110,97,118,97,105,108,97,98,108,101,0,110,111,119,0,52,48,102,45,50,49,97,45,50,49,100,0,37,48,52,100,45,37,48,50,100,45,37,48,50,100,32,37,48,50,100,58,37,48,50,100,58,37,48,50,100,0,37,48,50,100,58,37,48,50,100,58,37,48,50,100,0,37,48,52,100,45,37,48,50,100,45,37,48,50,100,0,115,113,108,105,116,101,95,114,101,110,97,109,101,95,116,97,98,108,101,0,115,113,108,105,116,101,95,114,101,110,97,109,101,95,116,114,105,103,103,101,114,0,115,113,108,105,116,101,95,114,101,110,97,109,101,95,112,97,114,101,110,116,0,37,115,37,46,42,115,34,37,119,34,0,37,46,42,115,34,37,119,34,37,115,0,109,105,115,117,115,101,0,67,79,77,80,73,76,69,82,61,99,108,97,110,103,45,51,46,55,46,48,0,68,73,83,65,66,76,69,95,76,70,83,0,69,78,65,66,76,69,95,70,84,83,51,0,69,78,65,66,76,69,95,70,84,83,51,95,80,65,82,69,78,84,72,69,83,73,83,0,73,78,84,54,52,95,84,89,80,69,0,79,77,73,84,95,76,79,65,68,95,69,88,84,69,78,83,73,79,78,0,83,89,83,84,69,77,95,77,65,76,76,79,67,0,84,72,82,69,65,68,83,65,70,69,61,48,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,47,112,114,111,99,47,115,101,108,102,47,102,100,47], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+40960);





/* no memory initializer */
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

}

function copyTempDouble(ptr) {

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];

  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];

  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];

  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];

}

// {{PRE_LIBRARY}}


   
  Module["_i64Subtract"] = _i64Subtract;

  var _DtoILow=true;

   
  Module["_i64Add"] = _i64Add;

  
  
  
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};
  
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  
  function ___setErrNo(value) {
      if (Module['___errno_location']) HEAP32[((Module['___errno_location']())>>2)]=value;
      return value;
    }
  
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            return ''; // an invalid portion invalidates the whole thing
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          stream.tty.ops.flush(stream.tty);
        },flush:function (stream) {
          stream.tty.ops.flush(stream.tty);
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              // we will read data by chunks of BUFSIZE
              var BUFSIZE = 256;
              var buf = new Buffer(BUFSIZE);
              var bytesRead = 0;
  
              var fd = process.stdin.fd;
              // Linux and Mac cannot use process.stdin.fd (which isn't set up as sync)
              var usingDevice = false;
              try {
                fd = fs.openSync('/dev/stdin', 'r');
                usingDevice = true;
              } catch (e) {}
  
              bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, null);
  
              if (usingDevice) { fs.closeSync(fd); }
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString('utf-8');
              } else {
                result = null;
              }
  
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val); // val == 0 would cut text output off in the middle.
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val);
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }}};
  
  var MEMFS={ops_table:null,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap,
                msync: MEMFS.stream_ops.msync
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            }
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.usedBytes = 0; // The actual number of bytes used in the typed array, as opposed to contents.buffer.byteLength which gives the whole capacity.
          // When the byte data of the file is populated, this will point to either a typed array, or a normal JS array. Typed arrays are preferred
          // for performance, and used by default. However, typed arrays are not resizable like normal JS arrays are, so there is a small disk size
          // penalty involved for appending file writes that continuously grow a file similar to std::vector capacity vs used -scheme.
          node.contents = null; 
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },getFileDataAsRegularArray:function (node) {
        if (node.contents && node.contents.subarray) {
          var arr = [];
          for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
          return arr; // Returns a copy of the original data.
        }
        return node.contents; // No-op, the file contents are already in a JS array. Return as-is.
      },getFileDataAsTypedArray:function (node) {
        if (!node.contents) return new Uint8Array;
        if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes); // Make sure to not return excess unused bytes.
        return new Uint8Array(node.contents);
      },expandFileStorage:function (node, newCapacity) {
        // If we are asked to expand the size of a file that already exists, revert to using a standard JS array to store the file
        // instead of a typed array. This makes resizing the array more flexible because we can just .push() elements at the back to
        // increase the size.
        if (node.contents && node.contents.subarray && newCapacity > node.contents.length) {
          node.contents = MEMFS.getFileDataAsRegularArray(node);
          node.usedBytes = node.contents.length; // We might be writing to a lazy-loaded file which had overridden this property, so force-reset it.
        }
  
        if (!node.contents || node.contents.subarray) { // Keep using a typed array if creating a new storage, or if old one was a typed array as well.
          var prevCapacity = node.contents ? node.contents.buffer.byteLength : 0;
          if (prevCapacity >= newCapacity) return; // No need to expand, the storage was already large enough.
          // Don't expand strictly to the given requested limit if it's only a very small increase, but instead geometrically grow capacity.
          // For small filesizes (<1MB), perform size*2 geometric increase, but for large sizes, do a much more conservative size*1.125 increase to
          // avoid overshooting the allocation cap by a very large margin.
          var CAPACITY_DOUBLING_MAX = 1024 * 1024;
          newCapacity = Math.max(newCapacity, (prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2.0 : 1.125)) | 0);
          if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256); // At minimum allocate 256b for each file when expanding.
          var oldContents = node.contents;
          node.contents = new Uint8Array(newCapacity); // Allocate new storage.
          if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0); // Copy old data over to the new storage.
          return;
        }
        // Not using a typed array to back the file storage. Use a standard JS array instead.
        if (!node.contents && newCapacity > 0) node.contents = [];
        while (node.contents.length < newCapacity) node.contents.push(0);
      },resizeFileStorage:function (node, newSize) {
        if (node.usedBytes == newSize) return;
        if (newSize == 0) {
          node.contents = null; // Fully decommit when requesting a resize to zero.
          node.usedBytes = 0;
          return;
        }
        if (!node.contents || node.contents.subarray) { // Resize a typed array if that is being used as the backing store.
          var oldContents = node.contents;
          node.contents = new Uint8Array(new ArrayBuffer(newSize)); // Allocate new storage.
          if (oldContents) {
            node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes))); // Copy old data over to the new storage.
          }
          node.usedBytes = newSize;
          return;
        }
        // Backing with a JS array.
        if (!node.contents) node.contents = [];
        if (node.contents.length > newSize) node.contents.length = newSize;
        else while (node.contents.length < newSize) node.contents.push(0);
        node.usedBytes = newSize;
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes) return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          if (!length) return 0;
          var node = stream.node;
          node.timestamp = Date.now();
  
          if (buffer.subarray && (!node.contents || node.contents.subarray)) { // This write is from a typed array to a typed array?
            if (canOwn) { // Can we just reuse the buffer we are given?
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) { // If this is a simple first write to an empty file, do a fast set since we don't need to care about old data.
              node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) { // Writing to an already allocated and used subrange of the file?
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
  
          // Appending to an existing file and we need to reallocate, or source data did not come as a typed array.
          MEMFS.expandFileStorage(node, position+length);
          if (node.contents.subarray && buffer.subarray) node.contents.set(buffer.subarray(offset, offset + length), position); // Use typed array write if available.
          else {
            for (var i = 0; i < length; i++) {
             node.contents[position + i] = buffer[offset + i]; // Or fall back to manual write if not.
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position+length);
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < stream.node.usedBytes) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        },msync:function (stream, buffer, offset, length, mmapFlags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          if (mmapFlags & 2) {
            // MAP_PRIVATE calls need not to be synced back to underlying fs
            return 0;
          }
  
          var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          // should we check if bytesWritten and length are the same?
          return 0;
        }}};
  
  var IDBFS={dbs:{},indexedDB:function () {
        if (typeof indexedDB !== 'undefined') return indexedDB;
        var ret = null;
        if (typeof window === 'object') ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
        assert(ret, 'IDBFS used, but indexedDB not supported');
        return ret;
      },DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        // reuse all of the core MEMFS functionality
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
  
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
  
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
  
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },getDB:function (name, callback) {
        // check the cache first
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
  
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return callback(e);
        }
        req.onupgradeneeded = function(e) {
          var db = e.target.result;
          var transaction = e.target.transaction;
  
          var fileStore;
  
          if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
            fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
          } else {
            fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
          }
  
          if (!fileStore.indexNames.contains('timestamp')) {
            fileStore.createIndex('timestamp', 'timestamp', { unique: false });
          }
        };
        req.onsuccess = function() {
          db = req.result;
  
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },getLocalSet:function (mount, callback) {
        var entries = {};
  
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
  
        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));
  
        while (check.length) {
          var path = check.pop();
          var stat;
  
          try {
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
  
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
          }
  
          entries[path] = { timestamp: stat.mtime };
        }
  
        return callback(null, { type: 'local', entries: entries });
      },getRemoteSet:function (mount, callback) {
        var entries = {};
  
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
  
          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function(e) {
            callback(this.error);
            e.preventDefault();
          };
  
          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          var index = store.index('timestamp');
  
          index.openKeyCursor().onsuccess = function(event) {
            var cursor = event.target.result;
  
            if (!cursor) {
              return callback(null, { type: 'remote', db: db, entries: entries });
            }
  
            entries[cursor.primaryKey] = { timestamp: cursor.key };
  
            cursor.continue();
          };
        });
      },loadLocalEntry:function (path, callback) {
        var stat, node;
  
        try {
          var lookup = FS.lookupPath(path);
          node = lookup.node;
          stat = FS.stat(path);
        } catch (e) {
          return callback(e);
        }
  
        if (FS.isDir(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode });
        } else if (FS.isFile(stat.mode)) {
          // Performance consideration: storing a normal JavaScript array to a IndexedDB is much slower than storing a typed array.
          // Therefore always convert the file contents to a typed array first before writing the data to IndexedDB.
          node.contents = MEMFS.getFileDataAsTypedArray(node);
          return callback(null, { timestamp: stat.mtime, mode: stat.mode, contents: node.contents });
        } else {
          return callback(new Error('node type not supported'));
        }
      },storeLocalEntry:function (path, entry, callback) {
        try {
          if (FS.isDir(entry.mode)) {
            FS.mkdir(path, entry.mode);
          } else if (FS.isFile(entry.mode)) {
            FS.writeFile(path, entry.contents, { encoding: 'binary', canOwn: true });
          } else {
            return callback(new Error('node type not supported'));
          }
  
          FS.chmod(path, entry.mode);
          FS.utime(path, entry.timestamp, entry.timestamp);
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },removeLocalEntry:function (path, callback) {
        try {
          var lookup = FS.lookupPath(path);
          var stat = FS.stat(path);
  
          if (FS.isDir(stat.mode)) {
            FS.rmdir(path);
          } else if (FS.isFile(stat.mode)) {
            FS.unlink(path);
          }
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },loadRemoteEntry:function (store, path, callback) {
        var req = store.get(path);
        req.onsuccess = function(event) { callback(null, event.target.result); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },storeRemoteEntry:function (store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },removeRemoteEntry:function (store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },reconcile:function (src, dst, callback) {
        var total = 0;
  
        var create = [];
        Object.keys(src.entries).forEach(function (key) {
          var e = src.entries[key];
          var e2 = dst.entries[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create.push(key);
            total++;
          }
        });
  
        var remove = [];
        Object.keys(dst.entries).forEach(function (key) {
          var e = dst.entries[key];
          var e2 = src.entries[key];
          if (!e2) {
            remove.push(key);
            total++;
          }
        });
  
        if (!total) {
          return callback(null);
        }
  
        var errored = false;
        var completed = 0;
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= total) {
            return callback(null);
          }
        };
  
        transaction.onerror = function(e) {
          done(this.error);
          e.preventDefault();
        };
  
        // sort paths in ascending order so directory entries are created
        // before the files inside them
        create.sort().forEach(function (path) {
          if (dst.type === 'local') {
            IDBFS.loadRemoteEntry(store, path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeLocalEntry(path, entry, done);
            });
          } else {
            IDBFS.loadLocalEntry(path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeRemoteEntry(store, path, entry, done);
            });
          }
        });
  
        // sort paths in descending order so files are deleted before their
        // parent directories
        remove.sort().reverse().forEach(function(path) {
          if (dst.type === 'local') {
            IDBFS.removeLocalEntry(path, done);
          } else {
            IDBFS.removeRemoteEntry(store, path, done);
          }
        });
      }};
  
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        flags &= ~0100000 /*O_LARGEFILE*/; // Ignore this flag from musl, otherwise node.js fails to open the file.
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            path = fs.readlinkSync(path);
            path = NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root), path);
            return path;
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          if (length === 0) return 0; // node errors on 0 length reads
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
  
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
  
          return position;
        }}};
  
  var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:function (mount) {
        assert(ENVIRONMENT_IS_WORKER);
        if (!WORKERFS.reader) WORKERFS.reader = new FileReaderSync();
        var root = WORKERFS.createNode(null, '/', WORKERFS.DIR_MODE, 0);
        var createdParents = {};
        function ensureParent(path) {
          // return the parent node, creating subdirs as necessary
          var parts = path.split('/');
          var parent = root;
          for (var i = 0; i < parts.length-1; i++) {
            var curr = parts.slice(0, i+1).join('/');
            if (!createdParents[curr]) {
              createdParents[curr] = WORKERFS.createNode(parent, curr, WORKERFS.DIR_MODE, 0);
            }
            parent = createdParents[curr];
          }
          return parent;
        }
        function base(path) {
          var parts = path.split('/');
          return parts[parts.length-1];
        }
        // We also accept FileList here, by using Array.prototype
        Array.prototype.forEach.call(mount.opts["files"] || [], function(file) {
          WORKERFS.createNode(ensureParent(file.name), base(file.name), WORKERFS.FILE_MODE, 0, file, file.lastModifiedDate);
        });
        (mount.opts["blobs"] || []).forEach(function(obj) {
          WORKERFS.createNode(ensureParent(obj["name"]), base(obj["name"]), WORKERFS.FILE_MODE, 0, obj["data"]);
        });
        (mount.opts["packages"] || []).forEach(function(pack) {
          pack['metadata'].files.forEach(function(file) {
            var name = file.filename.substr(1); // remove initial slash
            WORKERFS.createNode(ensureParent(name), base(name), WORKERFS.FILE_MODE, 0, pack['blob'].slice(file.start, file.end));
          });
        });
        return root;
      },createNode:function (parent, name, mode, dev, contents, mtime) {
        var node = FS.createNode(parent, name, mode);
        node.mode = mode;
        node.node_ops = WORKERFS.node_ops;
        node.stream_ops = WORKERFS.stream_ops;
        node.timestamp = (mtime || new Date).getTime();
        assert(WORKERFS.FILE_MODE !== WORKERFS.DIR_MODE);
        if (mode === WORKERFS.FILE_MODE) {
          node.size = contents.size;
          node.contents = contents;
        } else {
          node.size = 4096;
          node.contents = {};
        }
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },node_ops:{getattr:function (node) {
          return {
            dev: 1,
            ino: undefined,
            mode: node.mode,
            nlink: 1,
            uid: 0,
            gid: 0,
            rdev: undefined,
            size: node.size,
            atime: new Date(node.timestamp),
            mtime: new Date(node.timestamp),
            ctime: new Date(node.timestamp),
            blksize: 4096,
            blocks: Math.ceil(node.size / 4096),
          };
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
        },lookup:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        },mknod:function (parent, name, mode, dev) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rename:function (oldNode, newDir, newName) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },unlink:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rmdir:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readdir:function (node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },symlink:function (parent, newName, oldPath) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readlink:function (node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          if (position >= stream.node.size) return 0;
          var chunk = stream.node.contents.slice(position, position + length);
          var ab = WORKERFS.reader.readAsArrayBuffer(chunk);
          buffer.set(new Uint8Array(ab), offset);
          return chunk.size;
        },write:function (stream, buffer, offset, length, position) {
          throw new FS.ErrnoError(ERRNO_CODES.EIO);
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.size;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        }}};
  
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};
  
        if (!path) return { path: '', node: null };
  
        var defaults = {
          follow_mount: true,
          recurse_count: 0
        };
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key];
          }
        }
  
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
  
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
  
        // start at the root
        var current = FS.root;
        var current_path = '/';
  
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
  
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
  
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            if (!islast || (islast && opts.follow_mount)) {
              current = current.mounted.root;
            }
          }
  
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
  
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
  
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
  
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
  
  
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err, parent);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            this.mounted = null;
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
          };
  
          FS.FSNode.prototype = {};
  
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
  
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); }
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); }
            }
          });
        }
  
        var node = new FS.FSNode(parent, name, mode, rdev);
  
        FS.hashAddNode(node);
  
        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return !!node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var perms = ['r', 'w', 'rw'][flag & 3];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        var err = FS.nodePermissions(dir, 'x');
        if (err) return err;
        if (!dir.node_ops.lookup) return ERRNO_CODES.EACCES;
        return 0;
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        // clone it, so we can return an instance of FSStream
        var newStream = new FS.FSStream();
        for (var p in stream) {
          newStream[p] = stream[p];
        }
        stream = newStream;
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },getMounts:function (mount) {
        var mounts = [];
        var check = [mount];
  
        while (check.length) {
          var m = check.pop();
  
          mounts.push(m);
  
          check.push.apply(check, m.mounts);
        }
  
        return mounts;
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
  
        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= mounts.length) {
            callback(null);
          }
        };
  
        // sync all mounts
        mounts.forEach(function (mount) {
          if (!mount.type.syncfs) {
            return done(null);
          }
          mount.type.syncfs(mount, populate, done);
        });
      },mount:function (type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;
  
        if (root && FS.root) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
          mountpoint = lookup.path;  // use the absolute path
          node = lookup.node;
  
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
          }
  
          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
          }
        }
  
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          mounts: []
        };
  
        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;
  
        if (root) {
          FS.root = mountRoot;
        } else if (node) {
          // set as a mountpoint
          node.mounted = mount;
  
          // add the new mount to the current mount's children
          if (node.mount) {
            node.mount.mounts.push(mount);
          }
        }
  
        return mountRoot;
      },unmount:function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
  
        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);
  
        Object.keys(FS.nameTable).forEach(function (hash) {
          var current = FS.nameTable[hash];
  
          while (current) {
            var next = current.name_next;
  
            if (mounts.indexOf(current.mount) !== -1) {
              FS.destroyNode(current);
            }
  
            current = next;
          }
        });
  
        // no longer a mountpoint
        node.mounted = null;
  
        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1);
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        if (!name || name === '.' || name === '..') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 438 /* 0666 */;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        if (!PATH.resolve(oldpath)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        if (!parent) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        if (!old_dir || !new_dir) throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        try {
          if (FS.trackingDelegate['willMovePath']) {
            FS.trackingDelegate['willMovePath'](old_path, new_path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
        try {
          if (FS.trackingDelegate['onMovePath']) FS.trackingDelegate['onMovePath'](old_path, new_path);
        } catch(e) {
          console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readlink:function (path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return PATH.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        if (path === "") {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        var created = false;
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
            created = true;
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // if asked only for a directory, then this must be one
        if ((flags & 65536) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        // check permissions, if this is not a file we just created now (it is ok to
        // create and write to a file with read-only permissions; it is read-only
        // for later use)
        if (!created) {
          var err = FS.mayOpen(node, flags);
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
  
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        try {
          if (FS.trackingDelegate['onOpenFile']) {
            var trackingFlags = 0;
            if ((flags & 2097155) !== 1) {
              trackingFlags |= FS.tracking.openFlags.READ;
            }
            if ((flags & 2097155) !== 0) {
              trackingFlags |= FS.tracking.openFlags.WRITE;
            }
            FS.trackingDelegate['onOpenFile'](path, trackingFlags);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: " + e.message);
        }
        return stream;
      },close:function (stream) {
        if (stream.getdents) stream.getdents = null; // free readdir state
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence);
        stream.ungotten = [];
        return stream.position;
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        try {
          if (stream.path && FS.trackingDelegate['onWriteToFile']) FS.trackingDelegate['onWriteToFile'](stream.path);
        } catch(e) {
          console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: " + e.message);
        }
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },msync:function (stream, buffer, offset, length, mmapFlags) {
        if (!stream || !stream.stream_ops.msync) {
          return 0;
        }
        return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
      },munmap:function (stream) {
        return 0;
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = UTF8ArrayToString(buf, 0);
        } else if (opts.encoding === 'binary') {
          ret = buf;
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var buf = new Uint8Array(lengthBytesUTF8(data)+1);
          var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
          FS.write(stream, buf, 0, actualNumBytes, 0, opts.canOwn);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0, opts.canOwn);
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
        FS.mkdir('/home');
        FS.mkdir('/home/web_user');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function(stream, buffer, offset, length, pos) { return length; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // setup /dev/[u]random
        var random_device;
        if (typeof crypto !== 'undefined') {
          // for modern web browsers
          var randomBuffer = new Uint8Array(1);
          random_device = function() { crypto.getRandomValues(randomBuffer); return randomBuffer[0]; };
        } else if (ENVIRONMENT_IS_NODE) {
          // for nodejs
          random_device = function() { return require('crypto').randomBytes(1)[0]; };
        } else {
          // default for ES5 platforms
          random_device = function() { return (Math.random()*256)|0; };
        }
        FS.createDevice('/dev', 'random', random_device);
        FS.createDevice('/dev', 'urandom', random_device);
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createSpecialDirectories:function () {
        // create /proc/self/fd which allows /proc/self/fd/6 => readlink gives the name of the stream for fd 6 (see test_unistd_ttyname)
        FS.mkdir('/proc');
        FS.mkdir('/proc/self');
        FS.mkdir('/proc/self/fd');
        FS.mount({
          mount: function() {
            var node = FS.createNode('/proc/self', 'fd', 16384 | 0777, 73);
            node.node_ops = {
              lookup: function(parent, name) {
                var fd = +name;
                var stream = FS.getStream(fd);
                if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
                var ret = {
                  parent: null,
                  mount: { mountpoint: 'fake' },
                  node_ops: { readlink: function() { return stream.path } }
                };
                ret.parent = ret; // make it look like a simple root node
                return ret;
              }
            };
            return node;
          }
        }, {}, '/proc/self/fd');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
  
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
  
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        assert(stdin.fd === 0, 'invalid handle for stdin (' + stdin.fd + ')');
  
        var stdout = FS.open('/dev/stdout', 'w');
        assert(stdout.fd === 1, 'invalid handle for stdout (' + stdout.fd + ')');
  
        var stderr = FS.open('/dev/stderr', 'w');
        assert(stderr.fd === 2, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno, node) {
          //Module.printErr(stackTrace()); // useful for debugging
          this.node = node;
          this.setErrno = function(errno) {
            this.errno = errno;
            for (var key in ERRNO_CODES) {
              if (ERRNO_CODES[key] === errno) {
                this.code = key;
                break;
              }
            }
          };
          this.setErrno(errno);
          this.message = ERRNO_MESSAGES[errno];
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
  
        FS.nameTable = new Array(4096);
  
        FS.mount(MEMFS, {}, '/');
  
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
        FS.createSpecialDirectories();
  
        FS.filesystems = {
          'MEMFS': MEMFS,
          'IDBFS': IDBFS,
          'NODEFS': NODEFS,
          'WORKERFS': WORKERFS,
        };
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
  
        FS.ensureErrnoError();
  
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
  
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        // force-flush all streams, so we get musl std streams printed out
        var fflush = Module['_fflush'];
        if (fflush) fflush(0);
        // close all of our streams
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
            obj.usedBytes = obj.contents.length;
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
        function LazyUint8Array() {
          this.lengthKnown = false;
          this.chunks = []; // Loaded chunks. Index is the chunk number
        }
        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
          if (idx > this.length-1 || idx < 0) {
            return undefined;
          }
          var chunkOffset = idx % this.chunkSize;
          var chunkNum = (idx / this.chunkSize)|0;
          return this.getter(chunkNum)[chunkOffset];
        }
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter;
        }
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var chunkSize = 1024*1024; // Chunk size in bytes
  
          if (!hasByteServing) chunkSize = datalength;
  
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
  
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
  
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
  
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || []);
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
          var lazyArray = this;
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * chunkSize;
            var end = (chunkNum+1) * chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
  
          this._length = datalength;
          this._chunkSize = chunkSize;
          this.lengthKnown = true;
        }
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
  
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
  
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // Add a function that defers querying the file size until it is asked the first time.
        Object.defineProperty(node, "usedBytes", {
            get: function() { return this.contents.length; }
        });
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        var dep = getUniqueRunDependency('cp ' + fullname); // might have several active requests for the same fullname
        function processData(byteArray) {
          function finish(byteArray) {
            if (preFinish) preFinish();
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency(dep);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency(dep);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency(dep);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:function (dirfd, path) {
        if (path[0] !== '/') {
          // relative path
          var dir;
          if (dirfd === -100) {
            dir = FS.cwd();
          } else {
            var dirstream = FS.getStream(dirfd);
            if (!dirstream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
            dir = dirstream.path;
          }
          path = PATH.join2(dir, path);
        }
        return path;
      },doStat:function (func, path, buf) {
        try {
          var stat = func(path);
        } catch (e) {
          if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            // an error occurred while trying to look up the path; we should just report ENOTDIR
            return -ERRNO_CODES.ENOTDIR;
          }
          throw e;
        }
        HEAP32[((buf)>>2)]=stat.dev;
        HEAP32[(((buf)+(4))>>2)]=0;
        HEAP32[(((buf)+(8))>>2)]=stat.ino;
        HEAP32[(((buf)+(12))>>2)]=stat.mode;
        HEAP32[(((buf)+(16))>>2)]=stat.nlink;
        HEAP32[(((buf)+(20))>>2)]=stat.uid;
        HEAP32[(((buf)+(24))>>2)]=stat.gid;
        HEAP32[(((buf)+(28))>>2)]=stat.rdev;
        HEAP32[(((buf)+(32))>>2)]=0;
        HEAP32[(((buf)+(36))>>2)]=stat.size;
        HEAP32[(((buf)+(40))>>2)]=4096;
        HEAP32[(((buf)+(44))>>2)]=stat.blocks;
        HEAP32[(((buf)+(48))>>2)]=(stat.atime.getTime() / 1000)|0;
        HEAP32[(((buf)+(52))>>2)]=0;
        HEAP32[(((buf)+(56))>>2)]=(stat.mtime.getTime() / 1000)|0;
        HEAP32[(((buf)+(60))>>2)]=0;
        HEAP32[(((buf)+(64))>>2)]=(stat.ctime.getTime() / 1000)|0;
        HEAP32[(((buf)+(68))>>2)]=0;
        HEAP32[(((buf)+(72))>>2)]=stat.ino;
        return 0;
      },doMsync:function (addr, stream, len, flags) {
        var buffer = new Uint8Array(HEAPU8.subarray(addr, addr + len));
        FS.msync(stream, buffer, 0, len, flags);
      },doMkdir:function (path, mode) {
        // remove a trailing slash, if one - /a/b/ has basename of '', but
        // we want to create b in the context of this function
        path = PATH.normalize(path);
        if (path[path.length-1] === '/') path = path.substr(0, path.length-1);
        FS.mkdir(path, mode, 0);
        return 0;
      },doMknod:function (path, mode, dev) {
        // we don't want this in the JS API as it uses mknod to create all nodes.
        switch (mode & 61440) {
          case 32768:
          case 8192:
          case 24576:
          case 4096:
          case 49152:
            break;
          default: return -ERRNO_CODES.EINVAL;
        }
        FS.mknod(path, mode, dev);
        return 0;
      },doReadlink:function (path, buf, bufsize) {
        if (bufsize <= 0) return -ERRNO_CODES.EINVAL;
        var ret = FS.readlink(path);
        ret = ret.slice(0, Math.max(0, bufsize));
        writeStringToMemory(ret, buf, true);
        return ret.length;
      },doAccess:function (path, amode) {
        if (amode & ~7) {
          // need a valid mode
          return -ERRNO_CODES.EINVAL;
        }
        var node;
        var lookup = FS.lookupPath(path, { follow: true });
        node = lookup.node;
        var perms = '';
        if (amode & 4) perms += 'r';
        if (amode & 2) perms += 'w';
        if (amode & 1) perms += 'x';
        if (perms /* otherwise, they've just passed F_OK */ && FS.nodePermissions(node, perms)) {
          return -ERRNO_CODES.EACCES;
        }
        return 0;
      },doDup:function (path, flags, suggestFD) {
        var suggest = FS.getStream(suggestFD);
        if (suggest) FS.close(suggest);
        return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
      },doReadv:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.read(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
          if (curr < len) break; // nothing more to read
        }
        return ret;
      },doWritev:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.write(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
        }
        return ret;
      },varargs:0,get:function (varargs) {
        SYSCALLS.varargs += 4;
        var ret = HEAP32[(((SYSCALLS.varargs)-(4))>>2)];
        return ret;
      },getStr:function () {
        var ret = Pointer_stringify(SYSCALLS.get());
        return ret;
      },getStreamFromFD:function () {
        var stream = FS.getStream(SYSCALLS.get());
        if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return stream;
      },getSocketFromFD:function () {
        var socket = SOCKFS.getSocket(SYSCALLS.get());
        if (!socket) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return socket;
      },getSocketAddress:function (allowNull) {
        var addrp = SYSCALLS.get(), addrlen = SYSCALLS.get();
        if (allowNull && addrp === 0) return null;
        var info = __read_sockaddr(addrp, addrlen);
        if (info.errno) throw new FS.ErrnoError(info.errno);
        info.addr = DNS.lookup_addr(info.addr) || info.addr;
        return info;
      },get64:function () {
        var low = SYSCALLS.get(), high = SYSCALLS.get();
        if (low >= 0) assert(high === 0);
        else assert(high === -1);
        return low;
      },getZero:function () {
        assert(SYSCALLS.get() === 0);
      }};function ___syscall192(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // mmap2
      var addr = SYSCALLS.get(), len = SYSCALLS.get(), prot = SYSCALLS.get(), flags = SYSCALLS.get(), fd = SYSCALLS.get(), off = SYSCALLS.get()
      off <<= 12; // undo pgoffset
      var ptr;
      var allocated = false;
      if (fd === -1) {
        ptr = _malloc(len);
        if (!ptr) return -ERRNO_CODES.ENOMEM;
        _memset(ptr, 0, len);
        allocated = true;
      } else {
        var info = FS.getStream(fd);
        if (!info) return -ERRNO_CODES.EBADF;
        var res = FS.mmap(info, HEAPU8, addr, len, off, prot, flags);
        ptr = res.ptr;
        allocated = res.allocated;
      }
      SYSCALLS.mappings[ptr] = { malloc: ptr, len: len, allocated: allocated, fd: fd, flags: flags };
      return ptr;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall195(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // SYS_stat64
      var path = SYSCALLS.getStr(), buf = SYSCALLS.get();
      return SYSCALLS.doStat(FS.stat, path, buf);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall194(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // ftruncate64
      var fd = SYSCALLS.get(), zero = SYSCALLS.getZero(), length = SYSCALLS.get64();
      FS.ftruncate(fd, length);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall197(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // SYS_fstat64
      var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get();
      return SYSCALLS.doStat(FS.stat, stream.path, buf);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall196(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // SYS_lstat64
      var path = SYSCALLS.getStr(), buf = SYSCALLS.get();
      return SYSCALLS.doStat(FS.lstat, path, buf);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  
  var EmterpreterAsync=undefined;function ___syscall118(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // fsync
      var stream = SYSCALLS.getStreamFromFD();
      return 0; // we can't do anything synchronously; the in-memory FS is already synced to
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 85: return totalMemory / PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 79:
          return 0;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: {
          if (typeof navigator === 'object') return navigator['hardwareConcurrency'] || 1;
          return 1;
        }
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }

  
  function _usleep(useconds) {
      // int usleep(useconds_t useconds);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/usleep.html
      // We're single-threaded, so use a busy loop. Super-ugly.
      var msec = useconds / 1000;
      if ((ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) && self['performance'] && self['performance']['now']) {
        var start = self['performance']['now']();
        while (self['performance']['now']() - start < msec) {
          // Do nothing.
        }
      } else {
        var start = Date.now();
        while (Date.now() - start < msec) {
          // Do nothing.
        }
      }
      return 0;
    }
  Module["_usleep"] = _usleep;function _nanosleep(rqtp, rmtp) {
      // int nanosleep(const struct timespec  *rqtp, struct timespec *rmtp);
      var seconds = HEAP32[((rqtp)>>2)];
      var nanoseconds = HEAP32[(((rqtp)+(4))>>2)];
      if (rmtp !== 0) {
        HEAP32[((rmtp)>>2)]=0;
        HEAP32[(((rmtp)+(4))>>2)]=0;
      }
      return _usleep((seconds * 1e6) + (nanoseconds / 1000));
    }

  function ___syscall94(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // fchmod
      var fd = SYSCALLS.get(), mode = SYSCALLS.get();
      FS.fchmod(fd, mode);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall91(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // munmap
      var addr = SYSCALLS.get(), len = SYSCALLS.get();
      // TODO: support unmmap'ing parts of allocations
      var info = SYSCALLS.mappings[addr];
      if (!info) return 0;
      if (len === info.len) {
        var stream = FS.getStream(info.fd);
        SYSCALLS.doMsync(addr, stream, len, info.flags)
        FS.munmap(stream);
        SYSCALLS.mappings[addr] = null;
        if (info.allocated) {
          _free(info.malloc);
        }
      }
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall212(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // chown32
      var path = SYSCALLS.getStr(), owner = SYSCALLS.get(), group = SYSCALLS.get();
      FS.chown(path, owner, group);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall54(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // ioctl
      var stream = SYSCALLS.getStreamFromFD(), op = SYSCALLS.get();
      switch (op) {
        case 21505: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0;
        }
        case 21506: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0; // no-op, not actually adjusting terminal settings
        }
        case 21519: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          var argp = SYSCALLS.get();
          HEAP32[((argp)>>2)]=0;
          return 0;
        }
        case 21520: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return -ERRNO_CODES.EINVAL; // not supported
        }
        case 21531: {
          var argp = SYSCALLS.get();
          return FS.ioctl(stream, op, argp);
        }
        default: abort('bad ioctl syscall ' + op);
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  
  var ___tm_current=allocate(44, "i8", ALLOC_STATIC);
  
  
  var ___tm_timezone=allocate(intArrayFromString("GMT"), "i8", ALLOC_STATIC);
  
  
  var _tzname=allocate(8, "i32*", ALLOC_STATIC);
  
  var _daylight=allocate(1, "i32*", ALLOC_STATIC);
  
  var _timezone=allocate(1, "i32*", ALLOC_STATIC);function _tzset() {
      // TODO: Use (malleable) environment variables instead of system settings.
      if (_tzset.called) return;
      _tzset.called = true;
  
      HEAP32[((_timezone)>>2)]=-(new Date()).getTimezoneOffset() * 60;
  
      var winter = new Date(2000, 0, 1);
      var summer = new Date(2000, 6, 1);
      HEAP32[((_daylight)>>2)]=Number(winter.getTimezoneOffset() != summer.getTimezoneOffset());
  
      function extractZone(date) {
        var match = date.toTimeString().match(/\(([A-Za-z ]+)\)$/);
        return match ? match[1] : "GMT";
      };
      var winterName = extractZone(winter);
      var summerName = extractZone(summer);
      var winterNamePtr = allocate(intArrayFromString(winterName), 'i8', ALLOC_NORMAL);
      var summerNamePtr = allocate(intArrayFromString(summerName), 'i8', ALLOC_NORMAL);
      if (summer.getTimezoneOffset() < winter.getTimezoneOffset()) {
        // Northern hemisphere
        HEAP32[((_tzname)>>2)]=winterNamePtr;
        HEAP32[(((_tzname)+(4))>>2)]=summerNamePtr;
      } else {
        HEAP32[((_tzname)>>2)]=summerNamePtr;
        HEAP32[(((_tzname)+(4))>>2)]=winterNamePtr;
      }
    }function _localtime_r(time, tmPtr) {
      _tzset();
      var date = new Date(HEAP32[((time)>>2)]*1000);
      HEAP32[((tmPtr)>>2)]=date.getSeconds();
      HEAP32[(((tmPtr)+(4))>>2)]=date.getMinutes();
      HEAP32[(((tmPtr)+(8))>>2)]=date.getHours();
      HEAP32[(((tmPtr)+(12))>>2)]=date.getDate();
      HEAP32[(((tmPtr)+(16))>>2)]=date.getMonth();
      HEAP32[(((tmPtr)+(20))>>2)]=date.getFullYear()-1900;
      HEAP32[(((tmPtr)+(24))>>2)]=date.getDay();
  
      var start = new Date(date.getFullYear(), 0, 1);
      var yday = ((date.getTime() - start.getTime()) / (1000 * 60 * 60 * 24))|0;
      HEAP32[(((tmPtr)+(28))>>2)]=yday;
      HEAP32[(((tmPtr)+(36))>>2)]=-(date.getTimezoneOffset() * 60);
  
      // DST is in December in South
      var summerOffset = new Date(2000, 6, 1).getTimezoneOffset();
      var winterOffset = start.getTimezoneOffset();
      var dst = (date.getTimezoneOffset() == Math.min(winterOffset, summerOffset))|0;
      HEAP32[(((tmPtr)+(32))>>2)]=dst;
  
      var zonePtr = HEAP32[(((_tzname)+(dst ? Runtime.QUANTUM_SIZE : 0))>>2)];
      HEAP32[(((tmPtr)+(40))>>2)]=zonePtr;
  
      return tmPtr;
    }function _localtime(time) {
      return _localtime_r(time, ___tm_current);
    }

   
  Module["_bitshift64Lshr"] = _bitshift64Lshr;

  function ___syscall33(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // access
      var path = SYSCALLS.getStr(), amode = SYSCALLS.get();
      return SYSCALLS.doAccess(path, amode);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _BDtoIHigh=true;

  function _pthread_cleanup_push(routine, arg) {
      __ATEXIT__.push(function() { Runtime.dynCall('vi', routine, [arg]) })
      _pthread_cleanup_push.level = __ATEXIT__.length;
    }

  
  
  
  
  var _environ=allocate(1, "i32*", ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;
  
      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = ENV['LOGNAME'] = 'web_user';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/web_user';
        ENV['LANG'] = 'C';
        ENV['_'] = Module['thisProgram'];
        // Allocate memory.
        poolPtr = allocate(TOTAL_ENV_SIZE, 'i8', ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4,
                          'i8*', ALLOC_STATIC);
        HEAP32[((envPtr)>>2)]=poolPtr;
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }
  
      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }
  
      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        writeAsciiToMemory(line, poolPtr);
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;
  
      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocate(intArrayFromString(ENV[name]), 'i8', ALLOC_NORMAL);
      return _getenv.ret;
    }

  function _gettimeofday(ptr) {
      var now = Date.now();
      HEAP32[((ptr)>>2)]=(now/1000)|0; // seconds
      HEAP32[(((ptr)+(4))>>2)]=((now % 1000)*1000)|0; // microseconds
      return 0;
    }

  
  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    } 
  Module["_memcpy"] = _memcpy;

  var _llvm_pow_f64=Math_pow;

  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) {
        var success = self.alloc(bytes);
        if (!success) return -1 >>> 0; // sbrk failure code
      }
      return ret;  // Previous break location.
    }

   
  Module["_memmove"] = _memmove;

  var _BItoD=true;

  function ___syscall85(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // readlink
      var path = SYSCALLS.getStr(), buf = SYSCALLS.get(), bufsize = SYSCALLS.get();
      return SYSCALLS.doReadlink(path, buf, bufsize);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall207(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // fchown32
      var fd = SYSCALLS.get(), owner = SYSCALLS.get(), group = SYSCALLS.get();
      FS.fchown(fd, owner, group);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  
  function ___syscall202(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // getgid32
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }function ___syscall201() {
  return ___syscall202.apply(null, arguments)
  }

  function ___syscall40(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // rmdir
      var path = SYSCALLS.getStr();
      FS.rmdir(path);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___assert_fail(condition, filename, line, func) {
      ABORT = true;
      throw 'Assertion failed: ' + Pointer_stringify(condition) + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + stackTrace();
    }

  
  var PROCINFO={ppid:1,pid:42,sid:42,pgid:42};function ___syscall20(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // getpid
      return PROCINFO.pid;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _acos=Math_acos;

   
  Module["_memset"] = _memset;

  var _BDtoILow=true;

  function ___syscall39(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // mkdir
      var path = SYSCALLS.getStr(), mode = SYSCALLS.get();
      return SYSCALLS.doMkdir(path, mode);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _DtoIHigh=true;

   
  Module["_bitshift64Shl"] = _bitshift64Shl;

  function _abort() {
      Module['abort']();
    }

  var _tan=Math_tan;

  function ___lock() {}

  function ___unlock() {}

  var _asin=Math_asin;

  var _floor=Math_floor;

  var _sqrt=Math_sqrt;

  
  
  function _emscripten_set_main_loop_timing(mode, value) {
      Browser.mainLoop.timingMode = mode;
      Browser.mainLoop.timingValue = value;
  
      if (!Browser.mainLoop.func) {
        return 1; // Return non-zero on failure, can't set timing mode when there is no main loop.
      }
  
      if (mode == 0 /*EM_TIMING_SETTIMEOUT*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setTimeout() {
          setTimeout(Browser.mainLoop.runner, value); // doing this each time means that on exception, we stop
        };
        Browser.mainLoop.method = 'timeout';
      } else if (mode == 1 /*EM_TIMING_RAF*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_rAF() {
          Browser.requestAnimationFrame(Browser.mainLoop.runner);
        };
        Browser.mainLoop.method = 'rAF';
      } else if (mode == 2 /*EM_TIMING_SETIMMEDIATE*/) {
        if (!window['setImmediate']) {
          // Emulate setImmediate. (note: not a complete polyfill, we don't emulate clearImmediate() to keep code size to minimum, since not needed)
          var setImmediates = [];
          var emscriptenMainLoopMessageId = '__emcc';
          function Browser_setImmediate_messageHandler(event) {
            if (event.source === window && event.data === emscriptenMainLoopMessageId) {
              event.stopPropagation();
              setImmediates.shift()();
            }
          }
          window.addEventListener("message", Browser_setImmediate_messageHandler, true);
          window['setImmediate'] = function Browser_emulated_setImmediate(func) {
            setImmediates.push(func);
            window.postMessage(emscriptenMainLoopMessageId, "*");
          }
        }
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setImmediate() {
          window['setImmediate'](Browser.mainLoop.runner);
        };
        Browser.mainLoop.method = 'immediate';
      }
      return 0;
    }function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg, noSetTiming) {
      Module['noExitRuntime'] = true;
  
      assert(!Browser.mainLoop.func, 'emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.');
  
      Browser.mainLoop.func = func;
      Browser.mainLoop.arg = arg;
  
      var thisMainLoopId = Browser.mainLoop.currentlyRunningMainloop;
  
      Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
          var start = Date.now();
          var blocker = Browser.mainLoop.queue.shift();
          blocker.func(blocker.arg);
          if (Browser.mainLoop.remainingBlockers) {
            var remaining = Browser.mainLoop.remainingBlockers;
            var next = remaining%1 == 0 ? remaining-1 : Math.floor(remaining);
            if (blocker.counted) {
              Browser.mainLoop.remainingBlockers = next;
            } else {
              // not counted, but move the progress along a tiny bit
              next = next + 0.5; // do not steal all the next one's progress
              Browser.mainLoop.remainingBlockers = (8*remaining + next)/9;
            }
          }
          console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + ' ms'); //, left: ' + Browser.mainLoop.remainingBlockers);
          Browser.mainLoop.updateStatus();
          setTimeout(Browser.mainLoop.runner, 0);
          return;
        }
  
        // catch pauses from non-main loop sources
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Implement very basic swap interval control
        Browser.mainLoop.currentFrameNumber = Browser.mainLoop.currentFrameNumber + 1 | 0;
        if (Browser.mainLoop.timingMode == 1/*EM_TIMING_RAF*/ && Browser.mainLoop.timingValue > 1 && Browser.mainLoop.currentFrameNumber % Browser.mainLoop.timingValue != 0) {
          // Not the scheduled time to render this frame - skip.
          Browser.mainLoop.scheduler();
          return;
        }
  
        // Signal GL rendering layer that processing of a new frame is about to start. This helps it optimize
        // VBO double-buffering and reduce GPU stalls.
  
        if (Browser.mainLoop.method === 'timeout' && Module.ctx) {
          Module.printErr('Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!');
          Browser.mainLoop.method = ''; // just warn once per call to set main loop
        }
  
        Browser.mainLoop.runIter(function() {
          if (typeof arg !== 'undefined') {
            Runtime.dynCall('vi', func, [arg]);
          } else {
            Runtime.dynCall('v', func);
          }
        });
  
        // catch pauses from the main loop itself
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Queue new audio data. This is important to be right after the main loop invocation, so that we will immediately be able
        // to queue the newest produced audio samples.
        // TODO: Consider adding pre- and post- rAF callbacks so that GL.newRenderingFrameStarted() and SDL.audio.queueNewAudioData()
        //       do not need to be hardcoded into this function, but can be more generic.
        if (typeof SDL === 'object' && SDL.audio && SDL.audio.queueNewAudioData) SDL.audio.queueNewAudioData();
  
        Browser.mainLoop.scheduler();
      }
  
      if (!noSetTiming) {
        if (fps && fps > 0) _emscripten_set_main_loop_timing(0/*EM_TIMING_SETTIMEOUT*/, 1000.0 / fps);
        else _emscripten_set_main_loop_timing(1/*EM_TIMING_RAF*/, 1); // Do rAF by rendering each frame (no decimating)
  
        Browser.mainLoop.scheduler();
      }
  
      if (simulateInfiniteLoop) {
        throw 'SimulateInfiniteLoop';
      }
    }var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:function () {
          Browser.mainLoop.scheduler = null;
          Browser.mainLoop.currentlyRunningMainloop++; // Incrementing this signals the previous main loop that it's now become old, and it must return.
        },resume:function () {
          Browser.mainLoop.currentlyRunningMainloop++;
          var timingMode = Browser.mainLoop.timingMode;
          var timingValue = Browser.mainLoop.timingValue;
          var func = Browser.mainLoop.func;
          Browser.mainLoop.func = null;
          _emscripten_set_main_loop(func, 0, false, Browser.mainLoop.arg, true /* do not set timing and call scheduler, we will do it on the next lines */);
          _emscripten_set_main_loop_timing(timingMode, timingValue);
          Browser.mainLoop.scheduler();
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        },runIter:function (func) {
          if (ABORT) return;
          if (Module['preMainLoop']) {
            var preRet = Module['preMainLoop']();
            if (preRet === false) {
              return; // |return false| skips a frame
            }
          }
          try {
            func();
          } catch (e) {
            if (e instanceof ExitStatus) {
              return;
            } else {
              if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
              throw e;
            }
          }
          if (Module['postMainLoop']) Module['postMainLoop']();
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
  
        if (Browser.initted) return;
        Browser.initted = true;
  
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
  
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
  
        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
  
        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
  
        // Canvas event setup
  
        var canvas = Module['canvas'];
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas ||
                                document['msPointerLockElement'] === canvas;
        }
        if (canvas) {
          // forced aspect ratio can be enabled by defining 'forcedAspectRatio' on Module
          // Module['forcedAspectRatio'] = 4 / 3;
          
          canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                      canvas['mozRequestPointerLock'] ||
                                      canvas['webkitRequestPointerLock'] ||
                                      canvas['msRequestPointerLock'] ||
                                      function(){};
          canvas.exitPointerLock = document['exitPointerLock'] ||
                                   document['mozExitPointerLock'] ||
                                   document['webkitExitPointerLock'] ||
                                   document['msExitPointerLock'] ||
                                   function(){}; // no-op if function does not exist
          canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
  
  
          document.addEventListener('pointerlockchange', pointerLockChange, false);
          document.addEventListener('mozpointerlockchange', pointerLockChange, false);
          document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
          document.addEventListener('mspointerlockchange', pointerLockChange, false);
  
          if (Module['elementPointerLock']) {
            canvas.addEventListener("click", function(ev) {
              if (!Browser.pointerLock && canvas.requestPointerLock) {
                canvas.requestPointerLock();
                ev.preventDefault();
              }
            }, false);
          }
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        if (useWebGL && Module.ctx && canvas == Module.canvas) return Module.ctx; // no need to recreate GL context if it's already been created for this canvas.
  
        var ctx;
        var contextHandle;
        if (useWebGL) {
          // For GLES2/desktop GL compatibility, adjust a few defaults to be different to WebGL defaults, so that they align better with the desktop defaults.
          var contextAttributes = {
            antialias: false,
            alpha: false
          };
  
          if (webGLContextAttributes) {
            for (var attribute in webGLContextAttributes) {
              contextAttributes[attribute] = webGLContextAttributes[attribute];
            }
          }
  
          contextHandle = GL.createContext(canvas, contextAttributes);
          if (contextHandle) {
            ctx = GL.getContext(contextHandle).GLctx;
          }
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
        } else {
          ctx = canvas.getContext('2d');
        }
  
        if (!ctx) return null;
  
        if (setInModule) {
          if (!useWebGL) assert(typeof GLctx === 'undefined', 'cannot set in module if GLctx is used, but we are a non-GL context that would replace it');
  
          Module.ctx = ctx;
          if (useWebGL) GL.makeContextCurrent(contextHandle);
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas, vrDevice) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        Browser.vrDevice = vrDevice;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        if (typeof Browser.vrDevice === 'undefined') Browser.vrDevice = null;
  
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          var canvasContainer = canvas.parentNode;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement'] ||
               document['msFullScreenElement'] || document['msFullscreenElement'] ||
               document['webkitCurrentFullScreenElement']) === canvasContainer) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'] ||
                                      document['msExitFullscreen'] ||
                                      document['exitFullscreen'] ||
                                      function() {};
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else {
            
            // remove the full screen specific parent of the canvas again to restore the HTML structure from before going full screen
            canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
            canvasContainer.parentNode.removeChild(canvasContainer);
            
            if (Browser.resizeCanvas) Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
          Browser.updateCanvasDimensions(canvas);
        }
  
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
          document.addEventListener('MSFullscreenChange', fullScreenChange, false);
        }
  
        // create a new parent to ensure the canvas has no siblings. this allows browsers to optimize full screen performance when its parent is the full screen root
        var canvasContainer = document.createElement("div");
        canvas.parentNode.insertBefore(canvasContainer, canvas);
        canvasContainer.appendChild(canvas);
  
        // use parent of canvas as full screen root to allow aspect ratio correction (Firefox stretches the root to screen size)
        canvasContainer.requestFullScreen = canvasContainer['requestFullScreen'] ||
                                            canvasContainer['mozRequestFullScreen'] ||
                                            canvasContainer['msRequestFullscreen'] ||
                                           (canvasContainer['webkitRequestFullScreen'] ? function() { canvasContainer['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
  
        if (vrDevice) {
          canvasContainer.requestFullScreen({ vrDisplay: vrDevice });
        } else {
          canvasContainer.requestFullScreen();
        }
      },nextRAF:0,fakeRequestAnimationFrame:function (func) {
        // try to keep 60fps between calls to here
        var now = Date.now();
        if (Browser.nextRAF === 0) {
          Browser.nextRAF = now + 1000/60;
        } else {
          while (now + 2 >= Browser.nextRAF) { // fudge a little, to avoid timer jitter causing us to do lots of delay:0
            Browser.nextRAF += 1000/60;
          }
        }
        var delay = Math.max(Browser.nextRAF - now, 0);
        setTimeout(func, delay);
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          Browser.fakeRequestAnimationFrame(func);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           Browser.fakeRequestAnimationFrame;
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:function () {
        Browser.allowAsyncCallbacks = false;
      },resumeAsyncCallbacks:function () { // marks future callbacks as ok to execute, and synchronously runs any remaining ones right now
        Browser.allowAsyncCallbacks = true;
        if (Browser.queuedAsyncCallbacks.length > 0) {
          var callbacks = Browser.queuedAsyncCallbacks;
          Browser.queuedAsyncCallbacks = [];
          callbacks.forEach(function(func) {
            func();
          });
        }
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        });
      },safeSetTimeout:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setTimeout(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setInterval(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } // drop it on the floor otherwise, next interval will kick in
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },getMouseWheelDelta:function (event) {
        var delta = 0;
        switch (event.type) {
          case 'DOMMouseScroll': 
            delta = event.detail;
            break;
          case 'mousewheel': 
            delta = event.wheelDelta;
            break;
          case 'wheel': 
            delta = event['deltaY'];
            break;
          default:
            throw 'unrecognized mouse wheel event: ' + event.type;
        }
        return delta;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
  
          // Neither .scrollX or .pageXOffset are defined in a spec, but
          // we prefer .scrollX because it is currently in a spec draft.
          // (see: http://www.w3.org/TR/2013/WD-cssom-view-20131217/)
          var scrollX = ((typeof window.scrollX !== 'undefined') ? window.scrollX : window.pageXOffset);
          var scrollY = ((typeof window.scrollY !== 'undefined') ? window.scrollY : window.pageYOffset);
  
          if (event.type === 'touchstart' || event.type === 'touchend' || event.type === 'touchmove') {
            var touch = event.touch;
            if (touch === undefined) {
              return; // the "touch" property is only defined in SDL
  
            }
            var adjustedX = touch.pageX - (scrollX + rect.left);
            var adjustedY = touch.pageY - (scrollY + rect.top);
  
            adjustedX = adjustedX * (cw / rect.width);
            adjustedY = adjustedY * (ch / rect.height);
  
            var coords = { x: adjustedX, y: adjustedY };
            
            if (event.type === 'touchstart') {
              Browser.lastTouches[touch.identifier] = coords;
              Browser.touches[touch.identifier] = coords;
            } else if (event.type === 'touchend' || event.type === 'touchmove') {
              var last = Browser.touches[touch.identifier];
              if (!last) last = coords;
              Browser.lastTouches[touch.identifier] = last;
              Browser.touches[touch.identifier] = coords;
            } 
            return;
          }
  
          var x = event.pageX - (scrollX + rect.left);
          var y = event.pageY - (scrollY + rect.top);
  
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
  
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        Browser.updateCanvasDimensions(canvas, width, height);
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },updateCanvasDimensions:function (canvas, wNative, hNative) {
        if (wNative && hNative) {
          canvas.widthNative = wNative;
          canvas.heightNative = hNative;
        } else {
          wNative = canvas.widthNative;
          hNative = canvas.heightNative;
        }
        var w = wNative;
        var h = hNative;
        if (Module['forcedAspectRatio'] && Module['forcedAspectRatio'] > 0) {
          if (w/h < Module['forcedAspectRatio']) {
            w = Math.round(h * Module['forcedAspectRatio']);
          } else {
            h = Math.round(w / Module['forcedAspectRatio']);
          }
        }
        if (((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
             document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
             document['fullScreenElement'] || document['fullscreenElement'] ||
             document['msFullScreenElement'] || document['msFullscreenElement'] ||
             document['webkitCurrentFullScreenElement']) === canvas.parentNode) && (typeof screen != 'undefined')) {
           var factor = Math.min(screen.width / w, screen.height / h);
           w = Math.round(w * factor);
           h = Math.round(h * factor);
        }
        if (Browser.resizeCanvas) {
          if (canvas.width  != w) canvas.width  = w;
          if (canvas.height != h) canvas.height = h;
          if (typeof canvas.style != 'undefined') {
            canvas.style.removeProperty( "width");
            canvas.style.removeProperty("height");
          }
        } else {
          if (canvas.width  != wNative) canvas.width  = wNative;
          if (canvas.height != hNative) canvas.height = hNative;
          if (typeof canvas.style != 'undefined') {
            if (w != wNative || h != hNative) {
              canvas.style.setProperty( "width", w + "px", "important");
              canvas.style.setProperty("height", h + "px", "important");
            } else {
              canvas.style.removeProperty( "width");
              canvas.style.removeProperty("height");
            }
          }
        }
      },wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:function () {
        var handle = Browser.nextWgetRequestHandle;
        Browser.nextWgetRequestHandle++;
        return handle;
      }};

  var _sin=Math_sin;

  var _atan=Math_atan;

  function ___syscall15(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // chmod
      var path = SYSCALLS.getStr(), mode = SYSCALLS.get();
      FS.chmod(path, mode);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall10(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // unlink
      var path = SYSCALLS.getStr();
      FS.unlink(path);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall183(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // getcwd
      var buf = SYSCALLS.get(), size = SYSCALLS.get();
      if (size === 0) return -ERRNO_CODES.EINVAL;
      var cwd = FS.cwd();
      if (size < cwd.length + 1) return -ERRNO_CODES.ERANGE;
      writeAsciiToMemory(cwd, buf);
      return buf;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _SItoD=true;

  function ___syscall3(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // read
      var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get();
      return FS.read(stream, HEAP8,buf, count);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _ceil=Math_ceil;

  function ___syscall5(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // open
      var pathname = SYSCALLS.getStr(), flags = SYSCALLS.get(), mode = SYSCALLS.get() // optional TODO
      var stream = FS.open(pathname, flags, mode);
      return stream.fd;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall4(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // write
      var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get();
      return FS.write(stream, HEAP8,buf, count);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall6(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // close
      var stream = SYSCALLS.getStreamFromFD();
      FS.close(stream);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _cos=Math_cos;

  function _pthread_cleanup_pop() {
      assert(_pthread_cleanup_push.level == __ATEXIT__.length, 'cannot pop if something else added meanwhile!');
      __ATEXIT__.pop();
      _pthread_cleanup_push.level = __ATEXIT__.length;
    }

  var _atan2=Math_atan2;

  var _log=Math_log;

  var _exp=Math_exp;

  function _time(ptr) {
      var ret = (Date.now()/1000)|0;
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret;
      }
      return ret;
    }

  function _pthread_self() {
      //FIXME: assumes only a single thread
      return 0;
    }

  function ___syscall140(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // llseek
      var stream = SYSCALLS.getStreamFromFD(), offset_high = SYSCALLS.get(), offset_low = SYSCALLS.get(), result = SYSCALLS.get(), whence = SYSCALLS.get();
      var offset = offset_low;
      assert(offset_high === 0);
      FS.llseek(stream, offset, whence);
      HEAP32[((result)>>2)]=stream.position;
      if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null; // reset readdir state
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function _utimes(path, times) {
      var time;
      if (times) {
        var offset = 8 + 0;
        time = HEAP32[(((times)+(offset))>>2)] * 1000;
        offset = 8 + 4;
        time += HEAP32[(((times)+(offset))>>2)] / 1000;
      } else {
        time = Date.now();
      }
      path = Pointer_stringify(path);
      try {
        FS.utime(path, time, time);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }

  function ___syscall146(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // writev
      var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      return SYSCALLS.doWritev(stream, iov, iovcnt);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall221(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // fcntl64
      var stream = SYSCALLS.getStreamFromFD(), cmd = SYSCALLS.get();
      switch (cmd) {
        case 0: {
          var arg = SYSCALLS.get();
          if (arg < 0) {
            return -ERRNO_CODES.EINVAL;
          }
          var newStream;
          newStream = FS.open(stream.path, stream.flags, 0, arg);
          return newStream.fd;
        }
        case 1:
        case 2:
          return 0;  // FD_CLOEXEC makes no sense for a single process.
        case 3:
          return stream.flags;
        case 4: {
          var arg = SYSCALLS.get();
          stream.flags |= arg;
          return 0;
        }
        case 12:
        case 12: {
          var arg = SYSCALLS.get();
          var offset = 0;
          // We're always unlocked.
          HEAP16[(((arg)+(offset))>>1)]=2;
          return 0;
        }
        case 13:
        case 14:
        case 13:
        case 14:
          return 0; // Pretend that the locking is successful.
        case 16:
        case 8:
          return -ERRNO_CODES.EINVAL; // These are for sockets. We don't have them fully implemented yet.
        case 9:
          // musl trusts getown return values, due to a bug where they must be, as they overlap with errors. just return -1 here, so fnctl() returns that, and we set errno ourselves.
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        default: {
          return -ERRNO_CODES.EINVAL;
        }
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }
FS.staticInit();__ATINIT__.unshift(function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() });__ATMAIN__.push(function() { FS.ignorePermissions = false });__ATEXIT__.push(function() { FS.quit() });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;Module["FS_unlink"] = FS.unlink;
__ATINIT__.unshift(function() { TTY.init() });__ATEXIT__.push(function() { TTY.shutdown() });
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); var NODEJS_PATH = require("path"); NODEFS.staticInit(); }
___buildEnvironment(ENV);
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas, vrDevice) { Browser.requestFullScreen(lockPointer, resizeCanvas, vrDevice) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
  Module["createContext"] = function Module_createContext(canvas, useWebGL, setInModule, webGLContextAttributes) { return Browser.createContext(canvas, useWebGL, setInModule, webGLContextAttributes) }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);

staticSealed = true; // seal the static portion of memory

STACK_MAX = STACK_BASE + TOTAL_STACK;

DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);


function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_iiii(index,a1,a2,a3) {
    return Runtime.functionPointers[index](a1,a2,a3);
}

function invoke_i(index) {
  try {
    return Module["dynCall_i"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_i(index) {
    return Runtime.functionPointers[index]();
}

function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_vi(index,a1) {
    Runtime.functionPointers[index](a1);
}

function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_vii(index,a1,a2) {
    Runtime.functionPointers[index](a1,a2);
}

function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_iiiiiii(index,a1,a2,a3,a4,a5,a6) {
    return Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6);
}

function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_ii(index,a1) {
    return Runtime.functionPointers[index](a1);
}

function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_viii(index,a1,a2,a3) {
    Runtime.functionPointers[index](a1,a2,a3);
}

function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_v(index) {
    Runtime.functionPointers[index]();
}

function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_iiiii(index,a1,a2,a3,a4) {
    return Runtime.functionPointers[index](a1,a2,a3,a4);
}

function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_viiiiii(index,a1,a2,a3,a4,a5,a6) {
    Runtime.functionPointers[index](a1,a2,a3,a4,a5,a6);
}

function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_iii(index,a1,a2) {
    return Runtime.functionPointers[index](a1,a2);
}

function invoke_iiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_iiiiii(index,a1,a2,a3,a4,a5) {
    return Runtime.functionPointers[index](a1,a2,a3,a4,a5);
}

function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function jsCall_viiii(index,a1,a2,a3,a4) {
    Runtime.functionPointers[index](a1,a2,a3,a4);
}

Module.asmGlobalArg = { "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array, "NaN": NaN, "Infinity": Infinity };

Module.asmLibraryArg = { "abort": abort, "assert": assert, "invoke_iiii": invoke_iiii, "jsCall_iiii": jsCall_iiii, "invoke_i": invoke_i, "jsCall_i": jsCall_i, "invoke_vi": invoke_vi, "jsCall_vi": jsCall_vi, "invoke_vii": invoke_vii, "jsCall_vii": jsCall_vii, "invoke_iiiiiii": invoke_iiiiiii, "jsCall_iiiiiii": jsCall_iiiiiii, "invoke_ii": invoke_ii, "jsCall_ii": jsCall_ii, "invoke_viii": invoke_viii, "jsCall_viii": jsCall_viii, "invoke_v": invoke_v, "jsCall_v": jsCall_v, "invoke_iiiii": invoke_iiiii, "jsCall_iiiii": jsCall_iiiii, "invoke_viiiiii": invoke_viiiiii, "jsCall_viiiiii": jsCall_viiiiii, "invoke_iii": invoke_iii, "jsCall_iii": jsCall_iii, "invoke_iiiiii": invoke_iiiiii, "jsCall_iiiiii": jsCall_iiiiii, "invoke_viiii": invoke_viiii, "jsCall_viiii": jsCall_viiii, "_pthread_cleanup_pop": _pthread_cleanup_pop, "___syscall85": ___syscall85, "_sin": _sin, "_exp": _exp, "_utimes": _utimes, "_llvm_pow_f64": _llvm_pow_f64, "_acos": _acos, "___syscall54": ___syscall54, "_pthread_cleanup_push": _pthread_cleanup_push, "_abort": _abort, "___syscall40": ___syscall40, "___syscall118": ___syscall118, "___setErrNo": ___setErrNo, "___syscall20": ___syscall20, "___syscall183": ___syscall183, "___assert_fail": ___assert_fail, "_usleep": _usleep, "_asin": _asin, "___buildEnvironment": ___buildEnvironment, "___syscall202": ___syscall202, "___syscall91": ___syscall91, "_cos": _cos, "___syscall39": ___syscall39, "_localtime_r": _localtime_r, "_tzset": _tzset, "_emscripten_set_main_loop_timing": _emscripten_set_main_loop_timing, "_sbrk": _sbrk, "___syscall192": ___syscall192, "___syscall197": ___syscall197, "___syscall196": ___syscall196, "___syscall195": ___syscall195, "___syscall194": ___syscall194, "___syscall212": ___syscall212, "_sysconf": _sysconf, "___syscall94": ___syscall94, "_nanosleep": _nanosleep, "_emscripten_memcpy_big": _emscripten_memcpy_big, "___syscall221": ___syscall221, "_floor": _floor, "_atan": _atan, "___syscall201": ___syscall201, "_pthread_self": _pthread_self, "_getenv": _getenv, "___syscall33": ___syscall33, "_log": _log, "___unlock": ___unlock, "___syscall140": ___syscall140, "___syscall15": ___syscall15, "_emscripten_set_main_loop": _emscripten_set_main_loop, "___syscall10": ___syscall10, "_tan": _tan, "___syscall3": ___syscall3, "___lock": ___lock, "___syscall6": ___syscall6, "___syscall5": ___syscall5, "___syscall4": ___syscall4, "_time": _time, "_atan2": _atan2, "_gettimeofday": _gettimeofday, "_ceil": _ceil, "_sqrt": _sqrt, "_localtime": _localtime, "___syscall207": ___syscall207, "___syscall146": ___syscall146, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "cttz_i8": cttz_i8 };
// EMSCRIPTEN_START_ASM
var asm = (function(global, env, buffer) {
  'use asm';
  
  
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);


  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var cttz_i8=env.cttz_i8|0;

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = global.NaN, inf = global.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;

  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var Math_min=global.Math.min;
  var Math_clz32=global.Math.clz32;
  var abort=env.abort;
  var assert=env.assert;
  var invoke_iiii=env.invoke_iiii;
  var jsCall_iiii=env.jsCall_iiii;
  var invoke_i=env.invoke_i;
  var jsCall_i=env.jsCall_i;
  var invoke_vi=env.invoke_vi;
  var jsCall_vi=env.jsCall_vi;
  var invoke_vii=env.invoke_vii;
  var jsCall_vii=env.jsCall_vii;
  var invoke_iiiiiii=env.invoke_iiiiiii;
  var jsCall_iiiiiii=env.jsCall_iiiiiii;
  var invoke_ii=env.invoke_ii;
  var jsCall_ii=env.jsCall_ii;
  var invoke_viii=env.invoke_viii;
  var jsCall_viii=env.jsCall_viii;
  var invoke_v=env.invoke_v;
  var jsCall_v=env.jsCall_v;
  var invoke_iiiii=env.invoke_iiiii;
  var jsCall_iiiii=env.jsCall_iiiii;
  var invoke_viiiiii=env.invoke_viiiiii;
  var jsCall_viiiiii=env.jsCall_viiiiii;
  var invoke_iii=env.invoke_iii;
  var jsCall_iii=env.jsCall_iii;
  var invoke_iiiiii=env.invoke_iiiiii;
  var jsCall_iiiiii=env.jsCall_iiiiii;
  var invoke_viiii=env.invoke_viiii;
  var jsCall_viiii=env.jsCall_viiii;
  var _pthread_cleanup_pop=env._pthread_cleanup_pop;
  var ___syscall85=env.___syscall85;
  var _sin=env._sin;
  var _exp=env._exp;
  var _utimes=env._utimes;
  var _llvm_pow_f64=env._llvm_pow_f64;
  var _acos=env._acos;
  var ___syscall54=env.___syscall54;
  var _pthread_cleanup_push=env._pthread_cleanup_push;
  var _abort=env._abort;
  var ___syscall40=env.___syscall40;
  var ___syscall118=env.___syscall118;
  var ___setErrNo=env.___setErrNo;
  var ___syscall20=env.___syscall20;
  var ___syscall183=env.___syscall183;
  var ___assert_fail=env.___assert_fail;
  var _usleep=env._usleep;
  var _asin=env._asin;
  var ___buildEnvironment=env.___buildEnvironment;
  var ___syscall202=env.___syscall202;
  var ___syscall91=env.___syscall91;
  var _cos=env._cos;
  var ___syscall39=env.___syscall39;
  var _localtime_r=env._localtime_r;
  var _tzset=env._tzset;
  var _emscripten_set_main_loop_timing=env._emscripten_set_main_loop_timing;
  var _sbrk=env._sbrk;
  var ___syscall192=env.___syscall192;
  var ___syscall197=env.___syscall197;
  var ___syscall196=env.___syscall196;
  var ___syscall195=env.___syscall195;
  var ___syscall194=env.___syscall194;
  var ___syscall212=env.___syscall212;
  var _sysconf=env._sysconf;
  var ___syscall94=env.___syscall94;
  var _nanosleep=env._nanosleep;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var ___syscall221=env.___syscall221;
  var _floor=env._floor;
  var _atan=env._atan;
  var ___syscall201=env.___syscall201;
  var _pthread_self=env._pthread_self;
  var _getenv=env._getenv;
  var ___syscall33=env.___syscall33;
  var _log=env._log;
  var ___unlock=env.___unlock;
  var ___syscall140=env.___syscall140;
  var ___syscall15=env.___syscall15;
  var _emscripten_set_main_loop=env._emscripten_set_main_loop;
  var ___syscall10=env.___syscall10;
  var _tan=env._tan;
  var ___syscall3=env.___syscall3;
  var ___lock=env.___lock;
  var ___syscall6=env.___syscall6;
  var ___syscall5=env.___syscall5;
  var ___syscall4=env.___syscall4;
  var _time=env._time;
  var _atan2=env._atan2;
  var _gettimeofday=env._gettimeofday;
  var _ceil=env._ceil;
  var _sqrt=env._sqrt;
  var _localtime=env._localtime;
  var ___syscall207=env.___syscall207;
  var ___syscall146=env.___syscall146;
  var tempFloat = 0.0;

// EMSCRIPTEN_START_FUNCS
function stackAlloc(size) {
  size = size|0;
  var ret = 0;
  ret = STACKTOP;
  STACKTOP = (STACKTOP + size)|0;
  STACKTOP = (STACKTOP + 15)&-16;

  return ret|0;
}
function stackSave() {
  return STACKTOP|0;
}
function stackRestore(top) {
  top = top|0;
  STACKTOP = top;
}
function establishStackSpace(stackBase, stackMax) {
  stackBase = stackBase|0;
  stackMax = stackMax|0;
  STACKTOP = stackBase;
  STACK_MAX = stackMax;
}

function setThrew(threw, value) {
  threw = threw|0;
  value = value|0;
  if ((__THREW__|0) == 0) {
    __THREW__ = threw;
    threwValue = value;
  }
}
function copyTempFloat(ptr) {
  ptr = ptr|0;
  HEAP8[tempDoublePtr>>0] = HEAP8[ptr>>0];
  HEAP8[tempDoublePtr+1>>0] = HEAP8[ptr+1>>0];
  HEAP8[tempDoublePtr+2>>0] = HEAP8[ptr+2>>0];
  HEAP8[tempDoublePtr+3>>0] = HEAP8[ptr+3>>0];
}
function copyTempDouble(ptr) {
  ptr = ptr|0;
  HEAP8[tempDoublePtr>>0] = HEAP8[ptr>>0];
  HEAP8[tempDoublePtr+1>>0] = HEAP8[ptr+1>>0];
  HEAP8[tempDoublePtr+2>>0] = HEAP8[ptr+2>>0];
  HEAP8[tempDoublePtr+3>>0] = HEAP8[ptr+3>>0];
  HEAP8[tempDoublePtr+4>>0] = HEAP8[ptr+4>>0];
  HEAP8[tempDoublePtr+5>>0] = HEAP8[ptr+5>>0];
  HEAP8[tempDoublePtr+6>>0] = HEAP8[ptr+6>>0];
  HEAP8[tempDoublePtr+7>>0] = HEAP8[ptr+7>>0];
}

function setTempRet0(value) {
  value = value|0;
  tempRet0 = value;
}
function getTempRet0() {
  return tempRet0|0;
}

function _RegisterExtensionFunctions($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $pArg = 0;
 var $pArg1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $i = sp + 8|0;
 $pArg = sp + 4|0;
 $pArg1 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$i>>2] = 0;
 while(1) {
  $1 = HEAP32[$i>>2]|0;
  $2 = ($1>>>0)<(40);
  if (!($2)) {
   break;
  }
  HEAP32[$pArg>>2] = 0;
  $3 = HEAP32[$i>>2]|0;
  $4 = (360 + (($3*12)|0)|0);
  $5 = ((($4)) + 5|0);
  $6 = HEAP8[$5>>0]|0;
  $7 = $6&255;
  switch ($7|0) {
  case 1:  {
   $8 = HEAP32[$0>>2]|0;
   HEAP32[$pArg>>2] = $8;
   break;
  }
  case 2:  {
   HEAP32[$pArg>>2] = (-1);
   break;
  }
  default: {
  }
  }
  $9 = HEAP32[$0>>2]|0;
  $10 = HEAP32[$i>>2]|0;
  $11 = (360 + (($10*12)|0)|0);
  $12 = HEAP32[$11>>2]|0;
  $13 = HEAP32[$i>>2]|0;
  $14 = (360 + (($13*12)|0)|0);
  $15 = ((($14)) + 4|0);
  $16 = HEAP8[$15>>0]|0;
  $17 = $16 << 24 >> 24;
  $18 = HEAP32[$i>>2]|0;
  $19 = (360 + (($18*12)|0)|0);
  $20 = ((($19)) + 6|0);
  $21 = HEAP8[$20>>0]|0;
  $22 = $21&255;
  $23 = HEAP32[$pArg>>2]|0;
  $24 = HEAP32[$i>>2]|0;
  $25 = (360 + (($24*12)|0)|0);
  $26 = ((($25)) + 8|0);
  $27 = HEAP32[$26>>2]|0;
  (_sqlite3_create_function($9,$12,$17,$22,$23,$27,0,0)|0);
  $28 = HEAP32[$i>>2]|0;
  $29 = (($28) + 1)|0;
  HEAP32[$i>>2] = $29;
 }
 HEAP32[$i>>2] = 0;
 while(1) {
  $30 = HEAP32[$i>>2]|0;
  $31 = ($30>>>0)<(6);
  if (!($31)) {
   break;
  }
  HEAP32[$pArg1>>2] = 0;
  $32 = HEAP32[$i>>2]|0;
  $33 = (840 + ($32<<4)|0);
  $34 = ((($33)) + 5|0);
  $35 = HEAP8[$34>>0]|0;
  $36 = $35&255;
  switch ($36|0) {
  case 1:  {
   $37 = HEAP32[$0>>2]|0;
   HEAP32[$pArg1>>2] = $37;
   break;
  }
  case 2:  {
   HEAP32[$pArg1>>2] = (-1);
   break;
  }
  default: {
  }
  }
  $38 = HEAP32[$0>>2]|0;
  $39 = HEAP32[$i>>2]|0;
  $40 = (840 + ($39<<4)|0);
  $41 = HEAP32[$40>>2]|0;
  $42 = HEAP32[$i>>2]|0;
  $43 = (840 + ($42<<4)|0);
  $44 = ((($43)) + 4|0);
  $45 = HEAP8[$44>>0]|0;
  $46 = $45 << 24 >> 24;
  $47 = HEAP32[$pArg1>>2]|0;
  $48 = HEAP32[$i>>2]|0;
  $49 = (840 + ($48<<4)|0);
  $50 = ((($49)) + 8|0);
  $51 = HEAP32[$50>>2]|0;
  $52 = HEAP32[$i>>2]|0;
  $53 = (840 + ($52<<4)|0);
  $54 = ((($53)) + 12|0);
  $55 = HEAP32[$54>>2]|0;
  (_sqlite3_create_function($38,$41,$46,1,$47,0,$51,$55)|0);
  $56 = HEAP32[$i>>2]|0;
  $57 = (($56) + 1)|0;
  HEAP32[$i>>2] = $57;
 }
 STACKTOP = sp;return 0;
}
function _acosFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),378,(16758|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_acos((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _asinFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),379,(16767|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_asin((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _atanFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),380,(16776|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_atan((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _atn2Func($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0.0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0.0, $24 = 0.0, $25 = 0.0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $r1 = 0, $r2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $r1 = sp + 8|0;
 $r2 = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$r1>>3] = 0.0;
 HEAPF64[$r2>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),570,(16793|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = ($7|0)==(5);
 if (!($8)) {
  $9 = HEAP32[$2>>2]|0;
  $10 = ((($9)) + 4|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (_sqlite3_value_type($11)|0);
  $13 = ($12|0)==(5);
  if (!($13)) {
   $15 = HEAP32[$2>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   $17 = (+_sqlite3_value_double($16));
   HEAPF64[$r1>>3] = $17;
   $18 = HEAP32[$2>>2]|0;
   $19 = ((($18)) + 4|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = (+_sqlite3_value_double($20));
   HEAPF64[$r2>>3] = $21;
   $22 = HEAP32[$0>>2]|0;
   $23 = +HEAPF64[$r1>>3];
   $24 = +HEAPF64[$r2>>3];
   $25 = (+Math_atan2((+$23),(+$24)));
   _sqlite3_result_double($22,$25);
   STACKTOP = sp;return;
  }
 }
 $14 = HEAP32[$0>>2]|0;
 _sqlite3_result_null($14);
 STACKTOP = sp;return;
}
function _acoshFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),394,(16802|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_acosh($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _asinhFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),402,(16812|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_asinh($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _atanhFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),410,(16822|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_atanh($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _differenceFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $rVal = 0, $zIn1 = 0, $zIn2 = 0, $zR1 = 0, $zR2 = 0, $zResult1 = 0, $zResult2 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $zResult1 = sp + 48|0;
 $zResult2 = sp + 40|0;
 $zR1 = sp + 20|0;
 $zR2 = sp + 16|0;
 $rVal = sp + 12|0;
 $i = sp + 8|0;
 $zIn1 = sp + 4|0;
 $zIn2 = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$zR1>>2] = $zResult1;
 HEAP32[$zR2>>2] = $zResult2;
 HEAP32[$rVal>>2] = 0;
 HEAP32[$i>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),1680,(16832|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = ($7|0)==(5);
 if (!($8)) {
  $9 = HEAP32[$2>>2]|0;
  $10 = ((($9)) + 4|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (_sqlite3_value_type($11)|0);
  $13 = ($12|0)==(5);
  if (!($13)) {
   $15 = HEAP32[$2>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   $17 = (_sqlite3_value_text($16)|0);
   HEAP32[$zIn1>>2] = $17;
   $18 = HEAP32[$2>>2]|0;
   $19 = ((($18)) + 4|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = (_sqlite3_value_text($20)|0);
   HEAP32[$zIn2>>2] = $21;
   $22 = HEAP32[$zIn1>>2]|0;
   $23 = HEAP32[$zR1>>2]|0;
   _soundex($22,$23);
   $24 = HEAP32[$zIn2>>2]|0;
   $25 = HEAP32[$zR2>>2]|0;
   _soundex($24,$25);
   HEAP32[$i>>2] = 0;
   while(1) {
    $26 = HEAP32[$i>>2]|0;
    $27 = ($26|0)<(4);
    if (!($27)) {
     break;
    }
    $28 = HEAP32[$zR1>>2]|0;
    $29 = (_sqlite3ReadUtf8($28)|0);
    $30 = HEAP32[$zR2>>2]|0;
    $31 = (_sqlite3ReadUtf8($30)|0);
    $32 = ($29|0)==($31|0);
    if ($32) {
     $33 = HEAP32[$rVal>>2]|0;
     $34 = (($33) + 1)|0;
     HEAP32[$rVal>>2] = $34;
    }
    while(1) {
     $35 = HEAP32[$zR1>>2]|0;
     $36 = ((($35)) + 1|0);
     HEAP32[$zR1>>2] = $36;
     $37 = HEAP8[$36>>0]|0;
     $38 = $37 << 24 >> 24;
     $39 = 192 & $38;
     $40 = ($39|0)==(128);
     if (!($40)) {
      break;
     }
    }
    while(1) {
     $41 = HEAP32[$zR2>>2]|0;
     $42 = ((($41)) + 1|0);
     HEAP32[$zR2>>2] = $42;
     $43 = HEAP8[$42>>0]|0;
     $44 = $43 << 24 >> 24;
     $45 = 192 & $44;
     $46 = ($45|0)==(128);
     if (!($46)) {
      break;
     }
    }
    $47 = HEAP32[$i>>2]|0;
    $48 = (($47) + 1)|0;
    HEAP32[$i>>2] = $48;
   }
   $49 = HEAP32[$0>>2]|0;
   $50 = HEAP32[$rVal>>2]|0;
   _sqlite3_result_int($49,$50);
   STACKTOP = sp;return;
  }
 }
 $14 = HEAP32[$0>>2]|0;
 _sqlite3_result_null($14);
 STACKTOP = sp;return;
}
function _rad2degFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),498,(17236|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_rad2deg($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _deg2radFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),499,(17248|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_deg2rad($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _cosFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),420,(17260|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_cos((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _sinFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),419,(17268|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_sin((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _tanFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),421,(17276|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_tan((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _cotFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),422,(17284|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_cot($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _coshFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),446,(17292|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_cosh($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _sinhFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),438,(17301|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_sinh($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _tanhFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),454,(17310|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_tanh($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _cothFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),456,(17319|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_coth($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _expFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),474,(17328|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_exp((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _logFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),472,(17336|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_log((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _log10Func($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),473,(17344|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+_log10($13));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _powerFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0.0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0.0, $24 = 0.0, $25 = 0.0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $r1 = 0, $r2 = 0, $val = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $r1 = sp + 16|0;
 $r2 = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$r1>>3] = 0.0;
 HEAPF64[$r2>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),546,(17354|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = ($7|0)==(5);
 if (!($8)) {
  $9 = HEAP32[$2>>2]|0;
  $10 = ((($9)) + 4|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (_sqlite3_value_type($11)|0);
  $13 = ($12|0)==(5);
  if (!($13)) {
   $15 = HEAP32[$2>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   $17 = (+_sqlite3_value_double($16));
   HEAPF64[$r1>>3] = $17;
   $18 = HEAP32[$2>>2]|0;
   $19 = ((($18)) + 4|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = (+_sqlite3_value_double($20));
   HEAPF64[$r2>>3] = $21;
   $22 = (___errno_location()|0);
   HEAP32[$22>>2] = 0;
   $23 = +HEAPF64[$r1>>3];
   $24 = +HEAPF64[$r2>>3];
   $25 = (+Math_pow((+$23),(+$24)));
   HEAPF64[$val>>3] = $25;
   $26 = (___errno_location()|0);
   $27 = HEAP32[$26>>2]|0;
   $28 = ($27|0)==(0);
   $29 = HEAP32[$0>>2]|0;
   if ($28) {
    $30 = +HEAPF64[$val>>3];
    _sqlite3_result_double($29,$30);
    STACKTOP = sp;return;
   } else {
    $31 = (___errno_location()|0);
    $32 = HEAP32[$31>>2]|0;
    $33 = (_strerror($32)|0);
    $34 = (___errno_location()|0);
    $35 = HEAP32[$34>>2]|0;
    _sqlite3_result_error($29,$33,$35);
    STACKTOP = sp;return;
   }
  }
 }
 $14 = HEAP32[$0>>2]|0;
 _sqlite3_result_null($14);
 STACKTOP = sp;return;
}
function _signFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0.0, $57 = 0.0, $58 = 0, $59 = 0.0, $6 = 0, $60 = 0, $61 = 0, $62 = 0.0;
 var $63 = 0, $64 = 0, $65 = 0.0, $7 = 0, $8 = 0, $9 = 0, $iVal = 0, $rVal = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $iVal = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = $iVal;
 $4 = $3;
 HEAP32[$4>>2] = 0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = 0;
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)==(1);
 if (!($8)) {
  ___assert_fail((16726|0),(16734|0),590,(17364|0));
  // unreachable;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (_sqlite3_value_type($10)|0);
 switch ($11|0) {
 case 1:  {
  $12 = HEAP32[$2>>2]|0;
  $13 = HEAP32[$12>>2]|0;
  $14 = (_sqlite3_value_int64($13)|0);
  $15 = tempRet0;
  $16 = $iVal;
  $17 = $16;
  HEAP32[$17>>2] = $14;
  $18 = (($16) + 4)|0;
  $19 = $18;
  HEAP32[$19>>2] = $15;
  $20 = $iVal;
  $21 = $20;
  $22 = HEAP32[$21>>2]|0;
  $23 = (($20) + 4)|0;
  $24 = $23;
  $25 = HEAP32[$24>>2]|0;
  $26 = ($25|0)>(0);
  $27 = ($22>>>0)>(0);
  $28 = ($25|0)==(0);
  $29 = $28 & $27;
  $30 = $26 | $29;
  if ($30) {
   $40 = 1;
  } else {
   $31 = $iVal;
   $32 = $31;
   $33 = HEAP32[$32>>2]|0;
   $34 = (($31) + 4)|0;
   $35 = $34;
   $36 = HEAP32[$35>>2]|0;
   $37 = ($36|0)<(0);
   $38 = $37 ? -1 : 0;
   $40 = $38;
  }
  $39 = ($40|0)<(0);
  $41 = $39 << 31 >> 31;
  $42 = $iVal;
  $43 = $42;
  HEAP32[$43>>2] = $40;
  $44 = (($42) + 4)|0;
  $45 = $44;
  HEAP32[$45>>2] = $41;
  $46 = HEAP32[$0>>2]|0;
  $47 = $iVal;
  $48 = $47;
  $49 = HEAP32[$48>>2]|0;
  $50 = (($47) + 4)|0;
  $51 = $50;
  $52 = HEAP32[$51>>2]|0;
  _sqlite3_result_int64($46,$49,$52);
  STACKTOP = sp;return;
  break;
 }
 case 5:  {
  $53 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($53);
  STACKTOP = sp;return;
  break;
 }
 default: {
  $54 = HEAP32[$2>>2]|0;
  $55 = HEAP32[$54>>2]|0;
  $56 = (+_sqlite3_value_double($55));
  HEAPF64[$rVal>>3] = $56;
  $57 = +HEAPF64[$rVal>>3];
  $58 = $57 > 0.0;
  if ($58) {
   $63 = 1;
  } else {
   $59 = +HEAPF64[$rVal>>3];
   $60 = $59 < 0.0;
   $61 = $60 ? -1 : 0;
   $63 = $61;
  }
  $62 = (+($63|0));
  HEAPF64[$rVal>>3] = $62;
  $64 = HEAP32[$0>>2]|0;
  $65 = +HEAPF64[$rVal>>3];
  _sqlite3_result_double($64,$65);
  STACKTOP = sp;return;
 }
 }
}
function _sqrtFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $rVal = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $rVal = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),375,(17373|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $cond = ($7|0)==(5);
 if ($cond) {
  $8 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($8);
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (+_sqlite3_value_double($10));
 HEAPF64[$rVal>>3] = $11;
 $12 = (___errno_location()|0);
 HEAP32[$12>>2] = 0;
 $13 = +HEAPF64[$rVal>>3];
 $14 = (+Math_sqrt((+$13)));
 HEAPF64[$val>>3] = $14;
 $15 = (___errno_location()|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)==(0);
 $18 = HEAP32[$0>>2]|0;
 if ($17) {
  $19 = +HEAPF64[$val>>3];
  _sqlite3_result_double($18,$19);
  STACKTOP = sp;return;
 } else {
  $20 = (___errno_location()|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = (_strerror($21)|0);
  $23 = (___errno_location()|0);
  $24 = HEAP32[$23>>2]|0;
  _sqlite3_result_error($18,$22,$24);
  STACKTOP = sp;return;
 }
}
function _squareFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0.0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0.0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $iVal = 0, $rVal = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $iVal = sp + 8|0;
 $rVal = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 $3 = $iVal;
 $4 = $3;
 HEAP32[$4>>2] = 0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = 0;
 HEAPF64[$rVal>>3] = 0.0;
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)==(1);
 if (!($8)) {
  ___assert_fail((16726|0),(16734|0),514,(17382|0));
  // unreachable;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (_sqlite3_value_type($10)|0);
 switch ($11|0) {
 case 1:  {
  $12 = HEAP32[$2>>2]|0;
  $13 = HEAP32[$12>>2]|0;
  $14 = (_sqlite3_value_int64($13)|0);
  $15 = tempRet0;
  $16 = $iVal;
  $17 = $16;
  HEAP32[$17>>2] = $14;
  $18 = (($16) + 4)|0;
  $19 = $18;
  HEAP32[$19>>2] = $15;
  $20 = HEAP32[$0>>2]|0;
  $21 = $iVal;
  $22 = $21;
  $23 = HEAP32[$22>>2]|0;
  $24 = (($21) + 4)|0;
  $25 = $24;
  $26 = HEAP32[$25>>2]|0;
  $27 = $iVal;
  $28 = $27;
  $29 = HEAP32[$28>>2]|0;
  $30 = (($27) + 4)|0;
  $31 = $30;
  $32 = HEAP32[$31>>2]|0;
  $33 = (___muldi3(($23|0),($26|0),($29|0),($32|0))|0);
  $34 = tempRet0;
  _sqlite3_result_int64($20,$33,$34);
  STACKTOP = sp;return;
  break;
 }
 case 5:  {
  $35 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($35);
  STACKTOP = sp;return;
  break;
 }
 default: {
  $36 = HEAP32[$2>>2]|0;
  $37 = HEAP32[$36>>2]|0;
  $38 = (+_sqlite3_value_double($37));
  HEAPF64[$rVal>>3] = $38;
  $39 = HEAP32[$0>>2]|0;
  $40 = +HEAPF64[$rVal>>3];
  $41 = +HEAPF64[$rVal>>3];
  $42 = $40 * $41;
  _sqlite3_result_double($39,$42);
  STACKTOP = sp;return;
 }
 }
}
function _ceilFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0.0, $33 = 0.0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $iVal = 0, $iVal1 = 0, $rVal = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $rVal = sp + 16|0;
 $iVal = sp + 8|0;
 $iVal1 = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = $iVal;
 $4 = $3;
 HEAP32[$4>>2] = 0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = 0;
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)==(1);
 if (!($8)) {
  ___assert_fail((16726|0),(16734|0),620,(17393|0));
  // unreachable;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (_sqlite3_value_type($10)|0);
 switch ($11|0) {
 case 1:  {
  $12 = HEAP32[$2>>2]|0;
  $13 = HEAP32[$12>>2]|0;
  $14 = (_sqlite3_value_int64($13)|0);
  $15 = tempRet0;
  $16 = $iVal1;
  $17 = $16;
  HEAP32[$17>>2] = $14;
  $18 = (($16) + 4)|0;
  $19 = $18;
  HEAP32[$19>>2] = $15;
  $20 = HEAP32[$0>>2]|0;
  $21 = $iVal1;
  $22 = $21;
  $23 = HEAP32[$22>>2]|0;
  $24 = (($21) + 4)|0;
  $25 = $24;
  $26 = HEAP32[$25>>2]|0;
  _sqlite3_result_int64($20,$23,$26);
  STACKTOP = sp;return;
  break;
 }
 case 5:  {
  $27 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($27);
  STACKTOP = sp;return;
  break;
 }
 default: {
  $28 = HEAP32[$2>>2]|0;
  $29 = HEAP32[$28>>2]|0;
  $30 = (+_sqlite3_value_double($29));
  HEAPF64[$rVal>>3] = $30;
  $31 = HEAP32[$0>>2]|0;
  $32 = +HEAPF64[$rVal>>3];
  $33 = (+Math_ceil((+$32)));
  $34 = (~~$33)>>>0;
  $35 = +Math_abs($33) >= 1.0 ? $33 > 0.0 ? (~~+Math_min(+Math_floor($33 / 4294967296.0), 4294967295.0)) >>> 0 : ~~+Math_ceil(($33 - +(~~$33 >>> 0)) / 4294967296.0) >>> 0 : 0;
  _sqlite3_result_int64($31,$34,$35);
  STACKTOP = sp;return;
 }
 }
}
function _floorFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0.0, $33 = 0.0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $iVal = 0, $iVal1 = 0, $rVal = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $rVal = sp + 16|0;
 $iVal = sp + 8|0;
 $iVal1 = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAPF64[$rVal>>3] = 0.0;
 $3 = $iVal;
 $4 = $3;
 HEAP32[$4>>2] = 0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = 0;
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)==(1);
 if (!($8)) {
  ___assert_fail((16726|0),(16734|0),645,(17402|0));
  // unreachable;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (_sqlite3_value_type($10)|0);
 switch ($11|0) {
 case 1:  {
  $12 = HEAP32[$2>>2]|0;
  $13 = HEAP32[$12>>2]|0;
  $14 = (_sqlite3_value_int64($13)|0);
  $15 = tempRet0;
  $16 = $iVal1;
  $17 = $16;
  HEAP32[$17>>2] = $14;
  $18 = (($16) + 4)|0;
  $19 = $18;
  HEAP32[$19>>2] = $15;
  $20 = HEAP32[$0>>2]|0;
  $21 = $iVal1;
  $22 = $21;
  $23 = HEAP32[$22>>2]|0;
  $24 = (($21) + 4)|0;
  $25 = $24;
  $26 = HEAP32[$25>>2]|0;
  _sqlite3_result_int64($20,$23,$26);
  STACKTOP = sp;return;
  break;
 }
 case 5:  {
  $27 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($27);
  STACKTOP = sp;return;
  break;
 }
 default: {
  $28 = HEAP32[$2>>2]|0;
  $29 = HEAP32[$28>>2]|0;
  $30 = (+_sqlite3_value_double($29));
  HEAPF64[$rVal>>3] = $30;
  $31 = HEAP32[$0>>2]|0;
  $32 = +HEAPF64[$rVal>>3];
  $33 = (+Math_floor((+$32)));
  $34 = (~~$33)>>>0;
  $35 = +Math_abs($33) >= 1.0 ? $33 > 0.0 ? (~~+Math_min(+Math_floor($33 / 4294967296.0), 4294967295.0)) >>> 0 : ~~+Math_ceil(($33 - +(~~$33 >>> 0)) / 4294967296.0) >>> 0 : 0;
  _sqlite3_result_int64($31,$34,$35);
  STACKTOP = sp;return;
 }
 }
}
function _piFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 $3 = HEAP32[$0>>2]|0;
 _sqlite3_result_double($3,3.1415926535897931);
 STACKTOP = sp;return;
}
function _replicateFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0;
 var $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i = 0, $iCount = 0, $nLen = 0, $nTLen = 0, $or$cond = 0, $z = 0, $zo = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $0 = sp + 48|0;
 $1 = sp + 44|0;
 $2 = sp + 40|0;
 $z = sp + 36|0;
 $zo = sp + 32|0;
 $iCount = sp + 24|0;
 $nLen = sp + 16|0;
 $nTLen = sp + 8|0;
 $i = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 $3 = $i;
 $4 = $3;
 HEAP32[$4>>2] = 0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = 0;
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)!=(2);
 if ($8) {
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 $11 = (_sqlite3_value_type($10)|0);
 $12 = (5)==($11|0);
 if ($12) {
  STACKTOP = sp;return;
 }
 $13 = HEAP32[$2>>2]|0;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = (_sqlite3_value_int64($15)|0);
 $17 = tempRet0;
 $18 = $iCount;
 $19 = $18;
 HEAP32[$19>>2] = $16;
 $20 = (($18) + 4)|0;
 $21 = $20;
 HEAP32[$21>>2] = $17;
 $22 = $iCount;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 $25 = (($22) + 4)|0;
 $26 = $25;
 $27 = HEAP32[$26>>2]|0;
 $28 = ($27|0)<(0);
 if ($28) {
  $29 = HEAP32[$0>>2]|0;
  _sqlite3_result_error($29,17412,-1);
  STACKTOP = sp;return;
 }
 $30 = HEAP32[$2>>2]|0;
 $31 = HEAP32[$30>>2]|0;
 $32 = (_sqlite3_value_bytes($31)|0);
 $33 = ($32|0)<(0);
 $34 = $33 << 31 >> 31;
 $35 = $nLen;
 $36 = $35;
 HEAP32[$36>>2] = $32;
 $37 = (($35) + 4)|0;
 $38 = $37;
 HEAP32[$38>>2] = $34;
 $39 = $nLen;
 $40 = $39;
 $41 = HEAP32[$40>>2]|0;
 $42 = (($39) + 4)|0;
 $43 = $42;
 $44 = HEAP32[$43>>2]|0;
 $45 = $iCount;
 $46 = $45;
 $47 = HEAP32[$46>>2]|0;
 $48 = (($45) + 4)|0;
 $49 = $48;
 $50 = HEAP32[$49>>2]|0;
 $51 = (___muldi3(($41|0),($44|0),($47|0),($50|0))|0);
 $52 = tempRet0;
 $53 = $nTLen;
 $54 = $53;
 HEAP32[$54>>2] = $51;
 $55 = (($53) + 4)|0;
 $56 = $55;
 HEAP32[$56>>2] = $52;
 $57 = $nTLen;
 $58 = $57;
 $59 = HEAP32[$58>>2]|0;
 $60 = (($57) + 4)|0;
 $61 = $60;
 $62 = HEAP32[$61>>2]|0;
 $63 = (_i64Add(($59|0),($62|0),1,0)|0);
 $64 = tempRet0;
 $65 = (_sqlite3_malloc($63)|0);
 HEAP32[$z>>2] = $65;
 $66 = $nLen;
 $67 = $66;
 $68 = HEAP32[$67>>2]|0;
 $69 = (($66) + 4)|0;
 $70 = $69;
 $71 = HEAP32[$70>>2]|0;
 $72 = (_i64Add(($68|0),($71|0),1,0)|0);
 $73 = tempRet0;
 $74 = (_sqlite3_malloc($72)|0);
 HEAP32[$zo>>2] = $74;
 $75 = HEAP32[$z>>2]|0;
 $76 = ($75|0)!=(0|0);
 $77 = HEAP32[$zo>>2]|0;
 $78 = ($77|0)!=(0|0);
 $or$cond = $76 & $78;
 if ($or$cond) {
  $86 = HEAP32[$zo>>2]|0;
  $87 = HEAP32[$2>>2]|0;
  $88 = HEAP32[$87>>2]|0;
  $89 = (_sqlite3_value_text($88)|0);
  (_strcpy($86,$89)|0);
  $90 = $i;
  $91 = $90;
  HEAP32[$91>>2] = 0;
  $92 = (($90) + 4)|0;
  $93 = $92;
  HEAP32[$93>>2] = 0;
  while(1) {
   $94 = $i;
   $95 = $94;
   $96 = HEAP32[$95>>2]|0;
   $97 = (($94) + 4)|0;
   $98 = $97;
   $99 = HEAP32[$98>>2]|0;
   $100 = $iCount;
   $101 = $100;
   $102 = HEAP32[$101>>2]|0;
   $103 = (($100) + 4)|0;
   $104 = $103;
   $105 = HEAP32[$104>>2]|0;
   $106 = ($99|0)<($105|0);
   $107 = ($96>>>0)<($102>>>0);
   $108 = ($99|0)==($105|0);
   $109 = $108 & $107;
   $110 = $106 | $109;
   if (!($110)) {
    break;
   }
   $111 = HEAP32[$z>>2]|0;
   $112 = $i;
   $113 = $112;
   $114 = HEAP32[$113>>2]|0;
   $115 = (($112) + 4)|0;
   $116 = $115;
   $117 = HEAP32[$116>>2]|0;
   $118 = $nLen;
   $119 = $118;
   $120 = HEAP32[$119>>2]|0;
   $121 = (($118) + 4)|0;
   $122 = $121;
   $123 = HEAP32[$122>>2]|0;
   $124 = (___muldi3(($114|0),($117|0),($120|0),($123|0))|0);
   $125 = tempRet0;
   $126 = (($111) + ($124)|0);
   $127 = HEAP32[$zo>>2]|0;
   (_strcpy($126,$127)|0);
   $128 = $i;
   $129 = $128;
   $130 = HEAP32[$129>>2]|0;
   $131 = (($128) + 4)|0;
   $132 = $131;
   $133 = HEAP32[$132>>2]|0;
   $134 = (_i64Add(($130|0),($133|0),1,0)|0);
   $135 = tempRet0;
   $136 = $i;
   $137 = $136;
   HEAP32[$137>>2] = $134;
   $138 = (($136) + 4)|0;
   $139 = $138;
   HEAP32[$139>>2] = $135;
  }
  $140 = HEAP32[$0>>2]|0;
  $141 = HEAP32[$z>>2]|0;
  _sqlite3_result_text($140,$141,-1,(-1));
  $142 = HEAP32[$z>>2]|0;
  _sqlite3_free($142);
  $143 = HEAP32[$zo>>2]|0;
  _sqlite3_free($143);
  STACKTOP = sp;return;
 }
 $79 = HEAP32[$0>>2]|0;
 _sqlite3_result_error_nomem($79);
 $80 = HEAP32[$z>>2]|0;
 $81 = ($80|0)!=(0|0);
 if ($81) {
  $82 = HEAP32[$z>>2]|0;
  _sqlite3_free($82);
 }
 $83 = HEAP32[$zo>>2]|0;
 $84 = ($83|0)!=(0|0);
 if (!($84)) {
  STACKTOP = sp;return;
 }
 $85 = HEAP32[$zo>>2]|0;
 _sqlite3_free($85);
 STACKTOP = sp;return;
}
function _charindexFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $rVal = 0, $s = 0, $z1 = 0, $z2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $z1 = sp + 12|0;
 $z2 = sp + 8|0;
 $s = sp + 4|0;
 $rVal = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$s>>2] = 0;
 HEAP32[$rVal>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(3);
 $5 = HEAP32[$1>>2]|0;
 $6 = ($5|0)==(2);
 $or$cond = $4 | $6;
 if (!($or$cond)) {
  ___assert_fail((17425|0),(16734|0),1038,(17443|0));
  // unreachable;
 }
 $7 = HEAP32[$2>>2]|0;
 $8 = HEAP32[$7>>2]|0;
 $9 = (_sqlite3_value_type($8)|0);
 $10 = (5)==($9|0);
 if (!($10)) {
  $11 = HEAP32[$2>>2]|0;
  $12 = ((($11)) + 4|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = (_sqlite3_value_type($13)|0);
  $15 = (5)==($14|0);
  if (!($15)) {
   $17 = HEAP32[$2>>2]|0;
   $18 = HEAP32[$17>>2]|0;
   $19 = (_sqlite3_value_text($18)|0);
   HEAP32[$z1>>2] = $19;
   $20 = HEAP32[$z1>>2]|0;
   $21 = ($20|0)==(0|0);
   if ($21) {
    STACKTOP = sp;return;
   }
   $22 = HEAP32[$2>>2]|0;
   $23 = ((($22)) + 4|0);
   $24 = HEAP32[$23>>2]|0;
   $25 = (_sqlite3_value_text($24)|0);
   HEAP32[$z2>>2] = $25;
   $26 = HEAP32[$1>>2]|0;
   $27 = ($26|0)==(3);
   if ($27) {
    $28 = HEAP32[$2>>2]|0;
    $29 = ((($28)) + 8|0);
    $30 = HEAP32[$29>>2]|0;
    $31 = (_sqlite3_value_int($30)|0);
    $32 = (($31) - 1)|0;
    HEAP32[$s>>2] = $32;
    $33 = HEAP32[$s>>2]|0;
    $34 = ($33|0)<(0);
    $$ = $34 ? 0 : $32;
    HEAP32[$s>>2] = $$;
   } else {
    HEAP32[$s>>2] = 0;
   }
   $35 = HEAP32[$z1>>2]|0;
   $36 = HEAP32[$z2>>2]|0;
   $37 = HEAP32[$s>>2]|0;
   $38 = (__substr($35,$36,$37,0)|0);
   HEAP32[$rVal>>2] = $38;
   $39 = HEAP32[$0>>2]|0;
   $40 = HEAP32[$rVal>>2]|0;
   $41 = (($40) + 1)|0;
   _sqlite3_result_int($39,$41);
   STACKTOP = sp;return;
  }
 }
 $16 = HEAP32[$0>>2]|0;
 _sqlite3_result_null($16);
 STACKTOP = sp;return;
}
function _leftFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $7 = 0, $8 = 0, $9 = 0, $c = 0, $cc = 0, $l = 0, $rz = 0, $z = 0, $zt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $c = sp + 20|0;
 $cc = sp + 16|0;
 $l = sp + 12|0;
 $z = sp + 8|0;
 $zt = sp + 4|0;
 $rz = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$c>>2] = 0;
 HEAP32[$cc>>2] = 0;
 HEAP32[$l>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),1073,(17457|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = (5)==($7|0);
 if (!($8)) {
  $9 = HEAP32[$2>>2]|0;
  $10 = ((($9)) + 4|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (_sqlite3_value_type($11)|0);
  $13 = (5)==($12|0);
  if (!($13)) {
   $15 = HEAP32[$2>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   $17 = (_sqlite3_value_text($16)|0);
   HEAP32[$z>>2] = $17;
   $18 = HEAP32[$2>>2]|0;
   $19 = ((($18)) + 4|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = (_sqlite3_value_int($20)|0);
   HEAP32[$l>>2] = $21;
   $22 = HEAP32[$z>>2]|0;
   HEAP32[$zt>>2] = $22;
   L7: while(1) {
    $23 = HEAP32[$zt>>2]|0;
    $24 = (_sqlite3ReadUtf8($23)|0);
    $25 = ($24|0)!=(0);
    if (!($25)) {
     break;
    }
    $26 = HEAP32[$c>>2]|0;
    $27 = (($26) + 1)|0;
    HEAP32[$c>>2] = $27;
    $28 = HEAP32[$l>>2]|0;
    $29 = ($26|0)<($28|0);
    if (!($29)) {
     break;
    }
    while(1) {
     $30 = HEAP32[$zt>>2]|0;
     $31 = ((($30)) + 1|0);
     HEAP32[$zt>>2] = $31;
     $32 = HEAP8[$31>>0]|0;
     $33 = $32&255;
     $34 = 192 & $33;
     $35 = ($34|0)==(128);
     if (!($35)) {
      continue L7;
     }
    }
   }
   $36 = HEAP32[$zt>>2]|0;
   $37 = HEAP32[$z>>2]|0;
   $38 = $36;
   $39 = $37;
   $40 = (($38) - ($39))|0;
   HEAP32[$cc>>2] = $40;
   $41 = HEAP32[$zt>>2]|0;
   $42 = HEAP32[$z>>2]|0;
   $43 = $41;
   $44 = $42;
   $45 = (($43) - ($44))|0;
   $46 = (($45) + 1)|0;
   $47 = (_sqlite3_malloc($46)|0);
   HEAP32[$rz>>2] = $47;
   $48 = HEAP32[$rz>>2]|0;
   $49 = ($48|0)!=(0|0);
   if ($49) {
    $51 = HEAP32[$rz>>2]|0;
    $52 = HEAP32[$z>>2]|0;
    $53 = HEAP32[$zt>>2]|0;
    $54 = HEAP32[$z>>2]|0;
    $55 = $53;
    $56 = $54;
    $57 = (($55) - ($56))|0;
    (_strncpy($51,$52,$57)|0);
    $58 = HEAP32[$rz>>2]|0;
    $59 = HEAP32[$cc>>2]|0;
    $60 = (($58) + ($59)|0);
    HEAP8[$60>>0] = 0;
    $61 = HEAP32[$0>>2]|0;
    $62 = HEAP32[$rz>>2]|0;
    _sqlite3_result_text($61,$62,-1,(-1));
    $63 = HEAP32[$rz>>2]|0;
    _sqlite3_free($63);
    STACKTOP = sp;return;
   } else {
    $50 = HEAP32[$0>>2]|0;
    _sqlite3_result_error_nomem($50);
    STACKTOP = sp;return;
   }
  }
 }
 $14 = HEAP32[$0>>2]|0;
 _sqlite3_result_null($14);
 STACKTOP = sp;return;
}
function _rightFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $7 = 0, $8 = 0, $9 = 0, $c = 0, $cc = 0, $l = 0, $rz = 0, $z = 0, $ze = 0, $zt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 36|0;
 $1 = sp + 32|0;
 $2 = sp + 28|0;
 $l = sp + 24|0;
 $c = sp + 20|0;
 $cc = sp + 16|0;
 $z = sp + 12|0;
 $zt = sp + 8|0;
 $ze = sp + 4|0;
 $rz = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$l>>2] = 0;
 HEAP32[$c>>2] = 0;
 HEAP32[$cc>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),1113,(17466|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = (5)==($7|0);
 if (!($8)) {
  $9 = HEAP32[$2>>2]|0;
  $10 = ((($9)) + 4|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (_sqlite3_value_type($11)|0);
  $13 = (5)==($12|0);
  if (!($13)) {
   $15 = HEAP32[$2>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   $17 = (_sqlite3_value_text($16)|0);
   HEAP32[$z>>2] = $17;
   $18 = HEAP32[$2>>2]|0;
   $19 = ((($18)) + 4|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = (_sqlite3_value_int($20)|0);
   HEAP32[$l>>2] = $21;
   $22 = HEAP32[$z>>2]|0;
   HEAP32[$zt>>2] = $22;
   while(1) {
    $23 = HEAP32[$zt>>2]|0;
    $24 = (_sqlite3ReadUtf8($23)|0);
    $25 = ($24|0)!=(0);
    if (!($25)) {
     break;
    }
    while(1) {
     $26 = HEAP32[$zt>>2]|0;
     $27 = ((($26)) + 1|0);
     HEAP32[$zt>>2] = $27;
     $28 = HEAP8[$27>>0]|0;
     $29 = $28 << 24 >> 24;
     $30 = 192 & $29;
     $31 = ($30|0)==(128);
     if (!($31)) {
      break;
     }
    }
    $32 = HEAP32[$c>>2]|0;
    $33 = (($32) + 1)|0;
    HEAP32[$c>>2] = $33;
   }
   $34 = HEAP32[$zt>>2]|0;
   HEAP32[$ze>>2] = $34;
   $35 = HEAP32[$z>>2]|0;
   HEAP32[$zt>>2] = $35;
   $36 = HEAP32[$c>>2]|0;
   $37 = HEAP32[$l>>2]|0;
   $38 = (($36) - ($37))|0;
   HEAP32[$cc>>2] = $38;
   $39 = HEAP32[$cc>>2]|0;
   $40 = ($39|0)<(0);
   $$ = $40 ? 0 : $38;
   HEAP32[$cc>>2] = $$;
   L13: while(1) {
    $41 = HEAP32[$cc>>2]|0;
    $42 = (($41) + -1)|0;
    HEAP32[$cc>>2] = $42;
    $43 = ($41|0)>(0);
    if (!($43)) {
     break;
    }
    while(1) {
     $44 = HEAP32[$zt>>2]|0;
     $45 = ((($44)) + 1|0);
     HEAP32[$zt>>2] = $45;
     $46 = HEAP8[$45>>0]|0;
     $47 = $46 << 24 >> 24;
     $48 = 192 & $47;
     $49 = ($48|0)==(128);
     if (!($49)) {
      continue L13;
     }
    }
   }
   $50 = HEAP32[$ze>>2]|0;
   $51 = HEAP32[$zt>>2]|0;
   $52 = $50;
   $53 = $51;
   $54 = (($52) - ($53))|0;
   $55 = (($54) + 1)|0;
   $56 = (_sqlite3_malloc($55)|0);
   HEAP32[$rz>>2] = $56;
   $57 = HEAP32[$rz>>2]|0;
   $58 = ($57|0)!=(0|0);
   if ($58) {
    $60 = HEAP32[$rz>>2]|0;
    $61 = HEAP32[$zt>>2]|0;
    (_strcpy($60,$61)|0);
    $62 = HEAP32[$0>>2]|0;
    $63 = HEAP32[$rz>>2]|0;
    _sqlite3_result_text($62,$63,-1,(-1));
    $64 = HEAP32[$rz>>2]|0;
    _sqlite3_free($64);
    STACKTOP = sp;return;
   } else {
    $59 = HEAP32[$0>>2]|0;
    _sqlite3_result_error_nomem($59);
    STACKTOP = sp;return;
   }
  }
 }
 $14 = HEAP32[$0>>2]|0;
 _sqlite3_result_null($14);
 STACKTOP = sp;return;
}
function _reverseFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $l = 0, $rz = 0, $rzt = 0, $z = 0;
 var $zt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $z = sp + 20|0;
 $zt = sp + 16|0;
 $rz = sp + 12|0;
 $rzt = sp + 8|0;
 $l = sp + 4|0;
 $i = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$l>>2] = 0;
 HEAP32[$i>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (1)==($3|0);
 if (!($4)) {
  ___assert_fail((17476|0),(16734|0),1323,(17484|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = (5)==($7|0);
 if ($8) {
  $9 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($9);
  STACKTOP = sp;return;
 }
 $10 = HEAP32[$2>>2]|0;
 $11 = HEAP32[$10>>2]|0;
 $12 = (_sqlite3_value_text($11)|0);
 HEAP32[$z>>2] = $12;
 $13 = HEAP32[$z>>2]|0;
 $14 = (_strlen($13)|0);
 HEAP32[$l>>2] = $14;
 $15 = HEAP32[$l>>2]|0;
 $16 = (($15) + 1)|0;
 $17 = (_sqlite3_malloc($16)|0);
 HEAP32[$rz>>2] = $17;
 $18 = HEAP32[$rz>>2]|0;
 $19 = ($18|0)!=(0|0);
 if (!($19)) {
  $20 = HEAP32[$0>>2]|0;
  _sqlite3_result_error_nomem($20);
  STACKTOP = sp;return;
 }
 $21 = HEAP32[$rz>>2]|0;
 $22 = HEAP32[$l>>2]|0;
 $23 = (($21) + ($22)|0);
 HEAP32[$rzt>>2] = $23;
 $24 = HEAP32[$rzt>>2]|0;
 $25 = ((($24)) + -1|0);
 HEAP32[$rzt>>2] = $25;
 HEAP8[$24>>0] = 0;
 $26 = HEAP32[$z>>2]|0;
 HEAP32[$zt>>2] = $26;
 L12: while(1) {
  $27 = HEAP32[$zt>>2]|0;
  $28 = (_sqlite3ReadUtf8($27)|0);
  $29 = ($28|0)!=(0);
  if (!($29)) {
   break;
  }
  $30 = HEAP32[$zt>>2]|0;
  HEAP32[$z>>2] = $30;
  while(1) {
   $31 = HEAP32[$zt>>2]|0;
   $32 = ((($31)) + 1|0);
   HEAP32[$zt>>2] = $32;
   $33 = HEAP8[$32>>0]|0;
   $34 = $33 << 24 >> 24;
   $35 = 192 & $34;
   $36 = ($35|0)==(128);
   if (!($36)) {
    break;
   }
  }
  HEAP32[$i>>2] = 1;
  while(1) {
   $37 = HEAP32[$zt>>2]|0;
   $38 = HEAP32[$i>>2]|0;
   $39 = (0 - ($38))|0;
   $40 = (($37) + ($39)|0);
   $41 = HEAP32[$z>>2]|0;
   $42 = ($40>>>0)>=($41>>>0);
   if (!($42)) {
    continue L12;
   }
   $43 = HEAP32[$zt>>2]|0;
   $44 = HEAP32[$i>>2]|0;
   $45 = (0 - ($44))|0;
   $46 = (($43) + ($45)|0);
   $47 = HEAP8[$46>>0]|0;
   $48 = HEAP32[$rzt>>2]|0;
   $49 = ((($48)) + -1|0);
   HEAP32[$rzt>>2] = $49;
   HEAP8[$48>>0] = $47;
   $50 = HEAP32[$i>>2]|0;
   $51 = (($50) + 1)|0;
   HEAP32[$i>>2] = $51;
  }
 }
 $52 = HEAP32[$0>>2]|0;
 $53 = HEAP32[$rz>>2]|0;
 _sqlite3_result_text($52,$53,-1,(-1));
 $54 = HEAP32[$rz>>2]|0;
 _sqlite3_free($54);
 STACKTOP = sp;return;
}
function _properFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $c = 0, $r = 0, $z = 0, $zo = 0, $zt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $z = sp + 12|0;
 $zo = sp + 8|0;
 $zt = sp + 4|0;
 $r = sp + 28|0;
 $c = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$c>>2] = 1;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),724,(17496|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = (5)==($7|0);
 if ($8) {
  $9 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($9);
  STACKTOP = sp;return;
 }
 $10 = HEAP32[$2>>2]|0;
 $11 = HEAP32[$10>>2]|0;
 $12 = (_sqlite3_value_text($11)|0);
 HEAP32[$z>>2] = $12;
 $13 = HEAP32[$z>>2]|0;
 $14 = (_sqlite3StrDup($13)|0);
 HEAP32[$zo>>2] = $14;
 $15 = HEAP32[$zo>>2]|0;
 $16 = ($15|0)!=(0|0);
 if (!($16)) {
  $17 = HEAP32[$0>>2]|0;
  _sqlite3_result_error_nomem($17);
  STACKTOP = sp;return;
 }
 $18 = HEAP32[$zo>>2]|0;
 HEAP32[$zt>>2] = $18;
 while(1) {
  $19 = HEAP32[$z>>2]|0;
  $20 = ((($19)) + 1|0);
  HEAP32[$z>>2] = $20;
  $21 = HEAP8[$19>>0]|0;
  HEAP8[$r>>0] = $21;
  $22 = $21 << 24 >> 24;
  $23 = ($22|0)!=(0);
  if (!($23)) {
   break;
  }
  $24 = HEAP8[$r>>0]|0;
  $25 = $24 << 24 >> 24;
  $26 = (_isblank($25)|0);
  $27 = ($26|0)!=(0);
  if ($27) {
   HEAP32[$c>>2] = 1;
  } else {
   $28 = HEAP32[$c>>2]|0;
   $29 = ($28|0)==(1);
   $30 = HEAP8[$r>>0]|0;
   $31 = $30 << 24 >> 24;
   if ($29) {
    $32 = (_toupper($31)|0);
    $33 = $32&255;
    HEAP8[$r>>0] = $33;
   } else {
    $34 = (_tolower($31)|0);
    $35 = $34&255;
    HEAP8[$r>>0] = $35;
   }
   HEAP32[$c>>2] = 0;
  }
  $36 = HEAP8[$r>>0]|0;
  $37 = HEAP32[$zt>>2]|0;
  $38 = ((($37)) + 1|0);
  HEAP32[$zt>>2] = $38;
  HEAP8[$37>>0] = $36;
 }
 $39 = HEAP32[$zt>>2]|0;
 HEAP8[$39>>0] = 0;
 $40 = HEAP32[$0>>2]|0;
 $41 = HEAP32[$zo>>2]|0;
 _sqlite3_result_text($40,$41,-1,(-1));
 $42 = HEAP32[$zo>>2]|0;
 _sqlite3_free($42);
 STACKTOP = sp;return;
}
function _padlFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $12 = 0;
 var $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i = 0, $ilen = 0, $zi = 0, $zl = 0, $zo = 0;
 var $zt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 40|0;
 $1 = sp + 36|0;
 $2 = sp + 32|0;
 $ilen = sp + 8|0;
 $zl = sp;
 $i = sp + 28|0;
 $zi = sp + 24|0;
 $zo = sp + 20|0;
 $zt = sp + 16|0;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$i>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),771,(17507|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = ($7|0)==(5);
 if ($8) {
  $9 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($9);
  STACKTOP = sp;return;
 }
 $10 = HEAP32[$2>>2]|0;
 $11 = HEAP32[$10>>2]|0;
 $12 = (_sqlite3_value_text($11)|0);
 HEAP32[$zi>>2] = $12;
 $13 = HEAP32[$2>>2]|0;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = (_sqlite3_value_int64($15)|0);
 $17 = tempRet0;
 $18 = $ilen;
 $19 = $18;
 HEAP32[$19>>2] = $16;
 $20 = (($18) + 4)|0;
 $21 = $20;
 HEAP32[$21>>2] = $17;
 $22 = $ilen;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 $25 = (($22) + 4)|0;
 $26 = $25;
 $27 = HEAP32[$26>>2]|0;
 $28 = ($27|0)<(0);
 if ($28) {
  $29 = HEAP32[$0>>2]|0;
  _sqlite3_result_error($29,17412,-1);
  STACKTOP = sp;return;
 }
 $30 = HEAP32[$zi>>2]|0;
 $31 = (_sqlite3Utf8CharLen($30,-1)|0);
 $32 = ($31|0)<(0);
 $33 = $32 << 31 >> 31;
 $34 = $zl;
 $35 = $34;
 HEAP32[$35>>2] = $31;
 $36 = (($34) + 4)|0;
 $37 = $36;
 HEAP32[$37>>2] = $33;
 $38 = $zl;
 $39 = $38;
 $40 = HEAP32[$39>>2]|0;
 $41 = (($38) + 4)|0;
 $42 = $41;
 $43 = HEAP32[$42>>2]|0;
 $44 = $ilen;
 $45 = $44;
 $46 = HEAP32[$45>>2]|0;
 $47 = (($44) + 4)|0;
 $48 = $47;
 $49 = HEAP32[$48>>2]|0;
 $50 = ($43|0)>($49|0);
 $51 = ($40>>>0)>=($46>>>0);
 $52 = ($43|0)==($49|0);
 $53 = $52 & $51;
 $54 = $50 | $53;
 $55 = HEAP32[$zi>>2]|0;
 do {
  if ($54) {
   $56 = (_sqlite3StrDup($55)|0);
   HEAP32[$zo>>2] = $56;
   $57 = HEAP32[$zo>>2]|0;
   $58 = ($57|0)!=(0|0);
   $59 = HEAP32[$0>>2]|0;
   if ($58) {
    $60 = HEAP32[$zo>>2]|0;
    _sqlite3_result_text($59,$60,-1,(-1));
    break;
   }
   _sqlite3_result_error_nomem($59);
   STACKTOP = sp;return;
  } else {
   $61 = (_strlen($55)|0);
   $62 = $ilen;
   $63 = $62;
   $64 = HEAP32[$63>>2]|0;
   $65 = (($62) + 4)|0;
   $66 = $65;
   $67 = HEAP32[$66>>2]|0;
   $68 = (_i64Add(($61|0),0,($64|0),($67|0))|0);
   $69 = tempRet0;
   $70 = $zl;
   $71 = $70;
   $72 = HEAP32[$71>>2]|0;
   $73 = (($70) + 4)|0;
   $74 = $73;
   $75 = HEAP32[$74>>2]|0;
   $76 = (_i64Subtract(($68|0),($69|0),($72|0),($75|0))|0);
   $77 = tempRet0;
   $78 = (_i64Add(($76|0),($77|0),1,0)|0);
   $79 = tempRet0;
   $80 = (_sqlite3_malloc($78)|0);
   HEAP32[$zo>>2] = $80;
   $81 = HEAP32[$zo>>2]|0;
   $82 = ($81|0)!=(0|0);
   if (!($82)) {
    $83 = HEAP32[$0>>2]|0;
    _sqlite3_result_error_nomem($83);
    STACKTOP = sp;return;
   }
   $84 = HEAP32[$zo>>2]|0;
   HEAP32[$zt>>2] = $84;
   HEAP32[$i>>2] = 1;
   while(1) {
    $85 = HEAP32[$i>>2]|0;
    $86 = ($85|0)<(0);
    $87 = $86 << 31 >> 31;
    $88 = $zl;
    $89 = $88;
    $90 = HEAP32[$89>>2]|0;
    $91 = (($88) + 4)|0;
    $92 = $91;
    $93 = HEAP32[$92>>2]|0;
    $94 = (_i64Add(($85|0),($87|0),($90|0),($93|0))|0);
    $95 = tempRet0;
    $96 = $ilen;
    $97 = $96;
    $98 = HEAP32[$97>>2]|0;
    $99 = (($96) + 4)|0;
    $100 = $99;
    $101 = HEAP32[$100>>2]|0;
    $102 = ($95|0)<($101|0);
    $103 = ($94>>>0)<=($98>>>0);
    $104 = ($95|0)==($101|0);
    $105 = $104 & $103;
    $106 = $102 | $105;
    $107 = HEAP32[$zt>>2]|0;
    if (!($106)) {
     break;
    }
    $108 = ((($107)) + 1|0);
    HEAP32[$zt>>2] = $108;
    HEAP8[$107>>0] = 32;
    $109 = HEAP32[$i>>2]|0;
    $110 = (($109) + 1)|0;
    HEAP32[$i>>2] = $110;
   }
   $111 = HEAP32[$zi>>2]|0;
   (_strcpy($107,$111)|0);
  }
 } while(0);
 $112 = HEAP32[$0>>2]|0;
 $113 = HEAP32[$zo>>2]|0;
 _sqlite3_result_text($112,$113,-1,(-1));
 $114 = HEAP32[$zo>>2]|0;
 _sqlite3_free($114);
 STACKTOP = sp;return;
}
function _padrFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0;
 var $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0;
 var $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0;
 var $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0;
 var $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i = 0, $ilen = 0, $zi = 0, $zl = 0, $zll = 0, $zo = 0, $zt = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $0 = sp + 48|0;
 $1 = sp + 44|0;
 $2 = sp + 40|0;
 $ilen = sp + 16|0;
 $zl = sp + 8|0;
 $zll = sp;
 $i = sp + 36|0;
 $zi = sp + 32|0;
 $zo = sp + 28|0;
 $zt = sp + 24|0;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$i>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),825,(17544|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = ($7|0)==(5);
 if ($8) {
  $9 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($9);
  STACKTOP = sp;return;
 }
 $10 = HEAP32[$2>>2]|0;
 $11 = HEAP32[$10>>2]|0;
 $12 = (_sqlite3_value_text($11)|0);
 HEAP32[$zi>>2] = $12;
 $13 = HEAP32[$2>>2]|0;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = (_sqlite3_value_int64($15)|0);
 $17 = tempRet0;
 $18 = $ilen;
 $19 = $18;
 HEAP32[$19>>2] = $16;
 $20 = (($18) + 4)|0;
 $21 = $20;
 HEAP32[$21>>2] = $17;
 $22 = $ilen;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 $25 = (($22) + 4)|0;
 $26 = $25;
 $27 = HEAP32[$26>>2]|0;
 $28 = ($27|0)<(0);
 if ($28) {
  $29 = HEAP32[$0>>2]|0;
  _sqlite3_result_error($29,17412,-1);
  STACKTOP = sp;return;
 }
 $30 = HEAP32[$zi>>2]|0;
 $31 = (_sqlite3Utf8CharLen($30,-1)|0);
 $32 = ($31|0)<(0);
 $33 = $32 << 31 >> 31;
 $34 = $zl;
 $35 = $34;
 HEAP32[$35>>2] = $31;
 $36 = (($34) + 4)|0;
 $37 = $36;
 HEAP32[$37>>2] = $33;
 $38 = $zl;
 $39 = $38;
 $40 = HEAP32[$39>>2]|0;
 $41 = (($38) + 4)|0;
 $42 = $41;
 $43 = HEAP32[$42>>2]|0;
 $44 = $ilen;
 $45 = $44;
 $46 = HEAP32[$45>>2]|0;
 $47 = (($44) + 4)|0;
 $48 = $47;
 $49 = HEAP32[$48>>2]|0;
 $50 = ($43|0)>($49|0);
 $51 = ($40>>>0)>=($46>>>0);
 $52 = ($43|0)==($49|0);
 $53 = $52 & $51;
 $54 = $50 | $53;
 $55 = HEAP32[$zi>>2]|0;
 do {
  if ($54) {
   $56 = (_sqlite3StrDup($55)|0);
   HEAP32[$zo>>2] = $56;
   $57 = HEAP32[$zo>>2]|0;
   $58 = ($57|0)!=(0|0);
   $59 = HEAP32[$0>>2]|0;
   if ($58) {
    $60 = HEAP32[$zo>>2]|0;
    _sqlite3_result_text($59,$60,-1,(-1));
    break;
   }
   _sqlite3_result_error_nomem($59);
   STACKTOP = sp;return;
  } else {
   $61 = (_strlen($55)|0);
   $62 = $zll;
   $63 = $62;
   HEAP32[$63>>2] = $61;
   $64 = (($62) + 4)|0;
   $65 = $64;
   HEAP32[$65>>2] = 0;
   $66 = $zll;
   $67 = $66;
   $68 = HEAP32[$67>>2]|0;
   $69 = (($66) + 4)|0;
   $70 = $69;
   $71 = HEAP32[$70>>2]|0;
   $72 = $ilen;
   $73 = $72;
   $74 = HEAP32[$73>>2]|0;
   $75 = (($72) + 4)|0;
   $76 = $75;
   $77 = HEAP32[$76>>2]|0;
   $78 = (_i64Add(($68|0),($71|0),($74|0),($77|0))|0);
   $79 = tempRet0;
   $80 = $zl;
   $81 = $80;
   $82 = HEAP32[$81>>2]|0;
   $83 = (($80) + 4)|0;
   $84 = $83;
   $85 = HEAP32[$84>>2]|0;
   $86 = (_i64Subtract(($78|0),($79|0),($82|0),($85|0))|0);
   $87 = tempRet0;
   $88 = (_i64Add(($86|0),($87|0),1,0)|0);
   $89 = tempRet0;
   $90 = (_sqlite3_malloc($88)|0);
   HEAP32[$zo>>2] = $90;
   $91 = HEAP32[$zo>>2]|0;
   $92 = ($91|0)!=(0|0);
   if (!($92)) {
    $93 = HEAP32[$0>>2]|0;
    _sqlite3_result_error_nomem($93);
    STACKTOP = sp;return;
   }
   $94 = HEAP32[$zo>>2]|0;
   $95 = HEAP32[$zi>>2]|0;
   $96 = (_strcpy($94,$95)|0);
   $97 = $zll;
   $98 = $97;
   $99 = HEAP32[$98>>2]|0;
   $100 = (($97) + 4)|0;
   $101 = $100;
   $102 = HEAP32[$101>>2]|0;
   $103 = (($96) + ($99)|0);
   HEAP32[$zt>>2] = $103;
   HEAP32[$i>>2] = 1;
   while(1) {
    $104 = HEAP32[$i>>2]|0;
    $105 = ($104|0)<(0);
    $106 = $105 << 31 >> 31;
    $107 = $zl;
    $108 = $107;
    $109 = HEAP32[$108>>2]|0;
    $110 = (($107) + 4)|0;
    $111 = $110;
    $112 = HEAP32[$111>>2]|0;
    $113 = (_i64Add(($104|0),($106|0),($109|0),($112|0))|0);
    $114 = tempRet0;
    $115 = $ilen;
    $116 = $115;
    $117 = HEAP32[$116>>2]|0;
    $118 = (($115) + 4)|0;
    $119 = $118;
    $120 = HEAP32[$119>>2]|0;
    $121 = ($114|0)<($120|0);
    $122 = ($113>>>0)<=($117>>>0);
    $123 = ($114|0)==($120|0);
    $124 = $123 & $122;
    $125 = $121 | $124;
    $126 = HEAP32[$zt>>2]|0;
    if (!($125)) {
     break;
    }
    $127 = ((($126)) + 1|0);
    HEAP32[$zt>>2] = $127;
    HEAP8[$126>>0] = 32;
    $128 = HEAP32[$i>>2]|0;
    $129 = (($128) + 1)|0;
    HEAP32[$i>>2] = $129;
   }
   HEAP8[$126>>0] = 0;
  }
 } while(0);
 $130 = HEAP32[$0>>2]|0;
 $131 = HEAP32[$zo>>2]|0;
 _sqlite3_result_text($130,$131,-1,(-1));
 $132 = HEAP32[$zo>>2]|0;
 _sqlite3_free($132);
 STACKTOP = sp;return;
}
function _padcFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0;
 var $i = 0, $ilen = 0, $zi = 0, $zl = 0, $zll = 0, $zo = 0, $zt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $0 = sp + 48|0;
 $1 = sp + 44|0;
 $2 = sp + 40|0;
 $ilen = sp + 16|0;
 $zl = sp + 8|0;
 $zll = sp;
 $i = sp + 36|0;
 $zi = sp + 32|0;
 $zo = sp + 28|0;
 $zt = sp + 24|0;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$i>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),880,(17553|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = ($7|0)==(5);
 if ($8) {
  $9 = HEAP32[$0>>2]|0;
  _sqlite3_result_null($9);
  STACKTOP = sp;return;
 }
 $10 = HEAP32[$2>>2]|0;
 $11 = HEAP32[$10>>2]|0;
 $12 = (_sqlite3_value_text($11)|0);
 HEAP32[$zi>>2] = $12;
 $13 = HEAP32[$2>>2]|0;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = (_sqlite3_value_int64($15)|0);
 $17 = tempRet0;
 $18 = $ilen;
 $19 = $18;
 HEAP32[$19>>2] = $16;
 $20 = (($18) + 4)|0;
 $21 = $20;
 HEAP32[$21>>2] = $17;
 $22 = $ilen;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 $25 = (($22) + 4)|0;
 $26 = $25;
 $27 = HEAP32[$26>>2]|0;
 $28 = ($27|0)<(0);
 if ($28) {
  $29 = HEAP32[$0>>2]|0;
  _sqlite3_result_error($29,17412,-1);
  STACKTOP = sp;return;
 }
 $30 = HEAP32[$zi>>2]|0;
 $31 = (_sqlite3Utf8CharLen($30,-1)|0);
 $32 = ($31|0)<(0);
 $33 = $32 << 31 >> 31;
 $34 = $zl;
 $35 = $34;
 HEAP32[$35>>2] = $31;
 $36 = (($34) + 4)|0;
 $37 = $36;
 HEAP32[$37>>2] = $33;
 $38 = $zl;
 $39 = $38;
 $40 = HEAP32[$39>>2]|0;
 $41 = (($38) + 4)|0;
 $42 = $41;
 $43 = HEAP32[$42>>2]|0;
 $44 = $ilen;
 $45 = $44;
 $46 = HEAP32[$45>>2]|0;
 $47 = (($44) + 4)|0;
 $48 = $47;
 $49 = HEAP32[$48>>2]|0;
 $50 = ($43|0)>($49|0);
 $51 = ($40>>>0)>=($46>>>0);
 $52 = ($43|0)==($49|0);
 $53 = $52 & $51;
 $54 = $50 | $53;
 $55 = HEAP32[$zi>>2]|0;
 do {
  if ($54) {
   $56 = (_sqlite3StrDup($55)|0);
   HEAP32[$zo>>2] = $56;
   $57 = HEAP32[$zo>>2]|0;
   $58 = ($57|0)!=(0|0);
   $59 = HEAP32[$0>>2]|0;
   if ($58) {
    $60 = HEAP32[$zo>>2]|0;
    _sqlite3_result_text($59,$60,-1,(-1));
    break;
   }
   _sqlite3_result_error_nomem($59);
   STACKTOP = sp;return;
  } else {
   $61 = (_strlen($55)|0);
   $62 = $zll;
   $63 = $62;
   HEAP32[$63>>2] = $61;
   $64 = (($62) + 4)|0;
   $65 = $64;
   HEAP32[$65>>2] = 0;
   $66 = $zll;
   $67 = $66;
   $68 = HEAP32[$67>>2]|0;
   $69 = (($66) + 4)|0;
   $70 = $69;
   $71 = HEAP32[$70>>2]|0;
   $72 = $ilen;
   $73 = $72;
   $74 = HEAP32[$73>>2]|0;
   $75 = (($72) + 4)|0;
   $76 = $75;
   $77 = HEAP32[$76>>2]|0;
   $78 = (_i64Add(($68|0),($71|0),($74|0),($77|0))|0);
   $79 = tempRet0;
   $80 = $zl;
   $81 = $80;
   $82 = HEAP32[$81>>2]|0;
   $83 = (($80) + 4)|0;
   $84 = $83;
   $85 = HEAP32[$84>>2]|0;
   $86 = (_i64Subtract(($78|0),($79|0),($82|0),($85|0))|0);
   $87 = tempRet0;
   $88 = (_i64Add(($86|0),($87|0),1,0)|0);
   $89 = tempRet0;
   $90 = (_sqlite3_malloc($88)|0);
   HEAP32[$zo>>2] = $90;
   $91 = HEAP32[$zo>>2]|0;
   $92 = ($91|0)!=(0|0);
   if (!($92)) {
    $93 = HEAP32[$0>>2]|0;
    _sqlite3_result_error_nomem($93);
    STACKTOP = sp;return;
   }
   $94 = HEAP32[$zo>>2]|0;
   HEAP32[$zt>>2] = $94;
   HEAP32[$i>>2] = 1;
   while(1) {
    $95 = HEAP32[$i>>2]|0;
    $96 = $95<<1;
    $97 = ($96|0)<(0);
    $98 = $97 << 31 >> 31;
    $99 = $zl;
    $100 = $99;
    $101 = HEAP32[$100>>2]|0;
    $102 = (($99) + 4)|0;
    $103 = $102;
    $104 = HEAP32[$103>>2]|0;
    $105 = (_i64Add(($96|0),($98|0),($101|0),($104|0))|0);
    $106 = tempRet0;
    $107 = $ilen;
    $108 = $107;
    $109 = HEAP32[$108>>2]|0;
    $110 = (($107) + 4)|0;
    $111 = $110;
    $112 = HEAP32[$111>>2]|0;
    $113 = ($106|0)<($112|0);
    $114 = ($105>>>0)<=($109>>>0);
    $115 = ($106|0)==($112|0);
    $116 = $115 & $114;
    $117 = $113 | $116;
    $118 = HEAP32[$zt>>2]|0;
    if (!($117)) {
     break;
    }
    $119 = ((($118)) + 1|0);
    HEAP32[$zt>>2] = $119;
    HEAP8[$118>>0] = 32;
    $120 = HEAP32[$i>>2]|0;
    $121 = (($120) + 1)|0;
    HEAP32[$i>>2] = $121;
   }
   $122 = HEAP32[$zi>>2]|0;
   (_strcpy($118,$122)|0);
   $123 = $zll;
   $124 = $123;
   $125 = HEAP32[$124>>2]|0;
   $126 = (($123) + 4)|0;
   $127 = $126;
   $128 = HEAP32[$127>>2]|0;
   $129 = HEAP32[$zt>>2]|0;
   $130 = (($129) + ($125)|0);
   HEAP32[$zt>>2] = $130;
   while(1) {
    $131 = HEAP32[$i>>2]|0;
    $132 = ($131|0)<(0);
    $133 = $132 << 31 >> 31;
    $134 = $zl;
    $135 = $134;
    $136 = HEAP32[$135>>2]|0;
    $137 = (($134) + 4)|0;
    $138 = $137;
    $139 = HEAP32[$138>>2]|0;
    $140 = (_i64Add(($131|0),($133|0),($136|0),($139|0))|0);
    $141 = tempRet0;
    $142 = $ilen;
    $143 = $142;
    $144 = HEAP32[$143>>2]|0;
    $145 = (($142) + 4)|0;
    $146 = $145;
    $147 = HEAP32[$146>>2]|0;
    $148 = ($141|0)<($147|0);
    $149 = ($140>>>0)<=($144>>>0);
    $150 = ($141|0)==($147|0);
    $151 = $150 & $149;
    $152 = $148 | $151;
    $153 = HEAP32[$zt>>2]|0;
    if (!($152)) {
     break;
    }
    $154 = ((($153)) + 1|0);
    HEAP32[$zt>>2] = $154;
    HEAP8[$153>>0] = 32;
    $155 = HEAP32[$i>>2]|0;
    $156 = (($155) + 1)|0;
    HEAP32[$i>>2] = $156;
   }
   HEAP8[$153>>0] = 0;
  }
 } while(0);
 $157 = HEAP32[$0>>2]|0;
 $158 = HEAP32[$zo>>2]|0;
 _sqlite3_result_text($157,$158,-1,(-1));
 $159 = HEAP32[$zo>>2]|0;
 _sqlite3_free($159);
 STACKTOP = sp;return;
}
function _strfilterFunc($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $9 = 0;
 var $c1 = 0, $c2 = 0, $z1 = 0, $z21 = 0, $z22 = 0, $zi1 = 0, $zi2 = 0, $zo = 0, $zot = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 44|0;
 $1 = sp + 40|0;
 $2 = sp + 36|0;
 $zi1 = sp + 32|0;
 $zi2 = sp + 28|0;
 $z1 = sp + 24|0;
 $z21 = sp + 20|0;
 $z22 = sp + 16|0;
 $zo = sp + 12|0;
 $zot = sp + 8|0;
 $c1 = sp + 4|0;
 $c2 = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 HEAP32[$c1>>2] = 0;
 HEAP32[$c2>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(2);
 if (!($4)) {
  ___assert_fail((16785|0),(16734|0),939,(17562|0));
  // unreachable;
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3_value_type($6)|0);
 $8 = ($7|0)==(5);
 if (!($8)) {
  $9 = HEAP32[$2>>2]|0;
  $10 = ((($9)) + 4|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (_sqlite3_value_type($11)|0);
  $13 = ($12|0)==(5);
  if (!($13)) {
   $15 = HEAP32[$2>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   $17 = (_sqlite3_value_text($16)|0);
   HEAP32[$zi1>>2] = $17;
   $18 = HEAP32[$2>>2]|0;
   $19 = ((($18)) + 4|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = (_sqlite3_value_text($20)|0);
   HEAP32[$zi2>>2] = $21;
   $22 = HEAP32[$zi1>>2]|0;
   $23 = (_strlen($22)|0);
   $24 = (($23) + 1)|0;
   $25 = (_sqlite3_malloc($24)|0);
   HEAP32[$zo>>2] = $25;
   $26 = HEAP32[$zo>>2]|0;
   $27 = ($26|0)!=(0|0);
   if (!($27)) {
    $28 = HEAP32[$0>>2]|0;
    _sqlite3_result_error_nomem($28);
    STACKTOP = sp;return;
   }
   $29 = HEAP32[$zo>>2]|0;
   HEAP32[$zot>>2] = $29;
   $30 = HEAP32[$zi1>>2]|0;
   HEAP32[$z1>>2] = $30;
   L11: while(1) {
    $31 = HEAP32[$z1>>2]|0;
    $32 = (_sqlite3ReadUtf8($31)|0);
    HEAP32[$c1>>2] = $32;
    $33 = ($32|0)!=(0);
    if (!($33)) {
     break;
    }
    $34 = HEAP32[$zi2>>2]|0;
    HEAP32[$z21>>2] = $34;
    L14: while(1) {
     $35 = HEAP32[$z21>>2]|0;
     $36 = (_sqlite3ReadUtf8($35)|0);
     HEAP32[$c2>>2] = $36;
     $37 = ($36|0)!=(0);
     if (!($37)) {
      break;
     }
     $38 = HEAP32[$c2>>2]|0;
     $39 = HEAP32[$c1>>2]|0;
     $40 = ($38|0)!=($39|0);
     if (!($40)) {
      break;
     }
     while(1) {
      $41 = HEAP32[$z21>>2]|0;
      $42 = ((($41)) + 1|0);
      HEAP32[$z21>>2] = $42;
      $43 = HEAP8[$42>>0]|0;
      $44 = $43 << 24 >> 24;
      $45 = 192 & $44;
      $46 = ($45|0)==(128);
      if (!($46)) {
       continue L14;
      }
     }
    }
    $47 = HEAP32[$c2>>2]|0;
    $48 = ($47|0)!=(0);
    if ($48) {
     $49 = HEAP32[$z21>>2]|0;
     HEAP32[$z22>>2] = $49;
     while(1) {
      $50 = HEAP32[$z22>>2]|0;
      $51 = ((($50)) + 1|0);
      HEAP32[$z22>>2] = $51;
      $52 = HEAP8[$51>>0]|0;
      $53 = $52 << 24 >> 24;
      $54 = 192 & $53;
      $55 = ($54|0)==(128);
      if (!($55)) {
       break;
      }
     }
     $56 = HEAP32[$zot>>2]|0;
     $57 = HEAP32[$z21>>2]|0;
     $58 = HEAP32[$z22>>2]|0;
     $59 = HEAP32[$z21>>2]|0;
     $60 = $58;
     $61 = $59;
     $62 = (($60) - ($61))|0;
     (_strncpy($56,$57,$62)|0);
     $63 = HEAP32[$z22>>2]|0;
     $64 = HEAP32[$z21>>2]|0;
     $65 = $63;
     $66 = $64;
     $67 = (($65) - ($66))|0;
     $68 = HEAP32[$zot>>2]|0;
     $69 = (($68) + ($67)|0);
     HEAP32[$zot>>2] = $69;
    }
    while(1) {
     $70 = HEAP32[$z1>>2]|0;
     $71 = ((($70)) + 1|0);
     HEAP32[$z1>>2] = $71;
     $72 = HEAP8[$71>>0]|0;
     $73 = $72 << 24 >> 24;
     $74 = 192 & $73;
     $75 = ($74|0)==(128);
     if (!($75)) {
      continue L11;
     }
    }
   }
   $76 = HEAP32[$zot>>2]|0;
   HEAP8[$76>>0] = 0;
   $77 = HEAP32[$0>>2]|0;
   $78 = HEAP32[$zo>>2]|0;
   _sqlite3_result_text($77,$78,-1,(-1));
   $79 = HEAP32[$zo>>2]|0;
   _sqlite3_free($79);
   STACKTOP = sp;return;
  }
 }
 $14 = HEAP32[$0>>2]|0;
 _sqlite3_result_null($14);
 STACKTOP = sp;return;
}
function _varianceStep($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0.0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0.0, $32 = 0.0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0.0, $42 = 0.0, $43 = 0, $44 = 0.0;
 var $45 = 0.0, $46 = 0.0, $47 = 0.0, $48 = 0, $49 = 0.0, $5 = 0, $50 = 0.0, $51 = 0.0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0.0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $delta = 0, $p = 0, $x = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $p = sp + 16|0;
 $delta = sp + 8|0;
 $x = sp;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(1);
 if (!($4)) {
  ___assert_fail((16726|0),(16734|0),1395,(17576|0));
  // unreachable;
 }
 $5 = HEAP32[$0>>2]|0;
 $6 = (_sqlite3_aggregate_context($5,24)|0);
 HEAP32[$p>>2] = $6;
 $7 = HEAP32[$2>>2]|0;
 $8 = HEAP32[$7>>2]|0;
 $9 = (_sqlite3_value_numeric_type($8)|0);
 $10 = (5)!=($9|0);
 if (!($10)) {
  STACKTOP = sp;return;
 }
 $11 = HEAP32[$p>>2]|0;
 $12 = ((($11)) + 16|0);
 $13 = $12;
 $14 = $13;
 $15 = HEAP32[$14>>2]|0;
 $16 = (($13) + 4)|0;
 $17 = $16;
 $18 = HEAP32[$17>>2]|0;
 $19 = (_i64Add(($15|0),($18|0),1,0)|0);
 $20 = tempRet0;
 $21 = $12;
 $22 = $21;
 HEAP32[$22>>2] = $19;
 $23 = (($21) + 4)|0;
 $24 = $23;
 HEAP32[$24>>2] = $20;
 $25 = HEAP32[$2>>2]|0;
 $26 = HEAP32[$25>>2]|0;
 $27 = (+_sqlite3_value_double($26));
 HEAPF64[$x>>3] = $27;
 $28 = +HEAPF64[$x>>3];
 $29 = HEAP32[$p>>2]|0;
 $30 = +HEAPF64[$29>>3];
 $31 = $28 - $30;
 HEAPF64[$delta>>3] = $31;
 $32 = +HEAPF64[$delta>>3];
 $33 = HEAP32[$p>>2]|0;
 $34 = ((($33)) + 16|0);
 $35 = $34;
 $36 = $35;
 $37 = HEAP32[$36>>2]|0;
 $38 = (($35) + 4)|0;
 $39 = $38;
 $40 = HEAP32[$39>>2]|0;
 $41 = (+($37>>>0)) + (4294967296.0*(+($40|0)));
 $42 = $32 / $41;
 $43 = HEAP32[$p>>2]|0;
 $44 = +HEAPF64[$43>>3];
 $45 = $44 + $42;
 HEAPF64[$43>>3] = $45;
 $46 = +HEAPF64[$delta>>3];
 $47 = +HEAPF64[$x>>3];
 $48 = HEAP32[$p>>2]|0;
 $49 = +HEAPF64[$48>>3];
 $50 = $47 - $49;
 $51 = $46 * $50;
 $52 = HEAP32[$p>>2]|0;
 $53 = ((($52)) + 8|0);
 $54 = +HEAPF64[$53>>3];
 $55 = $54 + $51;
 HEAPF64[$53>>3] = $55;
 STACKTOP = sp;return;
}
function _stdevFinalize($context) {
 $context = $context|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0.0, $33 = 0.0, $34 = 0.0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $context;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_aggregate_context($1,0)|0);
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ($3|0)!=(0|0);
 if ($4) {
  $5 = HEAP32[$p>>2]|0;
  $6 = ((($5)) + 16|0);
  $7 = $6;
  $8 = $7;
  $9 = HEAP32[$8>>2]|0;
  $10 = (($7) + 4)|0;
  $11 = $10;
  $12 = HEAP32[$11>>2]|0;
  $13 = ($12|0)>(0);
  $14 = ($9>>>0)>(1);
  $15 = ($12|0)==(0);
  $16 = $15 & $14;
  $17 = $13 | $16;
  if ($17) {
   $18 = HEAP32[$0>>2]|0;
   $19 = HEAP32[$p>>2]|0;
   $20 = ((($19)) + 8|0);
   $21 = +HEAPF64[$20>>3];
   $22 = HEAP32[$p>>2]|0;
   $23 = ((($22)) + 16|0);
   $24 = $23;
   $25 = $24;
   $26 = HEAP32[$25>>2]|0;
   $27 = (($24) + 4)|0;
   $28 = $27;
   $29 = HEAP32[$28>>2]|0;
   $30 = (_i64Subtract(($26|0),($29|0),1,0)|0);
   $31 = tempRet0;
   $32 = (+($30>>>0)) + (4294967296.0*(+($31|0)));
   $33 = $21 / $32;
   $34 = (+Math_sqrt((+$33)));
   _sqlite3_result_double($18,$34);
   STACKTOP = sp;return;
  }
 }
 $35 = HEAP32[$0>>2]|0;
 _sqlite3_result_double($35,0.0);
 STACKTOP = sp;return;
}
function _varianceFinalize($context) {
 $context = $context|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0.0, $33 = 0.0, $34 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $context;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_aggregate_context($1,0)|0);
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ($3|0)!=(0|0);
 if ($4) {
  $5 = HEAP32[$p>>2]|0;
  $6 = ((($5)) + 16|0);
  $7 = $6;
  $8 = $7;
  $9 = HEAP32[$8>>2]|0;
  $10 = (($7) + 4)|0;
  $11 = $10;
  $12 = HEAP32[$11>>2]|0;
  $13 = ($12|0)>(0);
  $14 = ($9>>>0)>(1);
  $15 = ($12|0)==(0);
  $16 = $15 & $14;
  $17 = $13 | $16;
  if ($17) {
   $18 = HEAP32[$0>>2]|0;
   $19 = HEAP32[$p>>2]|0;
   $20 = ((($19)) + 8|0);
   $21 = +HEAPF64[$20>>3];
   $22 = HEAP32[$p>>2]|0;
   $23 = ((($22)) + 16|0);
   $24 = $23;
   $25 = $24;
   $26 = HEAP32[$25>>2]|0;
   $27 = (($24) + 4)|0;
   $28 = $27;
   $29 = HEAP32[$28>>2]|0;
   $30 = (_i64Subtract(($26|0),($29|0),1,0)|0);
   $31 = tempRet0;
   $32 = (+($30>>>0)) + (4294967296.0*(+($31|0)));
   $33 = $21 / $32;
   _sqlite3_result_double($18,$33);
   STACKTOP = sp;return;
  }
 }
 $34 = HEAP32[$0>>2]|0;
 _sqlite3_result_double($34,0.0);
 STACKTOP = sp;return;
}
function _modeStep($context,$argc,$argv) {
 $context = $context|0;
 $argc = $argc|0;
 $argv = $argv|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0;
 var $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0.0, $94 = 0, $95 = 0.0, $96 = 0, $97 = 0, $98 = 0;
 var $99 = 0, $dptr = 0, $iptr = 0, $p = 0, $type = 0, $xd = 0, $xi = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0;
 $0 = sp + 64|0;
 $1 = sp + 60|0;
 $2 = sp + 56|0;
 $p = sp + 52|0;
 $xi = sp + 8|0;
 $xd = sp;
 $iptr = sp + 48|0;
 $dptr = sp + 44|0;
 $type = sp + 40|0;
 $3 = sp + 28|0;
 $4 = sp + 16|0;
 HEAP32[$0>>2] = $context;
 HEAP32[$1>>2] = $argc;
 HEAP32[$2>>2] = $argv;
 $5 = $xi;
 $6 = $5;
 HEAP32[$6>>2] = 0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = 0;
 HEAPF64[$xd>>3] = 0.0;
 $9 = HEAP32[$1>>2]|0;
 $10 = ($9|0)==(1);
 if (!($10)) {
  ___assert_fail((16726|0),(16734|0),1418,(17589|0));
  // unreachable;
 }
 $11 = HEAP32[$2>>2]|0;
 $12 = HEAP32[$11>>2]|0;
 $13 = (_sqlite3_value_numeric_type($12)|0);
 HEAP32[$type>>2] = $13;
 $14 = HEAP32[$type>>2]|0;
 $15 = ($14|0)==(5);
 if ($15) {
  STACKTOP = sp;return;
 }
 $16 = HEAP32[$0>>2]|0;
 $17 = (_sqlite3_aggregate_context($16,64)|0);
 HEAP32[$p>>2] = $17;
 $18 = HEAP32[$p>>2]|0;
 $19 = ((($18)) + 56|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = (0|0)==($20|0);
 do {
  if ($21) {
   $22 = (_calloc(1,12)|0);
   $23 = HEAP32[$p>>2]|0;
   $24 = ((($23)) + 56|0);
   HEAP32[$24>>2] = $22;
   $25 = HEAP32[$type>>2]|0;
   $26 = ($25|0)==(1);
   $27 = HEAP32[$p>>2]|0;
   if ($26) {
    $28 = ((($27)) + 56|0);
    $29 = HEAP32[$28>>2]|0;
    _map_make($3,176);
    ;HEAP32[$29>>2]=HEAP32[$3>>2]|0;HEAP32[$29+4>>2]=HEAP32[$3+4>>2]|0;HEAP32[$29+8>>2]=HEAP32[$3+8>>2]|0;
    $30 = HEAP32[$p>>2]|0;
    $31 = ((($30)) + 48|0);
    $32 = $31;
    $33 = $32;
    HEAP32[$33>>2] = 0;
    $34 = (($32) + 4)|0;
    $35 = $34;
    HEAP32[$35>>2] = 0;
    break;
   } else {
    $36 = ((($27)) + 48|0);
    $37 = $36;
    $38 = $37;
    HEAP32[$38>>2] = 1;
    $39 = (($37) + 4)|0;
    $40 = $39;
    HEAP32[$40>>2] = 0;
    $41 = HEAP32[$p>>2]|0;
    $42 = ((($41)) + 56|0);
    $43 = HEAP32[$42>>2]|0;
    _map_make($4,177);
    ;HEAP32[$43>>2]=HEAP32[$4>>2]|0;HEAP32[$43+4>>2]=HEAP32[$4+4>>2]|0;HEAP32[$43+8>>2]=HEAP32[$4+8>>2]|0;
    break;
   }
  }
 } while(0);
 $44 = HEAP32[$p>>2]|0;
 $45 = ((($44)) + 16|0);
 $46 = $45;
 $47 = $46;
 $48 = HEAP32[$47>>2]|0;
 $49 = (($46) + 4)|0;
 $50 = $49;
 $51 = HEAP32[$50>>2]|0;
 $52 = (_i64Add(($48|0),($51|0),1,0)|0);
 $53 = tempRet0;
 $54 = $45;
 $55 = $54;
 HEAP32[$55>>2] = $52;
 $56 = (($54) + 4)|0;
 $57 = $56;
 HEAP32[$57>>2] = $53;
 $58 = HEAP32[$p>>2]|0;
 $59 = ((($58)) + 48|0);
 $60 = $59;
 $61 = $60;
 $62 = HEAP32[$61>>2]|0;
 $63 = (($60) + 4)|0;
 $64 = $63;
 $65 = HEAP32[$64>>2]|0;
 $66 = (0)==($62|0);
 $67 = (0)==($65|0);
 $68 = $66 & $67;
 $69 = HEAP32[$2>>2]|0;
 $70 = HEAP32[$69>>2]|0;
 if ($68) {
  $71 = (_sqlite3_value_int64($70)|0);
  $72 = tempRet0;
  $73 = $xi;
  $74 = $73;
  HEAP32[$74>>2] = $71;
  $75 = (($73) + 4)|0;
  $76 = $75;
  HEAP32[$76>>2] = $72;
  $77 = (_calloc(1,8)|0);
  HEAP32[$iptr>>2] = $77;
  $78 = $xi;
  $79 = $78;
  $80 = HEAP32[$79>>2]|0;
  $81 = (($78) + 4)|0;
  $82 = $81;
  $83 = HEAP32[$82>>2]|0;
  $84 = HEAP32[$iptr>>2]|0;
  $85 = $84;
  $86 = $85;
  HEAP32[$86>>2] = $80;
  $87 = (($85) + 4)|0;
  $88 = $87;
  HEAP32[$88>>2] = $83;
  $89 = HEAP32[$p>>2]|0;
  $90 = ((($89)) + 56|0);
  $91 = HEAP32[$90>>2]|0;
  $92 = HEAP32[$iptr>>2]|0;
  _map_insert($91,$92);
  STACKTOP = sp;return;
 } else {
  $93 = (+_sqlite3_value_double($70));
  HEAPF64[$xd>>3] = $93;
  $94 = (_calloc(1,8)|0);
  HEAP32[$dptr>>2] = $94;
  $95 = +HEAPF64[$xd>>3];
  $96 = HEAP32[$dptr>>2]|0;
  HEAPF64[$96>>3] = $95;
  $97 = HEAP32[$p>>2]|0;
  $98 = ((($97)) + 56|0);
  $99 = HEAP32[$98>>2]|0;
  $100 = HEAP32[$dptr>>2]|0;
  _map_insert($99,$100);
  STACKTOP = sp;return;
 }
}
function _modeFinalize($context) {
 $context = $context|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0.0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $context;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_aggregate_context($1,0)|0);
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$p>>2]|0;
 $6 = ((($5)) + 56|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)!=(0|0);
 if (!($8)) {
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$p>>2]|0;
 $10 = ((($9)) + 56|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = HEAP32[$p>>2]|0;
 _map_iterate($11,131,$12);
 $13 = HEAP32[$p>>2]|0;
 $14 = ((($13)) + 56|0);
 $15 = HEAP32[$14>>2]|0;
 _map_destroy($15);
 $16 = HEAP32[$p>>2]|0;
 $17 = ((($16)) + 56|0);
 $18 = HEAP32[$17>>2]|0;
 _free($18);
 $19 = HEAP32[$p>>2]|0;
 $20 = ((($19)) + 40|0);
 $21 = $20;
 $22 = $21;
 $23 = HEAP32[$22>>2]|0;
 $24 = (($21) + 4)|0;
 $25 = $24;
 $26 = HEAP32[$25>>2]|0;
 $27 = (1)==($23|0);
 $28 = (0)==($26|0);
 $29 = $27 & $28;
 if (!($29)) {
  STACKTOP = sp;return;
 }
 $30 = HEAP32[$p>>2]|0;
 $31 = ((($30)) + 48|0);
 $32 = $31;
 $33 = $32;
 $34 = HEAP32[$33>>2]|0;
 $35 = (($32) + 4)|0;
 $36 = $35;
 $37 = HEAP32[$36>>2]|0;
 $38 = (0)==($34|0);
 $39 = (0)==($37|0);
 $40 = $38 & $39;
 $41 = HEAP32[$0>>2]|0;
 $42 = HEAP32[$p>>2]|0;
 if ($40) {
  $43 = $42;
  $44 = $43;
  $45 = HEAP32[$44>>2]|0;
  $46 = (($43) + 4)|0;
  $47 = $46;
  $48 = HEAP32[$47>>2]|0;
  _sqlite3_result_int64($41,$45,$48);
  STACKTOP = sp;return;
 } else {
  $49 = ((($42)) + 8|0);
  $50 = +HEAPF64[$49>>3];
  _sqlite3_result_double($41,$50);
  STACKTOP = sp;return;
 }
}
function _medianFinalize($context) {
 $context = $context|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $context;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_aggregate_context($1,0)|0);
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$p>>2]|0;
 $6 = ((($5)) + 16|0);
 $7 = $6;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) + 4)|0;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (+($9>>>0)) + (4294967296.0*(+($12|0)));
 $14 = $13 / 2.0;
 $15 = HEAP32[$p>>2]|0;
 $16 = ((($15)) + 24|0);
 HEAPF64[$16>>3] = $14;
 $17 = HEAP32[$0>>2]|0;
 __medianFinalize($17);
 STACKTOP = sp;return;
}
function _lower_quartileFinalize($context) {
 $context = $context|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $context;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_aggregate_context($1,0)|0);
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$p>>2]|0;
 $6 = ((($5)) + 16|0);
 $7 = $6;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) + 4)|0;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (+($9>>>0)) + (4294967296.0*(+($12|0)));
 $14 = $13 / 4.0;
 $15 = HEAP32[$p>>2]|0;
 $16 = ((($15)) + 24|0);
 HEAPF64[$16>>3] = $14;
 $17 = HEAP32[$0>>2]|0;
 __medianFinalize($17);
 STACKTOP = sp;return;
}
function _upper_quartileFinalize($context) {
 $context = $context|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0.0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $context;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_aggregate_context($1,0)|0);
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$p>>2]|0;
 $6 = ((($5)) + 16|0);
 $7 = $6;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) + 4)|0;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (___muldi3(($9|0),($12|0),3,0)|0);
 $14 = tempRet0;
 $15 = (+($13>>>0)) + (4294967296.0*(+($14|0)));
 $16 = $15 / 4.0;
 $17 = HEAP32[$p>>2]|0;
 $18 = ((($17)) + 24|0);
 HEAPF64[$18>>3] = $16;
 $19 = HEAP32[$0>>2]|0;
 __medianFinalize($19);
 STACKTOP = sp;return;
}
function _map_make($agg$result,$cmp) {
 $agg$result = $agg$result|0;
 $cmp = $cmp|0;
 var $0 = 0, $1 = 0, $2 = 0, $r = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $r = sp;
 HEAP32[$0>>2] = $cmp;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($r)) + 4|0);
 HEAP32[$2>>2] = $1;
 HEAP32[$r>>2] = 0;
 ;HEAP32[$agg$result>>2]=HEAP32[$r>>2]|0;HEAP32[$agg$result+4>>2]=HEAP32[$r+4>>2]|0;HEAP32[$agg$result+8>>2]=HEAP32[$r+8>>2]|0;
 STACKTOP = sp;return;
}
function _xcalloc($nmemb,$size,$s) {
 $nmemb = $nmemb|0;
 $size = $size|0;
 $s = $s|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $ret = sp;
 HEAP32[$0>>2] = $nmemb;
 HEAP32[$1>>2] = $size;
 HEAP32[$2>>2] = $s;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = (_calloc($3,$4)|0);
 HEAP32[$ret>>2] = $5;
 $6 = HEAP32[$ret>>2]|0;
 STACKTOP = sp;return ($6|0);
}
function _xfree($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 _free($1);
 STACKTOP = sp;return;
}
function _node_insert($n,$cmp,$e) {
 $n = $n|0;
 $cmp = $cmp|0;
 $e = $e|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $c = 0, $nn = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $c = sp + 4|0;
 $nn = sp;
 HEAP32[$0>>2] = $n;
 HEAP32[$1>>2] = $cmp;
 HEAP32[$2>>2] = $e;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0|0);
 if ($5) {
  $6 = (_xcalloc(1,24,16717)|0);
  HEAP32[$nn>>2] = $6;
  $7 = HEAP32[$2>>2]|0;
  $8 = HEAP32[$nn>>2]|0;
  $9 = ((($8)) + 8|0);
  HEAP32[$9>>2] = $7;
  $10 = HEAP32[$nn>>2]|0;
  $11 = ((($10)) + 16|0);
  $12 = $11;
  $13 = $12;
  HEAP32[$13>>2] = 1;
  $14 = (($12) + 4)|0;
  $15 = $14;
  HEAP32[$15>>2] = 0;
  $16 = HEAP32[$nn>>2]|0;
  $17 = HEAP32[$0>>2]|0;
  HEAP32[$17>>2] = $16;
  STACKTOP = sp;return;
 }
 $18 = HEAP32[$1>>2]|0;
 $19 = HEAP32[$0>>2]|0;
 $20 = HEAP32[$19>>2]|0;
 $21 = ((($20)) + 8|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = HEAP32[$2>>2]|0;
 $24 = (FUNCTION_TABLE_iii[$18 & 255]($22,$23)|0);
 HEAP32[$c>>2] = $24;
 $25 = HEAP32[$c>>2]|0;
 $26 = (0)==($25|0);
 if ($26) {
  $27 = HEAP32[$0>>2]|0;
  $28 = HEAP32[$27>>2]|0;
  $29 = ((($28)) + 16|0);
  $30 = $29;
  $31 = $30;
  $32 = HEAP32[$31>>2]|0;
  $33 = (($30) + 4)|0;
  $34 = $33;
  $35 = HEAP32[$34>>2]|0;
  $36 = (_i64Add(($32|0),($35|0),1,0)|0);
  $37 = tempRet0;
  $38 = $29;
  $39 = $38;
  HEAP32[$39>>2] = $36;
  $40 = (($38) + 4)|0;
  $41 = $40;
  HEAP32[$41>>2] = $37;
  $42 = HEAP32[$2>>2]|0;
  _xfree($42);
  STACKTOP = sp;return;
 }
 $43 = HEAP32[$c>>2]|0;
 $44 = ($43|0)>(0);
 $45 = HEAP32[$0>>2]|0;
 $46 = HEAP32[$45>>2]|0;
 if ($44) {
  $47 = HEAP32[$1>>2]|0;
  $48 = HEAP32[$2>>2]|0;
  _node_insert($46,$47,$48);
  STACKTOP = sp;return;
 } else {
  $49 = ((($46)) + 4|0);
  $50 = HEAP32[$1>>2]|0;
  $51 = HEAP32[$2>>2]|0;
  _node_insert($49,$50,$51);
  STACKTOP = sp;return;
 }
}
function _map_insert($m,$e) {
 $m = $m|0;
 $e = $e|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $m;
 HEAP32[$1>>2] = $e;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = HEAP32[$1>>2]|0;
 _node_insert($2,$5,$6);
 STACKTOP = sp;return;
}
function _node_iterate($n,$iter,$p) {
 $n = $n|0;
 $iter = $iter|0;
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $n;
 HEAP32[$1>>2] = $iter;
 HEAP32[$2>>2] = $p;
 $3 = HEAP32[$0>>2]|0;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = ($6|0)!=(0|0);
 if ($7) {
  $8 = HEAP32[$0>>2]|0;
  $9 = HEAP32[$8>>2]|0;
  $10 = HEAP32[$1>>2]|0;
  $11 = HEAP32[$2>>2]|0;
  _node_iterate($9,$10,$11);
 }
 $12 = HEAP32[$1>>2]|0;
 $13 = HEAP32[$0>>2]|0;
 $14 = ((($13)) + 8|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = HEAP32[$0>>2]|0;
 $17 = ((($16)) + 16|0);
 $18 = $17;
 $19 = $18;
 $20 = HEAP32[$19>>2]|0;
 $21 = (($18) + 4)|0;
 $22 = $21;
 $23 = HEAP32[$22>>2]|0;
 $24 = HEAP32[$2>>2]|0;
 FUNCTION_TABLE_viiii[$12 & 255]($15,$20,$23,$24);
 $25 = HEAP32[$0>>2]|0;
 $26 = ((($25)) + 4|0);
 $27 = HEAP32[$26>>2]|0;
 $28 = ($27|0)!=(0|0);
 if (!($28)) {
  STACKTOP = sp;return;
 }
 $29 = HEAP32[$0>>2]|0;
 $30 = ((($29)) + 4|0);
 $31 = HEAP32[$30>>2]|0;
 $32 = HEAP32[$1>>2]|0;
 $33 = HEAP32[$2>>2]|0;
 _node_iterate($31,$32,$33);
 STACKTOP = sp;return;
}
function _map_iterate($m,$iter,$p) {
 $m = $m|0;
 $iter = $iter|0;
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $m;
 HEAP32[$1>>2] = $iter;
 HEAP32[$2>>2] = $p;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$3>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = HEAP32[$2>>2]|0;
 _node_iterate($4,$5,$6);
 STACKTOP = sp;return;
}
function _node_destroy($n) {
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $n;
 $1 = HEAP32[$0>>2]|0;
 $2 = (0|0)!=($1|0);
 if (!($2)) {
  STACKTOP = sp;return;
 }
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 _xfree($5);
 $6 = HEAP32[$0>>2]|0;
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)!=(0|0);
 if ($8) {
  $9 = HEAP32[$0>>2]|0;
  $10 = HEAP32[$9>>2]|0;
  _node_destroy($10);
 }
 $11 = HEAP32[$0>>2]|0;
 $12 = ((($11)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13|0)!=(0|0);
 if ($14) {
  $15 = HEAP32[$0>>2]|0;
  $16 = ((($15)) + 4|0);
  $17 = HEAP32[$16>>2]|0;
  _node_destroy($17);
 }
 $18 = HEAP32[$0>>2]|0;
 _xfree($18);
 STACKTOP = sp;return;
}
function _map_destroy($m) {
 $m = $m|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $m;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$1>>2]|0;
 _node_destroy($2);
 STACKTOP = sp;return;
}
function _int_cmp($a,$b) {
 $a = $a|0;
 $b = $b|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $aa = 0, $bb = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $aa = sp + 8|0;
 $bb = sp;
 HEAP32[$1>>2] = $a;
 HEAP32[$2>>2] = $b;
 $3 = HEAP32[$1>>2]|0;
 $4 = $3;
 $5 = $4;
 $6 = HEAP32[$5>>2]|0;
 $7 = (($4) + 4)|0;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = $aa;
 $11 = $10;
 HEAP32[$11>>2] = $6;
 $12 = (($10) + 4)|0;
 $13 = $12;
 HEAP32[$13>>2] = $9;
 $14 = HEAP32[$2>>2]|0;
 $15 = $14;
 $16 = $15;
 $17 = HEAP32[$16>>2]|0;
 $18 = (($15) + 4)|0;
 $19 = $18;
 $20 = HEAP32[$19>>2]|0;
 $21 = $bb;
 $22 = $21;
 HEAP32[$22>>2] = $17;
 $23 = (($21) + 4)|0;
 $24 = $23;
 HEAP32[$24>>2] = $20;
 $25 = $aa;
 $26 = $25;
 $27 = HEAP32[$26>>2]|0;
 $28 = (($25) + 4)|0;
 $29 = $28;
 $30 = HEAP32[$29>>2]|0;
 $31 = $bb;
 $32 = $31;
 $33 = HEAP32[$32>>2]|0;
 $34 = (($31) + 4)|0;
 $35 = $34;
 $36 = HEAP32[$35>>2]|0;
 $37 = ($27|0)==($33|0);
 $38 = ($30|0)==($36|0);
 $39 = $37 & $38;
 if ($39) {
  HEAP32[$0>>2] = 0;
  $57 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($57|0);
 }
 $40 = $aa;
 $41 = $40;
 $42 = HEAP32[$41>>2]|0;
 $43 = (($40) + 4)|0;
 $44 = $43;
 $45 = HEAP32[$44>>2]|0;
 $46 = $bb;
 $47 = $46;
 $48 = HEAP32[$47>>2]|0;
 $49 = (($46) + 4)|0;
 $50 = $49;
 $51 = HEAP32[$50>>2]|0;
 $52 = ($45|0)<($51|0);
 $53 = ($42>>>0)<($48>>>0);
 $54 = ($45|0)==($51|0);
 $55 = $54 & $53;
 $56 = $52 | $55;
 if ($56) {
  HEAP32[$0>>2] = -1;
  $57 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($57|0);
 } else {
  HEAP32[$0>>2] = 1;
  $57 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($57|0);
 }
 return (0)|0;
}
function _double_cmp($a,$b) {
 $a = $a|0;
 $b = $b|0;
 var $0 = 0, $1 = 0, $10 = 0.0, $11 = 0.0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0.0, $5 = 0, $6 = 0.0, $7 = 0.0, $8 = 0.0, $9 = 0, $aa = 0, $bb = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $2 = sp + 16|0;
 $aa = sp + 8|0;
 $bb = sp;
 HEAP32[$1>>2] = $a;
 HEAP32[$2>>2] = $b;
 $3 = HEAP32[$1>>2]|0;
 $4 = +HEAPF64[$3>>3];
 HEAPF64[$aa>>3] = $4;
 $5 = HEAP32[$2>>2]|0;
 $6 = +HEAPF64[$5>>3];
 HEAPF64[$bb>>3] = $6;
 $7 = +HEAPF64[$aa>>3];
 $8 = +HEAPF64[$bb>>3];
 $9 = $7 == $8;
 do {
  if ($9) {
   HEAP32[$0>>2] = 0;
  } else {
   $10 = +HEAPF64[$aa>>3];
   $11 = +HEAPF64[$bb>>3];
   $12 = $10 < $11;
   if ($12) {
    HEAP32[$0>>2] = -1;
    break;
   } else {
    HEAP32[$0>>2] = 1;
    break;
   }
  }
 } while(0);
 $13 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($13|0);
}
function _soundex($zIn,$zResult) {
 $zIn = $zIn|0;
 $zResult = $zResult|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $7 = 0, $8 = 0, $9 = 0, $code = 0, $i = 0, $j = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $i = sp + 8|0;
 $j = sp + 4|0;
 $code = sp;
 HEAP32[$0>>2] = $zIn;
 HEAP32[$1>>2] = $zResult;
 HEAP32[$i>>2] = 0;
 while(1) {
  $2 = HEAP32[$i>>2]|0;
  $3 = HEAP32[$0>>2]|0;
  $4 = (($3) + ($2)|0);
  $5 = HEAP8[$4>>0]|0;
  $6 = $5&255;
  $7 = ($6|0)!=(0);
  if (!($7)) {
   break;
  }
  $8 = HEAP32[$i>>2]|0;
  $9 = HEAP32[$0>>2]|0;
  $10 = (($9) + ($8)|0);
  $11 = HEAP8[$10>>0]|0;
  $12 = $11&255;
  $13 = (_isalpha($12)|0);
  $14 = ($13|0)!=(0);
  $15 = $14 ^ 1;
  if (!($15)) {
   break;
  }
  $16 = HEAP32[$i>>2]|0;
  $17 = (($16) + 1)|0;
  HEAP32[$i>>2] = $17;
 }
 $18 = HEAP32[$i>>2]|0;
 $19 = HEAP32[$0>>2]|0;
 $20 = (($19) + ($18)|0);
 $21 = HEAP8[$20>>0]|0;
 $22 = ($21<<24>>24)!=(0);
 if (!($22)) {
  $67 = HEAP32[$1>>2]|0;
  (_strcpy($67,16975)|0);
  STACKTOP = sp;return;
 }
 $23 = HEAP32[$i>>2]|0;
 $24 = HEAP32[$0>>2]|0;
 $25 = (($24) + ($23)|0);
 $26 = HEAP8[$25>>0]|0;
 $27 = $26&255;
 $28 = (_toupper($27)|0);
 $29 = $28&255;
 $30 = HEAP32[$1>>2]|0;
 HEAP8[$30>>0] = $29;
 HEAP32[$j>>2] = 1;
 while(1) {
  $31 = HEAP32[$j>>2]|0;
  $32 = ($31|0)<(4);
  if (!($32)) {
   break;
  }
  $33 = HEAP32[$i>>2]|0;
  $34 = HEAP32[$0>>2]|0;
  $35 = (($34) + ($33)|0);
  $36 = HEAP8[$35>>0]|0;
  $37 = $36&255;
  $38 = ($37|0)!=(0);
  if (!($38)) {
   break;
  }
  $39 = HEAP32[$i>>2]|0;
  $40 = HEAP32[$0>>2]|0;
  $41 = (($40) + ($39)|0);
  $42 = HEAP8[$41>>0]|0;
  $43 = $42&255;
  $44 = $43 & 127;
  $45 = (16847 + ($44)|0);
  $46 = HEAP8[$45>>0]|0;
  $47 = $46&255;
  HEAP32[$code>>2] = $47;
  $48 = HEAP32[$code>>2]|0;
  $49 = ($48|0)>(0);
  if ($49) {
   $50 = HEAP32[$code>>2]|0;
   $51 = (($50) + 48)|0;
   $52 = $51&255;
   $53 = HEAP32[$j>>2]|0;
   $54 = (($53) + 1)|0;
   HEAP32[$j>>2] = $54;
   $55 = HEAP32[$1>>2]|0;
   $56 = (($55) + ($53)|0);
   HEAP8[$56>>0] = $52;
  }
  $57 = HEAP32[$i>>2]|0;
  $58 = (($57) + 1)|0;
  HEAP32[$i>>2] = $58;
 }
 while(1) {
  $59 = HEAP32[$j>>2]|0;
  $60 = ($59|0)<(4);
  $61 = HEAP32[$j>>2]|0;
  if (!($60)) {
   break;
  }
  $62 = (($61) + 1)|0;
  HEAP32[$j>>2] = $62;
  $63 = HEAP32[$1>>2]|0;
  $64 = (($63) + ($61)|0);
  HEAP8[$64>>0] = 48;
 }
 $65 = HEAP32[$1>>2]|0;
 $66 = (($65) + ($61)|0);
 HEAP8[$66>>0] = 0;
 STACKTOP = sp;return;
}
function _sqlite3ReadUtf8($z) {
 $z = $z|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $c = 0, $xtra = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $c = sp + 4|0;
 $xtra = sp;
 HEAP32[$0>>2] = $z;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 1|0);
 HEAP32[$0>>2] = $2;
 $3 = HEAP8[$1>>0]|0;
 $4 = $3&255;
 HEAP32[$c>>2] = $4;
 $5 = HEAP32[$c>>2]|0;
 $6 = (16980 + ($5)|0);
 $7 = HEAP8[$6>>0]|0;
 $8 = $7&255;
 HEAP32[$xtra>>2] = $8;
 $9 = HEAP32[$xtra>>2]|0;
 switch ($9|0) {
 case 4:  {
  HEAP32[$c>>2] = 65533;
  $48 = HEAP32[$c>>2]|0;
  STACKTOP = sp;return ($48|0);
  break;
 }
 case 3:  {
  $10 = HEAP32[$c>>2]|0;
  $11 = $10 << 6;
  $12 = HEAP32[$0>>2]|0;
  $13 = ((($12)) + 1|0);
  HEAP32[$0>>2] = $13;
  $14 = HEAP8[$12>>0]|0;
  $15 = $14&255;
  $16 = (($11) + ($15))|0;
  HEAP32[$c>>2] = $16;
  label = 4;
  break;
 }
 case 2:  {
  label = 4;
  break;
 }
 case 1:  {
  break;
 }
 default: {
  $48 = HEAP32[$c>>2]|0;
  STACKTOP = sp;return ($48|0);
 }
 }
 if ((label|0) == 4) {
  $17 = HEAP32[$c>>2]|0;
  $18 = $17 << 6;
  $19 = HEAP32[$0>>2]|0;
  $20 = ((($19)) + 1|0);
  HEAP32[$0>>2] = $20;
  $21 = HEAP8[$19>>0]|0;
  $22 = $21&255;
  $23 = (($18) + ($22))|0;
  HEAP32[$c>>2] = $23;
 }
 $24 = HEAP32[$c>>2]|0;
 $25 = $24 << 6;
 $26 = HEAP32[$0>>2]|0;
 $27 = ((($26)) + 1|0);
 HEAP32[$0>>2] = $27;
 $28 = HEAP8[$26>>0]|0;
 $29 = $28&255;
 $30 = (($25) + ($29))|0;
 HEAP32[$c>>2] = $30;
 $31 = HEAP32[$xtra>>2]|0;
 $32 = (936 + ($31<<2)|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = HEAP32[$c>>2]|0;
 $35 = (($34) - ($33))|0;
 HEAP32[$c>>2] = $35;
 $36 = HEAP32[$xtra>>2]|0;
 $37 = (952 + ($36<<2)|0);
 $38 = HEAP32[$37>>2]|0;
 $39 = HEAP32[$c>>2]|0;
 $40 = $38 & $39;
 $41 = ($40|0)==(0);
 if (!($41)) {
  $42 = HEAP32[$c>>2]|0;
  $43 = $42 & -2048;
  $44 = ($43|0)==(55296);
  if (!($44)) {
   $45 = HEAP32[$c>>2]|0;
   $46 = $45 & -2;
   $47 = ($46|0)==(65534);
   if (!($47)) {
    $48 = HEAP32[$c>>2]|0;
    STACKTOP = sp;return ($48|0);
   }
  }
 }
 HEAP32[$c>>2] = 65533;
 $48 = HEAP32[$c>>2]|0;
 STACKTOP = sp;return ($48|0);
}
function _rad2deg($x) {
 $x = +$x;
 var $0 = 0, $1 = 0.0, $2 = 0.0, $3 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAPF64[$0>>3] = $x;
 $1 = +HEAPF64[$0>>3];
 $2 = 180.0 * $1;
 $3 = $2 / 3.1415926535897931;
 STACKTOP = sp;return (+$3);
}
function _deg2rad($x) {
 $x = +$x;
 var $0 = 0, $1 = 0.0, $2 = 0.0, $3 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAPF64[$0>>3] = $x;
 $1 = +HEAPF64[$0>>3];
 $2 = $1 * 3.1415926535897931;
 $3 = $2 / 180.0;
 STACKTOP = sp;return (+$3);
}
function _cot($x) {
 $x = +$x;
 var $0 = 0, $1 = 0.0, $2 = 0.0, $3 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAPF64[$0>>3] = $x;
 $1 = +HEAPF64[$0>>3];
 $2 = (+Math_tan((+$1)));
 $3 = 1.0 / $2;
 STACKTOP = sp;return (+$3);
}
function _coth($x) {
 $x = +$x;
 var $0 = 0, $1 = 0.0, $2 = 0.0, $3 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAPF64[$0>>3] = $x;
 $1 = +HEAPF64[$0>>3];
 $2 = (+_tanh($1));
 $3 = 1.0 / $2;
 STACKTOP = sp;return (+$3);
}
function __substr($z1,$z2,$s,$p) {
 $z1 = $z1|0;
 $z2 = $z2|0;
 $s = $s|0;
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $8 = 0, $9 = 0, $c = 0, $c1 = 0, $c2 = 0, $or$cond = 0, $or$cond4 = 0, $rVal = 0, $zt1 = 0, $zt2 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 40|0;
 $1 = sp + 36|0;
 $2 = sp + 32|0;
 $3 = sp + 28|0;
 $4 = sp + 24|0;
 $c = sp + 20|0;
 $rVal = sp + 16|0;
 $zt1 = sp + 12|0;
 $zt2 = sp + 8|0;
 $c1 = sp + 4|0;
 $c2 = sp;
 HEAP32[$1>>2] = $z1;
 HEAP32[$2>>2] = $z2;
 HEAP32[$3>>2] = $s;
 HEAP32[$4>>2] = $p;
 HEAP32[$c>>2] = 0;
 HEAP32[$rVal>>2] = -1;
 $5 = HEAP32[$1>>2]|0;
 $6 = HEAP8[$5>>0]|0;
 $7 = $6 << 24 >> 24;
 $8 = (0)==($7|0);
 if ($8) {
  HEAP32[$0>>2] = -1;
  $71 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($71|0);
 }
 L4: while(1) {
  $9 = HEAP32[$2>>2]|0;
  $10 = (_sqlite3ReadUtf8($9)|0);
  $11 = ($10|0)!=(0);
  if (!($11)) {
   break;
  }
  $12 = HEAP32[$c>>2]|0;
  $13 = (($12) + 1)|0;
  HEAP32[$c>>2] = $13;
  $14 = HEAP32[$3>>2]|0;
  $15 = ($12|0)<($14|0);
  if (!($15)) {
   break;
  }
  while(1) {
   $16 = HEAP32[$2>>2]|0;
   $17 = ((($16)) + 1|0);
   HEAP32[$2>>2] = $17;
   $18 = HEAP8[$17>>0]|0;
   $19 = $18 << 24 >> 24;
   $20 = 192 & $19;
   $21 = ($20|0)==(128);
   if (!($21)) {
    continue L4;
   }
  }
 }
 HEAP32[$c>>2] = 0;
 while(1) {
  $22 = HEAP32[$2>>2]|0;
  $23 = (_sqlite3ReadUtf8($22)|0);
  $24 = ($23|0)!=(0);
  if (!($24)) {
   break;
  }
  $25 = HEAP32[$1>>2]|0;
  HEAP32[$zt1>>2] = $25;
  $26 = HEAP32[$2>>2]|0;
  HEAP32[$zt2>>2] = $26;
  while(1) {
   $27 = HEAP32[$zt1>>2]|0;
   $28 = (_sqlite3ReadUtf8($27)|0);
   HEAP32[$c1>>2] = $28;
   $29 = HEAP32[$zt2>>2]|0;
   $30 = (_sqlite3ReadUtf8($29)|0);
   HEAP32[$c2>>2] = $30;
   while(1) {
    $31 = HEAP32[$zt1>>2]|0;
    $32 = ((($31)) + 1|0);
    HEAP32[$zt1>>2] = $32;
    $33 = HEAP8[$32>>0]|0;
    $34 = $33 << 24 >> 24;
    $35 = 192 & $34;
    $36 = ($35|0)==(128);
    if (!($36)) {
     break;
    }
   }
   while(1) {
    $37 = HEAP32[$zt2>>2]|0;
    $38 = ((($37)) + 1|0);
    HEAP32[$zt2>>2] = $38;
    $39 = HEAP8[$38>>0]|0;
    $40 = $39 << 24 >> 24;
    $41 = 192 & $40;
    $42 = ($41|0)==(128);
    if (!($42)) {
     break;
    }
   }
   $43 = HEAP32[$c1>>2]|0;
   $44 = HEAP32[$c2>>2]|0;
   $45 = ($43|0)==($44|0);
   $46 = HEAP32[$c1>>2]|0;
   $47 = ($46|0)!=(0);
   $or$cond = $45 & $47;
   $48 = HEAP32[$c2>>2]|0;
   $49 = ($48|0)!=(0);
   $or$cond4 = $or$cond & $49;
   if (!($or$cond4)) {
    break;
   }
  }
  $50 = HEAP32[$c1>>2]|0;
  $51 = ($50|0)==(0);
  if ($51) {
   label = 14;
   break;
  }
  while(1) {
   $53 = HEAP32[$2>>2]|0;
   $54 = ((($53)) + 1|0);
   HEAP32[$2>>2] = $54;
   $55 = HEAP8[$54>>0]|0;
   $56 = $55 << 24 >> 24;
   $57 = 192 & $56;
   $58 = ($57|0)==(128);
   if (!($58)) {
    break;
   }
  }
  $59 = HEAP32[$c>>2]|0;
  $60 = (($59) + 1)|0;
  HEAP32[$c>>2] = $60;
 }
 if ((label|0) == 14) {
  $52 = HEAP32[$c>>2]|0;
  HEAP32[$rVal>>2] = $52;
 }
 $61 = HEAP32[$4>>2]|0;
 $62 = ($61|0)!=(0|0);
 if ($62) {
  $63 = HEAP32[$2>>2]|0;
  $64 = HEAP32[$4>>2]|0;
  HEAP32[$64>>2] = $63;
 }
 $65 = HEAP32[$rVal>>2]|0;
 $66 = ($65|0)>=(0);
 $67 = HEAP32[$rVal>>2]|0;
 $68 = HEAP32[$3>>2]|0;
 $69 = (($67) + ($68))|0;
 $70 = $66 ? $69 : $67;
 HEAP32[$0>>2] = $70;
 $71 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($71|0);
}
function _sqlite3StrDup($z) {
 $z = $z|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $res = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $res = sp;
 HEAP32[$0>>2] = $z;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_strlen($1)|0);
 $3 = (($2) + 1)|0;
 $4 = (_sqlite3_malloc($3)|0);
 HEAP32[$res>>2] = $4;
 $5 = HEAP32[$res>>2]|0;
 $6 = HEAP32[$0>>2]|0;
 $7 = (_strcpy($5,$6)|0);
 STACKTOP = sp;return ($7|0);
}
function _sqlite3Utf8CharLen($z,$nByte) {
 $z = $z|0;
 $nByte = $nByte|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $r = 0, $zTerm = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $r = sp + 4|0;
 $zTerm = sp;
 HEAP32[$0>>2] = $z;
 HEAP32[$1>>2] = $nByte;
 HEAP32[$r>>2] = 0;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)>=(0);
 if ($3) {
  $4 = HEAP32[$1>>2]|0;
  $5 = HEAP32[$0>>2]|0;
  $6 = (($5) + ($4)|0);
  HEAP32[$zTerm>>2] = $6;
 } else {
  HEAP32[$zTerm>>2] = (-1);
 }
 $7 = HEAP32[$0>>2]|0;
 $8 = HEAP32[$zTerm>>2]|0;
 $9 = ($7>>>0)<=($8>>>0);
 if (!($9)) {
  ___assert_fail((17516|0),(16734|0),316,(17525|0));
  // unreachable;
 }
 while(1) {
  $10 = HEAP32[$0>>2]|0;
  $11 = HEAP8[$10>>0]|0;
  $12 = $11 << 24 >> 24;
  $13 = ($12|0)!=(0);
  if (!($13)) {
   label = 10;
   break;
  }
  $14 = HEAP32[$0>>2]|0;
  $15 = HEAP32[$zTerm>>2]|0;
  $16 = ($14>>>0)<($15>>>0);
  if (!($16)) {
   label = 10;
   break;
  }
  $17 = HEAP32[$0>>2]|0;
  $18 = HEAP8[$17>>0]|0;
  $19 = $18&255;
  $20 = (16980 + ($19)|0);
  $21 = HEAP8[$20>>0]|0;
  $22 = $21&255;
  $23 = (($22) + 1)|0;
  $24 = HEAP32[$0>>2]|0;
  $25 = (($24) + ($23)|0);
  HEAP32[$0>>2] = $25;
  $26 = HEAP32[$r>>2]|0;
  $27 = (($26) + 1)|0;
  HEAP32[$r>>2] = $27;
 }
 if ((label|0) == 10) {
  $28 = HEAP32[$r>>2]|0;
  STACKTOP = sp;return ($28|0);
 }
 return (0)|0;
}
function _modeIterate($e,$0,$1,$pp) {
 $e = $e|0;
 $0 = $0|0;
 $1 = $1|0;
 $pp = $pp|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0.0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0.0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ed = 0, $ei = 0, $p = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $2 = sp + 32|0;
 $3 = sp + 16|0;
 $4 = sp + 28|0;
 $ei = sp + 8|0;
 $ed = sp;
 $p = sp + 24|0;
 HEAP32[$2>>2] = $e;
 $5 = $3;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 HEAP32[$4>>2] = $pp;
 $9 = HEAP32[$4>>2]|0;
 HEAP32[$p>>2] = $9;
 $10 = HEAP32[$p>>2]|0;
 $11 = ((($10)) + 48|0);
 $12 = $11;
 $13 = $12;
 $14 = HEAP32[$13>>2]|0;
 $15 = (($12) + 4)|0;
 $16 = $15;
 $17 = HEAP32[$16>>2]|0;
 $18 = (0)==($14|0);
 $19 = (0)==($17|0);
 $20 = $18 & $19;
 $21 = HEAP32[$2>>2]|0;
 if ($20) {
  $22 = HEAP32[$21>>2]|0;
  $23 = ($22|0)<(0);
  $24 = $23 << 31 >> 31;
  $25 = $ei;
  $26 = $25;
  HEAP32[$26>>2] = $22;
  $27 = (($25) + 4)|0;
  $28 = $27;
  HEAP32[$28>>2] = $24;
  $29 = HEAP32[$p>>2]|0;
  $30 = ((($29)) + 32|0);
  $31 = $30;
  $32 = $31;
  $33 = HEAP32[$32>>2]|0;
  $34 = (($31) + 4)|0;
  $35 = $34;
  $36 = HEAP32[$35>>2]|0;
  $37 = $3;
  $38 = $37;
  $39 = HEAP32[$38>>2]|0;
  $40 = (($37) + 4)|0;
  $41 = $40;
  $42 = HEAP32[$41>>2]|0;
  $43 = ($33|0)==($39|0);
  $44 = ($36|0)==($42|0);
  $45 = $43 & $44;
  $46 = HEAP32[$p>>2]|0;
  if ($45) {
   $47 = ((($46)) + 40|0);
   $48 = $47;
   $49 = $48;
   $50 = HEAP32[$49>>2]|0;
   $51 = (($48) + 4)|0;
   $52 = $51;
   $53 = HEAP32[$52>>2]|0;
   $54 = (_i64Add(($50|0),($53|0),1,0)|0);
   $55 = tempRet0;
   $56 = $47;
   $57 = $56;
   HEAP32[$57>>2] = $54;
   $58 = (($56) + 4)|0;
   $59 = $58;
   HEAP32[$59>>2] = $55;
   STACKTOP = sp;return;
  }
  $60 = ((($46)) + 32|0);
  $61 = $60;
  $62 = $61;
  $63 = HEAP32[$62>>2]|0;
  $64 = (($61) + 4)|0;
  $65 = $64;
  $66 = HEAP32[$65>>2]|0;
  $67 = $3;
  $68 = $67;
  $69 = HEAP32[$68>>2]|0;
  $70 = (($67) + 4)|0;
  $71 = $70;
  $72 = HEAP32[$71>>2]|0;
  $73 = ($66|0)<($72|0);
  $74 = ($63>>>0)<($69>>>0);
  $75 = ($66|0)==($72|0);
  $76 = $75 & $74;
  $77 = $73 | $76;
  if (!($77)) {
   STACKTOP = sp;return;
  }
  $78 = $ei;
  $79 = $78;
  $80 = HEAP32[$79>>2]|0;
  $81 = (($78) + 4)|0;
  $82 = $81;
  $83 = HEAP32[$82>>2]|0;
  $84 = HEAP32[$p>>2]|0;
  $85 = $84;
  $86 = $85;
  HEAP32[$86>>2] = $80;
  $87 = (($85) + 4)|0;
  $88 = $87;
  HEAP32[$88>>2] = $83;
  $89 = $3;
  $90 = $89;
  $91 = HEAP32[$90>>2]|0;
  $92 = (($89) + 4)|0;
  $93 = $92;
  $94 = HEAP32[$93>>2]|0;
  $95 = HEAP32[$p>>2]|0;
  $96 = ((($95)) + 32|0);
  $97 = $96;
  $98 = $97;
  HEAP32[$98>>2] = $91;
  $99 = (($97) + 4)|0;
  $100 = $99;
  HEAP32[$100>>2] = $94;
  $101 = HEAP32[$p>>2]|0;
  $102 = ((($101)) + 40|0);
  $103 = $102;
  $104 = $103;
  HEAP32[$104>>2] = 1;
  $105 = (($103) + 4)|0;
  $106 = $105;
  HEAP32[$106>>2] = 0;
  STACKTOP = sp;return;
 } else {
  $107 = +HEAPF64[$21>>3];
  HEAPF64[$ed>>3] = $107;
  $108 = HEAP32[$p>>2]|0;
  $109 = ((($108)) + 32|0);
  $110 = $109;
  $111 = $110;
  $112 = HEAP32[$111>>2]|0;
  $113 = (($110) + 4)|0;
  $114 = $113;
  $115 = HEAP32[$114>>2]|0;
  $116 = $3;
  $117 = $116;
  $118 = HEAP32[$117>>2]|0;
  $119 = (($116) + 4)|0;
  $120 = $119;
  $121 = HEAP32[$120>>2]|0;
  $122 = ($112|0)==($118|0);
  $123 = ($115|0)==($121|0);
  $124 = $122 & $123;
  $125 = HEAP32[$p>>2]|0;
  if ($124) {
   $126 = ((($125)) + 40|0);
   $127 = $126;
   $128 = $127;
   $129 = HEAP32[$128>>2]|0;
   $130 = (($127) + 4)|0;
   $131 = $130;
   $132 = HEAP32[$131>>2]|0;
   $133 = (_i64Add(($129|0),($132|0),1,0)|0);
   $134 = tempRet0;
   $135 = $126;
   $136 = $135;
   HEAP32[$136>>2] = $133;
   $137 = (($135) + 4)|0;
   $138 = $137;
   HEAP32[$138>>2] = $134;
   STACKTOP = sp;return;
  }
  $139 = ((($125)) + 32|0);
  $140 = $139;
  $141 = $140;
  $142 = HEAP32[$141>>2]|0;
  $143 = (($140) + 4)|0;
  $144 = $143;
  $145 = HEAP32[$144>>2]|0;
  $146 = $3;
  $147 = $146;
  $148 = HEAP32[$147>>2]|0;
  $149 = (($146) + 4)|0;
  $150 = $149;
  $151 = HEAP32[$150>>2]|0;
  $152 = ($145|0)<($151|0);
  $153 = ($142>>>0)<($148>>>0);
  $154 = ($145|0)==($151|0);
  $155 = $154 & $153;
  $156 = $152 | $155;
  if (!($156)) {
   STACKTOP = sp;return;
  }
  $157 = +HEAPF64[$ed>>3];
  $158 = HEAP32[$p>>2]|0;
  $159 = ((($158)) + 8|0);
  HEAPF64[$159>>3] = $157;
  $160 = $3;
  $161 = $160;
  $162 = HEAP32[$161>>2]|0;
  $163 = (($160) + 4)|0;
  $164 = $163;
  $165 = HEAP32[$164>>2]|0;
  $166 = HEAP32[$p>>2]|0;
  $167 = ((($166)) + 32|0);
  $168 = $167;
  $169 = $168;
  HEAP32[$169>>2] = $162;
  $170 = (($168) + 4)|0;
  $171 = $170;
  HEAP32[$171>>2] = $165;
  $172 = HEAP32[$p>>2]|0;
  $173 = ((($172)) + 40|0);
  $174 = $173;
  $175 = $174;
  HEAP32[$175>>2] = 1;
  $176 = (($174) + 4)|0;
  $177 = $176;
  HEAP32[$177>>2] = 0;
  STACKTOP = sp;return;
 }
}
function __medianFinalize($context) {
 $context = $context|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0.0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0.0, $62 = 0.0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0.0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0.0, $76 = 0.0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $context;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_aggregate_context($1,0)|0);
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ($3|0)!=(0|0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$p>>2]|0;
 $6 = ((($5)) + 56|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)!=(0|0);
 if (!($8)) {
  STACKTOP = sp;return;
 }
 $9 = HEAP32[$p>>2]|0;
 $10 = ((($9)) + 60|0);
 HEAP32[$10>>2] = 0;
 $11 = HEAP32[$p>>2]|0;
 $12 = ((($11)) + 56|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = HEAP32[$p>>2]|0;
 _map_iterate($13,132,$14);
 $15 = HEAP32[$p>>2]|0;
 $16 = ((($15)) + 56|0);
 $17 = HEAP32[$16>>2]|0;
 _map_destroy($17);
 $18 = HEAP32[$p>>2]|0;
 $19 = ((($18)) + 56|0);
 $20 = HEAP32[$19>>2]|0;
 _free($20);
 $21 = HEAP32[$p>>2]|0;
 $22 = ((($21)) + 48|0);
 $23 = $22;
 $24 = $23;
 $25 = HEAP32[$24>>2]|0;
 $26 = (($23) + 4)|0;
 $27 = $26;
 $28 = HEAP32[$27>>2]|0;
 $29 = (0)==($25|0);
 $30 = (0)==($28|0);
 $31 = $29 & $30;
 if (!($31)) {
  $63 = HEAP32[$0>>2]|0;
  $64 = HEAP32[$p>>2]|0;
  $65 = ((($64)) + 8|0);
  $66 = +HEAPF64[$65>>3];
  $67 = HEAP32[$p>>2]|0;
  $68 = ((($67)) + 40|0);
  $69 = $68;
  $70 = $69;
  $71 = HEAP32[$70>>2]|0;
  $72 = (($69) + 4)|0;
  $73 = $72;
  $74 = HEAP32[$73>>2]|0;
  $75 = (+($71>>>0)) + (4294967296.0*(+($74|0)));
  $76 = $66 / $75;
  _sqlite3_result_double($63,$76);
  STACKTOP = sp;return;
 }
 $32 = HEAP32[$p>>2]|0;
 $33 = ((($32)) + 40|0);
 $34 = $33;
 $35 = $34;
 $36 = HEAP32[$35>>2]|0;
 $37 = (($34) + 4)|0;
 $38 = $37;
 $39 = HEAP32[$38>>2]|0;
 $40 = (1)==($36|0);
 $41 = (0)==($39|0);
 $42 = $40 & $41;
 $43 = HEAP32[$0>>2]|0;
 $44 = HEAP32[$p>>2]|0;
 $45 = $44;
 $46 = $45;
 $47 = HEAP32[$46>>2]|0;
 $48 = (($45) + 4)|0;
 $49 = $48;
 $50 = HEAP32[$49>>2]|0;
 if ($42) {
  _sqlite3_result_int64($43,$47,$50);
  STACKTOP = sp;return;
 } else {
  $51 = (+($47>>>0)) + (4294967296.0*(+($50|0)));
  $52 = $51 * 1.0;
  $53 = HEAP32[$p>>2]|0;
  $54 = ((($53)) + 40|0);
  $55 = $54;
  $56 = $55;
  $57 = HEAP32[$56>>2]|0;
  $58 = (($55) + 4)|0;
  $59 = $58;
  $60 = HEAP32[$59>>2]|0;
  $61 = (+($57>>>0)) + (4294967296.0*(+($60|0)));
  $62 = $52 / $61;
  _sqlite3_result_double($43,$62);
  STACKTOP = sp;return;
 }
}
function _medianIterate($e,$0,$1,$pp) {
 $e = $e|0;
 $0 = $0|0;
 $1 = $1|0;
 $pp = $pp|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0.0, $125 = 0.0, $126 = 0, $127 = 0, $128 = 0.0, $129 = 0.0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $16 = 0.0, $17 = 0, $18 = 0;
 var $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0.0, $26 = 0, $27 = 0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0.0, $66 = 0.0, $67 = 0, $68 = 0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ed = 0, $ei = 0, $iL = 0, $iR = 0, $il = 0, $ir = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $2 = sp + 56|0;
 $3 = sp + 32|0;
 $4 = sp + 52|0;
 $ei = sp + 24|0;
 $ed = sp + 16|0;
 $iL = sp + 8|0;
 $iR = sp;
 $il = sp + 48|0;
 $ir = sp + 44|0;
 $p = sp + 40|0;
 HEAP32[$2>>2] = $e;
 $5 = $3;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 HEAP32[$4>>2] = $pp;
 $9 = HEAP32[$4>>2]|0;
 HEAP32[$p>>2] = $9;
 $10 = HEAP32[$p>>2]|0;
 $11 = ((($10)) + 60|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = ($12|0)>(0);
 if ($13) {
  STACKTOP = sp;return;
 }
 $14 = HEAP32[$p>>2]|0;
 $15 = ((($14)) + 24|0);
 $16 = +HEAPF64[$15>>3];
 HEAPF64[$iL>>3] = $16;
 $17 = HEAP32[$p>>2]|0;
 $18 = ((($17)) + 16|0);
 $19 = $18;
 $20 = $19;
 $21 = HEAP32[$20>>2]|0;
 $22 = (($19) + 4)|0;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 $25 = (+($21>>>0)) + (4294967296.0*(+($24|0)));
 $26 = HEAP32[$p>>2]|0;
 $27 = ((($26)) + 24|0);
 $28 = +HEAPF64[$27>>3];
 $29 = $25 - $28;
 HEAPF64[$iR>>3] = $29;
 $30 = HEAP32[$p>>2]|0;
 $31 = ((($30)) + 32|0);
 $32 = $31;
 $33 = $32;
 $34 = HEAP32[$33>>2]|0;
 $35 = (($32) + 4)|0;
 $36 = $35;
 $37 = HEAP32[$36>>2]|0;
 $38 = $3;
 $39 = $38;
 $40 = HEAP32[$39>>2]|0;
 $41 = (($38) + 4)|0;
 $42 = $41;
 $43 = HEAP32[$42>>2]|0;
 $44 = (_i64Add(($34|0),($37|0),($40|0),($43|0))|0);
 $45 = tempRet0;
 HEAP32[$il>>2] = $44;
 $46 = HEAP32[$p>>2]|0;
 $47 = ((($46)) + 16|0);
 $48 = $47;
 $49 = $48;
 $50 = HEAP32[$49>>2]|0;
 $51 = (($48) + 4)|0;
 $52 = $51;
 $53 = HEAP32[$52>>2]|0;
 $54 = HEAP32[$p>>2]|0;
 $55 = ((($54)) + 32|0);
 $56 = $55;
 $57 = $56;
 $58 = HEAP32[$57>>2]|0;
 $59 = (($56) + 4)|0;
 $60 = $59;
 $61 = HEAP32[$60>>2]|0;
 $62 = (_i64Subtract(($50|0),($53|0),($58|0),($61|0))|0);
 $63 = tempRet0;
 HEAP32[$ir>>2] = $62;
 $64 = HEAP32[$il>>2]|0;
 $65 = (+($64|0));
 $66 = +HEAPF64[$iL>>3];
 $67 = $65 >= $66;
 do {
  if ($67) {
   $68 = HEAP32[$ir>>2]|0;
   $69 = (+($68|0));
   $70 = +HEAPF64[$iR>>3];
   $71 = $69 >= $70;
   $72 = HEAP32[$p>>2]|0;
   if (!($71)) {
    $130 = ((($72)) + 60|0);
    HEAP32[$130>>2] = 1;
    break;
   }
   $73 = ((($72)) + 40|0);
   $74 = $73;
   $75 = $74;
   $76 = HEAP32[$75>>2]|0;
   $77 = (($74) + 4)|0;
   $78 = $77;
   $79 = HEAP32[$78>>2]|0;
   $80 = (_i64Add(($76|0),($79|0),1,0)|0);
   $81 = tempRet0;
   $82 = $73;
   $83 = $82;
   HEAP32[$83>>2] = $80;
   $84 = (($82) + 4)|0;
   $85 = $84;
   HEAP32[$85>>2] = $81;
   $86 = HEAP32[$p>>2]|0;
   $87 = ((($86)) + 48|0);
   $88 = $87;
   $89 = $88;
   $90 = HEAP32[$89>>2]|0;
   $91 = (($88) + 4)|0;
   $92 = $91;
   $93 = HEAP32[$92>>2]|0;
   $94 = (0)==($90|0);
   $95 = (0)==($93|0);
   $96 = $94 & $95;
   $97 = HEAP32[$2>>2]|0;
   if ($96) {
    $98 = HEAP32[$97>>2]|0;
    $99 = ($98|0)<(0);
    $100 = $99 << 31 >> 31;
    $101 = $ei;
    $102 = $101;
    HEAP32[$102>>2] = $98;
    $103 = (($101) + 4)|0;
    $104 = $103;
    HEAP32[$104>>2] = $100;
    $105 = $ei;
    $106 = $105;
    $107 = HEAP32[$106>>2]|0;
    $108 = (($105) + 4)|0;
    $109 = $108;
    $110 = HEAP32[$109>>2]|0;
    $111 = HEAP32[$p>>2]|0;
    $112 = $111;
    $113 = $112;
    $114 = HEAP32[$113>>2]|0;
    $115 = (($112) + 4)|0;
    $116 = $115;
    $117 = HEAP32[$116>>2]|0;
    $118 = (_i64Add(($114|0),($117|0),($107|0),($110|0))|0);
    $119 = tempRet0;
    $120 = $111;
    $121 = $120;
    HEAP32[$121>>2] = $118;
    $122 = (($120) + 4)|0;
    $123 = $122;
    HEAP32[$123>>2] = $119;
    break;
   } else {
    $124 = +HEAPF64[$97>>3];
    HEAPF64[$ed>>3] = $124;
    $125 = +HEAPF64[$ed>>3];
    $126 = HEAP32[$p>>2]|0;
    $127 = ((($126)) + 8|0);
    $128 = +HEAPF64[$127>>3];
    $129 = $128 + $125;
    HEAPF64[$127>>3] = $129;
    break;
   }
  }
 } while(0);
 $131 = $3;
 $132 = $131;
 $133 = HEAP32[$132>>2]|0;
 $134 = (($131) + 4)|0;
 $135 = $134;
 $136 = HEAP32[$135>>2]|0;
 $137 = HEAP32[$p>>2]|0;
 $138 = ((($137)) + 32|0);
 $139 = $138;
 $140 = $139;
 $141 = HEAP32[$140>>2]|0;
 $142 = (($139) + 4)|0;
 $143 = $142;
 $144 = HEAP32[$143>>2]|0;
 $145 = (_i64Add(($141|0),($144|0),($133|0),($136|0))|0);
 $146 = tempRet0;
 $147 = $138;
 $148 = $147;
 HEAP32[$148>>2] = $145;
 $149 = (($147) + 4)|0;
 $150 = $149;
 HEAP32[$150>>2] = $146;
 STACKTOP = sp;return;
}
function _sqlite3_compileoption_used($zOptName) {
 $zOptName = $zOptName|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $n = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $i = sp + 4|0;
 $n = sp;
 HEAP32[$1>>2] = $zOptName;
 $2 = HEAP32[$1>>2]|0;
 $3 = (_sqlite3_strnicmp($2,17605,7)|0);
 $4 = ($3|0)==(0);
 if ($4) {
  $5 = HEAP32[$1>>2]|0;
  $6 = ((($5)) + 7|0);
  HEAP32[$1>>2] = $6;
 }
 $7 = HEAP32[$1>>2]|0;
 $8 = (_sqlite3Strlen30($7)|0);
 HEAP32[$n>>2] = $8;
 HEAP32[$i>>2] = 0;
 while(1) {
  $9 = HEAP32[$i>>2]|0;
  $10 = ($9|0)<(8);
  if (!($10)) {
   label = 9;
   break;
  }
  $11 = HEAP32[$1>>2]|0;
  $12 = HEAP32[$i>>2]|0;
  $13 = (976 + ($12<<2)|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = HEAP32[$n>>2]|0;
  $16 = (_sqlite3_strnicmp($11,$14,$15)|0);
  $17 = ($16|0)==(0);
  if ($17) {
   $18 = HEAP32[$n>>2]|0;
   $19 = HEAP32[$i>>2]|0;
   $20 = (976 + ($19<<2)|0);
   $21 = HEAP32[$20>>2]|0;
   $22 = (($21) + ($18)|0);
   $23 = HEAP8[$22>>0]|0;
   $24 = (_sqlite3IsIdChar($23)|0);
   $25 = ($24|0)==(0);
   if ($25) {
    label = 7;
    break;
   }
  }
  $26 = HEAP32[$i>>2]|0;
  $27 = (($26) + 1)|0;
  HEAP32[$i>>2] = $27;
 }
 if ((label|0) == 7) {
  HEAP32[$0>>2] = 1;
  $28 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($28|0);
 }
 else if ((label|0) == 9) {
  HEAP32[$0>>2] = 0;
  $28 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($28|0);
 }
 return (0)|0;
}
function _sqlite3_strnicmp($zLeft,$zRight,$N) {
 $zLeft = $zLeft|0;
 $zRight = $zRight|0;
 $N = $N|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $a = 0, $b = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $2 = sp + 12|0;
 $3 = sp + 8|0;
 $a = sp + 4|0;
 $b = sp;
 HEAP32[$1>>2] = $zLeft;
 HEAP32[$2>>2] = $zRight;
 HEAP32[$3>>2] = $N;
 $4 = HEAP32[$1>>2]|0;
 $5 = ($4|0)==(0|0);
 $6 = HEAP32[$2>>2]|0;
 if ($5) {
  $7 = ($6|0)!=(0|0);
  $8 = $7 ? -1 : 0;
  HEAP32[$0>>2] = $8;
  $52 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($52|0);
 }
 $9 = ($6|0)==(0|0);
 if ($9) {
  HEAP32[$0>>2] = 1;
  $52 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($52|0);
 }
 $10 = HEAP32[$1>>2]|0;
 HEAP32[$a>>2] = $10;
 $11 = HEAP32[$2>>2]|0;
 HEAP32[$b>>2] = $11;
 while(1) {
  $12 = HEAP32[$3>>2]|0;
  $13 = (($12) + -1)|0;
  HEAP32[$3>>2] = $13;
  $14 = ($12|0)>(0);
  if (!($14)) {
   break;
  }
  $15 = HEAP32[$a>>2]|0;
  $16 = HEAP8[$15>>0]|0;
  $17 = $16&255;
  $18 = ($17|0)!=(0);
  if (!($18)) {
   break;
  }
  $19 = HEAP32[$a>>2]|0;
  $20 = HEAP8[$19>>0]|0;
  $21 = $20&255;
  $22 = (17613 + ($21)|0);
  $23 = HEAP8[$22>>0]|0;
  $24 = $23&255;
  $25 = HEAP32[$b>>2]|0;
  $26 = HEAP8[$25>>0]|0;
  $27 = $26&255;
  $28 = (17613 + ($27)|0);
  $29 = HEAP8[$28>>0]|0;
  $30 = $29&255;
  $31 = ($24|0)==($30|0);
  if (!($31)) {
   break;
  }
  $32 = HEAP32[$a>>2]|0;
  $33 = ((($32)) + 1|0);
  HEAP32[$a>>2] = $33;
  $34 = HEAP32[$b>>2]|0;
  $35 = ((($34)) + 1|0);
  HEAP32[$b>>2] = $35;
 }
 $36 = HEAP32[$3>>2]|0;
 $37 = ($36|0)<(0);
 if ($37) {
  $51 = 0;
 } else {
  $38 = HEAP32[$a>>2]|0;
  $39 = HEAP8[$38>>0]|0;
  $40 = $39&255;
  $41 = (17613 + ($40)|0);
  $42 = HEAP8[$41>>0]|0;
  $43 = $42&255;
  $44 = HEAP32[$b>>2]|0;
  $45 = HEAP8[$44>>0]|0;
  $46 = $45&255;
  $47 = (17613 + ($46)|0);
  $48 = HEAP8[$47>>0]|0;
  $49 = $48&255;
  $50 = (($43) - ($49))|0;
  $51 = $50;
 }
 HEAP32[$0>>2] = $51;
 $52 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($52|0);
}
function _sqlite3_compileoption_get($N) {
 $N = $N|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$1>>2] = $N;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)>=(0);
 $4 = HEAP32[$1>>2]|0;
 $5 = ($4|0)<(8);
 $or$cond = $3 & $5;
 if ($or$cond) {
  $6 = HEAP32[$1>>2]|0;
  $7 = (976 + ($6<<2)|0);
  $8 = HEAP32[$7>>2]|0;
  HEAP32[$0>>2] = $8;
  $9 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($9|0);
 } else {
  HEAP32[$0>>2] = 0;
  $9 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($9|0);
 }
 return (0)|0;
}
function _sqlite3_status64($op,$pCurrent,$pHighwater,$resetFlag) {
 $op = $op|0;
 $pCurrent = $pCurrent|0;
 $pHighwater = $pHighwater|0;
 $resetFlag = $resetFlag|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $or$cond = 0, $pMutex = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $2 = sp + 12|0;
 $3 = sp + 8|0;
 $4 = sp + 4|0;
 $pMutex = sp;
 HEAP32[$1>>2] = $op;
 HEAP32[$2>>2] = $pCurrent;
 HEAP32[$3>>2] = $pHighwater;
 HEAP32[$4>>2] = $resetFlag;
 $5 = HEAP32[$1>>2]|0;
 $6 = ($5|0)<(0);
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)>=(10);
 $or$cond = $6 | $8;
 if ($or$cond) {
  $9 = (_sqlite3MisuseError(18365)|0);
  HEAP32[$0>>2] = $9;
  $41 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($41|0);
 }
 $10 = HEAP32[$1>>2]|0;
 $11 = (17869 + ($10)|0);
 $12 = HEAP8[$11>>0]|0;
 $13 = $12 << 24 >> 24;
 $14 = ($13|0)!=(0);
 if ($14) {
  $15 = (_sqlite3Pcache1Mutex()|0);
  $17 = $15;
 } else {
  $16 = (_sqlite3MallocMutex()|0);
  $17 = $16;
 }
 HEAP32[$pMutex>>2] = $17;
 $18 = HEAP32[$1>>2]|0;
 $19 = (1008 + ($18<<2)|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = HEAP32[$2>>2]|0;
 $22 = $21;
 $23 = $22;
 HEAP32[$23>>2] = $20;
 $24 = (($22) + 4)|0;
 $25 = $24;
 HEAP32[$25>>2] = 0;
 $26 = HEAP32[$1>>2]|0;
 $27 = ((1048) + ($26<<2)|0);
 $28 = HEAP32[$27>>2]|0;
 $29 = HEAP32[$3>>2]|0;
 $30 = $29;
 $31 = $30;
 HEAP32[$31>>2] = $28;
 $32 = (($30) + 4)|0;
 $33 = $32;
 HEAP32[$33>>2] = 0;
 $34 = HEAP32[$4>>2]|0;
 $35 = ($34|0)!=(0);
 if ($35) {
  $36 = HEAP32[$1>>2]|0;
  $37 = (1008 + ($36<<2)|0);
  $38 = HEAP32[$37>>2]|0;
  $39 = HEAP32[$1>>2]|0;
  $40 = ((1048) + ($39<<2)|0);
  HEAP32[$40>>2] = $38;
 }
 HEAP32[$0>>2] = 0;
 $41 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($41|0);
}
function _sqlite3_vfs_find($zVfs) {
 $zVfs = $zVfs|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, $or$cond = 0, $pVfs = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $pVfs = sp + 4|0;
 $rc = sp;
 HEAP32[$1>>2] = $zVfs;
 HEAP32[$pVfs>>2] = 0;
 $2 = (_sqlite3_initialize()|0);
 HEAP32[$rc>>2] = $2;
 $3 = HEAP32[$rc>>2]|0;
 $4 = ($3|0)!=(0);
 if ($4) {
  HEAP32[$0>>2] = 0;
  $20 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($20|0);
 }
 $5 = HEAP32[1088>>2]|0;
 HEAP32[$pVfs>>2] = $5;
 while(1) {
  $6 = HEAP32[$pVfs>>2]|0;
  $7 = ($6|0)==(0|0);
  $8 = HEAP32[$1>>2]|0;
  $9 = ($8|0)==(0|0);
  $or$cond = $7 | $9;
  if ($or$cond) {
   break;
  }
  $10 = HEAP32[$1>>2]|0;
  $11 = HEAP32[$pVfs>>2]|0;
  $12 = ((($11)) + 16|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = (_strcmp($10,$13)|0);
  $15 = ($14|0)==(0);
  if ($15) {
   break;
  }
  $16 = HEAP32[$pVfs>>2]|0;
  $17 = ((($16)) + 12|0);
  $18 = HEAP32[$17>>2]|0;
  HEAP32[$pVfs>>2] = $18;
 }
 $19 = HEAP32[$pVfs>>2]|0;
 HEAP32[$0>>2] = $19;
 $20 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($20|0);
}
function _sqlite3_initialize() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $or$cond3 = 0, $rc = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $rc = sp;
 $1 = HEAP32[(236)>>2]|0;
 $2 = ($1|0)!=(0);
 if ($2) {
  HEAP32[$0>>2] = 0;
  $44 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($44|0);
 }
 HEAP32[$rc>>2] = 0;
 $3 = HEAP32[$rc>>2]|0;
 $4 = ($3|0)!=(0);
 if ($4) {
  $5 = HEAP32[$rc>>2]|0;
  HEAP32[$0>>2] = $5;
  $44 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($44|0);
 }
 HEAP32[(244)>>2] = 1;
 $6 = HEAP32[(248)>>2]|0;
 $7 = ($6|0)!=(0);
 if (!($7)) {
  $8 = (_sqlite3MallocInit()|0);
  HEAP32[$rc>>2] = $8;
 }
 $9 = HEAP32[$rc>>2]|0;
 $10 = ($9|0)==(0);
 if ($10) {
  HEAP32[(248)>>2] = 1;
  $11 = HEAP32[(260)>>2]|0;
  $12 = ($11|0)!=(0|0);
  if (!($12)) {
   HEAP32[(260)>>2] = (8);
   $13 = HEAP32[(12)>>2]|0;
   $14 = ($13|0)==(0);
   $15 = HEAP32[(260)>>2]|0;
   $16 = ($15|0)!=(0|0);
   $or$cond = $14 | $16;
   if (!($or$cond)) {
    HEAP32[$rc>>2] = 7;
   }
  }
 }
 $17 = HEAP32[$rc>>2]|0;
 $18 = ($17|0)==(0);
 if ($18) {
  $19 = HEAP32[(256)>>2]|0;
  $20 = (($19) + 1)|0;
  HEAP32[(256)>>2] = $20;
 }
 $21 = HEAP32[$rc>>2]|0;
 $22 = ($21|0)!=(0);
 if ($22) {
  $23 = HEAP32[$rc>>2]|0;
  HEAP32[$0>>2] = $23;
  $44 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($44|0);
 }
 $24 = HEAP32[(236)>>2]|0;
 $25 = ($24|0)==(0);
 $26 = HEAP32[(240)>>2]|0;
 $27 = ($26|0)==(0);
 $or$cond3 = $25 & $27;
 if ($or$cond3) {
  HEAP32[(240)>>2] = 1;
  dest=1092; stop=dest+92|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
  _sqlite3RegisterBuiltinFunctions();
  $28 = HEAP32[(252)>>2]|0;
  $29 = ($28|0)==(0);
  if ($29) {
   $30 = (_sqlite3PcacheInitialize()|0);
   HEAP32[$rc>>2] = $30;
  }
  $31 = HEAP32[$rc>>2]|0;
  $32 = ($31|0)==(0);
  if ($32) {
   HEAP32[(252)>>2] = 1;
   $33 = (_sqlite3OsInit()|0);
   HEAP32[$rc>>2] = $33;
  }
  $34 = HEAP32[$rc>>2]|0;
  $35 = ($34|0)==(0);
  if ($35) {
   $36 = HEAP32[(212)>>2]|0;
   $37 = HEAP32[(216)>>2]|0;
   $38 = HEAP32[(220)>>2]|0;
   _sqlite3PCacheBufferSetup($36,$37,$38);
   HEAP32[(236)>>2] = 1;
  }
  HEAP32[(240)>>2] = 0;
 }
 $39 = HEAP32[(256)>>2]|0;
 $40 = (($39) + -1)|0;
 HEAP32[(256)>>2] = $40;
 $41 = HEAP32[(256)>>2]|0;
 $42 = ($41|0)<=(0);
 if ($42) {
  HEAP32[(260)>>2] = 0;
 }
 $43 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $43;
 $44 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($44|0);
}
function _sqlite3_vfs_register($pVfs,$makeDflt) {
 $pVfs = $pVfs|0;
 $makeDflt = $makeDflt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $rc = sp;
 HEAP32[$1>>2] = $pVfs;
 HEAP32[$2>>2] = $makeDflt;
 $3 = (_sqlite3_initialize()|0);
 HEAP32[$rc>>2] = $3;
 $4 = HEAP32[$rc>>2]|0;
 $5 = ($4|0)!=(0);
 if ($5) {
  $6 = HEAP32[$rc>>2]|0;
  HEAP32[$0>>2] = $6;
  $23 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($23|0);
 }
 $7 = HEAP32[$1>>2]|0;
 _vfsUnlink($7);
 $8 = HEAP32[$2>>2]|0;
 $9 = ($8|0)!=(0);
 $10 = HEAP32[1088>>2]|0;
 $11 = ($10|0)==(0|0);
 $or$cond = $9 | $11;
 $12 = HEAP32[1088>>2]|0;
 if ($or$cond) {
  $13 = HEAP32[$1>>2]|0;
  $14 = ((($13)) + 12|0);
  HEAP32[$14>>2] = $12;
  $15 = HEAP32[$1>>2]|0;
  HEAP32[1088>>2] = $15;
 } else {
  $16 = ((($12)) + 12|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = HEAP32[$1>>2]|0;
  $19 = ((($18)) + 12|0);
  HEAP32[$19>>2] = $17;
  $20 = HEAP32[$1>>2]|0;
  $21 = HEAP32[1088>>2]|0;
  $22 = ((($21)) + 12|0);
  HEAP32[$22>>2] = $20;
 }
 HEAP32[$0>>2] = 0;
 $23 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($23|0);
}
function _sqlite3_release_memory($n) {
 $n = $n|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $n;
 STACKTOP = sp;return 0;
}
function _sqlite3_soft_heap_limit64($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0;
 var $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0;
 var $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0;
 var $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0;
 var $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $excess = 0, $nUsed = 0, $priorLimit = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $2 = sp + 32|0;
 $3 = sp + 24|0;
 $priorLimit = sp + 16|0;
 $excess = sp + 8|0;
 $nUsed = sp;
 $rc = sp + 40|0;
 $4 = $3;
 $5 = $4;
 HEAP32[$5>>2] = $0;
 $6 = (($4) + 4)|0;
 $7 = $6;
 HEAP32[$7>>2] = $1;
 $8 = (_sqlite3_initialize()|0);
 HEAP32[$rc>>2] = $8;
 $9 = HEAP32[$rc>>2]|0;
 $10 = ($9|0)!=(0);
 if ($10) {
  $11 = $2;
  $12 = $11;
  HEAP32[$12>>2] = -1;
  $13 = (($11) + 4)|0;
  $14 = $13;
  HEAP32[$14>>2] = -1;
  $130 = $2;
  $131 = $130;
  $132 = HEAP32[$131>>2]|0;
  $133 = (($130) + 4)|0;
  $134 = $133;
  $135 = HEAP32[$134>>2]|0;
  tempRet0 = ($135);
  STACKTOP = sp;return ($132|0);
 }
 $15 = (296);
 $16 = $15;
 $17 = HEAP32[$16>>2]|0;
 $18 = (($15) + 4)|0;
 $19 = $18;
 $20 = HEAP32[$19>>2]|0;
 $21 = $priorLimit;
 $22 = $21;
 HEAP32[$22>>2] = $17;
 $23 = (($21) + 4)|0;
 $24 = $23;
 HEAP32[$24>>2] = $20;
 $25 = $3;
 $26 = $25;
 $27 = HEAP32[$26>>2]|0;
 $28 = (($25) + 4)|0;
 $29 = $28;
 $30 = HEAP32[$29>>2]|0;
 $31 = ($30|0)<(0);
 if ($31) {
  $32 = $priorLimit;
  $33 = $32;
  $34 = HEAP32[$33>>2]|0;
  $35 = (($32) + 4)|0;
  $36 = $35;
  $37 = HEAP32[$36>>2]|0;
  $38 = $2;
  $39 = $38;
  HEAP32[$39>>2] = $34;
  $40 = (($38) + 4)|0;
  $41 = $40;
  HEAP32[$41>>2] = $37;
  $130 = $2;
  $131 = $130;
  $132 = HEAP32[$131>>2]|0;
  $133 = (($130) + 4)|0;
  $134 = $133;
  $135 = HEAP32[$134>>2]|0;
  tempRet0 = ($135);
  STACKTOP = sp;return ($132|0);
 }
 $42 = $3;
 $43 = $42;
 $44 = HEAP32[$43>>2]|0;
 $45 = (($42) + 4)|0;
 $46 = $45;
 $47 = HEAP32[$46>>2]|0;
 $48 = (296);
 $49 = $48;
 HEAP32[$49>>2] = $44;
 $50 = (($48) + 4)|0;
 $51 = $50;
 HEAP32[$51>>2] = $47;
 $52 = (_sqlite3StatusValue(0)|0);
 $53 = tempRet0;
 $54 = $nUsed;
 $55 = $54;
 HEAP32[$55>>2] = $52;
 $56 = (($54) + 4)|0;
 $57 = $56;
 HEAP32[$57>>2] = $53;
 $58 = $3;
 $59 = $58;
 $60 = HEAP32[$59>>2]|0;
 $61 = (($58) + 4)|0;
 $62 = $61;
 $63 = HEAP32[$62>>2]|0;
 $64 = ($63|0)>(0);
 $65 = ($60>>>0)>(0);
 $66 = ($63|0)==(0);
 $67 = $66 & $65;
 $68 = $64 | $67;
 if ($68) {
  $69 = $3;
  $70 = $69;
  $71 = HEAP32[$70>>2]|0;
  $72 = (($69) + 4)|0;
  $73 = $72;
  $74 = HEAP32[$73>>2]|0;
  $75 = $nUsed;
  $76 = $75;
  $77 = HEAP32[$76>>2]|0;
  $78 = (($75) + 4)|0;
  $79 = $78;
  $80 = HEAP32[$79>>2]|0;
  $81 = ($74|0)<($80|0);
  $82 = ($71>>>0)<=($77>>>0);
  $83 = ($74|0)==($80|0);
  $84 = $83 & $82;
  $85 = $81 | $84;
  $87 = $85;
 } else {
  $87 = 0;
 }
 $86 = $87&1;
 HEAP32[(316)>>2] = $86;
 $88 = (_sqlite3_memory_used()|0);
 $89 = tempRet0;
 $90 = $3;
 $91 = $90;
 $92 = HEAP32[$91>>2]|0;
 $93 = (($90) + 4)|0;
 $94 = $93;
 $95 = HEAP32[$94>>2]|0;
 $96 = (_i64Subtract(($88|0),($89|0),($92|0),($95|0))|0);
 $97 = tempRet0;
 $98 = $excess;
 $99 = $98;
 HEAP32[$99>>2] = $96;
 $100 = (($98) + 4)|0;
 $101 = $100;
 HEAP32[$101>>2] = $97;
 $102 = $excess;
 $103 = $102;
 $104 = HEAP32[$103>>2]|0;
 $105 = (($102) + 4)|0;
 $106 = $105;
 $107 = HEAP32[$106>>2]|0;
 $108 = ($107|0)>(0);
 $109 = ($104>>>0)>(0);
 $110 = ($107|0)==(0);
 $111 = $110 & $109;
 $112 = $108 | $111;
 if ($112) {
  $113 = $excess;
  $114 = $113;
  $115 = HEAP32[$114>>2]|0;
  $116 = (($113) + 4)|0;
  $117 = $116;
  $118 = HEAP32[$117>>2]|0;
  $119 = $115 & 2147483647;
  (_sqlite3_release_memory($119)|0);
 }
 $120 = $priorLimit;
 $121 = $120;
 $122 = HEAP32[$121>>2]|0;
 $123 = (($120) + 4)|0;
 $124 = $123;
 $125 = HEAP32[$124>>2]|0;
 $126 = $2;
 $127 = $126;
 HEAP32[$127>>2] = $122;
 $128 = (($126) + 4)|0;
 $129 = $128;
 HEAP32[$129>>2] = $125;
 $130 = $2;
 $131 = $130;
 $132 = HEAP32[$131>>2]|0;
 $133 = (($130) + 4)|0;
 $134 = $133;
 $135 = HEAP32[$134>>2]|0;
 tempRet0 = ($135);
 STACKTOP = sp;return ($132|0);
}
function _sqlite3_memory_used() {
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $mx = 0, $res = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $res = sp + 8|0;
 $mx = sp;
 (_sqlite3_status64(0,$res,$mx,0)|0);
 $0 = $res;
 $1 = $0;
 $2 = HEAP32[$1>>2]|0;
 $3 = (($0) + 4)|0;
 $4 = $3;
 $5 = HEAP32[$4>>2]|0;
 tempRet0 = ($5);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3_malloc($n) {
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$1>>2] = $n;
 $2 = (_sqlite3_initialize()|0);
 $3 = ($2|0)!=(0);
 if ($3) {
  HEAP32[$0>>2] = 0;
  $11 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($11|0);
 }
 $4 = HEAP32[$1>>2]|0;
 $5 = ($4|0)<=(0);
 if ($5) {
  $10 = 0;
 } else {
  $6 = HEAP32[$1>>2]|0;
  $7 = ($6|0)<(0);
  $8 = $7 << 31 >> 31;
  $9 = (_sqlite3Malloc($6,$8)|0);
  $10 = $9;
 }
 HEAP32[$0>>2] = $10;
 $11 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($11|0);
}
function _sqlite3_malloc64($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $2 = sp + 8|0;
 $3 = sp;
 $4 = $3;
 $5 = $4;
 HEAP32[$5>>2] = $0;
 $6 = (($4) + 4)|0;
 $7 = $6;
 HEAP32[$7>>2] = $1;
 $8 = (_sqlite3_initialize()|0);
 $9 = ($8|0)!=(0);
 if ($9) {
  HEAP32[$2>>2] = 0;
  $17 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($17|0);
 } else {
  $10 = $3;
  $11 = $10;
  $12 = HEAP32[$11>>2]|0;
  $13 = (($10) + 4)|0;
  $14 = $13;
  $15 = HEAP32[$14>>2]|0;
  $16 = (_sqlite3Malloc($12,$15)|0);
  HEAP32[$2>>2] = $16;
  $17 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($17|0);
 }
 return (0)|0;
}
function _sqlite3_free($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  STACKTOP = sp;return;
 }
 $3 = HEAP32[8>>2]|0;
 $4 = ($3|0)!=(0);
 if ($4) {
  $5 = HEAP32[$0>>2]|0;
  $6 = (_sqlite3MallocSize($5)|0);
  _sqlite3StatusDown(0,$6);
  _sqlite3StatusDown(9,1);
  $7 = HEAP32[(52)>>2]|0;
  $8 = HEAP32[$0>>2]|0;
  FUNCTION_TABLE_vi[$7 & 255]($8);
  STACKTOP = sp;return;
 } else {
  $9 = HEAP32[(52)>>2]|0;
  $10 = HEAP32[$0>>2]|0;
  FUNCTION_TABLE_vi[$9 & 255]($10);
  STACKTOP = sp;return;
 }
}
function _sqlite3_realloc($pOld,$n) {
 $pOld = $pOld|0;
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$1>>2] = $pOld;
 HEAP32[$2>>2] = $n;
 $3 = (_sqlite3_initialize()|0);
 $4 = ($3|0)!=(0);
 if ($4) {
  HEAP32[$0>>2] = 0;
  $12 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($12|0);
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = ($5|0)<(0);
 if ($6) {
  HEAP32[$2>>2] = 0;
 }
 $7 = HEAP32[$1>>2]|0;
 $8 = HEAP32[$2>>2]|0;
 $9 = ($8|0)<(0);
 $10 = $9 << 31 >> 31;
 $11 = (_sqlite3Realloc($7,$8,$10)|0);
 HEAP32[$0>>2] = $11;
 $12 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($12|0);
}
function _sqlite3_realloc64($pOld,$0,$1) {
 $pOld = $pOld|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $2 = sp + 12|0;
 $3 = sp + 8|0;
 $4 = sp;
 HEAP32[$3>>2] = $pOld;
 $5 = $4;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 $9 = (_sqlite3_initialize()|0);
 $10 = ($9|0)!=(0);
 if ($10) {
  HEAP32[$2>>2] = 0;
  $19 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($19|0);
 } else {
  $11 = HEAP32[$3>>2]|0;
  $12 = $4;
  $13 = $12;
  $14 = HEAP32[$13>>2]|0;
  $15 = (($12) + 4)|0;
  $16 = $15;
  $17 = HEAP32[$16>>2]|0;
  $18 = (_sqlite3Realloc($11,$14,$17)|0);
  HEAP32[$2>>2] = $18;
  $19 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($19|0);
 }
 return (0)|0;
}
function _sqlite3_vmprintf($zFormat,$ap) {
 $zFormat = $zFormat|0;
 $ap = $ap|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $acc = 0, $z = 0, $zBase = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0;
 $0 = sp + 40|0;
 $1 = sp + 36|0;
 $2 = sp + 32|0;
 $z = sp + 28|0;
 $zBase = sp + 44|0;
 $acc = sp;
 HEAP32[$1>>2] = $zFormat;
 HEAP32[$2>>2] = $ap;
 $3 = (_sqlite3_initialize()|0);
 $4 = ($3|0)!=(0);
 if ($4) {
  HEAP32[$0>>2] = 0;
  $9 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($9|0);
 } else {
  _sqlite3StrAccumInit($acc,0,$zBase,70,1000000000);
  $5 = HEAP32[$1>>2]|0;
  $6 = HEAP32[$2>>2]|0;
  _sqlite3VXPrintf($acc,$5,$6);
  $7 = (_sqlite3StrAccumFinish($acc)|0);
  HEAP32[$z>>2] = $7;
  $8 = HEAP32[$z>>2]|0;
  HEAP32[$0>>2] = $8;
  $9 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($9|0);
 }
 return (0)|0;
}
function _sqlite3_mprintf($zFormat,$varargs) {
 $zFormat = $zFormat|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $ap = 0, $z = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $ap = sp + 8|0;
 $z = sp;
 HEAP32[$1>>2] = $zFormat;
 $2 = (_sqlite3_initialize()|0);
 $3 = ($2|0)!=(0);
 if ($3) {
  HEAP32[$0>>2] = 0;
  $7 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($7|0);
 } else {
  HEAP32[$ap>>2] = $varargs;
  $4 = HEAP32[$1>>2]|0;
  $5 = (_sqlite3_vmprintf($4,$ap)|0);
  HEAP32[$z>>2] = $5;
  $6 = HEAP32[$z>>2]|0;
  HEAP32[$0>>2] = $6;
  $7 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($7|0);
 }
 return (0)|0;
}
function _sqlite3_vsnprintf($n,$zBuf,$zFormat,$ap) {
 $n = $n|0;
 $zBuf = $zBuf|0;
 $zFormat = $zFormat|0;
 $ap = $ap|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $acc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 44|0;
 $1 = sp + 40|0;
 $2 = sp + 36|0;
 $3 = sp + 32|0;
 $4 = sp + 28|0;
 $acc = sp;
 HEAP32[$1>>2] = $n;
 HEAP32[$2>>2] = $zBuf;
 HEAP32[$3>>2] = $zFormat;
 HEAP32[$4>>2] = $ap;
 $5 = HEAP32[$1>>2]|0;
 $6 = ($5|0)<=(0);
 $7 = HEAP32[$2>>2]|0;
 if ($6) {
  HEAP32[$0>>2] = $7;
  $12 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($12|0);
 } else {
  $8 = HEAP32[$1>>2]|0;
  _sqlite3StrAccumInit($acc,0,$7,$8,0);
  $9 = HEAP32[$3>>2]|0;
  $10 = HEAP32[$4>>2]|0;
  _sqlite3VXPrintf($acc,$9,$10);
  $11 = (_sqlite3StrAccumFinish($acc)|0);
  HEAP32[$0>>2] = $11;
  $12 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($12|0);
 }
 return (0)|0;
}
function _sqlite3_snprintf($n,$zBuf,$zFormat,$varargs) {
 $n = $n|0;
 $zBuf = $zBuf|0;
 $zFormat = $zFormat|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $ap = 0, $z = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $z = sp + 16|0;
 $ap = sp;
 HEAP32[$0>>2] = $n;
 HEAP32[$1>>2] = $zBuf;
 HEAP32[$2>>2] = $zFormat;
 HEAP32[$ap>>2] = $varargs;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = HEAP32[$2>>2]|0;
 $6 = (_sqlite3_vsnprintf($3,$4,$5,$ap)|0);
 HEAP32[$z>>2] = $6;
 $7 = HEAP32[$z>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3_log($iErrCode,$zFormat,$varargs) {
 $iErrCode = $iErrCode|0;
 $zFormat = $zFormat|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $ap = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $ap = sp;
 HEAP32[$0>>2] = $iErrCode;
 HEAP32[$1>>2] = $zFormat;
 $2 = HEAP32[(264)>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 HEAP32[$ap>>2] = $varargs;
 $4 = HEAP32[$0>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 _renderLogMsg($4,$5,$ap);
 STACKTOP = sp;return;
}
function _sqlite3_randomness($N,$pBuf) {
 $N = $N|0;
 $pBuf = $pBuf|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $i = 0, $k = 0, $or$cond = 0, $t = 0, $zBuf = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 288|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $t = sp + 272|0;
 $zBuf = sp + 4|0;
 $i = sp;
 $k = sp + 16|0;
 HEAP32[$0>>2] = $N;
 HEAP32[$1>>2] = $pBuf;
 $2 = HEAP32[$1>>2]|0;
 HEAP32[$zBuf>>2] = $2;
 $3 = (_sqlite3_initialize()|0);
 $4 = ($3|0)!=(0);
 if ($4) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$0>>2]|0;
 $6 = ($5|0)<=(0);
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)==(0|0);
 $or$cond = $6 | $8;
 if ($or$cond) {
  HEAP8[17879>>0] = 0;
  STACKTOP = sp;return;
 }
 $9 = HEAP8[17879>>0]|0;
 $10 = ($9<<24>>24)!=(0);
 if (!($10)) {
  HEAP8[(17881)>>0] = 0;
  HEAP8[(17880)>>0] = 0;
  $11 = (_sqlite3_vfs_find(0)|0);
  (_sqlite3OsRandomness($11,256,$k)|0);
  HEAP32[$i>>2] = 0;
  while(1) {
   $12 = HEAP32[$i>>2]|0;
   $13 = ($12|0)<(256);
   if (!($13)) {
    break;
   }
   $14 = HEAP32[$i>>2]|0;
   $15 = $14&255;
   $16 = HEAP32[$i>>2]|0;
   $17 = ((17882) + ($16)|0);
   HEAP8[$17>>0] = $15;
   $18 = HEAP32[$i>>2]|0;
   $19 = (($18) + 1)|0;
   HEAP32[$i>>2] = $19;
  }
  HEAP32[$i>>2] = 0;
  while(1) {
   $20 = HEAP32[$i>>2]|0;
   $21 = ($20|0)<(256);
   if (!($21)) {
    break;
   }
   $22 = HEAP32[$i>>2]|0;
   $23 = ((17882) + ($22)|0);
   $24 = HEAP8[$23>>0]|0;
   $25 = $24&255;
   $26 = HEAP32[$i>>2]|0;
   $27 = (($k) + ($26)|0);
   $28 = HEAP8[$27>>0]|0;
   $29 = $28 << 24 >> 24;
   $30 = (($25) + ($29))|0;
   $31 = HEAP8[(17881)>>0]|0;
   $32 = $31&255;
   $33 = (($32) + ($30))|0;
   $34 = $33&255;
   HEAP8[(17881)>>0] = $34;
   $35 = HEAP8[(17881)>>0]|0;
   $36 = $35&255;
   $37 = ((17882) + ($36)|0);
   $38 = HEAP8[$37>>0]|0;
   HEAP8[$t>>0] = $38;
   $39 = HEAP32[$i>>2]|0;
   $40 = ((17882) + ($39)|0);
   $41 = HEAP8[$40>>0]|0;
   $42 = HEAP8[(17881)>>0]|0;
   $43 = $42&255;
   $44 = ((17882) + ($43)|0);
   HEAP8[$44>>0] = $41;
   $45 = HEAP8[$t>>0]|0;
   $46 = HEAP32[$i>>2]|0;
   $47 = ((17882) + ($46)|0);
   HEAP8[$47>>0] = $45;
   $48 = HEAP32[$i>>2]|0;
   $49 = (($48) + 1)|0;
   HEAP32[$i>>2] = $49;
  }
  HEAP8[17879>>0] = 1;
 }
 while(1) {
  $50 = HEAP8[(17880)>>0]|0;
  $51 = (($50) + 1)<<24>>24;
  HEAP8[(17880)>>0] = $51;
  $52 = HEAP8[(17880)>>0]|0;
  $53 = $52&255;
  $54 = ((17882) + ($53)|0);
  $55 = HEAP8[$54>>0]|0;
  HEAP8[$t>>0] = $55;
  $56 = HEAP8[$t>>0]|0;
  $57 = $56&255;
  $58 = HEAP8[(17881)>>0]|0;
  $59 = $58&255;
  $60 = (($59) + ($57))|0;
  $61 = $60&255;
  HEAP8[(17881)>>0] = $61;
  $62 = HEAP8[(17881)>>0]|0;
  $63 = $62&255;
  $64 = ((17882) + ($63)|0);
  $65 = HEAP8[$64>>0]|0;
  $66 = HEAP8[(17880)>>0]|0;
  $67 = $66&255;
  $68 = ((17882) + ($67)|0);
  HEAP8[$68>>0] = $65;
  $69 = HEAP8[$t>>0]|0;
  $70 = HEAP8[(17881)>>0]|0;
  $71 = $70&255;
  $72 = ((17882) + ($71)|0);
  HEAP8[$72>>0] = $69;
  $73 = HEAP8[(17880)>>0]|0;
  $74 = $73&255;
  $75 = ((17882) + ($74)|0);
  $76 = HEAP8[$75>>0]|0;
  $77 = $76&255;
  $78 = HEAP8[$t>>0]|0;
  $79 = $78&255;
  $80 = (($79) + ($77))|0;
  $81 = $80&255;
  HEAP8[$t>>0] = $81;
  $82 = HEAP8[$t>>0]|0;
  $83 = $82&255;
  $84 = ((17882) + ($83)|0);
  $85 = HEAP8[$84>>0]|0;
  $86 = HEAP32[$zBuf>>2]|0;
  $87 = ((($86)) + 1|0);
  HEAP32[$zBuf>>2] = $87;
  HEAP8[$86>>0] = $85;
  $88 = HEAP32[$0>>2]|0;
  $89 = (($88) + -1)|0;
  HEAP32[$0>>2] = $89;
  $90 = ($89|0)!=(0);
  if (!($90)) {
   break;
  }
 }
 STACKTOP = sp;return;
}
function _sqlite3_stricmp($zLeft,$zRight) {
 $zLeft = $zLeft|0;
 $zRight = $zRight|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$1>>2] = $zLeft;
 HEAP32[$2>>2] = $zRight;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(0|0);
 $5 = HEAP32[$2>>2]|0;
 do {
  if ($4) {
   $6 = ($5|0)!=(0|0);
   $7 = $6 ? -1 : 0;
   HEAP32[$0>>2] = $7;
  } else {
   $8 = ($5|0)==(0|0);
   if ($8) {
    HEAP32[$0>>2] = 1;
    break;
   } else {
    $9 = HEAP32[$1>>2]|0;
    $10 = HEAP32[$2>>2]|0;
    $11 = (_sqlite3StrICmp($9,$10)|0);
    HEAP32[$0>>2] = $11;
    break;
   }
  }
 } while(0);
 $12 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($12|0);
}
function _sqlite3_os_init() {
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $i = sp;
 HEAP32[$i>>2] = 0;
 while(1) {
  $0 = HEAP32[$i>>2]|0;
  $1 = ($0>>>0)<(4);
  if (!($1)) {
   break;
  }
  $2 = HEAP32[$i>>2]|0;
  $3 = (1184 + (($2*88)|0)|0);
  $4 = HEAP32[$i>>2]|0;
  $5 = ($4|0)==(0);
  $6 = $5&1;
  (_sqlite3_vfs_register($3,$6)|0);
  $7 = HEAP32[$i>>2]|0;
  $8 = (($7) + 1)|0;
  HEAP32[$i>>2] = $8;
 }
 STACKTOP = sp;return 0;
}
function _sqlite3_backup_step($p,$nPage) {
 $p = $p|0;
 $nPage = $nPage|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0;
 var $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0;
 var $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0;
 var $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0;
 var $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0;
 var $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0;
 var $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0;
 var $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0;
 var $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0;
 var $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0;
 var $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0;
 var $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0;
 var $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0;
 var $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0;
 var $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0;
 var $368 = 0, $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0;
 var $386 = 0, $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0;
 var $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0;
 var $421 = 0, $422 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0;
 var $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bCloseTrans = 0, $destMode = 0, $iEnd = 0, $iOff = 0, $iPg = 0, $iSize = 0, $iSrcPg = 0, $iSrcPg2 = 0, $ii = 0, $nDestTruncate = 0, $nDstPage = 0, $nSrcPage = 0, $or$cond = 0, $or$cond3 = 0, $or$cond6 = 0, $pDestPager = 0;
 var $pFile = 0, $pPg = 0, $pSrcPager = 0, $pSrcPg = 0, $pSrcPg1 = 0, $pgszDest = 0, $pgszSrc = 0, $ratio = 0, $rc = 0, $zData = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 112|0;
 $0 = sp + 108|0;
 $1 = sp + 104|0;
 $rc = sp + 100|0;
 $destMode = sp + 96|0;
 $pgszSrc = sp + 92|0;
 $pgszDest = sp + 88|0;
 $pSrcPager = sp + 84|0;
 $pDestPager = sp + 80|0;
 $ii = sp + 76|0;
 $nSrcPage = sp + 72|0;
 $bCloseTrans = sp + 68|0;
 $iSrcPg = sp + 64|0;
 $pSrcPg = sp + 60|0;
 $nDestTruncate = sp + 56|0;
 $ratio = sp + 52|0;
 $iSize = sp + 16|0;
 $pFile = sp + 48|0;
 $iPg = sp + 44|0;
 $nDstPage = sp + 40|0;
 $iOff = sp + 8|0;
 $iEnd = sp;
 $pPg = sp + 36|0;
 $pSrcPg1 = sp + 32|0;
 $iSrcPg2 = sp + 28|0;
 $zData = sp + 24|0;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $nPage;
 HEAP32[$pgszSrc>>2] = 0;
 HEAP32[$pgszDest>>2] = 0;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 24|0);
 $4 = HEAP32[$3>>2]|0;
 _sqlite3BtreeEnter($4);
 $5 = HEAP32[$0>>2]|0;
 $6 = ((($5)) + 28|0);
 $7 = HEAP32[$6>>2]|0;
 HEAP32[$rc>>2] = $7;
 $8 = HEAP32[$rc>>2]|0;
 $9 = (_isFatalError($8)|0);
 $10 = ($9|0)!=(0);
 if ($10) {
  $422 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($422|0);
 }
 $11 = HEAP32[$0>>2]|0;
 $12 = ((($11)) + 24|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (_sqlite3BtreePager($13)|0);
 HEAP32[$pSrcPager>>2] = $14;
 $15 = HEAP32[$0>>2]|0;
 $16 = ((($15)) + 4|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = (_sqlite3BtreePager($17)|0);
 HEAP32[$pDestPager>>2] = $18;
 HEAP32[$nSrcPage>>2] = -1;
 HEAP32[$bCloseTrans>>2] = 0;
 $19 = HEAP32[$0>>2]|0;
 $20 = HEAP32[$19>>2]|0;
 $21 = ($20|0)!=(0|0);
 if ($21) {
  $22 = HEAP32[$0>>2]|0;
  $23 = ((($22)) + 24|0);
  $24 = HEAP32[$23>>2]|0;
  $25 = ((($24)) + 4|0);
  $26 = HEAP32[$25>>2]|0;
  $27 = ((($26)) + 20|0);
  $28 = HEAP8[$27>>0]|0;
  $29 = $28&255;
  $30 = ($29|0)==(2);
  if ($30) {
   HEAP32[$rc>>2] = 5;
  } else {
   label = 5;
  }
 } else {
  label = 5;
 }
 if ((label|0) == 5) {
  HEAP32[$rc>>2] = 0;
 }
 $31 = HEAP32[$rc>>2]|0;
 $32 = ($31|0)==(0);
 if ($32) {
  $33 = HEAP32[$0>>2]|0;
  $34 = ((($33)) + 24|0);
  $35 = HEAP32[$34>>2]|0;
  $36 = (_sqlite3BtreeIsInReadTrans($35)|0);
  $37 = (0)==($36|0);
  if ($37) {
   $38 = HEAP32[$0>>2]|0;
   $39 = ((($38)) + 24|0);
   $40 = HEAP32[$39>>2]|0;
   $41 = (_sqlite3BtreeBeginTrans($40,0)|0);
   HEAP32[$rc>>2] = $41;
   HEAP32[$bCloseTrans>>2] = 1;
  }
 }
 $42 = HEAP32[$0>>2]|0;
 $43 = ((($42)) + 12|0);
 $44 = HEAP32[$43>>2]|0;
 $45 = ($44|0)==(0);
 $46 = HEAP32[$rc>>2]|0;
 $47 = ($46|0)==(0);
 $or$cond = $45 & $47;
 if ($or$cond) {
  $48 = HEAP32[$0>>2]|0;
  $49 = (_setDestPgsz($48)|0);
  $50 = ($49|0)==(7);
  if ($50) {
   HEAP32[$rc>>2] = 7;
  }
 }
 $51 = HEAP32[$rc>>2]|0;
 $52 = (0)==($51|0);
 if ($52) {
  $53 = HEAP32[$0>>2]|0;
  $54 = ((($53)) + 12|0);
  $55 = HEAP32[$54>>2]|0;
  $56 = ($55|0)==(0);
  if ($56) {
   $57 = HEAP32[$0>>2]|0;
   $58 = ((($57)) + 4|0);
   $59 = HEAP32[$58>>2]|0;
   $60 = (_sqlite3BtreeBeginTrans($59,2)|0);
   HEAP32[$rc>>2] = $60;
   $61 = (0)==($60|0);
   if ($61) {
    $62 = HEAP32[$0>>2]|0;
    $63 = ((($62)) + 12|0);
    HEAP32[$63>>2] = 1;
    $64 = HEAP32[$0>>2]|0;
    $65 = ((($64)) + 4|0);
    $66 = HEAP32[$65>>2]|0;
    $67 = HEAP32[$0>>2]|0;
    $68 = ((($67)) + 8|0);
    _sqlite3BtreeGetMeta($66,1,$68);
   }
  }
 }
 $69 = HEAP32[$0>>2]|0;
 $70 = ((($69)) + 24|0);
 $71 = HEAP32[$70>>2]|0;
 $72 = (_sqlite3BtreeGetPageSize($71)|0);
 HEAP32[$pgszSrc>>2] = $72;
 $73 = HEAP32[$0>>2]|0;
 $74 = ((($73)) + 4|0);
 $75 = HEAP32[$74>>2]|0;
 $76 = (_sqlite3BtreeGetPageSize($75)|0);
 HEAP32[$pgszDest>>2] = $76;
 $77 = HEAP32[$0>>2]|0;
 $78 = ((($77)) + 4|0);
 $79 = HEAP32[$78>>2]|0;
 $80 = (_sqlite3BtreePager($79)|0);
 $81 = (_sqlite3PagerGetJournalMode($80)|0);
 HEAP32[$destMode>>2] = $81;
 $82 = HEAP32[$rc>>2]|0;
 $83 = (0)==($82|0);
 $84 = HEAP32[$destMode>>2]|0;
 $85 = ($84|0)==(5);
 $or$cond3 = $83 & $85;
 if ($or$cond3) {
  $86 = HEAP32[$pgszSrc>>2]|0;
  $87 = HEAP32[$pgszDest>>2]|0;
  $88 = ($86|0)!=($87|0);
  if ($88) {
   HEAP32[$rc>>2] = 8;
  }
 }
 $89 = HEAP32[$0>>2]|0;
 $90 = ((($89)) + 24|0);
 $91 = HEAP32[$90>>2]|0;
 $92 = (_sqlite3BtreeLastPage($91)|0);
 HEAP32[$nSrcPage>>2] = $92;
 HEAP32[$ii>>2] = 0;
 while(1) {
  $93 = HEAP32[$1>>2]|0;
  $94 = ($93|0)<(0);
  if (!($94)) {
   $95 = HEAP32[$ii>>2]|0;
   $96 = HEAP32[$1>>2]|0;
   $97 = ($95|0)<($96|0);
   if (!($97)) {
    break;
   }
  }
  $98 = HEAP32[$0>>2]|0;
  $99 = ((($98)) + 16|0);
  $100 = HEAP32[$99>>2]|0;
  $101 = HEAP32[$nSrcPage>>2]|0;
  $102 = ($100>>>0)<=($101>>>0);
  if (!($102)) {
   break;
  }
  $103 = HEAP32[$rc>>2]|0;
  $104 = ($103|0)!=(0);
  $105 = $104 ^ 1;
  if (!($105)) {
   break;
  }
  $106 = HEAP32[$0>>2]|0;
  $107 = ((($106)) + 16|0);
  $108 = HEAP32[$107>>2]|0;
  HEAP32[$iSrcPg>>2] = $108;
  $109 = HEAP32[$iSrcPg>>2]|0;
  $110 = HEAP32[1536>>2]|0;
  $111 = HEAP32[$0>>2]|0;
  $112 = ((($111)) + 24|0);
  $113 = HEAP32[$112>>2]|0;
  $114 = ((($113)) + 4|0);
  $115 = HEAP32[$114>>2]|0;
  $116 = ((($115)) + 32|0);
  $117 = HEAP32[$116>>2]|0;
  $118 = (($110>>>0) / ($117>>>0))&-1;
  $119 = (($118) + 1)|0;
  $120 = ($109|0)!=($119|0);
  if ($120) {
   $121 = HEAP32[$pSrcPager>>2]|0;
   $122 = HEAP32[$iSrcPg>>2]|0;
   $123 = (_sqlite3PagerGet($121,$122,$pSrcPg,2)|0);
   HEAP32[$rc>>2] = $123;
   $124 = HEAP32[$rc>>2]|0;
   $125 = ($124|0)==(0);
   if ($125) {
    $126 = HEAP32[$0>>2]|0;
    $127 = HEAP32[$iSrcPg>>2]|0;
    $128 = HEAP32[$pSrcPg>>2]|0;
    $129 = (_sqlite3PagerGetData($128)|0);
    $130 = (_backupOnePage($126,$127,$129,0)|0);
    HEAP32[$rc>>2] = $130;
    $131 = HEAP32[$pSrcPg>>2]|0;
    _sqlite3PagerUnref($131);
   }
  }
  $132 = HEAP32[$0>>2]|0;
  $133 = ((($132)) + 16|0);
  $134 = HEAP32[$133>>2]|0;
  $135 = (($134) + 1)|0;
  HEAP32[$133>>2] = $135;
  $136 = HEAP32[$ii>>2]|0;
  $137 = (($136) + 1)|0;
  HEAP32[$ii>>2] = $137;
 }
 $138 = HEAP32[$rc>>2]|0;
 $139 = ($138|0)==(0);
 do {
  if ($139) {
   $140 = HEAP32[$nSrcPage>>2]|0;
   $141 = HEAP32[$0>>2]|0;
   $142 = ((($141)) + 36|0);
   HEAP32[$142>>2] = $140;
   $143 = HEAP32[$nSrcPage>>2]|0;
   $144 = (($143) + 1)|0;
   $145 = HEAP32[$0>>2]|0;
   $146 = ((($145)) + 16|0);
   $147 = HEAP32[$146>>2]|0;
   $148 = (($144) - ($147))|0;
   $149 = HEAP32[$0>>2]|0;
   $150 = ((($149)) + 32|0);
   HEAP32[$150>>2] = $148;
   $151 = HEAP32[$0>>2]|0;
   $152 = ((($151)) + 16|0);
   $153 = HEAP32[$152>>2]|0;
   $154 = HEAP32[$nSrcPage>>2]|0;
   $155 = ($153>>>0)>($154>>>0);
   if ($155) {
    HEAP32[$rc>>2] = 101;
    break;
   }
   $156 = HEAP32[$0>>2]|0;
   $157 = ((($156)) + 40|0);
   $158 = HEAP32[$157>>2]|0;
   $159 = ($158|0)!=(0);
   if (!($159)) {
    $160 = HEAP32[$0>>2]|0;
    _attachBackupObject($160);
   }
  }
 } while(0);
 $161 = HEAP32[$rc>>2]|0;
 $162 = ($161|0)==(101);
 if ($162) {
  $163 = HEAP32[$nSrcPage>>2]|0;
  $164 = ($163|0)==(0);
  if ($164) {
   $165 = HEAP32[$0>>2]|0;
   $166 = ((($165)) + 4|0);
   $167 = HEAP32[$166>>2]|0;
   $168 = (_sqlite3BtreeNewDb($167)|0);
   HEAP32[$rc>>2] = $168;
   HEAP32[$nSrcPage>>2] = 1;
  }
  $169 = HEAP32[$rc>>2]|0;
  $170 = ($169|0)==(0);
  $171 = HEAP32[$rc>>2]|0;
  $172 = ($171|0)==(101);
  $or$cond6 = $170 | $172;
  if ($or$cond6) {
   $173 = HEAP32[$0>>2]|0;
   $174 = ((($173)) + 4|0);
   $175 = HEAP32[$174>>2]|0;
   $176 = HEAP32[$0>>2]|0;
   $177 = ((($176)) + 8|0);
   $178 = HEAP32[$177>>2]|0;
   $179 = (($178) + 1)|0;
   $180 = (_sqlite3BtreeUpdateMeta($175,1,$179)|0);
   HEAP32[$rc>>2] = $180;
  }
  $181 = HEAP32[$rc>>2]|0;
  $182 = ($181|0)==(0);
  if ($182) {
   $183 = HEAP32[$0>>2]|0;
   $184 = HEAP32[$183>>2]|0;
   $185 = ($184|0)!=(0|0);
   if ($185) {
    $186 = HEAP32[$0>>2]|0;
    $187 = HEAP32[$186>>2]|0;
    _sqlite3ResetAllSchemasOfConnection($187);
   }
   $188 = HEAP32[$destMode>>2]|0;
   $189 = ($188|0)==(5);
   if ($189) {
    $190 = HEAP32[$0>>2]|0;
    $191 = ((($190)) + 4|0);
    $192 = HEAP32[$191>>2]|0;
    $193 = (_sqlite3BtreeSetVersion($192,2)|0);
    HEAP32[$rc>>2] = $193;
   }
  }
  $194 = HEAP32[$rc>>2]|0;
  $195 = ($194|0)==(0);
  if ($195) {
   $196 = HEAP32[$pgszSrc>>2]|0;
   $197 = HEAP32[$pgszDest>>2]|0;
   $198 = ($196|0)<($197|0);
   if ($198) {
    $199 = HEAP32[$pgszDest>>2]|0;
    $200 = HEAP32[$pgszSrc>>2]|0;
    $201 = (($199|0) / ($200|0))&-1;
    HEAP32[$ratio>>2] = $201;
    $202 = HEAP32[$nSrcPage>>2]|0;
    $203 = HEAP32[$ratio>>2]|0;
    $204 = (($202) + ($203))|0;
    $205 = (($204) - 1)|0;
    $206 = HEAP32[$ratio>>2]|0;
    $207 = (($205|0) / ($206|0))&-1;
    HEAP32[$nDestTruncate>>2] = $207;
    $208 = HEAP32[$nDestTruncate>>2]|0;
    $209 = HEAP32[1536>>2]|0;
    $210 = HEAP32[$0>>2]|0;
    $211 = ((($210)) + 4|0);
    $212 = HEAP32[$211>>2]|0;
    $213 = ((($212)) + 4|0);
    $214 = HEAP32[$213>>2]|0;
    $215 = ((($214)) + 32|0);
    $216 = HEAP32[$215>>2]|0;
    $217 = (($209>>>0) / ($216>>>0))&-1;
    $218 = (($217) + 1)|0;
    $219 = ($208|0)==($218|0);
    if ($219) {
     $220 = HEAP32[$nDestTruncate>>2]|0;
     $221 = (($220) + -1)|0;
     HEAP32[$nDestTruncate>>2] = $221;
    }
   } else {
    $222 = HEAP32[$nSrcPage>>2]|0;
    $223 = HEAP32[$pgszSrc>>2]|0;
    $224 = HEAP32[$pgszDest>>2]|0;
    $225 = (($223|0) / ($224|0))&-1;
    $226 = Math_imul($222, $225)|0;
    HEAP32[$nDestTruncate>>2] = $226;
   }
   $227 = HEAP32[$pgszSrc>>2]|0;
   $228 = HEAP32[$pgszDest>>2]|0;
   $229 = ($227|0)<($228|0);
   if ($229) {
    $230 = HEAP32[$pgszSrc>>2]|0;
    $231 = ($230|0)<(0);
    $232 = $231 << 31 >> 31;
    $233 = HEAP32[$nSrcPage>>2]|0;
    $234 = ($233|0)<(0);
    $235 = $234 << 31 >> 31;
    $236 = (___muldi3(($230|0),($232|0),($233|0),($235|0))|0);
    $237 = tempRet0;
    $238 = $iSize;
    $239 = $238;
    HEAP32[$239>>2] = $236;
    $240 = (($238) + 4)|0;
    $241 = $240;
    HEAP32[$241>>2] = $237;
    $242 = HEAP32[$pDestPager>>2]|0;
    $243 = (_sqlite3PagerFile($242)|0);
    HEAP32[$pFile>>2] = $243;
    $244 = HEAP32[$pDestPager>>2]|0;
    _sqlite3PagerPagecount($244,$nDstPage);
    $245 = HEAP32[$nDestTruncate>>2]|0;
    HEAP32[$iPg>>2] = $245;
    while(1) {
     $246 = HEAP32[$rc>>2]|0;
     $247 = ($246|0)==(0);
     if (!($247)) {
      break;
     }
     $248 = HEAP32[$iPg>>2]|0;
     $249 = HEAP32[$nDstPage>>2]|0;
     $250 = ($248>>>0)<=($249>>>0);
     if (!($250)) {
      break;
     }
     $251 = HEAP32[$iPg>>2]|0;
     $252 = HEAP32[1536>>2]|0;
     $253 = HEAP32[$0>>2]|0;
     $254 = ((($253)) + 4|0);
     $255 = HEAP32[$254>>2]|0;
     $256 = ((($255)) + 4|0);
     $257 = HEAP32[$256>>2]|0;
     $258 = ((($257)) + 32|0);
     $259 = HEAP32[$258>>2]|0;
     $260 = (($252>>>0) / ($259>>>0))&-1;
     $261 = (($260) + 1)|0;
     $262 = ($251|0)!=($261|0);
     do {
      if ($262) {
       $263 = HEAP32[$pDestPager>>2]|0;
       $264 = HEAP32[$iPg>>2]|0;
       $265 = (_sqlite3PagerGet($263,$264,$pPg,0)|0);
       HEAP32[$rc>>2] = $265;
       $266 = HEAP32[$rc>>2]|0;
       $267 = ($266|0)==(0);
       if (!($267)) {
        break;
       }
       $268 = HEAP32[$pPg>>2]|0;
       $269 = (_sqlite3PagerWrite($268)|0);
       HEAP32[$rc>>2] = $269;
       $270 = HEAP32[$pPg>>2]|0;
       _sqlite3PagerUnref($270);
      }
     } while(0);
     $271 = HEAP32[$iPg>>2]|0;
     $272 = (($271) + 1)|0;
     HEAP32[$iPg>>2] = $272;
    }
    $273 = HEAP32[$rc>>2]|0;
    $274 = ($273|0)==(0);
    if ($274) {
     $275 = HEAP32[$pDestPager>>2]|0;
     $276 = (_sqlite3PagerCommitPhaseOne($275,0,1)|0);
     HEAP32[$rc>>2] = $276;
    }
    $277 = HEAP32[1536>>2]|0;
    $278 = HEAP32[$pgszDest>>2]|0;
    $279 = (($277) + ($278))|0;
    $280 = ($279|0)<(0);
    $281 = $280 << 31 >> 31;
    $282 = $iSize;
    $283 = $282;
    $284 = HEAP32[$283>>2]|0;
    $285 = (($282) + 4)|0;
    $286 = $285;
    $287 = HEAP32[$286>>2]|0;
    $288 = ($281|0)<($287|0);
    $289 = ($279>>>0)<($284>>>0);
    $290 = ($281|0)==($287|0);
    $291 = $290 & $289;
    $292 = $288 | $291;
    if ($292) {
     $293 = HEAP32[1536>>2]|0;
     $294 = HEAP32[$pgszDest>>2]|0;
     $295 = (($293) + ($294))|0;
     $296 = ($295|0)<(0);
     $297 = $296 << 31 >> 31;
     $306 = $295;$309 = $297;
    } else {
     $298 = $iSize;
     $299 = $298;
     $300 = HEAP32[$299>>2]|0;
     $301 = (($298) + 4)|0;
     $302 = $301;
     $303 = HEAP32[$302>>2]|0;
     $306 = $300;$309 = $303;
    }
    $304 = $iEnd;
    $305 = $304;
    HEAP32[$305>>2] = $306;
    $307 = (($304) + 4)|0;
    $308 = $307;
    HEAP32[$308>>2] = $309;
    $310 = HEAP32[1536>>2]|0;
    $311 = HEAP32[$pgszSrc>>2]|0;
    $312 = (($310) + ($311))|0;
    $313 = ($312|0)<(0);
    $314 = $313 << 31 >> 31;
    $315 = $iOff;
    $316 = $315;
    HEAP32[$316>>2] = $312;
    $317 = (($315) + 4)|0;
    $318 = $317;
    HEAP32[$318>>2] = $314;
    while(1) {
     $319 = HEAP32[$rc>>2]|0;
     $320 = ($319|0)==(0);
     if (!($320)) {
      break;
     }
     $321 = $iOff;
     $322 = $321;
     $323 = HEAP32[$322>>2]|0;
     $324 = (($321) + 4)|0;
     $325 = $324;
     $326 = HEAP32[$325>>2]|0;
     $327 = $iEnd;
     $328 = $327;
     $329 = HEAP32[$328>>2]|0;
     $330 = (($327) + 4)|0;
     $331 = $330;
     $332 = HEAP32[$331>>2]|0;
     $333 = ($326|0)<($332|0);
     $334 = ($323>>>0)<($329>>>0);
     $335 = ($326|0)==($332|0);
     $336 = $335 & $334;
     $337 = $333 | $336;
     if (!($337)) {
      break;
     }
     HEAP32[$pSrcPg1>>2] = 0;
     $338 = $iOff;
     $339 = $338;
     $340 = HEAP32[$339>>2]|0;
     $341 = (($338) + 4)|0;
     $342 = $341;
     $343 = HEAP32[$342>>2]|0;
     $344 = HEAP32[$pgszSrc>>2]|0;
     $345 = ($344|0)<(0);
     $346 = $345 << 31 >> 31;
     $347 = (___divdi3(($340|0),($343|0),($344|0),($346|0))|0);
     $348 = tempRet0;
     $349 = (_i64Add(($347|0),($348|0),1,0)|0);
     $350 = tempRet0;
     HEAP32[$iSrcPg2>>2] = $349;
     $351 = HEAP32[$pSrcPager>>2]|0;
     $352 = HEAP32[$iSrcPg2>>2]|0;
     $353 = (_sqlite3PagerGet($351,$352,$pSrcPg1,0)|0);
     HEAP32[$rc>>2] = $353;
     $354 = HEAP32[$rc>>2]|0;
     $355 = ($354|0)==(0);
     if ($355) {
      $356 = HEAP32[$pSrcPg1>>2]|0;
      $357 = (_sqlite3PagerGetData($356)|0);
      HEAP32[$zData>>2] = $357;
      $358 = HEAP32[$pFile>>2]|0;
      $359 = HEAP32[$zData>>2]|0;
      $360 = HEAP32[$pgszSrc>>2]|0;
      $361 = $iOff;
      $362 = $361;
      $363 = HEAP32[$362>>2]|0;
      $364 = (($361) + 4)|0;
      $365 = $364;
      $366 = HEAP32[$365>>2]|0;
      $367 = (_sqlite3OsWrite($358,$359,$360,$363,$366)|0);
      HEAP32[$rc>>2] = $367;
     }
     $368 = HEAP32[$pSrcPg1>>2]|0;
     _sqlite3PagerUnref($368);
     $369 = HEAP32[$pgszSrc>>2]|0;
     $370 = ($369|0)<(0);
     $371 = $370 << 31 >> 31;
     $372 = $iOff;
     $373 = $372;
     $374 = HEAP32[$373>>2]|0;
     $375 = (($372) + 4)|0;
     $376 = $375;
     $377 = HEAP32[$376>>2]|0;
     $378 = (_i64Add(($374|0),($377|0),($369|0),($371|0))|0);
     $379 = tempRet0;
     $380 = $iOff;
     $381 = $380;
     HEAP32[$381>>2] = $378;
     $382 = (($380) + 4)|0;
     $383 = $382;
     HEAP32[$383>>2] = $379;
    }
    $384 = HEAP32[$rc>>2]|0;
    $385 = ($384|0)==(0);
    if ($385) {
     $386 = HEAP32[$pFile>>2]|0;
     $387 = $iSize;
     $388 = $387;
     $389 = HEAP32[$388>>2]|0;
     $390 = (($387) + 4)|0;
     $391 = $390;
     $392 = HEAP32[$391>>2]|0;
     $393 = (_backupTruncateFile($386,$389,$392)|0);
     HEAP32[$rc>>2] = $393;
    }
    $394 = HEAP32[$rc>>2]|0;
    $395 = ($394|0)==(0);
    if ($395) {
     $396 = HEAP32[$pDestPager>>2]|0;
     $397 = (_sqlite3PagerSync($396,0)|0);
     HEAP32[$rc>>2] = $397;
    }
   } else {
    $398 = HEAP32[$pDestPager>>2]|0;
    $399 = HEAP32[$nDestTruncate>>2]|0;
    _sqlite3PagerTruncateImage($398,$399);
    $400 = HEAP32[$pDestPager>>2]|0;
    $401 = (_sqlite3PagerCommitPhaseOne($400,0,0)|0);
    HEAP32[$rc>>2] = $401;
   }
   $402 = HEAP32[$rc>>2]|0;
   $403 = (0)==($402|0);
   if ($403) {
    $404 = HEAP32[$0>>2]|0;
    $405 = ((($404)) + 4|0);
    $406 = HEAP32[$405>>2]|0;
    $407 = (_sqlite3BtreeCommitPhaseTwo($406,0)|0);
    HEAP32[$rc>>2] = $407;
    $408 = (0)==($407|0);
    $$ = $408 ? 101 : $407;
    HEAP32[$rc>>2] = $$;
   }
  }
 }
 $409 = HEAP32[$bCloseTrans>>2]|0;
 $410 = ($409|0)!=(0);
 if ($410) {
  $411 = HEAP32[$0>>2]|0;
  $412 = ((($411)) + 24|0);
  $413 = HEAP32[$412>>2]|0;
  (_sqlite3BtreeCommitPhaseOne($413,0)|0);
  $414 = HEAP32[$0>>2]|0;
  $415 = ((($414)) + 24|0);
  $416 = HEAP32[$415>>2]|0;
  (_sqlite3BtreeCommitPhaseTwo($416,0)|0);
 }
 $417 = HEAP32[$rc>>2]|0;
 $418 = ($417|0)==(3082);
 if ($418) {
  HEAP32[$rc>>2] = 7;
 }
 $419 = HEAP32[$rc>>2]|0;
 $420 = HEAP32[$0>>2]|0;
 $421 = ((($420)) + 28|0);
 HEAP32[$421>>2] = $419;
 $422 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($422|0);
}
function _sqlite3_backup_finish($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $7 = 0, $8 = 0, $9 = 0, $pSrcDb = 0, $pp = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $pp = sp + 8|0;
 $pSrcDb = sp + 4|0;
 $rc = sp;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  HEAP32[$0>>2] = 0;
  $64 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($64|0);
 }
 $4 = HEAP32[$1>>2]|0;
 $5 = ((($4)) + 20|0);
 $6 = HEAP32[$5>>2]|0;
 HEAP32[$pSrcDb>>2] = $6;
 $7 = HEAP32[$1>>2]|0;
 $8 = ((($7)) + 24|0);
 $9 = HEAP32[$8>>2]|0;
 _sqlite3BtreeEnter($9);
 $10 = HEAP32[$1>>2]|0;
 $11 = HEAP32[$10>>2]|0;
 $12 = ($11|0)!=(0|0);
 if ($12) {
  $13 = HEAP32[$1>>2]|0;
  $14 = ((($13)) + 24|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = ((($15)) + 16|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (($17) + -1)|0;
  HEAP32[$16>>2] = $18;
 }
 $19 = HEAP32[$1>>2]|0;
 $20 = ((($19)) + 40|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = ($21|0)!=(0);
 if ($22) {
  $23 = HEAP32[$1>>2]|0;
  $24 = ((($23)) + 24|0);
  $25 = HEAP32[$24>>2]|0;
  $26 = (_sqlite3BtreePager($25)|0);
  $27 = (_sqlite3PagerBackupPtr($26)|0);
  HEAP32[$pp>>2] = $27;
  while(1) {
   $28 = HEAP32[$pp>>2]|0;
   $29 = HEAP32[$28>>2]|0;
   $30 = HEAP32[$1>>2]|0;
   $31 = ($29|0)!=($30|0);
   if (!($31)) {
    break;
   }
   $32 = HEAP32[$pp>>2]|0;
   $33 = HEAP32[$32>>2]|0;
   $34 = ((($33)) + 44|0);
   HEAP32[$pp>>2] = $34;
  }
  $35 = HEAP32[$1>>2]|0;
  $36 = ((($35)) + 44|0);
  $37 = HEAP32[$36>>2]|0;
  $38 = HEAP32[$pp>>2]|0;
  HEAP32[$38>>2] = $37;
 }
 $39 = HEAP32[$1>>2]|0;
 $40 = ((($39)) + 4|0);
 $41 = HEAP32[$40>>2]|0;
 (_sqlite3BtreeRollback($41,0,0)|0);
 $42 = HEAP32[$1>>2]|0;
 $43 = ((($42)) + 28|0);
 $44 = HEAP32[$43>>2]|0;
 $45 = ($44|0)==(101);
 if ($45) {
  $49 = 0;
 } else {
  $46 = HEAP32[$1>>2]|0;
  $47 = ((($46)) + 28|0);
  $48 = HEAP32[$47>>2]|0;
  $49 = $48;
 }
 HEAP32[$rc>>2] = $49;
 $50 = HEAP32[$1>>2]|0;
 $51 = HEAP32[$50>>2]|0;
 $52 = ($51|0)!=(0|0);
 if ($52) {
  $53 = HEAP32[$1>>2]|0;
  $54 = HEAP32[$53>>2]|0;
  $55 = HEAP32[$rc>>2]|0;
  _sqlite3Error($54,$55);
  $56 = HEAP32[$1>>2]|0;
  $57 = HEAP32[$56>>2]|0;
  _sqlite3LeaveMutexAndCloseZombie($57);
 }
 $58 = HEAP32[$1>>2]|0;
 $59 = HEAP32[$58>>2]|0;
 $60 = ($59|0)!=(0|0);
 if ($60) {
  $61 = HEAP32[$1>>2]|0;
  _sqlite3_free($61);
 }
 $62 = HEAP32[$pSrcDb>>2]|0;
 _sqlite3LeaveMutexAndCloseZombie($62);
 $63 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $63;
 $64 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($64|0);
}
function _sqlite3_finalize($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $db = 0, $rc = 0, $v = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $rc = sp + 8|0;
 $v = sp + 4|0;
 $db = sp;
 HEAP32[$1>>2] = $pStmt;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  HEAP32[$rc>>2] = 0;
 } else {
  $4 = HEAP32[$1>>2]|0;
  HEAP32[$v>>2] = $4;
  $5 = HEAP32[$v>>2]|0;
  $6 = HEAP32[$5>>2]|0;
  HEAP32[$db>>2] = $6;
  $7 = HEAP32[$v>>2]|0;
  $8 = (_vdbeSafety($7)|0);
  $9 = ($8|0)!=(0);
  if ($9) {
   $10 = (_sqlite3MisuseError(75223)|0);
   HEAP32[$0>>2] = $10;
   $33 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($33|0);
  }
  $11 = HEAP32[$v>>2]|0;
  $12 = ((($11)) + 128|0);
  $13 = $12;
  $14 = $13;
  $15 = HEAP32[$14>>2]|0;
  $16 = (($13) + 4)|0;
  $17 = $16;
  $18 = HEAP32[$17>>2]|0;
  $19 = ($18|0)>(0);
  $20 = ($15>>>0)>(0);
  $21 = ($18|0)==(0);
  $22 = $21 & $20;
  $23 = $19 | $22;
  if ($23) {
   $24 = HEAP32[$db>>2]|0;
   $25 = HEAP32[$v>>2]|0;
   _invokeProfileCallback($24,$25);
  }
  $26 = HEAP32[$v>>2]|0;
  $27 = (_sqlite3VdbeFinalize($26)|0);
  HEAP32[$rc>>2] = $27;
  $28 = HEAP32[$db>>2]|0;
  $29 = HEAP32[$rc>>2]|0;
  $30 = (_sqlite3ApiExit($28,$29)|0);
  HEAP32[$rc>>2] = $30;
  $31 = HEAP32[$db>>2]|0;
  _sqlite3LeaveMutexAndCloseZombie($31);
 }
 $32 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $32;
 $33 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($33|0);
}
function _sqlite3_reset($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $db = 0, $rc = 0, $v = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $rc = sp + 8|0;
 $v = sp + 4|0;
 $db = sp;
 HEAP32[$0>>2] = $pStmt;
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  HEAP32[$rc>>2] = 0;
  $27 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($27|0);
 }
 $3 = HEAP32[$0>>2]|0;
 HEAP32[$v>>2] = $3;
 $4 = HEAP32[$v>>2]|0;
 $5 = HEAP32[$4>>2]|0;
 HEAP32[$db>>2] = $5;
 $6 = HEAP32[$v>>2]|0;
 $7 = ((($6)) + 128|0);
 $8 = $7;
 $9 = $8;
 $10 = HEAP32[$9>>2]|0;
 $11 = (($8) + 4)|0;
 $12 = $11;
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13|0)>(0);
 $15 = ($10>>>0)>(0);
 $16 = ($13|0)==(0);
 $17 = $16 & $15;
 $18 = $14 | $17;
 if ($18) {
  $19 = HEAP32[$db>>2]|0;
  $20 = HEAP32[$v>>2]|0;
  _invokeProfileCallback($19,$20);
 }
 $21 = HEAP32[$v>>2]|0;
 $22 = (_sqlite3VdbeReset($21)|0);
 HEAP32[$rc>>2] = $22;
 $23 = HEAP32[$v>>2]|0;
 _sqlite3VdbeRewind($23);
 $24 = HEAP32[$db>>2]|0;
 $25 = HEAP32[$rc>>2]|0;
 $26 = (_sqlite3ApiExit($24,$25)|0);
 HEAP32[$rc>>2] = $26;
 $27 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($27|0);
}
function _sqlite3_clear_bindings($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $p = 0;
 var $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $i = sp + 8|0;
 $rc = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$rc>>2] = 0;
 $1 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $1;
 HEAP32[$i>>2] = 0;
 while(1) {
  $2 = HEAP32[$i>>2]|0;
  $3 = HEAP32[$p>>2]|0;
  $4 = ((($3)) + 16|0);
  $5 = HEAP16[$4>>1]|0;
  $6 = $5 << 16 >> 16;
  $7 = ($2|0)<($6|0);
  if (!($7)) {
   break;
  }
  $8 = HEAP32[$i>>2]|0;
  $9 = HEAP32[$p>>2]|0;
  $10 = ((($9)) + 116|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = (($11) + (($8*40)|0)|0);
  _sqlite3VdbeMemRelease($12);
  $13 = HEAP32[$i>>2]|0;
  $14 = HEAP32[$p>>2]|0;
  $15 = ((($14)) + 116|0);
  $16 = HEAP32[$15>>2]|0;
  $17 = (($16) + (($13*40)|0)|0);
  $18 = ((($17)) + 8|0);
  HEAP16[$18>>1] = 1;
  $19 = HEAP32[$i>>2]|0;
  $20 = (($19) + 1)|0;
  HEAP32[$i>>2] = $20;
 }
 $21 = HEAP32[$p>>2]|0;
 $22 = ((($21)) + 144|0);
 $23 = HEAP16[$22>>1]|0;
 $24 = ($23&65535) >>> 9;
 $25 = $24 & 1;
 $26 = $25&65535;
 $27 = ($26|0)!=(0);
 if (!($27)) {
  $37 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 $28 = HEAP32[$p>>2]|0;
 $29 = ((($28)) + 196|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = ($30|0)!=(0);
 if (!($31)) {
  $37 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 $32 = HEAP32[$p>>2]|0;
 $33 = ((($32)) + 144|0);
 $34 = HEAP16[$33>>1]|0;
 $35 = $34 & -2;
 $36 = $35 | 1;
 HEAP16[$33>>1] = $36;
 $37 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($37|0);
}
function _sqlite3_value_blob($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $p = sp;
 HEAP32[$1>>2] = $pVal;
 $2 = HEAP32[$1>>2]|0;
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP16[$4>>1]|0;
 $6 = $5&65535;
 $7 = $6 & 18;
 $8 = ($7|0)!=(0);
 if (!($8)) {
  $33 = HEAP32[$1>>2]|0;
  $34 = (_sqlite3_value_text($33)|0);
  HEAP32[$0>>2] = $34;
  $35 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 $9 = HEAP32[$p>>2]|0;
 $10 = ((($9)) + 8|0);
 $11 = HEAP16[$10>>1]|0;
 $12 = $11&65535;
 $13 = $12 & 16384;
 $14 = ($13|0)!=(0);
 if ($14) {
  $15 = HEAP32[$p>>2]|0;
  $16 = (_sqlite3VdbeMemExpandBlob($15)|0);
  $18 = $16;
 } else {
  $18 = 0;
 }
 $17 = ($18|0)!=(0);
 if ($17) {
  HEAP32[$0>>2] = 0;
  $35 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 $19 = HEAP32[$p>>2]|0;
 $20 = ((($19)) + 8|0);
 $21 = HEAP16[$20>>1]|0;
 $22 = $21&65535;
 $23 = $22 | 16;
 $24 = $23&65535;
 HEAP16[$20>>1] = $24;
 $25 = HEAP32[$p>>2]|0;
 $26 = ((($25)) + 12|0);
 $27 = HEAP32[$26>>2]|0;
 $28 = ($27|0)!=(0);
 if ($28) {
  $29 = HEAP32[$p>>2]|0;
  $30 = ((($29)) + 16|0);
  $31 = HEAP32[$30>>2]|0;
  $32 = $31;
 } else {
  $32 = 0;
 }
 HEAP32[$0>>2] = $32;
 $35 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($35|0);
}
function _sqlite3_value_text($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pVal;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3ValueText($1,1)|0);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3_value_bytes($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pVal;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3ValueBytes($1,1)|0);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3_value_double($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $2 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pVal;
 $1 = HEAP32[$0>>2]|0;
 $2 = (+_sqlite3VdbeRealValue($1));
 STACKTOP = sp;return (+$2);
}
function _sqlite3_value_int($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pVal;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3VdbeIntValue($1)|0);
 $3 = tempRet0;
 STACKTOP = sp;return ($2|0);
}
function _sqlite3_value_int64($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pVal;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3VdbeIntValue($1)|0);
 $3 = tempRet0;
 tempRet0 = ($3);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3_value_type($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pVal;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 8|0);
 $3 = HEAP16[$2>>1]|0;
 $4 = $3&65535;
 $5 = $4 & 31;
 $6 = (18138 + ($5)|0);
 $7 = HEAP8[$6>>0]|0;
 $8 = $7&255;
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_result_blob($pCtx,$z,$n,$xDel) {
 $pCtx = $pCtx|0;
 $z = $z|0;
 $n = $n|0;
 $xDel = $xDel|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $3 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAP32[$1>>2] = $z;
 HEAP32[$2>>2] = $n;
 HEAP32[$3>>2] = $xDel;
 $4 = HEAP32[$0>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = HEAP32[$2>>2]|0;
 $7 = HEAP32[$3>>2]|0;
 _setResultStrOrError($4,$5,$6,0,$7);
 STACKTOP = sp;return;
}
function _sqlite3_result_blob64($pCtx,$z,$0,$1,$xDel) {
 $pCtx = $pCtx|0;
 $z = $z|0;
 $0 = $0|0;
 $1 = $1|0;
 $xDel = $xDel|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 16|0;
 $3 = sp + 12|0;
 $4 = sp;
 $5 = sp + 8|0;
 HEAP32[$2>>2] = $pCtx;
 HEAP32[$3>>2] = $z;
 $6 = $4;
 $7 = $6;
 HEAP32[$7>>2] = $0;
 $8 = (($6) + 4)|0;
 $9 = $8;
 HEAP32[$9>>2] = $1;
 HEAP32[$5>>2] = $xDel;
 $10 = $4;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (($10) + 4)|0;
 $14 = $13;
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15>>>0)>(0);
 $17 = ($12>>>0)>(2147483647);
 $18 = ($15|0)==(0);
 $19 = $18 & $17;
 $20 = $16 | $19;
 if ($20) {
  $21 = HEAP32[$3>>2]|0;
  $22 = HEAP32[$5>>2]|0;
  $23 = HEAP32[$2>>2]|0;
  (_invokeValueDestructor($21,$22,$23)|0);
  STACKTOP = sp;return;
 } else {
  $24 = HEAP32[$2>>2]|0;
  $25 = HEAP32[$3>>2]|0;
  $26 = $4;
  $27 = $26;
  $28 = HEAP32[$27>>2]|0;
  $29 = (($26) + 4)|0;
  $30 = $29;
  $31 = HEAP32[$30>>2]|0;
  $32 = HEAP32[$5>>2]|0;
  _setResultStrOrError($24,$25,$28,0,$32);
  STACKTOP = sp;return;
 }
}
function _sqlite3_result_double($pCtx,$rVal) {
 $pCtx = $pCtx|0;
 $rVal = +$rVal;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAPF64[$1>>3] = $rVal;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 $4 = +HEAPF64[$1>>3];
 _sqlite3VdbeMemSetDouble($3,$4);
 STACKTOP = sp;return;
}
function _sqlite3_result_error($pCtx,$z,$n) {
 $pCtx = $pCtx|0;
 $z = $z|0;
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAP32[$1>>2] = $z;
 HEAP32[$2>>2] = $n;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 20|0);
 HEAP32[$4>>2] = 1;
 $5 = HEAP32[$0>>2]|0;
 $6 = ((($5)) + 25|0);
 HEAP8[$6>>0] = 1;
 $7 = HEAP32[$0>>2]|0;
 $8 = HEAP32[$7>>2]|0;
 $9 = HEAP32[$1>>2]|0;
 $10 = HEAP32[$2>>2]|0;
 (_sqlite3VdbeMemSetStr($8,$9,$10,1,(-1))|0);
 STACKTOP = sp;return;
}
function _sqlite3_result_int($pCtx,$iVal) {
 $pCtx = $pCtx|0;
 $iVal = $iVal|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAP32[$1>>2] = $iVal;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = ($4|0)<(0);
 $6 = $5 << 31 >> 31;
 _sqlite3VdbeMemSetInt64($3,$4,$6);
 STACKTOP = sp;return;
}
function _sqlite3_result_int64($pCtx,$0,$1) {
 $pCtx = $pCtx|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $2 = sp + 8|0;
 $3 = sp;
 HEAP32[$2>>2] = $pCtx;
 $4 = $3;
 $5 = $4;
 HEAP32[$5>>2] = $0;
 $6 = (($4) + 4)|0;
 $7 = $6;
 HEAP32[$7>>2] = $1;
 $8 = HEAP32[$2>>2]|0;
 $9 = HEAP32[$8>>2]|0;
 $10 = $3;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (($10) + 4)|0;
 $14 = $13;
 $15 = HEAP32[$14>>2]|0;
 _sqlite3VdbeMemSetInt64($9,$12,$15);
 STACKTOP = sp;return;
}
function _sqlite3_result_null($pCtx) {
 $pCtx = $pCtx|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pCtx;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$1>>2]|0;
 _sqlite3VdbeMemSetNull($2);
 STACKTOP = sp;return;
}
function _sqlite3_result_text($pCtx,$z,$n,$xDel) {
 $pCtx = $pCtx|0;
 $z = $z|0;
 $n = $n|0;
 $xDel = $xDel|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $3 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAP32[$1>>2] = $z;
 HEAP32[$2>>2] = $n;
 HEAP32[$3>>2] = $xDel;
 $4 = HEAP32[$0>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = HEAP32[$2>>2]|0;
 $7 = HEAP32[$3>>2]|0;
 _setResultStrOrError($4,$5,$6,1,$7);
 STACKTOP = sp;return;
}
function _sqlite3_result_text64($pCtx,$z,$0,$1,$xDel,$enc) {
 $pCtx = $pCtx|0;
 $z = $z|0;
 $0 = $0|0;
 $1 = $1|0;
 $xDel = $xDel|0;
 $enc = $enc|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 16|0;
 $3 = sp + 12|0;
 $4 = sp;
 $5 = sp + 8|0;
 $6 = sp + 20|0;
 HEAP32[$2>>2] = $pCtx;
 HEAP32[$3>>2] = $z;
 $7 = $4;
 $8 = $7;
 HEAP32[$8>>2] = $0;
 $9 = (($7) + 4)|0;
 $10 = $9;
 HEAP32[$10>>2] = $1;
 HEAP32[$5>>2] = $xDel;
 HEAP8[$6>>0] = $enc;
 $11 = HEAP8[$6>>0]|0;
 $12 = $11&255;
 $13 = ($12|0)==(4);
 if ($13) {
  $14 = HEAP8[968>>0]|0;
  $15 = $14 << 24 >> 24;
  $16 = ($15|0)==(0);
  $17 = $16 ? 3 : 2;
  $18 = $17&255;
  HEAP8[$6>>0] = $18;
 }
 $19 = $4;
 $20 = $19;
 $21 = HEAP32[$20>>2]|0;
 $22 = (($19) + 4)|0;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 $25 = ($24>>>0)>(0);
 $26 = ($21>>>0)>(2147483647);
 $27 = ($24|0)==(0);
 $28 = $27 & $26;
 $29 = $25 | $28;
 if ($29) {
  $30 = HEAP32[$3>>2]|0;
  $31 = HEAP32[$5>>2]|0;
  $32 = HEAP32[$2>>2]|0;
  (_invokeValueDestructor($30,$31,$32)|0);
  STACKTOP = sp;return;
 } else {
  $33 = HEAP32[$2>>2]|0;
  $34 = HEAP32[$3>>2]|0;
  $35 = $4;
  $36 = $35;
  $37 = HEAP32[$36>>2]|0;
  $38 = (($35) + 4)|0;
  $39 = $38;
  $40 = HEAP32[$39>>2]|0;
  $41 = HEAP8[$6>>0]|0;
  $42 = HEAP32[$5>>2]|0;
  _setResultStrOrError($33,$34,$37,$41,$42);
  STACKTOP = sp;return;
 }
}
function _sqlite3_result_value($pCtx,$pValue) {
 $pCtx = $pCtx|0;
 $pValue = $pValue|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAP32[$1>>2] = $pValue;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 (_sqlite3VdbeMemCopy($3,$4)|0);
 STACKTOP = sp;return;
}
function _sqlite3_result_zeroblob64($pCtx,$0,$1) {
 $pCtx = $pCtx|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pOut = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 16|0;
 $3 = sp + 12|0;
 $4 = sp;
 $pOut = sp + 8|0;
 HEAP32[$3>>2] = $pCtx;
 $5 = $4;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 $9 = HEAP32[$3>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 HEAP32[$pOut>>2] = $10;
 $11 = $4;
 $12 = $11;
 $13 = HEAP32[$12>>2]|0;
 $14 = (($11) + 4)|0;
 $15 = $14;
 $16 = HEAP32[$15>>2]|0;
 $17 = HEAP32[$pOut>>2]|0;
 $18 = ((($17)) + 32|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ((($19)) + 96|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = ($21|0)<(0);
 $23 = $22 << 31 >> 31;
 $24 = ($16>>>0)>($23>>>0);
 $25 = ($13>>>0)>($21>>>0);
 $26 = ($16|0)==($23|0);
 $27 = $26 & $25;
 $28 = $24 | $27;
 if ($28) {
  HEAP32[$2>>2] = 18;
  $37 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($37|0);
 } else {
  $29 = HEAP32[$3>>2]|0;
  $30 = HEAP32[$29>>2]|0;
  $31 = $4;
  $32 = $31;
  $33 = HEAP32[$32>>2]|0;
  $34 = (($31) + 4)|0;
  $35 = $34;
  $36 = HEAP32[$35>>2]|0;
  _sqlite3VdbeMemSetZeroBlob($30,$33);
  HEAP32[$2>>2] = 0;
  $37 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 return (0)|0;
}
function _sqlite3_result_error_code($pCtx,$errCode) {
 $pCtx = $pCtx|0;
 $errCode = $errCode|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAP32[$1>>2] = $errCode;
 $2 = HEAP32[$1>>2]|0;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 20|0);
 HEAP32[$4>>2] = $2;
 $5 = HEAP32[$0>>2]|0;
 $6 = ((($5)) + 25|0);
 HEAP8[$6>>0] = 1;
 $7 = HEAP32[$0>>2]|0;
 $8 = HEAP32[$7>>2]|0;
 $9 = ((($8)) + 8|0);
 $10 = HEAP16[$9>>1]|0;
 $11 = $10&65535;
 $12 = $11 & 1;
 $13 = ($12|0)!=(0);
 if (!($13)) {
  STACKTOP = sp;return;
 }
 $14 = HEAP32[$0>>2]|0;
 $15 = HEAP32[$14>>2]|0;
 $16 = HEAP32[$1>>2]|0;
 $17 = (_sqlite3ErrStr($16)|0);
 (_sqlite3VdbeMemSetStr($15,$17,-1,1,0)|0);
 STACKTOP = sp;return;
}
function _sqlite3_result_error_toobig($pCtx) {
 $pCtx = $pCtx|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pCtx;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 20|0);
 HEAP32[$2>>2] = 18;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 25|0);
 HEAP8[$4>>0] = 1;
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 (_sqlite3VdbeMemSetStr($6,18170,-1,1,0)|0);
 STACKTOP = sp;return;
}
function _sqlite3_result_error_nomem($pCtx) {
 $pCtx = $pCtx|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pCtx;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$1>>2]|0;
 _sqlite3VdbeMemSetNull($2);
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 20|0);
 HEAP32[$4>>2] = 7;
 $5 = HEAP32[$0>>2]|0;
 $6 = ((($5)) + 25|0);
 HEAP8[$6>>0] = 1;
 $7 = HEAP32[$0>>2]|0;
 $8 = HEAP32[$7>>2]|0;
 $9 = ((($8)) + 32|0);
 $10 = HEAP32[$9>>2]|0;
 _sqlite3OomFault($10);
 STACKTOP = sp;return;
}
function _sqlite3_step($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $7 = 0, $8 = 0, $9 = 0, $cnt = 0, $db = 0, $rc = 0, $rc2 = 0, $savedPc = 0, $v = 0, $zErr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $rc = sp + 24|0;
 $rc2 = sp + 20|0;
 $v = sp + 16|0;
 $cnt = sp + 12|0;
 $db = sp + 8|0;
 $savedPc = sp + 4|0;
 $zErr = sp;
 HEAP32[$1>>2] = $pStmt;
 HEAP32[$rc>>2] = 0;
 HEAP32[$rc2>>2] = 0;
 $2 = HEAP32[$1>>2]|0;
 HEAP32[$v>>2] = $2;
 HEAP32[$cnt>>2] = 0;
 $3 = HEAP32[$v>>2]|0;
 $4 = (_vdbeSafetyNotNull($3)|0);
 $5 = ($4|0)!=(0);
 if ($5) {
  $6 = (_sqlite3MisuseError(75775)|0);
  HEAP32[$0>>2] = $6;
  $64 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($64|0);
 }
 $7 = HEAP32[$v>>2]|0;
 $8 = HEAP32[$7>>2]|0;
 HEAP32[$db>>2] = $8;
 $9 = HEAP32[$v>>2]|0;
 $10 = ((($9)) + 144|0);
 $11 = HEAP16[$10>>1]|0;
 $12 = $11 & -3;
 HEAP16[$10>>1] = $12;
 while(1) {
  $13 = HEAP32[$v>>2]|0;
  $14 = (_sqlite3Step($13)|0);
  HEAP32[$rc>>2] = $14;
  $15 = ($14|0)==(17);
  if (!($15)) {
   break;
  }
  $16 = HEAP32[$cnt>>2]|0;
  $17 = (($16) + 1)|0;
  HEAP32[$cnt>>2] = $17;
  $18 = ($16|0)<(50);
  if (!($18)) {
   break;
  }
  $19 = HEAP32[$v>>2]|0;
  $20 = ((($19)) + 36|0);
  $21 = HEAP32[$20>>2]|0;
  HEAP32[$savedPc>>2] = $21;
  $22 = HEAP32[$v>>2]|0;
  $23 = (_sqlite3Reprepare($22)|0);
  HEAP32[$rc>>2] = $23;
  HEAP32[$rc2>>2] = $23;
  $24 = HEAP32[$rc>>2]|0;
  $25 = ($24|0)!=(0);
  if ($25) {
   break;
  }
  $26 = HEAP32[$1>>2]|0;
  (_sqlite3_reset($26)|0);
  $27 = HEAP32[$savedPc>>2]|0;
  $28 = ($27|0)>=(0);
  if (!($28)) {
   continue;
  }
  $29 = HEAP32[$v>>2]|0;
  $30 = ((($29)) + 144|0);
  $31 = HEAP16[$30>>1]|0;
  $32 = $31 & -3;
  $33 = $32 | 2;
  HEAP16[$30>>1] = $33;
 }
 $34 = HEAP32[$rc2>>2]|0;
 $35 = ($34|0)!=(0);
 do {
  if ($35) {
   $36 = HEAP32[$db>>2]|0;
   $37 = ((($36)) + 244|0);
   $38 = HEAP32[$37>>2]|0;
   $39 = (_sqlite3_value_text($38)|0);
   HEAP32[$zErr>>2] = $39;
   $40 = HEAP32[$db>>2]|0;
   $41 = HEAP32[$v>>2]|0;
   $42 = ((($41)) + 108|0);
   $43 = HEAP32[$42>>2]|0;
   _sqlite3DbFree($40,$43);
   $44 = HEAP32[$db>>2]|0;
   $45 = ((($44)) + 69|0);
   $46 = HEAP8[$45>>0]|0;
   $47 = ($46<<24>>24)!=(0);
   if ($47) {
    $56 = HEAP32[$v>>2]|0;
    $57 = ((($56)) + 108|0);
    HEAP32[$57>>2] = 0;
    HEAP32[$rc>>2] = 7;
    $58 = HEAP32[$v>>2]|0;
    $59 = ((($58)) + 40|0);
    HEAP32[$59>>2] = 7;
    break;
   } else {
    $48 = HEAP32[$db>>2]|0;
    $49 = HEAP32[$zErr>>2]|0;
    $50 = (_sqlite3DbStrDup($48,$49)|0);
    $51 = HEAP32[$v>>2]|0;
    $52 = ((($51)) + 108|0);
    HEAP32[$52>>2] = $50;
    $53 = HEAP32[$rc2>>2]|0;
    $54 = HEAP32[$v>>2]|0;
    $55 = ((($54)) + 40|0);
    HEAP32[$55>>2] = $53;
    break;
   }
  }
 } while(0);
 $60 = HEAP32[$db>>2]|0;
 $61 = HEAP32[$rc>>2]|0;
 $62 = (_sqlite3ApiExit($60,$61)|0);
 HEAP32[$rc>>2] = $62;
 $63 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $63;
 $64 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($64|0);
}
function _sqlite3_user_data($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 STACKTOP = sp;return ($5|0);
}
function _sqlite3_context_db_handle($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 32|0);
 $4 = HEAP32[$3>>2]|0;
 STACKTOP = sp;return ($4|0);
}
function _sqlite3_aggregate_context($p,$nByte) {
 $p = $p|0;
 $nByte = $nByte|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$1>>2] = $p;
 HEAP32[$2>>2] = $nByte;
 $3 = HEAP32[$1>>2]|0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($5)) + 8|0);
 $7 = HEAP16[$6>>1]|0;
 $8 = $7&65535;
 $9 = $8 & 8192;
 $10 = ($9|0)==(0);
 $11 = HEAP32[$1>>2]|0;
 if ($10) {
  $12 = HEAP32[$2>>2]|0;
  $13 = (_createAggContext($11,$12)|0);
  HEAP32[$0>>2] = $13;
  $18 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($18|0);
 } else {
  $14 = ((($11)) + 8|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = ((($15)) + 16|0);
  $17 = HEAP32[$16>>2]|0;
  HEAP32[$0>>2] = $17;
  $18 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($18|0);
 }
 return (0)|0;
}
function _sqlite3_column_count($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $pVm = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $pVm = sp;
 HEAP32[$0>>2] = $pStmt;
 $1 = HEAP32[$0>>2]|0;
 HEAP32[$pVm>>2] = $1;
 $2 = HEAP32[$pVm>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  $8 = 0;
  STACKTOP = sp;return ($8|0);
 }
 $4 = HEAP32[$pVm>>2]|0;
 $5 = ((($4)) + 140|0);
 $6 = HEAP16[$5>>1]|0;
 $7 = $6&65535;
 $8 = $7;
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_data_count($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pVm = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $pVm = sp;
 HEAP32[$1>>2] = $pStmt;
 $2 = HEAP32[$1>>2]|0;
 HEAP32[$pVm>>2] = $2;
 $3 = HEAP32[$pVm>>2]|0;
 $4 = ($3|0)==(0|0);
 if (!($4)) {
  $5 = HEAP32[$pVm>>2]|0;
  $6 = ((($5)) + 104|0);
  $7 = HEAP32[$6>>2]|0;
  $8 = ($7|0)==(0|0);
  if (!($8)) {
   $9 = HEAP32[$pVm>>2]|0;
   $10 = ((($9)) + 140|0);
   $11 = HEAP16[$10>>1]|0;
   $12 = $11&65535;
   HEAP32[$0>>2] = $12;
   $13 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($13|0);
  }
 }
 HEAP32[$0>>2] = 0;
 $13 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($13|0);
}
function _sqlite3_column_blob($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $val = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 $5 = (_sqlite3_value_blob($4)|0);
 HEAP32[$val>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _columnMallocFailure($6);
 $7 = HEAP32[$val>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3_column_bytes($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $val = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 $5 = (_sqlite3_value_bytes($4)|0);
 HEAP32[$val>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _columnMallocFailure($6);
 $7 = HEAP32[$val>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3_column_double($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0.0, $6 = 0, $7 = 0.0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 $5 = (+_sqlite3_value_double($4));
 HEAPF64[$val>>3] = $5;
 $6 = HEAP32[$0>>2]|0;
 _columnMallocFailure($6);
 $7 = +HEAPF64[$val>>3];
 STACKTOP = sp;return (+$7);
}
function _sqlite3_column_int($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $val = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 $5 = (_sqlite3_value_int($4)|0);
 HEAP32[$val>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _columnMallocFailure($6);
 $7 = HEAP32[$val>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3_column_int64($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $val = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $val = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 $5 = (_sqlite3_value_int64($4)|0);
 $6 = tempRet0;
 $7 = $val;
 $8 = $7;
 HEAP32[$8>>2] = $5;
 $9 = (($7) + 4)|0;
 $10 = $9;
 HEAP32[$10>>2] = $6;
 $11 = HEAP32[$0>>2]|0;
 _columnMallocFailure($11);
 $12 = $val;
 $13 = $12;
 $14 = HEAP32[$13>>2]|0;
 $15 = (($12) + 4)|0;
 $16 = $15;
 $17 = HEAP32[$16>>2]|0;
 tempRet0 = ($17);
 STACKTOP = sp;return ($14|0);
}
function _sqlite3_column_text($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $val = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $val = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 $5 = (_sqlite3_value_text($4)|0);
 HEAP32[$val>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _columnMallocFailure($6);
 $7 = HEAP32[$val>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3_column_value($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pOut = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $pOut = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 HEAP32[$pOut>>2] = $4;
 $5 = HEAP32[$pOut>>2]|0;
 $6 = ((($5)) + 8|0);
 $7 = HEAP16[$6>>1]|0;
 $8 = $7&65535;
 $9 = $8 & 2048;
 $10 = ($9|0)!=(0);
 if (!($10)) {
  $23 = HEAP32[$0>>2]|0;
  _columnMallocFailure($23);
  $24 = HEAP32[$pOut>>2]|0;
  STACKTOP = sp;return ($24|0);
 }
 $11 = HEAP32[$pOut>>2]|0;
 $12 = ((($11)) + 8|0);
 $13 = HEAP16[$12>>1]|0;
 $14 = $13&65535;
 $15 = $14 & -2049;
 $16 = $15&65535;
 HEAP16[$12>>1] = $16;
 $17 = HEAP32[$pOut>>2]|0;
 $18 = ((($17)) + 8|0);
 $19 = HEAP16[$18>>1]|0;
 $20 = $19&65535;
 $21 = $20 | 4096;
 $22 = $21&65535;
 HEAP16[$18>>1] = $22;
 $23 = HEAP32[$0>>2]|0;
 _columnMallocFailure($23);
 $24 = HEAP32[$pOut>>2]|0;
 STACKTOP = sp;return ($24|0);
}
function _sqlite3_column_type($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $iType = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $iType = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnMem($2,$3)|0);
 $5 = (_sqlite3_value_type($4)|0);
 HEAP32[$iType>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _columnMallocFailure($6);
 $7 = HEAP32[$iType>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3_column_name($pStmt,$N) {
 $pStmt = $pStmt|0;
 $N = $N|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $N;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_columnName($2,$3,169,0)|0);
 STACKTOP = sp;return ($4|0);
}
function _sqlite3_bind_blob($pStmt,$i,$zData,$nData,$xDel) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 $zData = $zData|0;
 $nData = $nData|0;
 $xDel = $xDel|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $3 = sp + 4|0;
 $4 = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 HEAP32[$2>>2] = $zData;
 HEAP32[$3>>2] = $nData;
 HEAP32[$4>>2] = $xDel;
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$1>>2]|0;
 $7 = HEAP32[$2>>2]|0;
 $8 = HEAP32[$3>>2]|0;
 $9 = HEAP32[$4>>2]|0;
 $10 = (_bindText($5,$6,$7,$8,$9,0)|0);
 STACKTOP = sp;return ($10|0);
}
function _sqlite3_bind_double($pStmt,$i,$rValue) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 $rValue = +$rValue;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, $rc = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $2 = sp;
 $rc = sp + 12|0;
 $p = sp + 8|0;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 HEAPF64[$2>>3] = $rValue;
 $3 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $3;
 $4 = HEAP32[$p>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = (_vdbeUnbind($4,$5)|0);
 HEAP32[$rc>>2] = $6;
 $7 = HEAP32[$rc>>2]|0;
 $8 = ($7|0)==(0);
 if (!($8)) {
  $16 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($16|0);
 }
 $9 = HEAP32[$1>>2]|0;
 $10 = (($9) - 1)|0;
 $11 = HEAP32[$p>>2]|0;
 $12 = ((($11)) + 116|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (($13) + (($10*40)|0)|0);
 $15 = +HEAPF64[$2>>3];
 _sqlite3VdbeMemSetDouble($14,$15);
 $16 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($16|0);
}
function _sqlite3_bind_int($p,$i,$iValue) {
 $p = $p|0;
 $i = $i|0;
 $iValue = $iValue|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $i;
 HEAP32[$2>>2] = $iValue;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = HEAP32[$2>>2]|0;
 $6 = ($5|0)<(0);
 $7 = $6 << 31 >> 31;
 $8 = (_sqlite3_bind_int64($3,$4,$5,$7)|0);
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_bind_int64($pStmt,$i,$0,$1) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 20|0;
 $3 = sp + 16|0;
 $4 = sp;
 $rc = sp + 12|0;
 $p = sp + 8|0;
 HEAP32[$2>>2] = $pStmt;
 HEAP32[$3>>2] = $i;
 $5 = $4;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 $9 = HEAP32[$2>>2]|0;
 HEAP32[$p>>2] = $9;
 $10 = HEAP32[$p>>2]|0;
 $11 = HEAP32[$3>>2]|0;
 $12 = (_vdbeUnbind($10,$11)|0);
 HEAP32[$rc>>2] = $12;
 $13 = HEAP32[$rc>>2]|0;
 $14 = ($13|0)==(0);
 if (!($14)) {
  $27 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($27|0);
 }
 $15 = HEAP32[$3>>2]|0;
 $16 = (($15) - 1)|0;
 $17 = HEAP32[$p>>2]|0;
 $18 = ((($17)) + 116|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = (($19) + (($16*40)|0)|0);
 $21 = $4;
 $22 = $21;
 $23 = HEAP32[$22>>2]|0;
 $24 = (($21) + 4)|0;
 $25 = $24;
 $26 = HEAP32[$25>>2]|0;
 _sqlite3VdbeMemSetInt64($20,$23,$26);
 $27 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($27|0);
}
function _sqlite3_bind_null($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $p = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $rc = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 $2 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $2;
 $3 = HEAP32[$p>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = (_vdbeUnbind($3,$4)|0);
 HEAP32[$rc>>2] = $5;
 $6 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($6|0);
}
function _sqlite3_bind_text($pStmt,$i,$zData,$nData,$xDel) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 $zData = $zData|0;
 $nData = $nData|0;
 $xDel = $xDel|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $3 = sp + 4|0;
 $4 = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 HEAP32[$2>>2] = $zData;
 HEAP32[$3>>2] = $nData;
 HEAP32[$4>>2] = $xDel;
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$1>>2]|0;
 $7 = HEAP32[$2>>2]|0;
 $8 = HEAP32[$3>>2]|0;
 $9 = HEAP32[$4>>2]|0;
 $10 = (_bindText($5,$6,$7,$8,$9,1)|0);
 STACKTOP = sp;return ($10|0);
}
function _sqlite3_bind_value($pStmt,$i,$pValue) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 $pValue = $pValue|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0.0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 HEAP32[$2>>2] = $pValue;
 $3 = HEAP32[$2>>2]|0;
 $4 = (_sqlite3_value_type($3)|0);
 switch ($4|0) {
 case 1:  {
  $5 = HEAP32[$0>>2]|0;
  $6 = HEAP32[$1>>2]|0;
  $7 = HEAP32[$2>>2]|0;
  $8 = $7;
  $9 = $8;
  $10 = HEAP32[$9>>2]|0;
  $11 = (($8) + 4)|0;
  $12 = $11;
  $13 = HEAP32[$12>>2]|0;
  $14 = (_sqlite3_bind_int64($5,$6,$10,$13)|0);
  HEAP32[$rc>>2] = $14;
  $52 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($52|0);
  break;
 }
 case 2:  {
  $15 = HEAP32[$0>>2]|0;
  $16 = HEAP32[$1>>2]|0;
  $17 = HEAP32[$2>>2]|0;
  $18 = +HEAPF64[$17>>3];
  $19 = (_sqlite3_bind_double($15,$16,$18)|0);
  HEAP32[$rc>>2] = $19;
  $52 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($52|0);
  break;
 }
 case 4:  {
  $20 = HEAP32[$2>>2]|0;
  $21 = ((($20)) + 8|0);
  $22 = HEAP16[$21>>1]|0;
  $23 = $22&65535;
  $24 = $23 & 16384;
  $25 = ($24|0)!=(0);
  $26 = HEAP32[$0>>2]|0;
  $27 = HEAP32[$1>>2]|0;
  $28 = HEAP32[$2>>2]|0;
  if ($25) {
   $29 = HEAP32[$28>>2]|0;
   $30 = (_sqlite3_bind_zeroblob($26,$27,$29)|0);
   HEAP32[$rc>>2] = $30;
   $52 = HEAP32[$rc>>2]|0;
   STACKTOP = sp;return ($52|0);
  } else {
   $31 = ((($28)) + 16|0);
   $32 = HEAP32[$31>>2]|0;
   $33 = HEAP32[$2>>2]|0;
   $34 = ((($33)) + 12|0);
   $35 = HEAP32[$34>>2]|0;
   $36 = (_sqlite3_bind_blob($26,$27,$32,$35,(-1))|0);
   HEAP32[$rc>>2] = $36;
   $52 = HEAP32[$rc>>2]|0;
   STACKTOP = sp;return ($52|0);
  }
  break;
 }
 case 3:  {
  $37 = HEAP32[$0>>2]|0;
  $38 = HEAP32[$1>>2]|0;
  $39 = HEAP32[$2>>2]|0;
  $40 = ((($39)) + 16|0);
  $41 = HEAP32[$40>>2]|0;
  $42 = HEAP32[$2>>2]|0;
  $43 = ((($42)) + 12|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = HEAP32[$2>>2]|0;
  $46 = ((($45)) + 10|0);
  $47 = HEAP8[$46>>0]|0;
  $48 = (_bindText($37,$38,$41,$44,(-1),$47)|0);
  HEAP32[$rc>>2] = $48;
  $52 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($52|0);
  break;
 }
 default: {
  $49 = HEAP32[$0>>2]|0;
  $50 = HEAP32[$1>>2]|0;
  $51 = (_sqlite3_bind_null($49,$50)|0);
  HEAP32[$rc>>2] = $51;
  $52 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($52|0);
 }
 }
 return (0)|0;
}
function _sqlite3_bind_zeroblob($pStmt,$i,$n) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, $rc = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $rc = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 HEAP32[$2>>2] = $n;
 $3 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $3;
 $4 = HEAP32[$p>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = (_vdbeUnbind($4,$5)|0);
 HEAP32[$rc>>2] = $6;
 $7 = HEAP32[$rc>>2]|0;
 $8 = ($7|0)==(0);
 if (!($8)) {
  $16 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($16|0);
 }
 $9 = HEAP32[$1>>2]|0;
 $10 = (($9) - 1)|0;
 $11 = HEAP32[$p>>2]|0;
 $12 = ((($11)) + 116|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (($13) + (($10*40)|0)|0);
 $15 = HEAP32[$2>>2]|0;
 _sqlite3VdbeMemSetZeroBlob($14,$15);
 $16 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($16|0);
}
function _sqlite3_bind_parameter_count($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pStmt;
 $1 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $1;
 $2 = HEAP32[$p>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  $8 = 0;
  STACKTOP = sp;return ($8|0);
 }
 $4 = HEAP32[$p>>2]|0;
 $5 = ((($4)) + 16|0);
 $6 = HEAP16[$5>>1]|0;
 $7 = $6 << 16 >> 16;
 $8 = $7;
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_bind_parameter_index($pStmt,$zName) {
 $pStmt = $pStmt|0;
 $zName = $zName|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $zName;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = (_sqlite3Strlen30($4)|0);
 $6 = (_sqlite3VdbeParameterIndex($2,$3,$5)|0);
 STACKTOP = sp;return ($6|0);
}
function _sqlite3_sql($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pStmt;
 $1 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $1;
 $2 = HEAP32[$p>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  $7 = 0;
  STACKTOP = sp;return ($7|0);
 }
 $4 = HEAP32[$p>>2]|0;
 $5 = ((($4)) + 176|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = $6;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3_value_numeric_type($pVal) {
 $pVal = $pVal|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $eType = 0, $pMem = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $eType = sp + 4|0;
 $pMem = sp;
 HEAP32[$0>>2] = $pVal;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3_value_type($1)|0);
 HEAP32[$eType>>2] = $2;
 $3 = HEAP32[$eType>>2]|0;
 $4 = ($3|0)==(3);
 if (!($4)) {
  $9 = HEAP32[$eType>>2]|0;
  STACKTOP = sp;return ($9|0);
 }
 $5 = HEAP32[$0>>2]|0;
 HEAP32[$pMem>>2] = $5;
 $6 = HEAP32[$pMem>>2]|0;
 _applyNumericAffinity($6,0);
 $7 = HEAP32[$0>>2]|0;
 $8 = (_sqlite3_value_type($7)|0);
 HEAP32[$eType>>2] = $8;
 $9 = HEAP32[$eType>>2]|0;
 STACKTOP = sp;return ($9|0);
}
function _sqlite3_blob_open($db,$zDb,$zTable,$zColumn,$0,$1,$flags,$ppBlob) {
 $db = $db|0;
 $zDb = $zDb|0;
 $zTable = $zTable|0;
 $zColumn = $zColumn|0;
 $0 = $0|0;
 $1 = $1|0;
 $flags = $flags|0;
 $ppBlob = $ppBlob|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0;
 var $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0;
 var $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0;
 var $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0;
 var $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0;
 var $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0;
 var $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0;
 var $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0;
 var $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0;
 var $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $aOp = 0, $iCol = 0, $iDb = 0, $j = 0, $j1 = 0;
 var $nAttempt = 0, $pBlob = 0, $pFKey = 0, $pIdx = 0, $pParse = 0, $pTab = 0, $rc = 0, $v = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_buffer10 = 0, $vararg_buffer13 = 0, $vararg_buffer4 = 0, $vararg_buffer7 = 0, $zErr = 0, $zFault = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0;
 $vararg_buffer13 = sp + 48|0;
 $vararg_buffer10 = sp + 40|0;
 $vararg_buffer7 = sp + 32|0;
 $vararg_buffer4 = sp + 24|0;
 $vararg_buffer1 = sp + 16|0;
 $vararg_buffer = sp + 8|0;
 $2 = sp + 132|0;
 $3 = sp + 128|0;
 $4 = sp + 124|0;
 $5 = sp + 120|0;
 $6 = sp;
 $7 = sp + 116|0;
 $8 = sp + 112|0;
 $nAttempt = sp + 108|0;
 $iCol = sp + 104|0;
 $rc = sp + 100|0;
 $zErr = sp + 96|0;
 $pTab = sp + 92|0;
 $pParse = sp + 88|0;
 $pBlob = sp + 84|0;
 $zFault = sp + 80|0;
 $pIdx = sp + 76|0;
 $pFKey = sp + 72|0;
 $j = sp + 68|0;
 $j1 = sp + 64|0;
 $v = sp + 60|0;
 $iDb = sp + 56|0;
 $aOp = sp + 52|0;
 HEAP32[$2>>2] = $db;
 HEAP32[$3>>2] = $zDb;
 HEAP32[$4>>2] = $zTable;
 HEAP32[$5>>2] = $zColumn;
 $9 = $6;
 $10 = $9;
 HEAP32[$10>>2] = $0;
 $11 = (($9) + 4)|0;
 $12 = $11;
 HEAP32[$12>>2] = $1;
 HEAP32[$7>>2] = $flags;
 HEAP32[$8>>2] = $ppBlob;
 HEAP32[$nAttempt>>2] = 0;
 HEAP32[$rc>>2] = 0;
 HEAP32[$zErr>>2] = 0;
 HEAP32[$pParse>>2] = 0;
 HEAP32[$pBlob>>2] = 0;
 $13 = HEAP32[$8>>2]|0;
 HEAP32[$13>>2] = 0;
 $14 = HEAP32[$7>>2]|0;
 $15 = ($14|0)!=(0);
 $16 = $15 ^ 1;
 $17 = $16 ^ 1;
 $18 = $17&1;
 HEAP32[$7>>2] = $18;
 $19 = HEAP32[$2>>2]|0;
 $20 = (_sqlite3DbMallocZero($19,36,0)|0);
 HEAP32[$pBlob>>2] = $20;
 $21 = HEAP32[$pBlob>>2]|0;
 $22 = ($21|0)!=(0|0);
 L1: do {
  if ($22) {
   $23 = HEAP32[$2>>2]|0;
   $24 = (_sqlite3DbMallocRaw($23,480,0)|0);
   HEAP32[$pParse>>2] = $24;
   $25 = HEAP32[$pParse>>2]|0;
   $26 = ($25|0)!=(0|0);
   if ($26) {
    while(1) {
     $27 = HEAP32[$pParse>>2]|0;
     _memset(($27|0),0,480)|0;
     $28 = HEAP32[$2>>2]|0;
     $29 = HEAP32[$pParse>>2]|0;
     HEAP32[$29>>2] = $28;
     $30 = HEAP32[$2>>2]|0;
     $31 = HEAP32[$zErr>>2]|0;
     _sqlite3DbFree($30,$31);
     HEAP32[$zErr>>2] = 0;
     $32 = HEAP32[$2>>2]|0;
     _sqlite3BtreeEnterAll($32);
     $33 = HEAP32[$pParse>>2]|0;
     $34 = HEAP32[$4>>2]|0;
     $35 = HEAP32[$3>>2]|0;
     $36 = (_sqlite3LocateTable($33,0,$34,$35)|0);
     HEAP32[$pTab>>2] = $36;
     $37 = HEAP32[$pTab>>2]|0;
     $38 = ($37|0)!=(0|0);
     if ($38) {
      $39 = HEAP32[$pTab>>2]|0;
      $40 = ((($39)) + 42|0);
      $41 = HEAP8[$40>>0]|0;
      $42 = $41&255;
      $43 = $42 & 16;
      $44 = ($43|0)!=(0);
      if ($44) {
       HEAP32[$pTab>>2] = 0;
       $45 = HEAP32[$pParse>>2]|0;
       $46 = HEAP32[$4>>2]|0;
       HEAP32[$vararg_buffer>>2] = $46;
       _sqlite3ErrorMsg($45,18193,$vararg_buffer);
      }
     }
     $47 = HEAP32[$pTab>>2]|0;
     $48 = ($47|0)!=(0|0);
     if ($48) {
      $49 = HEAP32[$pTab>>2]|0;
      $50 = ((($49)) + 42|0);
      $51 = HEAP8[$50>>0]|0;
      $52 = $51&255;
      $53 = $52 & 32;
      $54 = ($53|0)==(0);
      if (!($54)) {
       HEAP32[$pTab>>2] = 0;
       $55 = HEAP32[$pParse>>2]|0;
       $56 = HEAP32[$4>>2]|0;
       HEAP32[$vararg_buffer1>>2] = $56;
       _sqlite3ErrorMsg($55,18223,$vararg_buffer1);
      }
     }
     $57 = HEAP32[$pTab>>2]|0;
     $58 = ($57|0)!=(0|0);
     if ($58) {
      $59 = HEAP32[$pTab>>2]|0;
      $60 = ((($59)) + 12|0);
      $61 = HEAP32[$60>>2]|0;
      $62 = ($61|0)!=(0|0);
      if ($62) {
       HEAP32[$pTab>>2] = 0;
       $63 = HEAP32[$pParse>>2]|0;
       $64 = HEAP32[$4>>2]|0;
       HEAP32[$vararg_buffer4>>2] = $64;
       _sqlite3ErrorMsg($63,18259,$vararg_buffer4);
      }
     }
     $65 = HEAP32[$pTab>>2]|0;
     $66 = ($65|0)!=(0|0);
     if (!($66)) {
      label = 13;
      break;
     }
     $78 = HEAP32[$pTab>>2]|0;
     $79 = HEAP32[$pBlob>>2]|0;
     $80 = ((($79)) + 32|0);
     HEAP32[$80>>2] = $78;
     $81 = HEAP32[$2>>2]|0;
     $82 = HEAP32[$pTab>>2]|0;
     $83 = ((($82)) + 64|0);
     $84 = HEAP32[$83>>2]|0;
     $85 = (_sqlite3SchemaToIndex($81,$84)|0);
     $86 = HEAP32[$2>>2]|0;
     $87 = ((($86)) + 16|0);
     $88 = HEAP32[$87>>2]|0;
     $89 = (($88) + ($85<<4)|0);
     $90 = HEAP32[$89>>2]|0;
     $91 = HEAP32[$pBlob>>2]|0;
     $92 = ((($91)) + 28|0);
     HEAP32[$92>>2] = $90;
     HEAP32[$iCol>>2] = 0;
     while(1) {
      $93 = HEAP32[$iCol>>2]|0;
      $94 = HEAP32[$pTab>>2]|0;
      $95 = ((($94)) + 34|0);
      $96 = HEAP16[$95>>1]|0;
      $97 = $96 << 16 >> 16;
      $98 = ($93|0)<($97|0);
      if (!($98)) {
       break;
      }
      $99 = HEAP32[$iCol>>2]|0;
      $100 = HEAP32[$pTab>>2]|0;
      $101 = ((($100)) + 4|0);
      $102 = HEAP32[$101>>2]|0;
      $103 = (($102) + ($99<<4)|0);
      $104 = HEAP32[$103>>2]|0;
      $105 = HEAP32[$5>>2]|0;
      $106 = (_sqlite3StrICmp($104,$105)|0);
      $107 = ($106|0)==(0);
      if ($107) {
       break;
      }
      $108 = HEAP32[$iCol>>2]|0;
      $109 = (($108) + 1)|0;
      HEAP32[$iCol>>2] = $109;
     }
     $110 = HEAP32[$iCol>>2]|0;
     $111 = HEAP32[$pTab>>2]|0;
     $112 = ((($111)) + 34|0);
     $113 = HEAP16[$112>>1]|0;
     $114 = $113 << 16 >> 16;
     $115 = ($110|0)==($114|0);
     if ($115) {
      label = 21;
      break;
     }
     $121 = HEAP32[$7>>2]|0;
     $122 = ($121|0)!=(0);
     if ($122) {
      HEAP32[$zFault>>2] = 0;
      $123 = HEAP32[$2>>2]|0;
      $124 = ((($123)) + 24|0);
      $125 = HEAP32[$124>>2]|0;
      $126 = $125 & 524288;
      $127 = ($126|0)!=(0);
      L26: do {
       if ($127) {
        $128 = HEAP32[$pTab>>2]|0;
        $129 = ((($128)) + 16|0);
        $130 = HEAP32[$129>>2]|0;
        HEAP32[$pFKey>>2] = $130;
        while(1) {
         $131 = HEAP32[$pFKey>>2]|0;
         $132 = ($131|0)!=(0|0);
         if (!($132)) {
          break L26;
         }
         HEAP32[$j>>2] = 0;
         while(1) {
          $133 = HEAP32[$j>>2]|0;
          $134 = HEAP32[$pFKey>>2]|0;
          $135 = ((($134)) + 20|0);
          $136 = HEAP32[$135>>2]|0;
          $137 = ($133|0)<($136|0);
          if (!($137)) {
           break;
          }
          $138 = HEAP32[$j>>2]|0;
          $139 = HEAP32[$pFKey>>2]|0;
          $140 = ((($139)) + 36|0);
          $141 = (($140) + ($138<<3)|0);
          $142 = HEAP32[$141>>2]|0;
          $143 = HEAP32[$iCol>>2]|0;
          $144 = ($142|0)==($143|0);
          if ($144) {
           HEAP32[$zFault>>2] = 18301;
          }
          $145 = HEAP32[$j>>2]|0;
          $146 = (($145) + 1)|0;
          HEAP32[$j>>2] = $146;
         }
         $147 = HEAP32[$pFKey>>2]|0;
         $148 = ((($147)) + 4|0);
         $149 = HEAP32[$148>>2]|0;
         HEAP32[$pFKey>>2] = $149;
        }
       }
      } while(0);
      $150 = HEAP32[$pTab>>2]|0;
      $151 = ((($150)) + 8|0);
      $152 = HEAP32[$151>>2]|0;
      HEAP32[$pIdx>>2] = $152;
      while(1) {
       $153 = HEAP32[$pIdx>>2]|0;
       $154 = ($153|0)!=(0|0);
       if (!($154)) {
        break;
       }
       HEAP32[$j1>>2] = 0;
       while(1) {
        $155 = HEAP32[$j1>>2]|0;
        $156 = HEAP32[$pIdx>>2]|0;
        $157 = ((($156)) + 50|0);
        $158 = HEAP16[$157>>1]|0;
        $159 = $158&65535;
        $160 = ($155|0)<($159|0);
        if (!($160)) {
         break;
        }
        $161 = HEAP32[$j1>>2]|0;
        $162 = HEAP32[$pIdx>>2]|0;
        $163 = ((($162)) + 4|0);
        $164 = HEAP32[$163>>2]|0;
        $165 = (($164) + ($161<<1)|0);
        $166 = HEAP16[$165>>1]|0;
        $167 = $166 << 16 >> 16;
        $168 = HEAP32[$iCol>>2]|0;
        $169 = ($167|0)==($168|0);
        if ($169) {
         label = 38;
        } else {
         $170 = HEAP32[$j1>>2]|0;
         $171 = HEAP32[$pIdx>>2]|0;
         $172 = ((($171)) + 4|0);
         $173 = HEAP32[$172>>2]|0;
         $174 = (($173) + ($170<<1)|0);
         $175 = HEAP16[$174>>1]|0;
         $176 = $175 << 16 >> 16;
         $177 = ($176|0)==(-2);
         if ($177) {
          label = 38;
         }
        }
        if ((label|0) == 38) {
         label = 0;
         HEAP32[$zFault>>2] = 18313;
        }
        $178 = HEAP32[$j1>>2]|0;
        $179 = (($178) + 1)|0;
        HEAP32[$j1>>2] = $179;
       }
       $180 = HEAP32[$pIdx>>2]|0;
       $181 = ((($180)) + 20|0);
       $182 = HEAP32[$181>>2]|0;
       HEAP32[$pIdx>>2] = $182;
      }
      $183 = HEAP32[$zFault>>2]|0;
      $184 = ($183|0)!=(0|0);
      if ($184) {
       label = 42;
       break;
      }
     }
     $190 = HEAP32[$pParse>>2]|0;
     $191 = (_sqlite3VdbeCreate($190)|0);
     $192 = HEAP32[$pBlob>>2]|0;
     $193 = ((($192)) + 20|0);
     HEAP32[$193>>2] = $191;
     $194 = HEAP32[$pBlob>>2]|0;
     $195 = ((($194)) + 20|0);
     $196 = HEAP32[$195>>2]|0;
     $197 = ($196|0)!=(0|0);
     if ($197) {
      $198 = HEAP32[$pBlob>>2]|0;
      $199 = ((($198)) + 20|0);
      $200 = HEAP32[$199>>2]|0;
      HEAP32[$v>>2] = $200;
      $201 = HEAP32[$2>>2]|0;
      $202 = HEAP32[$pTab>>2]|0;
      $203 = ((($202)) + 64|0);
      $204 = HEAP32[$203>>2]|0;
      $205 = (_sqlite3SchemaToIndex($201,$204)|0);
      HEAP32[$iDb>>2] = $205;
      $206 = HEAP32[$v>>2]|0;
      $207 = HEAP32[$iDb>>2]|0;
      $208 = HEAP32[$7>>2]|0;
      $209 = HEAP32[$pTab>>2]|0;
      $210 = ((($209)) + 64|0);
      $211 = HEAP32[$210>>2]|0;
      $212 = HEAP32[$211>>2]|0;
      $213 = HEAP32[$pTab>>2]|0;
      $214 = ((($213)) + 64|0);
      $215 = HEAP32[$214>>2]|0;
      $216 = ((($215)) + 4|0);
      $217 = HEAP32[$216>>2]|0;
      (_sqlite3VdbeAddOp4Int($206,2,$207,$208,$212,$217)|0);
      $218 = HEAP32[$v>>2]|0;
      _sqlite3VdbeChangeP5($218,1);
      $219 = HEAP32[$v>>2]|0;
      $220 = (_sqlite3VdbeAddOpList($219,9,18355,0)|0);
      HEAP32[$aOp>>2] = $220;
      $221 = HEAP32[$v>>2]|0;
      $222 = HEAP32[$iDb>>2]|0;
      _sqlite3VdbeUsesBtree($221,$222);
      $223 = HEAP32[$2>>2]|0;
      $224 = ((($223)) + 69|0);
      $225 = HEAP8[$224>>0]|0;
      $226 = $225&255;
      $227 = ($226|0)==(0);
      if ($227) {
       $228 = HEAP32[$iDb>>2]|0;
       $229 = HEAP32[$aOp>>2]|0;
       $230 = ((($229)) + 4|0);
       HEAP32[$230>>2] = $228;
       $231 = HEAP32[$pTab>>2]|0;
       $232 = ((($231)) + 28|0);
       $233 = HEAP32[$232>>2]|0;
       $234 = HEAP32[$aOp>>2]|0;
       $235 = ((($234)) + 8|0);
       HEAP32[$235>>2] = $233;
       $236 = HEAP32[$7>>2]|0;
       $237 = HEAP32[$aOp>>2]|0;
       $238 = ((($237)) + 12|0);
       HEAP32[$238>>2] = $236;
       $239 = HEAP32[$v>>2]|0;
       $240 = HEAP32[$pTab>>2]|0;
       $241 = HEAP32[$240>>2]|0;
       _sqlite3VdbeChangeP4($239,1,$241,0);
      }
      $242 = HEAP32[$2>>2]|0;
      $243 = ((($242)) + 69|0);
      $244 = HEAP8[$243>>0]|0;
      $245 = $244&255;
      $246 = ($245|0)==(0);
      if ($246) {
       $247 = HEAP32[$7>>2]|0;
       $248 = ($247|0)!=(0);
       if ($248) {
        $249 = HEAP32[$aOp>>2]|0;
        $250 = ((($249)) + 20|0);
        HEAP8[$250>>0] = 105;
       }
       $251 = HEAP32[$pTab>>2]|0;
       $252 = ((($251)) + 28|0);
       $253 = HEAP32[$252>>2]|0;
       $254 = HEAP32[$aOp>>2]|0;
       $255 = ((($254)) + 20|0);
       $256 = ((($255)) + 8|0);
       HEAP32[$256>>2] = $253;
       $257 = HEAP32[$iDb>>2]|0;
       $258 = HEAP32[$aOp>>2]|0;
       $259 = ((($258)) + 20|0);
       $260 = ((($259)) + 12|0);
       HEAP32[$260>>2] = $257;
       $261 = HEAP32[$aOp>>2]|0;
       $262 = ((($261)) + 20|0);
       $263 = ((($262)) + 1|0);
       HEAP8[$263>>0] = -14;
       $264 = HEAP32[$pTab>>2]|0;
       $265 = ((($264)) + 34|0);
       $266 = HEAP16[$265>>1]|0;
       $267 = $266 << 16 >> 16;
       $268 = (($267) + 1)|0;
       $269 = HEAP32[$aOp>>2]|0;
       $270 = ((($269)) + 20|0);
       $271 = ((($270)) + 16|0);
       HEAP32[$271>>2] = $268;
       $272 = HEAP32[$pTab>>2]|0;
       $273 = ((($272)) + 34|0);
       $274 = HEAP16[$273>>1]|0;
       $275 = $274 << 16 >> 16;
       $276 = HEAP32[$aOp>>2]|0;
       $277 = ((($276)) + 80|0);
       $278 = ((($277)) + 8|0);
       HEAP32[$278>>2] = $275;
       $279 = HEAP32[$pParse>>2]|0;
       $280 = ((($279)) + 400|0);
       HEAP16[$280>>1] = 1;
       $281 = HEAP32[$pParse>>2]|0;
       $282 = ((($281)) + 44|0);
       HEAP32[$282>>2] = 1;
       $283 = HEAP32[$pParse>>2]|0;
       $284 = ((($283)) + 40|0);
       HEAP32[$284>>2] = 1;
       $285 = HEAP32[$v>>2]|0;
       $286 = HEAP32[$pParse>>2]|0;
       _sqlite3VdbeMakeReady($285,$286);
      }
     }
     $287 = HEAP32[$7>>2]|0;
     $288 = HEAP32[$pBlob>>2]|0;
     HEAP32[$288>>2] = $287;
     $289 = HEAP32[$iCol>>2]|0;
     $290 = HEAP32[$pBlob>>2]|0;
     $291 = ((($290)) + 12|0);
     HEAP32[$291>>2] = $289;
     $292 = HEAP32[$2>>2]|0;
     $293 = HEAP32[$pBlob>>2]|0;
     $294 = ((($293)) + 24|0);
     HEAP32[$294>>2] = $292;
     $295 = HEAP32[$2>>2]|0;
     $296 = ((($295)) + 69|0);
     $297 = HEAP8[$296>>0]|0;
     $298 = ($297<<24>>24)!=(0);
     if ($298) {
      break L1;
     }
     $299 = HEAP32[$pBlob>>2]|0;
     $300 = ((($299)) + 20|0);
     $301 = HEAP32[$300>>2]|0;
     $302 = $6;
     $303 = $302;
     $304 = HEAP32[$303>>2]|0;
     $305 = (($302) + 4)|0;
     $306 = $305;
     $307 = HEAP32[$306>>2]|0;
     (_sqlite3_bind_int64($301,1,$304,$307)|0);
     $308 = HEAP32[$pBlob>>2]|0;
     $309 = $6;
     $310 = $309;
     $311 = HEAP32[$310>>2]|0;
     $312 = (($309) + 4)|0;
     $313 = $312;
     $314 = HEAP32[$313>>2]|0;
     $315 = (_blobSeekToRow($308,$311,$314,$zErr)|0);
     HEAP32[$rc>>2] = $315;
     $316 = HEAP32[$nAttempt>>2]|0;
     $317 = (($316) + 1)|0;
     HEAP32[$nAttempt>>2] = $317;
     $318 = ($317|0)<(50);
     $319 = HEAP32[$rc>>2]|0;
     $320 = ($319|0)==(17);
     $321 = $318 ? $320 : 0;
     if (!($321)) {
      break L1;
     }
    }
    if ((label|0) == 13) {
     $67 = HEAP32[$pParse>>2]|0;
     $68 = ((($67)) + 4|0);
     $69 = HEAP32[$68>>2]|0;
     $70 = ($69|0)!=(0|0);
     if ($70) {
      $71 = HEAP32[$2>>2]|0;
      $72 = HEAP32[$zErr>>2]|0;
      _sqlite3DbFree($71,$72);
      $73 = HEAP32[$pParse>>2]|0;
      $74 = ((($73)) + 4|0);
      $75 = HEAP32[$74>>2]|0;
      HEAP32[$zErr>>2] = $75;
      $76 = HEAP32[$pParse>>2]|0;
      $77 = ((($76)) + 4|0);
      HEAP32[$77>>2] = 0;
     }
     HEAP32[$rc>>2] = 1;
     break;
    }
    else if ((label|0) == 21) {
     $116 = HEAP32[$2>>2]|0;
     $117 = HEAP32[$zErr>>2]|0;
     _sqlite3DbFree($116,$117);
     $118 = HEAP32[$2>>2]|0;
     $119 = HEAP32[$5>>2]|0;
     HEAP32[$vararg_buffer7>>2] = $119;
     $120 = (_sqlite3MPrintf($118,18280,$vararg_buffer7)|0);
     HEAP32[$zErr>>2] = $120;
     HEAP32[$rc>>2] = 1;
     break;
    }
    else if ((label|0) == 42) {
     $185 = HEAP32[$2>>2]|0;
     $186 = HEAP32[$zErr>>2]|0;
     _sqlite3DbFree($185,$186);
     $187 = HEAP32[$2>>2]|0;
     $188 = HEAP32[$zFault>>2]|0;
     HEAP32[$vararg_buffer10>>2] = $188;
     $189 = (_sqlite3MPrintf($187,18321,$vararg_buffer10)|0);
     HEAP32[$zErr>>2] = $189;
     HEAP32[$rc>>2] = 1;
     break;
    }
   }
  }
 } while(0);
 $322 = HEAP32[$rc>>2]|0;
 $323 = ($322|0)==(0);
 if ($323) {
  $324 = HEAP32[$2>>2]|0;
  $325 = ((($324)) + 69|0);
  $326 = HEAP8[$325>>0]|0;
  $327 = $326&255;
  $328 = ($327|0)==(0);
  if ($328) {
   $329 = HEAP32[$pBlob>>2]|0;
   $330 = HEAP32[$8>>2]|0;
   HEAP32[$330>>2] = $329;
   $342 = HEAP32[$2>>2]|0;
   $343 = HEAP32[$rc>>2]|0;
   $344 = HEAP32[$zErr>>2]|0;
   $345 = ($344|0)!=(0|0);
   $346 = $345 ? 18391 : 0;
   $347 = HEAP32[$zErr>>2]|0;
   HEAP32[$vararg_buffer13>>2] = $347;
   _sqlite3ErrorWithMsg($342,$343,$346,$vararg_buffer13);
   $348 = HEAP32[$2>>2]|0;
   $349 = HEAP32[$zErr>>2]|0;
   _sqlite3DbFree($348,$349);
   $350 = HEAP32[$pParse>>2]|0;
   _sqlite3ParserReset($350);
   $351 = HEAP32[$2>>2]|0;
   $352 = HEAP32[$pParse>>2]|0;
   _sqlite3DbFree($351,$352);
   $353 = HEAP32[$2>>2]|0;
   $354 = HEAP32[$rc>>2]|0;
   $355 = (_sqlite3ApiExit($353,$354)|0);
   HEAP32[$rc>>2] = $355;
   $356 = HEAP32[$rc>>2]|0;
   STACKTOP = sp;return ($356|0);
  }
 }
 $331 = HEAP32[$pBlob>>2]|0;
 $332 = ($331|0)!=(0|0);
 if ($332) {
  $333 = HEAP32[$pBlob>>2]|0;
  $334 = ((($333)) + 20|0);
  $335 = HEAP32[$334>>2]|0;
  $336 = ($335|0)!=(0|0);
  if ($336) {
   $337 = HEAP32[$pBlob>>2]|0;
   $338 = ((($337)) + 20|0);
   $339 = HEAP32[$338>>2]|0;
   (_sqlite3VdbeFinalize($339)|0);
  }
 }
 $340 = HEAP32[$2>>2]|0;
 $341 = HEAP32[$pBlob>>2]|0;
 _sqlite3DbFree($340,$341);
 $342 = HEAP32[$2>>2]|0;
 $343 = HEAP32[$rc>>2]|0;
 $344 = HEAP32[$zErr>>2]|0;
 $345 = ($344|0)!=(0|0);
 $346 = $345 ? 18391 : 0;
 $347 = HEAP32[$zErr>>2]|0;
 HEAP32[$vararg_buffer13>>2] = $347;
 _sqlite3ErrorWithMsg($342,$343,$346,$vararg_buffer13);
 $348 = HEAP32[$2>>2]|0;
 $349 = HEAP32[$zErr>>2]|0;
 _sqlite3DbFree($348,$349);
 $350 = HEAP32[$pParse>>2]|0;
 _sqlite3ParserReset($350);
 $351 = HEAP32[$2>>2]|0;
 $352 = HEAP32[$pParse>>2]|0;
 _sqlite3DbFree($351,$352);
 $353 = HEAP32[$2>>2]|0;
 $354 = HEAP32[$rc>>2]|0;
 $355 = (_sqlite3ApiExit($353,$354)|0);
 HEAP32[$rc>>2] = $355;
 $356 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($356|0);
}
function _sqlite3_blob_close($pBlob) {
 $pBlob = $pBlob|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $db = 0, $p = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $p = sp + 8|0;
 $rc = sp + 4|0;
 $db = sp;
 HEAP32[$0>>2] = $pBlob;
 $1 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $1;
 $2 = HEAP32[$p>>2]|0;
 $3 = ($2|0)!=(0|0);
 if ($3) {
  $4 = HEAP32[$p>>2]|0;
  $5 = ((($4)) + 24|0);
  $6 = HEAP32[$5>>2]|0;
  HEAP32[$db>>2] = $6;
  $7 = HEAP32[$p>>2]|0;
  $8 = ((($7)) + 20|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = (_sqlite3_finalize($9)|0);
  HEAP32[$rc>>2] = $10;
  $11 = HEAP32[$db>>2]|0;
  $12 = HEAP32[$p>>2]|0;
  _sqlite3DbFree($11,$12);
  $13 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($13|0);
 } else {
  HEAP32[$rc>>2] = 0;
  $13 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($13|0);
 }
 return (0)|0;
}
function _sqlite3_blob_read($pBlob,$z,$n,$iOffset) {
 $pBlob = $pBlob|0;
 $z = $z|0;
 $n = $n|0;
 $iOffset = $iOffset|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $3 = sp;
 HEAP32[$0>>2] = $pBlob;
 HEAP32[$1>>2] = $z;
 HEAP32[$2>>2] = $n;
 HEAP32[$3>>2] = $iOffset;
 $4 = HEAP32[$0>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = HEAP32[$2>>2]|0;
 $7 = HEAP32[$3>>2]|0;
 $8 = (_blobReadWrite($4,$5,$6,$7,138)|0);
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_blob_bytes($pBlob) {
 $pBlob = $pBlob|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pBlob;
 $1 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $1;
 $2 = HEAP32[$p>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  $11 = 0;
  STACKTOP = sp;return ($11|0);
 }
 $4 = HEAP32[$p>>2]|0;
 $5 = ((($4)) + 20|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ($6|0)!=(0|0);
 if (!($7)) {
  $11 = 0;
  STACKTOP = sp;return ($11|0);
 }
 $8 = HEAP32[$p>>2]|0;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = $10;
 STACKTOP = sp;return ($11|0);
}
function _sqlite3_blob_reopen($pBlob,$0,$1) {
 $pBlob = $pBlob|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, $db = 0, $p = 0, $rc = 0, $vararg_buffer = 0, $zErr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $vararg_buffer = sp + 8|0;
 $2 = sp + 32|0;
 $3 = sp + 28|0;
 $4 = sp;
 $rc = sp + 24|0;
 $p = sp + 20|0;
 $db = sp + 16|0;
 $zErr = sp + 12|0;
 HEAP32[$3>>2] = $pBlob;
 $5 = $4;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 $9 = HEAP32[$3>>2]|0;
 HEAP32[$p>>2] = $9;
 $10 = HEAP32[$p>>2]|0;
 $11 = ($10|0)==(0|0);
 if ($11) {
  $12 = (_sqlite3MisuseError(84814)|0);
  HEAP32[$2>>2] = $12;
  $42 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($42|0);
 }
 $13 = HEAP32[$p>>2]|0;
 $14 = ((($13)) + 24|0);
 $15 = HEAP32[$14>>2]|0;
 HEAP32[$db>>2] = $15;
 $16 = HEAP32[$p>>2]|0;
 $17 = ((($16)) + 20|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($18|0)==(0|0);
 if ($19) {
  HEAP32[$rc>>2] = 4;
 } else {
  $20 = HEAP32[$p>>2]|0;
  $21 = $4;
  $22 = $21;
  $23 = HEAP32[$22>>2]|0;
  $24 = (($21) + 4)|0;
  $25 = $24;
  $26 = HEAP32[$25>>2]|0;
  $27 = (_blobSeekToRow($20,$23,$26,$zErr)|0);
  HEAP32[$rc>>2] = $27;
  $28 = HEAP32[$rc>>2]|0;
  $29 = ($28|0)!=(0);
  if ($29) {
   $30 = HEAP32[$db>>2]|0;
   $31 = HEAP32[$rc>>2]|0;
   $32 = HEAP32[$zErr>>2]|0;
   $33 = ($32|0)!=(0|0);
   $34 = $33 ? 18391 : 0;
   $35 = HEAP32[$zErr>>2]|0;
   HEAP32[$vararg_buffer>>2] = $35;
   _sqlite3ErrorWithMsg($30,$31,$34,$vararg_buffer);
   $36 = HEAP32[$db>>2]|0;
   $37 = HEAP32[$zErr>>2]|0;
   _sqlite3DbFree($36,$37);
  }
 }
 $38 = HEAP32[$db>>2]|0;
 $39 = HEAP32[$rc>>2]|0;
 $40 = (_sqlite3ApiExit($38,$39)|0);
 HEAP32[$rc>>2] = $40;
 $41 = HEAP32[$rc>>2]|0;
 HEAP32[$2>>2] = $41;
 $42 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($42|0);
}
function _sqlite3_strglob($zGlobPattern,$zString) {
 $zGlobPattern = $zGlobPattern|0;
 $zString = $zString|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $zGlobPattern;
 HEAP32[$1>>2] = $zString;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_patternCompare($2,$3,18394,91)|0);
 $5 = ($4|0)==(0);
 $6 = $5&1;
 STACKTOP = sp;return ($6|0);
}
function _sqlite3_strlike($zPattern,$zStr,$esc) {
 $zPattern = $zPattern|0;
 $zStr = $zStr|0;
 $esc = $esc|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $zPattern;
 HEAP32[$1>>2] = $zStr;
 HEAP32[$2>>2] = $esc;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = HEAP32[$2>>2]|0;
 $6 = (_patternCompare($3,$4,18398,$5)|0);
 $7 = ($6|0)==(0);
 $8 = $7&1;
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_exec($db,$zSql,$xCallback,$pArg,$pzErrMsg) {
 $db = $db|0;
 $zSql = $zSql|0;
 $xCallback = $xCallback|0;
 $pArg = $pArg|0;
 $pzErrMsg = $pzErrMsg|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0;
 var $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0;
 var $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0;
 var $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0;
 var $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $azCols = 0, $azVals = 0, $callbackIsInit = 0, $i = 0, $nCol = 0, $nErrMsg = 0, $or$cond = 0, $or$cond3 = 0;
 var $pStmt = 0, $rc = 0, $zLeftover = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $0 = sp + 56|0;
 $1 = sp + 52|0;
 $2 = sp + 48|0;
 $3 = sp + 44|0;
 $4 = sp + 40|0;
 $5 = sp + 36|0;
 $rc = sp + 32|0;
 $zLeftover = sp + 28|0;
 $pStmt = sp + 24|0;
 $azCols = sp + 20|0;
 $callbackIsInit = sp + 16|0;
 $nCol = sp + 12|0;
 $azVals = sp + 8|0;
 $i = sp + 4|0;
 $nErrMsg = sp;
 HEAP32[$1>>2] = $db;
 HEAP32[$2>>2] = $zSql;
 HEAP32[$3>>2] = $xCallback;
 HEAP32[$4>>2] = $pArg;
 HEAP32[$5>>2] = $pzErrMsg;
 HEAP32[$rc>>2] = 0;
 HEAP32[$pStmt>>2] = 0;
 HEAP32[$azCols>>2] = 0;
 $6 = HEAP32[$1>>2]|0;
 $7 = (_sqlite3SafetyCheckOk($6)|0);
 $8 = ($7|0)!=(0);
 if (!($8)) {
  $9 = (_sqlite3MisuseError(109597)|0);
  HEAP32[$0>>2] = $9;
  $151 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($151|0);
 }
 $10 = HEAP32[$2>>2]|0;
 $11 = ($10|0)==(0|0);
 if ($11) {
  HEAP32[$2>>2] = 18402;
 }
 $12 = HEAP32[$1>>2]|0;
 _sqlite3Error($12,0);
 L8: while(1) {
  $13 = HEAP32[$rc>>2]|0;
  $14 = ($13|0)==(0);
  if (!($14)) {
   break;
  }
  $15 = HEAP32[$2>>2]|0;
  $16 = HEAP8[$15>>0]|0;
  $17 = $16 << 24 >> 24;
  $18 = ($17|0)!=(0);
  if (!($18)) {
   break;
  }
  HEAP32[$azVals>>2] = 0;
  HEAP32[$pStmt>>2] = 0;
  $19 = HEAP32[$1>>2]|0;
  $20 = HEAP32[$2>>2]|0;
  $21 = (_sqlite3_prepare_v2($19,$20,-1,$pStmt,$zLeftover)|0);
  HEAP32[$rc>>2] = $21;
  $22 = HEAP32[$rc>>2]|0;
  $23 = ($22|0)!=(0);
  if ($23) {
   continue;
  }
  $24 = HEAP32[$pStmt>>2]|0;
  $25 = ($24|0)!=(0|0);
  if (!($25)) {
   $26 = HEAP32[$zLeftover>>2]|0;
   HEAP32[$2>>2] = $26;
   continue;
  }
  HEAP32[$callbackIsInit>>2] = 0;
  $27 = HEAP32[$pStmt>>2]|0;
  $28 = (_sqlite3_column_count($27)|0);
  HEAP32[$nCol>>2] = $28;
  while(1) {
   $29 = HEAP32[$pStmt>>2]|0;
   $30 = (_sqlite3_step($29)|0);
   HEAP32[$rc>>2] = $30;
   $31 = HEAP32[$3>>2]|0;
   $32 = ($31|0)!=(0|0);
   do {
    if ($32) {
     $33 = HEAP32[$rc>>2]|0;
     $34 = (100)==($33|0);
     if (!($34)) {
      $35 = HEAP32[$rc>>2]|0;
      $36 = (101)!=($35|0);
      $37 = HEAP32[$callbackIsInit>>2]|0;
      $38 = ($37|0)!=(0);
      $or$cond = $36 | $38;
      if ($or$cond) {
       break;
      }
      $39 = HEAP32[$1>>2]|0;
      $40 = ((($39)) + 24|0);
      $41 = HEAP32[$40>>2]|0;
      $42 = $41 & 256;
      $43 = ($42|0)!=(0);
      if (!($43)) {
       break;
      }
     }
     $44 = HEAP32[$callbackIsInit>>2]|0;
     $45 = ($44|0)!=(0);
     if (!($45)) {
      $46 = HEAP32[$1>>2]|0;
      $47 = HEAP32[$nCol>>2]|0;
      $48 = $47<<1;
      $49 = $48<<2;
      $50 = (($49) + 1)|0;
      $51 = (_sqlite3DbMallocZero($46,$50,0)|0);
      HEAP32[$azCols>>2] = $51;
      $52 = HEAP32[$azCols>>2]|0;
      $53 = ($52|0)==(0|0);
      if ($53) {
       break L8;
      }
      HEAP32[$i>>2] = 0;
      while(1) {
       $54 = HEAP32[$i>>2]|0;
       $55 = HEAP32[$nCol>>2]|0;
       $56 = ($54|0)<($55|0);
       if (!($56)) {
        break;
       }
       $57 = HEAP32[$pStmt>>2]|0;
       $58 = HEAP32[$i>>2]|0;
       $59 = (_sqlite3_column_name($57,$58)|0);
       $60 = HEAP32[$i>>2]|0;
       $61 = HEAP32[$azCols>>2]|0;
       $62 = (($61) + ($60<<2)|0);
       HEAP32[$62>>2] = $59;
       $63 = HEAP32[$i>>2]|0;
       $64 = (($63) + 1)|0;
       HEAP32[$i>>2] = $64;
      }
      HEAP32[$callbackIsInit>>2] = 1;
     }
     $65 = HEAP32[$rc>>2]|0;
     $66 = ($65|0)==(100);
     L32: do {
      if ($66) {
       $67 = HEAP32[$nCol>>2]|0;
       $68 = HEAP32[$azCols>>2]|0;
       $69 = (($68) + ($67<<2)|0);
       HEAP32[$azVals>>2] = $69;
       HEAP32[$i>>2] = 0;
       while(1) {
        $70 = HEAP32[$i>>2]|0;
        $71 = HEAP32[$nCol>>2]|0;
        $72 = ($70|0)<($71|0);
        if (!($72)) {
         break L32;
        }
        $73 = HEAP32[$pStmt>>2]|0;
        $74 = HEAP32[$i>>2]|0;
        $75 = (_sqlite3_column_text($73,$74)|0);
        $76 = HEAP32[$i>>2]|0;
        $77 = HEAP32[$azVals>>2]|0;
        $78 = (($77) + ($76<<2)|0);
        HEAP32[$78>>2] = $75;
        $79 = HEAP32[$i>>2]|0;
        $80 = HEAP32[$azVals>>2]|0;
        $81 = (($80) + ($79<<2)|0);
        $82 = HEAP32[$81>>2]|0;
        $83 = ($82|0)!=(0|0);
        if (!($83)) {
         $84 = HEAP32[$pStmt>>2]|0;
         $85 = HEAP32[$i>>2]|0;
         $86 = (_sqlite3_column_type($84,$85)|0);
         $87 = ($86|0)!=(5);
         if ($87) {
          label = 27;
          break L8;
         }
        }
        $89 = HEAP32[$i>>2]|0;
        $90 = (($89) + 1)|0;
        HEAP32[$i>>2] = $90;
       }
      }
     } while(0);
     $91 = HEAP32[$3>>2]|0;
     $92 = HEAP32[$4>>2]|0;
     $93 = HEAP32[$nCol>>2]|0;
     $94 = HEAP32[$azVals>>2]|0;
     $95 = HEAP32[$azCols>>2]|0;
     $96 = (FUNCTION_TABLE_iiiii[$91 & 255]($92,$93,$94,$95)|0);
     $97 = ($96|0)!=(0);
     if ($97) {
      label = 30;
      break L8;
     }
    }
   } while(0);
   $100 = HEAP32[$rc>>2]|0;
   $101 = ($100|0)!=(100);
   if ($101) {
    break;
   }
  }
  $102 = HEAP32[$pStmt>>2]|0;
  $103 = (_sqlite3VdbeFinalize($102)|0);
  HEAP32[$rc>>2] = $103;
  HEAP32[$pStmt>>2] = 0;
  $104 = HEAP32[$zLeftover>>2]|0;
  HEAP32[$2>>2] = $104;
  while(1) {
   $105 = HEAP32[$2>>2]|0;
   $106 = HEAP8[$105>>0]|0;
   $107 = $106&255;
   $108 = (18403 + ($107)|0);
   $109 = HEAP8[$108>>0]|0;
   $110 = $109&255;
   $111 = $110 & 1;
   $112 = ($111|0)!=(0);
   if (!($112)) {
    break;
   }
   $113 = HEAP32[$2>>2]|0;
   $114 = ((($113)) + 1|0);
   HEAP32[$2>>2] = $114;
  }
  $115 = HEAP32[$1>>2]|0;
  $116 = HEAP32[$azCols>>2]|0;
  _sqlite3DbFree($115,$116);
  HEAP32[$azCols>>2] = 0;
 }
 if ((label|0) == 27) {
  $88 = HEAP32[$1>>2]|0;
  _sqlite3OomFault($88);
 }
 else if ((label|0) == 30) {
  HEAP32[$rc>>2] = 4;
  $98 = HEAP32[$pStmt>>2]|0;
  (_sqlite3VdbeFinalize($98)|0);
  HEAP32[$pStmt>>2] = 0;
  $99 = HEAP32[$1>>2]|0;
  _sqlite3Error($99,4);
 }
 $117 = HEAP32[$pStmt>>2]|0;
 $118 = ($117|0)!=(0|0);
 if ($118) {
  $119 = HEAP32[$pStmt>>2]|0;
  (_sqlite3VdbeFinalize($119)|0);
 }
 $120 = HEAP32[$1>>2]|0;
 $121 = HEAP32[$azCols>>2]|0;
 _sqlite3DbFree($120,$121);
 $122 = HEAP32[$1>>2]|0;
 $123 = HEAP32[$rc>>2]|0;
 $124 = (_sqlite3ApiExit($122,$123)|0);
 HEAP32[$rc>>2] = $124;
 $125 = HEAP32[$rc>>2]|0;
 $126 = ($125|0)!=(0);
 $127 = HEAP32[$5>>2]|0;
 $128 = ($127|0)!=(0|0);
 $or$cond3 = $126 & $128;
 do {
  if ($or$cond3) {
   $129 = HEAP32[$1>>2]|0;
   $130 = (_sqlite3_errmsg($129)|0);
   $131 = (_sqlite3Strlen30($130)|0);
   $132 = (1 + ($131))|0;
   HEAP32[$nErrMsg>>2] = $132;
   $133 = HEAP32[$nErrMsg>>2]|0;
   $134 = ($133|0)<(0);
   $135 = $134 << 31 >> 31;
   $136 = (_sqlite3Malloc($133,$135)|0);
   $137 = HEAP32[$5>>2]|0;
   HEAP32[$137>>2] = $136;
   $138 = HEAP32[$5>>2]|0;
   $139 = HEAP32[$138>>2]|0;
   $140 = ($139|0)!=(0|0);
   if ($140) {
    $141 = HEAP32[$5>>2]|0;
    $142 = HEAP32[$141>>2]|0;
    $143 = HEAP32[$1>>2]|0;
    $144 = (_sqlite3_errmsg($143)|0);
    $145 = HEAP32[$nErrMsg>>2]|0;
    _memcpy(($142|0),($144|0),($145|0))|0;
    break;
   } else {
    HEAP32[$rc>>2] = 7;
    $146 = HEAP32[$1>>2]|0;
    _sqlite3Error($146,7);
    break;
   }
  } else {
   $147 = HEAP32[$5>>2]|0;
   $148 = ($147|0)!=(0|0);
   if ($148) {
    $149 = HEAP32[$5>>2]|0;
    HEAP32[$149>>2] = 0;
   }
  }
 } while(0);
 $150 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $150;
 $151 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($151|0);
}
function _sqlite3_prepare_v2($db,$zSql,$nBytes,$ppStmt,$pzTail) {
 $db = $db|0;
 $zSql = $zSql|0;
 $nBytes = $nBytes|0;
 $ppStmt = $ppStmt|0;
 $pzTail = $pzTail|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $2 = sp + 12|0;
 $3 = sp + 8|0;
 $4 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zSql;
 HEAP32[$2>>2] = $nBytes;
 HEAP32[$3>>2] = $ppStmt;
 HEAP32[$4>>2] = $pzTail;
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$1>>2]|0;
 $7 = HEAP32[$2>>2]|0;
 $8 = HEAP32[$3>>2]|0;
 $9 = HEAP32[$4>>2]|0;
 $10 = (_sqlite3LockAndPrepare($5,$6,$7,1,0,$8,$9)|0);
 HEAP32[$rc>>2] = $10;
 $11 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($11|0);
}
function _sqlite3_errmsg($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $z = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $z = sp;
 HEAP32[$1>>2] = $db;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  $4 = (_sqlite3ErrStr(7)|0);
  HEAP32[$0>>2] = $4;
  $26 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($26|0);
 }
 $5 = HEAP32[$1>>2]|0;
 $6 = (_sqlite3SafetyCheckSickOrOk($5)|0);
 $7 = ($6|0)!=(0);
 if (!($7)) {
  $8 = (_sqlite3MisuseError(140046)|0);
  $9 = (_sqlite3ErrStr($8)|0);
  HEAP32[$0>>2] = $9;
  $26 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($26|0);
 }
 $10 = HEAP32[$1>>2]|0;
 $11 = ((($10)) + 69|0);
 $12 = HEAP8[$11>>0]|0;
 $13 = ($12<<24>>24)!=(0);
 if ($13) {
  $14 = (_sqlite3ErrStr(7)|0);
  HEAP32[$z>>2] = $14;
 } else {
  $15 = HEAP32[$1>>2]|0;
  $16 = ((($15)) + 244|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (_sqlite3_value_text($17)|0);
  HEAP32[$z>>2] = $18;
  $19 = HEAP32[$z>>2]|0;
  $20 = ($19|0)==(0|0);
  if ($20) {
   $21 = HEAP32[$1>>2]|0;
   $22 = ((($21)) + 52|0);
   $23 = HEAP32[$22>>2]|0;
   $24 = (_sqlite3ErrStr($23)|0);
   HEAP32[$z>>2] = $24;
  }
 }
 $25 = HEAP32[$z>>2]|0;
 HEAP32[$0>>2] = $25;
 $26 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($26|0);
}
function _sqlite3_prepare($db,$zSql,$nBytes,$ppStmt,$pzTail) {
 $db = $db|0;
 $zSql = $zSql|0;
 $nBytes = $nBytes|0;
 $ppStmt = $ppStmt|0;
 $pzTail = $pzTail|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $2 = sp + 12|0;
 $3 = sp + 8|0;
 $4 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zSql;
 HEAP32[$2>>2] = $nBytes;
 HEAP32[$3>>2] = $ppStmt;
 HEAP32[$4>>2] = $pzTail;
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$1>>2]|0;
 $7 = HEAP32[$2>>2]|0;
 $8 = HEAP32[$3>>2]|0;
 $9 = HEAP32[$4>>2]|0;
 $10 = (_sqlite3LockAndPrepare($5,$6,$7,0,0,$8,$9)|0);
 HEAP32[$rc>>2] = $10;
 $11 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($11|0);
}
function _sqlite3_create_module($db,$zName,$pModule,$pAux) {
 $db = $db|0;
 $zName = $zName|0;
 $pModule = $pModule|0;
 $pAux = $pAux|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $3 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zName;
 HEAP32[$2>>2] = $pModule;
 HEAP32[$3>>2] = $pAux;
 $4 = HEAP32[$0>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = HEAP32[$2>>2]|0;
 $7 = HEAP32[$3>>2]|0;
 $8 = (_createModule($4,$5,$6,$7,0)|0);
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_create_module_v2($db,$zName,$pModule,$pAux,$xDestroy) {
 $db = $db|0;
 $zName = $zName|0;
 $pModule = $pModule|0;
 $pAux = $pAux|0;
 $xDestroy = $xDestroy|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $3 = sp + 4|0;
 $4 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zName;
 HEAP32[$2>>2] = $pModule;
 HEAP32[$3>>2] = $pAux;
 HEAP32[$4>>2] = $xDestroy;
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$1>>2]|0;
 $7 = HEAP32[$2>>2]|0;
 $8 = HEAP32[$3>>2]|0;
 $9 = HEAP32[$4>>2]|0;
 $10 = (_createModule($5,$6,$7,$8,$9)|0);
 STACKTOP = sp;return ($10|0);
}
function _sqlite3_declare_vtab($db,$zCreateTable) {
 $db = $db|0;
 $zCreateTable = $zCreateTable|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, $pCtx = 0, $pIdx = 0, $pNew = 0, $pParse = 0, $pTab = 0, $rc = 0, $vararg_buffer = 0, $zErr = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $vararg_buffer = sp;
 $0 = sp + 40|0;
 $1 = sp + 36|0;
 $2 = sp + 32|0;
 $pCtx = sp + 28|0;
 $pParse = sp + 24|0;
 $rc = sp + 20|0;
 $pTab = sp + 16|0;
 $zErr = sp + 12|0;
 $pNew = sp + 8|0;
 $pIdx = sp + 4|0;
 HEAP32[$1>>2] = $db;
 HEAP32[$2>>2] = $zCreateTable;
 HEAP32[$rc>>2] = 0;
 HEAP32[$zErr>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ((($3)) + 336|0);
 $5 = HEAP32[$4>>2]|0;
 HEAP32[$pCtx>>2] = $5;
 $6 = HEAP32[$pCtx>>2]|0;
 $7 = ($6|0)!=(0|0);
 if ($7) {
  $8 = HEAP32[$pCtx>>2]|0;
  $9 = ((($8)) + 12|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = ($10|0)!=(0);
  if (!($11)) {
   $14 = HEAP32[$pCtx>>2]|0;
   $15 = ((($14)) + 4|0);
   $16 = HEAP32[$15>>2]|0;
   HEAP32[$pTab>>2] = $16;
   $17 = HEAP32[$1>>2]|0;
   $18 = (_sqlite3DbMallocZero($17,480,0)|0);
   HEAP32[$pParse>>2] = $18;
   $19 = HEAP32[$pParse>>2]|0;
   $20 = ($19|0)==(0|0);
   if ($20) {
    HEAP32[$rc>>2] = 7;
   } else {
    $21 = HEAP32[$pParse>>2]|0;
    $22 = ((($21)) + 410|0);
    HEAP8[$22>>0] = 1;
    $23 = HEAP32[$1>>2]|0;
    $24 = HEAP32[$pParse>>2]|0;
    HEAP32[$24>>2] = $23;
    $25 = HEAP32[$pParse>>2]|0;
    $26 = ((($25)) + 136|0);
    HEAP32[$26>>2] = 1;
    $27 = HEAP32[$pParse>>2]|0;
    $28 = HEAP32[$2>>2]|0;
    $29 = (_sqlite3RunParser($27,$28,$zErr)|0);
    $30 = (0)==($29|0);
    if ($30) {
     $31 = HEAP32[$pParse>>2]|0;
     $32 = ((($31)) + 440|0);
     $33 = HEAP32[$32>>2]|0;
     $34 = ($33|0)!=(0|0);
     if ($34) {
      $35 = HEAP32[$1>>2]|0;
      $36 = ((($35)) + 69|0);
      $37 = HEAP8[$36>>0]|0;
      $38 = ($37<<24>>24)!=(0);
      if ($38) {
       label = 18;
      } else {
       $39 = HEAP32[$pParse>>2]|0;
       $40 = ((($39)) + 440|0);
       $41 = HEAP32[$40>>2]|0;
       $42 = ((($41)) + 12|0);
       $43 = HEAP32[$42>>2]|0;
       $44 = ($43|0)!=(0|0);
       if ($44) {
        label = 18;
       } else {
        $45 = HEAP32[$pParse>>2]|0;
        $46 = ((($45)) + 440|0);
        $47 = HEAP32[$46>>2]|0;
        $48 = ((($47)) + 42|0);
        $49 = HEAP8[$48>>0]|0;
        $50 = $49&255;
        $51 = $50 & 16;
        $52 = ($51|0)==(0);
        if ($52) {
         $53 = HEAP32[$pTab>>2]|0;
         $54 = ((($53)) + 4|0);
         $55 = HEAP32[$54>>2]|0;
         $56 = ($55|0)!=(0|0);
         if (!($56)) {
          $57 = HEAP32[$pParse>>2]|0;
          $58 = ((($57)) + 440|0);
          $59 = HEAP32[$58>>2]|0;
          HEAP32[$pNew>>2] = $59;
          $60 = HEAP32[$pNew>>2]|0;
          $61 = ((($60)) + 4|0);
          $62 = HEAP32[$61>>2]|0;
          $63 = HEAP32[$pTab>>2]|0;
          $64 = ((($63)) + 4|0);
          HEAP32[$64>>2] = $62;
          $65 = HEAP32[$pNew>>2]|0;
          $66 = ((($65)) + 34|0);
          $67 = HEAP16[$66>>1]|0;
          $68 = HEAP32[$pTab>>2]|0;
          $69 = ((($68)) + 34|0);
          HEAP16[$69>>1] = $67;
          $70 = HEAP32[$pNew>>2]|0;
          $71 = ((($70)) + 42|0);
          $72 = HEAP8[$71>>0]|0;
          $73 = $72&255;
          $74 = $73 & 96;
          $75 = HEAP32[$pTab>>2]|0;
          $76 = ((($75)) + 42|0);
          $77 = HEAP8[$76>>0]|0;
          $78 = $77&255;
          $79 = $78 | $74;
          $80 = $79&255;
          HEAP8[$76>>0] = $80;
          $81 = HEAP32[$pNew>>2]|0;
          $82 = ((($81)) + 34|0);
          HEAP16[$82>>1] = 0;
          $83 = HEAP32[$pNew>>2]|0;
          $84 = ((($83)) + 4|0);
          HEAP32[$84>>2] = 0;
          $85 = HEAP32[$pNew>>2]|0;
          $86 = ((($85)) + 42|0);
          $87 = HEAP8[$86>>0]|0;
          $88 = $87&255;
          $89 = $88 & 32;
          $90 = ($89|0)==(0);
          if (!($90)) {
           $91 = HEAP32[$pCtx>>2]|0;
           $92 = HEAP32[$91>>2]|0;
           $93 = ((($92)) + 4|0);
           $94 = HEAP32[$93>>2]|0;
           $95 = HEAP32[$94>>2]|0;
           $96 = ((($95)) + 52|0);
           $97 = HEAP32[$96>>2]|0;
           $98 = ($97|0)!=(0|0);
           if ($98) {
            HEAP32[$rc>>2] = 1;
           }
          }
          $99 = HEAP32[$pNew>>2]|0;
          $100 = ((($99)) + 8|0);
          $101 = HEAP32[$100>>2]|0;
          HEAP32[$pIdx>>2] = $101;
          $102 = HEAP32[$pIdx>>2]|0;
          $103 = ($102|0)!=(0|0);
          if ($103) {
           $104 = HEAP32[$pIdx>>2]|0;
           $105 = HEAP32[$pTab>>2]|0;
           $106 = ((($105)) + 8|0);
           HEAP32[$106>>2] = $104;
           $107 = HEAP32[$pNew>>2]|0;
           $108 = ((($107)) + 8|0);
           HEAP32[$108>>2] = 0;
           $109 = HEAP32[$pTab>>2]|0;
           $110 = HEAP32[$pIdx>>2]|0;
           $111 = ((($110)) + 12|0);
           HEAP32[$111>>2] = $109;
          }
         }
         $112 = HEAP32[$pCtx>>2]|0;
         $113 = ((($112)) + 12|0);
         HEAP32[$113>>2] = 1;
        } else {
         label = 18;
        }
       }
      }
     } else {
      label = 18;
     }
    } else {
     label = 18;
    }
    if ((label|0) == 18) {
     $114 = HEAP32[$1>>2]|0;
     $115 = HEAP32[$zErr>>2]|0;
     $116 = ($115|0)!=(0|0);
     $117 = $116 ? 18391 : 0;
     $118 = HEAP32[$zErr>>2]|0;
     HEAP32[$vararg_buffer>>2] = $118;
     _sqlite3ErrorWithMsg($114,1,$117,$vararg_buffer);
     $119 = HEAP32[$1>>2]|0;
     $120 = HEAP32[$zErr>>2]|0;
     _sqlite3DbFree($119,$120);
     HEAP32[$rc>>2] = 1;
    }
    $121 = HEAP32[$pParse>>2]|0;
    $122 = ((($121)) + 410|0);
    HEAP8[$122>>0] = 0;
    $123 = HEAP32[$pParse>>2]|0;
    $124 = ((($123)) + 8|0);
    $125 = HEAP32[$124>>2]|0;
    $126 = ($125|0)!=(0|0);
    if ($126) {
     $127 = HEAP32[$pParse>>2]|0;
     $128 = ((($127)) + 8|0);
     $129 = HEAP32[$128>>2]|0;
     (_sqlite3VdbeFinalize($129)|0);
    }
    $130 = HEAP32[$1>>2]|0;
    $131 = HEAP32[$pParse>>2]|0;
    $132 = ((($131)) + 440|0);
    $133 = HEAP32[$132>>2]|0;
    _sqlite3DeleteTable($130,$133);
    $134 = HEAP32[$pParse>>2]|0;
    _sqlite3ParserReset($134);
    $135 = HEAP32[$1>>2]|0;
    $136 = HEAP32[$pParse>>2]|0;
    _sqlite3DbFree($135,$136);
   }
   $137 = HEAP32[$1>>2]|0;
   $138 = HEAP32[$rc>>2]|0;
   $139 = (_sqlite3ApiExit($137,$138)|0);
   HEAP32[$rc>>2] = $139;
   $140 = HEAP32[$rc>>2]|0;
   HEAP32[$0>>2] = $140;
   $141 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($141|0);
  }
 }
 $12 = HEAP32[$1>>2]|0;
 _sqlite3Error($12,21);
 $13 = (_sqlite3MisuseError(123278)|0);
 HEAP32[$0>>2] = $13;
 $141 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($141|0);
}
function _sqlite3_vtab_on_conflict($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 74|0);
 $3 = HEAP8[$2>>0]|0;
 $4 = $3&255;
 $5 = (($4) - 1)|0;
 $6 = (18659 + ($5)|0);
 $7 = HEAP8[$6>>0]|0;
 $8 = $7&255;
 STACKTOP = sp;return ($8|0);
}
function _sqlite3_vtab_config($db,$op,$varargs) {
 $db = $db|0;
 $op = $op|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ap = 0, $arglist_current = 0, $arglist_next = 0, $cond = 0, $expanded = 0, $expanded2 = 0, $expanded4 = 0, $expanded5 = 0, $expanded6 = 0, $p = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $ap = sp + 8|0;
 $rc = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $op;
 HEAP32[$rc>>2] = 0;
 HEAP32[$ap>>2] = $varargs;
 $2 = HEAP32[$1>>2]|0;
 $cond = ($2|0)==(1);
 do {
  if ($cond) {
   $3 = HEAP32[$0>>2]|0;
   $4 = ((($3)) + 336|0);
   $5 = HEAP32[$4>>2]|0;
   HEAP32[$p>>2] = $5;
   $6 = HEAP32[$p>>2]|0;
   $7 = ($6|0)!=(0|0);
   if ($7) {
    $arglist_current = HEAP32[$ap>>2]|0;
    $9 = $arglist_current;
    $10 = ((0) + 4|0);
    $expanded2 = $10;
    $expanded = (($expanded2) - 1)|0;
    $11 = (($9) + ($expanded))|0;
    $12 = ((0) + 4|0);
    $expanded6 = $12;
    $expanded5 = (($expanded6) - 1)|0;
    $expanded4 = $expanded5 ^ -1;
    $13 = $11 & $expanded4;
    $14 = $13;
    $15 = HEAP32[$14>>2]|0;
    $arglist_next = ((($14)) + 4|0);
    HEAP32[$ap>>2] = $arglist_next;
    $16 = $15&255;
    $17 = HEAP32[$p>>2]|0;
    $18 = HEAP32[$17>>2]|0;
    $19 = ((($18)) + 16|0);
    HEAP8[$19>>0] = $16;
    break;
   } else {
    $8 = (_sqlite3MisuseError(123749)|0);
    HEAP32[$rc>>2] = $8;
    break;
   }
  } else {
   $20 = (_sqlite3MisuseError(123757)|0);
   HEAP32[$rc>>2] = $20;
  }
 } while(0);
 $21 = HEAP32[$rc>>2]|0;
 $22 = ($21|0)!=(0);
 if (!($22)) {
  $25 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($25|0);
 }
 $23 = HEAP32[$0>>2]|0;
 $24 = HEAP32[$rc>>2]|0;
 _sqlite3Error($23,$24);
 $25 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($25|0);
}
function _sqlite3_libversion() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return (17598|0);
}
function _sqlite3_sourceid() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return (18677|0);
}
function _sqlite3_libversion_number() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return 3015001;
}
function _sqlite3_config($op,$varargs) {
 $op = $op|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0;
 var $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0;
 var $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ap = 0, $arglist_current = 0, $arglist_current12 = 0, $arglist_current15 = 0, $arglist_current18 = 0, $arglist_current21 = 0, $arglist_current24 = 0, $arglist_current27 = 0, $arglist_current3 = 0;
 var $arglist_current30 = 0, $arglist_current33 = 0, $arglist_current36 = 0, $arglist_current39 = 0, $arglist_current42 = 0, $arglist_current45 = 0, $arglist_current48 = 0, $arglist_current51 = 0, $arglist_current54 = 0, $arglist_current57 = 0, $arglist_current6 = 0, $arglist_current60 = 0, $arglist_current63 = 0, $arglist_current9 = 0, $arglist_next = 0, $arglist_next10 = 0, $arglist_next13 = 0, $arglist_next16 = 0, $arglist_next19 = 0, $arglist_next22 = 0;
 var $arglist_next25 = 0, $arglist_next28 = 0, $arglist_next31 = 0, $arglist_next34 = 0, $arglist_next37 = 0, $arglist_next4 = 0, $arglist_next40 = 0, $arglist_next43 = 0, $arglist_next46 = 0, $arglist_next49 = 0, $arglist_next52 = 0, $arglist_next55 = 0, $arglist_next58 = 0, $arglist_next61 = 0, $arglist_next64 = 0, $arglist_next7 = 0, $expanded = 0, $expanded100 = 0, $expanded102 = 0, $expanded103 = 0;
 var $expanded104 = 0, $expanded106 = 0, $expanded107 = 0, $expanded109 = 0, $expanded11 = 0, $expanded110 = 0, $expanded111 = 0, $expanded113 = 0, $expanded114 = 0, $expanded116 = 0, $expanded117 = 0, $expanded118 = 0, $expanded12 = 0, $expanded120 = 0, $expanded121 = 0, $expanded123 = 0, $expanded124 = 0, $expanded125 = 0, $expanded127 = 0, $expanded128 = 0;
 var $expanded13 = 0, $expanded130 = 0, $expanded131 = 0, $expanded132 = 0, $expanded134 = 0, $expanded135 = 0, $expanded137 = 0, $expanded138 = 0, $expanded139 = 0, $expanded141 = 0, $expanded142 = 0, $expanded144 = 0, $expanded145 = 0, $expanded146 = 0, $expanded148 = 0, $expanded149 = 0, $expanded15 = 0, $expanded151 = 0, $expanded152 = 0, $expanded153 = 0;
 var $expanded16 = 0, $expanded18 = 0, $expanded19 = 0, $expanded2 = 0, $expanded20 = 0, $expanded22 = 0, $expanded23 = 0, $expanded25 = 0, $expanded26 = 0, $expanded27 = 0, $expanded29 = 0, $expanded30 = 0, $expanded32 = 0, $expanded33 = 0, $expanded34 = 0, $expanded36 = 0, $expanded37 = 0, $expanded39 = 0, $expanded4 = 0, $expanded40 = 0;
 var $expanded41 = 0, $expanded43 = 0, $expanded44 = 0, $expanded46 = 0, $expanded47 = 0, $expanded48 = 0, $expanded5 = 0, $expanded50 = 0, $expanded51 = 0, $expanded53 = 0, $expanded54 = 0, $expanded55 = 0, $expanded57 = 0, $expanded58 = 0, $expanded6 = 0, $expanded60 = 0, $expanded61 = 0, $expanded62 = 0, $expanded64 = 0, $expanded65 = 0;
 var $expanded67 = 0, $expanded68 = 0, $expanded69 = 0, $expanded71 = 0, $expanded72 = 0, $expanded74 = 0, $expanded75 = 0, $expanded76 = 0, $expanded78 = 0, $expanded79 = 0, $expanded8 = 0, $expanded81 = 0, $expanded82 = 0, $expanded83 = 0, $expanded85 = 0, $expanded86 = 0, $expanded88 = 0, $expanded89 = 0, $expanded9 = 0, $expanded90 = 0;
 var $expanded92 = 0, $expanded93 = 0, $expanded95 = 0, $expanded96 = 0, $expanded97 = 0, $expanded99 = 0, $mxMmap = 0, $or$cond = 0, $rc = 0, $szMmap = 0, dest = 0, label = 0, sp = 0, src = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 44|0;
 $1 = sp + 40|0;
 $ap = sp + 24|0;
 $rc = sp + 16|0;
 $szMmap = sp + 8|0;
 $mxMmap = sp;
 HEAP32[$1>>2] = $op;
 HEAP32[$rc>>2] = 0;
 $2 = HEAP32[(236)>>2]|0;
 $3 = ($2|0)!=(0);
 if ($3) {
  $4 = (_sqlite3MisuseError(138190)|0);
  HEAP32[$0>>2] = $4;
  $270 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($270|0);
 }
 HEAP32[$ap>>2] = $varargs;
 $5 = HEAP32[$1>>2]|0;
 do {
  switch ($5|0) {
  case 4:  {
   $arglist_current = HEAP32[$ap>>2]|0;
   $6 = $arglist_current;
   $7 = ((0) + 4|0);
   $expanded2 = $7;
   $expanded = (($expanded2) - 1)|0;
   $8 = (($6) + ($expanded))|0;
   $9 = ((0) + 4|0);
   $expanded6 = $9;
   $expanded5 = (($expanded6) - 1)|0;
   $expanded4 = $expanded5 ^ -1;
   $10 = $8 & $expanded4;
   $11 = $10;
   $12 = HEAP32[$11>>2]|0;
   $arglist_next = ((($11)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next;
   ;HEAP32[(48)>>2]=HEAP32[$12>>2]|0;HEAP32[(48)+4>>2]=HEAP32[$12+4>>2]|0;HEAP32[(48)+8>>2]=HEAP32[$12+8>>2]|0;HEAP32[(48)+12>>2]=HEAP32[$12+12>>2]|0;HEAP32[(48)+16>>2]=HEAP32[$12+16>>2]|0;HEAP32[(48)+20>>2]=HEAP32[$12+20>>2]|0;HEAP32[(48)+24>>2]=HEAP32[$12+24>>2]|0;HEAP32[(48)+28>>2]=HEAP32[$12+28>>2]|0;
   break;
  }
  case 5:  {
   $13 = HEAP32[(48)>>2]|0;
   $14 = ($13|0)==(0|0);
   if ($14) {
    _sqlite3MemSetDefault();
   }
   $arglist_current3 = HEAP32[$ap>>2]|0;
   $15 = $arglist_current3;
   $16 = ((0) + 4|0);
   $expanded9 = $16;
   $expanded8 = (($expanded9) - 1)|0;
   $17 = (($15) + ($expanded8))|0;
   $18 = ((0) + 4|0);
   $expanded13 = $18;
   $expanded12 = (($expanded13) - 1)|0;
   $expanded11 = $expanded12 ^ -1;
   $19 = $17 & $expanded11;
   $20 = $19;
   $21 = HEAP32[$20>>2]|0;
   $arglist_next4 = ((($20)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next4;
   ;HEAP32[$21>>2]=HEAP32[(48)>>2]|0;HEAP32[$21+4>>2]=HEAP32[(48)+4>>2]|0;HEAP32[$21+8>>2]=HEAP32[(48)+8>>2]|0;HEAP32[$21+12>>2]=HEAP32[(48)+12>>2]|0;HEAP32[$21+16>>2]=HEAP32[(48)+16>>2]|0;HEAP32[$21+20>>2]=HEAP32[(48)+20>>2]|0;HEAP32[$21+24>>2]=HEAP32[(48)+24>>2]|0;HEAP32[$21+28>>2]=HEAP32[(48)+28>>2]|0;
   break;
  }
  case 9:  {
   $arglist_current6 = HEAP32[$ap>>2]|0;
   $22 = $arglist_current6;
   $23 = ((0) + 4|0);
   $expanded16 = $23;
   $expanded15 = (($expanded16) - 1)|0;
   $24 = (($22) + ($expanded15))|0;
   $25 = ((0) + 4|0);
   $expanded20 = $25;
   $expanded19 = (($expanded20) - 1)|0;
   $expanded18 = $expanded19 ^ -1;
   $26 = $24 & $expanded18;
   $27 = $26;
   $28 = HEAP32[$27>>2]|0;
   $arglist_next7 = ((($27)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next7;
   HEAP32[8>>2] = $28;
   break;
  }
  case 6:  {
   $arglist_current9 = HEAP32[$ap>>2]|0;
   $29 = $arglist_current9;
   $30 = ((0) + 4|0);
   $expanded23 = $30;
   $expanded22 = (($expanded23) - 1)|0;
   $31 = (($29) + ($expanded22))|0;
   $32 = ((0) + 4|0);
   $expanded27 = $32;
   $expanded26 = (($expanded27) - 1)|0;
   $expanded25 = $expanded26 ^ -1;
   $33 = $31 & $expanded25;
   $34 = $33;
   $35 = HEAP32[$34>>2]|0;
   $arglist_next10 = ((($34)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next10;
   HEAP32[(200)>>2] = $35;
   $arglist_current12 = HEAP32[$ap>>2]|0;
   $36 = $arglist_current12;
   $37 = ((0) + 4|0);
   $expanded30 = $37;
   $expanded29 = (($expanded30) - 1)|0;
   $38 = (($36) + ($expanded29))|0;
   $39 = ((0) + 4|0);
   $expanded34 = $39;
   $expanded33 = (($expanded34) - 1)|0;
   $expanded32 = $expanded33 ^ -1;
   $40 = $38 & $expanded32;
   $41 = $40;
   $42 = HEAP32[$41>>2]|0;
   $arglist_next13 = ((($41)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next13;
   HEAP32[(204)>>2] = $42;
   $arglist_current15 = HEAP32[$ap>>2]|0;
   $43 = $arglist_current15;
   $44 = ((0) + 4|0);
   $expanded37 = $44;
   $expanded36 = (($expanded37) - 1)|0;
   $45 = (($43) + ($expanded36))|0;
   $46 = ((0) + 4|0);
   $expanded41 = $46;
   $expanded40 = (($expanded41) - 1)|0;
   $expanded39 = $expanded40 ^ -1;
   $47 = $45 & $expanded39;
   $48 = $47;
   $49 = HEAP32[$48>>2]|0;
   $arglist_next16 = ((($48)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next16;
   HEAP32[(208)>>2] = $49;
   break;
  }
  case 7:  {
   $arglist_current18 = HEAP32[$ap>>2]|0;
   $50 = $arglist_current18;
   $51 = ((0) + 4|0);
   $expanded44 = $51;
   $expanded43 = (($expanded44) - 1)|0;
   $52 = (($50) + ($expanded43))|0;
   $53 = ((0) + 4|0);
   $expanded48 = $53;
   $expanded47 = (($expanded48) - 1)|0;
   $expanded46 = $expanded47 ^ -1;
   $54 = $52 & $expanded46;
   $55 = $54;
   $56 = HEAP32[$55>>2]|0;
   $arglist_next19 = ((($55)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next19;
   HEAP32[(212)>>2] = $56;
   $arglist_current21 = HEAP32[$ap>>2]|0;
   $57 = $arglist_current21;
   $58 = ((0) + 4|0);
   $expanded51 = $58;
   $expanded50 = (($expanded51) - 1)|0;
   $59 = (($57) + ($expanded50))|0;
   $60 = ((0) + 4|0);
   $expanded55 = $60;
   $expanded54 = (($expanded55) - 1)|0;
   $expanded53 = $expanded54 ^ -1;
   $61 = $59 & $expanded53;
   $62 = $61;
   $63 = HEAP32[$62>>2]|0;
   $arglist_next22 = ((($62)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next22;
   HEAP32[(216)>>2] = $63;
   $arglist_current24 = HEAP32[$ap>>2]|0;
   $64 = $arglist_current24;
   $65 = ((0) + 4|0);
   $expanded58 = $65;
   $expanded57 = (($expanded58) - 1)|0;
   $66 = (($64) + ($expanded57))|0;
   $67 = ((0) + 4|0);
   $expanded62 = $67;
   $expanded61 = (($expanded62) - 1)|0;
   $expanded60 = $expanded61 ^ -1;
   $68 = $66 & $expanded60;
   $69 = $68;
   $70 = HEAP32[$69>>2]|0;
   $arglist_next25 = ((($69)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next25;
   HEAP32[(220)>>2] = $70;
   break;
  }
  case 24:  {
   $71 = (_sqlite3HeaderSizeBtree()|0);
   $72 = (_sqlite3HeaderSizePcache()|0);
   $73 = (($71) + ($72))|0;
   $74 = (_sqlite3HeaderSizePcache1()|0);
   $75 = (($73) + ($74))|0;
   $arglist_current27 = HEAP32[$ap>>2]|0;
   $76 = $arglist_current27;
   $77 = ((0) + 4|0);
   $expanded65 = $77;
   $expanded64 = (($expanded65) - 1)|0;
   $78 = (($76) + ($expanded64))|0;
   $79 = ((0) + 4|0);
   $expanded69 = $79;
   $expanded68 = (($expanded69) - 1)|0;
   $expanded67 = $expanded68 ^ -1;
   $80 = $78 & $expanded67;
   $81 = $80;
   $82 = HEAP32[$81>>2]|0;
   $arglist_next28 = ((($81)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next28;
   HEAP32[$82>>2] = $75;
   break;
  }
  case 14:  {
   break;
  }
  case 15:  {
   HEAP32[$rc>>2] = 1;
   break;
  }
  case 18:  {
   $arglist_current30 = HEAP32[$ap>>2]|0;
   $83 = $arglist_current30;
   $84 = ((0) + 4|0);
   $expanded72 = $84;
   $expanded71 = (($expanded72) - 1)|0;
   $85 = (($83) + ($expanded71))|0;
   $86 = ((0) + 4|0);
   $expanded76 = $86;
   $expanded75 = (($expanded76) - 1)|0;
   $expanded74 = $expanded75 ^ -1;
   $87 = $85 & $expanded74;
   $88 = $87;
   $89 = HEAP32[$88>>2]|0;
   $arglist_next31 = ((($88)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next31;
   dest=(116); src=$89; stop=dest+52|0; do { HEAP32[dest>>2]=HEAP32[src>>2]|0; dest=dest+4|0; src=src+4|0; } while ((dest|0) < (stop|0));
   break;
  }
  case 19:  {
   $90 = HEAP32[(124)>>2]|0;
   $91 = ($90|0)==(0|0);
   if ($91) {
    _sqlite3PCacheSetDefault();
   }
   $arglist_current33 = HEAP32[$ap>>2]|0;
   $92 = $arglist_current33;
   $93 = ((0) + 4|0);
   $expanded79 = $93;
   $expanded78 = (($expanded79) - 1)|0;
   $94 = (($92) + ($expanded78))|0;
   $95 = ((0) + 4|0);
   $expanded83 = $95;
   $expanded82 = (($expanded83) - 1)|0;
   $expanded81 = $expanded82 ^ -1;
   $96 = $94 & $expanded81;
   $97 = $96;
   $98 = HEAP32[$97>>2]|0;
   $arglist_next34 = ((($97)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next34;
   dest=$98; src=(116); stop=dest+52|0; do { HEAP32[dest>>2]=HEAP32[src>>2]|0; dest=dest+4|0; src=src+4|0; } while ((dest|0) < (stop|0));
   break;
  }
  case 13:  {
   $arglist_current36 = HEAP32[$ap>>2]|0;
   $99 = $arglist_current36;
   $100 = ((0) + 4|0);
   $expanded86 = $100;
   $expanded85 = (($expanded86) - 1)|0;
   $101 = (($99) + ($expanded85))|0;
   $102 = ((0) + 4|0);
   $expanded90 = $102;
   $expanded89 = (($expanded90) - 1)|0;
   $expanded88 = $expanded89 ^ -1;
   $103 = $101 & $expanded88;
   $104 = $103;
   $105 = HEAP32[$104>>2]|0;
   $arglist_next37 = ((($104)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next37;
   HEAP32[(36)>>2] = $105;
   $arglist_current39 = HEAP32[$ap>>2]|0;
   $106 = $arglist_current39;
   $107 = ((0) + 4|0);
   $expanded93 = $107;
   $expanded92 = (($expanded93) - 1)|0;
   $108 = (($106) + ($expanded92))|0;
   $109 = ((0) + 4|0);
   $expanded97 = $109;
   $expanded96 = (($expanded97) - 1)|0;
   $expanded95 = $expanded96 ^ -1;
   $110 = $108 & $expanded95;
   $111 = $110;
   $112 = HEAP32[$111>>2]|0;
   $arglist_next40 = ((($111)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next40;
   HEAP32[(40)>>2] = $112;
   break;
  }
  case 16:  {
   $arglist_current42 = HEAP32[$ap>>2]|0;
   $113 = $arglist_current42;
   $114 = ((0) + 4|0);
   $expanded100 = $114;
   $expanded99 = (($expanded100) - 1)|0;
   $115 = (($113) + ($expanded99))|0;
   $116 = ((0) + 4|0);
   $expanded104 = $116;
   $expanded103 = (($expanded104) - 1)|0;
   $expanded102 = $expanded103 ^ -1;
   $117 = $115 & $expanded102;
   $118 = $117;
   $119 = HEAP32[$118>>2]|0;
   $arglist_next43 = ((($118)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next43;
   HEAP32[(264)>>2] = $119;
   $arglist_current45 = HEAP32[$ap>>2]|0;
   $120 = $arglist_current45;
   $121 = ((0) + 4|0);
   $expanded107 = $121;
   $expanded106 = (($expanded107) - 1)|0;
   $122 = (($120) + ($expanded106))|0;
   $123 = ((0) + 4|0);
   $expanded111 = $123;
   $expanded110 = (($expanded111) - 1)|0;
   $expanded109 = $expanded110 ^ -1;
   $124 = $122 & $expanded109;
   $125 = $124;
   $126 = HEAP32[$125>>2]|0;
   $arglist_next46 = ((($125)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next46;
   HEAP32[(268)>>2] = $126;
   break;
  }
  case 17:  {
   $arglist_current48 = HEAP32[$ap>>2]|0;
   $127 = $arglist_current48;
   $128 = ((0) + 4|0);
   $expanded114 = $128;
   $expanded113 = (($expanded114) - 1)|0;
   $129 = (($127) + ($expanded113))|0;
   $130 = ((0) + 4|0);
   $expanded118 = $130;
   $expanded117 = (($expanded118) - 1)|0;
   $expanded116 = $expanded117 ^ -1;
   $131 = $129 & $expanded116;
   $132 = $131;
   $133 = HEAP32[$132>>2]|0;
   $arglist_next49 = ((($132)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next49;
   HEAP32[(20)>>2] = $133;
   break;
  }
  case 20:  {
   $arglist_current51 = HEAP32[$ap>>2]|0;
   $134 = $arglist_current51;
   $135 = ((0) + 4|0);
   $expanded121 = $135;
   $expanded120 = (($expanded121) - 1)|0;
   $136 = (($134) + ($expanded120))|0;
   $137 = ((0) + 4|0);
   $expanded125 = $137;
   $expanded124 = (($expanded125) - 1)|0;
   $expanded123 = $expanded124 ^ -1;
   $138 = $136 & $expanded123;
   $139 = $138;
   $140 = HEAP32[$139>>2]|0;
   $arglist_next52 = ((($139)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next52;
   HEAP32[(24)>>2] = $140;
   break;
  }
  case 22:  {
   $arglist_current54 = HEAP32[$ap>>2]|0;
   $141 = $arglist_current54;
   $142 = ((0) + 8|0);
   $expanded128 = $142;
   $expanded127 = (($expanded128) - 1)|0;
   $143 = (($141) + ($expanded127))|0;
   $144 = ((0) + 8|0);
   $expanded132 = $144;
   $expanded131 = (($expanded132) - 1)|0;
   $expanded130 = $expanded131 ^ -1;
   $145 = $143 & $expanded130;
   $146 = $145;
   $147 = $146;
   $148 = $147;
   $149 = HEAP32[$148>>2]|0;
   $150 = (($147) + 4)|0;
   $151 = $150;
   $152 = HEAP32[$151>>2]|0;
   $arglist_next55 = ((($146)) + 8|0);
   HEAP32[$ap>>2] = $arglist_next55;
   $153 = $szMmap;
   $154 = $153;
   HEAP32[$154>>2] = $149;
   $155 = (($153) + 4)|0;
   $156 = $155;
   HEAP32[$156>>2] = $152;
   $arglist_current57 = HEAP32[$ap>>2]|0;
   $157 = $arglist_current57;
   $158 = ((0) + 8|0);
   $expanded135 = $158;
   $expanded134 = (($expanded135) - 1)|0;
   $159 = (($157) + ($expanded134))|0;
   $160 = ((0) + 8|0);
   $expanded139 = $160;
   $expanded138 = (($expanded139) - 1)|0;
   $expanded137 = $expanded138 ^ -1;
   $161 = $159 & $expanded137;
   $162 = $161;
   $163 = $162;
   $164 = $163;
   $165 = HEAP32[$164>>2]|0;
   $166 = (($163) + 4)|0;
   $167 = $166;
   $168 = HEAP32[$167>>2]|0;
   $arglist_next58 = ((($162)) + 8|0);
   HEAP32[$ap>>2] = $arglist_next58;
   $169 = $mxMmap;
   $170 = $169;
   HEAP32[$170>>2] = $165;
   $171 = (($169) + 4)|0;
   $172 = $171;
   HEAP32[$172>>2] = $168;
   $173 = $mxMmap;
   $174 = $173;
   $175 = HEAP32[$174>>2]|0;
   $176 = (($173) + 4)|0;
   $177 = $176;
   $178 = HEAP32[$177>>2]|0;
   $179 = ($178|0)<(0);
   $180 = $mxMmap;
   $181 = $180;
   $182 = HEAP32[$181>>2]|0;
   $183 = (($180) + 4)|0;
   $184 = $183;
   $185 = HEAP32[$184>>2]|0;
   $186 = ($185|0)>(0);
   $187 = ($182>>>0)>(0);
   $188 = ($185|0)==(0);
   $189 = $188 & $187;
   $190 = $186 | $189;
   $or$cond = $179 | $190;
   $191 = $or$cond ? 0 : $165;
   $192 = $or$cond ? 0 : $168;
   $193 = $mxMmap;
   $194 = $193;
   HEAP32[$194>>2] = $191;
   $195 = (($193) + 4)|0;
   $196 = $195;
   HEAP32[$196>>2] = $192;
   $197 = $szMmap;
   $198 = $197;
   $199 = HEAP32[$198>>2]|0;
   $200 = (($197) + 4)|0;
   $201 = $200;
   $202 = HEAP32[$201>>2]|0;
   $203 = ($202|0)<(0);
   if ($203) {
    $204 = $szMmap;
    $205 = $204;
    HEAP32[$205>>2] = 0;
    $206 = (($204) + 4)|0;
    $207 = $206;
    HEAP32[$207>>2] = 0;
   }
   $208 = $szMmap;
   $209 = $208;
   $210 = HEAP32[$209>>2]|0;
   $211 = (($208) + 4)|0;
   $212 = $211;
   $213 = HEAP32[$212>>2]|0;
   $214 = $mxMmap;
   $215 = $214;
   $216 = HEAP32[$215>>2]|0;
   $217 = (($214) + 4)|0;
   $218 = $217;
   $219 = HEAP32[$218>>2]|0;
   $220 = ($213|0)>($219|0);
   $221 = ($210>>>0)>($216>>>0);
   $222 = ($213|0)==($219|0);
   $223 = $222 & $221;
   $224 = $220 | $223;
   if ($224) {
    $225 = $mxMmap;
    $226 = $225;
    $227 = HEAP32[$226>>2]|0;
    $228 = (($225) + 4)|0;
    $229 = $228;
    $230 = HEAP32[$229>>2]|0;
    $231 = $szMmap;
    $232 = $231;
    HEAP32[$232>>2] = $227;
    $233 = (($231) + 4)|0;
    $234 = $233;
    HEAP32[$234>>2] = $230;
   }
   $235 = $mxMmap;
   $236 = $235;
   $237 = HEAP32[$236>>2]|0;
   $238 = (($235) + 4)|0;
   $239 = $238;
   $240 = HEAP32[$239>>2]|0;
   $241 = (192);
   $242 = $241;
   HEAP32[$242>>2] = $237;
   $243 = (($241) + 4)|0;
   $244 = $243;
   HEAP32[$244>>2] = $240;
   $245 = $szMmap;
   $246 = $245;
   $247 = HEAP32[$246>>2]|0;
   $248 = (($245) + 4)|0;
   $249 = $248;
   $250 = HEAP32[$249>>2]|0;
   $251 = (184);
   $252 = $251;
   HEAP32[$252>>2] = $247;
   $253 = (($251) + 4)|0;
   $254 = $253;
   HEAP32[$254>>2] = $250;
   break;
  }
  case 25:  {
   $arglist_current60 = HEAP32[$ap>>2]|0;
   $255 = $arglist_current60;
   $256 = ((0) + 4|0);
   $expanded142 = $256;
   $expanded141 = (($expanded142) - 1)|0;
   $257 = (($255) + ($expanded141))|0;
   $258 = ((0) + 4|0);
   $expanded146 = $258;
   $expanded145 = (($expanded146) - 1)|0;
   $expanded144 = $expanded145 ^ -1;
   $259 = $257 & $expanded144;
   $260 = $259;
   $261 = HEAP32[$260>>2]|0;
   $arglist_next61 = ((($260)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next61;
   HEAP32[(232)>>2] = $261;
   break;
  }
  case 26:  {
   $arglist_current63 = HEAP32[$ap>>2]|0;
   $262 = $arglist_current63;
   $263 = ((0) + 4|0);
   $expanded149 = $263;
   $expanded148 = (($expanded149) - 1)|0;
   $264 = (($262) + ($expanded148))|0;
   $265 = ((0) + 4|0);
   $expanded153 = $265;
   $expanded152 = (($expanded153) - 1)|0;
   $expanded151 = $expanded152 ^ -1;
   $266 = $264 & $expanded151;
   $267 = $266;
   $268 = HEAP32[$267>>2]|0;
   $arglist_next64 = ((($267)) + 4|0);
   HEAP32[$ap>>2] = $arglist_next64;
   HEAP32[(44)>>2] = $268;
   break;
  }
  default: {
   HEAP32[$rc>>2] = 1;
  }
  }
 } while(0);
 $269 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $269;
 $270 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($270|0);
}
function _sqlite3_db_release_memory($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, $i = 0, $pBt = 0, $pPager = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $i = sp + 8|0;
 $pBt = sp + 4|0;
 $pPager = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 _sqlite3BtreeEnterAll($1);
 HEAP32[$i>>2] = 0;
 while(1) {
  $2 = HEAP32[$i>>2]|0;
  $3 = HEAP32[$0>>2]|0;
  $4 = ((($3)) + 20|0);
  $5 = HEAP32[$4>>2]|0;
  $6 = ($2|0)<($5|0);
  if (!($6)) {
   break;
  }
  $7 = HEAP32[$i>>2]|0;
  $8 = HEAP32[$0>>2]|0;
  $9 = ((($8)) + 16|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = (($10) + ($7<<4)|0);
  $12 = ((($11)) + 4|0);
  $13 = HEAP32[$12>>2]|0;
  HEAP32[$pBt>>2] = $13;
  $14 = HEAP32[$pBt>>2]|0;
  $15 = ($14|0)!=(0|0);
  if ($15) {
   $16 = HEAP32[$pBt>>2]|0;
   $17 = (_sqlite3BtreePager($16)|0);
   HEAP32[$pPager>>2] = $17;
   $18 = HEAP32[$pPager>>2]|0;
   _sqlite3PagerShrink($18);
  }
  $19 = HEAP32[$i>>2]|0;
  $20 = (($19) + 1)|0;
  HEAP32[$i>>2] = $20;
 }
 STACKTOP = sp;return 0;
}
function _sqlite3_db_config($db,$op,$varargs) {
 $db = $db|0;
 $op = $op|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0;
 var $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ap = 0, $arglist_current = 0, $arglist_current11 = 0, $arglist_current14 = 0, $arglist_current2 = 0, $arglist_current5 = 0, $arglist_current8 = 0, $arglist_next = 0, $arglist_next12 = 0, $arglist_next15 = 0, $arglist_next3 = 0, $arglist_next6 = 0, $arglist_next9 = 0, $cnt = 0;
 var $expanded = 0, $expanded10 = 0, $expanded12 = 0, $expanded13 = 0, $expanded14 = 0, $expanded16 = 0, $expanded17 = 0, $expanded19 = 0, $expanded20 = 0, $expanded21 = 0, $expanded23 = 0, $expanded24 = 0, $expanded26 = 0, $expanded27 = 0, $expanded28 = 0, $expanded3 = 0, $expanded30 = 0, $expanded31 = 0, $expanded33 = 0, $expanded34 = 0;
 var $expanded35 = 0, $expanded37 = 0, $expanded38 = 0, $expanded40 = 0, $expanded41 = 0, $expanded42 = 0, $expanded5 = 0, $expanded6 = 0, $expanded7 = 0, $expanded9 = 0, $i = 0, $oldFlags = 0, $onoff = 0, $pBuf = 0, $pRes = 0, $rc = 0, $sz = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $0 = sp + 52|0;
 $1 = sp + 48|0;
 $ap = sp + 32|0;
 $rc = sp + 28|0;
 $pBuf = sp + 24|0;
 $sz = sp + 20|0;
 $cnt = sp + 16|0;
 $i = sp + 12|0;
 $onoff = sp + 8|0;
 $pRes = sp + 4|0;
 $oldFlags = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $op;
 HEAP32[$ap>>2] = $varargs;
 $2 = HEAP32[$1>>2]|0;
 switch ($2|0) {
 case 1000:  {
  $arglist_current = HEAP32[$ap>>2]|0;
  $3 = $arglist_current;
  $4 = ((0) + 4|0);
  $expanded3 = $4;
  $expanded = (($expanded3) - 1)|0;
  $5 = (($3) + ($expanded))|0;
  $6 = ((0) + 4|0);
  $expanded7 = $6;
  $expanded6 = (($expanded7) - 1)|0;
  $expanded5 = $expanded6 ^ -1;
  $7 = $5 & $expanded5;
  $8 = $7;
  $9 = HEAP32[$8>>2]|0;
  $arglist_next = ((($8)) + 4|0);
  HEAP32[$ap>>2] = $arglist_next;
  $10 = HEAP32[$0>>2]|0;
  $11 = ((($10)) + 16|0);
  $12 = HEAP32[$11>>2]|0;
  HEAP32[$12>>2] = $9;
  HEAP32[$rc>>2] = 0;
  $105 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($105|0);
  break;
 }
 case 1001:  {
  $arglist_current2 = HEAP32[$ap>>2]|0;
  $13 = $arglist_current2;
  $14 = ((0) + 4|0);
  $expanded10 = $14;
  $expanded9 = (($expanded10) - 1)|0;
  $15 = (($13) + ($expanded9))|0;
  $16 = ((0) + 4|0);
  $expanded14 = $16;
  $expanded13 = (($expanded14) - 1)|0;
  $expanded12 = $expanded13 ^ -1;
  $17 = $15 & $expanded12;
  $18 = $17;
  $19 = HEAP32[$18>>2]|0;
  $arglist_next3 = ((($18)) + 4|0);
  HEAP32[$ap>>2] = $arglist_next3;
  HEAP32[$pBuf>>2] = $19;
  $arglist_current5 = HEAP32[$ap>>2]|0;
  $20 = $arglist_current5;
  $21 = ((0) + 4|0);
  $expanded17 = $21;
  $expanded16 = (($expanded17) - 1)|0;
  $22 = (($20) + ($expanded16))|0;
  $23 = ((0) + 4|0);
  $expanded21 = $23;
  $expanded20 = (($expanded21) - 1)|0;
  $expanded19 = $expanded20 ^ -1;
  $24 = $22 & $expanded19;
  $25 = $24;
  $26 = HEAP32[$25>>2]|0;
  $arglist_next6 = ((($25)) + 4|0);
  HEAP32[$ap>>2] = $arglist_next6;
  HEAP32[$sz>>2] = $26;
  $arglist_current8 = HEAP32[$ap>>2]|0;
  $27 = $arglist_current8;
  $28 = ((0) + 4|0);
  $expanded24 = $28;
  $expanded23 = (($expanded24) - 1)|0;
  $29 = (($27) + ($expanded23))|0;
  $30 = ((0) + 4|0);
  $expanded28 = $30;
  $expanded27 = (($expanded28) - 1)|0;
  $expanded26 = $expanded27 ^ -1;
  $31 = $29 & $expanded26;
  $32 = $31;
  $33 = HEAP32[$32>>2]|0;
  $arglist_next9 = ((($32)) + 4|0);
  HEAP32[$ap>>2] = $arglist_next9;
  HEAP32[$cnt>>2] = $33;
  $34 = HEAP32[$0>>2]|0;
  $35 = HEAP32[$pBuf>>2]|0;
  $36 = HEAP32[$sz>>2]|0;
  $37 = HEAP32[$cnt>>2]|0;
  $38 = (_setupLookaside($34,$35,$36,$37)|0);
  HEAP32[$rc>>2] = $38;
  $105 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($105|0);
  break;
 }
 default: {
  HEAP32[$rc>>2] = 1;
  HEAP32[$i>>2] = 0;
  while(1) {
   $39 = HEAP32[$i>>2]|0;
   $40 = ($39>>>0)<(4);
   if (!($40)) {
    label = 17;
    break;
   }
   $41 = HEAP32[$i>>2]|0;
   $42 = (1548 + ($41<<3)|0);
   $43 = HEAP32[$42>>2]|0;
   $44 = HEAP32[$1>>2]|0;
   $45 = ($43|0)==($44|0);
   if ($45) {
    break;
   }
   $103 = HEAP32[$i>>2]|0;
   $104 = (($103) + 1)|0;
   HEAP32[$i>>2] = $104;
  }
  if ((label|0) == 17) {
   $105 = HEAP32[$rc>>2]|0;
   STACKTOP = sp;return ($105|0);
  }
  $arglist_current11 = HEAP32[$ap>>2]|0;
  $46 = $arglist_current11;
  $47 = ((0) + 4|0);
  $expanded31 = $47;
  $expanded30 = (($expanded31) - 1)|0;
  $48 = (($46) + ($expanded30))|0;
  $49 = ((0) + 4|0);
  $expanded35 = $49;
  $expanded34 = (($expanded35) - 1)|0;
  $expanded33 = $expanded34 ^ -1;
  $50 = $48 & $expanded33;
  $51 = $50;
  $52 = HEAP32[$51>>2]|0;
  $arglist_next12 = ((($51)) + 4|0);
  HEAP32[$ap>>2] = $arglist_next12;
  HEAP32[$onoff>>2] = $52;
  $arglist_current14 = HEAP32[$ap>>2]|0;
  $53 = $arglist_current14;
  $54 = ((0) + 4|0);
  $expanded38 = $54;
  $expanded37 = (($expanded38) - 1)|0;
  $55 = (($53) + ($expanded37))|0;
  $56 = ((0) + 4|0);
  $expanded42 = $56;
  $expanded41 = (($expanded42) - 1)|0;
  $expanded40 = $expanded41 ^ -1;
  $57 = $55 & $expanded40;
  $58 = $57;
  $59 = HEAP32[$58>>2]|0;
  $arglist_next15 = ((($58)) + 4|0);
  HEAP32[$ap>>2] = $arglist_next15;
  HEAP32[$pRes>>2] = $59;
  $60 = HEAP32[$0>>2]|0;
  $61 = ((($60)) + 24|0);
  $62 = HEAP32[$61>>2]|0;
  HEAP32[$oldFlags>>2] = $62;
  $63 = HEAP32[$onoff>>2]|0;
  $64 = ($63|0)>(0);
  if ($64) {
   $65 = HEAP32[$i>>2]|0;
   $66 = (1548 + ($65<<3)|0);
   $67 = ((($66)) + 4|0);
   $68 = HEAP32[$67>>2]|0;
   $69 = HEAP32[$0>>2]|0;
   $70 = ((($69)) + 24|0);
   $71 = HEAP32[$70>>2]|0;
   $72 = $71 | $68;
   HEAP32[$70>>2] = $72;
  } else {
   $73 = HEAP32[$onoff>>2]|0;
   $74 = ($73|0)==(0);
   if ($74) {
    $75 = HEAP32[$i>>2]|0;
    $76 = (1548 + ($75<<3)|0);
    $77 = ((($76)) + 4|0);
    $78 = HEAP32[$77>>2]|0;
    $79 = $78 ^ -1;
    $80 = HEAP32[$0>>2]|0;
    $81 = ((($80)) + 24|0);
    $82 = HEAP32[$81>>2]|0;
    $83 = $82 & $79;
    HEAP32[$81>>2] = $83;
   }
  }
  $84 = HEAP32[$oldFlags>>2]|0;
  $85 = HEAP32[$0>>2]|0;
  $86 = ((($85)) + 24|0);
  $87 = HEAP32[$86>>2]|0;
  $88 = ($84|0)!=($87|0);
  if ($88) {
   $89 = HEAP32[$0>>2]|0;
   _sqlite3ExpirePreparedStatements($89);
  }
  $90 = HEAP32[$pRes>>2]|0;
  $91 = ($90|0)!=(0|0);
  if ($91) {
   $92 = HEAP32[$0>>2]|0;
   $93 = ((($92)) + 24|0);
   $94 = HEAP32[$93>>2]|0;
   $95 = HEAP32[$i>>2]|0;
   $96 = (1548 + ($95<<3)|0);
   $97 = ((($96)) + 4|0);
   $98 = HEAP32[$97>>2]|0;
   $99 = $94 & $98;
   $100 = ($99|0)!=(0);
   $101 = $100&1;
   $102 = HEAP32[$pRes>>2]|0;
   HEAP32[$102>>2] = $101;
  }
  HEAP32[$rc>>2] = 0;
  $105 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($105|0);
 }
 }
 return (0)|0;
}
function _sqlite3_last_insert_rowid($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 32|0);
 $3 = $2;
 $4 = $3;
 $5 = HEAP32[$4>>2]|0;
 $6 = (($3) + 4)|0;
 $7 = $6;
 $8 = HEAP32[$7>>2]|0;
 tempRet0 = ($8);
 STACKTOP = sp;return ($5|0);
}
function _sqlite3_changes($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 88|0);
 $3 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($3|0);
}
function _sqlite3_total_changes($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 92|0);
 $3 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($3|0);
}
function _sqlite3_close($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3Close($1,0)|0);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3_close_v2($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_sqlite3Close($1,1)|0);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3_busy_handler($db,$xBusy,$pArg) {
 $db = $db|0;
 $xBusy = $xBusy|0;
 $pArg = $pArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $xBusy;
 HEAP32[$2>>2] = $pArg;
 $3 = HEAP32[$1>>2]|0;
 $4 = HEAP32[$0>>2]|0;
 $5 = ((($4)) + 380|0);
 HEAP32[$5>>2] = $3;
 $6 = HEAP32[$2>>2]|0;
 $7 = HEAP32[$0>>2]|0;
 $8 = ((($7)) + 380|0);
 $9 = ((($8)) + 4|0);
 HEAP32[$9>>2] = $6;
 $10 = HEAP32[$0>>2]|0;
 $11 = ((($10)) + 380|0);
 $12 = ((($11)) + 8|0);
 HEAP32[$12>>2] = 0;
 $13 = HEAP32[$0>>2]|0;
 $14 = ((($13)) + 428|0);
 HEAP32[$14>>2] = 0;
 STACKTOP = sp;return 0;
}
function _sqlite3_busy_timeout($db,$ms) {
 $db = $db|0;
 $ms = $ms|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $ms;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)>(0);
 $4 = HEAP32[$0>>2]|0;
 if ($3) {
  $5 = HEAP32[$0>>2]|0;
  (_sqlite3_busy_handler($4,178,$5)|0);
  $6 = HEAP32[$1>>2]|0;
  $7 = HEAP32[$0>>2]|0;
  $8 = ((($7)) + 428|0);
  HEAP32[$8>>2] = $6;
  STACKTOP = sp;return 0;
 } else {
  (_sqlite3_busy_handler($4,0,0)|0);
  STACKTOP = sp;return 0;
 }
 return (0)|0;
}
function _sqlite3_create_function($db,$zFunc,$nArg,$enc,$p,$xSFunc,$xStep,$xFinal) {
 $db = $db|0;
 $zFunc = $zFunc|0;
 $nArg = $nArg|0;
 $enc = $enc|0;
 $p = $p|0;
 $xSFunc = $xSFunc|0;
 $xStep = $xStep|0;
 $xFinal = $xFinal|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $3 = sp + 16|0;
 $4 = sp + 12|0;
 $5 = sp + 8|0;
 $6 = sp + 4|0;
 $7 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zFunc;
 HEAP32[$2>>2] = $nArg;
 HEAP32[$3>>2] = $enc;
 HEAP32[$4>>2] = $p;
 HEAP32[$5>>2] = $xSFunc;
 HEAP32[$6>>2] = $xStep;
 HEAP32[$7>>2] = $xFinal;
 $8 = HEAP32[$0>>2]|0;
 $9 = HEAP32[$1>>2]|0;
 $10 = HEAP32[$2>>2]|0;
 $11 = HEAP32[$3>>2]|0;
 $12 = HEAP32[$4>>2]|0;
 $13 = HEAP32[$5>>2]|0;
 $14 = HEAP32[$6>>2]|0;
 $15 = HEAP32[$7>>2]|0;
 $16 = (_sqlite3_create_function_v2($8,$9,$10,$11,$12,$13,$14,$15,0)|0);
 STACKTOP = sp;return ($16|0);
}
function _sqlite3_create_function_v2($db,$zFunc,$nArg,$enc,$p,$xSFunc,$xStep,$xFinal,$xDestroy) {
 $db = $db|0;
 $zFunc = $zFunc|0;
 $nArg = $nArg|0;
 $enc = $enc|0;
 $p = $p|0;
 $xSFunc = $xSFunc|0;
 $xStep = $xStep|0;
 $xFinal = $xFinal|0;
 $xDestroy = $xDestroy|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pArg = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 40|0;
 $1 = sp + 36|0;
 $2 = sp + 32|0;
 $3 = sp + 28|0;
 $4 = sp + 24|0;
 $5 = sp + 20|0;
 $6 = sp + 16|0;
 $7 = sp + 12|0;
 $8 = sp + 8|0;
 $rc = sp + 4|0;
 $pArg = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zFunc;
 HEAP32[$2>>2] = $nArg;
 HEAP32[$3>>2] = $enc;
 HEAP32[$4>>2] = $p;
 HEAP32[$5>>2] = $xSFunc;
 HEAP32[$6>>2] = $xStep;
 HEAP32[$7>>2] = $xFinal;
 HEAP32[$8>>2] = $xDestroy;
 HEAP32[$rc>>2] = 1;
 HEAP32[$pArg>>2] = 0;
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)!=(0|0);
 do {
  if ($10) {
   $11 = HEAP32[$0>>2]|0;
   $12 = (_sqlite3DbMallocZero($11,12,0)|0);
   HEAP32[$pArg>>2] = $12;
   $13 = HEAP32[$pArg>>2]|0;
   $14 = ($13|0)!=(0|0);
   $15 = HEAP32[$8>>2]|0;
   if ($14) {
    $17 = HEAP32[$pArg>>2]|0;
    $18 = ((($17)) + 4|0);
    HEAP32[$18>>2] = $15;
    $19 = HEAP32[$4>>2]|0;
    $20 = HEAP32[$pArg>>2]|0;
    $21 = ((($20)) + 8|0);
    HEAP32[$21>>2] = $19;
    label = 5;
    break;
   } else {
    $16 = HEAP32[$4>>2]|0;
    FUNCTION_TABLE_vi[$15 & 255]($16);
    break;
   }
  } else {
   label = 5;
  }
 } while(0);
 if ((label|0) == 5) {
  $22 = HEAP32[$0>>2]|0;
  $23 = HEAP32[$1>>2]|0;
  $24 = HEAP32[$2>>2]|0;
  $25 = HEAP32[$3>>2]|0;
  $26 = HEAP32[$4>>2]|0;
  $27 = HEAP32[$5>>2]|0;
  $28 = HEAP32[$6>>2]|0;
  $29 = HEAP32[$7>>2]|0;
  $30 = HEAP32[$pArg>>2]|0;
  $31 = (_sqlite3CreateFunc($22,$23,$24,$25,$26,$27,$28,$29,$30)|0);
  HEAP32[$rc>>2] = $31;
  $32 = HEAP32[$pArg>>2]|0;
  $33 = ($32|0)!=(0|0);
  if ($33) {
   $34 = HEAP32[$pArg>>2]|0;
   $35 = HEAP32[$34>>2]|0;
   $36 = ($35|0)==(0);
   if ($36) {
    $37 = HEAP32[$8>>2]|0;
    $38 = HEAP32[$4>>2]|0;
    FUNCTION_TABLE_vi[$37 & 255]($38);
    $39 = HEAP32[$0>>2]|0;
    $40 = HEAP32[$pArg>>2]|0;
    _sqlite3DbFree($39,$40);
   }
  }
 }
 $41 = HEAP32[$0>>2]|0;
 $42 = HEAP32[$rc>>2]|0;
 $43 = (_sqlite3ApiExit($41,$42)|0);
 HEAP32[$rc>>2] = $43;
 $44 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($44|0);
}
function _sqlite3_overload_function($db,$zName,$nArg) {
 $db = $db|0;
 $zName = $zName|0;
 $nArg = $nArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zName;
 HEAP32[$2>>2] = $nArg;
 HEAP32[$rc>>2] = 0;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = HEAP32[$2>>2]|0;
 $6 = (_sqlite3FindFunction($3,$4,$5,1,0)|0);
 $7 = ($6|0)==(0|0);
 if ($7) {
  $8 = HEAP32[$0>>2]|0;
  $9 = HEAP32[$1>>2]|0;
  $10 = HEAP32[$2>>2]|0;
  $11 = (_sqlite3CreateFunc($8,$9,$10,1,0,224,0,0,0)|0);
  HEAP32[$rc>>2] = $11;
 }
 $12 = HEAP32[$0>>2]|0;
 $13 = HEAP32[$rc>>2]|0;
 $14 = (_sqlite3ApiExit($12,$13)|0);
 HEAP32[$rc>>2] = $14;
 $15 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($15|0);
}
function _sqlite3_wal_autocheckpoint($db,$nFrame) {
 $db = $db|0;
 $nFrame = $nFrame|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $nFrame;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)>(0);
 $4 = HEAP32[$0>>2]|0;
 if ($3) {
  $5 = HEAP32[$1>>2]|0;
  $6 = $5;
  (_sqlite3_wal_hook($4,139,$6)|0);
  STACKTOP = sp;return 0;
 } else {
  (_sqlite3_wal_hook($4,0,0)|0);
  STACKTOP = sp;return 0;
 }
 return (0)|0;
}
function _sqlite3_wal_hook($db,$xCallback,$pArg) {
 $db = $db|0;
 $xCallback = $xCallback|0;
 $pArg = $pArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pRet = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $pRet = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $xCallback;
 HEAP32[$2>>2] = $pArg;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 228|0);
 $5 = HEAP32[$4>>2]|0;
 HEAP32[$pRet>>2] = $5;
 $6 = HEAP32[$1>>2]|0;
 $7 = HEAP32[$0>>2]|0;
 $8 = ((($7)) + 224|0);
 HEAP32[$8>>2] = $6;
 $9 = HEAP32[$2>>2]|0;
 $10 = HEAP32[$0>>2]|0;
 $11 = ((($10)) + 228|0);
 HEAP32[$11>>2] = $9;
 $12 = HEAP32[$pRet>>2]|0;
 STACKTOP = sp;return ($12|0);
}
function _sqlite3_wal_checkpoint_v2($db,$zDb,$eMode,$pnLog,$pnCkpt) {
 $db = $db|0;
 $zDb = $zDb|0;
 $eMode = $eMode|0;
 $pnLog = $pnLog|0;
 $pnCkpt = $pnCkpt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $iDb = 0, $or$cond = 0, $rc = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $vararg_buffer = sp;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $3 = sp + 20|0;
 $4 = sp + 16|0;
 $5 = sp + 12|0;
 $rc = sp + 8|0;
 $iDb = sp + 4|0;
 HEAP32[$1>>2] = $db;
 HEAP32[$2>>2] = $zDb;
 HEAP32[$3>>2] = $eMode;
 HEAP32[$4>>2] = $pnLog;
 HEAP32[$5>>2] = $pnCkpt;
 HEAP32[$iDb>>2] = 10;
 $6 = HEAP32[$4>>2]|0;
 $7 = ($6|0)!=(0|0);
 if ($7) {
  $8 = HEAP32[$4>>2]|0;
  HEAP32[$8>>2] = -1;
 }
 $9 = HEAP32[$5>>2]|0;
 $10 = ($9|0)!=(0|0);
 if ($10) {
  $11 = HEAP32[$5>>2]|0;
  HEAP32[$11>>2] = -1;
 }
 $12 = HEAP32[$3>>2]|0;
 $13 = ($12|0)<(0);
 $14 = HEAP32[$3>>2]|0;
 $15 = ($14|0)>(3);
 $or$cond = $13 | $15;
 if ($or$cond) {
  HEAP32[$0>>2] = 21;
  $44 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($44|0);
 }
 $16 = HEAP32[$2>>2]|0;
 $17 = ($16|0)!=(0|0);
 if ($17) {
  $18 = HEAP32[$2>>2]|0;
  $19 = HEAP8[$18>>0]|0;
  $20 = $19 << 24 >> 24;
  $21 = ($20|0)!=(0);
  if ($21) {
   $22 = HEAP32[$1>>2]|0;
   $23 = HEAP32[$2>>2]|0;
   $24 = (_sqlite3FindDbName($22,$23)|0);
   HEAP32[$iDb>>2] = $24;
  }
 }
 $25 = HEAP32[$iDb>>2]|0;
 $26 = ($25|0)<(0);
 if ($26) {
  HEAP32[$rc>>2] = 1;
  $27 = HEAP32[$1>>2]|0;
  $28 = HEAP32[$2>>2]|0;
  HEAP32[$vararg_buffer>>2] = $28;
  _sqlite3ErrorWithMsg($27,1,18738,$vararg_buffer);
 } else {
  $29 = HEAP32[$1>>2]|0;
  $30 = ((($29)) + 380|0);
  $31 = ((($30)) + 8|0);
  HEAP32[$31>>2] = 0;
  $32 = HEAP32[$1>>2]|0;
  $33 = HEAP32[$iDb>>2]|0;
  $34 = HEAP32[$3>>2]|0;
  $35 = HEAP32[$4>>2]|0;
  $36 = HEAP32[$5>>2]|0;
  $37 = (_sqlite3Checkpoint($32,$33,$34,$35,$36)|0);
  HEAP32[$rc>>2] = $37;
  $38 = HEAP32[$1>>2]|0;
  $39 = HEAP32[$rc>>2]|0;
  _sqlite3Error($38,$39);
 }
 $40 = HEAP32[$1>>2]|0;
 $41 = HEAP32[$rc>>2]|0;
 $42 = (_sqlite3ApiExit($40,$41)|0);
 HEAP32[$rc>>2] = $42;
 $43 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $43;
 $44 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($44|0);
}
function _sqlite3_wal_checkpoint($db,$zDb) {
 $db = $db|0;
 $zDb = $zDb|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zDb;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_sqlite3_wal_checkpoint_v2($2,$3,0,0,0)|0);
 STACKTOP = sp;return ($4|0);
}
function _sqlite3_errcode($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$1>>2] = $db;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)!=(0|0);
 if ($3) {
  $4 = HEAP32[$1>>2]|0;
  $5 = (_sqlite3SafetyCheckSickOrOk($4)|0);
  $6 = ($5|0)!=(0);
  if (!($6)) {
   $7 = (_sqlite3MisuseError(140115)|0);
   HEAP32[$0>>2] = $7;
   $22 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($22|0);
  }
 }
 $8 = HEAP32[$1>>2]|0;
 $9 = ($8|0)!=(0|0);
 if ($9) {
  $10 = HEAP32[$1>>2]|0;
  $11 = ((($10)) + 69|0);
  $12 = HEAP8[$11>>0]|0;
  $13 = $12&255;
  $14 = ($13|0)!=(0);
  if (!($14)) {
   $15 = HEAP32[$1>>2]|0;
   $16 = ((($15)) + 52|0);
   $17 = HEAP32[$16>>2]|0;
   $18 = HEAP32[$1>>2]|0;
   $19 = ((($18)) + 56|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = $17 & $20;
   HEAP32[$0>>2] = $21;
   $22 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($22|0);
  }
 }
 HEAP32[$0>>2] = 7;
 $22 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($22|0);
}
function _sqlite3_limit($db,$limitId,$newLimit) {
 $db = $db|0;
 $limitId = $limitId|0;
 $newLimit = $newLimit|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $oldLimit = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $3 = sp + 4|0;
 $oldLimit = sp;
 HEAP32[$1>>2] = $db;
 HEAP32[$2>>2] = $limitId;
 HEAP32[$3>>2] = $newLimit;
 $4 = HEAP32[$2>>2]|0;
 $5 = ($4|0)<(0);
 $6 = HEAP32[$2>>2]|0;
 $7 = ($6|0)>=(12);
 $or$cond = $5 | $7;
 if ($or$cond) {
  HEAP32[$0>>2] = -1;
  $29 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($29|0);
 }
 $8 = HEAP32[$2>>2]|0;
 $9 = HEAP32[$1>>2]|0;
 $10 = ((($9)) + 96|0);
 $11 = (($10) + ($8<<2)|0);
 $12 = HEAP32[$11>>2]|0;
 HEAP32[$oldLimit>>2] = $12;
 $13 = HEAP32[$3>>2]|0;
 $14 = ($13|0)>=(0);
 if ($14) {
  $15 = HEAP32[$3>>2]|0;
  $16 = HEAP32[$2>>2]|0;
  $17 = (1580 + ($16<<2)|0);
  $18 = HEAP32[$17>>2]|0;
  $19 = ($15|0)>($18|0);
  if ($19) {
   $20 = HEAP32[$2>>2]|0;
   $21 = (1580 + ($20<<2)|0);
   $22 = HEAP32[$21>>2]|0;
   HEAP32[$3>>2] = $22;
  }
  $23 = HEAP32[$3>>2]|0;
  $24 = HEAP32[$2>>2]|0;
  $25 = HEAP32[$1>>2]|0;
  $26 = ((($25)) + 96|0);
  $27 = (($26) + ($24<<2)|0);
  HEAP32[$27>>2] = $23;
 }
 $28 = HEAP32[$oldLimit>>2]|0;
 HEAP32[$0>>2] = $28;
 $29 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($29|0);
}
function _sqlite3_open($zFilename,$ppDb) {
 $zFilename = $zFilename|0;
 $ppDb = $ppDb|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $zFilename;
 HEAP32[$1>>2] = $ppDb;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_openDatabase($2,$3,6,0)|0);
 STACKTOP = sp;return ($4|0);
}
function _sqlite3_file_control($db,$zDbName,$op,$pArg) {
 $db = $db|0;
 $zDbName = $zDbName|0;
 $op = $op|0;
 $pArg = $pArg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $fd = 0, $pBtree = 0, $pPager = 0, $rc = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $3 = sp + 16|0;
 $rc = sp + 12|0;
 $pBtree = sp + 8|0;
 $pPager = sp + 4|0;
 $fd = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $zDbName;
 HEAP32[$2>>2] = $op;
 HEAP32[$3>>2] = $pArg;
 HEAP32[$rc>>2] = 1;
 $4 = HEAP32[$0>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = (_sqlite3DbNameToBtree($4,$5)|0);
 HEAP32[$pBtree>>2] = $6;
 $7 = HEAP32[$pBtree>>2]|0;
 $8 = ($7|0)!=(0|0);
 if (!($8)) {
  $35 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 $9 = HEAP32[$pBtree>>2]|0;
 _sqlite3BtreeEnter($9);
 $10 = HEAP32[$pBtree>>2]|0;
 $11 = (_sqlite3BtreePager($10)|0);
 HEAP32[$pPager>>2] = $11;
 $12 = HEAP32[$pPager>>2]|0;
 $13 = (_sqlite3PagerFile($12)|0);
 HEAP32[$fd>>2] = $13;
 $14 = HEAP32[$2>>2]|0;
 $15 = ($14|0)==(7);
 if ($15) {
  $16 = HEAP32[$fd>>2]|0;
  $17 = HEAP32[$3>>2]|0;
  HEAP32[$17>>2] = $16;
  HEAP32[$rc>>2] = 0;
  $35 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 $18 = HEAP32[$2>>2]|0;
 $19 = ($18|0)==(27);
 if ($19) {
  $20 = HEAP32[$pPager>>2]|0;
  $21 = (_sqlite3PagerVfs($20)|0);
  $22 = HEAP32[$3>>2]|0;
  HEAP32[$22>>2] = $21;
  HEAP32[$rc>>2] = 0;
  $35 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 $23 = HEAP32[$2>>2]|0;
 $24 = ($23|0)==(28);
 if ($24) {
  $25 = HEAP32[$pPager>>2]|0;
  $26 = (_sqlite3PagerJrnlFile($25)|0);
  $27 = HEAP32[$3>>2]|0;
  HEAP32[$27>>2] = $26;
  HEAP32[$rc>>2] = 0;
  $35 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 $28 = HEAP32[$fd>>2]|0;
 $29 = HEAP32[$28>>2]|0;
 $30 = ($29|0)!=(0|0);
 if ($30) {
  $31 = HEAP32[$fd>>2]|0;
  $32 = HEAP32[$2>>2]|0;
  $33 = HEAP32[$3>>2]|0;
  $34 = (_sqlite3OsFileControl($31,$32,$33)|0);
  HEAP32[$rc>>2] = $34;
  $35 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($35|0);
 } else {
  HEAP32[$rc>>2] = 12;
  $35 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 return (0)|0;
}
function _sqlite3_uri_parameter($zFilename,$zParam) {
 $zFilename = $zFilename|0;
 $zParam = $zParam|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $x = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $x = sp;
 HEAP32[$1>>2] = $zFilename;
 HEAP32[$2>>2] = $zParam;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(0|0);
 $5 = HEAP32[$2>>2]|0;
 $6 = ($5|0)==(0|0);
 $or$cond = $4 | $6;
 if ($or$cond) {
  HEAP32[$0>>2] = 0;
  $30 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($30|0);
 }
 $7 = HEAP32[$1>>2]|0;
 $8 = (_sqlite3Strlen30($7)|0);
 $9 = (($8) + 1)|0;
 $10 = HEAP32[$1>>2]|0;
 $11 = (($10) + ($9)|0);
 HEAP32[$1>>2] = $11;
 while(1) {
  $12 = HEAP32[$1>>2]|0;
  $13 = HEAP8[$12>>0]|0;
  $14 = ($13<<24>>24)!=(0);
  if (!($14)) {
   label = 8;
   break;
  }
  $15 = HEAP32[$1>>2]|0;
  $16 = HEAP32[$2>>2]|0;
  $17 = (_strcmp($15,$16)|0);
  HEAP32[$x>>2] = $17;
  $18 = HEAP32[$1>>2]|0;
  $19 = (_sqlite3Strlen30($18)|0);
  $20 = (($19) + 1)|0;
  $21 = HEAP32[$1>>2]|0;
  $22 = (($21) + ($20)|0);
  HEAP32[$1>>2] = $22;
  $23 = HEAP32[$x>>2]|0;
  $24 = ($23|0)==(0);
  $25 = HEAP32[$1>>2]|0;
  if ($24) {
   label = 6;
   break;
  }
  $26 = (_sqlite3Strlen30($25)|0);
  $27 = (($26) + 1)|0;
  $28 = HEAP32[$1>>2]|0;
  $29 = (($28) + ($27)|0);
  HEAP32[$1>>2] = $29;
 }
 if ((label|0) == 6) {
  HEAP32[$0>>2] = $25;
  $30 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($30|0);
 }
 else if ((label|0) == 8) {
  HEAP32[$0>>2] = 0;
  $30 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($30|0);
 }
 return (0)|0;
}
function _sqlite3_uri_boolean($zFilename,$zParam,$bDflt) {
 $zFilename = $zFilename|0;
 $zParam = $zParam|0;
 $bDflt = $bDflt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $z = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $z = sp;
 HEAP32[$0>>2] = $zFilename;
 HEAP32[$1>>2] = $zParam;
 HEAP32[$2>>2] = $bDflt;
 $3 = HEAP32[$0>>2]|0;
 $4 = HEAP32[$1>>2]|0;
 $5 = (_sqlite3_uri_parameter($3,$4)|0);
 HEAP32[$z>>2] = $5;
 $6 = HEAP32[$2>>2]|0;
 $7 = ($6|0)!=(0);
 $8 = $7&1;
 HEAP32[$2>>2] = $8;
 $9 = HEAP32[$z>>2]|0;
 $10 = ($9|0)!=(0|0);
 if ($10) {
  $11 = HEAP32[$z>>2]|0;
  $12 = HEAP32[$2>>2]|0;
  $13 = $12&255;
  $14 = (_sqlite3GetBoolean($11,$13)|0);
  $15 = $14&255;
  $17 = $15;
  STACKTOP = sp;return ($17|0);
 } else {
  $16 = HEAP32[$2>>2]|0;
  $17 = $16;
  STACKTOP = sp;return ($17|0);
 }
 return (0)|0;
}
function _sqlite3Strlen30($z) {
 $z = $z|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$1>>2] = $z;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  HEAP32[$0>>2] = 0;
 } else {
  $4 = HEAP32[$1>>2]|0;
  $5 = (_strlen($4)|0);
  $6 = 1073741823 & $5;
  HEAP32[$0>>2] = $6;
 }
 $7 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3IsIdChar($c) {
 $c = $c|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP8[$0>>0] = $c;
 $1 = HEAP8[$0>>0]|0;
 $2 = $1&255;
 $3 = (18403 + ($2)|0);
 $4 = HEAP8[$3>>0]|0;
 $5 = $4&255;
 $6 = $5 & 70;
 $7 = ($6|0)!=(0);
 $8 = $7&1;
 STACKTOP = sp;return ($8|0);
}
function _sqlite3MisuseError($lineno) {
 $lineno = $lineno|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $lineno;
 $1 = HEAP32[$0>>2]|0;
 $2 = (_reportError(21,$1,45606)|0);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3Pcache1Mutex() {
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[(1712)>>2]|0;
 return ($0|0);
}
function _sqlite3MallocMutex() {
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[288>>2]|0;
 return ($0|0);
}
function _sqlite3BtreeEnterAll($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $i = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $i = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$i>>2] = 0;
 while(1) {
  $1 = HEAP32[$i>>2]|0;
  $2 = HEAP32[$0>>2]|0;
  $3 = ((($2)) + 20|0);
  $4 = HEAP32[$3>>2]|0;
  $5 = ($1|0)<($4|0);
  if (!($5)) {
   break;
  }
  $6 = HEAP32[$i>>2]|0;
  $7 = HEAP32[$0>>2]|0;
  $8 = ((($7)) + 16|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = (($9) + ($6<<4)|0);
  $11 = ((($10)) + 4|0);
  $12 = HEAP32[$11>>2]|0;
  HEAP32[$p>>2] = $12;
  $13 = HEAP32[$p>>2]|0;
  $14 = ($13|0)!=(0|0);
  if ($14) {
   $15 = HEAP32[$p>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   $17 = HEAP32[$p>>2]|0;
   $18 = ((($17)) + 4|0);
   $19 = HEAP32[$18>>2]|0;
   $20 = ((($19)) + 4|0);
   HEAP32[$20>>2] = $16;
  }
  $21 = HEAP32[$i>>2]|0;
  $22 = (($21) + 1)|0;
  HEAP32[$i>>2] = $22;
 }
 STACKTOP = sp;return;
}
function _sqlite3BtreePager($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = HEAP32[$3>>2]|0;
 STACKTOP = sp;return ($4|0);
}
function _sqlite3DeleteTrigger($db,$pTrigger) {
 $db = $db|0;
 $pTrigger = $pTrigger|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $pTrigger;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  STACKTOP = sp;return;
 }
 $4 = HEAP32[$0>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = ((($5)) + 28|0);
 $7 = HEAP32[$6>>2]|0;
 _sqlite3DeleteTriggerStep($4,$7);
 $8 = HEAP32[$0>>2]|0;
 $9 = HEAP32[$1>>2]|0;
 $10 = HEAP32[$9>>2]|0;
 _sqlite3DbFree($8,$10);
 $11 = HEAP32[$0>>2]|0;
 $12 = HEAP32[$1>>2]|0;
 $13 = ((($12)) + 4|0);
 $14 = HEAP32[$13>>2]|0;
 _sqlite3DbFree($11,$14);
 $15 = HEAP32[$0>>2]|0;
 $16 = HEAP32[$1>>2]|0;
 $17 = ((($16)) + 12|0);
 $18 = HEAP32[$17>>2]|0;
 _sqlite3ExprDelete($15,$18);
 $19 = HEAP32[$0>>2]|0;
 $20 = HEAP32[$1>>2]|0;
 $21 = ((($20)) + 16|0);
 $22 = HEAP32[$21>>2]|0;
 _sqlite3IdListDelete($19,$22);
 $23 = HEAP32[$0>>2]|0;
 $24 = HEAP32[$1>>2]|0;
 _sqlite3DbFree($23,$24);
 STACKTOP = sp;return;
}
function _sqlite3DeleteTable($db,$pTable) {
 $db = $db|0;
 $pTable = $pTable|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $pTable;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 $4 = HEAP32[$0>>2]|0;
 $5 = ($4|0)!=(0|0);
 if ($5) {
  $6 = HEAP32[$0>>2]|0;
  $7 = ((($6)) + 456|0);
  $8 = HEAP32[$7>>2]|0;
  $9 = ($8|0)==(0|0);
  if ($9) {
   label = 4;
  }
 } else {
  label = 4;
 }
 if ((label|0) == 4) {
  $10 = HEAP32[$1>>2]|0;
  $11 = ((($10)) + 36|0);
  $12 = HEAP16[$11>>1]|0;
  $13 = (($12) + -1)<<16>>16;
  HEAP16[$11>>1] = $13;
  $14 = $13&65535;
  $15 = ($14|0)>(0);
  if ($15) {
   STACKTOP = sp;return;
  }
 }
 $16 = HEAP32[$0>>2]|0;
 $17 = HEAP32[$1>>2]|0;
 _deleteTable($16,$17);
 STACKTOP = sp;return;
}
function _sqlite3VdbeClearObject($db,$p) {
 $db = $db|0;
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $8 = 0, $9 = 0, $i = 0, $pNext = 0, $pSub = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $pSub = sp + 8|0;
 $pNext = sp + 4|0;
 $i = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 100|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = ((($5)) + 140|0);
 $7 = HEAP16[$6>>1]|0;
 $8 = $7&65535;
 $9 = $8<<1;
 _releaseMemArray($4,$9);
 $10 = HEAP32[$1>>2]|0;
 $11 = ((($10)) + 200|0);
 $12 = HEAP32[$11>>2]|0;
 HEAP32[$pSub>>2] = $12;
 while(1) {
  $13 = HEAP32[$pSub>>2]|0;
  $14 = ($13|0)!=(0|0);
  if (!($14)) {
   break;
  }
  $15 = HEAP32[$pSub>>2]|0;
  $16 = ((($15)) + 20|0);
  $17 = HEAP32[$16>>2]|0;
  HEAP32[$pNext>>2] = $17;
  $18 = HEAP32[$0>>2]|0;
  $19 = HEAP32[$pSub>>2]|0;
  $20 = HEAP32[$19>>2]|0;
  $21 = HEAP32[$pSub>>2]|0;
  $22 = ((($21)) + 4|0);
  $23 = HEAP32[$22>>2]|0;
  _vdbeFreeOpArray($18,$20,$23);
  $24 = HEAP32[$0>>2]|0;
  $25 = HEAP32[$pSub>>2]|0;
  _sqlite3DbFree($24,$25);
  $26 = HEAP32[$pNext>>2]|0;
  HEAP32[$pSub>>2] = $26;
 }
 $27 = HEAP32[$1>>2]|0;
 $28 = ((($27)) + 20|0);
 $29 = HEAP32[$28>>2]|0;
 $30 = ($29|0)!=(381479589);
 if ($30) {
  $31 = HEAP32[$1>>2]|0;
  $32 = ((($31)) + 116|0);
  $33 = HEAP32[$32>>2]|0;
  $34 = HEAP32[$1>>2]|0;
  $35 = ((($34)) + 16|0);
  $36 = HEAP16[$35>>1]|0;
  $37 = $36 << 16 >> 16;
  _releaseMemArray($33,$37);
  $38 = HEAP32[$1>>2]|0;
  $39 = ((($38)) + 18|0);
  $40 = HEAP16[$39>>1]|0;
  $41 = $40 << 16 >> 16;
  $42 = (($41) - 1)|0;
  HEAP32[$i>>2] = $42;
  while(1) {
   $43 = HEAP32[$i>>2]|0;
   $44 = ($43|0)>=(0);
   $45 = HEAP32[$0>>2]|0;
   if (!($44)) {
    break;
   }
   $46 = HEAP32[$i>>2]|0;
   $47 = HEAP32[$1>>2]|0;
   $48 = ((($47)) + 120|0);
   $49 = HEAP32[$48>>2]|0;
   $50 = (($49) + ($46<<2)|0);
   $51 = HEAP32[$50>>2]|0;
   _sqlite3DbFree($45,$51);
   $52 = HEAP32[$i>>2]|0;
   $53 = (($52) + -1)|0;
   HEAP32[$i>>2] = $53;
  }
  $54 = HEAP32[$1>>2]|0;
  $55 = ((($54)) + 120|0);
  $56 = HEAP32[$55>>2]|0;
  _sqlite3DbFree($45,$56);
  $57 = HEAP32[$0>>2]|0;
  $58 = HEAP32[$1>>2]|0;
  $59 = ((($58)) + 180|0);
  $60 = HEAP32[$59>>2]|0;
  _sqlite3DbFree($57,$60);
 }
 $61 = HEAP32[$0>>2]|0;
 $62 = HEAP32[$1>>2]|0;
 $63 = ((($62)) + 88|0);
 $64 = HEAP32[$63>>2]|0;
 $65 = HEAP32[$1>>2]|0;
 $66 = ((($65)) + 136|0);
 $67 = HEAP32[$66>>2]|0;
 _vdbeFreeOpArray($61,$64,$67);
 $68 = HEAP32[$0>>2]|0;
 $69 = HEAP32[$1>>2]|0;
 $70 = ((($69)) + 100|0);
 $71 = HEAP32[$70>>2]|0;
 _sqlite3DbFree($68,$71);
 $72 = HEAP32[$0>>2]|0;
 $73 = HEAP32[$1>>2]|0;
 $74 = ((($73)) + 176|0);
 $75 = HEAP32[$74>>2]|0;
 _sqlite3DbFree($72,$75);
 STACKTOP = sp;return;
}
function _sqlite3DbFree($db,$p) {
 $db = $db|0;
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pBuf = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $pBuf = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  STACKTOP = sp;return;
 }
 $4 = HEAP32[$0>>2]|0;
 $5 = ($4|0)!=(0|0);
 if ($5) {
  $6 = HEAP32[$0>>2]|0;
  $7 = ((($6)) + 456|0);
  $8 = HEAP32[$7>>2]|0;
  $9 = ($8|0)!=(0|0);
  $10 = HEAP32[$0>>2]|0;
  $11 = HEAP32[$1>>2]|0;
  if ($9) {
   _measureAllocationSize($10,$11);
   STACKTOP = sp;return;
  }
  $12 = (_isLookaside($10,$11)|0);
  $13 = ($12|0)!=(0);
  if ($13) {
   $14 = HEAP32[$1>>2]|0;
   HEAP32[$pBuf>>2] = $14;
   $15 = HEAP32[$0>>2]|0;
   $16 = ((($15)) + 256|0);
   $17 = ((($16)) + 28|0);
   $18 = HEAP32[$17>>2]|0;
   $19 = HEAP32[$pBuf>>2]|0;
   HEAP32[$19>>2] = $18;
   $20 = HEAP32[$pBuf>>2]|0;
   $21 = HEAP32[$0>>2]|0;
   $22 = ((($21)) + 256|0);
   $23 = ((($22)) + 28|0);
   HEAP32[$23>>2] = $20;
   $24 = HEAP32[$0>>2]|0;
   $25 = ((($24)) + 256|0);
   $26 = ((($25)) + 8|0);
   $27 = HEAP32[$26>>2]|0;
   $28 = (($27) + -1)|0;
   HEAP32[$26>>2] = $28;
   STACKTOP = sp;return;
  }
 }
 $29 = HEAP32[$1>>2]|0;
 _sqlite3_free($29);
 STACKTOP = sp;return;
}
function _sqlite3MallocInit() {
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $i = 0, $n = 0, $or$cond = 0, $or$cond3 = 0, $or$cond5 = 0, $or$cond7 = 0, $pSlot = 0, $rc = 0, $sz = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $rc = sp + 16|0;
 $i = sp + 12|0;
 $n = sp + 8|0;
 $sz = sp + 4|0;
 $pSlot = sp;
 $0 = HEAP32[(48)>>2]|0;
 $1 = ($0|0)==(0|0);
 if ($1) {
  _sqlite3MemSetDefault();
 }
 ;HEAP32[288>>2]=0|0;HEAP32[288+4>>2]=0|0;HEAP32[288+8>>2]=0|0;HEAP32[288+12>>2]=0|0;HEAP32[288+16>>2]=0|0;HEAP32[288+20>>2]=0|0;HEAP32[288+24>>2]=0|0;HEAP32[288+28>>2]=0|0;
 HEAP32[288>>2] = (8);
 $2 = HEAP32[(200)>>2]|0;
 $3 = ($2|0)!=(0|0);
 $4 = HEAP32[(204)>>2]|0;
 $5 = ($4|0)>=(100);
 $or$cond = $3 & $5;
 $6 = HEAP32[(208)>>2]|0;
 $7 = ($6|0)>(0);
 $or$cond3 = $or$cond & $7;
 if ($or$cond3) {
  $8 = HEAP32[(204)>>2]|0;
  $9 = $8 & -8;
  HEAP32[$sz>>2] = $9;
  $10 = HEAP32[$sz>>2]|0;
  HEAP32[(204)>>2] = $10;
  $11 = HEAP32[(200)>>2]|0;
  HEAP32[$pSlot>>2] = $11;
  $12 = HEAP32[(208)>>2]|0;
  HEAP32[$n>>2] = $12;
  $13 = HEAP32[$pSlot>>2]|0;
  HEAP32[(308)>>2] = $13;
  $14 = HEAP32[$n>>2]|0;
  HEAP32[(312)>>2] = $14;
  HEAP32[$i>>2] = 0;
  while(1) {
   $15 = HEAP32[$i>>2]|0;
   $16 = HEAP32[$n>>2]|0;
   $17 = (($16) - 1)|0;
   $18 = ($15|0)<($17|0);
   if (!($18)) {
    break;
   }
   $19 = HEAP32[$sz>>2]|0;
   $20 = HEAP32[$pSlot>>2]|0;
   $21 = (($20) + ($19)|0);
   $22 = HEAP32[$pSlot>>2]|0;
   HEAP32[$22>>2] = $21;
   $23 = HEAP32[$pSlot>>2]|0;
   $24 = HEAP32[$23>>2]|0;
   HEAP32[$pSlot>>2] = $24;
   $25 = HEAP32[$i>>2]|0;
   $26 = (($25) + 1)|0;
   HEAP32[$i>>2] = $26;
  }
  $27 = HEAP32[$pSlot>>2]|0;
  HEAP32[$27>>2] = 0;
  $28 = HEAP32[$pSlot>>2]|0;
  $29 = ((($28)) + 4|0);
  HEAP32[(304)>>2] = $29;
 } else {
  HEAP32[(304)>>2] = 0;
  HEAP32[(200)>>2] = 0;
  HEAP32[(204)>>2] = 0;
  HEAP32[(208)>>2] = 0;
 }
 $30 = HEAP32[(212)>>2]|0;
 $31 = ($30|0)==(0|0);
 $32 = HEAP32[(216)>>2]|0;
 $33 = ($32|0)<(512);
 $or$cond5 = $31 | $33;
 $34 = HEAP32[(220)>>2]|0;
 $35 = ($34|0)<=(0);
 $or$cond7 = $or$cond5 | $35;
 if ($or$cond7) {
  HEAP32[(212)>>2] = 0;
  HEAP32[(216)>>2] = 0;
 }
 $36 = HEAP32[(68)>>2]|0;
 $37 = HEAP32[(76)>>2]|0;
 $38 = (FUNCTION_TABLE_ii[$36 & 255]($37)|0);
 HEAP32[$rc>>2] = $38;
 $39 = HEAP32[$rc>>2]|0;
 $40 = ($39|0)!=(0);
 if (!($40)) {
  $41 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($41|0);
 }
 ;HEAP32[288>>2]=0|0;HEAP32[288+4>>2]=0|0;HEAP32[288+8>>2]=0|0;HEAP32[288+12>>2]=0|0;HEAP32[288+16>>2]=0|0;HEAP32[288+20>>2]=0|0;HEAP32[288+24>>2]=0|0;HEAP32[288+28>>2]=0|0;
 $41 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($41|0);
}
function _sqlite3RegisterBuiltinFunctions() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 _sqlite3AlterFunctions();
 _sqlite3RegisterDateTimeFunctions();
 _sqlite3InsertBuiltinFuncs(6956,57);
 return;
}
function _sqlite3PcacheInitialize() {
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[(124)>>2]|0;
 $1 = ($0|0)==(0|0);
 if ($1) {
  _sqlite3PCacheSetDefault();
 }
 $2 = HEAP32[(124)>>2]|0;
 $3 = HEAP32[(120)>>2]|0;
 $4 = (FUNCTION_TABLE_ii[$2 & 255]($3)|0);
 return ($4|0);
}
function _sqlite3OsInit() {
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 $1 = (_sqlite3_malloc(10)|0);
 HEAP32[$p>>2] = $1;
 $2 = HEAP32[$p>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  HEAP32[$0>>2] = 7;
  $6 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($6|0);
 } else {
  $4 = HEAP32[$p>>2]|0;
  _sqlite3_free($4);
  $5 = (_sqlite3_os_init()|0);
  HEAP32[$0>>2] = $5;
  $6 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($6|0);
 }
 return (0)|0;
}
function _sqlite3PCacheBufferSetup($pBuf,$sz,$n) {
 $pBuf = $pBuf|0;
 $sz = $sz|0;
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pBuf;
 HEAP32[$1>>2] = $sz;
 HEAP32[$2>>2] = $n;
 $3 = HEAP32[(1680)>>2]|0;
 $4 = ($3|0)!=(0);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$0>>2]|0;
 $6 = ($5|0)==(0|0);
 if ($6) {
  HEAP32[$2>>2] = 0;
  HEAP32[$1>>2] = 0;
 }
 $7 = HEAP32[$1>>2]|0;
 $8 = $7 & -8;
 HEAP32[$1>>2] = $8;
 $9 = HEAP32[$1>>2]|0;
 HEAP32[(1692)>>2] = $9;
 $10 = HEAP32[$2>>2]|0;
 HEAP32[(1720)>>2] = $10;
 HEAP32[(1696)>>2] = $10;
 $11 = HEAP32[$2>>2]|0;
 $12 = ($11|0)>(90);
 if ($12) {
  $16 = 10;
 } else {
  $13 = HEAP32[$2>>2]|0;
  $14 = (($13|0) / 10)&-1;
  $15 = (($14) + 1)|0;
  $16 = $15;
 }
 HEAP32[(1700)>>2] = $16;
 $17 = HEAP32[$0>>2]|0;
 HEAP32[(1704)>>2] = $17;
 HEAP32[(1716)>>2] = 0;
 HEAP32[(1724)>>2] = 0;
 while(1) {
  $18 = HEAP32[$2>>2]|0;
  $19 = (($18) + -1)|0;
  HEAP32[$2>>2] = $19;
  $20 = ($18|0)!=(0);
  $21 = HEAP32[$0>>2]|0;
  if (!($20)) {
   break;
  }
  HEAP32[$p>>2] = $21;
  $22 = HEAP32[(1716)>>2]|0;
  $23 = HEAP32[$p>>2]|0;
  HEAP32[$23>>2] = $22;
  $24 = HEAP32[$p>>2]|0;
  HEAP32[(1716)>>2] = $24;
  $25 = HEAP32[$1>>2]|0;
  $26 = HEAP32[$0>>2]|0;
  $27 = (($26) + ($25)|0);
  HEAP32[$0>>2] = $27;
 }
 HEAP32[(1708)>>2] = $21;
 STACKTOP = sp;return;
}
function _vfsUnlink($pVfs) {
 $pVfs = $pVfs|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pVfs;
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  STACKTOP = sp;return;
 }
 $3 = HEAP32[1088>>2]|0;
 $4 = HEAP32[$0>>2]|0;
 $5 = ($3|0)==($4|0);
 if ($5) {
  $6 = HEAP32[$0>>2]|0;
  $7 = ((($6)) + 12|0);
  $8 = HEAP32[$7>>2]|0;
  HEAP32[1088>>2] = $8;
  STACKTOP = sp;return;
 }
 $9 = HEAP32[1088>>2]|0;
 $10 = ($9|0)!=(0|0);
 if (!($10)) {
  STACKTOP = sp;return;
 }
 $11 = HEAP32[1088>>2]|0;
 HEAP32[$p>>2] = $11;
 while(1) {
  $12 = HEAP32[$p>>2]|0;
  $13 = ((($12)) + 12|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = ($14|0)!=(0|0);
  if ($15) {
   $16 = HEAP32[$p>>2]|0;
   $17 = ((($16)) + 12|0);
   $18 = HEAP32[$17>>2]|0;
   $19 = HEAP32[$0>>2]|0;
   $20 = ($18|0)!=($19|0);
   $31 = $20;
  } else {
   $31 = 0;
  }
  $21 = HEAP32[$p>>2]|0;
  $22 = ((($21)) + 12|0);
  $23 = HEAP32[$22>>2]|0;
  if (!($31)) {
   break;
  }
  HEAP32[$p>>2] = $23;
 }
 $24 = HEAP32[$0>>2]|0;
 $25 = ($23|0)==($24|0);
 if (!($25)) {
  STACKTOP = sp;return;
 }
 $26 = HEAP32[$0>>2]|0;
 $27 = ((($26)) + 12|0);
 $28 = HEAP32[$27>>2]|0;
 $29 = HEAP32[$p>>2]|0;
 $30 = ((($29)) + 12|0);
 HEAP32[$30>>2] = $28;
 STACKTOP = sp;return;
}
function _sqlite3StatusValue($op) {
 $op = $op|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $op;
 $1 = HEAP32[$0>>2]|0;
 $2 = (1008 + ($1<<2)|0);
 $3 = HEAP32[$2>>2]|0;
 tempRet0 = (0);
 STACKTOP = sp;return ($3|0);
}
function _sqlite3Malloc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $or$cond = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $2 = sp;
 $p = sp + 8|0;
 $3 = $2;
 $4 = $3;
 HEAP32[$4>>2] = $0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = $1;
 $7 = $2;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) + 4)|0;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = ($9|0)==(0);
 $14 = ($12|0)==(0);
 $15 = $13 & $14;
 $16 = $2;
 $17 = $16;
 $18 = HEAP32[$17>>2]|0;
 $19 = (($16) + 4)|0;
 $20 = $19;
 $21 = HEAP32[$20>>2]|0;
 $22 = ($21>>>0)>(0);
 $23 = ($18>>>0)>=(2147483392);
 $24 = ($21|0)==(0);
 $25 = $24 & $23;
 $26 = $22 | $25;
 $or$cond = $15 | $26;
 if ($or$cond) {
  HEAP32[$p>>2] = 0;
  $43 = HEAP32[$p>>2]|0;
  STACKTOP = sp;return ($43|0);
 }
 $27 = HEAP32[8>>2]|0;
 $28 = ($27|0)!=(0);
 if ($28) {
  $29 = $2;
  $30 = $29;
  $31 = HEAP32[$30>>2]|0;
  $32 = (($29) + 4)|0;
  $33 = $32;
  $34 = HEAP32[$33>>2]|0;
  (_mallocWithAlarm($31,$p)|0);
  $43 = HEAP32[$p>>2]|0;
  STACKTOP = sp;return ($43|0);
 } else {
  $35 = HEAP32[(48)>>2]|0;
  $36 = $2;
  $37 = $36;
  $38 = HEAP32[$37>>2]|0;
  $39 = (($36) + 4)|0;
  $40 = $39;
  $41 = HEAP32[$40>>2]|0;
  $42 = (FUNCTION_TABLE_ii[$35 & 255]($38)|0);
  HEAP32[$p>>2] = $42;
  $43 = HEAP32[$p>>2]|0;
  STACKTOP = sp;return ($43|0);
 }
 return (0)|0;
}
function _sqlite3MallocSize($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[(60)>>2]|0;
 $2 = HEAP32[$0>>2]|0;
 $3 = (FUNCTION_TABLE_ii[$1 & 255]($2)|0);
 STACKTOP = sp;return ($3|0);
}
function _sqlite3StatusDown($op,$N) {
 $op = $op|0;
 $N = $N|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $op;
 HEAP32[$1>>2] = $N;
 $2 = HEAP32[$1>>2]|0;
 $3 = HEAP32[$0>>2]|0;
 $4 = (1008 + ($3<<2)|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (($5) - ($2))|0;
 HEAP32[$4>>2] = $6;
 STACKTOP = sp;return;
}
function _sqlite3Realloc($pOld,$0,$1) {
 $pOld = $pOld|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $12 = 0;
 var $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $nDiff = 0, $nNew = 0, $nOld = 0, $or$cond = 0, $pNew = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 28|0;
 $3 = sp + 24|0;
 $4 = sp;
 $nOld = sp + 20|0;
 $nNew = sp + 16|0;
 $nDiff = sp + 12|0;
 $pNew = sp + 8|0;
 HEAP32[$3>>2] = $pOld;
 $5 = $4;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 $9 = HEAP32[$3>>2]|0;
 $10 = ($9|0)==(0|0);
 $11 = $4;
 $12 = $11;
 $13 = HEAP32[$12>>2]|0;
 $14 = (($11) + 4)|0;
 $15 = $14;
 $16 = HEAP32[$15>>2]|0;
 if ($10) {
  $17 = (_sqlite3Malloc($13,$16)|0);
  HEAP32[$2>>2] = $17;
  $116 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($116|0);
 }
 $18 = ($13|0)==(0);
 $19 = ($16|0)==(0);
 $20 = $18 & $19;
 if ($20) {
  $21 = HEAP32[$3>>2]|0;
  _sqlite3_free($21);
  HEAP32[$2>>2] = 0;
  $116 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($116|0);
 }
 $22 = $4;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 $25 = (($22) + 4)|0;
 $26 = $25;
 $27 = HEAP32[$26>>2]|0;
 $28 = ($27>>>0)>(0);
 $29 = ($24>>>0)>=(2147483392);
 $30 = ($27|0)==(0);
 $31 = $30 & $29;
 $32 = $28 | $31;
 if ($32) {
  HEAP32[$2>>2] = 0;
  $116 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($116|0);
 }
 $33 = HEAP32[$3>>2]|0;
 $34 = (_sqlite3MallocSize($33)|0);
 HEAP32[$nOld>>2] = $34;
 $35 = HEAP32[(64)>>2]|0;
 $36 = $4;
 $37 = $36;
 $38 = HEAP32[$37>>2]|0;
 $39 = (($36) + 4)|0;
 $40 = $39;
 $41 = HEAP32[$40>>2]|0;
 $42 = (FUNCTION_TABLE_ii[$35 & 255]($38)|0);
 HEAP32[$nNew>>2] = $42;
 $43 = HEAP32[$nOld>>2]|0;
 $44 = HEAP32[$nNew>>2]|0;
 $45 = ($43|0)==($44|0);
 do {
  if ($45) {
   $46 = HEAP32[$3>>2]|0;
   HEAP32[$pNew>>2] = $46;
  } else {
   $47 = HEAP32[8>>2]|0;
   $48 = ($47|0)!=(0);
   if (!($48)) {
    $111 = HEAP32[(56)>>2]|0;
    $112 = HEAP32[$3>>2]|0;
    $113 = HEAP32[$nNew>>2]|0;
    $114 = (FUNCTION_TABLE_iii[$111 & 255]($112,$113)|0);
    HEAP32[$pNew>>2] = $114;
    break;
   }
   $49 = $4;
   $50 = $49;
   $51 = HEAP32[$50>>2]|0;
   $52 = (($49) + 4)|0;
   $53 = $52;
   $54 = HEAP32[$53>>2]|0;
   _sqlite3StatusHighwater(5,$51);
   $55 = HEAP32[$nNew>>2]|0;
   $56 = HEAP32[$nOld>>2]|0;
   $57 = (($55) - ($56))|0;
   HEAP32[$nDiff>>2] = $57;
   $58 = (_sqlite3StatusValue(0)|0);
   $59 = tempRet0;
   $60 = (296);
   $61 = $60;
   $62 = HEAP32[$61>>2]|0;
   $63 = (($60) + 4)|0;
   $64 = $63;
   $65 = HEAP32[$64>>2]|0;
   $66 = HEAP32[$nDiff>>2]|0;
   $67 = ($66|0)<(0);
   $68 = $67 << 31 >> 31;
   $69 = (_i64Subtract(($62|0),($65|0),($66|0),($68|0))|0);
   $70 = tempRet0;
   $71 = ($59|0)>($70|0);
   $72 = ($58>>>0)>=($69>>>0);
   $73 = ($59|0)==($70|0);
   $74 = $73 & $72;
   $75 = $71 | $74;
   if ($75) {
    $76 = HEAP32[$nDiff>>2]|0;
    _sqlite3MallocAlarm($76);
   }
   $77 = HEAP32[(56)>>2]|0;
   $78 = HEAP32[$3>>2]|0;
   $79 = HEAP32[$nNew>>2]|0;
   $80 = (FUNCTION_TABLE_iii[$77 & 255]($78,$79)|0);
   HEAP32[$pNew>>2] = $80;
   $81 = HEAP32[$pNew>>2]|0;
   $82 = ($81|0)==(0|0);
   $83 = (296);
   $84 = $83;
   $85 = HEAP32[$84>>2]|0;
   $86 = (($83) + 4)|0;
   $87 = $86;
   $88 = HEAP32[$87>>2]|0;
   $89 = ($88|0)>(0);
   $90 = ($85>>>0)>(0);
   $91 = ($88|0)==(0);
   $92 = $91 & $90;
   $93 = $89 | $92;
   $or$cond = $82 & $93;
   if ($or$cond) {
    $94 = $4;
    $95 = $94;
    $96 = HEAP32[$95>>2]|0;
    $97 = (($94) + 4)|0;
    $98 = $97;
    $99 = HEAP32[$98>>2]|0;
    _sqlite3MallocAlarm($96);
    $100 = HEAP32[(56)>>2]|0;
    $101 = HEAP32[$3>>2]|0;
    $102 = HEAP32[$nNew>>2]|0;
    $103 = (FUNCTION_TABLE_iii[$100 & 255]($101,$102)|0);
    HEAP32[$pNew>>2] = $103;
   }
   $104 = HEAP32[$pNew>>2]|0;
   $105 = ($104|0)!=(0|0);
   if ($105) {
    $106 = HEAP32[$pNew>>2]|0;
    $107 = (_sqlite3MallocSize($106)|0);
    HEAP32[$nNew>>2] = $107;
    $108 = HEAP32[$nNew>>2]|0;
    $109 = HEAP32[$nOld>>2]|0;
    $110 = (($108) - ($109))|0;
    _sqlite3StatusUp(0,$110);
   }
  }
 } while(0);
 $115 = HEAP32[$pNew>>2]|0;
 HEAP32[$2>>2] = $115;
 $116 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($116|0);
}
function _sqlite3StrAccumInit($p,$db,$zBase,$n,$mx) {
 $p = $p|0;
 $db = $db|0;
 $zBase = $zBase|0;
 $n = $n|0;
 $mx = $mx|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $3 = sp + 4|0;
 $4 = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $db;
 HEAP32[$2>>2] = $zBase;
 HEAP32[$3>>2] = $n;
 HEAP32[$4>>2] = $mx;
 $5 = HEAP32[$2>>2]|0;
 $6 = HEAP32[$0>>2]|0;
 $7 = ((($6)) + 4|0);
 HEAP32[$7>>2] = $5;
 $8 = HEAP32[$0>>2]|0;
 $9 = ((($8)) + 8|0);
 HEAP32[$9>>2] = $5;
 $10 = HEAP32[$1>>2]|0;
 $11 = HEAP32[$0>>2]|0;
 HEAP32[$11>>2] = $10;
 $12 = HEAP32[$0>>2]|0;
 $13 = ((($12)) + 12|0);
 HEAP32[$13>>2] = 0;
 $14 = HEAP32[$3>>2]|0;
 $15 = HEAP32[$0>>2]|0;
 $16 = ((($15)) + 16|0);
 HEAP32[$16>>2] = $14;
 $17 = HEAP32[$4>>2]|0;
 $18 = HEAP32[$0>>2]|0;
 $19 = ((($18)) + 20|0);
 HEAP32[$19>>2] = $17;
 $20 = HEAP32[$0>>2]|0;
 $21 = ((($20)) + 24|0);
 HEAP8[$21>>0] = 0;
 $22 = HEAP32[$0>>2]|0;
 $23 = ((($22)) + 25|0);
 HEAP8[$23>>0] = 0;
 STACKTOP = sp;return;
}
function _sqlite3VXPrintf($pAccum,$fmt,$ap) {
 $pAccum = $pAccum|0;
 $fmt = $fmt|0;
 $ap = $ap|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $1000 = 0, $1001 = 0, $1002 = 0, $1003 = 0, $1004 = 0, $1005 = 0, $1006 = 0, $1007 = 0, $1008 = 0, $1009 = 0, $101 = 0, $1010 = 0, $1011 = 0, $1012 = 0, $1013 = 0, $1014 = 0;
 var $1015 = 0, $1016 = 0, $1017 = 0, $1018 = 0, $1019 = 0, $102 = 0, $1020 = 0, $1021 = 0, $1022 = 0, $1023 = 0, $1024 = 0, $1025 = 0, $1026 = 0, $1027 = 0, $1028 = 0, $1029 = 0, $103 = 0, $1030 = 0, $1031 = 0, $1032 = 0;
 var $1033 = 0, $1034 = 0, $1035 = 0, $1036 = 0, $1037 = 0, $1038 = 0, $1039 = 0, $104 = 0, $1040 = 0, $1041 = 0, $1042 = 0, $1043 = 0, $1044 = 0, $1045 = 0, $1046 = 0, $1047 = 0, $1048 = 0, $1049 = 0, $105 = 0, $1050 = 0;
 var $1051 = 0, $1052 = 0, $1053 = 0, $1054 = 0, $1055 = 0, $1056 = 0, $1057 = 0, $1058 = 0, $1059 = 0, $106 = 0, $1060 = 0, $1061 = 0, $1062 = 0, $1063 = 0, $1064 = 0, $1065 = 0, $1066 = 0, $1067 = 0, $1068 = 0, $1069 = 0;
 var $107 = 0, $1070 = 0, $1071 = 0, $1072 = 0, $1073 = 0, $1074 = 0, $1075 = 0, $1076 = 0, $1077 = 0, $1078 = 0, $1079 = 0, $108 = 0, $1080 = 0, $1081 = 0, $1082 = 0, $1083 = 0, $1084 = 0, $1085 = 0, $1086 = 0, $1087 = 0;
 var $1088 = 0, $1089 = 0, $109 = 0, $1090 = 0, $1091 = 0, $1092 = 0, $1093 = 0, $1094 = 0, $1095 = 0, $1096 = 0, $1097 = 0, $1098 = 0, $1099 = 0, $11 = 0, $110 = 0, $1100 = 0, $1101 = 0, $1102 = 0, $1103 = 0, $1104 = 0;
 var $1105 = 0, $1106 = 0, $1107 = 0, $1108 = 0, $1109 = 0, $111 = 0, $1110 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0;
 var $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0;
 var $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0;
 var $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0;
 var $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0;
 var $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0;
 var $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0;
 var $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0;
 var $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0;
 var $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0;
 var $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0;
 var $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0;
 var $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0;
 var $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0;
 var $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0;
 var $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0, $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0;
 var $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0;
 var $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0;
 var $430 = 0, $431 = 0, $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0, $440 = 0, $441 = 0, $442 = 0, $443 = 0, $444 = 0, $445 = 0, $446 = 0, $447 = 0, $448 = 0;
 var $449 = 0, $45 = 0, $450 = 0, $451 = 0, $452 = 0, $453 = 0, $454 = 0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $461 = 0, $462 = 0, $463 = 0, $464 = 0, $465 = 0, $466 = 0;
 var $467 = 0, $468 = 0, $469 = 0, $47 = 0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $474 = 0, $475 = 0, $476 = 0, $477 = 0, $478 = 0, $479 = 0, $48 = 0, $480 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0;
 var $485 = 0, $486 = 0, $487 = 0, $488 = 0, $489 = 0, $49 = 0, $490 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0, $498 = 0, $499 = 0, $5 = 0, $50 = 0, $500 = 0, $501 = 0;
 var $502 = 0, $503 = 0.0, $504 = 0, $505 = 0, $506 = 0, $507 = 0, $508 = 0, $509 = 0, $51 = 0, $510 = 0, $511 = 0.0, $512 = 0, $513 = 0, $514 = 0.0, $515 = 0, $516 = 0.0, $517 = 0.0, $518 = 0, $519 = 0, $52 = 0;
 var $520 = 0, $521 = 0, $522 = 0, $523 = 0, $524 = 0, $525 = 0, $526 = 0, $527 = 0, $528 = 0, $529 = 0, $53 = 0, $530 = 0, $531 = 0, $532 = 0, $533 = 0, $534 = 0, $535 = 0.0, $536 = 0.0, $537 = 0, $538 = 0;
 var $539 = 0, $54 = 0, $540 = 0.0, $541 = 0.0, $542 = 0.0, $543 = 0.0, $544 = 0, $545 = 0, $546 = 0.0, $547 = 0, $548 = 0.0, $549 = 0.0, $55 = 0, $550 = 0.0, $551 = 0, $552 = 0, $553 = 0, $554 = 0, $555 = 0.0, $556 = 0.0;
 var $557 = 0, $558 = 0, $559 = 0.0, $56 = 0, $560 = 0.0, $561 = 0.0, $562 = 0, $563 = 0, $564 = 0, $565 = 0, $566 = 0.0, $567 = 0.0, $568 = 0, $569 = 0, $57 = 0, $570 = 0.0, $571 = 0.0, $572 = 0.0, $573 = 0, $574 = 0;
 var $575 = 0, $576 = 0, $577 = 0.0, $578 = 0.0, $579 = 0, $58 = 0, $580 = 0, $581 = 0.0, $582 = 0.0, $583 = 0.0, $584 = 0, $585 = 0.0, $586 = 0.0, $587 = 0, $588 = 0, $589 = 0.0, $59 = 0, $590 = 0, $591 = 0.0, $592 = 0.0;
 var $593 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0, $598 = 0, $599 = 0, $6 = 0, $60 = 0, $600 = 0, $601 = 0, $602 = 0, $603 = 0, $604 = 0, $605 = 0, $606 = 0, $607 = 0, $608 = 0, $609 = 0, $61 = 0;
 var $610 = 0, $611 = 0.0, $612 = 0.0, $613 = 0.0, $614 = 0.0, $615 = 0, $616 = 0.0, $617 = 0.0, $618 = 0, $619 = 0, $62 = 0, $620 = 0, $621 = 0, $622 = 0, $623 = 0, $624 = 0, $625 = 0, $626 = 0, $627 = 0, $628 = 0;
 var $629 = 0, $63 = 0, $630 = 0, $631 = 0, $632 = 0, $633 = 0, $634 = 0, $635 = 0, $636 = 0, $637 = 0, $638 = 0, $639 = 0, $64 = 0, $640 = 0, $641 = 0, $642 = 0, $643 = 0, $644 = 0, $645 = 0, $646 = 0;
 var $647 = 0, $648 = 0, $649 = 0, $65 = 0, $650 = 0, $651 = 0, $652 = 0, $653 = 0, $654 = 0, $655 = 0, $656 = 0, $657 = 0, $658 = 0, $659 = 0, $66 = 0, $660 = 0, $661 = 0, $662 = 0, $663 = 0, $664 = 0;
 var $665 = 0, $666 = 0, $667 = 0, $668 = 0, $669 = 0, $67 = 0, $670 = 0, $671 = 0, $672 = 0, $673 = 0, $674 = 0, $675 = 0, $676 = 0, $677 = 0, $678 = 0, $679 = 0, $68 = 0, $680 = 0, $681 = 0, $682 = 0;
 var $683 = 0, $684 = 0, $685 = 0, $686 = 0, $687 = 0, $688 = 0, $689 = 0, $69 = 0, $690 = 0, $691 = 0, $692 = 0, $693 = 0, $694 = 0, $695 = 0, $696 = 0, $697 = 0, $698 = 0, $699 = 0, $7 = 0, $70 = 0;
 var $700 = 0, $701 = 0, $702 = 0, $703 = 0, $704 = 0, $705 = 0, $706 = 0, $707 = 0, $708 = 0, $709 = 0, $71 = 0, $710 = 0, $711 = 0, $712 = 0, $713 = 0, $714 = 0, $715 = 0, $716 = 0, $717 = 0, $718 = 0;
 var $719 = 0, $72 = 0, $720 = 0, $721 = 0, $722 = 0, $723 = 0, $724 = 0, $725 = 0, $726 = 0, $727 = 0, $728 = 0, $729 = 0, $73 = 0, $730 = 0, $731 = 0, $732 = 0, $733 = 0, $734 = 0, $735 = 0, $736 = 0;
 var $737 = 0, $738 = 0, $739 = 0, $74 = 0, $740 = 0, $741 = 0, $742 = 0, $743 = 0, $744 = 0, $745 = 0, $746 = 0, $747 = 0, $748 = 0, $749 = 0, $75 = 0, $750 = 0, $751 = 0, $752 = 0, $753 = 0, $754 = 0;
 var $755 = 0, $756 = 0, $757 = 0, $758 = 0, $759 = 0, $76 = 0, $760 = 0, $761 = 0, $762 = 0, $763 = 0, $764 = 0, $765 = 0, $766 = 0, $767 = 0, $768 = 0, $769 = 0, $77 = 0, $770 = 0, $771 = 0, $772 = 0;
 var $773 = 0, $774 = 0, $775 = 0, $776 = 0, $777 = 0, $778 = 0, $779 = 0, $78 = 0, $780 = 0, $781 = 0, $782 = 0, $783 = 0, $784 = 0, $785 = 0, $786 = 0, $787 = 0, $788 = 0, $789 = 0, $79 = 0, $790 = 0;
 var $791 = 0, $792 = 0, $793 = 0, $794 = 0, $795 = 0, $796 = 0, $797 = 0, $798 = 0, $799 = 0, $8 = 0, $80 = 0, $800 = 0, $801 = 0, $802 = 0, $803 = 0, $804 = 0, $805 = 0, $806 = 0, $807 = 0, $808 = 0;
 var $809 = 0, $81 = 0, $810 = 0, $811 = 0, $812 = 0, $813 = 0, $814 = 0, $815 = 0, $816 = 0, $817 = 0, $818 = 0, $819 = 0, $82 = 0, $820 = 0, $821 = 0, $822 = 0, $823 = 0, $824 = 0, $825 = 0, $826 = 0;
 var $827 = 0, $828 = 0, $829 = 0, $83 = 0, $830 = 0, $831 = 0, $832 = 0, $833 = 0, $834 = 0, $835 = 0, $836 = 0, $837 = 0, $838 = 0, $839 = 0, $84 = 0, $840 = 0, $841 = 0, $842 = 0, $843 = 0, $844 = 0;
 var $845 = 0, $846 = 0, $847 = 0, $848 = 0, $849 = 0, $85 = 0, $850 = 0, $851 = 0, $852 = 0, $853 = 0, $854 = 0, $855 = 0, $856 = 0, $857 = 0, $858 = 0, $859 = 0, $86 = 0, $860 = 0, $861 = 0, $862 = 0;
 var $863 = 0, $864 = 0, $865 = 0, $866 = 0, $867 = 0, $868 = 0, $869 = 0, $87 = 0, $870 = 0, $871 = 0, $872 = 0, $873 = 0, $874 = 0, $875 = 0, $876 = 0, $877 = 0, $878 = 0, $879 = 0, $88 = 0, $880 = 0;
 var $881 = 0, $882 = 0, $883 = 0, $884 = 0, $885 = 0, $886 = 0, $887 = 0, $888 = 0, $889 = 0, $89 = 0, $890 = 0, $891 = 0, $892 = 0, $893 = 0, $894 = 0, $895 = 0, $896 = 0, $897 = 0, $898 = 0, $899 = 0;
 var $9 = 0, $90 = 0, $900 = 0, $901 = 0, $902 = 0, $903 = 0, $904 = 0, $905 = 0, $906 = 0, $907 = 0, $908 = 0, $909 = 0, $91 = 0, $910 = 0, $911 = 0, $912 = 0, $913 = 0, $914 = 0, $915 = 0, $916 = 0;
 var $917 = 0, $918 = 0, $919 = 0, $92 = 0, $920 = 0, $921 = 0, $922 = 0, $923 = 0, $924 = 0, $925 = 0, $926 = 0, $927 = 0, $928 = 0, $929 = 0, $93 = 0, $930 = 0, $931 = 0, $932 = 0, $933 = 0, $934 = 0;
 var $935 = 0, $936 = 0, $937 = 0, $938 = 0, $939 = 0, $94 = 0, $940 = 0, $941 = 0, $942 = 0, $943 = 0, $944 = 0, $945 = 0, $946 = 0, $947 = 0, $948 = 0, $949 = 0, $95 = 0, $950 = 0, $951 = 0, $952 = 0;
 var $953 = 0, $954 = 0, $955 = 0, $956 = 0, $957 = 0, $958 = 0, $959 = 0, $96 = 0, $960 = 0, $961 = 0, $962 = 0, $963 = 0, $964 = 0, $965 = 0, $966 = 0, $967 = 0, $968 = 0, $969 = 0, $97 = 0, $970 = 0;
 var $971 = 0, $972 = 0, $973 = 0, $974 = 0, $975 = 0, $976 = 0, $977 = 0, $978 = 0, $979 = 0, $98 = 0, $980 = 0, $981 = 0, $982 = 0, $983 = 0, $984 = 0, $985 = 0, $986 = 0, $987 = 0, $988 = 0, $989 = 0;
 var $99 = 0, $990 = 0, $991 = 0, $992 = 0, $993 = 0, $994 = 0, $995 = 0, $996 = 0, $997 = 0, $998 = 0, $999 = 0, $arglist_current = 0, $arglist_current12 = 0, $arglist_current15 = 0, $arglist_current18 = 0, $arglist_current21 = 0, $arglist_current24 = 0, $arglist_current27 = 0, $arglist_current30 = 0, $arglist_current33 = 0;
 var $arglist_current36 = 0, $arglist_current39 = 0, $arglist_current42 = 0, $arglist_current45 = 0, $arglist_current48 = 0, $arglist_current51 = 0, $arglist_next = 0, $arglist_next13 = 0, $arglist_next16 = 0, $arglist_next19 = 0, $arglist_next22 = 0, $arglist_next25 = 0, $arglist_next28 = 0, $arglist_next31 = 0, $arglist_next34 = 0, $arglist_next37 = 0, $arglist_next40 = 0, $arglist_next43 = 0, $arglist_next46 = 0, $arglist_next49 = 0;
 var $arglist_next52 = 0, $bArgList = 0, $base = 0, $buf = 0, $bufpt = 0, $c = 0, $ch = 0, $cset = 0, $done = 0, $e2 = 0, $escarg = 0, $exp = 0, $expanded = 0, $expanded101 = 0, $expanded102 = 0, $expanded104 = 0, $expanded105 = 0, $expanded106 = 0, $expanded108 = 0, $expanded109 = 0;
 var $expanded111 = 0, $expanded112 = 0, $expanded113 = 0, $expanded115 = 0, $expanded116 = 0, $expanded118 = 0, $expanded119 = 0, $expanded120 = 0, $expanded122 = 0, $expanded123 = 0, $expanded125 = 0, $expanded126 = 0, $expanded127 = 0, $expanded129 = 0, $expanded130 = 0, $expanded132 = 0, $expanded133 = 0, $expanded134 = 0, $expanded136 = 0, $expanded137 = 0;
 var $expanded139 = 0, $expanded140 = 0, $expanded141 = 0, $expanded143 = 0, $expanded144 = 0, $expanded146 = 0, $expanded147 = 0, $expanded148 = 0, $expanded150 = 0, $expanded151 = 0, $expanded153 = 0, $expanded154 = 0, $expanded155 = 0, $expanded53 = 0, $expanded55 = 0, $expanded56 = 0, $expanded57 = 0, $expanded59 = 0, $expanded60 = 0, $expanded62 = 0;
 var $expanded63 = 0, $expanded64 = 0, $expanded66 = 0, $expanded67 = 0, $expanded69 = 0, $expanded70 = 0, $expanded71 = 0, $expanded73 = 0, $expanded74 = 0, $expanded76 = 0, $expanded77 = 0, $expanded78 = 0, $expanded80 = 0, $expanded81 = 0, $expanded83 = 0, $expanded84 = 0, $expanded85 = 0, $expanded87 = 0, $expanded88 = 0, $expanded90 = 0;
 var $expanded91 = 0, $expanded92 = 0, $expanded94 = 0, $expanded95 = 0, $expanded97 = 0, $expanded98 = 0, $expanded99 = 0, $flag_alternateform = 0, $flag_altform2 = 0, $flag_blanksign = 0, $flag_dp = 0, $flag_leftjustify = 0, $flag_long = 0, $flag_longlong = 0, $flag_plussign = 0, $flag_rtz = 0, $flag_zeropad = 0, $i = 0, $i2 = 0, $idx = 0;
 var $infop = 0, $isnull = 0, $j = 0, $k = 0, $k3 = 0, $length = 0, $longvalue = 0, $n = 0, $nOut = 0, $nPad = 0, $needQuote = 0, $nsd = 0, $or$cond = 0, $or$cond10 = 0, $or$cond4 = 0, $or$cond6 = 0, $pArgList = 0, $pItem = 0, $pSrc = 0, $pToken = 0;
 var $pre = 0, $precision = 0, $prefix = 0, $px = 0, $q = 0, $realvalue = 0, $rounder = 0, $scale = 0, $useIntern = 0, $v = 0, $width = 0, $wx = 0, $x = 0, $x1 = 0, $xtype = 0, $zExtra = 0, $zOut = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0;
 $0 = sp + 176|0;
 $1 = sp + 172|0;
 $2 = sp + 168|0;
 $c = sp + 164|0;
 $bufpt = sp + 160|0;
 $precision = sp + 156|0;
 $length = sp + 152|0;
 $idx = sp + 148|0;
 $width = sp + 144|0;
 $flag_leftjustify = sp + 268|0;
 $flag_plussign = sp + 267|0;
 $flag_blanksign = sp + 266|0;
 $flag_alternateform = sp + 265|0;
 $flag_altform2 = sp + 264|0;
 $flag_zeropad = sp + 263|0;
 $flag_long = sp + 262|0;
 $flag_longlong = sp + 261|0;
 $done = sp + 260|0;
 $xtype = sp + 259|0;
 $bArgList = sp + 258|0;
 $useIntern = sp + 257|0;
 $prefix = sp + 256|0;
 $longvalue = sp + 32|0;
 $realvalue = sp + 24|0;
 $infop = sp + 140|0;
 $zOut = sp + 136|0;
 $nOut = sp + 132|0;
 $zExtra = sp + 128|0;
 $exp = sp + 124|0;
 $e2 = sp + 120|0;
 $nsd = sp + 116|0;
 $rounder = sp + 16|0;
 $flag_dp = sp + 255|0;
 $flag_rtz = sp + 254|0;
 $pArgList = sp + 112|0;
 $buf = sp + 184|0;
 $wx = sp + 108|0;
 $px = sp + 104|0;
 $v = sp + 8|0;
 $x = sp + 100|0;
 $cset = sp + 96|0;
 $base = sp + 183|0;
 $pre = sp + 92|0;
 $x1 = sp + 182|0;
 $scale = sp;
 $i = sp + 88|0;
 $nPad = sp + 84|0;
 $i2 = sp + 80|0;
 $j = sp + 76|0;
 $k = sp + 72|0;
 $n = sp + 68|0;
 $isnull = sp + 64|0;
 $needQuote = sp + 60|0;
 $ch = sp + 181|0;
 $q = sp + 180|0;
 $escarg = sp + 56|0;
 $pToken = sp + 52|0;
 $pSrc = sp + 48|0;
 $k3 = sp + 44|0;
 $pItem = sp + 40|0;
 HEAP32[$0>>2] = $pAccum;
 HEAP32[$1>>2] = $fmt;
 HEAP32[$2>>2] = $ap;
 HEAP8[$xtype>>0] = 16;
 HEAP32[$zExtra>>2] = 0;
 HEAP32[$pArgList>>2] = 0;
 HEAP32[$bufpt>>2] = 0;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 25|0);
 $5 = HEAP8[$4>>0]|0;
 $6 = ($5<<24>>24)!=(0);
 if ($6) {
  $7 = HEAP32[$0>>2]|0;
  $8 = ((($7)) + 25|0);
  $9 = HEAP8[$8>>0]|0;
  $10 = $9&255;
  $11 = $10 & 2;
  $12 = $11&255;
  HEAP8[$bArgList>>0] = $12;
  $13 = $12&255;
  $14 = ($13|0)!=(0);
  if ($14) {
   $15 = HEAP32[$2>>2]|0;
   $arglist_current = HEAP32[$15>>2]|0;
   $16 = $arglist_current;
   $17 = ((0) + 4|0);
   $expanded53 = $17;
   $expanded = (($expanded53) - 1)|0;
   $18 = (($16) + ($expanded))|0;
   $19 = ((0) + 4|0);
   $expanded57 = $19;
   $expanded56 = (($expanded57) - 1)|0;
   $expanded55 = $expanded56 ^ -1;
   $20 = $18 & $expanded55;
   $21 = $20;
   $22 = HEAP32[$21>>2]|0;
   $arglist_next = ((($21)) + 4|0);
   HEAP32[$15>>2] = $arglist_next;
   HEAP32[$pArgList>>2] = $22;
  }
  $23 = HEAP32[$0>>2]|0;
  $24 = ((($23)) + 25|0);
  $25 = HEAP8[$24>>0]|0;
  $26 = $25&255;
  $27 = $26 & 1;
  $28 = $27&255;
  HEAP8[$useIntern>>0] = $28;
 } else {
  HEAP8[$useIntern>>0] = 0;
  HEAP8[$bArgList>>0] = 0;
 }
 L7: while(1) {
  $29 = HEAP32[$1>>2]|0;
  $30 = HEAP8[$29>>0]|0;
  $31 = $30 << 24 >> 24;
  HEAP32[$c>>2] = $31;
  $32 = ($31|0)!=(0);
  if (!($32)) {
   label = 268;
   break;
  }
  $33 = HEAP32[$c>>2]|0;
  $34 = ($33|0)!=(37);
  if ($34) {
   $35 = HEAP32[$1>>2]|0;
   HEAP32[$bufpt>>2] = $35;
   while(1) {
    $36 = HEAP32[$1>>2]|0;
    $37 = ((($36)) + 1|0);
    HEAP32[$1>>2] = $37;
    $38 = HEAP32[$1>>2]|0;
    $39 = HEAP8[$38>>0]|0;
    $40 = $39 << 24 >> 24;
    $41 = ($40|0)!=(0);
    if (!($41)) {
     break;
    }
    $42 = HEAP32[$1>>2]|0;
    $43 = HEAP8[$42>>0]|0;
    $44 = $43 << 24 >> 24;
    $45 = ($44|0)!=(37);
    if (!($45)) {
     break;
    }
   }
   $46 = HEAP32[$0>>2]|0;
   $47 = HEAP32[$bufpt>>2]|0;
   $48 = HEAP32[$1>>2]|0;
   $49 = HEAP32[$bufpt>>2]|0;
   $50 = $48;
   $51 = $49;
   $52 = (($50) - ($51))|0;
   _sqlite3StrAccumAppend($46,$47,$52);
   $53 = HEAP32[$1>>2]|0;
   $54 = HEAP8[$53>>0]|0;
   $55 = $54 << 24 >> 24;
   $56 = ($55|0)==(0);
   if ($56) {
    label = 268;
    break;
   }
  }
  $57 = HEAP32[$1>>2]|0;
  $58 = ((($57)) + 1|0);
  HEAP32[$1>>2] = $58;
  $59 = HEAP8[$58>>0]|0;
  $60 = $59 << 24 >> 24;
  HEAP32[$c>>2] = $60;
  $61 = ($60|0)==(0);
  if ($61) {
   label = 13;
   break;
  }
  HEAP8[$flag_zeropad>>0] = 0;
  HEAP8[$flag_altform2>>0] = 0;
  HEAP8[$flag_alternateform>>0] = 0;
  HEAP8[$flag_blanksign>>0] = 0;
  HEAP8[$flag_plussign>>0] = 0;
  HEAP8[$flag_leftjustify>>0] = 0;
  HEAP8[$done>>0] = 0;
  while(1) {
   $63 = HEAP32[$c>>2]|0;
   switch ($63|0) {
   case 45:  {
    HEAP8[$flag_leftjustify>>0] = 1;
    break;
   }
   case 43:  {
    HEAP8[$flag_plussign>>0] = 1;
    break;
   }
   case 32:  {
    HEAP8[$flag_blanksign>>0] = 1;
    break;
   }
   case 35:  {
    HEAP8[$flag_alternateform>>0] = 1;
    break;
   }
   case 33:  {
    HEAP8[$flag_altform2>>0] = 1;
    break;
   }
   case 48:  {
    HEAP8[$flag_zeropad>>0] = 1;
    break;
   }
   default: {
    HEAP8[$done>>0] = 1;
   }
   }
   $64 = HEAP8[$done>>0]|0;
   $65 = ($64<<24>>24)!=(0);
   if ($65) {
    break;
   }
   $66 = HEAP32[$1>>2]|0;
   $67 = ((($66)) + 1|0);
   HEAP32[$1>>2] = $67;
   $68 = HEAP8[$67>>0]|0;
   $69 = $68 << 24 >> 24;
   HEAP32[$c>>2] = $69;
   $70 = ($69|0)!=(0);
   if (!($70)) {
    break;
   }
  }
  $71 = HEAP32[$c>>2]|0;
  $72 = ($71|0)==(42);
  if ($72) {
   $73 = HEAP8[$bArgList>>0]|0;
   $74 = ($73<<24>>24)!=(0);
   if ($74) {
    $75 = HEAP32[$pArgList>>2]|0;
    $76 = (_getIntArg($75)|0);
    $77 = tempRet0;
    HEAP32[$width>>2] = $76;
   } else {
    $78 = HEAP32[$2>>2]|0;
    $arglist_current12 = HEAP32[$78>>2]|0;
    $79 = $arglist_current12;
    $80 = ((0) + 4|0);
    $expanded60 = $80;
    $expanded59 = (($expanded60) - 1)|0;
    $81 = (($79) + ($expanded59))|0;
    $82 = ((0) + 4|0);
    $expanded64 = $82;
    $expanded63 = (($expanded64) - 1)|0;
    $expanded62 = $expanded63 ^ -1;
    $83 = $81 & $expanded62;
    $84 = $83;
    $85 = HEAP32[$84>>2]|0;
    $arglist_next13 = ((($84)) + 4|0);
    HEAP32[$78>>2] = $arglist_next13;
    HEAP32[$width>>2] = $85;
   }
   $86 = HEAP32[$width>>2]|0;
   $87 = ($86|0)<(0);
   if ($87) {
    HEAP8[$flag_leftjustify>>0] = 1;
    $88 = HEAP32[$width>>2]|0;
    $89 = ($88|0)>=(-2147483647);
    $90 = HEAP32[$width>>2]|0;
    $91 = (0 - ($90))|0;
    $92 = $89 ? $91 : 0;
    HEAP32[$width>>2] = $92;
   }
   $93 = HEAP32[$1>>2]|0;
   $94 = ((($93)) + 1|0);
   HEAP32[$1>>2] = $94;
   $95 = HEAP8[$94>>0]|0;
   $96 = $95 << 24 >> 24;
   HEAP32[$c>>2] = $96;
  } else {
   HEAP32[$wx>>2] = 0;
   while(1) {
    $97 = HEAP32[$c>>2]|0;
    $98 = ($97|0)>=(48);
    $99 = HEAP32[$c>>2]|0;
    $100 = ($99|0)<=(57);
    $101 = $98 ? $100 : 0;
    $102 = HEAP32[$wx>>2]|0;
    if (!($101)) {
     break;
    }
    $103 = ($102*10)|0;
    $104 = HEAP32[$c>>2]|0;
    $105 = (($103) + ($104))|0;
    $106 = (($105) - 48)|0;
    HEAP32[$wx>>2] = $106;
    $107 = HEAP32[$1>>2]|0;
    $108 = ((($107)) + 1|0);
    HEAP32[$1>>2] = $108;
    $109 = HEAP8[$108>>0]|0;
    $110 = $109 << 24 >> 24;
    HEAP32[$c>>2] = $110;
   }
   $111 = $102 & 2147483647;
   HEAP32[$width>>2] = $111;
  }
  $112 = HEAP32[$c>>2]|0;
  $113 = ($112|0)==(46);
  do {
   if ($113) {
    $114 = HEAP32[$1>>2]|0;
    $115 = ((($114)) + 1|0);
    HEAP32[$1>>2] = $115;
    $116 = HEAP8[$115>>0]|0;
    $117 = $116 << 24 >> 24;
    HEAP32[$c>>2] = $117;
    $118 = HEAP32[$c>>2]|0;
    $119 = ($118|0)==(42);
    if (!($119)) {
     HEAP32[$px>>2] = 0;
     while(1) {
      $144 = HEAP32[$c>>2]|0;
      $145 = ($144|0)>=(48);
      $146 = HEAP32[$c>>2]|0;
      $147 = ($146|0)<=(57);
      $148 = $145 ? $147 : 0;
      $149 = HEAP32[$px>>2]|0;
      if (!($148)) {
       break;
      }
      $150 = ($149*10)|0;
      $151 = HEAP32[$c>>2]|0;
      $152 = (($150) + ($151))|0;
      $153 = (($152) - 48)|0;
      HEAP32[$px>>2] = $153;
      $154 = HEAP32[$1>>2]|0;
      $155 = ((($154)) + 1|0);
      HEAP32[$1>>2] = $155;
      $156 = HEAP8[$155>>0]|0;
      $157 = $156 << 24 >> 24;
      HEAP32[$c>>2] = $157;
     }
     $158 = $149 & 2147483647;
     HEAP32[$precision>>2] = $158;
     break;
    }
    $120 = HEAP8[$bArgList>>0]|0;
    $121 = ($120<<24>>24)!=(0);
    if ($121) {
     $122 = HEAP32[$pArgList>>2]|0;
     $123 = (_getIntArg($122)|0);
     $124 = tempRet0;
     HEAP32[$precision>>2] = $123;
    } else {
     $125 = HEAP32[$2>>2]|0;
     $arglist_current15 = HEAP32[$125>>2]|0;
     $126 = $arglist_current15;
     $127 = ((0) + 4|0);
     $expanded67 = $127;
     $expanded66 = (($expanded67) - 1)|0;
     $128 = (($126) + ($expanded66))|0;
     $129 = ((0) + 4|0);
     $expanded71 = $129;
     $expanded70 = (($expanded71) - 1)|0;
     $expanded69 = $expanded70 ^ -1;
     $130 = $128 & $expanded69;
     $131 = $130;
     $132 = HEAP32[$131>>2]|0;
     $arglist_next16 = ((($131)) + 4|0);
     HEAP32[$125>>2] = $arglist_next16;
     HEAP32[$precision>>2] = $132;
    }
    $133 = HEAP32[$1>>2]|0;
    $134 = ((($133)) + 1|0);
    HEAP32[$1>>2] = $134;
    $135 = HEAP8[$134>>0]|0;
    $136 = $135 << 24 >> 24;
    HEAP32[$c>>2] = $136;
    $137 = HEAP32[$precision>>2]|0;
    $138 = ($137|0)<(0);
    if ($138) {
     $139 = HEAP32[$precision>>2]|0;
     $140 = ($139|0)>=(-2147483647);
     $141 = HEAP32[$precision>>2]|0;
     $142 = (0 - ($141))|0;
     $143 = $140 ? $142 : -1;
     HEAP32[$precision>>2] = $143;
    }
   } else {
    HEAP32[$precision>>2] = -1;
   }
  } while(0);
  $159 = HEAP32[$c>>2]|0;
  $160 = ($159|0)==(108);
  do {
   if ($160) {
    HEAP8[$flag_long>>0] = 1;
    $161 = HEAP32[$1>>2]|0;
    $162 = ((($161)) + 1|0);
    HEAP32[$1>>2] = $162;
    $163 = HEAP8[$162>>0]|0;
    $164 = $163 << 24 >> 24;
    HEAP32[$c>>2] = $164;
    $165 = HEAP32[$c>>2]|0;
    $166 = ($165|0)==(108);
    if ($166) {
     HEAP8[$flag_longlong>>0] = 1;
     $167 = HEAP32[$1>>2]|0;
     $168 = ((($167)) + 1|0);
     HEAP32[$1>>2] = $168;
     $169 = HEAP8[$168>>0]|0;
     $170 = $169 << 24 >> 24;
     HEAP32[$c>>2] = $170;
     break;
    } else {
     HEAP8[$flag_longlong>>0] = 0;
     break;
    }
   } else {
    HEAP8[$flag_longlong>>0] = 0;
    HEAP8[$flag_long>>0] = 0;
   }
  } while(0);
  HEAP32[$infop>>2] = 44615;
  HEAP8[$xtype>>0] = 16;
  HEAP32[$idx>>2] = 0;
  while(1) {
   $171 = HEAP32[$idx>>2]|0;
   $172 = ($171|0)<(23);
   if (!($172)) {
    break;
   }
   $173 = HEAP32[$c>>2]|0;
   $174 = HEAP32[$idx>>2]|0;
   $175 = (44615 + (($174*6)|0)|0);
   $176 = HEAP8[$175>>0]|0;
   $177 = $176 << 24 >> 24;
   $178 = ($173|0)==($177|0);
   $179 = HEAP32[$idx>>2]|0;
   if ($178) {
    label = 56;
    break;
   }
   $193 = (($179) + 1)|0;
   HEAP32[$idx>>2] = $193;
  }
  if ((label|0) == 56) {
   label = 0;
   $180 = (44615 + (($179*6)|0)|0);
   HEAP32[$infop>>2] = $180;
   $181 = HEAP8[$useIntern>>0]|0;
   $182 = $181&255;
   $183 = ($182|0)!=(0);
   if (!($183)) {
    $184 = HEAP32[$infop>>2]|0;
    $185 = ((($184)) + 2|0);
    $186 = HEAP8[$185>>0]|0;
    $187 = $186&255;
    $188 = $187 & 2;
    $189 = ($188|0)==(0);
    if (!($189)) {
     label = 268;
     break;
    }
   }
   $190 = HEAP32[$infop>>2]|0;
   $191 = ((($190)) + 3|0);
   $192 = HEAP8[$191>>0]|0;
   HEAP8[$xtype>>0] = $192;
  }
  $194 = HEAP8[$xtype>>0]|0;
  $195 = $194&255;
  L79: do {
   switch ($195|0) {
   case 13:  {
    HEAP8[$flag_longlong>>0] = 0;
    HEAP8[$flag_long>>0] = 1;
    label = 62;
    break;
   }
   case 0: case 15:  {
    label = 62;
    break;
   }
   case 3: case 2: case 1:  {
    $500 = HEAP8[$bArgList>>0]|0;
    $501 = ($500<<24>>24)!=(0);
    if ($501) {
     $502 = HEAP32[$pArgList>>2]|0;
     $503 = (+_getDoubleArg($502));
     HEAPF64[$realvalue>>3] = $503;
    } else {
     $504 = HEAP32[$2>>2]|0;
     $arglist_current30 = HEAP32[$504>>2]|0;
     $505 = $arglist_current30;
     $506 = ((0) + 8|0);
     $expanded102 = $506;
     $expanded101 = (($expanded102) - 1)|0;
     $507 = (($505) + ($expanded101))|0;
     $508 = ((0) + 8|0);
     $expanded106 = $508;
     $expanded105 = (($expanded106) - 1)|0;
     $expanded104 = $expanded105 ^ -1;
     $509 = $507 & $expanded104;
     $510 = $509;
     $511 = +HEAPF64[$510>>3];
     $arglist_next31 = ((($510)) + 8|0);
     HEAP32[$504>>2] = $arglist_next31;
     HEAPF64[$realvalue>>3] = $511;
    }
    $512 = HEAP32[$precision>>2]|0;
    $513 = ($512|0)<(0);
    if ($513) {
     HEAP32[$precision>>2] = 6;
    }
    $514 = +HEAPF64[$realvalue>>3];
    $515 = $514 < 0.0;
    do {
     if ($515) {
      $516 = +HEAPF64[$realvalue>>3];
      $517 = -$516;
      HEAPF64[$realvalue>>3] = $517;
      HEAP8[$prefix>>0] = 45;
     } else {
      $518 = HEAP8[$flag_plussign>>0]|0;
      $519 = ($518<<24>>24)!=(0);
      if ($519) {
       HEAP8[$prefix>>0] = 43;
       break;
      }
      $520 = HEAP8[$flag_blanksign>>0]|0;
      $521 = ($520<<24>>24)!=(0);
      if ($521) {
       HEAP8[$prefix>>0] = 32;
       break;
      } else {
       HEAP8[$prefix>>0] = 0;
       break;
      }
     }
    } while(0);
    $522 = HEAP8[$xtype>>0]|0;
    $523 = $522&255;
    $524 = ($523|0)==(3);
    $525 = HEAP32[$precision>>2]|0;
    $526 = ($525|0)>(0);
    $or$cond = $524 & $526;
    if ($or$cond) {
     $527 = HEAP32[$precision>>2]|0;
     $528 = (($527) + -1)|0;
     HEAP32[$precision>>2] = $528;
    }
    $529 = HEAP32[$precision>>2]|0;
    $530 = $529 & 4095;
    HEAP32[$idx>>2] = $530;
    HEAPF64[$rounder>>3] = 0.5;
    while(1) {
     $531 = HEAP32[$idx>>2]|0;
     $532 = ($531|0)>(0);
     if (!($532)) {
      break;
     }
     $533 = HEAP32[$idx>>2]|0;
     $534 = (($533) + -1)|0;
     HEAP32[$idx>>2] = $534;
     $535 = +HEAPF64[$rounder>>3];
     $536 = $535 * 0.10000000000000001;
     HEAPF64[$rounder>>3] = $536;
    }
    $537 = HEAP8[$xtype>>0]|0;
    $538 = $537&255;
    $539 = ($538|0)==(1);
    if ($539) {
     $540 = +HEAPF64[$rounder>>3];
     $541 = +HEAPF64[$realvalue>>3];
     $542 = $541 + $540;
     HEAPF64[$realvalue>>3] = $542;
    }
    HEAP32[$exp>>2] = 0;
    $543 = +HEAPF64[$realvalue>>3];
    $544 = (_sqlite3IsNaN($543)|0);
    $545 = ($544|0)!=(0);
    if ($545) {
     HEAP32[$bufpt>>2] = 44802;
     HEAP32[$length>>2] = 3;
     break L79;
    }
    $546 = +HEAPF64[$realvalue>>3];
    $547 = $546 > 0.0;
    if ($547) {
     HEAPF64[$scale>>3] = 1.0;
     while(1) {
      $548 = +HEAPF64[$realvalue>>3];
      $549 = +HEAPF64[$scale>>3];
      $550 = 1.0E+100 * $549;
      $551 = $548 >= $550;
      $552 = HEAP32[$exp>>2]|0;
      $553 = ($552|0)<=(350);
      $554 = $551 ? $553 : 0;
      if (!($554)) {
       break;
      }
      $555 = +HEAPF64[$scale>>3];
      $556 = $555 * 1.0E+100;
      HEAPF64[$scale>>3] = $556;
      $557 = HEAP32[$exp>>2]|0;
      $558 = (($557) + 100)|0;
      HEAP32[$exp>>2] = $558;
     }
     while(1) {
      $559 = +HEAPF64[$realvalue>>3];
      $560 = +HEAPF64[$scale>>3];
      $561 = 1.0E+10 * $560;
      $562 = $559 >= $561;
      $563 = HEAP32[$exp>>2]|0;
      $564 = ($563|0)<=(350);
      $565 = $562 ? $564 : 0;
      if (!($565)) {
       break;
      }
      $566 = +HEAPF64[$scale>>3];
      $567 = $566 * 1.0E+10;
      HEAPF64[$scale>>3] = $567;
      $568 = HEAP32[$exp>>2]|0;
      $569 = (($568) + 10)|0;
      HEAP32[$exp>>2] = $569;
     }
     while(1) {
      $570 = +HEAPF64[$realvalue>>3];
      $571 = +HEAPF64[$scale>>3];
      $572 = 10.0 * $571;
      $573 = $570 >= $572;
      $574 = HEAP32[$exp>>2]|0;
      $575 = ($574|0)<=(350);
      $576 = $573 ? $575 : 0;
      $577 = +HEAPF64[$scale>>3];
      if (!($576)) {
       break;
      }
      $578 = $577 * 10.0;
      HEAPF64[$scale>>3] = $578;
      $579 = HEAP32[$exp>>2]|0;
      $580 = (($579) + 1)|0;
      HEAP32[$exp>>2] = $580;
     }
     $581 = +HEAPF64[$realvalue>>3];
     $582 = $581 / $577;
     HEAPF64[$realvalue>>3] = $582;
     while(1) {
      $583 = +HEAPF64[$realvalue>>3];
      $584 = $583 < 1.0E-8;
      if (!($584)) {
       break;
      }
      $585 = +HEAPF64[$realvalue>>3];
      $586 = $585 * 1.0E+8;
      HEAPF64[$realvalue>>3] = $586;
      $587 = HEAP32[$exp>>2]|0;
      $588 = (($587) - 8)|0;
      HEAP32[$exp>>2] = $588;
     }
     while(1) {
      $589 = +HEAPF64[$realvalue>>3];
      $590 = $589 < 1.0;
      if (!($590)) {
       break;
      }
      $591 = +HEAPF64[$realvalue>>3];
      $592 = $591 * 10.0;
      HEAPF64[$realvalue>>3] = $592;
      $593 = HEAP32[$exp>>2]|0;
      $594 = (($593) + -1)|0;
      HEAP32[$exp>>2] = $594;
     }
     $595 = HEAP32[$exp>>2]|0;
     $596 = ($595|0)>(350);
     if ($596) {
      HEAP32[$bufpt>>2] = $buf;
      $597 = HEAP8[$prefix>>0]|0;
      HEAP8[$buf>>0] = $597;
      $598 = HEAP8[$prefix>>0]|0;
      $599 = $598 << 24 >> 24;
      $600 = ($599|0)!=(0);
      $601 = $600&1;
      $602 = (($buf) + ($601)|0);
      ;HEAP8[$602>>0]=HEAP8[44806>>0]|0;HEAP8[$602+1>>0]=HEAP8[44806+1>>0]|0;HEAP8[$602+2>>0]=HEAP8[44806+2>>0]|0;HEAP8[$602+3>>0]=HEAP8[44806+3>>0]|0;
      $603 = HEAP8[$prefix>>0]|0;
      $604 = $603 << 24 >> 24;
      $605 = ($604|0)!=(0);
      $606 = $605&1;
      $607 = (3 + ($606))|0;
      HEAP32[$length>>2] = $607;
      break L79;
     }
    }
    HEAP32[$bufpt>>2] = $buf;
    $608 = HEAP8[$xtype>>0]|0;
    $609 = $608&255;
    $610 = ($609|0)!=(1);
    if ($610) {
     $611 = +HEAPF64[$rounder>>3];
     $612 = +HEAPF64[$realvalue>>3];
     $613 = $612 + $611;
     HEAPF64[$realvalue>>3] = $613;
     $614 = +HEAPF64[$realvalue>>3];
     $615 = $614 >= 10.0;
     if ($615) {
      $616 = +HEAPF64[$realvalue>>3];
      $617 = $616 * 0.10000000000000001;
      HEAPF64[$realvalue>>3] = $617;
      $618 = HEAP32[$exp>>2]|0;
      $619 = (($618) + 1)|0;
      HEAP32[$exp>>2] = $619;
     }
    }
    $620 = HEAP8[$xtype>>0]|0;
    $621 = $620&255;
    $622 = ($621|0)==(3);
    L137: do {
     if ($622) {
      $623 = HEAP8[$flag_alternateform>>0]|0;
      $624 = ($623<<24>>24)!=(0);
      $625 = $624 ^ 1;
      $626 = $625&1;
      $627 = $626&255;
      HEAP8[$flag_rtz>>0] = $627;
      $628 = HEAP32[$exp>>2]|0;
      $629 = ($628|0)<(-4);
      do {
       if (!($629)) {
        $630 = HEAP32[$exp>>2]|0;
        $631 = HEAP32[$precision>>2]|0;
        $632 = ($630|0)>($631|0);
        if ($632) {
         break;
        }
        $633 = HEAP32[$precision>>2]|0;
        $634 = HEAP32[$exp>>2]|0;
        $635 = (($633) - ($634))|0;
        HEAP32[$precision>>2] = $635;
        HEAP8[$xtype>>0] = 1;
        break L137;
       }
      } while(0);
      HEAP8[$xtype>>0] = 2;
     } else {
      $636 = HEAP8[$flag_altform2>>0]|0;
      HEAP8[$flag_rtz>>0] = $636;
     }
    } while(0);
    $637 = HEAP8[$xtype>>0]|0;
    $638 = $637&255;
    $639 = ($638|0)==(2);
    if ($639) {
     HEAP32[$e2>>2] = 0;
    } else {
     $640 = HEAP32[$exp>>2]|0;
     HEAP32[$e2>>2] = $640;
    }
    $641 = HEAP32[$e2>>2]|0;
    $642 = ($641|0)>(0);
    $643 = HEAP32[$e2>>2]|0;
    $644 = $642 ? $643 : 0;
    $645 = ($644|0)<(0);
    $646 = $645 << 31 >> 31;
    $647 = HEAP32[$precision>>2]|0;
    $648 = ($647|0)<(0);
    $649 = $648 << 31 >> 31;
    $650 = (_i64Add(($644|0),($646|0),($647|0),($649|0))|0);
    $651 = tempRet0;
    $652 = HEAP32[$width>>2]|0;
    $653 = ($652|0)<(0);
    $654 = $653 << 31 >> 31;
    $655 = (_i64Add(($650|0),($651|0),($652|0),($654|0))|0);
    $656 = tempRet0;
    $657 = ($656|0)>(0);
    $658 = ($655>>>0)>(55);
    $659 = ($656|0)==(0);
    $660 = $659 & $658;
    $661 = $657 | $660;
    if ($661) {
     $662 = HEAP32[$e2>>2]|0;
     $663 = ($662|0)>(0);
     $664 = HEAP32[$e2>>2]|0;
     $665 = $663 ? $664 : 0;
     $666 = ($665|0)<(0);
     $667 = $666 << 31 >> 31;
     $668 = HEAP32[$precision>>2]|0;
     $669 = ($668|0)<(0);
     $670 = $669 << 31 >> 31;
     $671 = (_i64Add(($665|0),($667|0),($668|0),($670|0))|0);
     $672 = tempRet0;
     $673 = HEAP32[$width>>2]|0;
     $674 = ($673|0)<(0);
     $675 = $674 << 31 >> 31;
     $676 = (_i64Add(($671|0),($672|0),($673|0),($675|0))|0);
     $677 = tempRet0;
     $678 = (_i64Add(($676|0),($677|0),15,0)|0);
     $679 = tempRet0;
     $680 = (_sqlite3Malloc($678,$679)|0);
     HEAP32[$zExtra>>2] = $680;
     HEAP32[$bufpt>>2] = $680;
     $681 = HEAP32[$bufpt>>2]|0;
     $682 = ($681|0)==(0|0);
     if ($682) {
      label = 161;
      break L7;
     }
    }
    $684 = HEAP32[$bufpt>>2]|0;
    HEAP32[$zOut>>2] = $684;
    $685 = HEAP8[$flag_altform2>>0]|0;
    $686 = $685&255;
    $687 = ($686*10)|0;
    $688 = (16 + ($687))|0;
    HEAP32[$nsd>>2] = $688;
    $689 = HEAP32[$precision>>2]|0;
    $690 = ($689|0)>(0);
    $691 = $690 ? 1 : 0;
    $692 = HEAP8[$flag_alternateform>>0]|0;
    $693 = $692&255;
    $694 = $691 | $693;
    $695 = HEAP8[$flag_altform2>>0]|0;
    $696 = $695&255;
    $697 = $694 | $696;
    $698 = $697&255;
    HEAP8[$flag_dp>>0] = $698;
    $699 = HEAP8[$prefix>>0]|0;
    $700 = ($699<<24>>24)!=(0);
    if ($700) {
     $701 = HEAP8[$prefix>>0]|0;
     $702 = HEAP32[$bufpt>>2]|0;
     $703 = ((($702)) + 1|0);
     HEAP32[$bufpt>>2] = $703;
     HEAP8[$702>>0] = $701;
    }
    $704 = HEAP32[$e2>>2]|0;
    $705 = ($704|0)<(0);
    L155: do {
     if ($705) {
      $706 = HEAP32[$bufpt>>2]|0;
      $707 = ((($706)) + 1|0);
      HEAP32[$bufpt>>2] = $707;
      HEAP8[$706>>0] = 48;
     } else {
      while(1) {
       $708 = HEAP32[$e2>>2]|0;
       $709 = ($708|0)>=(0);
       if (!($709)) {
        break L155;
       }
       $710 = (_et_getdigit($realvalue,$nsd)|0);
       $711 = HEAP32[$bufpt>>2]|0;
       $712 = ((($711)) + 1|0);
       HEAP32[$bufpt>>2] = $712;
       HEAP8[$711>>0] = $710;
       $713 = HEAP32[$e2>>2]|0;
       $714 = (($713) + -1)|0;
       HEAP32[$e2>>2] = $714;
      }
     }
    } while(0);
    $715 = HEAP8[$flag_dp>>0]|0;
    $716 = ($715<<24>>24)!=(0);
    if ($716) {
     $717 = HEAP32[$bufpt>>2]|0;
     $718 = ((($717)) + 1|0);
     HEAP32[$bufpt>>2] = $718;
     HEAP8[$717>>0] = 46;
    }
    $719 = HEAP32[$e2>>2]|0;
    $720 = (($719) + 1)|0;
    HEAP32[$e2>>2] = $720;
    while(1) {
     $721 = HEAP32[$e2>>2]|0;
     $722 = ($721|0)<(0);
     if (!($722)) {
      break;
     }
     $723 = HEAP32[$bufpt>>2]|0;
     $724 = ((($723)) + 1|0);
     HEAP32[$bufpt>>2] = $724;
     HEAP8[$723>>0] = 48;
     $725 = HEAP32[$precision>>2]|0;
     $726 = (($725) + -1)|0;
     HEAP32[$precision>>2] = $726;
     $727 = HEAP32[$e2>>2]|0;
     $728 = (($727) + 1)|0;
     HEAP32[$e2>>2] = $728;
    }
    while(1) {
     $729 = HEAP32[$precision>>2]|0;
     $730 = (($729) + -1)|0;
     HEAP32[$precision>>2] = $730;
     $731 = ($729|0)>(0);
     if (!($731)) {
      break;
     }
     $732 = (_et_getdigit($realvalue,$nsd)|0);
     $733 = HEAP32[$bufpt>>2]|0;
     $734 = ((($733)) + 1|0);
     HEAP32[$bufpt>>2] = $734;
     HEAP8[$733>>0] = $732;
    }
    $735 = HEAP8[$flag_rtz>>0]|0;
    $736 = $735&255;
    $737 = ($736|0)!=(0);
    do {
     if ($737) {
      $738 = HEAP8[$flag_dp>>0]|0;
      $739 = $738&255;
      $740 = ($739|0)!=(0);
      if (!($740)) {
       break;
      }
      while(1) {
       $741 = HEAP32[$bufpt>>2]|0;
       $742 = ((($741)) + -1|0);
       $743 = HEAP8[$742>>0]|0;
       $744 = $743 << 24 >> 24;
       $745 = ($744|0)==(48);
       $746 = HEAP32[$bufpt>>2]|0;
       $747 = ((($746)) + -1|0);
       if (!($745)) {
        break;
       }
       HEAP32[$bufpt>>2] = $747;
       HEAP8[$747>>0] = 0;
      }
      $748 = HEAP8[$747>>0]|0;
      $749 = $748 << 24 >> 24;
      $750 = ($749|0)==(46);
      if (!($750)) {
       break;
      }
      $751 = HEAP8[$flag_altform2>>0]|0;
      $752 = ($751<<24>>24)!=(0);
      $753 = HEAP32[$bufpt>>2]|0;
      if ($752) {
       $754 = ((($753)) + 1|0);
       HEAP32[$bufpt>>2] = $754;
       HEAP8[$753>>0] = 48;
       break;
      } else {
       $755 = ((($753)) + -1|0);
       HEAP32[$bufpt>>2] = $755;
       HEAP8[$755>>0] = 0;
       break;
      }
     }
    } while(0);
    $756 = HEAP8[$xtype>>0]|0;
    $757 = $756&255;
    $758 = ($757|0)==(2);
    if ($758) {
     $759 = HEAP32[$infop>>2]|0;
     $760 = ((($759)) + 4|0);
     $761 = HEAP8[$760>>0]|0;
     $762 = $761&255;
     $763 = (44762 + ($762)|0);
     $764 = HEAP8[$763>>0]|0;
     $765 = HEAP32[$bufpt>>2]|0;
     $766 = ((($765)) + 1|0);
     HEAP32[$bufpt>>2] = $766;
     HEAP8[$765>>0] = $764;
     $767 = HEAP32[$exp>>2]|0;
     $768 = ($767|0)<(0);
     $769 = HEAP32[$bufpt>>2]|0;
     $770 = ((($769)) + 1|0);
     HEAP32[$bufpt>>2] = $770;
     if ($768) {
      HEAP8[$769>>0] = 45;
      $771 = HEAP32[$exp>>2]|0;
      $772 = (0 - ($771))|0;
      HEAP32[$exp>>2] = $772;
     } else {
      HEAP8[$769>>0] = 43;
     }
     $773 = HEAP32[$exp>>2]|0;
     $774 = ($773|0)>=(100);
     if ($774) {
      $775 = HEAP32[$exp>>2]|0;
      $776 = (($775|0) / 100)&-1;
      $777 = (($776) + 48)|0;
      $778 = $777&255;
      $779 = HEAP32[$bufpt>>2]|0;
      $780 = ((($779)) + 1|0);
      HEAP32[$bufpt>>2] = $780;
      HEAP8[$779>>0] = $778;
      $781 = HEAP32[$exp>>2]|0;
      $782 = (($781|0) % 100)&-1;
      HEAP32[$exp>>2] = $782;
     }
     $783 = HEAP32[$exp>>2]|0;
     $784 = (($783|0) / 10)&-1;
     $785 = (($784) + 48)|0;
     $786 = $785&255;
     $787 = HEAP32[$bufpt>>2]|0;
     $788 = ((($787)) + 1|0);
     HEAP32[$bufpt>>2] = $788;
     HEAP8[$787>>0] = $786;
     $789 = HEAP32[$exp>>2]|0;
     $790 = (($789|0) % 10)&-1;
     $791 = (($790) + 48)|0;
     $792 = $791&255;
     $793 = HEAP32[$bufpt>>2]|0;
     $794 = ((($793)) + 1|0);
     HEAP32[$bufpt>>2] = $794;
     HEAP8[$793>>0] = $792;
    }
    $795 = HEAP32[$bufpt>>2]|0;
    HEAP8[$795>>0] = 0;
    $796 = HEAP32[$bufpt>>2]|0;
    $797 = HEAP32[$zOut>>2]|0;
    $798 = $796;
    $799 = $797;
    $800 = (($798) - ($799))|0;
    HEAP32[$length>>2] = $800;
    $801 = HEAP32[$zOut>>2]|0;
    HEAP32[$bufpt>>2] = $801;
    $802 = HEAP8[$flag_zeropad>>0]|0;
    $803 = $802&255;
    $804 = ($803|0)==(0);
    $805 = HEAP8[$flag_leftjustify>>0]|0;
    $806 = ($805<<24>>24)!=(0);
    $or$cond4 = $804 | $806;
    if ($or$cond4) {
     break L79;
    }
    $807 = HEAP32[$length>>2]|0;
    $808 = HEAP32[$width>>2]|0;
    $809 = ($807|0)<($808|0);
    if (!($809)) {
     break L79;
    }
    $810 = HEAP32[$width>>2]|0;
    $811 = HEAP32[$length>>2]|0;
    $812 = (($810) - ($811))|0;
    HEAP32[$nPad>>2] = $812;
    $813 = HEAP32[$width>>2]|0;
    HEAP32[$i>>2] = $813;
    while(1) {
     $814 = HEAP32[$i>>2]|0;
     $815 = HEAP32[$nPad>>2]|0;
     $816 = ($814|0)>=($815|0);
     if (!($816)) {
      break;
     }
     $817 = HEAP32[$i>>2]|0;
     $818 = HEAP32[$nPad>>2]|0;
     $819 = (($817) - ($818))|0;
     $820 = HEAP32[$bufpt>>2]|0;
     $821 = (($820) + ($819)|0);
     $822 = HEAP8[$821>>0]|0;
     $823 = HEAP32[$i>>2]|0;
     $824 = HEAP32[$bufpt>>2]|0;
     $825 = (($824) + ($823)|0);
     HEAP8[$825>>0] = $822;
     $826 = HEAP32[$i>>2]|0;
     $827 = (($826) + -1)|0;
     HEAP32[$i>>2] = $827;
    }
    $828 = HEAP8[$prefix>>0]|0;
    $829 = $828 << 24 >> 24;
    $830 = ($829|0)!=(0);
    $831 = $830&1;
    HEAP32[$i>>2] = $831;
    while(1) {
     $832 = HEAP32[$nPad>>2]|0;
     $833 = (($832) + -1)|0;
     HEAP32[$nPad>>2] = $833;
     $834 = ($832|0)!=(0);
     if (!($834)) {
      break;
     }
     $835 = HEAP32[$i>>2]|0;
     $836 = (($835) + 1)|0;
     HEAP32[$i>>2] = $836;
     $837 = HEAP32[$bufpt>>2]|0;
     $838 = (($837) + ($835)|0);
     HEAP8[$838>>0] = 48;
    }
    $839 = HEAP32[$width>>2]|0;
    HEAP32[$length>>2] = $839;
    break;
   }
   case 4:  {
    $840 = HEAP8[$bArgList>>0]|0;
    $841 = ($840<<24>>24)!=(0);
    if (!($841)) {
     $842 = HEAP32[$0>>2]|0;
     $843 = ((($842)) + 12|0);
     $844 = HEAP32[$843>>2]|0;
     $845 = HEAP32[$2>>2]|0;
     $arglist_current33 = HEAP32[$845>>2]|0;
     $846 = $arglist_current33;
     $847 = ((0) + 4|0);
     $expanded109 = $847;
     $expanded108 = (($expanded109) - 1)|0;
     $848 = (($846) + ($expanded108))|0;
     $849 = ((0) + 4|0);
     $expanded113 = $849;
     $expanded112 = (($expanded113) - 1)|0;
     $expanded111 = $expanded112 ^ -1;
     $850 = $848 & $expanded111;
     $851 = $850;
     $852 = HEAP32[$851>>2]|0;
     $arglist_next34 = ((($851)) + 4|0);
     HEAP32[$845>>2] = $arglist_next34;
     HEAP32[$852>>2] = $844;
    }
    HEAP32[$width>>2] = 0;
    HEAP32[$length>>2] = 0;
    break;
   }
   case 7:  {
    HEAP8[$buf>>0] = 37;
    HEAP32[$bufpt>>2] = $buf;
    HEAP32[$length>>2] = 1;
    break;
   }
   case 8:  {
    $853 = HEAP8[$bArgList>>0]|0;
    $854 = ($853<<24>>24)!=(0);
    if ($854) {
     $855 = HEAP32[$pArgList>>2]|0;
     $856 = (_getTextArg($855)|0);
     HEAP32[$bufpt>>2] = $856;
     $857 = HEAP32[$bufpt>>2]|0;
     $858 = ($857|0)!=(0|0);
     if ($858) {
      $859 = HEAP32[$bufpt>>2]|0;
      $860 = HEAP8[$859>>0]|0;
      $861 = $860 << 24 >> 24;
      $862 = $861;
     } else {
      $862 = 0;
     }
     HEAP32[$c>>2] = $862;
    } else {
     $863 = HEAP32[$2>>2]|0;
     $arglist_current36 = HEAP32[$863>>2]|0;
     $864 = $arglist_current36;
     $865 = ((0) + 4|0);
     $expanded116 = $865;
     $expanded115 = (($expanded116) - 1)|0;
     $866 = (($864) + ($expanded115))|0;
     $867 = ((0) + 4|0);
     $expanded120 = $867;
     $expanded119 = (($expanded120) - 1)|0;
     $expanded118 = $expanded119 ^ -1;
     $868 = $866 & $expanded118;
     $869 = $868;
     $870 = HEAP32[$869>>2]|0;
     $arglist_next37 = ((($869)) + 4|0);
     HEAP32[$863>>2] = $arglist_next37;
     HEAP32[$c>>2] = $870;
    }
    $871 = HEAP32[$precision>>2]|0;
    $872 = ($871|0)>(1);
    if ($872) {
     $873 = HEAP32[$precision>>2]|0;
     $874 = (($873) - 1)|0;
     $875 = HEAP32[$width>>2]|0;
     $876 = (($875) - ($874))|0;
     HEAP32[$width>>2] = $876;
     $877 = HEAP32[$width>>2]|0;
     $878 = ($877|0)<=(1);
     $879 = HEAP8[$flag_leftjustify>>0]|0;
     $880 = ($879<<24>>24)!=(0);
     $or$cond6 = $878 | $880;
     if (!($or$cond6)) {
      $881 = HEAP32[$0>>2]|0;
      $882 = HEAP32[$width>>2]|0;
      $883 = (($882) - 1)|0;
      _sqlite3AppendChar($881,$883,32);
      HEAP32[$width>>2] = 0;
     }
     $884 = HEAP32[$0>>2]|0;
     $885 = HEAP32[$precision>>2]|0;
     $886 = (($885) - 1)|0;
     $887 = HEAP32[$c>>2]|0;
     $888 = $887&255;
     _sqlite3AppendChar($884,$886,$888);
    }
    HEAP32[$length>>2] = 1;
    $889 = HEAP32[$c>>2]|0;
    $890 = $889&255;
    HEAP8[$buf>>0] = $890;
    HEAP32[$bufpt>>2] = $buf;
    break;
   }
   case 6: case 5:  {
    $891 = HEAP8[$bArgList>>0]|0;
    $892 = ($891<<24>>24)!=(0);
    if ($892) {
     $893 = HEAP32[$pArgList>>2]|0;
     $894 = (_getTextArg($893)|0);
     HEAP32[$bufpt>>2] = $894;
     HEAP8[$xtype>>0] = 5;
    } else {
     $895 = HEAP32[$2>>2]|0;
     $arglist_current39 = HEAP32[$895>>2]|0;
     $896 = $arglist_current39;
     $897 = ((0) + 4|0);
     $expanded123 = $897;
     $expanded122 = (($expanded123) - 1)|0;
     $898 = (($896) + ($expanded122))|0;
     $899 = ((0) + 4|0);
     $expanded127 = $899;
     $expanded126 = (($expanded127) - 1)|0;
     $expanded125 = $expanded126 ^ -1;
     $900 = $898 & $expanded125;
     $901 = $900;
     $902 = HEAP32[$901>>2]|0;
     $arglist_next40 = ((($901)) + 4|0);
     HEAP32[$895>>2] = $arglist_next40;
     HEAP32[$bufpt>>2] = $902;
    }
    $903 = HEAP32[$bufpt>>2]|0;
    $904 = ($903|0)==(0|0);
    if ($904) {
     HEAP32[$bufpt>>2] = 18402;
    } else {
     $905 = HEAP8[$xtype>>0]|0;
     $906 = $905&255;
     $907 = ($906|0)==(6);
     if ($907) {
      $908 = HEAP32[$bufpt>>2]|0;
      HEAP32[$zExtra>>2] = $908;
     }
    }
    $909 = HEAP32[$precision>>2]|0;
    $910 = ($909|0)>=(0);
    if (!($910)) {
     $922 = HEAP32[$bufpt>>2]|0;
     $923 = (_sqlite3Strlen30($922)|0);
     HEAP32[$length>>2] = $923;
     break L79;
    }
    HEAP32[$length>>2] = 0;
    while(1) {
     $911 = HEAP32[$length>>2]|0;
     $912 = HEAP32[$precision>>2]|0;
     $913 = ($911|0)<($912|0);
     if (!($913)) {
      break L79;
     }
     $914 = HEAP32[$length>>2]|0;
     $915 = HEAP32[$bufpt>>2]|0;
     $916 = (($915) + ($914)|0);
     $917 = HEAP8[$916>>0]|0;
     $918 = $917 << 24 >> 24;
     $919 = ($918|0)!=(0);
     if (!($919)) {
      break L79;
     }
     $920 = HEAP32[$length>>2]|0;
     $921 = (($920) + 1)|0;
     HEAP32[$length>>2] = $921;
    }
    break;
   }
   case 14: case 10: case 9:  {
    $924 = HEAP8[$xtype>>0]|0;
    $925 = $924&255;
    $926 = ($925|0)==(14);
    $927 = $926 ? 34 : 39;
    $928 = $927&255;
    HEAP8[$q>>0] = $928;
    $929 = HEAP8[$bArgList>>0]|0;
    $930 = ($929<<24>>24)!=(0);
    if ($930) {
     $931 = HEAP32[$pArgList>>2]|0;
     $932 = (_getTextArg($931)|0);
     HEAP32[$escarg>>2] = $932;
    } else {
     $933 = HEAP32[$2>>2]|0;
     $arglist_current42 = HEAP32[$933>>2]|0;
     $934 = $arglist_current42;
     $935 = ((0) + 4|0);
     $expanded130 = $935;
     $expanded129 = (($expanded130) - 1)|0;
     $936 = (($934) + ($expanded129))|0;
     $937 = ((0) + 4|0);
     $expanded134 = $937;
     $expanded133 = (($expanded134) - 1)|0;
     $expanded132 = $expanded133 ^ -1;
     $938 = $936 & $expanded132;
     $939 = $938;
     $940 = HEAP32[$939>>2]|0;
     $arglist_next43 = ((($939)) + 4|0);
     HEAP32[$933>>2] = $arglist_next43;
     HEAP32[$escarg>>2] = $940;
    }
    $941 = HEAP32[$escarg>>2]|0;
    $942 = ($941|0)==(0|0);
    $943 = $942&1;
    HEAP32[$isnull>>2] = $943;
    $944 = HEAP32[$isnull>>2]|0;
    $945 = ($944|0)!=(0);
    if ($945) {
     $946 = HEAP8[$xtype>>0]|0;
     $947 = $946&255;
     $948 = ($947|0)==(10);
     $949 = $948 ? 39691 : 44810;
     HEAP32[$escarg>>2] = $949;
    }
    $950 = HEAP32[$precision>>2]|0;
    HEAP32[$k>>2] = $950;
    HEAP32[$n>>2] = 0;
    HEAP32[$i2>>2] = 0;
    while(1) {
     $951 = HEAP32[$k>>2]|0;
     $952 = ($951|0)!=(0);
     if (!($952)) {
      break;
     }
     $953 = HEAP32[$i2>>2]|0;
     $954 = HEAP32[$escarg>>2]|0;
     $955 = (($954) + ($953)|0);
     $956 = HEAP8[$955>>0]|0;
     HEAP8[$ch>>0] = $956;
     $957 = $956 << 24 >> 24;
     $958 = ($957|0)!=(0);
     if (!($958)) {
      break;
     }
     $959 = HEAP8[$ch>>0]|0;
     $960 = $959 << 24 >> 24;
     $961 = HEAP8[$q>>0]|0;
     $962 = $961 << 24 >> 24;
     $963 = ($960|0)==($962|0);
     if ($963) {
      $964 = HEAP32[$n>>2]|0;
      $965 = (($964) + 1)|0;
      HEAP32[$n>>2] = $965;
     }
     $966 = HEAP32[$i2>>2]|0;
     $967 = (($966) + 1)|0;
     HEAP32[$i2>>2] = $967;
     $968 = HEAP32[$k>>2]|0;
     $969 = (($968) + -1)|0;
     HEAP32[$k>>2] = $969;
    }
    $970 = HEAP32[$isnull>>2]|0;
    $971 = ($970|0)!=(0);
    if ($971) {
     $976 = 0;
    } else {
     $972 = HEAP8[$xtype>>0]|0;
     $973 = $972&255;
     $974 = ($973|0)==(10);
     $976 = $974;
    }
    $975 = $976&1;
    HEAP32[$needQuote>>2] = $975;
    $977 = HEAP32[$i2>>2]|0;
    $978 = (($977) + 3)|0;
    $979 = HEAP32[$n>>2]|0;
    $980 = (($979) + ($978))|0;
    HEAP32[$n>>2] = $980;
    $981 = HEAP32[$n>>2]|0;
    $982 = ($981|0)>(70);
    if ($982) {
     $983 = HEAP32[$n>>2]|0;
     $984 = ($983|0)<(0);
     $985 = $984 << 31 >> 31;
     $986 = (_sqlite3Malloc($983,$985)|0);
     HEAP32[$zExtra>>2] = $986;
     HEAP32[$bufpt>>2] = $986;
     $987 = HEAP32[$bufpt>>2]|0;
     $988 = ($987|0)==(0|0);
     if ($988) {
      label = 241;
      break L7;
     }
    } else {
     HEAP32[$bufpt>>2] = $buf;
    }
    HEAP32[$j>>2] = 0;
    $990 = HEAP32[$needQuote>>2]|0;
    $991 = ($990|0)!=(0);
    if ($991) {
     $992 = HEAP8[$q>>0]|0;
     $993 = HEAP32[$j>>2]|0;
     $994 = (($993) + 1)|0;
     HEAP32[$j>>2] = $994;
     $995 = HEAP32[$bufpt>>2]|0;
     $996 = (($995) + ($993)|0);
     HEAP8[$996>>0] = $992;
    }
    $997 = HEAP32[$i2>>2]|0;
    HEAP32[$k>>2] = $997;
    HEAP32[$i2>>2] = 0;
    while(1) {
     $998 = HEAP32[$i2>>2]|0;
     $999 = HEAP32[$k>>2]|0;
     $1000 = ($998|0)<($999|0);
     if (!($1000)) {
      break;
     }
     $1001 = HEAP32[$i2>>2]|0;
     $1002 = HEAP32[$escarg>>2]|0;
     $1003 = (($1002) + ($1001)|0);
     $1004 = HEAP8[$1003>>0]|0;
     HEAP8[$ch>>0] = $1004;
     $1005 = HEAP32[$j>>2]|0;
     $1006 = (($1005) + 1)|0;
     HEAP32[$j>>2] = $1006;
     $1007 = HEAP32[$bufpt>>2]|0;
     $1008 = (($1007) + ($1005)|0);
     HEAP8[$1008>>0] = $1004;
     $1009 = HEAP8[$ch>>0]|0;
     $1010 = $1009 << 24 >> 24;
     $1011 = HEAP8[$q>>0]|0;
     $1012 = $1011 << 24 >> 24;
     $1013 = ($1010|0)==($1012|0);
     if ($1013) {
      $1014 = HEAP8[$ch>>0]|0;
      $1015 = HEAP32[$j>>2]|0;
      $1016 = (($1015) + 1)|0;
      HEAP32[$j>>2] = $1016;
      $1017 = HEAP32[$bufpt>>2]|0;
      $1018 = (($1017) + ($1015)|0);
      HEAP8[$1018>>0] = $1014;
     }
     $1019 = HEAP32[$i2>>2]|0;
     $1020 = (($1019) + 1)|0;
     HEAP32[$i2>>2] = $1020;
    }
    $1021 = HEAP32[$needQuote>>2]|0;
    $1022 = ($1021|0)!=(0);
    if ($1022) {
     $1023 = HEAP8[$q>>0]|0;
     $1024 = HEAP32[$j>>2]|0;
     $1025 = (($1024) + 1)|0;
     HEAP32[$j>>2] = $1025;
     $1026 = HEAP32[$bufpt>>2]|0;
     $1027 = (($1026) + ($1024)|0);
     HEAP8[$1027>>0] = $1023;
    }
    $1028 = HEAP32[$j>>2]|0;
    $1029 = HEAP32[$bufpt>>2]|0;
    $1030 = (($1029) + ($1028)|0);
    HEAP8[$1030>>0] = 0;
    $1031 = HEAP32[$j>>2]|0;
    HEAP32[$length>>2] = $1031;
    break;
   }
   case 11:  {
    $1032 = HEAP32[$2>>2]|0;
    $arglist_current45 = HEAP32[$1032>>2]|0;
    $1033 = $arglist_current45;
    $1034 = ((0) + 4|0);
    $expanded137 = $1034;
    $expanded136 = (($expanded137) - 1)|0;
    $1035 = (($1033) + ($expanded136))|0;
    $1036 = ((0) + 4|0);
    $expanded141 = $1036;
    $expanded140 = (($expanded141) - 1)|0;
    $expanded139 = $expanded140 ^ -1;
    $1037 = $1035 & $expanded139;
    $1038 = $1037;
    $1039 = HEAP32[$1038>>2]|0;
    $arglist_next46 = ((($1038)) + 4|0);
    HEAP32[$1032>>2] = $arglist_next46;
    HEAP32[$pToken>>2] = $1039;
    $1040 = HEAP32[$pToken>>2]|0;
    $1041 = ($1040|0)!=(0|0);
    if ($1041) {
     $1042 = HEAP32[$pToken>>2]|0;
     $1043 = ((($1042)) + 4|0);
     $1044 = HEAP32[$1043>>2]|0;
     $1045 = ($1044|0)!=(0);
     if ($1045) {
      $1046 = HEAP32[$0>>2]|0;
      $1047 = HEAP32[$pToken>>2]|0;
      $1048 = HEAP32[$1047>>2]|0;
      $1049 = HEAP32[$pToken>>2]|0;
      $1050 = ((($1049)) + 4|0);
      $1051 = HEAP32[$1050>>2]|0;
      _sqlite3StrAccumAppend($1046,$1048,$1051);
     }
    }
    HEAP32[$width>>2] = 0;
    HEAP32[$length>>2] = 0;
    break;
   }
   case 12:  {
    $1052 = HEAP32[$2>>2]|0;
    $arglist_current48 = HEAP32[$1052>>2]|0;
    $1053 = $arglist_current48;
    $1054 = ((0) + 4|0);
    $expanded144 = $1054;
    $expanded143 = (($expanded144) - 1)|0;
    $1055 = (($1053) + ($expanded143))|0;
    $1056 = ((0) + 4|0);
    $expanded148 = $1056;
    $expanded147 = (($expanded148) - 1)|0;
    $expanded146 = $expanded147 ^ -1;
    $1057 = $1055 & $expanded146;
    $1058 = $1057;
    $1059 = HEAP32[$1058>>2]|0;
    $arglist_next49 = ((($1058)) + 4|0);
    HEAP32[$1052>>2] = $arglist_next49;
    HEAP32[$pSrc>>2] = $1059;
    $1060 = HEAP32[$2>>2]|0;
    $arglist_current51 = HEAP32[$1060>>2]|0;
    $1061 = $arglist_current51;
    $1062 = ((0) + 4|0);
    $expanded151 = $1062;
    $expanded150 = (($expanded151) - 1)|0;
    $1063 = (($1061) + ($expanded150))|0;
    $1064 = ((0) + 4|0);
    $expanded155 = $1064;
    $expanded154 = (($expanded155) - 1)|0;
    $expanded153 = $expanded154 ^ -1;
    $1065 = $1063 & $expanded153;
    $1066 = $1065;
    $1067 = HEAP32[$1066>>2]|0;
    $arglist_next52 = ((($1066)) + 4|0);
    HEAP32[$1060>>2] = $arglist_next52;
    HEAP32[$k3>>2] = $1067;
    $1068 = HEAP32[$k3>>2]|0;
    $1069 = HEAP32[$pSrc>>2]|0;
    $1070 = ((($1069)) + 8|0);
    $1071 = (($1070) + (($1068*72)|0)|0);
    HEAP32[$pItem>>2] = $1071;
    $1072 = HEAP32[$pItem>>2]|0;
    $1073 = ((($1072)) + 4|0);
    $1074 = HEAP32[$1073>>2]|0;
    $1075 = ($1074|0)!=(0|0);
    if ($1075) {
     $1076 = HEAP32[$0>>2]|0;
     $1077 = HEAP32[$pItem>>2]|0;
     $1078 = ((($1077)) + 4|0);
     $1079 = HEAP32[$1078>>2]|0;
     _sqlite3StrAccumAppendAll($1076,$1079);
     $1080 = HEAP32[$0>>2]|0;
     _sqlite3StrAccumAppend($1080,44433,1);
    }
    $1081 = HEAP32[$0>>2]|0;
    $1082 = HEAP32[$pItem>>2]|0;
    $1083 = ((($1082)) + 8|0);
    $1084 = HEAP32[$1083>>2]|0;
    _sqlite3StrAccumAppendAll($1081,$1084);
    HEAP32[$width>>2] = 0;
    HEAP32[$length>>2] = 0;
    break;
   }
   default: {
    label = 268;
    break L7;
   }
   }
  } while(0);
  if ((label|0) == 62) {
   label = 0;
   $196 = HEAP32[$infop>>2]|0;
   $197 = ((($196)) + 2|0);
   $198 = HEAP8[$197>>0]|0;
   $199 = $198&255;
   $200 = $199 & 1;
   $201 = ($200|0)!=(0);
   $202 = HEAP8[$bArgList>>0]|0;
   $203 = ($202<<24>>24)!=(0);
   do {
    if ($201) {
     do {
      if ($203) {
       $204 = HEAP32[$pArgList>>2]|0;
       $205 = (_getIntArg($204)|0);
       $206 = tempRet0;
       $207 = $v;
       $208 = $207;
       HEAP32[$208>>2] = $205;
       $209 = (($207) + 4)|0;
       $210 = $209;
       HEAP32[$210>>2] = $206;
      } else {
       $211 = HEAP8[$flag_longlong>>0]|0;
       $212 = ($211<<24>>24)!=(0);
       $213 = HEAP32[$2>>2]|0;
       if ($212) {
        $arglist_current18 = HEAP32[$213>>2]|0;
        $214 = $arglist_current18;
        $215 = ((0) + 8|0);
        $expanded74 = $215;
        $expanded73 = (($expanded74) - 1)|0;
        $216 = (($214) + ($expanded73))|0;
        $217 = ((0) + 8|0);
        $expanded78 = $217;
        $expanded77 = (($expanded78) - 1)|0;
        $expanded76 = $expanded77 ^ -1;
        $218 = $216 & $expanded76;
        $219 = $218;
        $220 = $219;
        $221 = $220;
        $222 = HEAP32[$221>>2]|0;
        $223 = (($220) + 4)|0;
        $224 = $223;
        $225 = HEAP32[$224>>2]|0;
        $arglist_next19 = ((($219)) + 8|0);
        HEAP32[$213>>2] = $arglist_next19;
        $226 = $v;
        $227 = $226;
        HEAP32[$227>>2] = $222;
        $228 = (($226) + 4)|0;
        $229 = $228;
        HEAP32[$229>>2] = $225;
        break;
       } else {
        $arglist_current21 = HEAP32[$213>>2]|0;
        $230 = $arglist_current21;
        $231 = ((0) + 4|0);
        $expanded81 = $231;
        $expanded80 = (($expanded81) - 1)|0;
        $232 = (($230) + ($expanded80))|0;
        $233 = ((0) + 4|0);
        $expanded85 = $233;
        $expanded84 = (($expanded85) - 1)|0;
        $expanded83 = $expanded84 ^ -1;
        $234 = $232 & $expanded83;
        $235 = $234;
        $236 = HEAP32[$235>>2]|0;
        $arglist_next22 = ((($235)) + 4|0);
        HEAP32[$213>>2] = $arglist_next22;
        $237 = ($236|0)<(0);
        $238 = $237 << 31 >> 31;
        $239 = $v;
        $240 = $239;
        HEAP32[$240>>2] = $236;
        $241 = (($239) + 4)|0;
        $242 = $241;
        HEAP32[$242>>2] = $238;
        break;
       }
      }
     } while(0);
     $243 = $v;
     $244 = $243;
     $245 = HEAP32[$244>>2]|0;
     $246 = (($243) + 4)|0;
     $247 = $246;
     $248 = HEAP32[$247>>2]|0;
     $249 = ($248|0)<(0);
     $250 = $v;
     $251 = $250;
     $252 = HEAP32[$251>>2]|0;
     $253 = (($250) + 4)|0;
     $254 = $253;
     $255 = HEAP32[$254>>2]|0;
     if ($249) {
      $256 = ($252|0)==(0);
      $257 = ($255|0)==(-2147483648);
      $258 = $256 & $257;
      if ($258) {
       $259 = $longvalue;
       $260 = $259;
       HEAP32[$260>>2] = 0;
       $261 = (($259) + 4)|0;
       $262 = $261;
       HEAP32[$262>>2] = -2147483648;
      } else {
       $263 = $v;
       $264 = $263;
       $265 = HEAP32[$264>>2]|0;
       $266 = (($263) + 4)|0;
       $267 = $266;
       $268 = HEAP32[$267>>2]|0;
       $269 = (_i64Subtract(0,0,($265|0),($268|0))|0);
       $270 = tempRet0;
       $271 = $longvalue;
       $272 = $271;
       HEAP32[$272>>2] = $269;
       $273 = (($271) + 4)|0;
       $274 = $273;
       HEAP32[$274>>2] = $270;
      }
      HEAP8[$prefix>>0] = 45;
      break;
     }
     $275 = $longvalue;
     $276 = $275;
     HEAP32[$276>>2] = $252;
     $277 = (($275) + 4)|0;
     $278 = $277;
     HEAP32[$278>>2] = $255;
     $279 = HEAP8[$flag_plussign>>0]|0;
     $280 = ($279<<24>>24)!=(0);
     if ($280) {
      HEAP8[$prefix>>0] = 43;
      break;
     }
     $281 = HEAP8[$flag_blanksign>>0]|0;
     $282 = ($281<<24>>24)!=(0);
     if ($282) {
      HEAP8[$prefix>>0] = 32;
      break;
     } else {
      HEAP8[$prefix>>0] = 0;
      break;
     }
    } else {
     do {
      if ($203) {
       $283 = HEAP32[$pArgList>>2]|0;
       $284 = (_getIntArg($283)|0);
       $285 = tempRet0;
       $286 = $longvalue;
       $287 = $286;
       HEAP32[$287>>2] = $284;
       $288 = (($286) + 4)|0;
       $289 = $288;
       HEAP32[$289>>2] = $285;
      } else {
       $290 = HEAP8[$flag_longlong>>0]|0;
       $291 = ($290<<24>>24)!=(0);
       $292 = HEAP32[$2>>2]|0;
       if ($291) {
        $arglist_current24 = HEAP32[$292>>2]|0;
        $293 = $arglist_current24;
        $294 = ((0) + 8|0);
        $expanded88 = $294;
        $expanded87 = (($expanded88) - 1)|0;
        $295 = (($293) + ($expanded87))|0;
        $296 = ((0) + 8|0);
        $expanded92 = $296;
        $expanded91 = (($expanded92) - 1)|0;
        $expanded90 = $expanded91 ^ -1;
        $297 = $295 & $expanded90;
        $298 = $297;
        $299 = $298;
        $300 = $299;
        $301 = HEAP32[$300>>2]|0;
        $302 = (($299) + 4)|0;
        $303 = $302;
        $304 = HEAP32[$303>>2]|0;
        $arglist_next25 = ((($298)) + 8|0);
        HEAP32[$292>>2] = $arglist_next25;
        $305 = $longvalue;
        $306 = $305;
        HEAP32[$306>>2] = $301;
        $307 = (($305) + 4)|0;
        $308 = $307;
        HEAP32[$308>>2] = $304;
        break;
       } else {
        $arglist_current27 = HEAP32[$292>>2]|0;
        $309 = $arglist_current27;
        $310 = ((0) + 4|0);
        $expanded95 = $310;
        $expanded94 = (($expanded95) - 1)|0;
        $311 = (($309) + ($expanded94))|0;
        $312 = ((0) + 4|0);
        $expanded99 = $312;
        $expanded98 = (($expanded99) - 1)|0;
        $expanded97 = $expanded98 ^ -1;
        $313 = $311 & $expanded97;
        $314 = $313;
        $315 = HEAP32[$314>>2]|0;
        $arglist_next28 = ((($314)) + 4|0);
        HEAP32[$292>>2] = $arglist_next28;
        $316 = $longvalue;
        $317 = $316;
        HEAP32[$317>>2] = $315;
        $318 = (($316) + 4)|0;
        $319 = $318;
        HEAP32[$319>>2] = 0;
        break;
       }
      }
     } while(0);
     HEAP8[$prefix>>0] = 0;
    }
   } while(0);
   $320 = $longvalue;
   $321 = $320;
   $322 = HEAP32[$321>>2]|0;
   $323 = (($320) + 4)|0;
   $324 = $323;
   $325 = HEAP32[$324>>2]|0;
   $326 = ($322|0)==(0);
   $327 = ($325|0)==(0);
   $328 = $326 & $327;
   if ($328) {
    HEAP8[$flag_alternateform>>0] = 0;
   }
   $329 = HEAP8[$flag_zeropad>>0]|0;
   $330 = $329&255;
   $331 = ($330|0)!=(0);
   if ($331) {
    $332 = HEAP32[$precision>>2]|0;
    $333 = HEAP32[$width>>2]|0;
    $334 = HEAP8[$prefix>>0]|0;
    $335 = $334 << 24 >> 24;
    $336 = ($335|0)!=(0);
    $337 = $336&1;
    $338 = (($333) - ($337))|0;
    $339 = ($332|0)<($338|0);
    if ($339) {
     $340 = HEAP32[$width>>2]|0;
     $341 = HEAP8[$prefix>>0]|0;
     $342 = $341 << 24 >> 24;
     $343 = ($342|0)!=(0);
     $344 = $343&1;
     $345 = (($340) - ($344))|0;
     HEAP32[$precision>>2] = $345;
    }
   }
   $346 = HEAP32[$precision>>2]|0;
   $347 = ($346|0)<(60);
   if ($347) {
    HEAP32[$nOut>>2] = 70;
    HEAP32[$zOut>>2] = $buf;
   } else {
    $348 = HEAP32[$precision>>2]|0;
    $349 = (($348) + 10)|0;
    HEAP32[$nOut>>2] = $349;
    $350 = HEAP32[$nOut>>2]|0;
    $351 = ($350|0)<(0);
    $352 = $351 << 31 >> 31;
    $353 = (_sqlite3Malloc($350,$352)|0);
    HEAP32[$zExtra>>2] = $353;
    HEAP32[$zOut>>2] = $353;
    $354 = HEAP32[$zOut>>2]|0;
    $355 = ($354|0)==(0|0);
    if ($355) {
     label = 92;
     break;
    }
   }
   $357 = HEAP32[$nOut>>2]|0;
   $358 = (($357) - 1)|0;
   $359 = HEAP32[$zOut>>2]|0;
   $360 = (($359) + ($358)|0);
   HEAP32[$bufpt>>2] = $360;
   $361 = HEAP8[$xtype>>0]|0;
   $362 = $361&255;
   $363 = ($362|0)==(15);
   if ($363) {
    $364 = $longvalue;
    $365 = $364;
    $366 = HEAP32[$365>>2]|0;
    $367 = (($364) + 4)|0;
    $368 = $367;
    $369 = HEAP32[$368>>2]|0;
    $370 = (___uremdi3(($366|0),($369|0),10,0)|0);
    $371 = tempRet0;
    HEAP32[$x>>2] = $370;
    $372 = HEAP32[$x>>2]|0;
    $373 = ($372|0)>=(4);
    if ($373) {
     label = 96;
    } else {
     $374 = $longvalue;
     $375 = $374;
     $376 = HEAP32[$375>>2]|0;
     $377 = (($374) + 4)|0;
     $378 = $377;
     $379 = HEAP32[$378>>2]|0;
     $380 = (___udivdi3(($376|0),($379|0),10,0)|0);
     $381 = tempRet0;
     $382 = (___uremdi3(($380|0),($381|0),10,0)|0);
     $383 = tempRet0;
     $384 = ($382|0)==(1);
     $385 = ($383|0)==(0);
     $386 = $384 & $385;
     if ($386) {
      label = 96;
     }
    }
    if ((label|0) == 96) {
     label = 0;
     HEAP32[$x>>2] = 0;
    }
    $387 = HEAP32[$x>>2]|0;
    $388 = $387<<1;
    $389 = (($388) + 1)|0;
    $390 = (44753 + ($389)|0);
    $391 = HEAP8[$390>>0]|0;
    $392 = HEAP32[$bufpt>>2]|0;
    $393 = ((($392)) + -1|0);
    HEAP32[$bufpt>>2] = $393;
    HEAP8[$393>>0] = $391;
    $394 = HEAP32[$x>>2]|0;
    $395 = $394<<1;
    $396 = (44753 + ($395)|0);
    $397 = HEAP8[$396>>0]|0;
    $398 = HEAP32[$bufpt>>2]|0;
    $399 = ((($398)) + -1|0);
    HEAP32[$bufpt>>2] = $399;
    HEAP8[$399>>0] = $397;
   }
   $400 = HEAP32[$infop>>2]|0;
   $401 = ((($400)) + 4|0);
   $402 = HEAP8[$401>>0]|0;
   $403 = $402&255;
   $404 = (44762 + ($403)|0);
   HEAP32[$cset>>2] = $404;
   $405 = HEAP32[$infop>>2]|0;
   $406 = ((($405)) + 1|0);
   $407 = HEAP8[$406>>0]|0;
   HEAP8[$base>>0] = $407;
   while(1) {
    $408 = $longvalue;
    $409 = $408;
    $410 = HEAP32[$409>>2]|0;
    $411 = (($408) + 4)|0;
    $412 = $411;
    $413 = HEAP32[$412>>2]|0;
    $414 = HEAP8[$base>>0]|0;
    $415 = $414&255;
    $416 = (___uremdi3(($410|0),($413|0),($415|0),0)|0);
    $417 = tempRet0;
    $418 = HEAP32[$cset>>2]|0;
    $419 = (($418) + ($416)|0);
    $420 = HEAP8[$419>>0]|0;
    $421 = HEAP32[$bufpt>>2]|0;
    $422 = ((($421)) + -1|0);
    HEAP32[$bufpt>>2] = $422;
    HEAP8[$422>>0] = $420;
    $423 = $longvalue;
    $424 = $423;
    $425 = HEAP32[$424>>2]|0;
    $426 = (($423) + 4)|0;
    $427 = $426;
    $428 = HEAP32[$427>>2]|0;
    $429 = HEAP8[$base>>0]|0;
    $430 = $429&255;
    $431 = (___udivdi3(($425|0),($428|0),($430|0),0)|0);
    $432 = tempRet0;
    $433 = $longvalue;
    $434 = $433;
    HEAP32[$434>>2] = $431;
    $435 = (($433) + 4)|0;
    $436 = $435;
    HEAP32[$436>>2] = $432;
    $437 = $longvalue;
    $438 = $437;
    $439 = HEAP32[$438>>2]|0;
    $440 = (($437) + 4)|0;
    $441 = $440;
    $442 = HEAP32[$441>>2]|0;
    $443 = ($442>>>0)>(0);
    $444 = ($439>>>0)>(0);
    $445 = ($442|0)==(0);
    $446 = $445 & $444;
    $447 = $443 | $446;
    if (!($447)) {
     break;
    }
   }
   $448 = HEAP32[$nOut>>2]|0;
   $449 = (($448) - 1)|0;
   $450 = HEAP32[$zOut>>2]|0;
   $451 = (($450) + ($449)|0);
   $452 = HEAP32[$bufpt>>2]|0;
   $453 = $451;
   $454 = $452;
   $455 = (($453) - ($454))|0;
   HEAP32[$length>>2] = $455;
   $456 = HEAP32[$precision>>2]|0;
   $457 = HEAP32[$length>>2]|0;
   $458 = (($456) - ($457))|0;
   HEAP32[$idx>>2] = $458;
   while(1) {
    $459 = HEAP32[$idx>>2]|0;
    $460 = ($459|0)>(0);
    if (!($460)) {
     break;
    }
    $461 = HEAP32[$bufpt>>2]|0;
    $462 = ((($461)) + -1|0);
    HEAP32[$bufpt>>2] = $462;
    HEAP8[$462>>0] = 48;
    $463 = HEAP32[$idx>>2]|0;
    $464 = (($463) + -1)|0;
    HEAP32[$idx>>2] = $464;
   }
   $465 = HEAP8[$prefix>>0]|0;
   $466 = ($465<<24>>24)!=(0);
   if ($466) {
    $467 = HEAP8[$prefix>>0]|0;
    $468 = HEAP32[$bufpt>>2]|0;
    $469 = ((($468)) + -1|0);
    HEAP32[$bufpt>>2] = $469;
    HEAP8[$469>>0] = $467;
   }
   $470 = HEAP8[$flag_alternateform>>0]|0;
   $471 = $470&255;
   $472 = ($471|0)!=(0);
   L345: do {
    if ($472) {
     $473 = HEAP32[$infop>>2]|0;
     $474 = ((($473)) + 5|0);
     $475 = HEAP8[$474>>0]|0;
     $476 = $475&255;
     $477 = ($476|0)!=(0);
     if ($477) {
      $478 = HEAP32[$infop>>2]|0;
      $479 = ((($478)) + 5|0);
      $480 = HEAP8[$479>>0]|0;
      $481 = $480&255;
      $482 = (44795 + ($481)|0);
      HEAP32[$pre>>2] = $482;
      while(1) {
       $483 = HEAP32[$pre>>2]|0;
       $484 = HEAP8[$483>>0]|0;
       HEAP8[$x1>>0] = $484;
       $485 = $484 << 24 >> 24;
       $486 = ($485|0)!=(0);
       if (!($486)) {
        break L345;
       }
       $487 = HEAP8[$x1>>0]|0;
       $488 = HEAP32[$bufpt>>2]|0;
       $489 = ((($488)) + -1|0);
       HEAP32[$bufpt>>2] = $489;
       HEAP8[$489>>0] = $487;
       $490 = HEAP32[$pre>>2]|0;
       $491 = ((($490)) + 1|0);
       HEAP32[$pre>>2] = $491;
      }
     }
    }
   } while(0);
   $492 = HEAP32[$nOut>>2]|0;
   $493 = (($492) - 1)|0;
   $494 = HEAP32[$zOut>>2]|0;
   $495 = (($494) + ($493)|0);
   $496 = HEAP32[$bufpt>>2]|0;
   $497 = $495;
   $498 = $496;
   $499 = (($497) - ($498))|0;
   HEAP32[$length>>2] = $499;
  }
  $1085 = HEAP32[$length>>2]|0;
  $1086 = HEAP32[$width>>2]|0;
  $1087 = (($1086) - ($1085))|0;
  HEAP32[$width>>2] = $1087;
  $1088 = HEAP32[$width>>2]|0;
  $1089 = ($1088|0)<=(0);
  $1090 = HEAP8[$flag_leftjustify>>0]|0;
  $1091 = ($1090<<24>>24)!=(0);
  $or$cond10 = $1089 | $1091;
  if (!($or$cond10)) {
   $1092 = HEAP32[$0>>2]|0;
   $1093 = HEAP32[$width>>2]|0;
   _sqlite3AppendChar($1092,$1093,32);
  }
  $1094 = HEAP32[$0>>2]|0;
  $1095 = HEAP32[$bufpt>>2]|0;
  $1096 = HEAP32[$length>>2]|0;
  _sqlite3StrAccumAppend($1094,$1095,$1096);
  $1097 = HEAP32[$width>>2]|0;
  $1098 = ($1097|0)>(0);
  if ($1098) {
   $1099 = HEAP8[$flag_leftjustify>>0]|0;
   $1100 = $1099&255;
   $1101 = ($1100|0)!=(0);
   if ($1101) {
    $1102 = HEAP32[$0>>2]|0;
    $1103 = HEAP32[$width>>2]|0;
    _sqlite3AppendChar($1102,$1103,32);
   }
  }
  $1104 = HEAP32[$zExtra>>2]|0;
  $1105 = ($1104|0)!=(0|0);
  if ($1105) {
   $1106 = HEAP32[$0>>2]|0;
   $1107 = HEAP32[$1106>>2]|0;
   $1108 = HEAP32[$zExtra>>2]|0;
   _sqlite3DbFree($1107,$1108);
   HEAP32[$zExtra>>2] = 0;
  }
  $1109 = HEAP32[$1>>2]|0;
  $1110 = ((($1109)) + 1|0);
  HEAP32[$1>>2] = $1110;
 }
 if ((label|0) == 13) {
  $62 = HEAP32[$0>>2]|0;
  _sqlite3StrAccumAppend($62,44613,1);
  STACKTOP = sp;return;
 }
 else if ((label|0) == 92) {
  $356 = HEAP32[$0>>2]|0;
  _setStrAccumError($356,1);
  STACKTOP = sp;return;
 }
 else if ((label|0) == 161) {
  $683 = HEAP32[$0>>2]|0;
  _setStrAccumError($683,1);
  STACKTOP = sp;return;
 }
 else if ((label|0) == 241) {
  $989 = HEAP32[$0>>2]|0;
  _setStrAccumError($989,1);
  STACKTOP = sp;return;
 }
 else if ((label|0) == 268) {
  STACKTOP = sp;return;
 }
}
function _sqlite3StrAccumFinish($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 8|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)!=(0|0);
 do {
  if ($4) {
   $5 = HEAP32[$0>>2]|0;
   $6 = ((($5)) + 12|0);
   $7 = HEAP32[$6>>2]|0;
   $8 = HEAP32[$0>>2]|0;
   $9 = ((($8)) + 8|0);
   $10 = HEAP32[$9>>2]|0;
   $11 = (($10) + ($7)|0);
   HEAP8[$11>>0] = 0;
   $12 = HEAP32[$0>>2]|0;
   $13 = ((($12)) + 20|0);
   $14 = HEAP32[$13>>2]|0;
   $15 = ($14>>>0)>(0);
   if ($15) {
    $16 = HEAP32[$0>>2]|0;
    $17 = ((($16)) + 25|0);
    $18 = HEAP8[$17>>0]|0;
    $19 = $18&255;
    $20 = $19 & 4;
    $21 = ($20|0)!=(0);
    if (!($21)) {
     $22 = HEAP32[$0>>2]|0;
     $23 = HEAP32[$22>>2]|0;
     $24 = HEAP32[$0>>2]|0;
     $25 = ((($24)) + 12|0);
     $26 = HEAP32[$25>>2]|0;
     $27 = (($26) + 1)|0;
     $28 = (_sqlite3DbMallocRaw($23,$27,0)|0);
     $29 = HEAP32[$0>>2]|0;
     $30 = ((($29)) + 8|0);
     HEAP32[$30>>2] = $28;
     $31 = HEAP32[$0>>2]|0;
     $32 = ((($31)) + 8|0);
     $33 = HEAP32[$32>>2]|0;
     $34 = ($33|0)!=(0|0);
     $35 = HEAP32[$0>>2]|0;
     if ($34) {
      $36 = ((($35)) + 8|0);
      $37 = HEAP32[$36>>2]|0;
      $38 = HEAP32[$0>>2]|0;
      $39 = ((($38)) + 4|0);
      $40 = HEAP32[$39>>2]|0;
      $41 = HEAP32[$0>>2]|0;
      $42 = ((($41)) + 12|0);
      $43 = HEAP32[$42>>2]|0;
      $44 = (($43) + 1)|0;
      _memcpy(($37|0),($40|0),($44|0))|0;
      $45 = HEAP32[$0>>2]|0;
      $46 = ((($45)) + 25|0);
      $47 = HEAP8[$46>>0]|0;
      $48 = $47&255;
      $49 = $48 | 4;
      $50 = $49&255;
      HEAP8[$46>>0] = $50;
      break;
     } else {
      _setStrAccumError($35,1);
      break;
     }
    }
   }
  }
 } while(0);
 $51 = HEAP32[$0>>2]|0;
 $52 = ((($51)) + 8|0);
 $53 = HEAP32[$52>>2]|0;
 STACKTOP = sp;return ($53|0);
}
function _renderLogMsg($iErrCode,$zFormat,$ap) {
 $iErrCode = $iErrCode|0;
 $zFormat = $zFormat|0;
 $ap = $ap|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $acc = 0, $zMsg = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 256|0;
 $0 = sp + 36|0;
 $1 = sp + 32|0;
 $2 = sp + 28|0;
 $acc = sp;
 $zMsg = sp + 40|0;
 HEAP32[$0>>2] = $iErrCode;
 HEAP32[$1>>2] = $zFormat;
 HEAP32[$2>>2] = $ap;
 _sqlite3StrAccumInit($acc,0,$zMsg,210,0);
 $3 = HEAP32[$1>>2]|0;
 $4 = HEAP32[$2>>2]|0;
 _sqlite3VXPrintf($acc,$3,$4);
 $5 = HEAP32[(264)>>2]|0;
 $6 = HEAP32[(268)>>2]|0;
 $7 = HEAP32[$0>>2]|0;
 $8 = (_sqlite3StrAccumFinish($acc)|0);
 FUNCTION_TABLE_viii[$5 & 255]($6,$7,$8);
 STACKTOP = sp;return;
}
function _sqlite3OsRandomness($pVfs,$nByte,$zBufOut) {
 $pVfs = $pVfs|0;
 $nByte = $nByte|0;
 $zBufOut = $zBufOut|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $pVfs;
 HEAP32[$1>>2] = $nByte;
 HEAP32[$2>>2] = $zBufOut;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 56|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = HEAP32[$0>>2]|0;
 $7 = HEAP32[$1>>2]|0;
 $8 = HEAP32[$2>>2]|0;
 $9 = (FUNCTION_TABLE_iiii[$5 & 255]($6,$7,$8)|0);
 STACKTOP = sp;return ($9|0);
}
function _sqlite3StrICmp($zLeft,$zRight) {
 $zLeft = $zLeft|0;
 $zRight = $zRight|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $a = 0, $b = 0, $c = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $a = sp + 8|0;
 $b = sp + 4|0;
 $c = sp;
 HEAP32[$0>>2] = $zLeft;
 HEAP32[$1>>2] = $zRight;
 $2 = HEAP32[$0>>2]|0;
 HEAP32[$a>>2] = $2;
 $3 = HEAP32[$1>>2]|0;
 HEAP32[$b>>2] = $3;
 while(1) {
  $4 = HEAP32[$a>>2]|0;
  $5 = HEAP8[$4>>0]|0;
  $6 = $5&255;
  $7 = (17613 + ($6)|0);
  $8 = HEAP8[$7>>0]|0;
  $9 = $8&255;
  $10 = HEAP32[$b>>2]|0;
  $11 = HEAP8[$10>>0]|0;
  $12 = $11&255;
  $13 = (17613 + ($12)|0);
  $14 = HEAP8[$13>>0]|0;
  $15 = $14&255;
  $16 = (($9) - ($15))|0;
  HEAP32[$c>>2] = $16;
  $17 = HEAP32[$c>>2]|0;
  $18 = ($17|0)!=(0);
  if ($18) {
   label = 5;
   break;
  }
  $19 = HEAP32[$a>>2]|0;
  $20 = HEAP8[$19>>0]|0;
  $21 = $20&255;
  $22 = ($21|0)==(0);
  if ($22) {
   label = 5;
   break;
  }
  $23 = HEAP32[$a>>2]|0;
  $24 = ((($23)) + 1|0);
  HEAP32[$a>>2] = $24;
  $25 = HEAP32[$b>>2]|0;
  $26 = ((($25)) + 1|0);
  HEAP32[$b>>2] = $26;
 }
 if ((label|0) == 5) {
  $27 = HEAP32[$c>>2]|0;
  STACKTOP = sp;return ($27|0);
 }
 return (0)|0;
}
function _sqlite3ErrorWithMsg($db,$err_code,$zFormat,$varargs) {
 $db = $db|0;
 $err_code = $err_code|0;
 $zFormat = $zFormat|0;
 $varargs = $varargs|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $ap = 0, $z = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $z = sp + 16|0;
 $ap = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $err_code;
 HEAP32[$2>>2] = $zFormat;
 $3 = HEAP32[$1>>2]|0;
 $4 = HEAP32[$0>>2]|0;
 $5 = ((($4)) + 52|0);
 HEAP32[$5>>2] = $3;
 $6 = HEAP32[$0>>2]|0;
 $7 = HEAP32[$1>>2]|0;
 _sqlite3SystemError($6,$7);
 $8 = HEAP32[$2>>2]|0;
 $9 = ($8|0)==(0|0);
 $10 = HEAP32[$0>>2]|0;
 if ($9) {
  $11 = HEAP32[$1>>2]|0;
  _sqlite3Error($10,$11);
  STACKTOP = sp;return;
 }
 $12 = ((($10)) + 244|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13|0)!=(0|0);
 if (!($14)) {
  $15 = HEAP32[$0>>2]|0;
  $16 = (_sqlite3ValueNew($15)|0);
  $17 = HEAP32[$0>>2]|0;
  $18 = ((($17)) + 244|0);
  HEAP32[$18>>2] = $16;
  $19 = ($16|0)!=(0|0);
  if (!($19)) {
   STACKTOP = sp;return;
  }
 }
 HEAP32[$ap>>2] = $varargs;
 $20 = HEAP32[$0>>2]|0;
 $21 = HEAP32[$2>>2]|0;
 $22 = (_sqlite3VMPrintf($20,$21,$ap)|0);
 HEAP32[$z>>2] = $22;
 $23 = HEAP32[$0>>2]|0;
 $24 = ((($23)) + 244|0);
 $25 = HEAP32[$24>>2]|0;
 $26 = HEAP32[$z>>2]|0;
 _sqlite3ValueSetStr($25,-1,$26,1,170);
 STACKTOP = sp;return;
}
function _sqlite3MallocZero($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $2 = sp;
 $p = sp + 8|0;
 $3 = $2;
 $4 = $3;
 HEAP32[$4>>2] = $0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = $1;
 $7 = $2;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) + 4)|0;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (_sqlite3Malloc($9,$12)|0);
 HEAP32[$p>>2] = $13;
 $14 = HEAP32[$p>>2]|0;
 $15 = ($14|0)!=(0|0);
 if (!($15)) {
  $23 = HEAP32[$p>>2]|0;
  STACKTOP = sp;return ($23|0);
 }
 $16 = HEAP32[$p>>2]|0;
 $17 = $2;
 $18 = $17;
 $19 = HEAP32[$18>>2]|0;
 $20 = (($17) + 4)|0;
 $21 = $20;
 $22 = HEAP32[$21>>2]|0;
 _memset(($16|0),0,($19|0))|0;
 $23 = HEAP32[$p>>2]|0;
 STACKTOP = sp;return ($23|0);
}
function _sqlite3Error($db,$err_code) {
 $db = $db|0;
 $err_code = $err_code|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $err_code;
 $2 = HEAP32[$1>>2]|0;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 52|0);
 HEAP32[$4>>2] = $2;
 $5 = HEAP32[$1>>2]|0;
 $6 = ($5|0)!=(0);
 if (!($6)) {
  $7 = HEAP32[$0>>2]|0;
  $8 = ((($7)) + 244|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = ($9|0)!=(0|0);
  if (!($10)) {
   STACKTOP = sp;return;
  }
 }
 $11 = HEAP32[$0>>2]|0;
 $12 = HEAP32[$1>>2]|0;
 _sqlite3ErrorFinish($11,$12);
 STACKTOP = sp;return;
}
function _sqlite3BtreeEnter($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$1>>2]|0;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($5)) + 4|0);
 HEAP32[$6>>2] = $2;
 STACKTOP = sp;return;
}
function _isFatalError($rc) {
 $rc = $rc|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $rc;
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)!=(0);
 $3 = HEAP32[$0>>2]|0;
 $4 = ($3|0)!=(5);
 $or$cond = $2 & $4;
 if (!($or$cond)) {
  $8 = 0;
  $7 = $8&1;
  STACKTOP = sp;return ($7|0);
 }
 $5 = HEAP32[$0>>2]|0;
 $6 = ($5|0)!=(6);
 $8 = $6;
 $7 = $8&1;
 STACKTOP = sp;return ($7|0);
}
function _sqlite3BtreeIsInReadTrans($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 8|0);
 $3 = HEAP8[$2>>0]|0;
 $4 = $3&255;
 $5 = ($4|0)!=(0);
 $6 = $5&1;
 STACKTOP = sp;return ($6|0);
}
function _sqlite3BtreeBeginTrans($p,$wrflag) {
 $p = $p|0;
 $wrflag = $wrflag|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $or$cond = 0, $or$cond3 = 0, $or$cond5 = 0, $or$cond9 = 0, $pBlock = 0, $pBt = 0, $pIter = 0, $pPage1 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 24|0;
 $1 = sp + 20|0;
 $pBt = sp + 16|0;
 $rc = sp + 12|0;
 $pBlock = sp + 8|0;
 $pIter = sp + 4|0;
 $pPage1 = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $wrflag;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[$pBt>>2] = $4;
 HEAP32[$rc>>2] = 0;
 $5 = HEAP32[$0>>2]|0;
 _sqlite3BtreeEnter($5);
 $6 = HEAP32[$0>>2]|0;
 $7 = ((($6)) + 8|0);
 $8 = HEAP8[$7>>0]|0;
 $9 = $8&255;
 $10 = ($9|0)==(2);
 do {
  if (!($10)) {
   $11 = HEAP32[$0>>2]|0;
   $12 = ((($11)) + 8|0);
   $13 = HEAP8[$12>>0]|0;
   $14 = $13&255;
   $15 = ($14|0)!=(1);
   $16 = HEAP32[$1>>2]|0;
   $17 = ($16|0)!=(0);
   $or$cond = $15 | $17;
   if ($or$cond) {
    $18 = HEAP32[$pBt>>2]|0;
    $19 = ((($18)) + 22|0);
    $20 = HEAP16[$19>>1]|0;
    $21 = $20&65535;
    $22 = $21 & 1;
    $23 = ($22|0)!=(0);
    $24 = HEAP32[$1>>2]|0;
    $25 = ($24|0)!=(0);
    $or$cond3 = $23 & $25;
    if ($or$cond3) {
     HEAP32[$rc>>2] = 8;
     break;
    }
    HEAP32[$pBlock>>2] = 0;
    $26 = HEAP32[$1>>2]|0;
    $27 = ($26|0)!=(0);
    if ($27) {
     $28 = HEAP32[$pBt>>2]|0;
     $29 = ((($28)) + 20|0);
     $30 = HEAP8[$29>>0]|0;
     $31 = $30&255;
     $32 = ($31|0)==(2);
     if ($32) {
      label = 8;
     } else {
      label = 7;
     }
    } else {
     label = 7;
    }
    L9: do {
     if ((label|0) == 7) {
      $33 = HEAP32[$pBt>>2]|0;
      $34 = ((($33)) + 22|0);
      $35 = HEAP16[$34>>1]|0;
      $36 = $35&65535;
      $37 = $36 & 64;
      $38 = ($37|0)!=(0);
      if ($38) {
       label = 8;
      } else {
       $43 = HEAP32[$1>>2]|0;
       $44 = ($43|0)>(1);
       if ($44) {
        $45 = HEAP32[$pBt>>2]|0;
        $46 = ((($45)) + 72|0);
        $47 = HEAP32[$46>>2]|0;
        HEAP32[$pIter>>2] = $47;
        while(1) {
         $48 = HEAP32[$pIter>>2]|0;
         $49 = ($48|0)!=(0|0);
         if (!($49)) {
          break L9;
         }
         $50 = HEAP32[$pIter>>2]|0;
         $51 = HEAP32[$50>>2]|0;
         $52 = HEAP32[$0>>2]|0;
         $53 = ($51|0)!=($52|0);
         $54 = HEAP32[$pIter>>2]|0;
         if ($53) {
          break;
         }
         $57 = ((($54)) + 12|0);
         $58 = HEAP32[$57>>2]|0;
         HEAP32[$pIter>>2] = $58;
        }
        $55 = HEAP32[$54>>2]|0;
        $56 = HEAP32[$55>>2]|0;
        HEAP32[$pBlock>>2] = $56;
       }
      }
     }
    } while(0);
    if ((label|0) == 8) {
     $39 = HEAP32[$pBt>>2]|0;
     $40 = ((($39)) + 76|0);
     $41 = HEAP32[$40>>2]|0;
     $42 = HEAP32[$41>>2]|0;
     HEAP32[$pBlock>>2] = $42;
    }
    $59 = HEAP32[$pBlock>>2]|0;
    $60 = ($59|0)!=(0|0);
    if ($60) {
     HEAP32[$rc>>2] = 262;
     break;
    }
    $61 = HEAP32[$0>>2]|0;
    $62 = (_querySharedCacheTableLock($61,1,1)|0);
    HEAP32[$rc>>2] = $62;
    $63 = HEAP32[$rc>>2]|0;
    $64 = (0)!=($63|0);
    if (!($64)) {
     $65 = HEAP32[$pBt>>2]|0;
     $66 = ((($65)) + 22|0);
     $67 = HEAP16[$66>>1]|0;
     $68 = $67&65535;
     $69 = $68 & -9;
     $70 = $69&65535;
     HEAP16[$66>>1] = $70;
     $71 = HEAP32[$pBt>>2]|0;
     $72 = ((($71)) + 44|0);
     $73 = HEAP32[$72>>2]|0;
     $74 = ($73|0)==(0);
     if ($74) {
      $75 = HEAP32[$pBt>>2]|0;
      $76 = ((($75)) + 22|0);
      $77 = HEAP16[$76>>1]|0;
      $78 = $77&65535;
      $79 = $78 | 8;
      $80 = $79&65535;
      HEAP16[$76>>1] = $80;
     }
     while(1) {
      $81 = HEAP32[$pBt>>2]|0;
      $82 = ((($81)) + 12|0);
      $83 = HEAP32[$82>>2]|0;
      $84 = ($83|0)==(0|0);
      if ($84) {
       $85 = HEAP32[$pBt>>2]|0;
       $86 = (_lockBtree($85)|0);
       HEAP32[$rc>>2] = $86;
       $87 = (0)==($86|0);
       if ($87) {
        continue;
       }
      }
      $88 = HEAP32[$rc>>2]|0;
      $89 = ($88|0)==(0);
      $90 = HEAP32[$1>>2]|0;
      $91 = ($90|0)!=(0);
      $or$cond5 = $89 & $91;
      do {
       if ($or$cond5) {
        $92 = HEAP32[$pBt>>2]|0;
        $93 = ((($92)) + 22|0);
        $94 = HEAP16[$93>>1]|0;
        $95 = $94&65535;
        $96 = $95 & 1;
        $97 = ($96|0)!=(0);
        if ($97) {
         HEAP32[$rc>>2] = 8;
         break;
        }
        $98 = HEAP32[$pBt>>2]|0;
        $99 = HEAP32[$98>>2]|0;
        $100 = HEAP32[$1>>2]|0;
        $101 = ($100|0)>(1);
        $102 = $101&1;
        $103 = HEAP32[$0>>2]|0;
        $104 = HEAP32[$103>>2]|0;
        $105 = (_sqlite3TempInMemory($104)|0);
        $106 = (_sqlite3PagerBegin($99,$102,$105)|0);
        HEAP32[$rc>>2] = $106;
        $107 = HEAP32[$rc>>2]|0;
        $108 = ($107|0)==(0);
        if ($108) {
         $109 = HEAP32[$pBt>>2]|0;
         $110 = (_newDatabase($109)|0);
         HEAP32[$rc>>2] = $110;
        }
       }
      } while(0);
      $111 = HEAP32[$rc>>2]|0;
      $112 = ($111|0)!=(0);
      if ($112) {
       $113 = HEAP32[$pBt>>2]|0;
       _unlockBtreeIfUnused($113);
      }
      $114 = HEAP32[$rc>>2]|0;
      $115 = $114 & 255;
      $116 = ($115|0)==(5);
      if (!($116)) {
       break;
      }
      $117 = HEAP32[$pBt>>2]|0;
      $118 = ((($117)) + 20|0);
      $119 = HEAP8[$118>>0]|0;
      $120 = $119&255;
      $121 = ($120|0)==(0);
      if (!($121)) {
       break;
      }
      $122 = HEAP32[$pBt>>2]|0;
      $123 = (_btreeInvokeBusyHandler($122)|0);
      $124 = ($123|0)!=(0);
      if (!($124)) {
       break;
      }
     }
     $125 = HEAP32[$rc>>2]|0;
     $126 = ($125|0)==(0);
     if ($126) {
      $127 = HEAP32[$0>>2]|0;
      $128 = ((($127)) + 8|0);
      $129 = HEAP8[$128>>0]|0;
      $130 = $129&255;
      $131 = ($130|0)==(0);
      if ($131) {
       $132 = HEAP32[$pBt>>2]|0;
       $133 = ((($132)) + 40|0);
       $134 = HEAP32[$133>>2]|0;
       $135 = (($134) + 1)|0;
       HEAP32[$133>>2] = $135;
       $136 = HEAP32[$0>>2]|0;
       $137 = ((($136)) + 9|0);
       $138 = HEAP8[$137>>0]|0;
       $139 = ($138<<24>>24)!=(0);
       if ($139) {
        $140 = HEAP32[$0>>2]|0;
        $141 = ((($140)) + 32|0);
        $142 = ((($141)) + 8|0);
        HEAP8[$142>>0] = 1;
        $143 = HEAP32[$pBt>>2]|0;
        $144 = ((($143)) + 72|0);
        $145 = HEAP32[$144>>2]|0;
        $146 = HEAP32[$0>>2]|0;
        $147 = ((($146)) + 32|0);
        $148 = ((($147)) + 12|0);
        HEAP32[$148>>2] = $145;
        $149 = HEAP32[$0>>2]|0;
        $150 = ((($149)) + 32|0);
        $151 = HEAP32[$pBt>>2]|0;
        $152 = ((($151)) + 72|0);
        HEAP32[$152>>2] = $150;
       }
      }
      $153 = HEAP32[$1>>2]|0;
      $154 = ($153|0)!=(0);
      $155 = $154 ? 2 : 1;
      $156 = $155&255;
      $157 = HEAP32[$0>>2]|0;
      $158 = ((($157)) + 8|0);
      HEAP8[$158>>0] = $156;
      $159 = HEAP32[$0>>2]|0;
      $160 = ((($159)) + 8|0);
      $161 = HEAP8[$160>>0]|0;
      $162 = $161&255;
      $163 = HEAP32[$pBt>>2]|0;
      $164 = ((($163)) + 20|0);
      $165 = HEAP8[$164>>0]|0;
      $166 = $165&255;
      $167 = ($162|0)>($166|0);
      if ($167) {
       $168 = HEAP32[$0>>2]|0;
       $169 = ((($168)) + 8|0);
       $170 = HEAP8[$169>>0]|0;
       $171 = HEAP32[$pBt>>2]|0;
       $172 = ((($171)) + 20|0);
       HEAP8[$172>>0] = $170;
      }
      $173 = HEAP32[$1>>2]|0;
      $174 = ($173|0)!=(0);
      if ($174) {
       $175 = HEAP32[$pBt>>2]|0;
       $176 = ((($175)) + 12|0);
       $177 = HEAP32[$176>>2]|0;
       HEAP32[$pPage1>>2] = $177;
       $178 = HEAP32[$0>>2]|0;
       $179 = HEAP32[$pBt>>2]|0;
       $180 = ((($179)) + 76|0);
       HEAP32[$180>>2] = $178;
       $181 = HEAP32[$pBt>>2]|0;
       $182 = ((($181)) + 22|0);
       $183 = HEAP16[$182>>1]|0;
       $184 = $183&65535;
       $185 = $184 & -33;
       $186 = $185&65535;
       HEAP16[$182>>1] = $186;
       $187 = HEAP32[$1>>2]|0;
       $188 = ($187|0)>(1);
       if ($188) {
        $189 = HEAP32[$pBt>>2]|0;
        $190 = ((($189)) + 22|0);
        $191 = HEAP16[$190>>1]|0;
        $192 = $191&65535;
        $193 = $192 | 32;
        $194 = $193&65535;
        HEAP16[$190>>1] = $194;
       }
       $195 = HEAP32[$pBt>>2]|0;
       $196 = ((($195)) + 44|0);
       $197 = HEAP32[$196>>2]|0;
       $198 = HEAP32[$pPage1>>2]|0;
       $199 = ((($198)) + 56|0);
       $200 = HEAP32[$199>>2]|0;
       $201 = ((($200)) + 28|0);
       $202 = (_sqlite3Get4byte($201)|0);
       $203 = ($197|0)!=($202|0);
       if ($203) {
        $204 = HEAP32[$pPage1>>2]|0;
        $205 = ((($204)) + 72|0);
        $206 = HEAP32[$205>>2]|0;
        $207 = (_sqlite3PagerWrite($206)|0);
        HEAP32[$rc>>2] = $207;
        $208 = HEAP32[$rc>>2]|0;
        $209 = ($208|0)==(0);
        if ($209) {
         $210 = HEAP32[$pPage1>>2]|0;
         $211 = ((($210)) + 56|0);
         $212 = HEAP32[$211>>2]|0;
         $213 = ((($212)) + 28|0);
         $214 = HEAP32[$pBt>>2]|0;
         $215 = ((($214)) + 44|0);
         $216 = HEAP32[$215>>2]|0;
         _sqlite3Put4byte($213,$216);
        }
       }
      }
     }
    }
   }
  }
 } while(0);
 $217 = HEAP32[$rc>>2]|0;
 $218 = ($217|0)==(0);
 $219 = HEAP32[$1>>2]|0;
 $220 = ($219|0)!=(0);
 $or$cond9 = $218 & $220;
 if (!($or$cond9)) {
  $228 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($228|0);
 }
 $221 = HEAP32[$pBt>>2]|0;
 $222 = HEAP32[$221>>2]|0;
 $223 = HEAP32[$0>>2]|0;
 $224 = HEAP32[$223>>2]|0;
 $225 = ((($224)) + 432|0);
 $226 = HEAP32[$225>>2]|0;
 $227 = (_sqlite3PagerOpenSavepoint($222,$226)|0);
 HEAP32[$rc>>2] = $227;
 $228 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($228|0);
}
function _setDestPgsz($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = HEAP32[$0>>2]|0;
 $5 = ((($4)) + 24|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3BtreeGetPageSize($6)|0);
 $8 = (_sqlite3BtreeSetPageSize($3,$7,-1,0)|0);
 HEAP32[$rc>>2] = $8;
 $9 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($9|0);
}
function _sqlite3BtreeGetMeta($p,$idx,$pMeta) {
 $p = $p|0;
 $idx = $idx|0;
 $pMeta = $pMeta|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pBt = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $pBt = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $idx;
 HEAP32[$2>>2] = $pMeta;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 HEAP32[$pBt>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _sqlite3BtreeEnter($6);
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)==(15);
 if ($8) {
  $9 = HEAP32[$pBt>>2]|0;
  $10 = HEAP32[$9>>2]|0;
  $11 = (_sqlite3PagerDataVersion($10)|0);
  $12 = HEAP32[$0>>2]|0;
  $13 = ((($12)) + 20|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = (($11) + ($14))|0;
  $16 = HEAP32[$2>>2]|0;
  HEAP32[$16>>2] = $15;
  STACKTOP = sp;return;
 } else {
  $17 = HEAP32[$1>>2]|0;
  $18 = $17<<2;
  $19 = (36 + ($18))|0;
  $20 = HEAP32[$pBt>>2]|0;
  $21 = ((($20)) + 12|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = ((($22)) + 56|0);
  $24 = HEAP32[$23>>2]|0;
  $25 = (($24) + ($19)|0);
  $26 = (_sqlite3Get4byte($25)|0);
  $27 = HEAP32[$2>>2]|0;
  HEAP32[$27>>2] = $26;
  STACKTOP = sp;return;
 }
}
function _sqlite3BtreeGetPageSize($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 32|0);
 $5 = HEAP32[$4>>2]|0;
 STACKTOP = sp;return ($5|0);
}
function _sqlite3PagerGetJournalMode($pPager) {
 $pPager = $pPager|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pPager;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 5|0);
 $3 = HEAP8[$2>>0]|0;
 $4 = $3&255;
 STACKTOP = sp;return ($4|0);
}
function _sqlite3BtreeLastPage($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = (_btreePagecount($3)|0);
 STACKTOP = sp;return ($4|0);
}
function _sqlite3PagerGet($pPager,$pgno,$ppPage,$flags) {
 $pPager = $pPager|0;
 $pgno = $pgno|0;
 $ppPage = $ppPage|0;
 $flags = $flags|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bMmapOk = 0, $iFrame = 0, $noContent = 0, $or$cond = 0, $or$cond11 = 0, $or$cond3 = 0, $or$cond5 = 0, $or$cond7 = 0, $or$cond9 = 0, $pBase = 0, $pData = 0, $pPg = 0, $rc = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 44|0;
 $1 = sp + 40|0;
 $2 = sp + 36|0;
 $3 = sp + 32|0;
 $4 = sp + 28|0;
 $rc = sp + 24|0;
 $pPg = sp + 20|0;
 $iFrame = sp + 16|0;
 $noContent = sp + 12|0;
 $bMmapOk = sp + 8|0;
 $pData = sp + 4|0;
 $pBase = sp;
 HEAP32[$1>>2] = $pPager;
 HEAP32[$2>>2] = $pgno;
 HEAP32[$3>>2] = $ppPage;
 HEAP32[$4>>2] = $flags;
 HEAP32[$rc>>2] = 0;
 HEAP32[$pPg>>2] = 0;
 HEAP32[$iFrame>>2] = 0;
 $5 = HEAP32[$4>>2]|0;
 $6 = $5 & 1;
 HEAP32[$noContent>>2] = $6;
 $7 = 0;
 HEAP32[$bMmapOk>>2] = $7;
 $8 = HEAP32[$2>>2]|0;
 $9 = ($8>>>0)<=(1);
 $10 = HEAP32[$2>>2]|0;
 $11 = ($10|0)==(0);
 $or$cond = $9 & $11;
 if ($or$cond) {
  $12 = (_sqlite3CorruptError(51704)|0);
  HEAP32[$0>>2] = $12;
  $206 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($206|0);
 }
 $13 = HEAP32[$1>>2]|0;
 $14 = ((($13)) + 44|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)!=(0);
 do {
  if ($16) {
   $17 = HEAP32[$1>>2]|0;
   $18 = ((($17)) + 44|0);
   $19 = HEAP32[$18>>2]|0;
   HEAP32[$rc>>2] = $19;
   label = 24;
  } else {
   $20 = HEAP32[$bMmapOk>>2]|0;
   $21 = ($20|0)!=(0);
   if ($21) {
    $22 = HEAP32[$1>>2]|0;
    $23 = (_sqlite3PagerUseWal($22)|0);
    $24 = ($23|0)!=(0);
    if ($24) {
     $25 = HEAP32[$1>>2]|0;
     $26 = ((($25)) + 216|0);
     $27 = HEAP32[$26>>2]|0;
     $28 = HEAP32[$2>>2]|0;
     $29 = (_sqlite3WalFindFrame($27,$28,$iFrame)|0);
     HEAP32[$rc>>2] = $29;
     $30 = HEAP32[$rc>>2]|0;
     $31 = ($30|0)!=(0);
     if ($31) {
      break;
     }
    }
   }
   $32 = HEAP32[$bMmapOk>>2]|0;
   $33 = ($32|0)!=(0);
   $34 = HEAP32[$iFrame>>2]|0;
   $35 = ($34|0)==(0);
   $or$cond3 = $33 & $35;
   if ($or$cond3) {
    HEAP32[$pData>>2] = 0;
    $36 = HEAP32[$1>>2]|0;
    $37 = ((($36)) + 64|0);
    $38 = HEAP32[$37>>2]|0;
    $39 = HEAP32[$2>>2]|0;
    $40 = (($39) - 1)|0;
    $41 = HEAP32[$1>>2]|0;
    $42 = ((($41)) + 160|0);
    $43 = HEAP32[$42>>2]|0;
    $44 = ($43|0)<(0);
    $45 = $44 << 31 >> 31;
    $46 = (___muldi3(($40|0),0,($43|0),($45|0))|0);
    $47 = tempRet0;
    $48 = HEAP32[$1>>2]|0;
    $49 = ((($48)) + 160|0);
    $50 = HEAP32[$49>>2]|0;
    $51 = (_sqlite3OsFetch($38,$46,$47,$50,$pData)|0);
    HEAP32[$rc>>2] = $51;
    $52 = HEAP32[$rc>>2]|0;
    $53 = ($52|0)==(0);
    $54 = HEAP32[$pData>>2]|0;
    $55 = ($54|0)!=(0|0);
    $or$cond5 = $53 & $55;
    if ($or$cond5) {
     $56 = HEAP32[$1>>2]|0;
     $57 = ((($56)) + 17|0);
     $58 = HEAP8[$57>>0]|0;
     $59 = $58&255;
     $60 = ($59|0)>(1);
     if ($60) {
      label = 12;
     } else {
      $61 = HEAP32[$1>>2]|0;
      $62 = ((($61)) + 13|0);
      $63 = HEAP8[$62>>0]|0;
      $64 = $63&255;
      $65 = ($64|0)!=(0);
      if ($65) {
       label = 12;
      }
     }
     if ((label|0) == 12) {
      $66 = HEAP32[$1>>2]|0;
      $67 = HEAP32[$2>>2]|0;
      $68 = (_sqlite3PagerLookup($66,$67)|0);
      HEAP32[$pPg>>2] = $68;
     }
     $69 = HEAP32[$pPg>>2]|0;
     $70 = ($69|0)==(0|0);
     $71 = HEAP32[$1>>2]|0;
     if ($70) {
      $72 = HEAP32[$2>>2]|0;
      $73 = HEAP32[$pData>>2]|0;
      $74 = (_pagerAcquireMapPage($71,$72,$73,$pPg)|0);
      HEAP32[$rc>>2] = $74;
     } else {
      $75 = ((($71)) + 64|0);
      $76 = HEAP32[$75>>2]|0;
      $77 = HEAP32[$2>>2]|0;
      $78 = (($77) - 1)|0;
      $79 = HEAP32[$1>>2]|0;
      $80 = ((($79)) + 160|0);
      $81 = HEAP32[$80>>2]|0;
      $82 = ($81|0)<(0);
      $83 = $82 << 31 >> 31;
      $84 = (___muldi3(($78|0),0,($81|0),($83|0))|0);
      $85 = tempRet0;
      $86 = HEAP32[$pData>>2]|0;
      (_sqlite3OsUnfetch($76,$84,$85,$86)|0);
     }
     $87 = HEAP32[$pPg>>2]|0;
     $88 = ($87|0)!=(0|0);
     if ($88) {
      $89 = HEAP32[$pPg>>2]|0;
      $90 = HEAP32[$3>>2]|0;
      HEAP32[$90>>2] = $89;
      HEAP32[$0>>2] = 0;
      $206 = HEAP32[$0>>2]|0;
      STACKTOP = sp;return ($206|0);
     }
    }
    $91 = HEAP32[$rc>>2]|0;
    $92 = ($91|0)!=(0);
    if ($92) {
     break;
    }
   }
   $93 = HEAP32[$1>>2]|0;
   $94 = ((($93)) + 212|0);
   $95 = HEAP32[$94>>2]|0;
   $96 = HEAP32[$2>>2]|0;
   $97 = (_sqlite3PcacheFetch($95,$96,3)|0);
   HEAP32[$pBase>>2] = $97;
   $98 = HEAP32[$pBase>>2]|0;
   $99 = ($98|0)==(0|0);
   if ($99) {
    $100 = HEAP32[$1>>2]|0;
    $101 = ((($100)) + 212|0);
    $102 = HEAP32[$101>>2]|0;
    $103 = HEAP32[$2>>2]|0;
    $104 = (_sqlite3PcacheFetchStress($102,$103,$pBase)|0);
    HEAP32[$rc>>2] = $104;
    $105 = HEAP32[$rc>>2]|0;
    $106 = ($105|0)!=(0);
    if ($106) {
     break;
    }
    $107 = HEAP32[$pBase>>2]|0;
    $108 = ($107|0)==(0|0);
    if ($108) {
     $109 = HEAP32[$3>>2]|0;
     HEAP32[$109>>2] = 0;
     HEAP32[$pPg>>2] = 0;
     HEAP32[$rc>>2] = 7;
     break;
    }
   }
   $110 = HEAP32[$1>>2]|0;
   $111 = ((($110)) + 212|0);
   $112 = HEAP32[$111>>2]|0;
   $113 = HEAP32[$2>>2]|0;
   $114 = HEAP32[$pBase>>2]|0;
   $115 = (_sqlite3PcacheFetchFinish($112,$113,$114)|0);
   $116 = HEAP32[$3>>2]|0;
   HEAP32[$116>>2] = $115;
   HEAP32[$pPg>>2] = $115;
   label = 24;
  }
 } while(0);
 do {
  if ((label|0) == 24) {
   $117 = HEAP32[$rc>>2]|0;
   $118 = ($117|0)!=(0);
   if ($118) {
    HEAP32[$pPg>>2] = 0;
    break;
   }
   $119 = HEAP32[$pPg>>2]|0;
   $120 = ((($119)) + 16|0);
   $121 = HEAP32[$120>>2]|0;
   $122 = ($121|0)==(0|0);
   $123 = HEAP32[$noContent>>2]|0;
   $124 = ($123|0)!=(0);
   $or$cond7 = $122 | $124;
   $125 = HEAP32[$1>>2]|0;
   if (!($or$cond7)) {
    $126 = ((($125)) + 192|0);
    $127 = HEAP32[$126>>2]|0;
    $128 = (($127) + 1)|0;
    HEAP32[$126>>2] = $128;
    HEAP32[$0>>2] = 0;
    $206 = HEAP32[$0>>2]|0;
    STACKTOP = sp;return ($206|0);
   }
   $129 = HEAP32[$pPg>>2]|0;
   $130 = ((($129)) + 16|0);
   HEAP32[$130>>2] = $125;
   $131 = HEAP32[$2>>2]|0;
   $132 = ($131>>>0)>(2147483647);
   if (!($132)) {
    $133 = HEAP32[$2>>2]|0;
    $134 = HEAP32[1536>>2]|0;
    $135 = HEAP32[$1>>2]|0;
    $136 = ((($135)) + 160|0);
    $137 = HEAP32[$136>>2]|0;
    $138 = (($134|0) / ($137|0))&-1;
    $139 = (($138) + 1)|0;
    $140 = ($133|0)==($139|0);
    if (!($140)) {
     $142 = HEAP32[$1>>2]|0;
     $143 = ((($142)) + 64|0);
     $144 = HEAP32[$143>>2]|0;
     $145 = HEAP32[$144>>2]|0;
     $146 = ($145|0)!=(0|0);
     if ($146) {
      $147 = HEAP32[$1>>2]|0;
      $148 = ((($147)) + 28|0);
      $149 = HEAP32[$148>>2]|0;
      $150 = HEAP32[$2>>2]|0;
      $151 = ($149>>>0)<($150>>>0);
      $152 = HEAP32[$noContent>>2]|0;
      $153 = ($152|0)!=(0);
      $or$cond9 = $151 | $153;
      if ($or$cond9) {
       label = 33;
      } else {
       $178 = HEAP32[$1>>2]|0;
       $179 = (_sqlite3PagerUseWal($178)|0);
       $180 = ($179|0)!=(0);
       $181 = HEAP32[$bMmapOk>>2]|0;
       $182 = ($181|0)==(0);
       $or$cond11 = $180 & $182;
       if ($or$cond11) {
        $183 = HEAP32[$1>>2]|0;
        $184 = ((($183)) + 216|0);
        $185 = HEAP32[$184>>2]|0;
        $186 = HEAP32[$2>>2]|0;
        $187 = (_sqlite3WalFindFrame($185,$186,$iFrame)|0);
        HEAP32[$rc>>2] = $187;
        $188 = HEAP32[$rc>>2]|0;
        $189 = ($188|0)!=(0);
        if ($189) {
         break;
        }
       }
       $190 = HEAP32[$1>>2]|0;
       $191 = ((($190)) + 192|0);
       $192 = ((($191)) + 4|0);
       $193 = HEAP32[$192>>2]|0;
       $194 = (($193) + 1)|0;
       HEAP32[$192>>2] = $194;
       $195 = HEAP32[$pPg>>2]|0;
       $196 = HEAP32[$iFrame>>2]|0;
       $197 = (_readDbPage($195,$196)|0);
       HEAP32[$rc>>2] = $197;
       $198 = HEAP32[$rc>>2]|0;
       $199 = ($198|0)!=(0);
       if ($199) {
        break;
       }
      }
     } else {
      label = 33;
     }
     if ((label|0) == 33) {
      $154 = HEAP32[$2>>2]|0;
      $155 = HEAP32[$1>>2]|0;
      $156 = ((($155)) + 164|0);
      $157 = HEAP32[$156>>2]|0;
      $158 = ($154>>>0)>($157>>>0);
      if ($158) {
       HEAP32[$rc>>2] = 13;
       break;
      }
      $159 = HEAP32[$noContent>>2]|0;
      $160 = ($159|0)!=(0);
      if ($160) {
       _sqlite3BeginBenignMalloc();
       $161 = HEAP32[$2>>2]|0;
       $162 = HEAP32[$1>>2]|0;
       $163 = ((($162)) + 32|0);
       $164 = HEAP32[$163>>2]|0;
       $165 = ($161>>>0)<=($164>>>0);
       if ($165) {
        $166 = HEAP32[$1>>2]|0;
        $167 = ((($166)) + 60|0);
        $168 = HEAP32[$167>>2]|0;
        $169 = HEAP32[$2>>2]|0;
        (_sqlite3BitvecSet($168,$169)|0);
       }
       $170 = HEAP32[$1>>2]|0;
       $171 = HEAP32[$2>>2]|0;
       (_addToSavepointBitvecs($170,$171)|0);
       _sqlite3EndBenignMalloc();
      }
      $172 = HEAP32[$pPg>>2]|0;
      $173 = ((($172)) + 4|0);
      $174 = HEAP32[$173>>2]|0;
      $175 = HEAP32[$1>>2]|0;
      $176 = ((($175)) + 160|0);
      $177 = HEAP32[$176>>2]|0;
      _memset(($174|0),0,($177|0))|0;
     }
     HEAP32[$0>>2] = 0;
     $206 = HEAP32[$0>>2]|0;
     STACKTOP = sp;return ($206|0);
    }
   }
   $141 = (_sqlite3CorruptError(51793)|0);
   HEAP32[$rc>>2] = $141;
  }
 } while(0);
 $200 = HEAP32[$pPg>>2]|0;
 $201 = ($200|0)!=(0|0);
 if ($201) {
  $202 = HEAP32[$pPg>>2]|0;
  _sqlite3PcacheDrop($202);
 }
 $203 = HEAP32[$1>>2]|0;
 _pagerUnlockIfUnused($203);
 $204 = HEAP32[$3>>2]|0;
 HEAP32[$204>>2] = 0;
 $205 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $205;
 $206 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($206|0);
}
function _sqlite3PagerGetData($pPg) {
 $pPg = $pPg|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pPg;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($3|0);
}
function _backupOnePage($p,$iSrcPg,$zSrcData,$bUpdate) {
 $p = $p|0;
 $iSrcPg = $iSrcPg|0;
 $zSrcData = $zSrcData|0;
 $bUpdate = $bUpdate|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
 var $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0;
 var $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0;
 var $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0;
 var $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $iDest = 0, $iEnd = 0, $iOff = 0, $nCopy = 0, $nDestPgsz = 0, $nSrcPgsz = 0, $or$cond = 0, $pDestPager = 0, $pDestPg = 0, $rc = 0;
 var $zDestData = 0, $zIn = 0, $zOut = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0;
 $0 = sp + 68|0;
 $1 = sp + 64|0;
 $2 = sp + 60|0;
 $3 = sp + 56|0;
 $pDestPager = sp + 52|0;
 $nSrcPgsz = sp + 48|0;
 $nDestPgsz = sp + 44|0;
 $nCopy = sp + 40|0;
 $iEnd = sp + 8|0;
 $rc = sp + 36|0;
 $iOff = sp;
 $pDestPg = sp + 32|0;
 $iDest = sp + 28|0;
 $zIn = sp + 24|0;
 $zDestData = sp + 20|0;
 $zOut = sp + 16|0;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $iSrcPg;
 HEAP32[$2>>2] = $zSrcData;
 HEAP32[$3>>2] = $bUpdate;
 $4 = HEAP32[$0>>2]|0;
 $5 = ((($4)) + 4|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = (_sqlite3BtreePager($6)|0);
 HEAP32[$pDestPager>>2] = $7;
 $8 = HEAP32[$0>>2]|0;
 $9 = ((($8)) + 24|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = (_sqlite3BtreeGetPageSize($10)|0);
 HEAP32[$nSrcPgsz>>2] = $11;
 $12 = HEAP32[$0>>2]|0;
 $13 = ((($12)) + 4|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = (_sqlite3BtreeGetPageSize($14)|0);
 HEAP32[$nDestPgsz>>2] = $15;
 $16 = HEAP32[$nSrcPgsz>>2]|0;
 $17 = HEAP32[$nDestPgsz>>2]|0;
 $18 = ($16|0)<($17|0);
 $19 = HEAP32[$nSrcPgsz>>2]|0;
 $20 = HEAP32[$nDestPgsz>>2]|0;
 $21 = $18 ? $19 : $20;
 HEAP32[$nCopy>>2] = $21;
 $22 = HEAP32[$1>>2]|0;
 $23 = HEAP32[$nSrcPgsz>>2]|0;
 $24 = ($23|0)<(0);
 $25 = $24 << 31 >> 31;
 $26 = (___muldi3(($22|0),0,($23|0),($25|0))|0);
 $27 = tempRet0;
 $28 = $iEnd;
 $29 = $28;
 HEAP32[$29>>2] = $26;
 $30 = (($28) + 4)|0;
 $31 = $30;
 HEAP32[$31>>2] = $27;
 HEAP32[$rc>>2] = 0;
 $32 = HEAP32[$nSrcPgsz>>2]|0;
 $33 = HEAP32[$nDestPgsz>>2]|0;
 $34 = ($32|0)!=($33|0);
 if ($34) {
  $35 = HEAP32[$pDestPager>>2]|0;
  $36 = (_sqlite3PagerIsMemdb($35)|0);
  $37 = ($36|0)!=(0);
  if ($37) {
   HEAP32[$rc>>2] = 8;
  }
 }
 $38 = $iEnd;
 $39 = $38;
 $40 = HEAP32[$39>>2]|0;
 $41 = (($38) + 4)|0;
 $42 = $41;
 $43 = HEAP32[$42>>2]|0;
 $44 = HEAP32[$nSrcPgsz>>2]|0;
 $45 = ($44|0)<(0);
 $46 = $45 << 31 >> 31;
 $47 = (_i64Subtract(($40|0),($43|0),($44|0),($46|0))|0);
 $48 = tempRet0;
 $49 = $iOff;
 $50 = $49;
 HEAP32[$50>>2] = $47;
 $51 = (($49) + 4)|0;
 $52 = $51;
 HEAP32[$52>>2] = $48;
 while(1) {
  $53 = HEAP32[$rc>>2]|0;
  $54 = ($53|0)==(0);
  if (!($54)) {
   label = 14;
   break;
  }
  $55 = $iOff;
  $56 = $55;
  $57 = HEAP32[$56>>2]|0;
  $58 = (($55) + 4)|0;
  $59 = $58;
  $60 = HEAP32[$59>>2]|0;
  $61 = $iEnd;
  $62 = $61;
  $63 = HEAP32[$62>>2]|0;
  $64 = (($61) + 4)|0;
  $65 = $64;
  $66 = HEAP32[$65>>2]|0;
  $67 = ($60|0)<($66|0);
  $68 = ($57>>>0)<($63>>>0);
  $69 = ($60|0)==($66|0);
  $70 = $69 & $68;
  $71 = $67 | $70;
  if (!($71)) {
   label = 14;
   break;
  }
  HEAP32[$pDestPg>>2] = 0;
  $72 = $iOff;
  $73 = $72;
  $74 = HEAP32[$73>>2]|0;
  $75 = (($72) + 4)|0;
  $76 = $75;
  $77 = HEAP32[$76>>2]|0;
  $78 = HEAP32[$nDestPgsz>>2]|0;
  $79 = ($78|0)<(0);
  $80 = $79 << 31 >> 31;
  $81 = (___divdi3(($74|0),($77|0),($78|0),($80|0))|0);
  $82 = tempRet0;
  $83 = (($81) + 1)|0;
  HEAP32[$iDest>>2] = $83;
  $84 = HEAP32[$iDest>>2]|0;
  $85 = HEAP32[1536>>2]|0;
  $86 = HEAP32[$0>>2]|0;
  $87 = ((($86)) + 4|0);
  $88 = HEAP32[$87>>2]|0;
  $89 = ((($88)) + 4|0);
  $90 = HEAP32[$89>>2]|0;
  $91 = ((($90)) + 32|0);
  $92 = HEAP32[$91>>2]|0;
  $93 = (($85>>>0) / ($92>>>0))&-1;
  $94 = (($93) + 1)|0;
  $95 = ($84|0)==($94|0);
  if (!($95)) {
   $96 = HEAP32[$pDestPager>>2]|0;
   $97 = HEAP32[$iDest>>2]|0;
   $98 = (_sqlite3PagerGet($96,$97,$pDestPg,0)|0);
   HEAP32[$rc>>2] = $98;
   $99 = (0)==($98|0);
   if ($99) {
    $100 = HEAP32[$pDestPg>>2]|0;
    $101 = (_sqlite3PagerWrite($100)|0);
    HEAP32[$rc>>2] = $101;
    $102 = (0)==($101|0);
    if ($102) {
     $103 = $iOff;
     $104 = $103;
     $105 = HEAP32[$104>>2]|0;
     $106 = (($103) + 4)|0;
     $107 = $106;
     $108 = HEAP32[$107>>2]|0;
     $109 = HEAP32[$nSrcPgsz>>2]|0;
     $110 = ($109|0)<(0);
     $111 = $110 << 31 >> 31;
     $112 = (___remdi3(($105|0),($108|0),($109|0),($111|0))|0);
     $113 = tempRet0;
     $114 = HEAP32[$2>>2]|0;
     $115 = (($114) + ($112)|0);
     HEAP32[$zIn>>2] = $115;
     $116 = HEAP32[$pDestPg>>2]|0;
     $117 = (_sqlite3PagerGetData($116)|0);
     HEAP32[$zDestData>>2] = $117;
     $118 = $iOff;
     $119 = $118;
     $120 = HEAP32[$119>>2]|0;
     $121 = (($118) + 4)|0;
     $122 = $121;
     $123 = HEAP32[$122>>2]|0;
     $124 = HEAP32[$nDestPgsz>>2]|0;
     $125 = ($124|0)<(0);
     $126 = $125 << 31 >> 31;
     $127 = (___remdi3(($120|0),($123|0),($124|0),($126|0))|0);
     $128 = tempRet0;
     $129 = HEAP32[$zDestData>>2]|0;
     $130 = (($129) + ($127)|0);
     HEAP32[$zOut>>2] = $130;
     $131 = HEAP32[$zOut>>2]|0;
     $132 = HEAP32[$zIn>>2]|0;
     $133 = HEAP32[$nCopy>>2]|0;
     _memcpy(($131|0),($132|0),($133|0))|0;
     $134 = HEAP32[$pDestPg>>2]|0;
     $135 = (_sqlite3PagerGetExtra($134)|0);
     HEAP8[$135>>0] = 0;
     $136 = $iOff;
     $137 = $136;
     $138 = HEAP32[$137>>2]|0;
     $139 = (($136) + 4)|0;
     $140 = $139;
     $141 = HEAP32[$140>>2]|0;
     $142 = ($138|0)==(0);
     $143 = ($141|0)==(0);
     $144 = $142 & $143;
     $145 = HEAP32[$3>>2]|0;
     $146 = ($145|0)==(0);
     $or$cond = $144 & $146;
     if ($or$cond) {
      $147 = HEAP32[$zOut>>2]|0;
      $148 = ((($147)) + 28|0);
      $149 = HEAP32[$0>>2]|0;
      $150 = ((($149)) + 24|0);
      $151 = HEAP32[$150>>2]|0;
      $152 = (_sqlite3BtreeLastPage($151)|0);
      _sqlite3Put4byte($148,$152);
     }
    }
   }
   $153 = HEAP32[$pDestPg>>2]|0;
   _sqlite3PagerUnref($153);
  }
  $154 = HEAP32[$nDestPgsz>>2]|0;
  $155 = ($154|0)<(0);
  $156 = $155 << 31 >> 31;
  $157 = $iOff;
  $158 = $157;
  $159 = HEAP32[$158>>2]|0;
  $160 = (($157) + 4)|0;
  $161 = $160;
  $162 = HEAP32[$161>>2]|0;
  $163 = (_i64Add(($159|0),($162|0),($154|0),($156|0))|0);
  $164 = tempRet0;
  $165 = $iOff;
  $166 = $165;
  HEAP32[$166>>2] = $163;
  $167 = (($165) + 4)|0;
  $168 = $167;
  HEAP32[$168>>2] = $164;
 }
 if ((label|0) == 14) {
  $169 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($169|0);
 }
 return (0)|0;
}
function _sqlite3PagerUnref($pPg) {
 $pPg = $pPg|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pPg;
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)!=(0|0);
 if (!($2)) {
  STACKTOP = sp;return;
 }
 $3 = HEAP32[$0>>2]|0;
 _sqlite3PagerUnrefNotNull($3);
 STACKTOP = sp;return;
}
function _attachBackupObject($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $pp = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 24|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = (_sqlite3BtreePager($3)|0);
 $5 = (_sqlite3PagerBackupPtr($4)|0);
 HEAP32[$pp>>2] = $5;
 $6 = HEAP32[$pp>>2]|0;
 $7 = HEAP32[$6>>2]|0;
 $8 = HEAP32[$0>>2]|0;
 $9 = ((($8)) + 44|0);
 HEAP32[$9>>2] = $7;
 $10 = HEAP32[$0>>2]|0;
 $11 = HEAP32[$pp>>2]|0;
 HEAP32[$11>>2] = $10;
 $12 = HEAP32[$0>>2]|0;
 $13 = ((($12)) + 40|0);
 HEAP32[$13>>2] = 1;
 STACKTOP = sp;return;
}
function _sqlite3BtreeNewDb($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 _sqlite3BtreeEnter($1);
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($4)) + 44|0);
 HEAP32[$5>>2] = 0;
 $6 = HEAP32[$0>>2]|0;
 $7 = ((($6)) + 4|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (_newDatabase($8)|0);
 HEAP32[$rc>>2] = $9;
 $10 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($10|0);
}
function _sqlite3BtreeUpdateMeta($p,$idx,$iMeta) {
 $p = $p|0;
 $idx = $idx|0;
 $iMeta = $iMeta|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pBt = 0, $pP1 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $2 = sp + 12|0;
 $pBt = sp + 8|0;
 $pP1 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $idx;
 HEAP32[$2>>2] = $iMeta;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 HEAP32[$pBt>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _sqlite3BtreeEnter($6);
 $7 = HEAP32[$pBt>>2]|0;
 $8 = ((($7)) + 12|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($9)) + 56|0);
 $11 = HEAP32[$10>>2]|0;
 HEAP32[$pP1>>2] = $11;
 $12 = HEAP32[$pBt>>2]|0;
 $13 = ((($12)) + 12|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = ((($14)) + 72|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = (_sqlite3PagerWrite($16)|0);
 HEAP32[$rc>>2] = $17;
 $18 = HEAP32[$rc>>2]|0;
 $19 = ($18|0)==(0);
 if (!($19)) {
  $32 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($32|0);
 }
 $20 = HEAP32[$1>>2]|0;
 $21 = $20<<2;
 $22 = (36 + ($21))|0;
 $23 = HEAP32[$pP1>>2]|0;
 $24 = (($23) + ($22)|0);
 $25 = HEAP32[$2>>2]|0;
 _sqlite3Put4byte($24,$25);
 $26 = HEAP32[$1>>2]|0;
 $27 = ($26|0)==(7);
 if (!($27)) {
  $32 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($32|0);
 }
 $28 = HEAP32[$2>>2]|0;
 $29 = $28&255;
 $30 = HEAP32[$pBt>>2]|0;
 $31 = ((($30)) + 18|0);
 HEAP8[$31>>0] = $29;
 $32 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($32|0);
}
function _sqlite3ResetAllSchemasOfConnection($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $pDb = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $i = sp + 4|0;
 $pDb = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 _sqlite3BtreeEnterAll($1);
 HEAP32[$i>>2] = 0;
 while(1) {
  $2 = HEAP32[$i>>2]|0;
  $3 = HEAP32[$0>>2]|0;
  $4 = ((($3)) + 20|0);
  $5 = HEAP32[$4>>2]|0;
  $6 = ($2|0)<($5|0);
  if (!($6)) {
   break;
  }
  $7 = HEAP32[$i>>2]|0;
  $8 = HEAP32[$0>>2]|0;
  $9 = ((($8)) + 16|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = (($10) + ($7<<4)|0);
  HEAP32[$pDb>>2] = $11;
  $12 = HEAP32[$pDb>>2]|0;
  $13 = ((($12)) + 12|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = ($14|0)!=(0|0);
  if ($15) {
   $16 = HEAP32[$pDb>>2]|0;
   $17 = ((($16)) + 12|0);
   $18 = HEAP32[$17>>2]|0;
   _sqlite3SchemaClear($18);
  }
  $19 = HEAP32[$i>>2]|0;
  $20 = (($19) + 1)|0;
  HEAP32[$i>>2] = $20;
 }
 $21 = HEAP32[$0>>2]|0;
 $22 = ((($21)) + 24|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = $23 & -3;
 HEAP32[$22>>2] = $24;
 $25 = HEAP32[$0>>2]|0;
 _sqlite3VtabUnlockList($25);
 $26 = HEAP32[$0>>2]|0;
 _sqlite3CollapseDatabaseArray($26);
 STACKTOP = sp;return;
}
function _sqlite3BtreeSetVersion($pBtree,$iVersion) {
 $pBtree = $pBtree|0;
 $iVersion = $iVersion|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $8 = 0, $9 = 0, $aData = 0, $pBt = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $pBt = sp + 8|0;
 $rc = sp + 4|0;
 $aData = sp;
 HEAP32[$0>>2] = $pBtree;
 HEAP32[$1>>2] = $iVersion;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[$pBt>>2] = $4;
 $5 = HEAP32[$pBt>>2]|0;
 $6 = ((($5)) + 22|0);
 $7 = HEAP16[$6>>1]|0;
 $8 = $7&65535;
 $9 = $8 & -17;
 $10 = $9&65535;
 HEAP16[$6>>1] = $10;
 $11 = HEAP32[$1>>2]|0;
 $12 = ($11|0)==(1);
 if ($12) {
  $13 = HEAP32[$pBt>>2]|0;
  $14 = ((($13)) + 22|0);
  $15 = HEAP16[$14>>1]|0;
  $16 = $15&65535;
  $17 = $16 | 16;
  $18 = $17&65535;
  HEAP16[$14>>1] = $18;
 }
 $19 = HEAP32[$0>>2]|0;
 $20 = (_sqlite3BtreeBeginTrans($19,0)|0);
 HEAP32[$rc>>2] = $20;
 $21 = HEAP32[$rc>>2]|0;
 $22 = ($21|0)==(0);
 do {
  if ($22) {
   $23 = HEAP32[$pBt>>2]|0;
   $24 = ((($23)) + 12|0);
   $25 = HEAP32[$24>>2]|0;
   $26 = ((($25)) + 56|0);
   $27 = HEAP32[$26>>2]|0;
   HEAP32[$aData>>2] = $27;
   $28 = HEAP32[$aData>>2]|0;
   $29 = ((($28)) + 18|0);
   $30 = HEAP8[$29>>0]|0;
   $31 = $30&255;
   $32 = HEAP32[$1>>2]|0;
   $33 = $32&255;
   $34 = $33&255;
   $35 = ($31|0)!=($34|0);
   if (!($35)) {
    $36 = HEAP32[$aData>>2]|0;
    $37 = ((($36)) + 19|0);
    $38 = HEAP8[$37>>0]|0;
    $39 = $38&255;
    $40 = HEAP32[$1>>2]|0;
    $41 = $40&255;
    $42 = $41&255;
    $43 = ($39|0)!=($42|0);
    if (!($43)) {
     break;
    }
   }
   $44 = HEAP32[$0>>2]|0;
   $45 = (_sqlite3BtreeBeginTrans($44,2)|0);
   HEAP32[$rc>>2] = $45;
   $46 = HEAP32[$rc>>2]|0;
   $47 = ($46|0)==(0);
   if ($47) {
    $48 = HEAP32[$pBt>>2]|0;
    $49 = ((($48)) + 12|0);
    $50 = HEAP32[$49>>2]|0;
    $51 = ((($50)) + 72|0);
    $52 = HEAP32[$51>>2]|0;
    $53 = (_sqlite3PagerWrite($52)|0);
    HEAP32[$rc>>2] = $53;
    $54 = HEAP32[$rc>>2]|0;
    $55 = ($54|0)==(0);
    if ($55) {
     $56 = HEAP32[$1>>2]|0;
     $57 = $56&255;
     $58 = HEAP32[$aData>>2]|0;
     $59 = ((($58)) + 18|0);
     HEAP8[$59>>0] = $57;
     $60 = HEAP32[$1>>2]|0;
     $61 = $60&255;
     $62 = HEAP32[$aData>>2]|0;
     $63 = ((($62)) + 19|0);
     HEAP8[$63>>0] = $61;
    }
   }
  }
 } while(0);
 $64 = HEAP32[$pBt>>2]|0;
 $65 = ((($64)) + 22|0);
 $66 = HEAP16[$65>>1]|0;
 $67 = $66&65535;
 $68 = $67 & -17;
 $69 = $68&65535;
 HEAP16[$65>>1] = $69;
 $70 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($70|0);
}
function _sqlite3PagerFile($pPager) {
 $pPager = $pPager|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pPager;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 64|0);
 $3 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($3|0);
}
function _sqlite3PagerPagecount($pPager,$pnPage) {
 $pPager = $pPager|0;
 $pnPage = $pnPage|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pPager;
 HEAP32[$1>>2] = $pnPage;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 28|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 HEAP32[$5>>2] = $4;
 STACKTOP = sp;return;
}
function _sqlite3PagerWrite($pPg) {
 $pPg = $pPg|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $pPager = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $pPager = sp;
 HEAP32[$1>>2] = $pPg;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 16|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[$pPager>>2] = $4;
 $5 = HEAP32[$pPager>>2]|0;
 $6 = ((($5)) + 44|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)!=(0);
 if ($8) {
  $9 = HEAP32[$pPager>>2]|0;
  $10 = ((($9)) + 44|0);
  $11 = HEAP32[$10>>2]|0;
  HEAP32[$0>>2] = $11;
  $41 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($41|0);
 }
 $12 = HEAP32[$1>>2]|0;
 $13 = ((($12)) + 24|0);
 $14 = HEAP16[$13>>1]|0;
 $15 = $14&65535;
 $16 = $15 & 4;
 $17 = ($16|0)!=(0);
 if ($17) {
  $18 = HEAP32[$pPager>>2]|0;
  $19 = ((($18)) + 28|0);
  $20 = HEAP32[$19>>2]|0;
  $21 = HEAP32[$1>>2]|0;
  $22 = ((($21)) + 20|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = ($20>>>0)>=($23>>>0);
  if ($24) {
   $25 = HEAP32[$pPager>>2]|0;
   $26 = ((($25)) + 104|0);
   $27 = HEAP32[$26>>2]|0;
   $28 = ($27|0)!=(0);
   if ($28) {
    $29 = HEAP32[$1>>2]|0;
    $30 = (_subjournalPageIfRequired($29)|0);
    HEAP32[$0>>2] = $30;
    $41 = HEAP32[$0>>2]|0;
    STACKTOP = sp;return ($41|0);
   } else {
    HEAP32[$0>>2] = 0;
    $41 = HEAP32[$0>>2]|0;
    STACKTOP = sp;return ($41|0);
   }
  }
 }
 $31 = HEAP32[$pPager>>2]|0;
 $32 = ((($31)) + 156|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = HEAP32[$pPager>>2]|0;
 $35 = ((($34)) + 160|0);
 $36 = HEAP32[$35>>2]|0;
 $37 = ($33>>>0)>($36>>>0);
 $38 = HEAP32[$1>>2]|0;
 if ($37) {
  $39 = (_pagerWriteLargeSector($38)|0);
  HEAP32[$0>>2] = $39;
  $41 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($41|0);
 } else {
  $40 = (_pager_write($38)|0);
  HEAP32[$0>>2] = $40;
  $41 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($41|0);
 }
 return (0)|0;
}
function _sqlite3PagerCommitPhaseOne($pPager,$zMaster,$noSync) {
 $pPager = $pPager|0;
 $zMaster = $zMaster|0;
 $noSync = $noSync|0;
 var $$old = 0, $$old1 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0;
 var $114 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $nNew = 0, $or$cond = 0, $pList = 0;
 var $pPageOne = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $3 = sp + 16|0;
 $rc = sp + 12|0;
 $pList = sp + 8|0;
 $pPageOne = sp + 4|0;
 $nNew = sp;
 HEAP32[$1>>2] = $pPager;
 HEAP32[$2>>2] = $zMaster;
 HEAP32[$3>>2] = $noSync;
 HEAP32[$rc>>2] = 0;
 $4 = HEAP32[$1>>2]|0;
 $5 = ((($4)) + 44|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ($6|0)!=(0);
 if ($7) {
  $8 = HEAP32[$1>>2]|0;
  $9 = ((($8)) + 44|0);
  $10 = HEAP32[$9>>2]|0;
  HEAP32[$0>>2] = $10;
  $114 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($114|0);
 }
 $11 = (_sqlite3FaultSim(400)|0);
 $12 = ($11|0)!=(0);
 if ($12) {
  HEAP32[$0>>2] = 10;
  $114 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($114|0);
 }
 $13 = HEAP32[$1>>2]|0;
 $14 = ((($13)) + 17|0);
 $15 = HEAP8[$14>>0]|0;
 $16 = $15&255;
 $17 = ($16|0)<(3);
 if ($17) {
  HEAP32[$0>>2] = 0;
  $114 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($114|0);
 }
 $18 = HEAP32[$1>>2]|0;
 $19 = (_pagerFlushOnCommit($18,1)|0);
 $20 = (0)==($19|0);
 $21 = HEAP32[$1>>2]|0;
 do {
  if ($20) {
   $22 = ((($21)) + 96|0);
   $23 = HEAP32[$22>>2]|0;
   _sqlite3BackupRestart($23);
  } else {
   $24 = (_sqlite3PagerUseWal($21)|0);
   $25 = ($24|0)!=(0);
   $26 = HEAP32[$1>>2]|0;
   if ($25) {
    $27 = ((($26)) + 212|0);
    $28 = HEAP32[$27>>2]|0;
    $29 = (_sqlite3PcacheDirtyList($28)|0);
    HEAP32[$pList>>2] = $29;
    HEAP32[$pPageOne>>2] = 0;
    $30 = HEAP32[$pList>>2]|0;
    $31 = ($30|0)==(0|0);
    if ($31) {
     $32 = HEAP32[$1>>2]|0;
     $33 = (_sqlite3PagerGet($32,1,$pPageOne,0)|0);
     HEAP32[$rc>>2] = $33;
     $34 = HEAP32[$pPageOne>>2]|0;
     HEAP32[$pList>>2] = $34;
     $35 = HEAP32[$pList>>2]|0;
     $36 = ((($35)) + 12|0);
     HEAP32[$36>>2] = 0;
    }
    $37 = HEAP32[$pList>>2]|0;
    $38 = ($37|0)!=(0|0);
    if ($38) {
     $39 = HEAP32[$1>>2]|0;
     $40 = HEAP32[$pList>>2]|0;
     $41 = HEAP32[$1>>2]|0;
     $42 = ((($41)) + 28|0);
     $43 = HEAP32[$42>>2]|0;
     $44 = (_pagerWalFrames($39,$40,$43,1)|0);
     HEAP32[$rc>>2] = $44;
    }
    $45 = HEAP32[$pPageOne>>2]|0;
    _sqlite3PagerUnref($45);
    $46 = HEAP32[$rc>>2]|0;
    $47 = ($46|0)==(0);
    if (!($47)) {
     break;
    }
    $48 = HEAP32[$1>>2]|0;
    $49 = ((($48)) + 212|0);
    $50 = HEAP32[$49>>2]|0;
    _sqlite3PcacheCleanAll($50);
    break;
   }
   $51 = (_pager_incr_changecounter($26,0)|0);
   HEAP32[$rc>>2] = $51;
   $52 = HEAP32[$rc>>2]|0;
   $53 = ($52|0)!=(0);
   if (!($53)) {
    $54 = HEAP32[$1>>2]|0;
    $55 = HEAP32[$2>>2]|0;
    $56 = (_writeMasterJournal($54,$55)|0);
    HEAP32[$rc>>2] = $56;
    $57 = HEAP32[$rc>>2]|0;
    $58 = ($57|0)!=(0);
    if (!($58)) {
     $59 = HEAP32[$1>>2]|0;
     $60 = (_syncJournal($59,0)|0);
     HEAP32[$rc>>2] = $60;
     $61 = HEAP32[$rc>>2]|0;
     $62 = ($61|0)!=(0);
     if (!($62)) {
      $63 = HEAP32[$1>>2]|0;
      $64 = HEAP32[$1>>2]|0;
      $65 = ((($64)) + 212|0);
      $66 = HEAP32[$65>>2]|0;
      $67 = (_sqlite3PcacheDirtyList($66)|0);
      $68 = (_pager_write_pagelist($63,$67)|0);
      HEAP32[$rc>>2] = $68;
      $69 = HEAP32[$rc>>2]|0;
      $70 = ($69|0)!=(0);
      if (!($70)) {
       $71 = HEAP32[$1>>2]|0;
       $72 = ((($71)) + 212|0);
       $73 = HEAP32[$72>>2]|0;
       _sqlite3PcacheCleanAll($73);
       $74 = HEAP32[$1>>2]|0;
       $75 = ((($74)) + 28|0);
       $76 = HEAP32[$75>>2]|0;
       $77 = HEAP32[$1>>2]|0;
       $78 = ((($77)) + 36|0);
       $79 = HEAP32[$78>>2]|0;
       $80 = ($76>>>0)>($79>>>0);
       if ($80) {
        $81 = HEAP32[$1>>2]|0;
        $82 = ((($81)) + 28|0);
        $83 = HEAP32[$82>>2]|0;
        $84 = HEAP32[$1>>2]|0;
        $85 = ((($84)) + 28|0);
        $86 = HEAP32[$85>>2]|0;
        $87 = HEAP32[1536>>2]|0;
        $88 = HEAP32[$1>>2]|0;
        $89 = ((($88)) + 160|0);
        $90 = HEAP32[$89>>2]|0;
        $91 = (($87|0) / ($90|0))&-1;
        $92 = (($91) + 1)|0;
        $93 = ($86|0)==($92|0);
        $94 = $93&1;
        $95 = (($83) - ($94))|0;
        HEAP32[$nNew>>2] = $95;
        $96 = HEAP32[$1>>2]|0;
        $97 = HEAP32[$nNew>>2]|0;
        $98 = (_pager_truncate($96,$97)|0);
        HEAP32[$rc>>2] = $98;
        $99 = HEAP32[$rc>>2]|0;
        $100 = ($99|0)!=(0);
        $101 = HEAP32[$3>>2]|0;
        $102 = ($101|0)!=(0);
        $or$cond = $100 | $102;
        if ($or$cond) {
         break;
        }
       } else {
        $$old = HEAP32[$3>>2]|0;
        $$old1 = ($$old|0)!=(0);
        if ($$old1) {
         break;
        }
       }
       $103 = HEAP32[$1>>2]|0;
       $104 = HEAP32[$2>>2]|0;
       $105 = (_sqlite3PagerSync($103,$104)|0);
       HEAP32[$rc>>2] = $105;
      }
     }
    }
   }
  }
 } while(0);
 $106 = HEAP32[$rc>>2]|0;
 $107 = ($106|0)==(0);
 if ($107) {
  $108 = HEAP32[$1>>2]|0;
  $109 = (_sqlite3PagerUseWal($108)|0);
  $110 = ($109|0)!=(0);
  if (!($110)) {
   $111 = HEAP32[$1>>2]|0;
   $112 = ((($111)) + 17|0);
   HEAP8[$112>>0] = 5;
  }
 }
 $113 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $113;
 $114 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($114|0);
}
function _sqlite3OsWrite($id,$pBuf,$amt,$0,$1) {
 $id = $id|0;
 $pBuf = $pBuf|0;
 $amt = $amt|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 16|0;
 $3 = sp + 12|0;
 $4 = sp + 8|0;
 $5 = sp;
 HEAP32[$2>>2] = $id;
 HEAP32[$3>>2] = $pBuf;
 HEAP32[$4>>2] = $amt;
 $6 = $5;
 $7 = $6;
 HEAP32[$7>>2] = $0;
 $8 = (($6) + 4)|0;
 $9 = $8;
 HEAP32[$9>>2] = $1;
 $10 = HEAP32[$2>>2]|0;
 $11 = HEAP32[$10>>2]|0;
 $12 = ((($11)) + 12|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = HEAP32[$2>>2]|0;
 $15 = HEAP32[$3>>2]|0;
 $16 = HEAP32[$4>>2]|0;
 $17 = $5;
 $18 = $17;
 $19 = HEAP32[$18>>2]|0;
 $20 = (($17) + 4)|0;
 $21 = $20;
 $22 = HEAP32[$21>>2]|0;
 $23 = (FUNCTION_TABLE_iiiiii[$13 & 255]($14,$15,$16,$19,$22)|0);
 STACKTOP = sp;return ($23|0);
}
function _backupTruncateFile($pFile,$0,$1) {
 $pFile = $pFile|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $iCurrent = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 20|0;
 $3 = sp + 8|0;
 $iCurrent = sp;
 $rc = sp + 16|0;
 HEAP32[$2>>2] = $pFile;
 $4 = $3;
 $5 = $4;
 HEAP32[$5>>2] = $0;
 $6 = (($4) + 4)|0;
 $7 = $6;
 HEAP32[$7>>2] = $1;
 $8 = HEAP32[$2>>2]|0;
 $9 = (_sqlite3OsFileSize($8,$iCurrent)|0);
 HEAP32[$rc>>2] = $9;
 $10 = HEAP32[$rc>>2]|0;
 $11 = ($10|0)==(0);
 if (!($11)) {
  $37 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 $12 = $iCurrent;
 $13 = $12;
 $14 = HEAP32[$13>>2]|0;
 $15 = (($12) + 4)|0;
 $16 = $15;
 $17 = HEAP32[$16>>2]|0;
 $18 = $3;
 $19 = $18;
 $20 = HEAP32[$19>>2]|0;
 $21 = (($18) + 4)|0;
 $22 = $21;
 $23 = HEAP32[$22>>2]|0;
 $24 = ($17|0)>($23|0);
 $25 = ($14>>>0)>($20>>>0);
 $26 = ($17|0)==($23|0);
 $27 = $26 & $25;
 $28 = $24 | $27;
 if (!($28)) {
  $37 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 $29 = HEAP32[$2>>2]|0;
 $30 = $3;
 $31 = $30;
 $32 = HEAP32[$31>>2]|0;
 $33 = (($30) + 4)|0;
 $34 = $33;
 $35 = HEAP32[$34>>2]|0;
 $36 = (_sqlite3OsTruncate($29,$32,$35)|0);
 HEAP32[$rc>>2] = $36;
 $37 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($37|0);
}
function _sqlite3PagerSync($pPager,$zMaster) {
 $pPager = $pPager|0;
 $zMaster = $zMaster|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pArg = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $rc = sp + 4|0;
 $pArg = sp;
 HEAP32[$0>>2] = $pPager;
 HEAP32[$1>>2] = $zMaster;
 HEAP32[$rc>>2] = 0;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 64|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = HEAP32[$4>>2]|0;
 $6 = ($5|0)!=(0|0);
 if ($6) {
  $7 = HEAP32[$1>>2]|0;
  HEAP32[$pArg>>2] = $7;
  $8 = HEAP32[$0>>2]|0;
  $9 = ((($8)) + 64|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = HEAP32[$pArg>>2]|0;
  $12 = (_sqlite3OsFileControl($10,21,$11)|0);
  HEAP32[$rc>>2] = $12;
  $13 = HEAP32[$rc>>2]|0;
  $14 = ($13|0)==(12);
  $$ = $14 ? 0 : $12;
  HEAP32[$rc>>2] = $$;
 }
 $15 = HEAP32[$rc>>2]|0;
 $16 = ($15|0)==(0);
 if (!($16)) {
  $29 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($29|0);
 }
 $17 = HEAP32[$0>>2]|0;
 $18 = ((($17)) + 7|0);
 $19 = HEAP8[$18>>0]|0;
 $20 = ($19<<24>>24)!=(0);
 if ($20) {
  $29 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($29|0);
 }
 $21 = HEAP32[$0>>2]|0;
 $22 = ((($21)) + 64|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = HEAP32[$0>>2]|0;
 $25 = ((($24)) + 12|0);
 $26 = HEAP8[$25>>0]|0;
 $27 = $26&255;
 $28 = (_sqlite3OsSync($23,$27)|0);
 HEAP32[$rc>>2] = $28;
 $29 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($29|0);
}
function _sqlite3PagerTruncateImage($pPager,$nPage) {
 $pPager = $pPager|0;
 $nPage = $nPage|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pPager;
 HEAP32[$1>>2] = $nPage;
 $2 = HEAP32[$1>>2]|0;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 28|0);
 HEAP32[$4>>2] = $2;
 STACKTOP = sp;return;
}
function _sqlite3BtreeCommitPhaseTwo($p,$bCleanup) {
 $p = $p|0;
 $bCleanup = $bCleanup|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $pBt = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $rc = sp + 4|0;
 $pBt = sp;
 HEAP32[$1>>2] = $p;
 HEAP32[$2>>2] = $bCleanup;
 $3 = HEAP32[$1>>2]|0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP8[$4>>0]|0;
 $6 = $5&255;
 $7 = ($6|0)==(0);
 if ($7) {
  HEAP32[$0>>2] = 0;
  $33 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($33|0);
 }
 $8 = HEAP32[$1>>2]|0;
 _sqlite3BtreeEnter($8);
 $9 = HEAP32[$1>>2]|0;
 $10 = ((($9)) + 8|0);
 $11 = HEAP8[$10>>0]|0;
 $12 = $11&255;
 $13 = ($12|0)==(2);
 do {
  if ($13) {
   $14 = HEAP32[$1>>2]|0;
   $15 = ((($14)) + 4|0);
   $16 = HEAP32[$15>>2]|0;
   HEAP32[$pBt>>2] = $16;
   $17 = HEAP32[$pBt>>2]|0;
   $18 = HEAP32[$17>>2]|0;
   $19 = (_sqlite3PagerCommitPhaseTwo($18)|0);
   HEAP32[$rc>>2] = $19;
   $20 = HEAP32[$rc>>2]|0;
   $21 = ($20|0)!=(0);
   $22 = HEAP32[$2>>2]|0;
   $23 = ($22|0)==(0);
   $or$cond = $21 & $23;
   if (!($or$cond)) {
    $25 = HEAP32[$1>>2]|0;
    $26 = ((($25)) + 20|0);
    $27 = HEAP32[$26>>2]|0;
    $28 = (($27) + -1)|0;
    HEAP32[$26>>2] = $28;
    $29 = HEAP32[$pBt>>2]|0;
    $30 = ((($29)) + 20|0);
    HEAP8[$30>>0] = 1;
    $31 = HEAP32[$pBt>>2]|0;
    _btreeClearHasContent($31);
    break;
   }
   $24 = HEAP32[$rc>>2]|0;
   HEAP32[$0>>2] = $24;
   $33 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($33|0);
  }
 } while(0);
 $32 = HEAP32[$1>>2]|0;
 _btreeEndTransaction($32);
 HEAP32[$0>>2] = 0;
 $33 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($33|0);
}
function _sqlite3BtreeCommitPhaseOne($p,$zMaster) {
 $p = $p|0;
 $zMaster = $zMaster|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pBt = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $rc = sp + 4|0;
 $pBt = sp;
 HEAP32[$1>>2] = $p;
 HEAP32[$2>>2] = $zMaster;
 HEAP32[$rc>>2] = 0;
 $3 = HEAP32[$1>>2]|0;
 $4 = ((($3)) + 8|0);
 $5 = HEAP8[$4>>0]|0;
 $6 = $5&255;
 $7 = ($6|0)==(2);
 if ($7) {
  $8 = HEAP32[$1>>2]|0;
  $9 = ((($8)) + 4|0);
  $10 = HEAP32[$9>>2]|0;
  HEAP32[$pBt>>2] = $10;
  $11 = HEAP32[$1>>2]|0;
  _sqlite3BtreeEnter($11);
  $12 = HEAP32[$pBt>>2]|0;
  $13 = ((($12)) + 17|0);
  $14 = HEAP8[$13>>0]|0;
  $15 = ($14<<24>>24)!=(0);
  if ($15) {
   $16 = HEAP32[$pBt>>2]|0;
   $17 = (_autoVacuumCommit($16)|0);
   HEAP32[$rc>>2] = $17;
   $18 = HEAP32[$rc>>2]|0;
   $19 = ($18|0)!=(0);
   if ($19) {
    $20 = HEAP32[$rc>>2]|0;
    HEAP32[$0>>2] = $20;
    $35 = HEAP32[$0>>2]|0;
    STACKTOP = sp;return ($35|0);
   }
  }
  $21 = HEAP32[$pBt>>2]|0;
  $22 = ((($21)) + 19|0);
  $23 = HEAP8[$22>>0]|0;
  $24 = ($23<<24>>24)!=(0);
  if ($24) {
   $25 = HEAP32[$pBt>>2]|0;
   $26 = HEAP32[$25>>2]|0;
   $27 = HEAP32[$pBt>>2]|0;
   $28 = ((($27)) + 44|0);
   $29 = HEAP32[$28>>2]|0;
   _sqlite3PagerTruncateImage($26,$29);
  }
  $30 = HEAP32[$pBt>>2]|0;
  $31 = HEAP32[$30>>2]|0;
  $32 = HEAP32[$2>>2]|0;
  $33 = (_sqlite3PagerCommitPhaseOne($31,$32,0)|0);
  HEAP32[$rc>>2] = $33;
 }
 $34 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $34;
 $35 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($35|0);
}
function _sqlite3PagerBackupPtr($pPager) {
 $pPager = $pPager|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pPager;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 96|0);
 STACKTOP = sp;return ($2|0);
}
function _sqlite3BtreeRollback($p,$tripCode,$writeOnly) {
 $p = $p|0;
 $tripCode = $tripCode|0;
 $writeOnly = $writeOnly|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $nPage = 0, $pBt = 0, $pPage1 = 0, $rc = 0, $rc2 = 0, $rc21 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 32|0;
 $1 = sp + 28|0;
 $2 = sp + 24|0;
 $rc = sp + 20|0;
 $pBt = sp + 16|0;
 $pPage1 = sp + 12|0;
 $rc2 = sp + 8|0;
 $rc21 = sp + 4|0;
 $nPage = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $tripCode;
 HEAP32[$2>>2] = $writeOnly;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 HEAP32[$pBt>>2] = $5;
 $6 = HEAP32[$0>>2]|0;
 _sqlite3BtreeEnter($6);
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)==(0);
 if ($8) {
  $9 = HEAP32[$pBt>>2]|0;
  $10 = (_saveAllCursors($9,0,0)|0);
  HEAP32[$1>>2] = $10;
  HEAP32[$rc>>2] = $10;
  $11 = HEAP32[$rc>>2]|0;
  $12 = ($11|0)!=(0);
  if ($12) {
   HEAP32[$2>>2] = 0;
  }
 } else {
  HEAP32[$rc>>2] = 0;
 }
 $13 = HEAP32[$1>>2]|0;
 $14 = ($13|0)!=(0);
 if ($14) {
  $15 = HEAP32[$0>>2]|0;
  $16 = HEAP32[$1>>2]|0;
  $17 = HEAP32[$2>>2]|0;
  $18 = (_sqlite3BtreeTripAllCursors($15,$16,$17)|0);
  HEAP32[$rc2>>2] = $18;
  $19 = HEAP32[$rc2>>2]|0;
  $20 = ($19|0)!=(0);
  if ($20) {
   $21 = HEAP32[$rc2>>2]|0;
   HEAP32[$rc>>2] = $21;
  }
 }
 $22 = HEAP32[$0>>2]|0;
 $23 = ((($22)) + 8|0);
 $24 = HEAP8[$23>>0]|0;
 $25 = $24&255;
 $26 = ($25|0)==(2);
 if (!($26)) {
  $52 = HEAP32[$0>>2]|0;
  _btreeEndTransaction($52);
  $53 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($53|0);
 }
 $27 = HEAP32[$pBt>>2]|0;
 $28 = HEAP32[$27>>2]|0;
 $29 = (_sqlite3PagerRollback($28)|0);
 HEAP32[$rc21>>2] = $29;
 $30 = HEAP32[$rc21>>2]|0;
 $31 = ($30|0)!=(0);
 if ($31) {
  $32 = HEAP32[$rc21>>2]|0;
  HEAP32[$rc>>2] = $32;
 }
 $33 = HEAP32[$pBt>>2]|0;
 $34 = (_btreeGetPage($33,1,$pPage1,0)|0);
 $35 = ($34|0)==(0);
 if ($35) {
  $36 = HEAP32[$pPage1>>2]|0;
  $37 = ((($36)) + 56|0);
  $38 = HEAP32[$37>>2]|0;
  $39 = ((($38)) + 28|0);
  $40 = (_sqlite3Get4byte($39)|0);
  HEAP32[$nPage>>2] = $40;
  $41 = HEAP32[$nPage>>2]|0;
  $42 = ($41|0)==(0);
  if ($42) {
   $43 = HEAP32[$pBt>>2]|0;
   $44 = HEAP32[$43>>2]|0;
   _sqlite3PagerPagecount($44,$nPage);
  }
  $45 = HEAP32[$nPage>>2]|0;
  $46 = HEAP32[$pBt>>2]|0;
  $47 = ((($46)) + 44|0);
  HEAP32[$47>>2] = $45;
  $48 = HEAP32[$pPage1>>2]|0;
  _releasePage($48);
 }
 $49 = HEAP32[$pBt>>2]|0;
 $50 = ((($49)) + 20|0);
 HEAP8[$50>>0] = 1;
 $51 = HEAP32[$pBt>>2]|0;
 _btreeClearHasContent($51);
 $52 = HEAP32[$0>>2]|0;
 _btreeEndTransaction($52);
 $53 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($53|0);
}
function _sqlite3LeaveMutexAndCloseZombie($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0;
 var $i = 0, $j = 0, $p = 0, $pColl = 0, $pDb = 0, $pMod = 0, $pNext = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $i = sp + 24|0;
 $j = sp + 20|0;
 $pDb = sp + 16|0;
 $pNext = sp + 12|0;
 $p = sp + 8|0;
 $pColl = sp + 4|0;
 $pMod = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 84|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)!=(1691352191);
 if ($4) {
  STACKTOP = sp;return;
 }
 $5 = HEAP32[$0>>2]|0;
 $6 = (_connectionIsBusy($5)|0);
 $7 = ($6|0)!=(0);
 if ($7) {
  STACKTOP = sp;return;
 }
 $8 = HEAP32[$0>>2]|0;
 _sqlite3RollbackAll($8,0);
 $9 = HEAP32[$0>>2]|0;
 _sqlite3CloseSavepoints($9);
 HEAP32[$j>>2] = 0;
 while(1) {
  $10 = HEAP32[$j>>2]|0;
  $11 = HEAP32[$0>>2]|0;
  $12 = ((($11)) + 20|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = ($10|0)<($13|0);
  if (!($14)) {
   break;
  }
  $15 = HEAP32[$j>>2]|0;
  $16 = HEAP32[$0>>2]|0;
  $17 = ((($16)) + 16|0);
  $18 = HEAP32[$17>>2]|0;
  $19 = (($18) + ($15<<4)|0);
  HEAP32[$pDb>>2] = $19;
  $20 = HEAP32[$pDb>>2]|0;
  $21 = ((($20)) + 4|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = ($22|0)!=(0|0);
  if ($23) {
   $24 = HEAP32[$pDb>>2]|0;
   $25 = ((($24)) + 4|0);
   $26 = HEAP32[$25>>2]|0;
   (_sqlite3BtreeClose($26)|0);
   $27 = HEAP32[$pDb>>2]|0;
   $28 = ((($27)) + 4|0);
   HEAP32[$28>>2] = 0;
   $29 = HEAP32[$j>>2]|0;
   $30 = ($29|0)!=(1);
   if ($30) {
    $31 = HEAP32[$pDb>>2]|0;
    $32 = ((($31)) + 12|0);
    HEAP32[$32>>2] = 0;
   }
  }
  $33 = HEAP32[$j>>2]|0;
  $34 = (($33) + 1)|0;
  HEAP32[$j>>2] = $34;
 }
 $35 = HEAP32[$0>>2]|0;
 $36 = ((($35)) + 16|0);
 $37 = HEAP32[$36>>2]|0;
 $38 = ((($37)) + 16|0);
 $39 = ((($38)) + 12|0);
 $40 = HEAP32[$39>>2]|0;
 $41 = ($40|0)!=(0|0);
 if ($41) {
  $42 = HEAP32[$0>>2]|0;
  $43 = ((($42)) + 16|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ((($44)) + 16|0);
  $46 = ((($45)) + 12|0);
  $47 = HEAP32[$46>>2]|0;
  _sqlite3SchemaClear($47);
 }
 $48 = HEAP32[$0>>2]|0;
 _sqlite3VtabUnlockList($48);
 $49 = HEAP32[$0>>2]|0;
 _sqlite3CollapseDatabaseArray($49);
 $50 = HEAP32[$0>>2]|0;
 $51 = ((($50)) + 348|0);
 $52 = ((($51)) + 8|0);
 $53 = HEAP32[$52>>2]|0;
 HEAP32[$i>>2] = $53;
 while(1) {
  $54 = HEAP32[$i>>2]|0;
  $55 = ($54|0)!=(0|0);
  if (!($55)) {
   break;
  }
  $56 = HEAP32[$i>>2]|0;
  $57 = ((($56)) + 8|0);
  $58 = HEAP32[$57>>2]|0;
  HEAP32[$p>>2] = $58;
  while(1) {
   $59 = HEAP32[$0>>2]|0;
   $60 = HEAP32[$p>>2]|0;
   _functionDestroy($59,$60);
   $61 = HEAP32[$p>>2]|0;
   $62 = ((($61)) + 8|0);
   $63 = HEAP32[$62>>2]|0;
   HEAP32[$pNext>>2] = $63;
   $64 = HEAP32[$0>>2]|0;
   $65 = HEAP32[$p>>2]|0;
   _sqlite3DbFree($64,$65);
   $66 = HEAP32[$pNext>>2]|0;
   HEAP32[$p>>2] = $66;
   $67 = HEAP32[$p>>2]|0;
   $68 = ($67|0)!=(0|0);
   if (!($68)) {
    break;
   }
  }
  $69 = HEAP32[$i>>2]|0;
  $70 = HEAP32[$69>>2]|0;
  HEAP32[$i>>2] = $70;
 }
 $71 = HEAP32[$0>>2]|0;
 $72 = ((($71)) + 348|0);
 _sqlite3HashClear($72);
 $73 = HEAP32[$0>>2]|0;
 $74 = ((($73)) + 364|0);
 $75 = ((($74)) + 8|0);
 $76 = HEAP32[$75>>2]|0;
 HEAP32[$i>>2] = $76;
 while(1) {
  $77 = HEAP32[$i>>2]|0;
  $78 = ($77|0)!=(0|0);
  if (!($78)) {
   break;
  }
  $79 = HEAP32[$i>>2]|0;
  $80 = ((($79)) + 8|0);
  $81 = HEAP32[$80>>2]|0;
  HEAP32[$pColl>>2] = $81;
  HEAP32[$j>>2] = 0;
  while(1) {
   $82 = HEAP32[$j>>2]|0;
   $83 = ($82|0)<(3);
   if (!($83)) {
    break;
   }
   $84 = HEAP32[$j>>2]|0;
   $85 = HEAP32[$pColl>>2]|0;
   $86 = (($85) + (($84*20)|0)|0);
   $87 = ((($86)) + 16|0);
   $88 = HEAP32[$87>>2]|0;
   $89 = ($88|0)!=(0|0);
   if ($89) {
    $90 = HEAP32[$j>>2]|0;
    $91 = HEAP32[$pColl>>2]|0;
    $92 = (($91) + (($90*20)|0)|0);
    $93 = ((($92)) + 16|0);
    $94 = HEAP32[$93>>2]|0;
    $95 = HEAP32[$j>>2]|0;
    $96 = HEAP32[$pColl>>2]|0;
    $97 = (($96) + (($95*20)|0)|0);
    $98 = ((($97)) + 8|0);
    $99 = HEAP32[$98>>2]|0;
    FUNCTION_TABLE_vi[$94 & 255]($99);
   }
   $100 = HEAP32[$j>>2]|0;
   $101 = (($100) + 1)|0;
   HEAP32[$j>>2] = $101;
  }
  $102 = HEAP32[$0>>2]|0;
  $103 = HEAP32[$pColl>>2]|0;
  _sqlite3DbFree($102,$103);
  $104 = HEAP32[$i>>2]|0;
  $105 = HEAP32[$104>>2]|0;
  HEAP32[$i>>2] = $105;
 }
 $106 = HEAP32[$0>>2]|0;
 $107 = ((($106)) + 364|0);
 _sqlite3HashClear($107);
 $108 = HEAP32[$0>>2]|0;
 $109 = ((($108)) + 320|0);
 $110 = ((($109)) + 8|0);
 $111 = HEAP32[$110>>2]|0;
 HEAP32[$i>>2] = $111;
 while(1) {
  $112 = HEAP32[$i>>2]|0;
  $113 = ($112|0)!=(0|0);
  if (!($113)) {
   break;
  }
  $114 = HEAP32[$i>>2]|0;
  $115 = ((($114)) + 8|0);
  $116 = HEAP32[$115>>2]|0;
  HEAP32[$pMod>>2] = $116;
  $117 = HEAP32[$pMod>>2]|0;
  $118 = ((($117)) + 12|0);
  $119 = HEAP32[$118>>2]|0;
  $120 = ($119|0)!=(0|0);
  if ($120) {
   $121 = HEAP32[$pMod>>2]|0;
   $122 = ((($121)) + 12|0);
   $123 = HEAP32[$122>>2]|0;
   $124 = HEAP32[$pMod>>2]|0;
   $125 = ((($124)) + 8|0);
   $126 = HEAP32[$125>>2]|0;
   FUNCTION_TABLE_vi[$123 & 255]($126);
  }
  $127 = HEAP32[$0>>2]|0;
  $128 = HEAP32[$pMod>>2]|0;
  _sqlite3VtabEponymousTableClear($127,$128);
  $129 = HEAP32[$0>>2]|0;
  $130 = HEAP32[$pMod>>2]|0;
  _sqlite3DbFree($129,$130);
  $131 = HEAP32[$i>>2]|0;
  $132 = HEAP32[$131>>2]|0;
  HEAP32[$i>>2] = $132;
 }
 $133 = HEAP32[$0>>2]|0;
 $134 = ((($133)) + 320|0);
 _sqlite3HashClear($134);
 $135 = HEAP32[$0>>2]|0;
 _sqlite3Error($135,0);
 $136 = HEAP32[$0>>2]|0;
 $137 = ((($136)) + 244|0);
 $138 = HEAP32[$137>>2]|0;
 _sqlite3ValueFree($138);
 $139 = HEAP32[$0>>2]|0;
 $140 = ((($139)) + 84|0);
 HEAP32[$140>>2] = -1254786768;
 $141 = HEAP32[$0>>2]|0;
 $142 = HEAP32[$0>>2]|0;
 $143 = ((($142)) + 16|0);
 $144 = HEAP32[$143>>2]|0;
 $145 = ((($144)) + 16|0);
 $146 = ((($145)) + 12|0);
 $147 = HEAP32[$146>>2]|0;
 _sqlite3DbFree($141,$147);
 $148 = HEAP32[$0>>2]|0;
 $149 = ((($148)) + 84|0);
 HEAP32[$149>>2] = -1623446221;
 $150 = HEAP32[$0>>2]|0;
 $151 = ((($150)) + 256|0);
 $152 = ((($151)) + 6|0);
 $153 = HEAP8[$152>>0]|0;
 $154 = ($153<<24>>24)!=(0);
 if ($154) {
  $155 = HEAP32[$0>>2]|0;
  $156 = ((($155)) + 256|0);
  $157 = ((($156)) + 32|0);
  $158 = HEAP32[$157>>2]|0;
  _sqlite3_free($158);
 }
 $159 = HEAP32[$0>>2]|0;
 _sqlite3_free($159);
 STACKTOP = sp;return;
}
function _vdbeSafety($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $vararg_buffer = sp;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$1>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0|0);
 if ($4) {
  _sqlite3_log(21,44004,$vararg_buffer);
  HEAP32[$0>>2] = 1;
  $5 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($5|0);
 } else {
  HEAP32[$0>>2] = 0;
  $5 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($5|0);
 }
 return (0)|0;
}
function _invokeProfileCallback($db,$p) {
 $db = $db|0;
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $7 = 0, $8 = 0, $9 = 0, $iElapse = 0, $iNow = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $iNow = sp + 8|0;
 $iElapse = sp;
 HEAP32[$0>>2] = $db;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 (_sqlite3OsCurrentTimeInt64($3,$iNow)|0);
 $4 = $iNow;
 $5 = $4;
 $6 = HEAP32[$5>>2]|0;
 $7 = (($4) + 4)|0;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = HEAP32[$1>>2]|0;
 $11 = ((($10)) + 128|0);
 $12 = $11;
 $13 = $12;
 $14 = HEAP32[$13>>2]|0;
 $15 = (($12) + 4)|0;
 $16 = $15;
 $17 = HEAP32[$16>>2]|0;
 $18 = (_i64Subtract(($6|0),($9|0),($14|0),($17|0))|0);
 $19 = tempRet0;
 $20 = (___muldi3(($18|0),($19|0),1000000,0)|0);
 $21 = tempRet0;
 $22 = $iElapse;
 $23 = $22;
 HEAP32[$23>>2] = $20;
 $24 = (($22) + 4)|0;
 $25 = $24;
 HEAP32[$25>>2] = $21;
 $26 = HEAP32[$0>>2]|0;
 $27 = ((($26)) + 192|0);
 $28 = HEAP32[$27>>2]|0;
 $29 = ($28|0)!=(0|0);
 if ($29) {
  $30 = HEAP32[$0>>2]|0;
  $31 = ((($30)) + 192|0);
  $32 = HEAP32[$31>>2]|0;
  $33 = HEAP32[$0>>2]|0;
  $34 = ((($33)) + 196|0);
  $35 = HEAP32[$34>>2]|0;
  $36 = HEAP32[$1>>2]|0;
  $37 = ((($36)) + 176|0);
  $38 = HEAP32[$37>>2]|0;
  $39 = $iElapse;
  $40 = $39;
  $41 = HEAP32[$40>>2]|0;
  $42 = (($39) + 4)|0;
  $43 = $42;
  $44 = HEAP32[$43>>2]|0;
  FUNCTION_TABLE_viiii[$32 & 255]($35,$38,$41,$44);
 }
 $45 = HEAP32[$0>>2]|0;
 $46 = ((($45)) + 76|0);
 $47 = HEAP8[$46>>0]|0;
 $48 = $47&255;
 $49 = $48 & 2;
 $50 = ($49|0)!=(0);
 if (!($50)) {
  $58 = HEAP32[$1>>2]|0;
  $59 = ((($58)) + 128|0);
  $60 = $59;
  $61 = $60;
  HEAP32[$61>>2] = 0;
  $62 = (($60) + 4)|0;
  $63 = $62;
  HEAP32[$63>>2] = 0;
  STACKTOP = sp;return;
 }
 $51 = HEAP32[$0>>2]|0;
 $52 = ((($51)) + 184|0);
 $53 = HEAP32[$52>>2]|0;
 $54 = HEAP32[$0>>2]|0;
 $55 = ((($54)) + 188|0);
 $56 = HEAP32[$55>>2]|0;
 $57 = HEAP32[$1>>2]|0;
 (FUNCTION_TABLE_iiiii[$53 & 255](2,$56,$57,$iElapse)|0);
 $58 = HEAP32[$1>>2]|0;
 $59 = ((($58)) + 128|0);
 $60 = $59;
 $61 = $60;
 HEAP32[$61>>2] = 0;
 $62 = (($60) + 4)|0;
 $63 = $62;
 HEAP32[$63>>2] = 0;
 STACKTOP = sp;return;
}
function _sqlite3VdbeFinalize($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$rc>>2] = 0;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 20|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(770837923);
 if ($4) {
  label = 3;
 } else {
  $5 = HEAP32[$0>>2]|0;
  $6 = ((($5)) + 20|0);
  $7 = HEAP32[$6>>2]|0;
  $8 = ($7|0)==(832317811);
  if ($8) {
   label = 3;
  }
 }
 if ((label|0) == 3) {
  $9 = HEAP32[$0>>2]|0;
  $10 = (_sqlite3VdbeReset($9)|0);
  HEAP32[$rc>>2] = $10;
 }
 $11 = HEAP32[$0>>2]|0;
 _sqlite3VdbeDelete($11);
 $12 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($12|0);
}
function _sqlite3ApiExit($db,$rc) {
 $db = $db|0;
 $rc = $rc|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$1>>2] = $db;
 HEAP32[$2>>2] = $rc;
 $3 = HEAP32[$1>>2]|0;
 $4 = ((($3)) + 69|0);
 $5 = HEAP8[$4>>0]|0;
 $6 = $5&255;
 $7 = ($6|0)!=(0);
 $8 = HEAP32[$2>>2]|0;
 $9 = ($8|0)==(3082);
 $or$cond = $7 | $9;
 if ($or$cond) {
  $10 = HEAP32[$1>>2]|0;
  $11 = (_apiOomError($10)|0);
  HEAP32[$0>>2] = $11;
  $17 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($17|0);
 } else {
  $12 = HEAP32[$2>>2]|0;
  $13 = HEAP32[$1>>2]|0;
  $14 = ((($13)) + 56|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = $12 & $15;
  HEAP32[$0>>2] = $16;
  $17 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($17|0);
 }
 return (0)|0;
}
function _sqlite3VdbeReset($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $8 = 0, $9 = 0, $db = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $vararg_buffer = sp;
 $0 = sp + 8|0;
 $db = sp + 4|0;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$1>>2]|0;
 HEAP32[$db>>2] = $2;
 $3 = HEAP32[$0>>2]|0;
 (_sqlite3VdbeHalt($3)|0);
 $4 = HEAP32[$0>>2]|0;
 $5 = ((($4)) + 36|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ($6|0)>=(0);
 $8 = HEAP32[$0>>2]|0;
 if ($7) {
  (_sqlite3VdbeTransferError($8)|0);
  $9 = HEAP32[$db>>2]|0;
  $10 = HEAP32[$0>>2]|0;
  $11 = ((($10)) + 108|0);
  $12 = HEAP32[$11>>2]|0;
  _sqlite3DbFree($9,$12);
  $13 = HEAP32[$0>>2]|0;
  $14 = ((($13)) + 108|0);
  HEAP32[$14>>2] = 0;
  $15 = HEAP32[$0>>2]|0;
  $16 = ((($15)) + 144|0);
  $17 = HEAP16[$16>>1]|0;
  $18 = ($17&65535) >>> 5;
  $19 = $18 & 1;
  $20 = $19&65535;
  $21 = ($20|0)!=(0);
  if ($21) {
   $22 = HEAP32[$0>>2]|0;
   $23 = ((($22)) + 144|0);
   $24 = HEAP16[$23>>1]|0;
   $25 = $24 & -2;
   $26 = $25 | 1;
   HEAP16[$23>>1] = $26;
  }
 } else {
  $27 = ((($8)) + 40|0);
  $28 = HEAP32[$27>>2]|0;
  $29 = ($28|0)!=(0);
  if ($29) {
   $30 = HEAP32[$0>>2]|0;
   $31 = ((($30)) + 144|0);
   $32 = HEAP16[$31>>1]|0;
   $33 = $32 & 1;
   $34 = $33&65535;
   $35 = ($34|0)!=(0);
   if ($35) {
    $36 = HEAP32[$db>>2]|0;
    $37 = HEAP32[$0>>2]|0;
    $38 = ((($37)) + 40|0);
    $39 = HEAP32[$38>>2]|0;
    $40 = HEAP32[$0>>2]|0;
    $41 = ((($40)) + 108|0);
    $42 = HEAP32[$41>>2]|0;
    $43 = ($42|0)!=(0|0);
    $44 = $43 ? 18391 : 0;
    $45 = HEAP32[$0>>2]|0;
    $46 = ((($45)) + 108|0);
    $47 = HEAP32[$46>>2]|0;
    HEAP32[$vararg_buffer>>2] = $47;
    _sqlite3ErrorWithMsg($36,$39,$44,$vararg_buffer);
    $48 = HEAP32[$db>>2]|0;
    $49 = HEAP32[$0>>2]|0;
    $50 = ((($49)) + 108|0);
    $51 = HEAP32[$50>>2]|0;
    _sqlite3DbFree($48,$51);
    $52 = HEAP32[$0>>2]|0;
    $53 = ((($52)) + 108|0);
    HEAP32[$53>>2] = 0;
   }
  }
 }
 $54 = HEAP32[$0>>2]|0;
 _Cleanup($54);
 $55 = HEAP32[$0>>2]|0;
 $56 = ((($55)) + 56|0);
 $57 = $56;
 $58 = $57;
 HEAP32[$58>>2] = 0;
 $59 = (($57) + 4)|0;
 $60 = $59;
 HEAP32[$60>>2] = 0;
 $61 = HEAP32[$0>>2]|0;
 $62 = ((($61)) + 20|0);
 HEAP32[$62>>2] = 1224384374;
 $63 = HEAP32[$0>>2]|0;
 $64 = ((($63)) + 40|0);
 $65 = HEAP32[$64>>2]|0;
 $66 = HEAP32[$db>>2]|0;
 $67 = ((($66)) + 56|0);
 $68 = HEAP32[$67>>2]|0;
 $69 = $65 & $68;
 STACKTOP = sp;return ($69|0);
}
function _sqlite3VdbeRewind($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 20|0);
 HEAP32[$2>>2] = 770837923;
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 36|0);
 HEAP32[$4>>2] = -1;
 $5 = HEAP32[$0>>2]|0;
 $6 = ((($5)) + 40|0);
 HEAP32[$6>>2] = 0;
 $7 = HEAP32[$0>>2]|0;
 $8 = ((($7)) + 142|0);
 HEAP8[$8>>0] = 2;
 $9 = HEAP32[$0>>2]|0;
 $10 = ((($9)) + 44|0);
 HEAP32[$10>>2] = 0;
 $11 = HEAP32[$0>>2]|0;
 $12 = ((($11)) + 32|0);
 HEAP32[$12>>2] = 1;
 $13 = HEAP32[$0>>2]|0;
 $14 = ((($13)) + 143|0);
 HEAP8[$14>>0] = -1;
 $15 = HEAP32[$0>>2]|0;
 $16 = ((($15)) + 48|0);
 HEAP32[$16>>2] = 0;
 $17 = HEAP32[$0>>2]|0;
 $18 = ((($17)) + 64|0);
 $19 = $18;
 $20 = $19;
 HEAP32[$20>>2] = 0;
 $21 = (($19) + 4)|0;
 $22 = $21;
 HEAP32[$22>>2] = 0;
 STACKTOP = sp;return;
}
function _sqlite3VdbeMemRelease($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $p;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 8|0);
 $3 = HEAP16[$2>>1]|0;
 $4 = $3&65535;
 $5 = $4 & 9312;
 $6 = ($5|0)!=(0);
 if (!($6)) {
  $7 = HEAP32[$0>>2]|0;
  $8 = ((($7)) + 24|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = ($9|0)!=(0);
  if (!($10)) {
   STACKTOP = sp;return;
  }
 }
 $11 = HEAP32[$0>>2]|0;
 _vdbeMemClear($11);
 STACKTOP = sp;return;
}
function _sqlite3VdbeMemExpandBlob($pMem) {
 $pMem = $pMem|0;
 var $$ = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $nByte = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $nByte = sp;
 HEAP32[$1>>2] = $pMem;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 12|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = HEAP32[$1>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = (($4) + ($6))|0;
 HEAP32[$nByte>>2] = $7;
 $8 = HEAP32[$nByte>>2]|0;
 $9 = ($8|0)<=(0);
 $$ = $9 ? 1 : $7;
 HEAP32[$nByte>>2] = $$;
 $10 = HEAP32[$1>>2]|0;
 $11 = HEAP32[$nByte>>2]|0;
 $12 = (_sqlite3VdbeMemGrow($10,$11,1)|0);
 $13 = ($12|0)!=(0);
 if ($13) {
  HEAP32[$0>>2] = 7;
  $35 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($35|0);
 } else {
  $14 = HEAP32[$1>>2]|0;
  $15 = ((($14)) + 12|0);
  $16 = HEAP32[$15>>2]|0;
  $17 = HEAP32[$1>>2]|0;
  $18 = ((($17)) + 16|0);
  $19 = HEAP32[$18>>2]|0;
  $20 = (($19) + ($16)|0);
  $21 = HEAP32[$1>>2]|0;
  $22 = HEAP32[$21>>2]|0;
  _memset(($20|0),0,($22|0))|0;
  $23 = HEAP32[$1>>2]|0;
  $24 = HEAP32[$23>>2]|0;
  $25 = HEAP32[$1>>2]|0;
  $26 = ((($25)) + 12|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = (($27) + ($24))|0;
  HEAP32[$26>>2] = $28;
  $29 = HEAP32[$1>>2]|0;
  $30 = ((($29)) + 8|0);
  $31 = HEAP16[$30>>1]|0;
  $32 = $31&65535;
  $33 = $32 & -16897;
  $34 = $33&65535;
  HEAP16[$30>>1] = $34;
  HEAP32[$0>>2] = 0;
  $35 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($35|0);
 }
 return (0)|0;
}
function _sqlite3ValueText($pVal,$enc) {
 $pVal = $pVal|0;
 $enc = $enc|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 $2 = sp + 8|0;
 HEAP32[$1>>2] = $pVal;
 HEAP8[$2>>0] = $enc;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)!=(0|0);
 do {
  if ($4) {
   $5 = HEAP32[$1>>2]|0;
   $6 = ((($5)) + 8|0);
   $7 = HEAP16[$6>>1]|0;
   $8 = $7&65535;
   $9 = $8 & 514;
   $10 = ($9|0)==(514);
   if ($10) {
    $11 = HEAP32[$1>>2]|0;
    $12 = ((($11)) + 10|0);
    $13 = HEAP8[$12>>0]|0;
    $14 = $13&255;
    $15 = HEAP8[$2>>0]|0;
    $16 = $15&255;
    $17 = ($14|0)==($16|0);
    if ($17) {
     $18 = HEAP32[$1>>2]|0;
     $19 = ((($18)) + 16|0);
     $20 = HEAP32[$19>>2]|0;
     HEAP32[$0>>2] = $20;
     break;
    }
   }
   $21 = HEAP32[$1>>2]|0;
   $22 = ((($21)) + 8|0);
   $23 = HEAP16[$22>>1]|0;
   $24 = $23&65535;
   $25 = $24 & 1;
   $26 = ($25|0)!=(0);
   if ($26) {
    HEAP32[$0>>2] = 0;
    break;
   } else {
    $27 = HEAP32[$1>>2]|0;
    $28 = HEAP8[$2>>0]|0;
    $29 = (_valueToText($27,$28)|0);
    HEAP32[$0>>2] = $29;
    break;
   }
  } else {
   HEAP32[$0>>2] = 0;
  }
 } while(0);
 $30 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($30|0);
}
function _sqlite3ValueBytes($pVal,$enc) {
 $pVal = $pVal|0;
 $enc = $enc|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp + 12|0;
 $p = sp;
 HEAP32[$1>>2] = $pVal;
 HEAP8[$2>>0] = $enc;
 $3 = HEAP32[$1>>2]|0;
 HEAP32[$p>>2] = $3;
 $4 = HEAP32[$p>>2]|0;
 $5 = ((($4)) + 8|0);
 $6 = HEAP16[$5>>1]|0;
 $7 = $6&65535;
 $8 = $7 & 2;
 $9 = ($8|0)!=(0);
 if ($9) {
  $10 = HEAP32[$1>>2]|0;
  $11 = ((($10)) + 10|0);
  $12 = HEAP8[$11>>0]|0;
  $13 = $12&255;
  $14 = HEAP8[$2>>0]|0;
  $15 = $14&255;
  $16 = ($13|0)==($15|0);
  if ($16) {
   $17 = HEAP32[$p>>2]|0;
   $18 = ((($17)) + 12|0);
   $19 = HEAP32[$18>>2]|0;
   HEAP32[$0>>2] = $19;
   $43 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($43|0);
  }
 }
 $20 = HEAP32[$p>>2]|0;
 $21 = ((($20)) + 8|0);
 $22 = HEAP16[$21>>1]|0;
 $23 = $22&65535;
 $24 = $23 & 16;
 $25 = ($24|0)!=(0);
 $26 = HEAP32[$p>>2]|0;
 $27 = ((($26)) + 8|0);
 $28 = HEAP16[$27>>1]|0;
 $29 = $28&65535;
 if ($25) {
  $30 = $29 & 16384;
  $31 = ($30|0)!=(0);
  $32 = HEAP32[$p>>2]|0;
  $33 = ((($32)) + 12|0);
  $34 = HEAP32[$33>>2]|0;
  if ($31) {
   $35 = HEAP32[$p>>2]|0;
   $36 = HEAP32[$35>>2]|0;
   $37 = (($34) + ($36))|0;
   HEAP32[$0>>2] = $37;
   $43 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($43|0);
  } else {
   HEAP32[$0>>2] = $34;
   $43 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($43|0);
  }
 } else {
  $38 = $29 & 1;
  $39 = ($38|0)!=(0);
  if ($39) {
   HEAP32[$0>>2] = 0;
   $43 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($43|0);
  } else {
   $40 = HEAP32[$1>>2]|0;
   $41 = HEAP8[$2>>0]|0;
   $42 = (_valueBytes($40,$41)|0);
   HEAP32[$0>>2] = $42;
   $43 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($43|0);
  }
 }
 return (0)|0;
}
function _sqlite3VdbeRealValue($pMem) {
 $pMem = $pMem|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0.0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0.0, $38 = 0.0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0.0, $val = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 8|0;
 $1 = sp + 16|0;
 $val = sp;
 HEAP32[$1>>2] = $pMem;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 8|0);
 $4 = HEAP16[$3>>1]|0;
 $5 = $4&65535;
 $6 = $5 & 8;
 $7 = ($6|0)!=(0);
 $8 = HEAP32[$1>>2]|0;
 if ($7) {
  $9 = +HEAPF64[$8>>3];
  HEAPF64[$0>>3] = $9;
  $38 = +HEAPF64[$0>>3];
  STACKTOP = sp;return (+$38);
 }
 $10 = ((($8)) + 8|0);
 $11 = HEAP16[$10>>1]|0;
 $12 = $11&65535;
 $13 = $12 & 4;
 $14 = ($13|0)!=(0);
 $15 = HEAP32[$1>>2]|0;
 if ($14) {
  $16 = $15;
  $17 = $16;
  $18 = HEAP32[$17>>2]|0;
  $19 = (($16) + 4)|0;
  $20 = $19;
  $21 = HEAP32[$20>>2]|0;
  $22 = (+($18>>>0)) + (4294967296.0*(+($21|0)));
  HEAPF64[$0>>3] = $22;
  $38 = +HEAPF64[$0>>3];
  STACKTOP = sp;return (+$38);
 }
 $23 = ((($15)) + 8|0);
 $24 = HEAP16[$23>>1]|0;
 $25 = $24&65535;
 $26 = $25 & 18;
 $27 = ($26|0)!=(0);
 if ($27) {
  HEAPF64[$val>>3] = 0.0;
  $28 = HEAP32[$1>>2]|0;
  $29 = ((($28)) + 16|0);
  $30 = HEAP32[$29>>2]|0;
  $31 = HEAP32[$1>>2]|0;
  $32 = ((($31)) + 12|0);
  $33 = HEAP32[$32>>2]|0;
  $34 = HEAP32[$1>>2]|0;
  $35 = ((($34)) + 10|0);
  $36 = HEAP8[$35>>0]|0;
  (_sqlite3AtoF($30,$val,$33,$36)|0);
  $37 = +HEAPF64[$val>>3];
  HEAPF64[$0>>3] = $37;
  $38 = +HEAPF64[$0>>3];
  STACKTOP = sp;return (+$38);
 } else {
  HEAPF64[$0>>3] = 0.0;
  $38 = +HEAPF64[$0>>3];
  STACKTOP = sp;return (+$38);
 }
 return +(0.0);
}
function _sqlite3VdbeIntValue($pMem) {
 $pMem = $pMem|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0.0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $7 = 0, $8 = 0, $9 = 0, $flags = 0, $value = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 8|0;
 $1 = sp + 20|0;
 $flags = sp + 16|0;
 $value = sp;
 HEAP32[$1>>2] = $pMem;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 8|0);
 $4 = HEAP16[$3>>1]|0;
 $5 = $4&65535;
 HEAP32[$flags>>2] = $5;
 $6 = HEAP32[$flags>>2]|0;
 $7 = $6 & 4;
 $8 = ($7|0)!=(0);
 do {
  if ($8) {
   $9 = HEAP32[$1>>2]|0;
   $10 = $9;
   $11 = $10;
   $12 = HEAP32[$11>>2]|0;
   $13 = (($10) + 4)|0;
   $14 = $13;
   $15 = HEAP32[$14>>2]|0;
   $16 = $0;
   $17 = $16;
   HEAP32[$17>>2] = $12;
   $18 = (($16) + 4)|0;
   $19 = $18;
   HEAP32[$19>>2] = $15;
  } else {
   $20 = HEAP32[$flags>>2]|0;
   $21 = $20 & 8;
   $22 = ($21|0)!=(0);
   if ($22) {
    $23 = HEAP32[$1>>2]|0;
    $24 = +HEAPF64[$23>>3];
    $25 = (_doubleToInt64($24)|0);
    $26 = tempRet0;
    $27 = $0;
    $28 = $27;
    HEAP32[$28>>2] = $25;
    $29 = (($27) + 4)|0;
    $30 = $29;
    HEAP32[$30>>2] = $26;
    break;
   }
   $31 = HEAP32[$flags>>2]|0;
   $32 = $31 & 18;
   $33 = ($32|0)!=(0);
   if ($33) {
    $34 = $value;
    $35 = $34;
    HEAP32[$35>>2] = 0;
    $36 = (($34) + 4)|0;
    $37 = $36;
    HEAP32[$37>>2] = 0;
    $38 = HEAP32[$1>>2]|0;
    $39 = ((($38)) + 16|0);
    $40 = HEAP32[$39>>2]|0;
    $41 = HEAP32[$1>>2]|0;
    $42 = ((($41)) + 12|0);
    $43 = HEAP32[$42>>2]|0;
    $44 = HEAP32[$1>>2]|0;
    $45 = ((($44)) + 10|0);
    $46 = HEAP8[$45>>0]|0;
    (_sqlite3Atoi64($40,$value,$43,$46)|0);
    $47 = $value;
    $48 = $47;
    $49 = HEAP32[$48>>2]|0;
    $50 = (($47) + 4)|0;
    $51 = $50;
    $52 = HEAP32[$51>>2]|0;
    $53 = $0;
    $54 = $53;
    HEAP32[$54>>2] = $49;
    $55 = (($53) + 4)|0;
    $56 = $55;
    HEAP32[$56>>2] = $52;
    break;
   } else {
    $57 = $0;
    $58 = $57;
    HEAP32[$58>>2] = 0;
    $59 = (($57) + 4)|0;
    $60 = $59;
    HEAP32[$60>>2] = 0;
    break;
   }
  }
 } while(0);
 $61 = $0;
 $62 = $61;
 $63 = HEAP32[$62>>2]|0;
 $64 = (($61) + 4)|0;
 $65 = $64;
 $66 = HEAP32[$65>>2]|0;
 tempRet0 = ($66);
 STACKTOP = sp;return ($63|0);
}
function _sqlite3VdbeMemMakeWriteable($pMem) {
 $pMem = $pMem|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$1>>2] = $pMem;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 8|0);
 $4 = HEAP16[$3>>1]|0;
 $5 = $4&65535;
 $6 = $5 & 18;
 $7 = ($6|0)!=(0);
 do {
  if ($7) {
   $8 = HEAP32[$1>>2]|0;
   $9 = ((($8)) + 8|0);
   $10 = HEAP16[$9>>1]|0;
   $11 = $10&65535;
   $12 = $11 & 16384;
   $13 = ($12|0)!=(0);
   if ($13) {
    $14 = HEAP32[$1>>2]|0;
    $15 = (_sqlite3VdbeMemExpandBlob($14)|0);
    $16 = ($15|0)!=(0);
    if ($16) {
     HEAP32[$0>>2] = 7;
     $62 = HEAP32[$0>>2]|0;
     STACKTOP = sp;return ($62|0);
    }
   }
   $17 = HEAP32[$1>>2]|0;
   $18 = ((($17)) + 24|0);
   $19 = HEAP32[$18>>2]|0;
   $20 = ($19|0)==(0);
   if (!($20)) {
    $21 = HEAP32[$1>>2]|0;
    $22 = ((($21)) + 16|0);
    $23 = HEAP32[$22>>2]|0;
    $24 = HEAP32[$1>>2]|0;
    $25 = ((($24)) + 20|0);
    $26 = HEAP32[$25>>2]|0;
    $27 = ($23|0)!=($26|0);
    if (!($27)) {
     break;
    }
   }
   $28 = HEAP32[$1>>2]|0;
   $29 = HEAP32[$1>>2]|0;
   $30 = ((($29)) + 12|0);
   $31 = HEAP32[$30>>2]|0;
   $32 = (($31) + 2)|0;
   $33 = (_sqlite3VdbeMemGrow($28,$32,1)|0);
   $34 = ($33|0)!=(0);
   if (!($34)) {
    $35 = HEAP32[$1>>2]|0;
    $36 = ((($35)) + 12|0);
    $37 = HEAP32[$36>>2]|0;
    $38 = HEAP32[$1>>2]|0;
    $39 = ((($38)) + 16|0);
    $40 = HEAP32[$39>>2]|0;
    $41 = (($40) + ($37)|0);
    HEAP8[$41>>0] = 0;
    $42 = HEAP32[$1>>2]|0;
    $43 = ((($42)) + 12|0);
    $44 = HEAP32[$43>>2]|0;
    $45 = (($44) + 1)|0;
    $46 = HEAP32[$1>>2]|0;
    $47 = ((($46)) + 16|0);
    $48 = HEAP32[$47>>2]|0;
    $49 = (($48) + ($45)|0);
    HEAP8[$49>>0] = 0;
    $50 = HEAP32[$1>>2]|0;
    $51 = ((($50)) + 8|0);
    $52 = HEAP16[$51>>1]|0;
    $53 = $52&65535;
    $54 = $53 | 512;
    $55 = $54&65535;
    HEAP16[$51>>1] = $55;
    break;
   }
   HEAP32[$0>>2] = 7;
   $62 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($62|0);
  }
 } while(0);
 $56 = HEAP32[$1>>2]|0;
 $57 = ((($56)) + 8|0);
 $58 = HEAP16[$57>>1]|0;
 $59 = $58&65535;
 $60 = $59 & -4097;
 $61 = $60&65535;
 HEAP16[$57>>1] = $61;
 HEAP32[$0>>2] = 0;
 $62 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($62|0);
}
function _sqlite3ValueFree($v) {
 $v = $v|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $v;
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)!=(0|0);
 if (!($2)) {
  STACKTOP = sp;return;
 }
 $3 = HEAP32[$0>>2]|0;
 _sqlite3VdbeMemRelease($3);
 $4 = HEAP32[$0>>2]|0;
 $5 = ((($4)) + 32|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = HEAP32[$0>>2]|0;
 _sqlite3DbFree($6,$7);
 STACKTOP = sp;return;
}
function _setResultStrOrError($pCtx,$z,$n,$enc,$xDel) {
 $pCtx = $pCtx|0;
 $z = $z|0;
 $n = $n|0;
 $enc = $enc|0;
 $xDel = $xDel|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $2 = sp + 4|0;
 $3 = sp + 16|0;
 $4 = sp;
 HEAP32[$0>>2] = $pCtx;
 HEAP32[$1>>2] = $z;
 HEAP32[$2>>2] = $n;
 HEAP8[$3>>0] = $enc;
 HEAP32[$4>>2] = $xDel;
 $5 = HEAP32[$0>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 $7 = HEAP32[$1>>2]|0;
 $8 = HEAP32[$2>>2]|0;
 $9 = HEAP8[$3>>0]|0;
 $10 = HEAP32[$4>>2]|0;
 $11 = (_sqlite3VdbeMemSetStr($6,$7,$8,$9,$10)|0);
 $12 = ($11|0)==(18);
 if (!($12)) {
  STACKTOP = sp;return;
 }
 $13 = HEAP32[$0>>2]|0;
 _sqlite3_result_error_toobig($13);
 STACKTOP = sp;return;
}
function _invokeValueDestructor($p,$xDel,$pCtx) {
 $p = $p|0;
 $xDel = $xDel|0;
 $pCtx = $pCtx|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $2 = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $xDel;
 HEAP32[$2>>2] = $pCtx;
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)==(0|0);
 $5 = HEAP32[$1>>2]|0;
 $6 = ($5|0)==((-1)|0);
 $or$cond = $4 | $6;
 if (!($or$cond)) {
  $7 = HEAP32[$1>>2]|0;
  $8 = HEAP32[$0>>2]|0;
  FUNCTION_TABLE_vi[$7 & 255]($8);
 }
 $9 = HEAP32[$2>>2]|0;
 $10 = ($9|0)!=(0|0);
 if (!($10)) {
  STACKTOP = sp;return 18;
 }
 $11 = HEAP32[$2>>2]|0;
 _sqlite3_result_error_toobig($11);
 STACKTOP = sp;return 18;
}
function _sqlite3VdbeMemSetDouble($pMem,$val) {
 $pMem = $pMem|0;
 $val = +$val;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0.0, $4 = 0, $5 = 0, $6 = 0.0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp;
 HEAP32[$0>>2] = $pMem;
 HEAPF64[$1>>3] = $val;
 $2 = HEAP32[$0>>2]|0;
 _sqlite3VdbeMemSetNull($2);
 $3 = +HEAPF64[$1>>3];
 $4 = (_sqlite3IsNaN($3)|0);
 $5 = ($4|0)!=(0);
 if ($5) {
  STACKTOP = sp;return;
 }
 $6 = +HEAPF64[$1>>3];
 $7 = HEAP32[$0>>2]|0;
 HEAPF64[$7>>3] = $6;
 $8 = HEAP32[$0>>2]|0;
 $9 = ((($8)) + 8|0);
 HEAP16[$9>>1] = 8;
 STACKTOP = sp;return;
}
function _sqlite3VdbeMemSetStr($pMem,$z,$n,$enc,$xDel) {
 $pMem = $pMem|0;
 $z = $z|0;
 $n = $n|0;
 $enc = $enc|0;
 $xDel = $xDel|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $flags = 0;
 var $iLimit = 0, $nAlloc = 0, $nByte = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $3 = sp + 16|0;
 $4 = sp + 34|0;
 $5 = sp + 12|0;
 $nByte = sp + 8|0;
 $iLimit = sp + 4|0;
 $flags = sp + 32|0;
 $nAlloc = sp;
 HEAP32[$1>>2] = $pMem;
 HEAP32[$2>>2] = $z;
 HEAP32[$3>>2] = $n;
 HEAP8[$4>>0] = $enc;
 HEAP32[$5>>2] = $xDel;
 $6 = HEAP32[$3>>2]|0;
 HEAP32[$nByte>>2] = $6;
 HEAP16[$flags>>1] = 0;
 $7 = HEAP32[$2>>2]|0;
 $8 = ($7|0)!=(0|0);
 $9 = HEAP32[$1>>2]|0;
 if (!($8)) {
  _sqlite3VdbeMemSetNull($9);
  HEAP32[$0>>2] = 0;
  $138 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($138|0);
 }
 $10 = ((($9)) + 32|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ($11|0)!=(0|0);
 if ($12) {
  $13 = HEAP32[$1>>2]|0;
  $14 = ((($13)) + 32|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = ((($15)) + 96|0);
  $17 = HEAP32[$16>>2]|0;
  HEAP32[$iLimit>>2] = $17;
 } else {
  HEAP32[$iLimit>>2] = 1000000000;
 }
 $18 = HEAP8[$4>>0]|0;
 $19 = $18&255;
 $20 = ($19|0)==(0);
 $21 = $20 ? 16 : 2;
 $22 = $21&65535;
 HEAP16[$flags>>1] = $22;
 $23 = HEAP32[$nByte>>2]|0;
 $24 = ($23|0)<(0);
 if ($24) {
  $25 = HEAP8[$4>>0]|0;
  $26 = $25&255;
  $27 = ($26|0)==(1);
  L11: do {
   if ($27) {
    $28 = HEAP32[$2>>2]|0;
    $29 = (_sqlite3Strlen30($28)|0);
    HEAP32[$nByte>>2] = $29;
    $30 = HEAP32[$nByte>>2]|0;
    $31 = HEAP32[$iLimit>>2]|0;
    $32 = ($30|0)>($31|0);
    if ($32) {
     $33 = HEAP32[$iLimit>>2]|0;
     $34 = (($33) + 1)|0;
     HEAP32[$nByte>>2] = $34;
    }
   } else {
    HEAP32[$nByte>>2] = 0;
    while(1) {
     $35 = HEAP32[$nByte>>2]|0;
     $36 = HEAP32[$iLimit>>2]|0;
     $37 = ($35|0)<=($36|0);
     if (!($37)) {
      break L11;
     }
     $38 = HEAP32[$nByte>>2]|0;
     $39 = HEAP32[$2>>2]|0;
     $40 = (($39) + ($38)|0);
     $41 = HEAP8[$40>>0]|0;
     $42 = $41 << 24 >> 24;
     $43 = HEAP32[$nByte>>2]|0;
     $44 = (($43) + 1)|0;
     $45 = HEAP32[$2>>2]|0;
     $46 = (($45) + ($44)|0);
     $47 = HEAP8[$46>>0]|0;
     $48 = $47 << 24 >> 24;
     $49 = $42 | $48;
     $50 = ($49|0)!=(0);
     if (!($50)) {
      break L11;
     }
     $51 = HEAP32[$nByte>>2]|0;
     $52 = (($51) + 2)|0;
     HEAP32[$nByte>>2] = $52;
    }
   }
  } while(0);
  $53 = HEAP16[$flags>>1]|0;
  $54 = $53&65535;
  $55 = $54 | 512;
  $56 = $55&65535;
  HEAP16[$flags>>1] = $56;
 }
 $57 = HEAP32[$5>>2]|0;
 $58 = ($57|0)==((-1)|0);
 do {
  if ($58) {
   $59 = HEAP32[$nByte>>2]|0;
   HEAP32[$nAlloc>>2] = $59;
   $60 = HEAP16[$flags>>1]|0;
   $61 = $60&65535;
   $62 = $61 & 512;
   $63 = ($62|0)!=(0);
   if ($63) {
    $64 = HEAP8[$4>>0]|0;
    $65 = $64&255;
    $66 = ($65|0)==(1);
    $67 = $66 ? 1 : 2;
    $68 = HEAP32[$nAlloc>>2]|0;
    $69 = (($68) + ($67))|0;
    HEAP32[$nAlloc>>2] = $69;
   }
   $70 = HEAP32[$nByte>>2]|0;
   $71 = HEAP32[$iLimit>>2]|0;
   $72 = ($70|0)>($71|0);
   if ($72) {
    HEAP32[$0>>2] = 18;
    $138 = HEAP32[$0>>2]|0;
    STACKTOP = sp;return ($138|0);
   }
   $73 = HEAP32[$1>>2]|0;
   $74 = HEAP32[$nAlloc>>2]|0;
   $75 = ($74|0)>(32);
   $76 = HEAP32[$nAlloc>>2]|0;
   $77 = $75 ? $76 : 32;
   $78 = (_sqlite3VdbeMemClearAndResize($73,$77)|0);
   $79 = ($78|0)!=(0);
   if (!($79)) {
    $80 = HEAP32[$1>>2]|0;
    $81 = ((($80)) + 16|0);
    $82 = HEAP32[$81>>2]|0;
    $83 = HEAP32[$2>>2]|0;
    $84 = HEAP32[$nAlloc>>2]|0;
    _memcpy(($82|0),($83|0),($84|0))|0;
    break;
   }
   HEAP32[$0>>2] = 7;
   $138 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($138|0);
  } else {
   $85 = HEAP32[$5>>2]|0;
   $86 = ($85|0)==(170|0);
   $87 = HEAP32[$1>>2]|0;
   _sqlite3VdbeMemRelease($87);
   $88 = HEAP32[$2>>2]|0;
   $89 = HEAP32[$1>>2]|0;
   $90 = ((($89)) + 16|0);
   HEAP32[$90>>2] = $88;
   if ($86) {
    $91 = HEAP32[$1>>2]|0;
    $92 = ((($91)) + 20|0);
    HEAP32[$92>>2] = $88;
    $93 = HEAP32[$1>>2]|0;
    $94 = ((($93)) + 32|0);
    $95 = HEAP32[$94>>2]|0;
    $96 = HEAP32[$1>>2]|0;
    $97 = ((($96)) + 20|0);
    $98 = HEAP32[$97>>2]|0;
    $99 = (_sqlite3DbMallocSize($95,$98)|0);
    $100 = HEAP32[$1>>2]|0;
    $101 = ((($100)) + 24|0);
    HEAP32[$101>>2] = $99;
    break;
   } else {
    $102 = HEAP32[$5>>2]|0;
    $103 = HEAP32[$1>>2]|0;
    $104 = ((($103)) + 36|0);
    HEAP32[$104>>2] = $102;
    $105 = HEAP32[$5>>2]|0;
    $106 = ($105|0)==(0|0);
    $107 = $106 ? 2048 : 1024;
    $108 = HEAP16[$flags>>1]|0;
    $109 = $108&65535;
    $110 = $109 | $107;
    $111 = $110&65535;
    HEAP16[$flags>>1] = $111;
    break;
   }
  }
 } while(0);
 $112 = HEAP32[$nByte>>2]|0;
 $113 = HEAP32[$1>>2]|0;
 $114 = ((($113)) + 12|0);
 HEAP32[$114>>2] = $112;
 $115 = HEAP16[$flags>>1]|0;
 $116 = HEAP32[$1>>2]|0;
 $117 = ((($116)) + 8|0);
 HEAP16[$117>>1] = $115;
 $118 = HEAP8[$4>>0]|0;
 $119 = $118&255;
 $120 = ($119|0)==(0);
 $121 = HEAP8[$4>>0]|0;
 $122 = $121&255;
 $123 = $120 ? 1 : $122;
 $124 = $123&255;
 $125 = HEAP32[$1>>2]|0;
 $126 = ((($125)) + 10|0);
 HEAP8[$126>>0] = $124;
 $127 = HEAP32[$1>>2]|0;
 $128 = ((($127)) + 10|0);
 $129 = HEAP8[$128>>0]|0;
 $130 = $129&255;
 $131 = ($130|0)!=(1);
 if ($131) {
  $132 = HEAP32[$1>>2]|0;
  $133 = (_sqlite3VdbeMemHandleBom($132)|0);
  $134 = ($133|0)!=(0);
  if ($134) {
   HEAP32[$0>>2] = 7;
   $138 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($138|0);
  }
 }
 $135 = HEAP32[$nByte>>2]|0;
 $136 = HEAP32[$iLimit>>2]|0;
 $137 = ($135|0)>($136|0);
 if ($137) {
  HEAP32[$0>>2] = 18;
  $138 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($138|0);
 } else {
  HEAP32[$0>>2] = 0;
  $138 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($138|0);
 }
 return (0)|0;
}
function _sqlite3VdbeMemSetInt64($pMem,$0,$1) {
 $pMem = $pMem|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $2 = sp + 8|0;
 $3 = sp;
 HEAP32[$2>>2] = $pMem;
 $4 = $3;
 $5 = $4;
 HEAP32[$5>>2] = $0;
 $6 = (($4) + 4)|0;
 $7 = $6;
 HEAP32[$7>>2] = $1;
 $8 = HEAP32[$2>>2]|0;
 $9 = ((($8)) + 8|0);
 $10 = HEAP16[$9>>1]|0;
 $11 = $10&65535;
 $12 = $11 & 9312;
 $13 = ($12|0)!=(0);
 if ($13) {
  $14 = HEAP32[$2>>2]|0;
  $15 = $3;
  $16 = $15;
  $17 = HEAP32[$16>>2]|0;
  $18 = (($15) + 4)|0;
  $19 = $18;
  $20 = HEAP32[$19>>2]|0;
  _vdbeReleaseAndSetInt64($14,$17,$20);
  STACKTOP = sp;return;
 } else {
  $21 = $3;
  $22 = $21;
  $23 = HEAP32[$22>>2]|0;
  $24 = (($21) + 4)|0;
  $25 = $24;
  $26 = HEAP32[$25>>2]|0;
  $27 = HEAP32[$2>>2]|0;
  $28 = $27;
  $29 = $28;
  HEAP32[$29>>2] = $23;
  $30 = (($28) + 4)|0;
  $31 = $30;
  HEAP32[$31>>2] = $26;
  $32 = HEAP32[$2>>2]|0;
  $33 = ((($32)) + 8|0);
  HEAP16[$33>>1] = 4;
  STACKTOP = sp;return;
 }
}
function _sqlite3VdbeMemSetNull($pMem) {
 $pMem = $pMem|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $pMem;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 8|0);
 $3 = HEAP16[$2>>1]|0;
 $4 = $3&65535;
 $5 = $4 & 9312;
 $6 = ($5|0)!=(0);
 $7 = HEAP32[$0>>2]|0;
 if ($6) {
  _vdbeMemClearExternAndSetNull($7);
  STACKTOP = sp;return;
 } else {
  $8 = ((($7)) + 8|0);
  HEAP16[$8>>1] = 1;
  STACKTOP = sp;return;
 }
}
function _sqlite3VdbeMemCopy($pTo,$pFrom) {
 $pTo = $pTo|0;
 $pFrom = $pFrom|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $rc = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $pTo;
 HEAP32[$1>>2] = $pFrom;
 HEAP32[$rc>>2] = 0;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 8|0);
 $4 = HEAP16[$3>>1]|0;
 $5 = $4&65535;
 $6 = $5 & 9312;
 $7 = ($6|0)!=(0);
 if ($7) {
  $8 = HEAP32[$0>>2]|0;
  _vdbeMemClearExternAndSetNull($8);
 }
 $9 = HEAP32[$0>>2]|0;
 $10 = HEAP32[$1>>2]|0;
 ;HEAP32[$9>>2]=HEAP32[$10>>2]|0;HEAP32[$9+4>>2]=HEAP32[$10+4>>2]|0;HEAP32[$9+8>>2]=HEAP32[$10+8>>2]|0;HEAP32[$9+12>>2]=HEAP32[$10+12>>2]|0;HEAP32[$9+16>>2]=HEAP32[$10+16>>2]|0;
 $11 = HEAP32[$0>>2]|0;
 $12 = ((($11)) + 8|0);
 $13 = HEAP16[$12>>1]|0;
 $14 = $13&65535;
 $15 = $14 & -1025;
 $16 = $15&65535;
 HEAP16[$12>>1] = $16;
 $17 = HEAP32[$0>>2]|0;
 $18 = ((($17)) + 8|0);
 $19 = HEAP16[$18>>1]|0;
 $20 = $19&65535;
 $21 = $20 & 18;
 $22 = ($21|0)!=(0);
 if (!($22)) {
  $37 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 $23 = HEAP32[$1>>2]|0;
 $24 = ((($23)) + 8|0);
 $25 = HEAP16[$24>>1]|0;
 $26 = $25&65535;
 $27 = $26 & 2048;
 $28 = (0)==($27|0);
 if (!($28)) {
  $37 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 $29 = HEAP32[$0>>2]|0;
 $30 = ((($29)) + 8|0);
 $31 = HEAP16[$30>>1]|0;
 $32 = $31&65535;
 $33 = $32 | 4096;
 $34 = $33&65535;
 HEAP16[$30>>1] = $34;
 $35 = HEAP32[$0>>2]|0;
 $36 = (_sqlite3VdbeMemMakeWriteable($35)|0);
 HEAP32[$rc>>2] = $36;
 $37 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($37|0);
}
function _sqlite3VdbeMemSetZeroBlob($pMem,$n) {
 $pMem = $pMem|0;
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $1 = sp;
 HEAP32[$0>>2] = $pMem;
 HEAP32[$1>>2] = $n;
 $2 = HEAP32[$0>>2]|0;
 _sqlite3VdbeMemRelease($2);
 $3 = HEAP32[$0>>2]|0;
 $4 = ((($3)) + 8|0);
 HEAP16[$4>>1] = 16400;
 $5 = HEAP32[$0>>2]|0;
 $6 = ((($5)) + 12|0);
 HEAP32[$6>>2] = 0;
 $7 = HEAP32[$1>>2]|0;
 $8 = ($7|0)<(0);
 if ($8) {
  HEAP32[$1>>2] = 0;
 }
 $9 = HEAP32[$1>>2]|0;
 $10 = HEAP32[$0>>2]|0;
 HEAP32[$10>>2] = $9;
 $11 = HEAP32[$0>>2]|0;
 $12 = ((($11)) + 10|0);
 HEAP8[$12>>0] = 1;
 $13 = HEAP32[$0>>2]|0;
 $14 = ((($13)) + 16|0);
 HEAP32[$14>>2] = 0;
 STACKTOP = sp;return;
}
function _sqlite3ErrStr($rc) {
 $rc = $rc|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $cond = 0, $or$cond = 0, $zErr = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $zErr = sp;
 HEAP32[$0>>2] = $rc;
 HEAP32[$zErr>>2] = 43378;
 $1 = HEAP32[$0>>2]|0;
 $cond = ($1|0)==(516);
 if ($cond) {
  HEAP32[$zErr>>2] = 43392;
 } else {
  $2 = HEAP32[$0>>2]|0;
  $3 = $2 & 255;
  HEAP32[$0>>2] = $3;
  $4 = HEAP32[$0>>2]|0;
  $5 = ($4|0)>=(0);
  $6 = HEAP32[$0>>2]|0;
  $7 = ($6|0)<(27);
  $or$cond = $5 & $7;
  if ($or$cond) {
   $8 = HEAP32[$0>>2]|0;
   $9 = (6240 + ($8<<2)|0);
   $10 = HEAP32[$9>>2]|0;
   $11 = ($10|0)!=(0|0);
   if ($11) {
    $12 = HEAP32[$0>>2]|0;
    $13 = (6240 + ($12<<2)|0);
    $14 = HEAP32[$13>>2]|0;
    HEAP32[$zErr>>2] = $14;
   }
  }
 }
 $15 = HEAP32[$zErr>>2]|0;
 STACKTOP = sp;return ($15|0);
}
function _sqlite3OomFault($db) {
 $db = $db|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp;
 HEAP32[$0>>2] = $db;
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 69|0);
 $3 = HEAP8[$2>>0]|0;
 $4 = $3&255;
 $5 = ($4|0)==(0);
 if (!($5)) {
  STACKTOP = sp;return;
 }
 $6 = HEAP32[$0>>2]|0;
 $7 = ((($6)) + 70|0);
 $8 = HEAP8[$7>>0]|0;
 $9 = $8&255;
 $10 = ($9|0)==(0);
 if (!($10)) {
  STACKTOP = sp;return;
 }
 $11 = HEAP32[$0>>2]|0;
 $12 = ((($11)) + 69|0);
 HEAP8[$12>>0] = 1;
 $13 = HEAP32[$0>>2]|0;
 $14 = ((($13)) + 168|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)>(0);
 if ($16) {
  $17 = HEAP32[$0>>2]|0;
  $18 = ((($17)) + 248|0);
  HEAP32[$18>>2] = 1;
 }
 $19 = HEAP32[$0>>2]|0;
 $20 = ((($19)) + 256|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = (($21) + 1)|0;
 HEAP32[$20>>2] = $22;
 STACKTOP = sp;return;
}
function _vdbeSafetyNotNull($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $vararg_buffer = sp;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  _sqlite3_log(21,43338,$vararg_buffer);
  HEAP32[$0>>2] = 1;
  $6 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($6|0);
 } else {
  $4 = HEAP32[$1>>2]|0;
  $5 = (_vdbeSafety($4)|0);
  HEAP32[$0>>2] = $5;
  $6 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($6|0);
 }
 return (0)|0;
}
function _sqlite3Step($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0;
 var $96 = 0, $97 = 0, $98 = 0, $99 = 0, $db = 0, $or$cond = 0, $or$cond3 = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 12|0;
 $1 = sp + 8|0;
 $db = sp + 4|0;
 $rc = sp;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 20|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)!=(770837923);
 if ($5) {
  $6 = HEAP32[$1>>2]|0;
  (_sqlite3_reset($6)|0);
 }
 $7 = HEAP32[$1>>2]|0;
 $8 = HEAP32[$7>>2]|0;
 HEAP32[$db>>2] = $8;
 $9 = HEAP32[$db>>2]|0;
 $10 = ((($9)) + 69|0);
 $11 = HEAP8[$10>>0]|0;
 $12 = ($11<<24>>24)!=(0);
 $13 = HEAP32[$1>>2]|0;
 if ($12) {
  $14 = ((($13)) + 40|0);
  HEAP32[$14>>2] = 7;
  HEAP32[$0>>2] = 7;
  $163 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($163|0);
 }
 $15 = ((($13)) + 36|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)<=(0);
 if ($17) {
  $18 = HEAP32[$1>>2]|0;
  $19 = ((($18)) + 144|0);
  $20 = HEAP16[$19>>1]|0;
  $21 = $20 & 1;
  $22 = $21&65535;
  $23 = ($22|0)!=(0);
  if ($23) {
   $24 = HEAP32[$1>>2]|0;
   $25 = ((($24)) + 40|0);
   HEAP32[$25>>2] = 17;
   HEAP32[$rc>>2] = 1;
  } else {
   label = 8;
  }
 } else {
  label = 8;
 }
 if ((label|0) == 8) {
  $26 = HEAP32[$1>>2]|0;
  $27 = ((($26)) + 36|0);
  $28 = HEAP32[$27>>2]|0;
  $29 = ($28|0)<(0);
  if ($29) {
   $30 = HEAP32[$db>>2]|0;
   $31 = ((($30)) + 156|0);
   $32 = HEAP32[$31>>2]|0;
   $33 = ($32|0)==(0);
   if ($33) {
    $34 = HEAP32[$db>>2]|0;
    $35 = ((($34)) + 248|0);
    HEAP32[$35>>2] = 0;
   }
   $36 = HEAP32[$db>>2]|0;
   $37 = ((($36)) + 192|0);
   $38 = HEAP32[$37>>2]|0;
   $39 = ($38|0)!=(0|0);
   if ($39) {
    label = 13;
   } else {
    $40 = HEAP32[$db>>2]|0;
    $41 = ((($40)) + 76|0);
    $42 = HEAP8[$41>>0]|0;
    $43 = $42&255;
    $44 = $43 & 2;
    $45 = ($44|0)!=(0);
    if ($45) {
     label = 13;
    }
   }
   if ((label|0) == 13) {
    $46 = HEAP32[$db>>2]|0;
    $47 = ((($46)) + 148|0);
    $48 = ((($47)) + 5|0);
    $49 = HEAP8[$48>>0]|0;
    $50 = ($49<<24>>24)!=(0);
    if (!($50)) {
     $51 = HEAP32[$1>>2]|0;
     $52 = ((($51)) + 176|0);
     $53 = HEAP32[$52>>2]|0;
     $54 = ($53|0)!=(0|0);
     if ($54) {
      $55 = HEAP32[$db>>2]|0;
      $56 = HEAP32[$55>>2]|0;
      $57 = HEAP32[$1>>2]|0;
      $58 = ((($57)) + 128|0);
      (_sqlite3OsCurrentTimeInt64($56,$58)|0);
     }
    }
   }
   $59 = HEAP32[$db>>2]|0;
   $60 = ((($59)) + 156|0);
   $61 = HEAP32[$60>>2]|0;
   $62 = (($61) + 1)|0;
   HEAP32[$60>>2] = $62;
   $63 = HEAP32[$1>>2]|0;
   $64 = ((($63)) + 144|0);
   $65 = HEAP16[$64>>1]|0;
   $66 = ($65&65535) >>> 7;
   $67 = $66 & 1;
   $68 = $67&65535;
   $69 = ($68|0)==(0);
   if ($69) {
    $70 = HEAP32[$db>>2]|0;
    $71 = ((($70)) + 164|0);
    $72 = HEAP32[$71>>2]|0;
    $73 = (($72) + 1)|0;
    HEAP32[$71>>2] = $73;
   }
   $74 = HEAP32[$1>>2]|0;
   $75 = ((($74)) + 144|0);
   $76 = HEAP16[$75>>1]|0;
   $77 = ($76&65535) >>> 8;
   $78 = $77 & 1;
   $79 = $78&65535;
   $80 = ($79|0)!=(0);
   if ($80) {
    $81 = HEAP32[$db>>2]|0;
    $82 = ((($81)) + 160|0);
    $83 = HEAP32[$82>>2]|0;
    $84 = (($83) + 1)|0;
    HEAP32[$82>>2] = $84;
   }
   $85 = HEAP32[$1>>2]|0;
   $86 = ((($85)) + 36|0);
   HEAP32[$86>>2] = 0;
  }
  $87 = HEAP32[$1>>2]|0;
  $88 = ((($87)) + 144|0);
  $89 = HEAP16[$88>>1]|0;
  $90 = ($89&65535) >>> 2;
  $91 = $90 & 3;
  $92 = $91&65535;
  $93 = ($92|0)!=(0);
  if ($93) {
   $94 = HEAP32[$1>>2]|0;
   $95 = (_sqlite3VdbeList($94)|0);
   HEAP32[$rc>>2] = $95;
  } else {
   $96 = HEAP32[$db>>2]|0;
   $97 = ((($96)) + 168|0);
   $98 = HEAP32[$97>>2]|0;
   $99 = (($98) + 1)|0;
   HEAP32[$97>>2] = $99;
   $100 = HEAP32[$1>>2]|0;
   $101 = (_sqlite3VdbeExec($100)|0);
   HEAP32[$rc>>2] = $101;
   $102 = HEAP32[$db>>2]|0;
   $103 = ((($102)) + 168|0);
   $104 = HEAP32[$103>>2]|0;
   $105 = (($104) + -1)|0;
   HEAP32[$103>>2] = $105;
  }
  $106 = HEAP32[$rc>>2]|0;
  $107 = ($106|0)!=(100);
  if ($107) {
   $108 = HEAP32[$1>>2]|0;
   $109 = ((($108)) + 128|0);
   $110 = $109;
   $111 = $110;
   $112 = HEAP32[$111>>2]|0;
   $113 = (($110) + 4)|0;
   $114 = $113;
   $115 = HEAP32[$114>>2]|0;
   $116 = ($115|0)>(0);
   $117 = ($112>>>0)>(0);
   $118 = ($115|0)==(0);
   $119 = $118 & $117;
   $120 = $116 | $119;
   if ($120) {
    $121 = HEAP32[$db>>2]|0;
    $122 = HEAP32[$1>>2]|0;
    _invokeProfileCallback($121,$122);
   }
  }
  $123 = HEAP32[$rc>>2]|0;
  $124 = ($123|0)==(101);
  if ($124) {
   $125 = HEAP32[$db>>2]|0;
   $126 = (_doWalCallbacks($125)|0);
   $127 = HEAP32[$1>>2]|0;
   $128 = ((($127)) + 40|0);
   HEAP32[$128>>2] = $126;
   $129 = HEAP32[$1>>2]|0;
   $130 = ((($129)) + 40|0);
   $131 = HEAP32[$130>>2]|0;
   $132 = ($131|0)!=(0);
   if ($132) {
    HEAP32[$rc>>2] = 1;
   }
  }
  $133 = HEAP32[$rc>>2]|0;
  $134 = HEAP32[$db>>2]|0;
  $135 = ((($134)) + 52|0);
  HEAP32[$135>>2] = $133;
  $136 = HEAP32[$1>>2]|0;
  $137 = HEAP32[$136>>2]|0;
  $138 = HEAP32[$1>>2]|0;
  $139 = ((($138)) + 40|0);
  $140 = HEAP32[$139>>2]|0;
  $141 = (_sqlite3ApiExit($137,$140)|0);
  $142 = (7)==($141|0);
  if ($142) {
   $143 = HEAP32[$1>>2]|0;
   $144 = ((($143)) + 40|0);
   HEAP32[$144>>2] = 7;
  }
 }
 $145 = HEAP32[$1>>2]|0;
 $146 = ((($145)) + 144|0);
 $147 = HEAP16[$146>>1]|0;
 $148 = ($147&65535) >>> 9;
 $149 = $148 & 1;
 $150 = $149&65535;
 $151 = ($150|0)!=(0);
 $152 = HEAP32[$rc>>2]|0;
 $153 = ($152|0)!=(100);
 $or$cond = $151 & $153;
 $154 = HEAP32[$rc>>2]|0;
 $155 = ($154|0)!=(101);
 $or$cond3 = $or$cond & $155;
 if ($or$cond3) {
  $156 = HEAP32[$1>>2]|0;
  $157 = (_sqlite3VdbeTransferError($156)|0);
  HEAP32[$rc>>2] = $157;
 }
 $158 = HEAP32[$rc>>2]|0;
 $159 = HEAP32[$db>>2]|0;
 $160 = ((($159)) + 56|0);
 $161 = HEAP32[$160>>2]|0;
 $162 = $158 & $161;
 HEAP32[$0>>2] = $162;
 $163 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($163|0);
}
function _sqlite3Reprepare($p) {
 $p = $p|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $db = 0, $pNew = 0, $rc = 0, $zSql = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $rc = sp + 12|0;
 $pNew = sp + 8|0;
 $zSql = sp + 4|0;
 $db = sp;
 HEAP32[$1>>2] = $p;
 $2 = HEAP32[$1>>2]|0;
 $3 = (_sqlite3_sql($2)|0);
 HEAP32[$zSql>>2] = $3;
 $4 = HEAP32[$1>>2]|0;
 $5 = (_sqlite3VdbeDb($4)|0);
 HEAP32[$db>>2] = $5;
 $6 = HEAP32[$db>>2]|0;
 $7 = HEAP32[$zSql>>2]|0;
 $8 = HEAP32[$1>>2]|0;
 $9 = (_sqlite3LockAndPrepare($6,$7,-1,0,$8,$pNew,0)|0);
 HEAP32[$rc>>2] = $9;
 $10 = HEAP32[$rc>>2]|0;
 $11 = ($10|0)!=(0);
 if (!($11)) {
  $16 = HEAP32[$pNew>>2]|0;
  $17 = HEAP32[$1>>2]|0;
  _sqlite3VdbeSwap($16,$17);
  $18 = HEAP32[$pNew>>2]|0;
  $19 = HEAP32[$1>>2]|0;
  (_sqlite3TransferBindings($18,$19)|0);
  $20 = HEAP32[$pNew>>2]|0;
  _sqlite3VdbeResetStepResult($20);
  $21 = HEAP32[$pNew>>2]|0;
  (_sqlite3VdbeFinalize($21)|0);
  HEAP32[$0>>2] = 0;
  $22 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($22|0);
 }
 $12 = HEAP32[$rc>>2]|0;
 $13 = ($12|0)==(7);
 if ($13) {
  $14 = HEAP32[$db>>2]|0;
  _sqlite3OomFault($14);
 }
 $15 = HEAP32[$rc>>2]|0;
 HEAP32[$0>>2] = $15;
 $22 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($22|0);
}
function _sqlite3DbStrDup($db,$z) {
 $db = $db|0;
 $z = $z|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $n = 0, $zNew = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $zNew = sp + 4|0;
 $n = sp;
 HEAP32[$1>>2] = $db;
 HEAP32[$2>>2] = $z;
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0|0);
 if ($4) {
  HEAP32[$0>>2] = 0;
  $19 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($19|0);
 }
 $5 = HEAP32[$2>>2]|0;
 $6 = (_sqlite3Strlen30($5)|0);
 $7 = (($6) + 1)|0;
 HEAP32[$n>>2] = $7;
 $8 = HEAP32[$1>>2]|0;
 $9 = HEAP32[$n>>2]|0;
 $10 = ($9|0)<(0);
 $11 = $10 << 31 >> 31;
 $12 = (_sqlite3DbMallocRaw($8,$9,$11)|0);
 HEAP32[$zNew>>2] = $12;
 $13 = HEAP32[$zNew>>2]|0;
 $14 = ($13|0)!=(0|0);
 if ($14) {
  $15 = HEAP32[$zNew>>2]|0;
  $16 = HEAP32[$2>>2]|0;
  $17 = HEAP32[$n>>2]|0;
  _memcpy(($15|0),($16|0),($17|0))|0;
 }
 $18 = HEAP32[$zNew>>2]|0;
 HEAP32[$0>>2] = $18;
 $19 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($19|0);
}
function _createAggContext($p,$nByte) {
 $p = $p|0;
 $nByte = $nByte|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $pMem = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 8|0;
 $1 = sp + 4|0;
 $pMem = sp;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $nByte;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 8|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[$pMem>>2] = $4;
 $5 = HEAP32[$1>>2]|0;
 $6 = ($5|0)<=(0);
 $7 = HEAP32[$pMem>>2]|0;
 if ($6) {
  _sqlite3VdbeMemSetNull($7);
  $8 = HEAP32[$pMem>>2]|0;
  $9 = ((($8)) + 16|0);
  HEAP32[$9>>2] = 0;
 } else {
  $10 = HEAP32[$1>>2]|0;
  (_sqlite3VdbeMemClearAndResize($7,$10)|0);
  $11 = HEAP32[$pMem>>2]|0;
  $12 = ((($11)) + 8|0);
  HEAP16[$12>>1] = 8192;
  $13 = HEAP32[$0>>2]|0;
  $14 = ((($13)) + 4|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = HEAP32[$pMem>>2]|0;
  HEAP32[$16>>2] = $15;
  $17 = HEAP32[$pMem>>2]|0;
  $18 = ((($17)) + 16|0);
  $19 = HEAP32[$18>>2]|0;
  $20 = ($19|0)!=(0|0);
  if ($20) {
   $21 = HEAP32[$pMem>>2]|0;
   $22 = ((($21)) + 16|0);
   $23 = HEAP32[$22>>2]|0;
   $24 = HEAP32[$1>>2]|0;
   _memset(($23|0),0,($24|0))|0;
  }
 }
 $25 = HEAP32[$pMem>>2]|0;
 $26 = ((($25)) + 16|0);
 $27 = HEAP32[$26>>2]|0;
 STACKTOP = sp;return ($27|0);
}
function _sqlite3DbMallocZero($db,$0,$1) {
 $db = $db|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $2 = sp + 12|0;
 $3 = sp;
 $p = sp + 8|0;
 HEAP32[$2>>2] = $db;
 $4 = $3;
 $5 = $4;
 HEAP32[$5>>2] = $0;
 $6 = (($4) + 4)|0;
 $7 = $6;
 HEAP32[$7>>2] = $1;
 $8 = HEAP32[$2>>2]|0;
 $9 = $3;
 $10 = $9;
 $11 = HEAP32[$10>>2]|0;
 $12 = (($9) + 4)|0;
 $13 = $12;
 $14 = HEAP32[$13>>2]|0;
 $15 = (_sqlite3DbMallocRaw($8,$11,$14)|0);
 HEAP32[$p>>2] = $15;
 $16 = HEAP32[$p>>2]|0;
 $17 = ($16|0)!=(0|0);
 if (!($17)) {
  $25 = HEAP32[$p>>2]|0;
  STACKTOP = sp;return ($25|0);
 }
 $18 = HEAP32[$p>>2]|0;
 $19 = $3;
 $20 = $19;
 $21 = HEAP32[$20>>2]|0;
 $22 = (($19) + 4)|0;
 $23 = $22;
 $24 = HEAP32[$23>>2]|0;
 _memset(($18|0),0,($21|0))|0;
 $25 = HEAP32[$p>>2]|0;
 STACKTOP = sp;return ($25|0);
}
function _columnMem($pStmt,$i) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $pOut = 0, $pVm = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $pVm = sp + 4|0;
 $pOut = sp;
 HEAP32[$1>>2] = $pStmt;
 HEAP32[$2>>2] = $i;
 $3 = HEAP32[$1>>2]|0;
 HEAP32[$pVm>>2] = $3;
 $4 = HEAP32[$pVm>>2]|0;
 $5 = ($4|0)==(0|0);
 if ($5) {
  $6 = (_columnNullValue()|0);
  HEAP32[$0>>2] = $6;
  $28 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($28|0);
 }
 $7 = HEAP32[$pVm>>2]|0;
 $8 = ((($7)) + 104|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)!=(0|0);
 if ($10) {
  $11 = HEAP32[$2>>2]|0;
  $12 = HEAP32[$pVm>>2]|0;
  $13 = ((($12)) + 140|0);
  $14 = HEAP16[$13>>1]|0;
  $15 = $14&65535;
  $16 = ($11|0)<($15|0);
  $17 = HEAP32[$2>>2]|0;
  $18 = ($17|0)>=(0);
  $or$cond = $16 & $18;
  if ($or$cond) {
   $19 = HEAP32[$2>>2]|0;
   $20 = HEAP32[$pVm>>2]|0;
   $21 = ((($20)) + 104|0);
   $22 = HEAP32[$21>>2]|0;
   $23 = (($22) + (($19*40)|0)|0);
   HEAP32[$pOut>>2] = $23;
  } else {
   label = 6;
  }
 } else {
  label = 6;
 }
 if ((label|0) == 6) {
  $24 = HEAP32[$pVm>>2]|0;
  $25 = HEAP32[$24>>2]|0;
  _sqlite3Error($25,25);
  $26 = (_columnNullValue()|0);
  HEAP32[$pOut>>2] = $26;
 }
 $27 = HEAP32[$pOut>>2]|0;
 HEAP32[$0>>2] = $27;
 $28 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($28|0);
}
function _columnMallocFailure($pStmt) {
 $pStmt = $pStmt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $0 = sp + 4|0;
 $p = sp;
 HEAP32[$0>>2] = $pStmt;
 $1 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $1;
 $2 = HEAP32[$p>>2]|0;
 $3 = ($2|0)!=(0|0);
 if (!($3)) {
  STACKTOP = sp;return;
 }
 $4 = HEAP32[$p>>2]|0;
 $5 = HEAP32[$4>>2]|0;
 $6 = HEAP32[$p>>2]|0;
 $7 = ((($6)) + 40|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (_sqlite3ApiExit($5,$8)|0);
 $10 = HEAP32[$p>>2]|0;
 $11 = ((($10)) + 40|0);
 HEAP32[$11>>2] = $9;
 STACKTOP = sp;return;
}
function _columnName($pStmt,$N,$xFunc,$useType) {
 $pStmt = $pStmt|0;
 $N = $N|0;
 $xFunc = $xFunc|0;
 $useType = $useType|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $db = 0, $n = 0, $or$cond = 0, $p = 0, $ret = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $3 = sp + 16|0;
 $ret = sp + 12|0;
 $p = sp + 8|0;
 $n = sp + 4|0;
 $db = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $N;
 HEAP32[$2>>2] = $xFunc;
 HEAP32[$3>>2] = $useType;
 HEAP32[$ret>>2] = 0;
 $4 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $4;
 $5 = HEAP32[$p>>2]|0;
 $6 = HEAP32[$5>>2]|0;
 HEAP32[$db>>2] = $6;
 $7 = HEAP32[$0>>2]|0;
 $8 = (_sqlite3_column_count($7)|0);
 HEAP32[$n>>2] = $8;
 $9 = HEAP32[$1>>2]|0;
 $10 = HEAP32[$n>>2]|0;
 $11 = ($9|0)<($10|0);
 $12 = HEAP32[$1>>2]|0;
 $13 = ($12|0)>=(0);
 $or$cond = $11 & $13;
 if (!($or$cond)) {
  $31 = HEAP32[$ret>>2]|0;
  STACKTOP = sp;return ($31|0);
 }
 $14 = HEAP32[$3>>2]|0;
 $15 = HEAP32[$n>>2]|0;
 $16 = Math_imul($14, $15)|0;
 $17 = HEAP32[$1>>2]|0;
 $18 = (($17) + ($16))|0;
 HEAP32[$1>>2] = $18;
 $19 = HEAP32[$2>>2]|0;
 $20 = HEAP32[$1>>2]|0;
 $21 = HEAP32[$p>>2]|0;
 $22 = ((($21)) + 100|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = (($23) + (($20*40)|0)|0);
 $25 = (FUNCTION_TABLE_ii[$19 & 255]($24)|0);
 HEAP32[$ret>>2] = $25;
 $26 = HEAP32[$db>>2]|0;
 $27 = ((($26)) + 69|0);
 $28 = HEAP8[$27>>0]|0;
 $29 = ($28<<24>>24)!=(0);
 if (!($29)) {
  $31 = HEAP32[$ret>>2]|0;
  STACKTOP = sp;return ($31|0);
 }
 $30 = HEAP32[$db>>2]|0;
 _sqlite3OomClear($30);
 HEAP32[$ret>>2] = 0;
 $31 = HEAP32[$ret>>2]|0;
 STACKTOP = sp;return ($31|0);
}
function _bindText($pStmt,$i,$zData,$nData,$xDel,$encoding) {
 $pStmt = $pStmt|0;
 $i = $i|0;
 $zData = $zData|0;
 $nData = $nData|0;
 $xDel = $xDel|0;
 $encoding = $encoding|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $p = 0, $pVar = 0, $rc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0;
 $0 = sp + 28|0;
 $1 = sp + 24|0;
 $2 = sp + 20|0;
 $3 = sp + 16|0;
 $4 = sp + 12|0;
 $5 = sp + 32|0;
 $p = sp + 8|0;
 $pVar = sp + 4|0;
 $rc = sp;
 HEAP32[$0>>2] = $pStmt;
 HEAP32[$1>>2] = $i;
 HEAP32[$2>>2] = $zData;
 HEAP32[$3>>2] = $nData;
 HEAP32[$4>>2] = $xDel;
 HEAP8[$5>>0] = $encoding;
 $6 = HEAP32[$0>>2]|0;
 HEAP32[$p>>2] = $6;
 $7 = HEAP32[$p>>2]|0;
 $8 = HEAP32[$1>>2]|0;
 $9 = (_vdbeUnbind($7,$8)|0);
 HEAP32[$rc>>2] = $9;
 $10 = HEAP32[$rc>>2]|0;
 $11 = ($10|0)==(0);
 if (!($11)) {
  $45 = HEAP32[$4>>2]|0;
  $46 = ($45|0)!=(0|0);
  $47 = HEAP32[$4>>2]|0;
  $48 = ($47|0)!=((-1)|0);
  $or$cond = $46 & $48;
  if (!($or$cond)) {
   $51 = HEAP32[$rc>>2]|0;
   STACKTOP = sp;return ($51|0);
  }
  $49 = HEAP32[$4>>2]|0;
  $50 = HEAP32[$2>>2]|0;
  FUNCTION_TABLE_vi[$49 & 255]($50);
  $51 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($51|0);
 }
 $12 = HEAP32[$2>>2]|0;
 $13 = ($12|0)!=(0|0);
 if (!($13)) {
  $51 = HEAP32[$rc>>2]|0;
  STACKTOP = sp;return ($51|0);
 }
 $14 = HEAP32[$1>>2]|0;
 $15 = (($14) - 1)|0;
 $16 = HEAP32[$p>>2]|0;
 $17 = ((($16)) + 116|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = (($18) + (($15*40)|0)|0);
 HEAP32[$pVar>>2] = $19;
 $20 = HEAP32[$pVar>>2]|0;
 $21 = HEAP32[$2>>2]|0;
 $22 = HEAP32[$3>>2]|0;
 $23 = HEAP8[$5>>0]|0;
 $24 = HEAP32[$4>>2]|0;
 $25 = (_sqlite3VdbeMemSetStr($20,$21,$22,$23,$24)|0);
 HEAP32[$rc>>2] = $25;
 $26 = HEAP32[$rc>>2]|0;
 $27 = ($26|0)==(0);
 if ($27) {
  $28 = HEAP8[$5>>0]|0;
  $29 = $28&255;
  $30 = ($29|0)!=(0);
  if ($30) {
   $31 = HEAP32[$pVar>>2]|0;
   $32 = HEAP32[$p>>2]|0;
   $33 = HEAP32[$32>>2]|0;
   $34 = ((($33)) + 66|0);
   $35 = HEAP8[$34>>0]|0;
   $36 = $35&255;
   $37 = (_sqlite3VdbeChangeEncoding($31,$36)|0);
   HEAP32[$rc>>2] = $37;
  }
 }
 $38 = HEAP32[$p>>2]|0;
 $39 = HEAP32[$38>>2]|0;
 $40 = HEAP32[$rc>>2]|0;
 _sqlite3Error($39,$40);
 $41 = HEAP32[$p>>2]|0;
 $42 = HEAP32[$41>>2]|0;
 $43 = HEAP32[$rc>>2]|0;
 $44 = (_sqlite3ApiExit($42,$43)|0);
 HEAP32[$rc>>2] = $44;
 $51 = HEAP32[$rc>>2]|0;
 STACKTOP = sp;return ($51|0);
}
function _vdbeUnbind($p,$i) {
 $p = $p|0;
 $i = $i|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $7 = 0, $8 = 0, $9 = 0, $pVar = 0, $vararg_buffer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $vararg_buffer = sp;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $2 = sp + 8|0;
 $pVar = sp + 4|0;
 HEAP32[$1>>2] = $p;
 HEAP32[$2>>2] = $i;
 $3 = HEAP32[$1>>2]|0;
 $4 = (_vdbeSafetyNotNull($3)|0);
 $5 = ($4|0)!=(0);
 if ($5) {
  $6 = (_sqlite3MisuseError(76348)|0);
  HEAP32[$0>>2] = $6;
  $68 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($68|0);
 }
 $7 = HEAP32[$1>>2]|0;
 $8 = ((($7)) + 20|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)!=(770837923);
 if (!($10)) {
  $11 = HEAP32[$1>>2]|0;
  $12 = ((($11)) + 36|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = ($13|0)>=(0);
  if (!($14)) {
   $21 = HEAP32[$2>>2]|0;
   $22 = ($21|0)<(1);
   if (!($22)) {
    $23 = HEAP32[$2>>2]|0;
    $24 = HEAP32[$1>>2]|0;
    $25 = ((($24)) + 16|0);
    $26 = HEAP16[$25>>1]|0;
    $27 = $26 << 16 >> 16;
    $28 = ($23|0)>($27|0);
    if (!($28)) {
     $31 = HEAP32[$2>>2]|0;
     $32 = (($31) + -1)|0;
     HEAP32[$2>>2] = $32;
     $33 = HEAP32[$2>>2]|0;
     $34 = HEAP32[$1>>2]|0;
     $35 = ((($34)) + 116|0);
     $36 = HEAP32[$35>>2]|0;
     $37 = (($36) + (($33*40)|0)|0);
     HEAP32[$pVar>>2] = $37;
     $38 = HEAP32[$pVar>>2]|0;
     _sqlite3VdbeMemRelease($38);
     $39 = HEAP32[$pVar>>2]|0;
     $40 = ((($39)) + 8|0);
     HEAP16[$40>>1] = 1;
     $41 = HEAP32[$1>>2]|0;
     $42 = HEAP32[$41>>2]|0;
     _sqlite3Error($42,0);
     $43 = HEAP32[$1>>2]|0;
     $44 = ((($43)) + 144|0);
     $45 = HEAP16[$44>>1]|0;
     $46 = ($45&65535) >>> 9;
     $47 = $46 & 1;
     $48 = $47&65535;
     $49 = ($48|0)!=(0);
     do {
      if ($49) {
       $50 = HEAP32[$2>>2]|0;
       $51 = ($50|0)<(32);
       if ($51) {
        $52 = HEAP32[$1>>2]|0;
        $53 = ((($52)) + 196|0);
        $54 = HEAP32[$53>>2]|0;
        $55 = HEAP32[$2>>2]|0;
        $56 = 1 << $55;
        $57 = $54 & $56;
        $58 = ($57|0)!=(0);
        if (!($58)) {
         label = 12;
        }
       } else {
        label = 12;
       }
       if ((label|0) == 12) {
        $59 = HEAP32[$1>>2]|0;
        $60 = ((($59)) + 196|0);
        $61 = HEAP32[$60>>2]|0;
        $62 = ($61|0)==(-1);
        if (!($62)) {
         break;
        }
       }
       $63 = HEAP32[$1>>2]|0;
       $64 = ((($63)) + 144|0);
       $65 = HEAP16[$64>>1]|0;
       $66 = $65 & -2;
       $67 = $66 | 1;
       HEAP16[$64>>1] = $67;
      }
     } while(0);
     HEAP32[$0>>2] = 0;
     $68 = HEAP32[$0>>2]|0;
     STACKTOP = sp;return ($68|0);
    }
   }
   $29 = HEAP32[$1>>2]|0;
   $30 = HEAP32[$29>>2]|0;
   _sqlite3Error($30,25);
   HEAP32[$0>>2] = 25;
   $68 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($68|0);
  }
 }
 $15 = HEAP32[$1>>2]|0;
 $16 = HEAP32[$15>>2]|0;
 _sqlite3Error($16,21);
 $17 = HEAP32[$1>>2]|0;
 $18 = ((($17)) + 176|0);
 $19 = HEAP32[$18>>2]|0;
 HEAP32[$vararg_buffer>>2] = $19;
 _sqlite3_log(21,39833,$vararg_buffer);
 $20 = (_sqlite3MisuseError(76356)|0);
 HEAP32[$0>>2] = $20;
 $68 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($68|0);
}
function _sqlite3VdbeParameterIndex($p,$zName,$nName) {
 $p = $p|0;
 $zName = $zName|0;
 $nName = $nName|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i = 0, $z = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $2 = sp + 12|0;
 $3 = sp + 8|0;
 $i = sp + 4|0;
 $z = sp;
 HEAP32[$1>>2] = $p;
 HEAP32[$2>>2] = $zName;
 HEAP32[$3>>2] = $nName;
 $4 = HEAP32[$1>>2]|0;
 $5 = ($4|0)==(0|0);
 if ($5) {
  HEAP32[$0>>2] = 0;
  $37 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($37|0);
 }
 $6 = HEAP32[$2>>2]|0;
 $7 = ($6|0)!=(0|0);
 L5: do {
  if ($7) {
   HEAP32[$i>>2] = 0;
   while(1) {
    $8 = HEAP32[$i>>2]|0;
    $9 = HEAP32[$1>>2]|0;
    $10 = ((($9)) + 18|0);
    $11 = HEAP16[$10>>1]|0;
    $12 = $11 << 16 >> 16;
    $13 = ($8|0)<($12|0);
    if (!($13)) {
     break L5;
    }
    $14 = HEAP32[$i>>2]|0;
    $15 = HEAP32[$1>>2]|0;
    $16 = ((($15)) + 120|0);
    $17 = HEAP32[$16>>2]|0;
    $18 = (($17) + ($14<<2)|0);
    $19 = HEAP32[$18>>2]|0;
    HEAP32[$z>>2] = $19;
    $20 = HEAP32[$z>>2]|0;
    $21 = ($20|0)!=(0|0);
    if ($21) {
     $22 = HEAP32[$z>>2]|0;
     $23 = HEAP32[$2>>2]|0;
     $24 = HEAP32[$3>>2]|0;
     $25 = (_strncmp($22,$23,$24)|0);
     $26 = ($25|0)==(0);
     if ($26) {
      $27 = HEAP32[$3>>2]|0;
      $28 = HEAP32[$z>>2]|0;
      $29 = (($28) + ($27)|0);
      $30 = HEAP8[$29>>0]|0;
      $31 = $30 << 24 >> 24;
      $32 = ($31|0)==(0);
      if ($32) {
       break;
      }
     }
    }
    $35 = HEAP32[$i>>2]|0;
    $36 = (($35) + 1)|0;
    HEAP32[$i>>2] = $36;
   }
   $33 = HEAP32[$i>>2]|0;
   $34 = (($33) + 1)|0;
   HEAP32[$0>>2] = $34;
   $37 = HEAP32[$0>>2]|0;
   STACKTOP = sp;return ($37|0);
  }
 } while(0);
 HEAP32[$0>>2] = 0;
 $37 = HEAP32[$0>>2]|0;
 STACKTOP = sp;return ($37|0);
}
function _sqlite3TransferBindings($pFromStmt,$pToStmt) {
 $pFromStmt = $pFromStmt|0;
 $pToStmt = $pToStmt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $i = 0, $pFrom = 0, $pTo = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 16|0;
 $1 = sp + 12|0;
 $pFrom = sp + 8|0;
 $pTo = sp + 4|0;
 $i = sp;
 HEAP32[$0>>2] = $pFromStmt;
 HEAP32[$1>>2] = $pToStmt;
 $2 = HEAP32[$0>>2]|0;
 HEAP32[$pFrom>>2] = $2;
 $3 = HEAP32[$1>>2]|0;
 HEAP32[$pTo>>2] = $3;
 HEAP32[$i>>2] = 0;
 while(1) {
  $4 = HEAP32[$i>>2]|0;
  $5 = HEAP32[$pFrom>>2]|0;
  $6 = ((($5)) + 16|0);
  $7 = HEAP16[$6>>1]|0;
  $8 = $7 << 16 >> 16;
  $9 = ($4|0)<($8|0);
  if (!($9)) {
   break;
  }
  $10 = HEAP32[$i>>2]|0;
  $11 = HEAP32[$pTo>>2]|0;
  $12 = ((($11)) + 116|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = (($13) + (($10*40)|0)|0);
  $15 = HEAP32[$i>>2]|0;
  $16 = HEAP32[$pFrom>>2]|0;
  $17 = ((($16)) + 116|0);
  $18 = HEAP32[$17>>2]|0;
  $19 = (($18) + (($15*40)|0)|0);
  _sqlite3VdbeMemMove($14,$19);
  $20 = HEAP32[$i>>2]|0;
  $21 = (($20) + 1)|0;
  HEAP32[$i>>2] = $21;
 }
 STACKTOP = sp;return 0;
}
function _sqlite3VdbeExpandSql($p,$zRawSql) {
 $p = $p|0;
 $zRawSql = $zRawSql|0;
 var $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0.0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0;
 var $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $db = 0, $enc = 0, $i = 0, $idx = 0, $n = 0, $nOut = 0, $nOut1 = 0, $nToken = 0, $nextIndex = 0, $out = 0, $pVar = 0, $utf8 = 0, $vararg_buffer = 0, $vararg_buffer1 = 0;
 var $vararg_buffer11 = 0, $vararg_buffer4 = 0, $vararg_buffer8 = 0, $vararg_ptr7 = 0, $zBase = 0, $zStart = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 256|0;
 $vararg_buffer11 = sp + 72|0;
 $vararg_buffer8 = sp + 64|0;
 $vararg_buffer4 = sp + 56|0;
 $vararg_buffer1 = sp + 48|0;
 $vararg_buffer = sp + 40|0;
 $0 = sp + 148|0;
 $1 = sp + 144|0;
 $db = sp + 140|0;
 $idx = sp + 136|0;
 $nextIndex = sp + 132|0;
 $n = sp + 128|0;
 $nToken = sp + 124|0;
 $i = sp + 120|0;
 $pVar = sp + 116|0;
 $out = sp + 88|0;
 $utf8 = sp;
 $zBase = sp + 156|0;
 $zStart = sp + 84|0;
 $nOut = sp + 80|0;
 $enc = sp + 152|0;
 $nOut1 = sp + 76|0;
 HEAP32[$0>>2] = $p;
 HEAP32[$1>>2] = $zRawSql;
 HEAP32[$idx>>2] = 0;
 HEAP32[$nextIndex>>2] = 1;
 $2 = HEAP32[$0>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 HEAP32[$db>>2] = $3;
 $4 = HEAP32[$db>>2]|0;
 $5 = ((($4)) + 96|0);
 $6 = HEAP32[$5>>2]|0;
 _sqlite3StrAccumInit($out,0,$zBase,100,$6);
 $7 = HEAP32[$db>>2]|0;
 $8 = ((($7)) + 168|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)>(1);
 L1: do {
  if ($10) {
   while(1) {
    $11 = HEAP32[$1>>2]|0;
    $12 = HEAP8[$11>>0]|0;
    $13 = ($12<<24>>24)!=(0);
    if (!($13)) {
     break L1;
    }
    $14 = HEAP32[$1>>2]|0;
    HEAP32[$zStart>>2] = $14;
    while(1) {
     $15 = HEAP32[$1>>2]|0;
     $16 = ((($15)) + 1|0);
     HEAP32[$1>>2] = $16;
     $17 = HEAP8[$15>>0]|0;
     $18 = $17 << 24 >> 24;
     $19 = ($18|0)!=(10);
     if (!($19)) {
      break;
     }
     $20 = HEAP32[$1>>2]|0;
     $21 = HEAP8[$20>>0]|0;
     $22 = $21 << 24 >> 24;
     $23 = ($22|0)!=(0);
     if (!($23)) {
      break;
     }
    }
    _sqlite3StrAccumAppend($out,39799,3);
    $24 = HEAP32[$zStart>>2]|0;
    $25 = HEAP32[$1>>2]|0;
    $26 = HEAP32[$zStart>>2]|0;
    $27 = $25;
    $28 = $26;
    $29 = (($27) - ($28))|0;
    _sqlite3StrAccumAppend($out,$24,$29);
   }
  } else {
   $30 = HEAP32[$0>>2]|0;
   $31 = ((($30)) + 16|0);
   $32 = HEAP16[$31>>1]|0;
   $33 = $32 << 16 >> 16;
   $34 = ($33|0)==(0);
   if ($34) {
    $35 = HEAP32[$1>>2]|0;
    $36 = HEAP32[$1>>2]|0;
    $37 = (_sqlite3Strlen30($36)|0);
    _sqlite3StrAccumAppend($out,$35,$37);
    break;
   }
   while(1) {
    $38 = HEAP32[$1>>2]|0;
    $39 = HEAP8[$38>>0]|0;
    $40 = ($39<<24>>24)!=(0);
    if (!($40)) {
     break L1;
    }
    $41 = HEAP32[$1>>2]|0;
    $42 = (_findNextHostParameter($41,$nToken)|0);
    HEAP32[$n>>2] = $42;
    $43 = HEAP32[$1>>2]|0;
    $44 = HEAP32[$n>>2]|0;
    _sqlite3StrAccumAppend($out,$43,$44);
    $45 = HEAP32[$n>>2]|0;
    $46 = HEAP32[$1>>2]|0;
    $47 = (($46) + ($45)|0);
    HEAP32[$1>>2] = $47;
    $48 = HEAP32[$nToken>>2]|0;
    $49 = ($48|0)==(0);
    if ($49) {
     break L1;
    }
    $50 = HEAP32[$1>>2]|0;
    $51 = HEAP8[$50>>0]|0;
    $52 = $51 << 24 >> 24;
    $53 = ($52|0)==(63);
    do {
     if ($53) {
      $54 = HEAP32[$nToken>>2]|0;
      $55 = ($54|0)>(1);
      if ($55) {
       $56 = HEAP32[$1>>2]|0;
       $57 = ((($56)) + 1|0);
       (_sqlite3GetInt32($57,$idx)|0);
       break;
      } else {
       $58 = HEAP32[$nextIndex>>2]|0;
       HEAP32[$idx>>2] = $58;
       break;
      }
     } else {
      $59 = HEAP32[$0>>2]|0;
      $60 = HEAP32[$1>>2]|0;
      $61 = HEAP32[$nToken>>2]|0;
      $62 = (_sqlite3VdbeParameterIndex($59,$60,$61)|0);
      HEAP32[$idx>>2] = $62;
     }
    } while(0);
    $63 = HEAP32[$nToken>>2]|0;
    $64 = HEAP32[$1>>2]|0;
    $65 = (($64) + ($63)|0);
    HEAP32[$1>>2] = $65;
    $66 = HEAP32[$idx>>2]|0;
    $67 = (($66) + 1)|0;
    HEAP32[$nextIndex>>2] = $67;
    $68 = HEAP32[$idx>>2]|0;
    $69 = (($68) - 1)|0;
    $70 = HEAP32[$0>>2]|0;
    $71 = ((($70)) + 116|0);
    $72 = HEAP32[$71>>2]|0;
    $73 = (($72) + (($69*40)|0)|0);
    HEAP32[$pVar>>2] = $73;
    $74 = HEAP32[$pVar>>2]|0;
    $75 = ((($74)) + 8|0);
    $76 = HEAP16[$75>>1]|0;
    $77 = $76&65535;
    $78 = $77 & 1;
    $79 = ($78|0)!=(0);
    if ($79) {
     _sqlite3StrAccumAppend($out,39691,4);
     continue;
    }
    $80 = HEAP32[$pVar>>2]|0;
    $81 = ((($80)) + 8|0);
    $82 = HEAP16[$81>>1]|0;
    $83 = $82&65535;
    $84 = $83 & 4;
    $85 = ($84|0)!=(0);
    $86 = HEAP32[$pVar>>2]|0;
    if ($85) {
     $87 = $86;
     $88 = $87;
     $89 = HEAP32[$88>>2]|0;
     $90 = (($87) + 4)|0;
     $91 = $90;
     $92 = HEAP32[$91>>2]|0;
     $93 = $vararg_buffer;
     $94 = $93;
     HEAP32[$94>>2] = $89;
     $95 = (($93) + 4)|0;
     $96 = $95;
     HEAP32[$96>>2] = $92;
     _sqlite3XPrintf($out,28266,$vararg_buffer);
     continue;
    }
    $97 = ((($86)) + 8|0);
    $98 = HEAP16[$97>>1]|0;
    $99 = $98&65535;
    $100 = $99 & 8;
    $101 = ($100|0)!=(0);
    $102 = HEAP32[$pVar>>2]|0;
    if ($101) {
     $103 = +HEAPF64[$102>>3];
     HEAPF64[$vararg_buffer1>>3] = $103;
     _sqlite3XPrintf($out,28271,$vararg_buffer1);
     continue;
    }
    $104 = ((($102)) + 8|0);
    $105 = HEAP16[$104>>1]|0;
    $106 = $105&65535;
    $107 = $106 & 2;
    $108 = ($107|0)!=(0);
    if ($108) {
     $109 = HEAP32[$db>>2]|0;
     $110 = ((($109)) + 66|0);
     $111 = HEAP8[$110>>0]|0;
     HEAP8[$enc>>0] = $111;
     $112 = HEAP8[$enc>>0]|0;
     $113 = $112&255;
     $114 = ($113|0)!=(1);
     if ($114) {
      dest=$utf8; stop=dest+40|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
      $115 = HEAP32[$db>>2]|0;
      $116 = ((($utf8)) + 32|0);
      HEAP32[$116>>2] = $115;
      $117 = HEAP32[$pVar>>2]|0;
      $118 = ((($117)) + 16|0);
      $119 = HEAP32[$118>>2]|0;
      $120 = HEAP32[$pVar>>2]|0;
      $121 = ((($120)) + 12|0);
      $122 = HEAP32[$121>>2]|0;
      $123 = HEAP8[$enc>>0]|0;
      (_sqlite3VdbeMemSetStr($utf8,$119,$122,$123,0)|0);
      $124 = (_sqlite3VdbeChangeEncoding($utf8,1)|0);
      $125 = (7)==($124|0);
      if ($125) {
       $126 = ((($out)) + 24|0);
       HEAP8[$126>>0] = 1;
       $127 = ((($out)) + 16|0);
       HEAP32[$127>>2] = 0;
      }
      HEAP32[$pVar>>2] = $utf8;
     }
     $128 = HEAP32[$pVar>>2]|0;
     $129 = ((($128)) + 12|0);
     $130 = HEAP32[$129>>2]|0;
     HEAP32[$nOut>>2] = $130;
     $131 = HEAP32[$nOut>>2]|0;
     $132 = HEAP32[$pVar>>2]|0;
     $133 = ((($132)) + 16|0);
     $134 = HEAP32[$133>>2]|0;
     HEAP32[$vararg_buffer4>>2] = $131;
     $vararg_ptr7 = ((($vararg_buffer4)) + 4|0);
     HEAP32[$vararg_ptr7>>2] = $134;
     _sqlite3XPrintf($out,39803,$vararg_buffer4);
     $135 = HEAP8[$enc>>0]|0;
     $136 = $135&255;
     $137 = ($136|0)!=(1);
     if (!($137)) {
      continue;
     }
     _sqlite3VdbeMemRelease($utf8);
     continue;
    } else {
     $138 = HEAP32[$pVar>>2]|0;
     $139 = ((($138)) + 8|0);
     $140 = HEAP16[$139>>1]|0;
     $141 = $140&65535;
     $142 = $141 & 16384;
     $143 = ($142|0)!=(0);
     if ($143) {
      $144 = HEAP32[$pVar>>2]|0;
      $145 = HEAP32[$144>>2]|0;
      HEAP32[$vararg_buffer8>>2] = $145;
      _sqlite3XPrintf($out,39810,$vararg_buffer8);
      continue;
     }
     _sqlite3StrAccumAppend($out,39823,2);
     $146 = HEAP32[$pVar>>2]|0;
     $147 = ((($146)) + 12|0);
     $148 = HEAP32[$147>>2]|0;
     HEAP32[$nOut1>>2] = $148;
     HEAP32[$i>>2] = 0;
     while(1) {
      $149 = HEAP32[$i>>2]|0;
      $150 = HEAP32[$nOut1>>2]|0;
      $151 = ($149|0)<($150|0);
      if (!($151)) {
       break;
      }
      $152 = HEAP32[$i>>2]|0;
      $153 = HEAP32[$pVar>>2]|0;
      $154 = ((($153)) + 16|0);
      $155 = HEAP32[$154>>2]|0;
      $156 = (($155) + ($152)|0);
      $157 = HEAP8[$156>>0]|0;
      $158 = $157 << 24 >> 24;
      $159 = $158 & 255;
      HEAP32[$vararg_buffer11>>2] = $159;
      _sqlite3XPrintf($out,39826,$vararg_buffer11);
      $160 = HEAP32[$i>>2]|0;
      $161 = (($160) + 1)|0;
      HEAP32[$i>>2] = $161;
     }
     _sqlite3StrAccumAppend($out,39831,1);
     continue;
    }
   }
  }
 } while(0);
 $162 = ((($out)) + 24|0);
 $163 = HEAP8[$162>>0]|0;
 $164 = ($163<<24>>24)!=(0);
 if (!($164)) {
  $165 = (_sqlite3StrAccumFinish($out)|0);
  STACKTOP = sp;return ($165|0);
 }
 _sqlite3StrAccumReset($out);
 $165 = (_sqlite3StrAccumFinish($out)|0);
 STACKTOP = sp;return ($165|0);
}
function _applyNumericAffinity($pRec,$bTryForInt) {
 $pRec = $pRec|0;
 $bTryForInt = $bTryForInt|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $enc = 0, $iValue = 0, $rValue = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $0 = sp + 20|0;
 $1 = sp + 16|0;
 $rValue = sp + 8|0;
 $iValue = sp;
 $enc = sp + 24|0;
 HEAP32[$0>>2] = $pRec;
 HEAP32[$1>>2] = $bTryForInt;
 $2 = HEAP32[$0>>2]|0;
 $3 = ((($2)) + 10|0);
 $4 = HEAP8[$3>>0]|0;
 HEAP8[$enc>>0] = $4;
 $5 = HEAP32[$0>>2]|0;
 $6 = ((($5)) + 16|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = HEAP32[$0>>2]|0;
 $9 = ((($8)) + 12|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = HEAP8[$enc>>0]|0;
 $12 = (_sqlite3AtoF($7,$rValue,$10,$11)|0);
 $13 = ($12|0)==(0);
 if ($13) {
  STACKTOP = sp;return;
 }
 $14 = HEAP32[$0>>2]|0;
 $15 = ((($14)) + 16|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = HEAP32[$0>>2]|0;
 $18 = ((($17)) + 12|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = HEAP8[$enc>>0]|0;
 $21 = (_sqlite3Atoi64($16,$iValue,$19,$20)|0);
 $22 = (0)==($21|0);
 if ($22) {
  $23 = $iValue;
  $24 = $23;
  $25 = HEAP32[$24>>2]|0;
  $26 = (($23) + 4)|0;
  $27 = $26;
  $28 = HEAP32[$27>>2]|0;
  $29 = HEAP32[$0>>2]|0;
  $30 = $29;
  $31 = $30;
  HEAP32[$31>>2] = $25;
  $32 = (($30) + 4)|0;
  $33 = $32;
  HEAP32[$33>>2] = $28;
  $34 = HEAP32[$0>>2]|0;
  $35 = ((($34)) + 8|0);
  $36 = HEAP16[$35>>1]|0;
  $37 = $36&65535;
  $38 = $37 | 4;
  $39 = $38&65535;
  HEAP16[$35>>1] = $39;
  STACKTOP = sp;return;
 }
 $40 = +HEAPF64[$rValue>>3];
 $41 = HEAP32[$0>>2]|0;
 HEAPF64[$41>>3] = $40;
 $42 = HEAP32[$0>>2]|0;
 $43 = ((($42)) + 8|0);
 $44 = HEAP16[$43>>1]|0;
 $45 = $44&65535;
 $46 = $45 | 8;
 $47 = $46&65535;
 HEAP16[$43>>1] = $47;
 $48 = HEAP32[$1>>2]|0;
 $49 = ($48|0)!=(0);
 if (!($49)) {
  STACKTOP = sp;return;
 }
 $50 = HEAP32[$0>>2]|0;
 _sqlite3VdbeIntegerAffinity($50);
 STACKTOP = sp;return;
}
function _sqlite3DbMallocRaw($db,$0,$1) {
 $db = $db|0;
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $2 = sp + 16|0;
 $3 = sp + 12|0;
 $4 = sp;
 $p = sp + 8|0;
 HEAP32[$3>>2] = $db;
 $5 = $4;
 $6 = $5;
 HEAP32[$6>>2] = $0;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $1;
 $9 = HEAP32[$3>>2]|0;
 $10 = ($9|0)!=(0|0);
 if ($10) {
  $11 = HEAP32[$3>>2]|0;
  $12 = $4;
  $13 = $12;
  $14 = HEAP32[$13>>2]|0;
  $15 = (($12) + 4)|0;
  $16 = $15;
  $17 = HEAP32[$16>>2]|0;
  $18 = (_sqlite3DbMallocRawNN($11,$14,$17)|0);
  HEAP32[$2>>2] = $18;
  $27 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($27|0);
 } else {
  $19 = $4;
  $20 = $19;
  $21 = HEAP32[$20>>2]|0;
  $22 = (($19) + 4)|0;
  $23 = $22;
  $24 = HEAP32[$23>>2]|0;
  $25 = (_sqlite3Malloc($21,$24)|0);
  HEAP32[$p>>2] = $25;
  $26 = HEAP32[$p>>2]|0;
  HEAP32[$2>>2] = $26;
  $27 = HEAP32[$2>>2]|0;
  STACKTOP = sp;return ($27|0);
 }
 return (0)|0;
}
function _sqlite3LocateTable($pParse,$flags,$zName,$zDbase) {
 $pParse = $pParse|0;
 $flags = $flags|0;
 $zName = $zName|0;
 $zDbase = $zDbase|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $p = 0, $pMod = 0, $vararg_buffer = 0, $vararg_buffer3 = 0, $vararg_ptr1 = 0, $vararg_ptr2 = 0, $vararg_ptr6 = 0, $zMsg = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $vararg_buffer3 = sp + 16|0;
 $vararg_buffer = sp;
 $0 = sp + 52|0;
 $1 = sp + 48|0;
 $2 = sp + 44|0;
 $3 = sp + 40|0;
 $4 = sp + 36|0;
 $p = sp + 32|0;
 $zMsg = sp + 28|0;
 $pMod = sp + 24|0;
 HEAP32[$1>>2] = $pParse;
 HEAP32[$2>>2] = $flags;
 HEAP32[$3>>2] = $zName;
 HEAP32[$4>>2] = $zDbase;
 $5 = HEAP32[$1>>2]|0;
 $6 = (_sqlite3ReadSchema($5)|0);
 $7 = (0)!=($6|0);
 if ($7) {
  HEAP32[$0>>2] = 0;
  $51 = HEAP32[$0>>2]|0;
  STACKTOP = sp;return ($51|0);
 }
 $8 = HEAP32[$1>>2]|0;
 $9 = HEAP32[$8>>2]|0;
 $10 = HEAP32[$3>>2]|0;
 $11 = HEAP32[$4>>2]|0;
 $12 = (_sqlite3FindTable($9,$10,$11)|0);
 HEAP32[$p>>2] = $12;
 $13 = HEAP32[$p>>2]|0;
 $14 = ($13|0)==(0|0);
 if ($14) {
  $15 = HEAP32[$2>>2]|0;
  $16 = $15 & 1;
  $17 = ($16|0)!=(0);
  $18 = $17 ? 39772 : 39785;
  HEAP32[$zMsg>>2] = $18;
  $19 = HEAP32[$1>>2]|0;
  $20 = HEAP32[$19>>2]|0;
  $21 = HEAP32[$4>>2]|0;
  $22 = (_sqlite3FindDbName($20,$21)|0);
  $23 = ($22|0)<(1);
  if ($23) {
   $24 = HEAP32[$1>>2]|0;
   $25 = HEAP32[$24>>2]|0;
   $26 = ((($25)) + 320|0);
   $27 = HEAP32[$3>>2]|0;
   $28 = (_sqlite3HashFind($26,$27)|0);
   HEAP32[$pMod>>2] = $28;
   $29 = HEAP32[$pMod>>2]|0;
   $30 = ($29|0)!=(0|0);
   if ($30) {
    $31 = HEAP32[$1>>2]|0;
    $32 = HEAP32[$pMod>>2]|0;
    $33 = (_sqlite3VtabEponymousTableInit($31,$32)|0);
    $34 = ($33|0)!=(0);
    if ($34) {
     $35 = HEAP32[$pMod>>2]|0;
     $36 = ((($35)) + 16|0);
     $37 = HEAP32[$36>>2]|0;
     HEAP32[$0>>2] = $37;
     $51 =